﻿-- -------------------------------------------------------------------------------------
-- Create database `saldodb` if this does not already exist
-- -------------------------------------------------------------------------------------
CREATE DATABASE IF NOT EXISTS `saldodb`;
-- -------------------------------------------------------------------------------------
-- Set `saldodb` as default schema (work environment)
-- -------------------------------------------------------------------------------------
USE `saldodb`;
-- -------------------------------------------------------------------------------------
-- Create table for all words and it's cross reference definitions
-- -------------------------------------------------------------------------------------
DROP TABLE IF EXISTS `saldodb`.`ordlista`;
CREATE TABLE `saldodb`.`ordlista` (
  `id` INTEGER(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ord` VARCHAR(128) NOT NULL DEFAULT '',
  `def` VARCHAR(128) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
)
ENGINE = MyISAM
CHARACTER SET utf8 COLLATE utf8_general_ci
COMMENT = 'derivat av SALDO 2.3 exkl. namn och uttryck';
-- -------------------------------------------------------------------------------------
-- Create export table with single column for import into preferred spell checker
-- -------------------------------------------------------------------------------------
DROP TABLE IF EXISTS `saldodb`.`spelling`;
CREATE TABLE `saldodb`.`spelling` (
  `ord` VARCHAR(128) NOT NULL DEFAULT '',
  PRIMARY KEY (`ord`)
)
ENGINE = MyISAM
CHARACTER SET utf8 COLLATE utf8_general_ci
COMMENT = 'exportable for spellcheckers';
-- -------------------------------------------------------------------------------------
-- Insert all words into main table `ordlista` (124,993 words)
-- -------------------------------------------------------------------------------------
INSERT INTO saldodb.ordlista(ord,def) VALUES
('a','1|bokstav'),
('A','1|initial'),
('a','2|ton'),
('à','1|per'),
('A3','1|pappersark'),
('A4','1|pappersark'),
('A5','1|pappersark'),
('aa','1|verk'),
('Aar','1|flod'),
('abakus','1|räkna'),
('abalone','1|havsöra'),
('abandon','1|otvungen'),
('Abba','1|popgrupp'),
('Abba','2|konservfabrik'),
('abbé','1|abbot'),
('abbedissa','1|kloster'),
('abborre','1|fisk'),
('abborre','1|fisk'),
('abborrfisk','1|abborrliknande'),
('abborrliknande','1|abborre'),
('abborrpinne','1|abborre'),
('abbot','1|föreståndare'),
('abbotlig','1|abbot'),
('abbotskap','1|abbot'),
('abbotskloster','1|kloster'),
('abbotsstav','1|stav'),
('abbotsstift','1|stift'),
('abbotsvärdighet','1|abbot'),
('abbreviation','1|abbreviera'),
('abbreviatur','1|abbreviera'),
('abbreviera','1|förkorta'),
('abbrevierande','1|abbreviera'),
('abbrevierbar','1|abbreviera'),
('abbrevierbarhet','1|abbrevierbar'),
('abbreviering','1|abbreviera'),
('abc','1|alfabet'),
('abc','2|grundkunskap'),
('abc-bok','1|bok'),
('abc-bok','2|bok'),
('Abchazien','1|Kaukasus'),
('abchazisk','1|Abchazien'),
('abderitisk','1|enfaldig'),
('abdikation','1|abdikera'),
('abdikationsakt','1|abdikation'),
('abdikationshot','1|hot'),
('abdikera','1|avgå'),
('abdikerande','1|abdikera'),
('abdikerbar','1|abdikera'),
('abdikerbarhet','1|abdikerbar'),
('abdikering','1|abdikera'),
('abdomen','1|bakkropp'),
('abdomen','2|buk'),
('abdominal','1|abdomen'),
('abducensnervsjukdom','1|nervsjukdom'),
('abducensnervskada','1|nervskada'),
('aber','1|hinder'),
('aberration','1|lins'),
('Abessinien','1|Etiopien'),
('abessinier','1|Abessinien'),
('abessinsk','1|Abessinien'),
('abessinska','1|abessinier'),
('abessiv','1|kasus'),
('abetalipoproteinemi','1|ämnesomsättningsrubbning'),
('ABF','1|bildningsförbund'),
('ABF','1|bildningsförbund'),
('abilitet','1|förmåga'),
('abiturient','1|elev'),
('abiturientexamen','1|studentexamen'),
('ablation','1|erosion'),
('ablativ','1|kasus'),
('ablativform','1|ablativ'),
('abnorm','1|onormal'),
('abnormalitet','1|avvikelse'),
('abnormitet','1|abnorm'),
('abolition','1|benådning'),
('abolitionism','1|avskaffa'),
('abolitionist','1|abolitionism'),
('abolitionistisk','1|abolitionism'),
('A-bomb','1|atombomb'),
('A-bomb','1|atombomb'),
('abominabel','1|avskyvärd'),
('abonnemang','1|abonnera'),
('abonnemangspris','1|pris'),
('abonnent','1|abonnera'),
('abonnera','1|beställa'),
('abonnerande','1|abonnera'),
('abonnerbar','1|abonnera'),
('abonnerbarhet','1|abonnerbar'),
('abonnering','1|abonnera'),
('aboriginer','1|folk'),
('aboriginer','1|folk'),
('aboriginsk','1|aboriginer'),
('abort','1|bort'),
('abortera','1|abort'),
('abortera','2|abortera'),
('aborterande','1|abortera'),
('aborterande','2|abortera'),
('aborterbar','1|abortera'),
('aborterbarhet','1|aborterbar'),
('abortering','1|abortera'),
('abortering','2|abortera'),
('abortfråga','1|fråga'),
('abortiv','1|abort'),
('abortiv','2|ofullgången'),
('abortmotstånd','1|abort'),
('abortmotståndare','1|abortmotstånd'),
('abortpiller','1|piller'),
('abortrådgivning','1|rådgivning'),
('abortrådgivning','2|inrättning'),
('aborträtt','1|rätt'),
('abortör','1|abort'),
('abradera','1|bryta_ned'),
('abradera','2|abradera'),
('abraderande','1|abradera'),
('abraderbar','1|abradera'),
('abraderbarhet','1|abraderbar'),
('abradering','1|abradera'),
('abrakadabra','1|nonsens'),
('abrasion','1|abradera'),
('abrovink','1|knep'),
('abrovink','1|knep'),
('abrupt','1|plötslig'),
('abrupthet','1|abrupt'),
('ABS-broms','1|bilbroms'),
('abscess','1|böld'),
('abscessbildning','1|abscess'),
('absens','1|medvetslös'),
('absensepilepsi','1|epilepsi'),
('absid','1|kyrka'),
('absint','1|likör'),
('abskissa','1|koordinatsystem'),
('absolut','1|total'),
('Absolut','1|vodka'),
('absolut','2|säker'),
('absolutbelopp','1|matematik'),
('absoluthet','1|absolut'),
('absolution','1|förlåta'),
('absolutism','1|envälde'),
('absolutism','2|nykterhet'),
('absolutist','1|absolutism'),
('absolutistisk','1|absolutism'),
('absolutistisk','2|absolutism'),
('absolutiv','1|kasus'),
('absolutivobjekt','1|objekt'),
('absolutivsubjekt','1|subjekt'),
('absolvera','1|avlägga'),
('absolverande','1|absolvera'),
('absolverbar','1|absolvera'),
('absolverbarhet','1|absolverbar'),
('absolvering','1|absolvera'),
('absorbator','1|solfångare'),
('absorber','1|absorbera'),
('absorbera','1|uppta'),
('absorbera','2|uppta'),
('absorberande','1|absorbera'),
('absorberande','2|absorbera'),
('absorberbar','1|absorbera'),
('absorberbar','2|absorbera'),
('absorberbarhet','1|absorberbar'),
('absorberbarhet','2|absorberbar'),
('absorbering','1|absorbera'),
('absorberingsförmåga','1|förmåga'),
('absorption','1|absorbera'),
('absorptionslinje','1|absorption'),
('abstinens','1|alkoholism'),
('abstinensbesvär','1|besvär'),
('abstinenssyndrom','1|abstinens'),
('abstrahera','1|abstrakt'),
('abstraherande','1|abstrahera'),
('abstraherbar','1|abstrahera'),
('abstraherbarhet','1|abstraherbar'),
('abstrahering','1|abstrahera'),
('abstrakt','1|konkret'),
('abstrakt','2|substantiv'),
('abstrakthet','1|abstrakt'),
('abstraktion','1|abstrakt'),
('abstraktionsförmåga','1|förmåga'),
('abstraktändelse','1|ändelse'),
('abstrus','1|oklar'),
('absurd','1|orimlig'),
('absurdhet','1|absurd'),
('absurdism','1|konstriktning'),
('absurdistisk','1|absurdism'),
('absurditet','1|absurd'),
('abundans','1|abundant'),
('abundant','1|överflöda'),
('abyssal','1|djup'),
('acanthamoebakeratit','1|parasitinfektion'),
('accedera','1|registrera'),
('accederande','1|accedera'),
('accederbar','1|accedera'),
('accederbarhet','1|accederbar'),
('accedering','1|accedera'),
('acceleration','1|accelerera'),
('accelerationsfält','1|påfart'),
('accelerationslag','1|lag'),
('accelerator','1|accelerera'),
('acceleratormaskin','1|maskin'),
('acceleratorsystem','1|system'),
('accelerera','1|öka'),
('accelerera','2|öka'),
('accelererande','1|accelerera'),
('accelererande','2|accelerera'),
('accelererbar','1|accelerera'),
('accelererbarhet','1|accelererbar'),
('accelerering','1|accelerera'),
('accent','1|betoning'),
('accent','2|uttal'),
('accent','3|framhäva'),
('accentbeteckning','1|beteckning'),
('accentförskjutning','1|förskjutning'),
('accenttecken','1|tecken'),
('accentuera','1|accent'),
('accentuera','2|accent'),
('accentuerande','1|accentuera'),
('accentuerande','2|accentuera'),
('accentuerbar','1|accentuera'),
('accentuerbarhet','1|accentuerbar'),
('accentuering','1|accentuera'),
('accentuering','2|accentuera'),
('accept','1|godkänna'),
('accept','2|accept'),
('acceptabel','1|acceptera'),
('acceptans','1|acceptera'),
('acceptant','1|accept'),
('acceptera','1|ja'),
('accepterande','1|acceptera'),
('accepterbar','1|acceptera'),
('accepterbarhet','1|accepterbar'),
('acceptering','1|acceptera'),
('acceptkredit','1|accept'),
('acceptpris','1|bostadsköp'),
('access','1|åtkomst'),
('accessa','1|access'),
('accessande','1|accessa'),
('accession','1|nyförvärv'),
('accession','2|anslutning'),
('accessionskatalog','1|katalog'),
('accessoarer','1|tillbehör'),
('accessorisk','1|bihang'),
('accesstid','1|access'),
('accidens','1|tillfällig'),
('accidenstryck','1|tryck'),
('accidentell','1|accidens'),
('accidentell','1|accidens'),
('accis','1|skatt'),
('accisfri','1|accis'),
('accispliktig','1|pliktig'),
('acerolakörsbär','1|körsbär'),
('acetaldehyd','1|lösningsmedel'),
('acetat','1|salt'),
('aceton','1|lösningsmedel'),
('acetylen','1|kolväte'),
('acetylengas','1|acetylen'),
('acetylenlampa','1|lampa'),
('acetylsalicylsyra','1|medicin'),
('aciditet','1|surhetsgrad'),
('acidos','1|pH-balans'),
('acinetobacterinfektion','1|bakterieinfektion'),
('acinärcellskarcinom','1|karcinom'),
('ack','1|klaga'),
('ackja','1|släde'),
('acklamation','1|bifall'),
('acklamationsval','1|val'),
('acklimatisation','1|acklimatisera'),
('acklimatisera','1|vänja'),
('acklimatiserande','1|acklimatisera'),
('acklimatiserbar','1|acklimatisera'),
('acklimatiserbarhet','1|acklimatiserbar'),
('acklimatisering','1|acklimatisera'),
('ackommodation','1|anpassa'),
('ackommodation','2|anpassning'),
('ackommodationsförmåga','1|förmåga'),
('ackommodationsväxel','1|växel'),
('ackommodera','1|ackommodation'),
('ackommodera','2|ackommodation'),
('ackommoderande','1|ackommodera'),
('ackommoderande','2|ackommodera'),
('ackommoderbar','1|ackommodera'),
('ackommoderbar','2|ackommodera'),
('ackommoderbarhet','1|ackommoderbar'),
('ackommoderbarhet','2|ackommoderbar'),
('ackommodering','1|ackommodera'),
('ackommodering','2|ackommodera'),
('ackompanjatör','1|ackompanjera'),
('ackompanjemang','1|ackompanjera'),
('ackompanjera','1|musik'),
('ackompanjera','2|tillsammans'),
('ackompanjerande','1|ackompanjera'),
('ackompanjerande','2|ackompanjera'),
('ackompanjerbar','1|ackompanjera'),
('ackompanjerbar','2|ackompanjera'),
('ackompanjerbarhet','1|ackompanjerbar'),
('ackompanjerbarhet','2|ackompanjerbar'),
('ackompanjering','1|ackompanjera'),
('ackord','1|musik'),
('ackord','2|beting'),
('ackord','3|överenskommelse'),
('ackordera','1|ackord'),
('ackorderande','1|ackordera'),
('ackorderbar','1|ackordera'),
('ackorderbarhet','1|ackorderbar'),
('ackordering','1|ackordera'),
('ackordgrepp','1|grepp'),
('ackordion','1|dragspel'),
('ackordlära','1|lära'),
('ackordsarbete','1|ackord'),
('ackordshets','1|hets'),
('ackordslön','1|lön'),
('ackordssumma','1|ackord'),
('ackordssättning','1|norm'),
('ackordssättning','1|norm'),
('ackreditera','1|fullmakt'),
('ackrediterande','1|ackreditera'),
('ackrediterbar','1|ackreditera'),
('ackrediterbarhet','1|ackrediterbar'),
('ackreditering','1|ackreditera'),
('ackumulation','1|ackumulera'),
('ackumulator','1|ackumulera'),
('ackumulera','1|samla_upp'),
('ackumulerande','1|ackumulera'),
('ackumulerbar','1|ackumulera'),
('ackumulerbarhet','1|ackumulerbar'),
('ackumulering','1|ackumulera'),
('ackurat','1|ackuratess'),
('ackurat','2|precis'),
('ackuratess','1|noggrannhet'),
('ackusativ','1|kasus'),
('ackusativ','2|ackusativ'),
('ackusativobjekt','1|objekt'),
('ackusativändelse','1|ändelse'),
('ackusatorisk','1|juridik'),
('ackuschör','1|läkare'),
('ackuschörska','1|barnmorska'),
('ackvirera','1|anskaffa'),
('ackvirerande','1|ackvirera'),
('ackvirerbar','1|ackvirera'),
('ackvirerbarhet','1|ackvirerbar'),
('ackvirering','1|ackvirera'),
('ackvisition','1|ackvirera'),
('ackvisitionskatalog','1|katalog'),
('ackvisitör','1|ackvirera'),
('actinobacillusinfektion','1|bakterieinfektion'),
('actinomycetalesinfektion','1|bakterieinfektion'),
('action','1|dramatisk'),
('actionfilm','1|film'),
('actionrulle','1|actionfilm'),
('actionstjärna','1|stjärna'),
('adagio','1|musik'),
('adagio','2|adagio'),
('adagiosats','1|sats'),
('Adam','2|människa'),
('adamantinom','1|tumör'),
('adamsdräkt','1|naken'),
('adamsäpple','1|struphuvud'),
('adaptation','1|adaption'),
('adaptation','2|adaption'),
('adapter','1|adaptera'),
('adaptera','1|anpassa'),
('adapterande','1|adaptera'),
('adapterbar','1|adaptera'),
('adapterbarhet','1|adapterbar'),
('adaptering','1|adaptera'),
('adaption','1|adaptera'),
('adaption','2|adaptera'),
('adaptiv','1|anpassa'),
('addend','1|tal'),
('addenda','1|tillägg'),
('addera','1|tillägga'),
('adderande','1|addera'),
('adderbar','1|addera'),
('adderbarhet','1|adderbar'),
('addering','1|addera'),
('addiktion','1|tillvänja'),
('addiktolog','1|beroende'),
('additament','1|tillägg'),
('addition','1|addera'),
('additionstecken','1|tecken'),
('additiv','1|addition'),
('additiv','2|tillsatsämne'),
('adduktion','1|rörelse'),
('adekvat','1|riktig'),
('adel','1|stånd'),
('adelsbrev','1|privilegium'),
('adelsdam','1|dam'),
('adelsgods','1|gods'),
('adelshem','1|hem'),
('adelshögfärd','1|högfärd'),
('adelskalender','1|förteckning'),
('adelskap','1|adel'),
('adelskrets','1|krets'),
('adelskultur','1|kultur'),
('adelsman','1|adel'),
('adelsmatrikel','1|adelskalender'),
('adelsmärke','1|kvalitet'),
('adelsprivilegium','1|privilegium'),
('adelssläkt','1|släkt'),
('adelsstånd','1|adel'),
('adelsätt','1|ätt'),
('Aden','1|stad'),
('adenit','1|inflammation'),
('adenofibrom','1|tumör'),
('adenoid','1|körtel'),
('adenoid','2|adenoid'),
('adenokarcinom','1|cancertumör'),
('adenolymfom','1|tumör'),
('adenom','1|tumör'),
('adenomyoepiteliom','1|tumör'),
('adenomyom','1|tumör'),
('adenophoreainfektion','1|parasitinfektion'),
('adenosarkom','1|tumör'),
('adenovirusinfektion','1|virusinfektion'),
('Adenviken','1|vik'),
('adept','1|lärjunge'),
('adessiv','1|kasus'),
('adhd','1|störning'),
('adhd','1|störning'),
('adhd-symtom','1|symtom'),
('adhd-symtom','1|symtom'),
('adherens','1|sammanväxning'),
('adhesion','1|vidhäftning'),
('adhesionskraft','1|adhesion'),
('adhesiv','1|adhesion'),
('adiabatisk','1|värmeutbyte'),
('adiafora','1|oväsentlighet'),
('adiaforistisk','1|kyrkostrid'),
('adidasgympasko','1|gympasko'),
('adipositas','1|fetma'),
('adjektiv','1|ordklass'),
('adjektivattribut','1|attribut'),
('adjektivfras','1|fras'),
('adjektivisk','1|adjektiv'),
('adjektivisk','1|adjektiv'),
('adjektivändelse','1|böjningsändelse'),
('adjungera','1|medlem'),
('adjungerande','1|adjungera'),
('adjungerbar','1|adjungera'),
('adjungerbarhet','1|adjungerbar'),
('adjungering','1|adjungera'),
('adjunkt','1|lärare'),
('adjunkt','2|kyrkoadjunkt'),
('adjunktion','1|adjungera'),
('adjunktur','1|adjunkt'),
('adjutant','1|medhjälpare'),
('adjö','1|lämna'),
('adjö','2|adjö'),
('adla','1|adel'),
('adlande','1|adla'),
('adlig','1|adel'),
('adlighet','1|adlig'),
('administration','1|administrera'),
('administrativ','1|administrera'),
('administrator','1|administratör'),
('administrator','1|administratör'),
('administratör','1|administrera'),
('administratörsstatus','1|status'),
('administrera','1|organisera'),
('administrerande','1|administrera'),
('administrerbar','1|administrera'),
('administrerbarhet','1|administrerbar'),
('administrering','1|administrera'),
('admonition','1|tillrättavisning'),
('adnexasjukdom','1|sjukdom'),
('adnexit','1|inflammation'),
('adobe','1|lersten'),
('adolescens','1|ungdom'),
('adonis','1|yngling'),
('adonis','2|våradonis'),
('adonisgestalt','1|gestalt'),
('adoptant','1|adoptera'),
('adoptera','1|anta'),
('adoptera','2|anta'),
('adopterande','1|adoptera'),
('adopterbar','1|adoptera'),
('adopterbarhet','1|adopterbar'),
('adoptering','1|adoptera'),
('adoption','1|adoptera'),
('adoptiv','1|adoption'),
('adoptivbarn','1|adoptera'),
('adoptivförälder','1|förälder'),
('adoptivson','1|adoptivbarn'),
('adoratör','1|beundrare'),
('adrenalin','1|signalsubstans'),
('adrenalinkick','1|kick'),
('adrenalinstinn','1|stinn'),
('adrenoleukodystrofi','1|nervsjukdom'),
('adrenomyeloneuropati','1|nervsjukdom'),
('adress','1|plats'),
('adressat','1|adress'),
('adressbuss','1|datoradress'),
('adressera','1|adress'),
('adressera','2|rikta'),
('adressera','3|ta_itu'),
('adresserande','1|adressera'),
('adresserande','2|adressera'),
('adresserande','3|adressera'),
('adresserbar','1|adressera'),
('adresserbar','2|adressera'),
('adresserbar','3|adressera'),
('adresserbarhet','1|adresserbar'),
('adresserbarhet','2|adresserbar'),
('adresserbarhet','3|adresserbar'),
('adressering','1|adressera'),
('adresskalender','1|kalender'),
('adresskort','1|kort'),
('adresskälla','1|källa'),
('adresslapp','1|lapp'),
('adriatisk','1|Adriatiska_havet'),
('adsorbera','1|fasthålla'),
('adsorberande','1|adsorbera'),
('adsorberbar','1|adsorbera'),
('adsorberbarhet','1|adsorberbar'),
('adsorbering','1|adsorbera'),
('adsorption','1|adsorbera'),
('adstringerande','1|sammandra'),
('aducera','1|metallurgi'),
('aducerande','1|aducera'),
('aducerbar','1|aducera'),
('aducerbarhet','1|aducerbar'),
('aducering','1|aducera'),
('advent','1|jul'),
('adventist','1|sekt'),
('adventistisk','1|adventist'),
('adventiv','1|utväxt'),
('adventskalender','1|kalender'),
('adventsljusstake','1|ljusstake'),
('adventsmys','1|mys'),
('adventsstake','1|adventsljusstake'),
('adventsstjärna','1|prydnad'),
('adverb','1|ordklass'),
('adverbial','1|satsdel'),
('adverbialbestämning','1|bestämning'),
('adverbialsats','1|sats'),
('adverbiell','1|adverb'),
('advers','1|framsida'),
('adversativ','1|konjunktion'),
('advocera','1|övertala'),
('advocerande','1|advocera'),
('advocerbar','1|advocera'),
('advocerbarhet','1|advocerbar'),
('advocering','1|advocera'),
('advokat','1|lag'),
('advokat','2|försvara'),
('advokatbyrå','1|byrå'),
('advokatfiskal','1|jurist'),
('advokathjälp','1|hjälp'),
('advokatknep','1|knep'),
('advokatkontor','1|kontor'),
('advokatorisk','1|advokatyr'),
('advokatsamfund','1|förening'),
('advokatstorm','1|proteststorm'),
('advokatyr','1|spetsfundighet'),
('adxukiböna','1|böna'),
('aerob','1|syrefordrande'),
('aerobisk','1|syreupptagande'),
('aerodrom','1|flygplats'),
('aerodynamik','1|rörelse'),
('aerodynamisk','1|luftmotstånd'),
('aerofagi','1|luft'),
('Aeroflot','1|flygbolag'),
('aerogel','1|isoleringsmaterial'),
('aerogram','1|brev'),
('aerologi','1|vetenskap'),
('aeromekanik','1|gaslära'),
('aeronaut','1|flygare'),
('aeronautik','1|flyg'),
('aeronautisk','1|aeronautik'),
('aeroplan','1|flygplan'),
('aerosol','1|sprej'),
('aerosolform','1|aerosol'),
('aerostat','1|luftfarkost'),
('aerostatik','1|aeromekanik'),
('aerostatisk','1|aerostatik'),
('af','1|släktnamn'),
('afaki','1|öga'),
('afasi','1|hjärnskada'),
('afatiker','1|afasi'),
('afatisk','1|afasi'),
('afatisk','1|afasi'),
('affekt','1|upprörd'),
('affektanfall','1|affekt'),
('affektation','1|affekterad'),
('affekterad','1|tillgjord'),
('affektfri','1|affekt'),
('affektion','1|tillgivenhet'),
('affektionsvärde','1|värde'),
('affektiv','1|affekt'),
('afficiera','1|angripa'),
('afficierande','1|afficiera'),
('afficierbar','1|afficiera'),
('afficierbarhet','1|afficierbar'),
('afficiering','1|afficiera'),
('affidavit','1|ed'),
('affin','1|överensstämma'),
('affinage','1|metallurgi'),
('affinera','1|affinage'),
('affinerande','1|affinera'),
('affinerbar','1|affinera'),
('affinerbarhet','1|affinerbar'),
('affinering','1|affinera'),
('affinitet','1|släktskap'),
('affirmativ','1|bekräfta'),
('affisch','1|anslag'),
('affischera','1|affisch'),
('affischerande','1|affischera'),
('affischerbar','1|affischera'),
('affischerbarhet','1|affischerbar'),
('affischering','1|affischera'),
('affischkampanj','1|kampanj'),
('affischmässig','1|affisch'),
('affischnamn','1|namn'),
('affischpelare','1|pelare'),
('affischstil','1|stil'),
('affischör','1|affisch'),
('affix','1|del'),
('affrikata','1|konsonant'),
('affär','1|handla'),
('affär','2|sälja'),
('affär','3|kärleksförhållande'),
('affär','4|skandal'),
('affärsavtal','1|avtal'),
('affärsbank','1|bank'),
('affärsbegåvning','1|begåvning'),
('affärsbegåvning','2|begåvning'),
('affärsbekant','1|bekant'),
('affärsbiträde','1|affär'),
('affärsbrev','1|brev'),
('affärsbyrå','1|byrå'),
('affärscentrum','1|centrum'),
('affärsdistrikt','1|distrikt'),
('affärsdrivande','1|vinst'),
('affärsfastighet','1|fastighet'),
('affärsförbindelse','1|förbindelse'),
('affärsföretag','1|företag'),
('affärsförslag','1|förslag'),
('affärsgata','1|gata'),
('affärsgeni','1|geni'),
('affärshandling','1|handling'),
('affärshuvud','1|huvud'),
('affärsidé','1|idé'),
('affärskedja','1|kedja'),
('affärskvarter','1|kvarter'),
('affärsliv','1|affär'),
('affärslokal','1|lokal'),
('affärsman','1|affär'),
('affärsmannamässig','1|affärsman'),
('affärsmoral','1|moral'),
('affärsmässig','1|saklig'),
('affärsmässig','2|affär'),
('affärsmässighet','1|affärsmässig'),
('affärsmässighet','2|affärsmässig'),
('affärspapper','1|papper'),
('affärsresa','1|resa'),
('affärsresenär','1|affärsresa'),
('affärsstil','1|stil'),
('affärsstråk','1|stråk'),
('affärsställning','1|ställning'),
('affärstid','1|öppethållande'),
('affärstransaktion','1|affär'),
('affärsuppgörelse','1|uppgörelse'),
('affärsverk','1|affärsdrivande_verk'),
('affärsverksamhet','1|affär'),
('affärsvärld','1|värld'),
('afghan','1|Afghanistan'),
('afghan','2|hundras'),
('Afghanistan','1|land'),
('Afghanistan','1|land'),
('Afghanistaninsatsen','1|insats'),
('Afghanistantrupp','1|trupp'),
('afghansk','1|Afghanistan'),
('afghanska','1|afghan'),
('afghanska','2|språk'),
('afibrinogenemi','1|blodsjukdom'),
('afoni','1|tappa_rösten'),
('aforism','1|uttryck'),
('aforistiker','1|aforism'),
('aforistisk','1|aforism'),
('Afrika','1|världsdel'),
('afrikaans','1|språk'),
('afrikainspirerad','1|inspirera'),
('Afrikainstitutet','1|institut'),
('afrikan','1|Afrika'),
('afrikanisera','1|Afrika'),
('afrikaniserande','1|afrikanisera'),
('afrikaniserbar','1|afrikanisera'),
('afrikaniserbarhet','1|afrikaniserbar'),
('afrikanisering','1|afrikanisera'),
('afrikansk','1|Afrika'),
('afrikanska','1|afrikan'),
('Afrikatrad','1|trad'),
('afroamerikan','1|amerikan'),
('afroamerikansk','1|amerikansk'),
('afro-asiatisk','1|Asien'),
('afro-asiatisk','1|Asien'),
('afrodisiakum','1|uppegga'),
('Afrodite','1|gudinna'),
('afrofobi','1|hat'),
('afrofrisyr','1|frisyr'),
('afrokam','1|kam'),
('afrosvensk','1|svensk'),
('afton','1|kväll'),
('aftonandakt','1|andakt'),
('aftonbelysning','1|belysning'),
('Aftonbladet','1|tidning'),
('aftonbrasa','1|brasa'),
('aftonbön','1|bön'),
('aftondagg','1|dagg'),
('aftondräkt','1|kläder'),
('aftonfjäril','1|fjäril'),
('aftongudstjänst','1|gudstjänst'),
('aftonhandske','1|handske'),
('aftonhimmel','1|himmel'),
('aftonklänning','1|klänning'),
('aftonkvist','1|kvist'),
('aftonkyla','1|kyla'),
('aftonluft','1|luft'),
('aftonmål','1|kvällsmat'),
('aftonmåltid','1|måltid'),
('aftonpipa','1|pipa'),
('aftonplenum','1|plenum'),
('aftonpromenad','1|promenad'),
('aftonpsalm','1|psalm'),
('aftonrodnad','1|solnedgång'),
('aftonsamkväm','1|samkväm'),
('aftonskola','1|skola'),
('aftonsky','1|sky'),
('aftonskymning','1|skymning'),
('aftonsol','1|sol'),
('aftonstjärna','1|Venus'),
('aftonstund','1|stund'),
('aftonstämning','1|stämning'),
('aftonsång','1|mässa'),
('aftontidning','1|tidning'),
('aftontoalett','1|aftonklänning'),
('aftonunderhållning','1|underhållning'),
('aftonvard','1|kvällsmåltid'),
('aftonvind','1|vind'),
('aftonvisit','1|visit'),
('ag','1|gräs'),
('aga','1|bestraffa'),
('aga','2|aga'),
('aga','3|hövding'),
('agammaglobulinemi','1|antikroppsbrist'),
('agande','1|aga'),
('agar','1|gelatin'),
('agat','1|ädelsten'),
('agatglas','1|glas'),
('agave','1|växt'),
('agenda','1|dagordning'),
('agens','1|reaktion'),
('agens','1|reaktion'),
('agent','1|ombud'),
('agent','2|spion'),
('agentfilm','1|film'),
('agentkontor','1|kontor'),
('agentskap','1|agent'),
('agentur','1|agent'),
('agera','1|handla'),
('agera','2|spela'),
('agerande','1|agera'),
('agerande','2|agera'),
('agerbar','1|agera'),
('agerbarhet','1|agerbar'),
('ageusi','1|smaksinne'),
('agg','1|hat'),
('aggande','1|plågsam'),
('aggfri','1|agg'),
('agglomerat','1|bergart'),
('agglomeration','1|samhälle'),
('agglomerera','1|sammanhopa'),
('agglomererande','1|agglomerera'),
('agglomererbar','1|agglomerera'),
('agglomererbarhet','1|agglomererbar'),
('agglomerering','1|agglomerera'),
('agglutination','1|agglutinera'),
('agglutination','2|agglutinera'),
('agglutinera','1|sammanfoga'),
('agglutinera','2|morfologi'),
('agglutinerande','1|agglutinera'),
('agglutinerande','2|agglutinera'),
('agglutinerbar','1|agglutinera'),
('agglutinerbar','2|agglutinera'),
('agglutinerbarhet','1|agglutinerbar'),
('agglutinerbarhet','2|agglutinerbar'),
('agglutinering','1|agglutinera'),
('agglutinering','2|agglutinera'),
('aggravera','1|förvärra'),
('aggregat','1|maskin'),
('aggregat','2|sammansatt'),
('aggregation','1|hopklumpning'),
('aggregationsform','1|aggregationstillstånd'),
('aggregationstillstånd','1|tillstånd'),
('aggression','1|aggressiv'),
('aggressionsbehov','1|behov'),
('aggressionshämning','1|hämma'),
('aggressiv','1|arg'),
('aggressivitet','1|aggressiv'),
('agio','1|börs'),
('agitation','1|agitera'),
('agitation','2|upprörd'),
('agitationsresa','1|resa'),
('agitationsvisa','1|visa'),
('agitator','1|agitera'),
('agitatorisk','1|agitera'),
('agitera','1|propaganda'),
('agiterande','1|agitera'),
('agiterbar','1|agitera'),
('agiterbarhet','1|agiterbar'),
('agitering','1|agitera'),
('agn','1|bete'),
('agna','1|agn'),
('agnande','1|agna'),
('agnar','1|säd'),
('agnat','1|agnatisk'),
('agnatisk','1|släkt'),
('agnblommig','1|gräs'),
('agnborst','1|agnar'),
('agnosi','1|hjärnskada'),
('agnosticism','1|agnostiker'),
('agnostiker','1|likgiltig'),
('agnostisk','1|agnostiker'),
('agnrost','1|rostsvamp'),
('agogik','1|tolkning'),
('agoni','1|dödskamp'),
('agonistisk','1|agoni'),
('agorafobi','1|torgskräck'),
('agraff','1|spänne'),
('agrafi','1|skrivstörning'),
('agranulocytos','1|blodsjukdom'),
('agrar','1|politisk'),
('agrar','2|agrar'),
('agrarförbund','1|förbund'),
('agrarkommunistisk','1|kommunism'),
('agrarpolitik','1|agrar'),
('agreabel','1|behaglig'),
('agremang','1|godkännande'),
('agremanger','1|bekvämlighet'),
('agrikultur','1|jordbruk'),
('agrikulturell','1|agrikultur'),
('agrikulturkemi','1|kemi'),
('agronom','1|agronomi'),
('agronomi','1|vetenskap'),
('agronomisk','1|lantbruk'),
('agronomisk','2|agronomi'),
('aguti','1|gnagare'),
('agyri','1|missbildning'),
('ah','1|jaså'),
('aha','1|förstå'),
('Ahasverus','1|jude'),
('aha-upplevelse','1|aha'),
('aha-upplevelse','1|aha'),
('Aida','1|opera'),
('aids','1|sjukdom'),
('aids','1|sjukdom'),
('aids-demens','1|demens'),
('aidsmedicin','1|medicin'),
('aidspanik','1|panik'),
('aidssjuk','1|sjuk'),
('aikido','1|kampsport'),
('aikidotrick','1|trick'),
('air','1|ansiktsuttryck'),
('air','2|stämning'),
('airbag','1|krockkudde'),
('airbagsensor','1|sensor'),
('airdaleterrier','1|terrier'),
('Aischylos','1|dramatiker'),
('Aisopos','1|diktare'),
('aj','1|ond'),
('ajournera','1|skjuta_upp'),
('ajournerande','1|ajournera'),
('ajournerbar','1|ajournera'),
('ajournerbarhet','1|ajournerbar'),
('ajournering','1|ajournera'),
('ajowan','1|krydda'),
('ajowan','1|krydda'),
('ajowan','1|krydda'),
('ajowan','1|krydda'),
('ajö','1|adjö'),
('ajöss','1|adjö'),
('akacia','1|träd'),
('akademi','1|vetenskap'),
('akademiker','1|universitet'),
('akademisk','1|universitet'),
('akademist','1|akademi'),
('akantolys','1|hudsjukdom'),
('akantom','1|hudtumör'),
('akantus','1|växt'),
('akantus','1|växt'),
('akantusblad','1|blad'),
('a-kassa','1|arbetslöshet'),
('a-kassa','1|arbetslöshet'),
('akatalasemi','1|enzymrubbning'),
('akatalektisk','1|katalektisk'),
('Akilles','1|hjälte'),
('akilleshäl','1|punkt'),
('akillessena','1|hälsena'),
('akleja','1|växt'),
('aklorhydri','1|magsjukdom'),
('akne','1|sjukdom'),
('akne','1|sjukdom'),
('akneiformutslag','1|hudutslag'),
('akondroplasi','1|dvärgväxt'),
('akribi','1|noggrannhet'),
('akrobat','1|akrobatik'),
('akrobatik','1|gymnastik'),
('akrobatik','2|konststycke'),
('akrobatisk','1|akrobat'),
('akrobatisk','2|vig'),
('akrocefali','1|missbildning'),
('akrocefalosyndaktyli','1|missbildning'),
('akrodermatit','1|hudinflammation'),
('akrodyni','1|kvicksilverförgiftning'),
('akromatisk','1|färglös'),
('akromegali','1|sjukdom'),
('akronym','1|förkortning'),
('akro-osteolys','1|skleros'),
('akropol','1|stad'),
('akrospirom','1|tumör'),
('akrostikon','1|verslära'),
('akroterion','1|fris'),
('akryl','1|plast'),
('akt','1|handling'),
('akt','2|skådespel'),
('akt','3|dokument'),
('akt','4|nakenakt'),
('akta','1|försiktig'),
('akta','2|vörda'),
('aktande','1|akta'),
('aktande','2|akta'),
('aktant','1|predikat'),
('akter','1|båt'),
('akter','2|riktning'),
('akterdel','1|stjärt'),
('akterdäck','1|däck'),
('akterhytt','1|hytt'),
('akterkastell','1|akter'),
('akterlig','1|akter'),
('akterlik','1|lik'),
('aktersalong','1|salong'),
('aktersegel','1|segel'),
('akterseglad','1|kvarlämna'),
('akterseglad','2|inaktuell'),
('akterskepp','1|akter'),
('aktersnurra','1|båtmotor'),
('akterspegel','1|akter'),
('akterst','1|akter'),
('akterstäv','1|stäv'),
('akterut','1|akter'),
('akterända','1|akter'),
('akteröver','1|akter'),
('aktförklaring','1|fördriva'),
('aktgivning','1|ge_akt'),
('aktie','1|ekonomi'),
('aktiebolag','1|bolag'),
('aktiebolag','1|bolag'),
('aktiebrev','1|dokument'),
('aktiebubbla','1|bubbla'),
('aktiebörs','1|börs'),
('aktieemission','1|emission'),
('aktiefond','1|fond'),
('aktiehandel','1|handel'),
('aktieinnehav','1|innehav'),
('aktiekapital','1|kapital'),
('aktiekupong','1|kvitto'),
('aktiekurs','1|kurs'),
('aktiemajoritet','1|majoritet'),
('aktiemarknad','1|marknad'),
('aktieportfölj','1|aktie'),
('aktiepost','1|aktie'),
('aktiespara','1|aktiesparande'),
('aktiesparande','1|spara'),
('aktiesparare','1|aktiesparande'),
('aktiesparklubb','1|klubb'),
('aktiestock','1|aktie'),
('aktieutdelning','1|utdelning'),
('aktievinst','1|vinst'),
('aktieägande','1|äga'),
('aktieägare','1|ägare'),
('aktindelning','1|akt'),
('aktinium','1|grundämne'),
('aktinium','1|grundämne'),
('aktinobacillos','1|infektion'),
('aktinomykos','1|strålsvampsjuka'),
('aktion','1|handla'),
('aktionistisk','1|aktion'),
('aktionsart','1|verb'),
('aktionsgrupp','1|grupp'),
('aktionsplan','1|plan'),
('aktionsradie','1|räckvidd'),
('aktionsström','1|ström'),
('aktionssätt','1|aktionsart'),
('aktionsturbin','1|ångturbin'),
('aktiv','1|göra'),
('aktiv','2|aktivum'),
('aktiva','1|bokföring'),
('aktivera','1|aktiv'),
('aktiverande','1|aktivera'),
('aktiverbar','1|aktivera'),
('aktiverbarhet','1|aktiverbar'),
('aktivering','1|aktivera'),
('aktiveringsmönster','1|mönster'),
('aktivism','1|aktivist'),
('aktivist','1|aktiv'),
('aktivistisk','1|aktivism'),
('aktivitet','1|aktiv'),
('aktivitetsersättning','1|ersättning'),
('aktivum','1|verbform'),
('aktning','1|akta'),
('aktningsbetygelse','1|aktning'),
('aktningsbevis','1|bevis'),
('aktningsfull','1|aktning'),
('aktningsfullhet','1|aktningsfull'),
('aktningsvärd','1|värd'),
('aktningsvärd','2|avsevärd'),
('aktningsvärdhet','1|aktningsvärd'),
('aktor','1|åtal'),
('aktre','1|akter'),
('aktris','1|aktör'),
('aktsam','1|försiktig'),
('aktsamhet','1|aktsam'),
('aktsamhetsplikt','1|plikt'),
('aktslut','1|slut'),
('aktstycke','1|dokument'),
('aktualisation','1|aktualisera'),
('aktualisera','1|aktuell'),
('aktualiserande','1|aktualisera'),
('aktualiserbar','1|aktualisera'),
('aktualiserbarhet','1|aktualiserbar'),
('aktualisering','1|aktualisera'),
('aktualism','1|geologi'),
('aktualistisk','1|aktualism'),
('aktualitet','1|aktuell'),
('aktualitetspress','1|press'),
('aktuarie','1|tjänsteman'),
('aktuell','1|nu'),
('Aktuellt','1|TV-program'),
('aktör','1|skådespelare'),
('aktör','2|verka'),
('akupunktur','1|medicin'),
('akupunktör','1|akupunktur'),
('akustik','1|ljud'),
('akustik','2|ljud'),
('akustiker','1|akustik'),
('akustikplatta','1|platta'),
('akustikusneurinom','1|tumör'),
('akustisk','1|akustik'),
('akustisk','2|akustik'),
('akustisk','3|instrument'),
('akut','1|nu'),
('akut','2|accent'),
('akut','3|akut'),
('akutavdelning','1|akutmottagning'),
('akuten','1|akutmottagning'),
('akutfall','1|patient'),
('akutfall','2|sjukdomsfall'),
('akutfasreaktion','1|inflammation'),
('akuthjälp','1|hjälp'),
('akutmottagning','1|mottagning'),
('akutopererad','1|operera'),
('akutvård','1|sjukvård'),
('akutvårdsdata','1|data'),
('akvakultur','1|kultur'),
('akvamarin','1|ädelsten'),
('akvanaut','1|dykare'),
('akvaplaning','1|vattenplaning'),
('akvarell','1|målning'),
('akvarellfärg','1|vattenfärg'),
('akvarellist','1|akvarell'),
('akvarellmålare','1|akvarell'),
('akvarelltryck','1|tryck'),
('akvarellutställning','1|utställning'),
('akvariefisk','1|akvarium'),
('akvaristik','1|akvarium'),
('akvaristisk','1|akvaristik'),
('akvarium','1|förvara'),
('akvatint','1|etsning'),
('akvatisk','1|vatten'),
('akvavit','1|brännvin'),
('akvedukt','1|vattenledning'),
('akyli','1|magsyra'),
('al','1|träd'),
('Alabama','1|delstat'),
('alabaster','1|material'),
('alabasterhy','1|hy'),
('alabasterliknande','1|alabaster'),
('alabastervit','1|vit'),
('Aladdin','1|Tusen_och_en_natt'),
('aladåb','1|mat'),
('A-lag','1|lag'),
('A-lag','2|fyllerist'),
('A-lagare','1|A-lag'),
('alagreck','1|ornament'),
('alan','1|nomad'),
('alanin','1|aminosyra'),
('alant','1|ålandsrot'),
('alarm','1|signal'),
('alarm','2|alarmanordning'),
('alarm','3|uppståndelse'),
('alarmanordning','1|apparat'),
('alarmera','1|alarm'),
('alarmera','2|alarm'),
('alarmerande','1|alarm'),
('alarmerande','2|alarmera'),
('alarmerande','3|alarmera'),
('alarmerbar','1|alarmera'),
('alarmerbarhet','1|alarmerbar'),
('alarmering','1|alarmera'),
('alarmering','2|alarmera'),
('alarmism','1|alarmist'),
('alarmist','1|alarmera'),
('alarmistisk','1|alarmism'),
('alarmklocka','1|klocka'),
('alarmsignal','1|alarm'),
('alarmskott','1|skott'),
('alarmtrumma','1|trumma'),
('Alaska','1|delstat'),
('alba','1|skjorta'),
('alba','2|morgonsång'),
('alban','1|Albanien'),
('Albanien','1|land'),
('albansk','1|Albanien'),
('albanska','1|språk'),
('albanska','2|alban'),
('Albany','1|huvudstad'),
('albatross','1|havsfågel'),
('albatross','2|golf'),
('Alberta','1|Kanada'),
('albigenser','1|asket'),
('albigenser','1|asket'),
('albigensisk','1|albigenser'),
('albinism','1|pigment'),
('albinistisk','1|albinism'),
('albino','1|albinism'),
('album','1|pärm'),
('album','2|musikalbum'),
('albumin','1|protein'),
('albuminuri','1|äggviteämne'),
('Albuquerque','1|stad'),
('albuske','1|buske'),
('albyl','1|medicin'),
('alcantara','1|syntetmaterial'),
('aldehyd','1|acetaldehyd'),
('aldrig','1|alltid'),
('aldrig','2|nej'),
('aldrig','3|hur'),
('ale','1|virke'),
('alemann','1|german'),
('alert','1|uppmärksam'),
('Aleutergraven','1|djuphavsgrav'),
('Aleuterna','1|ögrupp'),
('Alexanderhugg','1|hugg'),
('Alexanderhugg','1|hugg'),
('Alexandria','1|stad'),
('alexandrin','1|versmått'),
('alexandrinsk','1|alexandrin'),
('alexandrinsk','2|Alexandria'),
('alexi','1|hjärnskada'),
('alf','1|väsen'),
('alf','1|väsen'),
('alfa','1|bokstav'),
('alfabet','1|bokstav'),
('alfabetisera','1|läskunnig'),
('alfabetisera','2|alfabetisk'),
('alfabetisera','3|skriftspråk'),
('alfabetiserande','1|alfabetisera'),
('alfabetiserande','2|alfabetisera'),
('alfabetiserande','3|alfabetisera'),
('alfabetiserbar','1|alfabetisera'),
('alfabetiserbar','2|alfabetisera'),
('alfabetiserbar','3|alfabetisera'),
('alfabetiserbarhet','1|alfabetiserbar'),
('alfabetiserbarhet','2|alfabetiserbar'),
('alfabetiserbarhet','3|alfabetiserbar'),
('alfabetisering','1|alfabetisera'),
('alfabetisering','2|alfabetisera'),
('alfabetisering','3|alfabetisera'),
('alfabetisk','1|alfabet'),
('alfahanne','1|hanne'),
('alfalfa','1|grodd'),
('alfamannosidos','1|ämnesomsättningsrubbning'),
('alfametyltyrosin','1|hormon'),
('alfanumerisk','1|siffra'),
('alfapartikel','1|partikel'),
('alfapet','1|sällskapsspel'),
('alfapet','1|sällskapsspel'),
('alfastrålning','1|strålning'),
('alfasönderfall','1|sönderfall'),
('alfatalassemi','1|blodsjukdom'),
('alfavirusinfektion','1|virusinfektion'),
('alfkors','1|amulett'),
('alfons','1|hallick'),
('alfresko','1|freskomålning'),
('alfågel','1|sjöfågel'),
('alfågelskytte','1|skjuta'),
('alförrädare','1|sjöfågel'),
('alg','1|växt'),
('algblomning','1|blomning'),
('algebra','1|matematik'),
('algebraiker','1|algebra'),
('algebraisk','1|algebra'),
('Alger','1|huvudstad'),
('algerier','1|Algeriet'),
('Algeriet','1|land'),
('algerisk','1|Algeriet'),
('algeriska','1|algerier'),
('algmatta','1|täcke'),
('Algol','1|stjärna'),
('algolog','1|algologi'),
('algologi','1|vetenskap'),
('algologisk','1|algologi'),
('Algolstjärnan','1|Algol'),
('Algolsystemet','1|system'),
('algonk','1|period'),
('algoritm','1|instruktion'),
('algren','1|gren'),
('algtvätt','1|borttvagning'),
('Alhambra','1|slott'),
('alias','1|annan'),
('alibi','1|bevisa'),
('alibi','2|ursäkt'),
('alibibevis','1|alibi'),
('alibistisk','1|alibi'),
('Alicante','1|stad'),
('alienation','1|främlingskap'),
('alienationsupplevelse','1|upplevelse'),
('alienera','1|alienation'),
('alienerande','1|alienera'),
('alienerbar','1|alienera'),
('alienerbarhet','1|alienerbar'),
('alienering','1|alienera'),
('alifatisk','1|kolförening'),
('alika','1|kaja'),
('alimentär','1|näring'),
('Alingsås','1|stad'),
('alisarin','1|färgämne'),
('alka','1|tordmule'),
('alkaisk','1|versmått'),
('alkali','1|alkalimetall'),
('alkaliblått','1|anilinfärg'),
('alkalilut','1|lut'),
('alkalimetall','1|metall'),
('alkalisk','1|basisk'),
('alkaloid','1|ämne'),
('alkalos','1|pH-balans'),
('alkan','1|paraffin'),
('alkanna','1|växt'),
('alkanol','1|alkohol'),
('alkaptonuri','1|ämnesomsättningsrubbning'),
('alkekung','1|alkfågel'),
('alkemi','1|guld'),
('alkemisk','1|alkemi'),
('alkemist','1|alkemi'),
('alkemistisk','1|alkemi'),
('alkfågel','1|havsfågel'),
('alkis','1|alkoholist'),
('alkohol','1|sprit'),
('alkoholabstinens','1|abstinens'),
('alkoholabstinensanfall','1|anfall'),
('alkoholberusning','1|berusning'),
('alkoholcirros','1|cirros'),
('alkoholcirros','1|cirros'),
('alkoholfri','1|alkohol'),
('alkoholfri','2|nykter'),
('alkoholförbud','1|förbud'),
('alkoholförgiftning','1|förgiftning'),
('alkoholförtäring','1|förtäring'),
('alkoholhalt','1|halt'),
('alkoholhaltig','1|alkoholhalt'),
('alkoholinnehav','1|innehav'),
('alkoholintoxikation','1|intoxikation'),
('alkoholiserad','1|alkoholmissbruk'),
('alkoholisk','1|alkohol'),
('alkoholism','1|missbruk'),
('alkoholist','1|alkoholism'),
('alkoholistanstalt','1|vårdanstalt'),
('alkoholistisk','1|alkoholism'),
('alkoholkardiomyopati','1|kardiomyopati'),
('alkoholkonsumtion','1|konsumtion'),
('alkoholmissbruk','1|missbruk'),
('alkoholmissbrukande','1|alkoholmissbrukare'),
('alkoholmissbrukare','1|missbruka'),
('alkoholneuropati','1|neuropati'),
('alkoholometer','1|mäta'),
('alkoholpolicy','1|policy'),
('alkoholpolitik','1|politik'),
('alkoholpolitisk','1|alkoholpolitik'),
('alkoholpsykos','1|psykos'),
('alkoholpåverkad','1|påverkad'),
('alkoholrelaterad','1|relatera'),
('alkoholskada','1|kroppsskada'),
('alkoholskatt','1|skatt'),
('alkoholstark','1|alkoholhalt'),
('alkoholstyrka','1|alkoholhalt'),
('alkoholsvag','1|alkoholhalt'),
('alkoholsvaghet','1|alkoholsvag'),
('alkoholtest','1|test'),
('alkoholvana','1|vana'),
('alkolås','1|billås'),
('alkotest','1|alkoholtest'),
('alkotte','1|kotte'),
('alkov','1|rum'),
('alkovsäng','1|säng'),
('alkyd','1|konstharts'),
('alkyl','1|kolförening'),
('alkyn','1|kolväte'),
('all','1|PRIM'),
('all','1|PRIM'),
('all','1|PRIM'),
('alla','1|tärningskast'),
('Allah','1|gud'),
('allaredan','1|redan'),
('allativ','1|kasus'),
('allbekant','1|bekant'),
('alldaglig','1|vanlig'),
('alldaglig','2|daglig'),
('alldaglighet','1|alldaglig'),
('alldeles','1|hel'),
('alldenstund','1|eftersom'),
('allé','1|väg'),
('allegat','1|kvitto'),
('allegori','1|liknelse'),
('allegorisera','1|allegori'),
('allegoriserande','1|allegorisera'),
('allegoriserbar','1|allegorisera'),
('allegoriserbarhet','1|allegoriserbar'),
('allegorisering','1|allegorisera'),
('allegorisk','1|allegori'),
('allegretto','1|musik'),
('allegretto','2|allegretto'),
('allegro','1|musik'),
('allegro','2|allegro'),
('allegrosats','1|sats'),
('allehanda','1|diverse'),
('allel','1|gen'),
('allemansfond','1|fond'),
('allemansrätt','1|rättighet'),
('allena','1|ensam'),
('allena','1|ensam'),
('allenarådande','1|dominera'),
('allenast','1|endast'),
('allenastyre','1|självstyre'),
('allergen','1|allergi'),
('allergen','2|allergen'),
('allergi','1|allergisk'),
('allergiframkallande','1|framkalla'),
('allergiker','1|allergi'),
('allergimedicin','1|medicin'),
('allergisk','1|överkänslig'),
('allergisk','2|ogilla'),
('allergitablett','1|tablett'),
('allergolog','1|allergologi'),
('allergologi','1|vetenskap'),
('allernådigste','1|nåd'),
('allesammans','1|all'),
('allesammans','1|all'),
('allestädes','1|överallt'),
('allestädesnärvarande','1|allestädes'),
('alleuropeisk','1|Europa'),
('allfader','1|gud'),
('allfarväg','1|väg'),
('allgod','1|god'),
('allgodhet','1|allgod'),
('allhelgonadag','1|helg'),
('allhelgonamässa','1|mässa'),
('allhärskare','1|härskare'),
('allians','1|förbund'),
('alliansfri','1|allians'),
('allianskollega','1|regeringskollega'),
('alliansparti','1|parti'),
('alliansregering','1|regering'),
('alliansring','1|fingerring'),
('alliera','1|allians'),
('allierad','1|alliera'),
('allierande','1|alliera'),
('allierbar','1|alliera'),
('allierbarhet','1|allierbar'),
('alliering','1|alliera'),
('alligator','1|krokodil'),
('allihop','1|all'),
('allihop','1|all'),
('allitteration','1|begynnelserim'),
('allitterera','1|allitteration'),
('allittererande','1|allitterera'),
('allittererbar','1|allitterera'),
('allittererbarhet','1|allittererbar'),
('allitterering','1|allitterera'),
('allkonstnär','1|konstnär'),
('allkonstverk','1|konstverk'),
('allmakt','1|makt'),
('allmaktsord','1|ord'),
('allmoge','1|bondebefolkning'),
('allmogeblå','1|blå'),
('allmogebroderi','1|broderi'),
('allmogedräkt','1|dräkt'),
('allmogekultur','1|kultur'),
('allmogemål','1|dialekt'),
('allmogesed','1|sed'),
('allmogesmycke','1|smycke'),
('allmogespråk','1|dialekt'),
('allmogevävnad','1|vävnad'),
('allmosa','1|gåva'),
('allmän','1|vanlig'),
('allmän','2|all'),
('allmän','3|hel'),
('allmän','4|offentlig'),
('allmän','5|obestämd'),
('allmänanda','1|solidaritet'),
('allmänbefinnande','1|må'),
('allmänbegrepp','1|begrepp'),
('allmänbegåvning','1|begåvning'),
('allmänbegåvning','2|begåvning'),
('allmänbilda','1|allmänbildning'),
('allmänbildad','1|veta'),
('allmänbildande','1|allmänbilda'),
('allmänbildning','1|allmänbildad'),
('allmänborgerlig','1|borgerlig'),
('allmänfarlig','1|farlig'),
('allmänfarlighet','1|allmänfarlig'),
('allmängiltig','1|allmän'),
('allmängiltighet','1|allmängiltig'),
('allmängods','1|bekant'),
('allmänhet','1|samhälle'),
('allmänhumanistisk','1|humanism'),
('allmänintresse','1|intresse'),
('allmänläkare','1|allmänpraktiserande'),
('allmänmodernistisk','1|modernism'),
('allmänmänsklig','1|mänsklig'),
('allmänmänsklighet','1|allmänmänsklig'),
('allmännelig','1|omfatta'),
('allmännelighet','1|allmännelig'),
('allmänning','1|mark'),
('allmännytta','1|hyreshus'),
('allmännyttig','1|nyttig'),
('allmännyttighet','1|allmännyttig'),
('allmänpolitisk','1|politisk'),
('allmänpraktiker','1|läkare'),
('allmänpraktiserande','1|allmänpraktiker'),
('allmänprevention','1|allmänpreventiv'),
('allmänpreventiv','1|straff'),
('allmäntillstånd','1|må'),
('allmäntjänstgöring','1|praktik'),
('allmäntjänstgöring','1|praktik'),
('allnationell','1|nationell'),
('allod','1|äga'),
('allodial','1|allod'),
('allodium','1|allod'),
('allofon','1|fonem'),
('allograf','1|grafem'),
('allokera','1|fördela'),
('allokerande','1|allokera'),
('allokerbar','1|allokera'),
('allokerbarhet','1|allokerbar'),
('allokering','1|allokera'),
('allokton','1|geologi'),
('allokution','1|anförande'),
('allomfattande','1|omfatta'),
('allomorf','1|morfem'),
('allomorf','2|allomorf'),
('allongeperuk','1|peruk'),
('allopat','1|allopatisk'),
('allopati','1|allopatisk'),
('allopatisk','1|behandlingsmetod'),
('allra','1|all'),
('allraheligaste','1|rum'),
('allriskförsäkring','1|försäkring'),
('allroundsåg','1|såg'),
('allrum','1|rum'),
('allrådande','1|allmän'),
('alls','1|inte'),
('allseende','1|se'),
('allshärjarting','1|folkting'),
('allsidig','1|sida'),
('allsidighet','1|allsidig'),
('allsköns','1|diverse'),
('allsmäktig','1|makt'),
('allsmäktighet','1|allsmäktig'),
('allströmsapparat','1|apparat'),
('allsvensk','1|allsvenskan'),
('allsvenskan','1|elitserie'),
('allsvåldig','1|allsmäktig'),
('allsvåldighet','1|allsvåldig'),
('allsång','1|sång'),
('allsångsledare','1|ledare'),
('allt','1|mycken'),
('allt','2|säker'),
('alltefter','1|bero'),
('alltefter','1|bero'),
('allteftersom','1|successiv'),
('allteftersom','1|successiv'),
('alltemellanåt','1|emellanåt'),
('alltemellanåt','1|emellanåt'),
('alltemellanåt','1|emellanåt'),
('alltet','1|all'),
('alltfler','1|mången'),
('alltfler','1|mången'),
('alltfort','1|fortfarande'),
('alltframgent','1|framgent'),
('alltför','1|mycken'),
('alltid','1|tid'),
('alltifrån','1|från'),
('alltigenom','1|total'),
('alltihop','1|all'),
('alltihop','1|all'),
('allting','1|all'),
('allting','2|riksdag'),
('alltintill','1|nu'),
('alltjämt','1|fortfarande'),
('alltmedan','1|hela_tiden'),
('alltmera','1|mycken'),
('alltmera','1|mycken'),
('alltmindre','1|lite'),
('alltmindre','1|lite'),
('alltnog','1|nåväl'),
('alltomfattande','1|omfatta'),
('alltsammans','1|all'),
('alltsammans','1|all'),
('alltsedan','1|sedan'),
('alltsomoftast','1|ofta'),
('alltså','1|följa'),
('alltså','1|följa'),
('alltså','2|ju'),
('alltså','2|ju'),
('alludera','1|anspela'),
('alluderande','1|alludera'),
('alluderbar','1|alludera'),
('alluderbarhet','1|alluderbar'),
('alludering','1|alludera'),
('allusion','1|alludera'),
('allusionsvis','1|allusion'),
('alluvial','1|avlagring'),
('alluvialbildning','1|bildning'),
('alluvialland','1|land'),
('alluvialperiod','1|period'),
('alluvium','1|jordart'),
('allvar','1|allvarlig'),
('allvarlig','1|skämta'),
('allvarlig','2|farlig'),
('allvarligen','1|allvarlig'),
('allvarlighet','1|allvarlig'),
('allvarlighet','2|allvarlig'),
('allvarsam','1|allvarlig'),
('allvarsamhet','1|allvarsam'),
('allvarsord','1|ord'),
('allvarstyngd','1|allvarlig'),
('allvarstyngdhet','1|allvarstyngd'),
('allvetande','1|veta'),
('allvetare','1|allvetande'),
('allvis','1|vis'),
('allvishet','1|allvis'),
('allväders','1|skydda'),
('allvädersskydd','1|skydd'),
('allvädersstövel','1|stövel'),
('allätande','1|allätare'),
('allätare','1|äta'),
('alm','1|träd'),
('almanacka','1|kalender'),
('almanacka','1|kalender'),
('almanacksblad','1|blad'),
('alme','1|virke'),
('Almedalen','1|politikervecka'),
('Almedalstal','1|tal'),
('Almedalstal','1|tal'),
('Almedalsveckan','1|Almedalen'),
('almfällning','1|fällning'),
('almgren','1|gren'),
('almsav','1|sav'),
('almsjuka','1|sjukdom'),
('almstriden','1|almfällning'),
('aln','1|mått'),
('alnmått','1|aln'),
('alnsbred','1|bred'),
('alnsdjup','1|djup'),
('alnshög','1|hög'),
('alnslång','1|lång'),
('aloe','1|lilja'),
('aloebaserad','1|basera'),
('alopeci','1|håravfall'),
('alopeci','1|håravfall'),
('alp','1|berg'),
('alpacka','1|lamadjur'),
('alpacka','2|nysilver'),
('alpackatyg','1|tyg'),
('alpackaull','1|ull'),
('alpari','1|börs'),
('alpbestigning','1|bestigning'),
('Alperna','1|bergskedja'),
('alpget','1|get'),
('alphorn','1|horn'),
('alpidyll','1|idyll'),
('alpin','1|Alperna'),
('alpin','2|utförsåkning'),
('alpinism','1|bergsklättring'),
('alpinist','1|alpinism'),
('alpinsk','1|Alperna'),
('alpjägare','1|soldat'),
('alpkedja','1|bergskedja'),
('alpland','1|land'),
('alpregion','1|region'),
('alpros','1|ros'),
('alpspets','1|alptopp'),
('alpstav','1|vandringsstav'),
('alpstig','1|stig'),
('alptopp','1|bergstopp'),
('alpvandring','1|vandring'),
('alpviol','1|cyklamen'),
('alpväg','1|väg'),
('alruna','1|växt'),
('als','1|nervsjukdom'),
('als','1|nervsjukdom'),
('alsikeklöver','1|klöver'),
('alspån','1|spån'),
('alster','1|skapa'),
('alstra','1|producera'),
('alstrande','1|alstra'),
('alstrare','1|alstra'),
('alstring','1|alstra'),
('alt','1|röst'),
('alt','2|sångare'),
('altaisk','1|språk'),
('altan','1|uteplats'),
('altanbräda','1|bräda'),
('altandörr','1|dörr'),
('altanfäste','1|fäste'),
('altarbild','1|bild'),
('altarbord','1|bord'),
('altarbrun','1|antependium'),
('altardisk','1|altarring'),
('altarduk','1|duk'),
('altare','1|kyrka'),
('altargång','1|kyrka'),
('altarkläde','1|kläde'),
('altarkors','1|kors'),
('altarkärl','1|kärl'),
('altarlykta','1|lykta'),
('altarmålning','1|målning'),
('altarprydnad','1|prydnad'),
('altarring','1|räcke'),
('altarrund','1|altare'),
('altarskrud','1|skrud'),
('altarskåp','1|tavla'),
('altartavla','1|tavla'),
('altartjänst','1|gudstjänst'),
('altaruppsats','1|altartavla'),
('altbasun','1|basun'),
('altea','1|stockros'),
('alteasirap','1|medicin'),
('alteration','1|bestörtning'),
('altererad','1|alteration'),
('alternativ','1|annan'),
('alternativ','2|alternativ'),
('alternativfråga','1|fråga'),
('alternativkurs','1|kurs'),
('alternativt','1|eller'),
('alternatvinkel','1|vinkel'),
('alternera','1|omväxla'),
('alternerande','1|alternera'),
('alternerbar','1|alternera'),
('alternerbarhet','1|alternerbar'),
('alternering','1|alternera'),
('altfiol','1|fiol'),
('altflöjt','1|flöjt'),
('althorn','1|horn'),
('altita','1|stjärtmes'),
('altitud','1|höjd'),
('altklarinett','1|klarinett'),
('altklav','1|klav'),
('altparti','1|altstämma'),
('altruism','1|altruist'),
('altruist','1|osjälvisk'),
('altruistisk','1|altruist'),
('altröst','1|alt'),
('altsträng','1|sträng'),
('altstämma','1|stämma'),
('altsångare','1|alt'),
('altsångerska','1|alt'),
('altviolin','1|altfiol'),
('aluminera','1|aluminium'),
('aluminerande','1|aluminera'),
('aluminerbar','1|aluminera'),
('aluminerbarhet','1|aluminerbar'),
('aluminering','1|aluminera'),
('aluminium','1|metall'),
('aluminium','2|grundämne'),
('aluminium','2|grundämne'),
('aluminiumfabrik','1|fabrik'),
('aluminiumfolie','1|folie'),
('aluminiumjon','1|jon'),
('aluminiumkärl','1|kärl'),
('aluminiumlinjal','1|linjal'),
('aluminiumnät','1|nät'),
('aluminiumpulver','1|pulver'),
('aluminiumsmältverk','1|smältverk'),
('alumn','1|lärjunge'),
('alun','1|garvmedel'),
('alunhaltig','1|alun'),
('alunit','1|bergart'),
('alunskiffer','1|lerskiffer'),
('alv','1|jordart'),
('alvar','1|slätt'),
('alvarsmark','1|mark'),
('alveol','1|tandhåla'),
('alveolar','1|alveol'),
('alveolar','2|konsonant'),
('alveolarben','1|ben'),
('alveolarresorption','1|resorption'),
('Alvesta','1|ort'),
('Alvik','1|Göteborg'),
('alvluckra','1|plöja'),
('alvluckrande','1|alvluckra'),
('alvplog','1|plog'),
('alzheimer','1|hjärnsjukdom'),
('alzheimer','1|hjärnsjukdom'),
('amalgam','1|tandfyllning'),
('amalgamera','1|legera'),
('amalgamera','2|smälta_samman'),
('amalgamerande','1|amalgamera'),
('amalgamerande','2|amalgamera'),
('amalgamerbar','1|amalgamera'),
('amalgamerbar','2|amalgamera'),
('amalgamerbarhet','1|amalgamerbar'),
('amalgamerbarhet','2|amalgamerbar'),
('amalgamering','1|amalgamera'),
('amalgamering','2|amalgamera'),
('amanuens','1|universitet'),
('amarant','1|vävarfink'),
('amarant','2|växt'),
('amaryllis','1|lilja'),
('amason','1|kvinna'),
('amason','1|kvinna'),
('amatör','1|yrkesmässig'),
('amatör','2|oskicklig'),
('amatörastronom','1|astronom'),
('amatörbestämmelse','1|bestämmelse'),
('amatörbombtillverkning','1|bombtillverkning'),
('amatörforskare','1|forskare'),
('amatöridrott','1|idrott'),
('amatörism','1|amatör'),
('amatörism','2|amatör'),
('amatöristisk','1|amatörism'),
('amatöristisk','2|amatörism'),
('amatörmålare','1|målare'),
('amatörmässig','1|amatör'),
('amatörmässighet','1|amatörmässig'),
('amatörprojekt','1|projekt'),
('amatörregel','1|amatörbestämmelse'),
('amatörsändare','1|radiosändare'),
('amatörteater','1|teater'),
('amatörteleskop','1|teleskop'),
('amatörvideo','1|video'),
('Amazonfloden','1|flod'),
('ambassad','1|representant'),
('ambassadpersonal','1|personal'),
('ambassadris','1|ambassadör'),
('ambassadråd','1|ambassad'),
('ambassadsekreterare','1|ambassad'),
('ambassadör','1|ambassad'),
('ambassadör','2|representant'),
('ambassadörsmässig','1|ambassadör'),
('ambassadörspost','1|ambassadör'),
('ambidexter','1|hand'),
('ambidexteritet','1|ambidextri'),
('ambidextri','1|hand'),
('ambiguitet','1|tvetydighet'),
('Ambio','1|miljötidskrift'),
('ambiofoni','1|stereofoni'),
('ambition','1|strävan'),
('ambitionsnivå','1|nivå'),
('ambitionssak','1|hederssak'),
('ambitiös','1|ambition'),
('ambitiös','2|utmaning'),
('ambivalens','1|ambivalent'),
('ambivalent','1|kluven'),
('amblyopi','1|synnedsättning'),
('ambra','1|parfym'),
('ambradoft','1|doft'),
('ambrosia','1|mat'),
('ambrosisk','1|ambrosia'),
('Ambrosius','1|kyrkofader'),
('ambulans','1|fordon'),
('ambulansflyg','1|flyg'),
('ambulansförare','1|förare'),
('ambulanshelikopter','1|helikopter'),
('ambulanskår','1|kår'),
('ambulanskår','2|kår'),
('ambulansman','1|ambulanspersonal'),
('ambulanspersonal','1|personal'),
('ambulanssjukskötare','1|sjukskötare'),
('ambulanssjuksköterska','1|sjuksköterska'),
('ambulanssjukvårdare','1|sjukvårdare'),
('ambulatorisk','1|ambulera'),
('ambulera','1|förflytta_sig'),
('ambulerande','1|ambulera'),
('ambulerbar','1|ambulera'),
('ambulerbarhet','1|ambulerbar'),
('ambulering','1|ambulera'),
('ameloblastom','1|tumör'),
('amen','1|bön'),
('amendemang','1|tillägg'),
('amenorre','1|menstruationsrubbning'),
('americium','1|grundämne'),
('americium','1|grundämne'),
('Amerika','1|världsdel'),
('Amerika','2|USA'),
('amerikabiljett','1|biljett'),
('amerikan','1|Amerika'),
('amerikan','1|Amerika'),
('amerikan','2|USA'),
('amerikan','2|USA'),
('amerikanare','1|bil'),
('amerikanisera','1|amerikansk'),
('amerikaniserande','1|amerikanisera'),
('amerikaniserbar','1|amerikanisera'),
('amerikaniserbarhet','1|amerikaniserbar'),
('amerikanisering','1|amerikanisera'),
('amerikanism','1|amerikanska'),
('amerikansk','1|Amerika'),
('amerikansk','2|USA'),
('amerikanska','1|engelska'),
('amerikanska','2|amerikan'),
('amerikanska','3|amerikan'),
('amerikansktillverkad','1|tillverka'),
('ametist','1|ädelsten'),
('ametistblå','1|blå'),
('ametistsmycke','1|smycke'),
('amfetamin','1|medicin'),
('amfetaminbeslag','1|beslag'),
('amfetaminmissbruk','1|missbruk'),
('amfibie','1|groddjur'),
('amfibieplan','1|sjöflygplan'),
('amfibisk','1|amfibie'),
('amfibolit','1|bergart'),
('amfiteater','1|scen'),
('amfiteatralisk','1|amfiteater'),
('amfora','1|kruka'),
('ami','1|halsduk'),
('amid','1|förening'),
('amin','1|förening'),
('aminosyra','1|syra'),
('amiral','1|officer'),
('amiralitet','1|flotta'),
('amiralsflagga','1|flagga'),
('amiralsperson','1|amiral'),
('amiralstitel','1|titel'),
('amma','1|modersmjölk'),
('amma','2|amma'),
('Amman','1|huvudstad'),
('ammande','1|amma'),
('ammoniak','1|ämne'),
('ammoniaklukt','1|lukt'),
('ammoniaklösning','1|ammoniak'),
('ammonit','1|blötdjur'),
('ammonit','2|folk'),
('ammonium','1|ammoniak'),
('ammoniumklorid','1|salmiak'),
('ammoniumnitrat','1|ammoniak'),
('ammoniumnitratlösning','1|lösning'),
('ammunition','1|vapen'),
('ammunitionsväska','1|förvara'),
('amnesi','1|minne'),
('amnesti','1|benåda'),
('amnestidekret','1|dekret'),
('amnestilag','1|lag'),
('Amnesty','1|förening'),
('amning','1|amma'),
('amningsbehå','1|behå'),
('amningsdepression','1|depression'),
('amningsfanatiker','1|fanatiker'),
('amningsfanatism','1|amningsfanatiker'),
('amningsfascism','1|amningsfanatiker'),
('amningsfascist','1|amningsfascism'),
('amningsförakt','1|förakt'),
('amningsmobbare','1|mobba'),
('amningssvårighet','1|svårighet'),
('amnionbandsyndrom','1|spädbarnssjukdom'),
('amoebiasis','1|amöbainfektion'),
('amok','1|raseri'),
('Amor','1|gud'),
('amoralisk','1|moral'),
('amoralism','1|amoralisk'),
('amoralitet','1|amoralisk'),
('amorbåge','1|överläpp'),
('amorf','1|formlös'),
('amorfism','1|amorf'),
('amorin','1|kärleksgud'),
('amortera','1|avbetala'),
('amorterande','1|amortera'),
('amorterbar','1|amortera'),
('amorterbarhet','1|amorterbar'),
('amortering','1|amortera'),
('amorteringsfond','1|fond'),
('amorteringsfri','1|amortering'),
('amorteringslån','1|lån'),
('amorteringsplan','1|plan'),
('amorös','1|kärlek'),
('ampel','1|krukväxt'),
('ampel','2|lovord'),
('amper','1|barsk'),
('ampere','1|strömstyrka'),
('amperemeter','1|mäta'),
('amperesekund','1|coulomb'),
('amperevarv','1|ampere'),
('amperhet','1|amper'),
('amplifiera','1|utvidga'),
('amplifierande','1|amplifiera'),
('amplifierbar','1|amplifiera'),
('amplifierbarhet','1|amplifierbar'),
('amplifiering','1|amplifiera'),
('amplitud','1|avstånd'),
('amplitud','2|variationsbredd'),
('amplitudmodulera','1|amplitudmodulering'),
('amplitudmodulerande','1|amplitudmodulera'),
('amplitudmodulerbar','1|amplitudmodulera'),
('amplitudmodulerbarhet','1|amplitudmodulerbar'),
('amplitudmodulering','1|radioteknik'),
('ampull','1|behållare'),
('amputation','1|amputera'),
('amputera','1|avlägsna'),
('amputerande','1|amputera'),
('amputerbar','1|amputera'),
('amputerbarhet','1|amputerbar'),
('amputering','1|amputera'),
('AMS','1|ämbetsverk'),
('AMS','1|ämbetsverk'),
('amsaga','1|historia'),
('Amsterdam','1|stad'),
('amt','1|län'),
('amtman','1|ämbetsman'),
('amulett','1|skydd'),
('amylas','1|enzym'),
('amyloidneuropati','1|nervsjukdom'),
('amyloidos','1|vävnadssjukdom'),
('amyloidplack','1|amyloidos'),
('amyotrofi','1|förtvina'),
('A-människa','1|prestationsfixerad'),
('amöba','1|djur'),
('amöbadysenteri','1|dysenteri'),
('amöbainfektion','1|infektion'),
('an','1|mot'),
('ana','1|tro'),
('ana','1|tro'),
('anabaptism','1|vederdöpare'),
('anabaptist','1|anabaptism'),
('anabaptistisk','1|anabaptism'),
('anabatisk','1|vind'),
('anabol','1|hormon'),
('anabol','2|anabol'),
('anacka','1|fan_anamma'),
('anadrom','1|reproducera'),
('anaerob','1|syre'),
('anafor','1|stilfigur'),
('anaforisk','1|syfta'),
('anafylaxi','1|chockreaktion'),
('anagram','1|ord'),
('anakolut','1|syntax'),
('anakolutisk','1|anakolut'),
('anakonda','1|boaorm'),
('anakoret','1|eremit'),
('anakreontisk','1|levnadsglad'),
('anakronism','1|otidsenlig'),
('anakronistisk','1|anakronism'),
('anal','1|ändtarm'),
('analatresi','1|missbildning'),
('analbuminemi','1|ämnesomsättningsrubbning'),
('analcancer','1|cancer'),
('analeptik','1|konvalescens'),
('analfabet','1|obildad'),
('analfabetisk','1|analfabet'),
('analfabetism','1|analfabet'),
('analfena','1|fena'),
('analfissur','1|fissur'),
('analgetika','1|medicin'),
('analinkontinens','1|inkontinens'),
('analkörtel','1|körtel'),
('analkörtelcancer','1|cancer'),
('analkörteltumör','1|tumör'),
('analog','1|analogi'),
('analog','2|digital'),
('analog','3|TV-sändare'),
('analogi','1|likna'),
('analogibevis','1|analogislut'),
('analogibildning','1|bildning'),
('analogisk','1|analogi'),
('analogislut','1|slutsats'),
('analsex','1|sex'),
('analsfinkter','1|sfinkter'),
('analsjukdom','1|sjukdom'),
('analtumör','1|tumör'),
('analulcer','1|sår'),
('analys','1|analysera'),
('analysera','1|undersöka'),
('analyserande','1|analysera'),
('analyserbar','1|analysera'),
('analyserbarhet','1|analyserbar'),
('analysering','1|analysera'),
('analysmetodik','1|metodik'),
('analytiker','1|analysera'),
('analytisk','1|analysera'),
('analöppning','1|öppning'),
('anamma','1|ta_emot'),
('anamma','2|svordom'),
('anammande','1|anamma'),
('anamnes','1|förhistoria'),
('ananas','1|frukt'),
('ananassallad','1|sallad'),
('anande','1|ana'),
('anapest','1|versfot'),
('anapestisk','1|anapest'),
('anaplasi','1|tillbakabildning'),
('anaplasmainfektion','1|fästingfeber'),
('anaplasmos','1|fästingfeber'),
('anarki','1|laglöshet'),
('anarkisk','1|anarki'),
('anarkism','1|anarki'),
('anarkist','1|anarki'),
('anarkistisk','1|anarki'),
('anarkokapitalistisk','1|kapitalism'),
('anarkokommunistisk','1|kommunism'),
('anarkoprimitivistisk','1|primitivism'),
('anarkosyndikalism','1|syndikalism'),
('anarkosyndikalist','1|syndikalist'),
('anarkosyndikalistisk','1|anarkosyndikalism'),
('anastas','1|återuppståndelse'),
('Anastasia','1|tsardotter'),
('anastatisk','1|tryck'),
('anastigmatisk','1|astigmatism'),
('anastomos','1|tvärförbindelse'),
('anastomosläckage','1|läckage'),
('anatema','1|fördöma'),
('Anatolien','1|Mindre_Asien'),
('anatolisk','1|Anatolien'),
('anatom','1|anatomi'),
('anatomi','1|vetenskap'),
('anatomi','2|kropp'),
('anatomisal','1|sal'),
('anatomisk','1|anatomi'),
('anbefalla','1|rekommendera'),
('anbefalla','2|befalla'),
('anbefallande','1|anbefalla'),
('anbefallande','2|anbefalla'),
('anbefallning','1|anbefalla'),
('anbefallning','2|anbefalla'),
('anbelanga','1|beträffa'),
('anbelangande','1|anbelanga'),
('anblick','1|se'),
('anblåspipa','1|säckpipa'),
('anbringa','1|placera'),
('anbringande','1|anbringa'),
('anbringning','1|anbringa'),
('anbrott','1|bryta'),
('anbud','1|erbjuda'),
('anbudsgivare','1|anbud'),
('ancestor','1|förfader'),
('Anchorage','1|stad'),
('anciennitet','1|tjänsteår'),
('Ancylussjön','1|Östersjön'),
('and','1|sjöfågel'),
('and','2|skördeand'),
('anda','1|stämning'),
('anda','2|innebörd'),
('andakt','1|bön'),
('andakt','2|andaktsfull'),
('andaktsbok','1|bok'),
('andaktsfull','1|uppmärksam'),
('andaktsfullhet','1|andaktsfull'),
('andaktslitteratur','1|litteratur'),
('andaktssal','1|sal'),
('andaktsstund','1|andakt'),
('andaktsutövning','1|utövning'),
('andaktsövning','1|andakt'),
('Andalusien','1|Spanien'),
('andalusisk','1|Andalusien'),
('andan','1|andas'),
('andante','1|musik'),
('andante','2|andante'),
('andas','1|luft'),
('andas','2|intryck'),
('ande','1|själ'),
('ande','2|väsen'),
('andebesvärjare','1|andebesvärjelse'),
('andebesvärjelse','1|utdriva'),
('andedrag','1|andetag'),
('andedräkt','1|luft'),
('andefattig','1|intetsägande'),
('andefattigdom','1|andefattig'),
('andefattighet','1|andefattig'),
('andekraft','1|ande'),
('andel','1|del'),
('andel','2|delaktig'),
('andelsförening','1|förening'),
('andelös','1|ande'),
('andelöshet','1|andelös'),
('andemeddelande','1|meddelande'),
('andemening','1|mening'),
('anderike','1|rike'),
('Anderna','1|bergskedja'),
('anderöst','1|röst'),
('andeskådande','1|andeskådare'),
('andeskådare','1|kontakt'),
('andeskåderi','1|andeskådare'),
('andeskådning','1|andeskådare'),
('andestämma','1|stämma'),
('andesyn','1|syn'),
('andetag','1|andas'),
('andeuppenbarelse','1|uppenbarelse'),
('andeutdrivare','1|utdriva'),
('andevärld','1|ande'),
('andeväsen','1|ande'),
('andeögon','1|panna'),
('andfigur','1|figur'),
('andfådd','1|andas'),
('andfåddhet','1|andfådd'),
('andfågel','1|and'),
('andhål','1|hål'),
('andhämtning','1|andas'),
('andhämtningspaus','1|paus'),
('andjakt','1|jakt'),
('andlig','1|religion'),
('andligen','1|andlig'),
('andlighet','1|andlig'),
('andlös','1|uppmärksam'),
('andlöshet','1|andlös'),
('andmat','1|vattenväxt'),
('andning','1|andas'),
('andningsacidos','1|acidos'),
('andningsalkalos','1|alkalos'),
('andningsapparat','1|andningsorgan'),
('andningsapparat','2|apparat'),
('andningsbesvär','1|besvär'),
('andningsenzym','1|enzym'),
('andningsförlamning','1|förlamning'),
('andningshjälp','1|hjälp'),
('andningshål','1|hål'),
('andningshål','2|tillflyktsort'),
('andningsinsufficiens','1|insufficiens'),
('andningsljud','1|ljud'),
('andningsorgan','1|organ'),
('andningsparalys','1|paralys'),
('andningspaus','1|paus'),
('andningsreaktion','1|reaktion'),
('andningsrör','1|rör'),
('andningsrörelse','1|andning'),
('andningsskydd','1|skydd'),
('andningsstillestånd','1|stillestånd'),
('andningsstörning','1|störning'),
('andningssvikt','1|svikta'),
('andningssvårighet','1|svårighet'),
('andningsuppehåll','1|uppehåll'),
('andningsväg','1|väg'),
('andningsvägar','1|luftstrupe'),
('andnöd','1|andas'),
('Andorra','1|land'),
('andorran','1|Andorra'),
('andorransk','1|Andorra'),
('andorranska','1|andorran'),
('andouillette','1|inälvskorv'),
('andra','1|framföra'),
('andra','2|två'),
('andrabas','1|bas'),
('andrabas','1|bas'),
('andrabas','2|sångare'),
('andrabas','2|sångare'),
('andrabil','1|bil'),
('andraderivata','1|derivata'),
('andrag','1|registerknapp'),
('andragande','1|andra'),
('andragradsekvation','1|ekvation'),
('andrahandsbutik','1|butik'),
('andrahandscitat','1|citat'),
('andrahandsfaktor','1|faktor'),
('andrahandsföremål','1|föremål'),
('andrahandsinformation','1|information'),
('andrahandskälla','1|källa'),
('andrahandsuppgift','1|uppgift'),
('andrahandsval','1|val'),
('andrahandsvärde','1|värde'),
('andrake','1|and'),
('andrake','2|anka'),
('andraklassbiljett','1|tågbiljett'),
('andraklasspassagerare','1|passagerare'),
('andraopponent','1|opponent'),
('andraplacering','1|placering'),
('andraplans','1|oviktig'),
('andraplats','1|plats'),
('andraslagsförmåga','1|vedergällningsförmåga'),
('andratenor','1|tenor'),
('andratenor','1|tenor'),
('andratenor','2|sångare'),
('andratenor','2|sångare'),
('andratidning','1|tidning'),
('andreaskors','1|kors'),
('andrechef','1|chef'),
('andreopponent','1|opponent'),
('androblastom','1|tumör'),
('androfani','1|virilism'),
('androfobi','1|fientlighet'),
('androgener','1|könshormon'),
('androgenokänslighetssyndrom','1|hormonrubbning'),
('androgyn','1|tvåkönad'),
('androgyn','2|androgyn'),
('androgynhet','1|androgyn'),
('android','1|människoliknande'),
('android','2|mobiltelefon'),
('android','2|mobiltelefon'),
('androidlur','1|android'),
('androidlur','1|android'),
('androidmobil','1|android'),
('androidmobil','1|android'),
('Andromeda','1|stjärnbild'),
('andrum','1|vila'),
('andryg','1|högfärdig'),
('andryghet','1|andryg'),
('andsträck','1|fågelsträck'),
('andtruten','1|andfådd'),
('andtrutenhet','1|andtruten'),
('andtäppa','1|andnöd'),
('andtäppt','1|andtäppa'),
('andur','1|skida'),
('andäktig','1|högtidlig'),
('andäktighet','1|andäktig'),
('anekdot','1|historia'),
('anekdotartad','1|anekdot'),
('anekdotberättare','1|berättare'),
('anekdotflora','1|flora'),
('anekdotisk','1|anekdot'),
('anekdotsamling','1|anekdot'),
('anemi','1|blodbrist'),
('anemisk','1|anemi'),
('anemometer','1|mäta'),
('anemon','1|sippa'),
('anencefali','1|missbildning'),
('aneroidbarometer','1|barometer'),
('anestesi','1|bedöva'),
('anestesiolog','1|narkosläkare'),
('anestesiologi','1|vetenskap'),
('anestesirum','1|rum'),
('anestetika','1|bedövningsmedel'),
('anestetisk','1|bedövning'),
('anetoderma','1|hudsjukdom'),
('aneuploidi','1|kromosomavvikelse'),
('aneurysm','1|blodkärlsbråck'),
('anfader','1|förfader'),
('anfall','1|anfalla'),
('anfall','2|sjukdom'),
('anfalla','1|mot'),
('anfallande','1|anfalla'),
('anfallare','1|anfallsspelare'),
('anfallsbas','1|bas'),
('anfallsfront','1|front'),
('anfallskrig','1|krig'),
('anfallslinje','1|linje'),
('anfallsmässig','1|anfall'),
('anfallsområde','1|volleyboll'),
('anfallsrörelse','1|anfall'),
('anfallssignal','1|signal'),
('anfallsspel','1|spel'),
('anfallsspelare','1|fotbollsspelare'),
('anfallsvapen','1|vapen'),
('anfallsvinkel','1|flygplansvinge'),
('anfallsvåg','1|våg'),
('anfang','1|initial'),
('anfart','1|förbindelsegång'),
('anflog','1|mineralöverdrag'),
('anflygning','1|flyg'),
('anfordran','1|uppmaning'),
('anfräta','1|fräta'),
('anfrätande','1|anfräta'),
('anfrätning','1|anfräta'),
('anfrätt','1|anfräta'),
('anfäkta','1|plåga'),
('anfäkta','2|fan_anamma'),
('anfäktad','1|anfäkta'),
('anfäktande','1|anfäkta'),
('anfäktelse','1|anfäktad'),
('anfäktning','1|anfäkta'),
('anföra','1|säga'),
('anföra','2|leda'),
('anförande','1|anföra'),
('anförande','2|anföra'),
('anförare','1|anföra'),
('anförarförmåga','1|förmåga'),
('anförarskap','1|anförare'),
('anförarskicklighet','1|skicklighet'),
('anföring','1|anföra'),
('anföringssats','1|sats'),
('anföringstecken','1|skrivtecken'),
('anföringsverb','1|verb'),
('anförtro','1|lita'),
('anförtro','2|berätta'),
('anförtroende','1|anförtro'),
('anförtroende','2|anförtro'),
('anförvant','1|släkting'),
('anförvantskap','1|anförvant'),
('ange','1|visa'),
('ange','2|förråda'),
('ange','3|meddela'),
('angel','1|fiskkrok'),
('angelologi','1|lära'),
('angelägen','1|vilja'),
('angelägen','2|viktig'),
('angelägenhet','1|angelägen'),
('angelägenhet','2|angå'),
('angenäm','1|bra'),
('angenämhet','1|angenäm'),
('Angered','1|Göteborg'),
('angina','1|halsfluss'),
('angiodysplasi','1|blödning'),
('angiofibrom','1|tumör'),
('angiografi','1|röntgen'),
('angiokeratom','1|hudförändring'),
('angioleiomyom','1|tumör'),
('angiolipom','1|tumör'),
('angiologi','1|vetenskap'),
('angiom','1|tumör'),
('angiomatos','1|angiom'),
('angiomyolipom','1|tumör'),
('angiomyom','1|tumör'),
('angiosperm','1|gömfröig'),
('angioödem','1|svullnad'),
('angit','1|inflammation'),
('angivande','1|ange'),
('angivande','2|ange'),
('angivare','1|ange'),
('angivelse','1|ange'),
('angivelse','2|ange'),
('angivelsebrott','1|brott'),
('angiveri','1|ange'),
('angiverilagen','1|lag'),
('angla','1|fiska'),
('anglande','1|angla'),
('anglicism','1|engelska'),
('anglicistisk','1|anglicism'),
('anglifiera','1|anglisera'),
('anglifierande','1|anglifiera'),
('anglifierbar','1|anglifiera'),
('anglifierbarhet','1|anglifierbar'),
('anglifiering','1|anglifiera'),
('anglikansk','1|statskyrka'),
('anglisera','1|engelsk'),
('angliserande','1|anglisera'),
('angliserbar','1|anglisera'),
('angliserbarhet','1|angliserbar'),
('anglisering','1|anglisera'),
('anglist','1|språkvetare'),
('angloamerikansk','1|amerikansk'),
('anglosaxare','1|folk'),
('anglosaxare','1|folk'),
('anglosaxare','1|folk'),
('anglosaxare','1|folk'),
('anglosaxisk','1|engelsk'),
('anglosaxisk','1|engelsk'),
('anglosaxisk','1|engelsk'),
('anglosaxisk','1|engelsk'),
('angläs','1|dans'),
('Angola','1|land'),
('angolan','1|Angola'),
('angolansk','1|Angola'),
('angolanska','1|angolan'),
('angoragarn','1|garn'),
('angoraget','1|get'),
('angorajumper','1|jumper'),
('angorakatt','1|katt'),
('angoraull','1|ull'),
('angostura','1|likör'),
('angrepp','1|angripa'),
('angreppsmål','1|mål'),
('angreppspunkt','1|punkt'),
('angreppssätt','1|sätt'),
('angripa','1|anfalla'),
('angripa','2|skada'),
('angripa','3|behandla'),
('angripande','1|angripa'),
('angripande','2|angripa'),
('angripare','1|angripa'),
('angripbar','1|angripa'),
('angränsa','1|gräns'),
('angränsande','1|nära'),
('angränsande','2|angränsa'),
('angå','1|vid'),
('angående','1|angå'),
('angöra','1|förtöja'),
('angörande','1|angöra'),
('anhalt','1|stanna'),
('anhang','1|grupp'),
('anhopa','1|samla'),
('anhopande','1|anhopa'),
('anhopning','1|anhopa'),
('anhåll','1|geringslåda'),
('anhålla','1|be'),
('anhålla','2|fängsla'),
('anhållan','1|anhålla'),
('anhållande','1|anhålla'),
('anhållande','2|anhålla'),
('anhållningsbeslut','1|beslut'),
('anhängare','1|stödja'),
('anhängarskara','1|anhängare'),
('anhängig','1|pröva'),
('anhörig','1|släkting'),
('anhörigdag','1|dag'),
('anhörighet','1|anhörig'),
('anhöriginvandring','1|invandring'),
('anhörigvård','1|vård'),
('anhörigvårdare','1|anhörigvård'),
('Aniara','1|rymdepos'),
('anilin','1|anilinfärg'),
('anilinfärg','1|färg'),
('anilinfärgad','1|färg'),
('anilinolja','1|olja'),
('anilinröd','1|röd'),
('animal','1|djur'),
('animalier','1|föda'),
('animalisk','1|djur'),
('animation','1|animerad'),
('animatör','1|filmtecknare'),
('animera','1|livlig'),
('animerad','1|bild'),
('animerande','1|animera'),
('animerbar','1|animera'),
('animerbarhet','1|animerbar'),
('animering','1|animera'),
('animism','1|besjäla'),
('animistisk','1|animism'),
('animositet','1|hätskhet'),
('aning','1|ana'),
('aningsfull','1|aning'),
('aningslös','1|naiv'),
('aningslöshet','1|aningslös'),
('aniridi','1|ögonsjukdom'),
('anis','1|krydda'),
('anisakiasis','1|parasitinfektion'),
('anisbrännvin','1|brännvin'),
('anisbröd','1|bröd'),
('aniseikoni','1|oliksynthet'),
('anisett','1|likör'),
('anisettlikör','1|likör'),
('anislikör','1|likör'),
('anisokori','1|pupill'),
('anisolja','1|olja'),
('anisometropi','1|dubbelseende'),
('anjon','1|jon'),
('anka','1|fågel'),
('anka','2|tidningsanka'),
('Ankara','1|huvudstad'),
('ankararm','1|arm'),
('ankarboj','1|boj'),
('ankarbult','1|trumbroms'),
('ankare','1|fästa'),
('ankare','1|fästa'),
('ankare','2|elmotor'),
('ankarfly','1|ankare'),
('ankarfäste','1|fäste'),
('ankargrund','1|grund'),
('ankarjärn','1|förankra'),
('ankarkabel','1|kabel'),
('ankarklys','1|klys'),
('ankarkropp','1|brofäste'),
('ankarkätting','1|kätting'),
('ankarlindning','1|ankare'),
('ankarplats','1|plats'),
('ankarplats','1|plats'),
('ankarslut','1|ända'),
('ankarspel','1|vinsch'),
('ankarstock','1|ankare'),
('ankartross','1|tross'),
('ankartåg','1|tåg'),
('ankarur','1|ur'),
('ankbonde','1|anka'),
('ankbröst','1|maträtt'),
('ankbröst','2|bröst'),
('ankdamm','1|inskränkthet'),
('ankdamm','2|damm'),
('ankel','1|fot'),
('ankelled','1|led'),
('ankellång','1|lång'),
('ankelsocka','1|socka'),
('ankism','1|Kalle_Anka'),
('ankistisk','1|ankism'),
('anklaga','1|missnöjd'),
('anklagande','1|anklaga'),
('anklagare','1|anklaga'),
('anklagelse','1|anklaga'),
('anklagelseakt','1|dokumentsamling'),
('anklagelsepunkt','1|anklagelse'),
('anklagelseskrift','1|skrift'),
('anklang','1|intresse'),
('ankläpp','1|överläpp'),
('anknyta','1|förbinda'),
('anknytande','1|anknyta'),
('anknytning','1|anknyta'),
('anknytning','2|telefonnummer'),
('ankomma','1|komma'),
('ankomma','2|ansvara'),
('ankommande','1|ankomma'),
('ankommen','1|skämd'),
('ankommenhet','1|ankommen'),
('ankomst','1|ankomma'),
('ankomstdag','1|dag'),
('ankomsthall','1|flygplats'),
('ankomstkommun','1|asylmottagning'),
('ankomstort','1|ort'),
('ankomststation','1|station'),
('ankomsttid','1|tid'),
('ankra','1|ankare'),
('ankrande','1|ankra'),
('ankring','1|ankra'),
('ankunge','1|anka'),
('ankylos','1|led'),
('ankylostomiasis','1|hakmaskinfektion'),
('ankägg','1|ägg'),
('anlag','1|begåvning'),
('anlag','2|arvsanlag'),
('anlagsbärare','1|bärare'),
('anlagstest','1|test'),
('anlagstestning','1|anlagstest'),
('anledning','1|för'),
('anlete','1|ansikte'),
('anletsdrag','1|drag'),
('anligga','1|kontakt'),
('anliggande','1|anligga'),
('anliggning','1|anligga'),
('anliggningspunkt','1|punkt'),
('anliggningsyta','1|yta'),
('anlita','1|använda'),
('anlitande','1|anlita'),
('anlopp','1|anfall'),
('anloppshamn','1|anlöpa'),
('anlupen','1|rostig'),
('anlupenhet','1|anlupen'),
('anlägga','1|bygga'),
('anlägga','2|starta'),
('anläggande','1|anlägga'),
('anläggande','2|anlägga'),
('anläggare','1|anlägga'),
('anläggning','1|anlägga'),
('anläggning','2|anlägga'),
('anläggningsarbetare','1|anlägga'),
('anläggningskostnad','1|kostnad'),
('anläggningsplats','1|hamn'),
('anläggningstillgång','1|tillgångar'),
('anläggningsyta','1|anliggningsyta'),
('anländ','1|anlända'),
('anlända','1|komma'),
('anländande','1|anlända'),
('anlöpa','1|ankomma'),
('anlöpa','2|stål'),
('anlöpande','1|anlöpa'),
('anlöpande','2|anlöpa'),
('anlöpning','1|anlöpa'),
('anlöpning','2|anlöpa'),
('anlöpningshamn','1|hamn'),
('anmana','1|uppmana'),
('anmanande','1|anmana'),
('anmaning','1|anmana'),
('anmarsch','1|marsch'),
('anmarschering','1|marschera_an'),
('anmoda','1|uppmana'),
('anmodan','1|anmoda'),
('anmodande','1|anmoda'),
('anmoder','1|mor'),
('anmäla','1|meddela'),
('anmäla','2|recensera'),
('anmälan','1|anmäla'),
('anmälan','2|anmäla'),
('anmälande','1|anmäla'),
('anmälande','2|anmäla'),
('anmälare','1|anmäla'),
('anmälning','1|anmäla'),
('anmälningsbenägenhet','1|benägenhet'),
('anmälningsplikt','1|plikt'),
('anmälningspliktig','1|anmälningsplikt'),
('anmälningsskyldig','1|skyldig'),
('anmälningstid','1|tidpunkt'),
('anmärka','1|påpeka'),
('anmärka','2|yttra'),
('anmärkande','1|anmärka'),
('anmärkande','2|anmärka'),
('anmärkare','1|anmärka'),
('anmärkare','2|anmärka'),
('anmärkning','1|anmärka'),
('anmärkning','2|anmärka'),
('anmärkningsbok','1|lista'),
('anmärkningsvärd','1|intressant'),
('anmärkningsvärdhet','1|anmärkningsvärd'),
('Ann','1|Anna'),
('ann','1|annan'),
('annaler','1|historia'),
('annalist','1|annaler'),
('annalkande','1|närma_sig'),
('annalkande','2|närma_sig'),
('annalskrivning','1|annaler'),
('annan','1|PRIM'),
('annandag','1|helgdag'),
('annanstans','1|plats'),
('Annapolis','1|huvudstad'),
('annars','1|annan'),
('annatto','1|livsmedelsfärg'),
('Anne','1|Anna'),
('annektera','1|besätta'),
('annekterande','1|annektera'),
('annekterbar','1|annektera'),
('annekterbarhet','1|annekterbar'),
('annektering','1|annektera'),
('Anneli','1|Anna'),
('Anneliese','1|Lisa'),
('Anne-Sophie','1|Sofia'),
('annex','1|sidobyggnad'),
('annex','2|tillägg'),
('annexförsamling','1|dotterförsamling'),
('annexion','1|annektera'),
('annexion','1|annektera'),
('annexionspolitik','1|politik'),
('annexkyrka','1|kyrka'),
('annihilation','1|annihilera'),
('annihilera','1|förinta'),
('annihilerande','1|annihilera'),
('annihilerbar','1|annihilera'),
('annihilerbarhet','1|annihilerbar'),
('annihilering','1|annihilera'),
('anno','1|år'),
('annons','1|meddela'),
('annonsblad','1|reklam'),
('annonsbojkott','1|bojkott'),
('annonsbyrå','1|reklam'),
('annonsera','1|annons'),
('annonsera','2|tala_om'),
('annonserande','1|annonsera'),
('annonserande','2|annonsera'),
('annonserbar','1|annonsera'),
('annonserbar','2|annonsera'),
('annonserbarhet','1|annonserbar'),
('annonserbarhet','2|annonserbar'),
('annonsering','1|annonsera'),
('annonsering','2|annonsera'),
('annonsinkomst','1|inkomst'),
('annonskampanj','1|kampanj'),
('annonspelare','1|pelare'),
('annonsplats','1|plats'),
('annonssvar','1|svar'),
('annonstavla','1|tavla'),
('annonstidning','1|tidning'),
('annonsör','1|annonsera'),
('annorledes','1|annorlunda'),
('annorlunda','1|sätt'),
('annorlunda','2|annorlunda'),
('annorstädes','1|annanstans'),
('annotation','1|annotera'),
('annotationsbok','1|anteckningsblock'),
('annotera','1|anteckna'),
('annoterande','1|annotera'),
('annoterbar','1|annotera'),
('annoterbarhet','1|annoterbar'),
('annotering','1|annotera'),
('annuell','1|växt'),
('annuitet','1|avbetalning'),
('annuitetslån','1|lån'),
('annuitetslån','1|lån'),
('annullera','1|upphäva'),
('annullerande','1|annullera'),
('annullerbar','1|annullera'),
('annullerbarhet','1|annullerbar'),
('annullering','1|annullera'),
('anod','1|elektrod'),
('anodisera','1|elektrolys'),
('anodiserande','1|anodisera'),
('anodiserbar','1|anodisera'),
('anodiserbarhet','1|anodiserbar'),
('anodisering','1|anodisera'),
('anodonti','1|tand'),
('anoftalmi','1|öga'),
('anomal','1|anomali'),
('anomal','1|anomali'),
('anomali','1|orimlighet'),
('anomalistisk','1|anomali'),
('anomi','1|normlöshet'),
('anonym','1|namn'),
('anonym','2|obemärkt'),
('anonymhet','1|anonym'),
('anonymhet','2|anonym'),
('anonymisera','1|anonym'),
('anonymiserande','1|anonymisera'),
('anonymiserbar','1|anonymisera'),
('anonymiserbarhet','1|anonymiserbar'),
('anonymisering','1|anonymisera'),
('anonymiseringsverktyg','1|verktyg'),
('anonymitet','1|anonym'),
('anonymitet','2|anonym'),
('anor','1|släkthistoria'),
('anor','2|tradition'),
('anorak','1|jacka'),
('anordna','1|ordna'),
('anordnande','1|anordna'),
('anordnare','1|anordna'),
('anordning','1|anordna'),
('anordning','2|sak'),
('anorektiker','1|anorexi'),
('anorektisk','1|anorexi'),
('anorektiskhet','1|anorektisk'),
('anorexi','1|ätstörning'),
('anorexihets','1|hets'),
('anormal','1|onormal'),
('anosmi','1|luktsinne'),
('anoxemi','1|syrebrist'),
('anoxi','1|syrebrist'),
('anpart','1|andel'),
('anpassa','1|passa'),
('anpassande','1|anpassa'),
('anpassbar','1|anpassa'),
('anpassbarhet','1|anpassbar'),
('anpasslig','1|anpassa'),
('anpasslighet','1|anpasslig'),
('anpassling','1|medlöpare'),
('anpassning','1|anpassa'),
('anpassningsbar','1|anpassbar'),
('anpassningsförmåga','1|förmåga'),
('anpassningsgrupp','1|problem'),
('anpassningsklinik','1|skola'),
('anrik','1|anor'),
('anrika','1|öka'),
('anrikande','1|anrika'),
('anrikhet','1|anrik'),
('anrikning','1|anrika'),
('anrikningsanläggning','1|anläggning'),
('anrop','1|anropa'),
('anropa','1|kalla'),
('anropande','1|anropa'),
('anropning','1|anropa'),
('anropsknapp','1|knapp'),
('anropsnummer','1|nummer'),
('anropssignal','1|signal'),
('anryckning','1|framryckning'),
('anrätta','1|tillaga'),
('anrättande','1|anrätta'),
('anrättning','1|maträtt'),
('ans','1|ansa'),
('ansa','1|vårda'),
('ansamla','1|samla'),
('ansamlande','1|ansamla'),
('ansamling','1|ansamla'),
('ansande','1|ansa'),
('ansats','1|början'),
('ansatsbana','1|bana'),
('ansatsrör','1|talorgan'),
('anse','1|tänka'),
('ansedd','1|anseende'),
('anseddhet','1|ansedd'),
('ansedel','1|anor'),
('anseende','1|tycka'),
('anseende','2|anse'),
('ansenlig','1|avsevärd'),
('ansenlighet','1|ansenlig'),
('Ansgar','1|missionär'),
('ansikte','1|huvud'),
('ansiktsasymmetri','1|asymmetri'),
('ansiktsbehandling','1|behandling'),
('ansiktsbehåring','1|behåring'),
('ansiktsbjudning','1|fosterläge'),
('ansiktsblind','1|oförmögen'),
('ansiktsblindhet','1|oförmåga'),
('ansiktscancer','1|cancer'),
('ansiktsdermatos','1|dermatos'),
('ansiktsdrag','1|anletsdrag'),
('ansiktsform','1|form'),
('ansiktsfärg','1|färg'),
('ansiktsförlamning','1|förlamning'),
('ansiktshy','1|hy'),
('ansiktsigenkänning','1|igenkänning'),
('ansiktskräm','1|kräm'),
('ansiktslyft','1|ansiktslyftning'),
('ansiktslyftning','1|förbättra'),
('ansiktslös','1|ansikte'),
('ansiktsmask','1|mask'),
('ansiktsmask','2|kosmetika'),
('ansiktsmissbildning','1|missbildning'),
('ansiktsmuskel','1|muskel'),
('ansiktsmålning','1|målning'),
('ansiktsnerv','1|nerv'),
('ansiktsnervssjukdom','1|nervsjukdom'),
('ansiktsneuralgi','1|neuralgi'),
('ansiktsoval','1|oval'),
('ansiktsskada','1|skada'),
('ansiktsskydd','1|skydd'),
('ansiktssmärta','1|smärta'),
('ansiktstumör','1|tumör'),
('ansiktsuttryck','1|uttryck'),
('ansjovis','1|skarpsill'),
('anskaffa','1|skaffa'),
('anskaffande','1|anskaffa'),
('anskaffare','1|anskaffa'),
('anskaffbar','1|anskaffa'),
('anskaffning','1|anskaffa'),
('anskaffningsdag','1|dag'),
('anskaffningskostnad','1|kostnad'),
('anskri','1|skrik'),
('anskriven','1|anseende'),
('anskrämlig','1|ful'),
('anskrämlighet','1|anskrämlig'),
('anslag','1|anslå'),
('anslag','2|anslå'),
('anslag','3|upptakt'),
('anslagsbegäran','1|begäran'),
('anslagsbeviljande','1|bevilja'),
('anslagsbevillning','1|bevillning'),
('anslagsframställning','1|begäran'),
('anslagsfråga','1|fråga'),
('anslagsgivande','1|anslagsbeviljande'),
('anslagsmässig','1|anslag'),
('anslagssumma','1|anslag'),
('anslagstavla','1|tavla'),
('anslagstid','1|tid'),
('anslagsäskande','1|begära'),
('ansluta','1|förena'),
('ansluta','2|koppla'),
('anslutande','1|ansluta'),
('anslutande','2|ansluta'),
('anslutning','1|ansluta'),
('anslutning','2|ansluta'),
('anslutningsavtal','1|avtal'),
('anslutningsbox','1|box'),
('anslutningskabel','1|kabel'),
('anslutningskontakt','1|kontakt'),
('anslutningspunkt','1|punkt'),
('anslutningsserver','1|server'),
('anslutningssladd','1|sladd'),
('anslå','1|bidra'),
('anslå','2|meddela'),
('anslående','1|imponerande'),
('anslående','2|slå_an'),
('anslående','3|anslå'),
('anslående','4|anslå'),
('ansning','1|ansa'),
('anspann','1|hästspann'),
('anspela','1|antyda'),
('anspelande','1|anspela'),
('anspelning','1|anspela'),
('anspråk','1|kräva'),
('anspråklös','1|anspråk'),
('anspråksfull','1|anspråk'),
('anspråksfullhet','1|anspråksfull'),
('anspråkslös','1|anspråk'),
('anspråkslöshet','1|anspråkslös'),
('anspänd','1|spänd'),
('anspändhet','1|anspänd'),
('anspänning','1|anspänd'),
('anstalt','1|institution'),
('anstalta','1|anstalter'),
('anstaltande','1|anstalta'),
('anstalter','1|åtgärd'),
('anstaltspastor','1|pastor'),
('anstaltsvistelse','1|vistelse'),
('anstaltsvård','1|sjukvård'),
('anstifta','1|vålla'),
('anstiftan','1|anstifta'),
('anstiftande','1|anstifta'),
('anstiftare','1|anstifta'),
('anstiftelse','1|anstiftan'),
('anstorma','1|anfalla'),
('anstormande','1|anstorma'),
('anstormning','1|strömma'),
('anstruken','1|åsikt'),
('anstrukenhet','1|anstruken'),
('anstryka','1|måla'),
('anstrykande','1|anstryka'),
('anstrykare','1|pensel'),
('anstrykning','1|anstryka'),
('anstrykning','2|nyans'),
('anstränga','1|arbeta'),
('ansträngande','1|anstränga'),
('ansträngande','2|anstränga'),
('ansträngd','1|anstränga'),
('ansträngdhet','1|ansträngd'),
('ansträngning','1|anstränga'),
('ansträngningsinkontinens','1|inkontinens'),
('anstucken','1|påverkad'),
('anstuckenhet','1|anstucken'),
('anstå','1|skjuta_upp'),
('anstå','2|passa'),
('anstående','1|anstå'),
('anstående','2|anstå'),
('anstånd','1|anstå'),
('anståndstid','1|tid'),
('anställa','1|arbete'),
('anställa','2|sätta_igång'),
('anställande','1|anställa'),
('anställande','2|anställa'),
('anställare','1|anställa'),
('anställare','2|anställa'),
('anställd','1|anställa'),
('anställning','1|anställa'),
('anställningsavtal','1|avtal'),
('anställningsbar','1|anställa'),
('anställningsbar','1|anställa'),
('anställningsintervju','1|intervju'),
('anställningskommitté','1|kommitté'),
('anställningskontrakt','1|kontrakt'),
('anställningsrättighet','1|rättighet'),
('anställningsskydd','1|skydd'),
('anställningsstopp','1|stopp'),
('anställningstid','1|tidsperiod'),
('anställningstrygghet','1|trygghet'),
('anställningsvillkor','1|villkor'),
('anständig','1|passande'),
('anständighet','1|anständig'),
('anständighetsbegrepp','1|anständighet'),
('anständigtvis','1|anständig'),
('anstöt','1|förarga'),
('anstötlig','1|anstöt'),
('anstötlighet','1|anstötlig'),
('ansvar','1|skyldighet'),
('ansvara','1|ansvar'),
('ansvarande','1|ansvara'),
('ansvarig','1|ansvar'),
('ansvarighet','1|ansvarig'),
('ansvarighetsförsäkring','1|ansvarsförsäkring'),
('ansvaring','1|ansvarig'),
('ansvarsbefrielse','1|befrielse'),
('ansvarsfri','1|ansvar'),
('ansvarsfrihet','1|frihet'),
('ansvarsfull','1|ansvar'),
('ansvarsfullhet','1|ansvarsfull'),
('ansvarsförsäkring','1|försäkring'),
('ansvarskännande','1|ansvar'),
('ansvarskännande','2|ansvar'),
('ansvarskänsla','1|ansvar'),
('ansvarslös','1|ansvar'),
('ansvarslöshet','1|ansvarslös'),
('ansvarsnämnd','1|nämnd'),
('ansvarsområde','1|ansvar'),
('ansvarspåföljd','1|straff'),
('ansvarsskyldig','1|ansvar'),
('ansvarsskyldighet','1|skyldighet'),
('ansvarstagande','1|ansvar'),
('ansvarstagande','2|ansvar'),
('ansvarstalan','1|talan'),
('ansvarsutkrävande','1|utkrävande'),
('ansvarsyrkande','1|yrkande'),
('ansvälla','1|svälla'),
('ansvällande','1|ansvälla'),
('ansvälld','1|svälla'),
('ansvälldhet','1|ansvälld'),
('ansvällning','1|ansvälla'),
('ansätta','1|plåga'),
('ansättande','1|ansätta'),
('ansättning','1|ansätta'),
('ansättningsskruv','1|skruv'),
('ansöka','1|be'),
('ansökan','1|ansöka'),
('ansökande','1|ansöka'),
('ansökarland','1|land'),
('ansökning','1|ansöka'),
('ansökningshandling','1|handling'),
('ansökningspapper','1|ansökningshandling'),
('ansökningstid','1|tidpunkt'),
('ansökningstryck','1|söktryck'),
('anta','1|förmoda'),
('anta','2|ta'),
('antabus','1|medicin'),
('antagande','1|anta'),
('antagande','2|anta'),
('antaglig','1|trolig'),
('antagligen','1|troligen'),
('antaglighet','1|antaglig'),
('antagning','1|anta'),
('antagningsbevis','1|bevis'),
('antagonism','1|motsättning'),
('antagonist','1|antagonism'),
('antagonistisk','1|antagonist'),
('antal','1|mången'),
('antalsberäkning','1|beräkna'),
('antalsmässig','1|antal'),
('Antarktis','1|världsdel'),
('Antarktisfördraget','1|fördrag'),
('antarktisk','1|Antarktis'),
('Antarktisprojekt','1|projekt'),
('antasta','1|ofreda'),
('antastande','1|antasta'),
('antavla','1|stamtavla'),
('antecedentia','1|liv'),
('antecedentier','1|antecedentia'),
('antecipation','1|antecipera'),
('antecipativ','1|antecipera'),
('antecipera','1|föregripa'),
('anteciperande','1|antecipera'),
('anteciperbar','1|antecipera'),
('anteciperbarhet','1|anteciperbar'),
('antecipering','1|antecipera'),
('anteckna','1|skriva'),
('antecknande','1|anteckna'),
('antecknare','1|anteckna'),
('anteckning','1|anteckna'),
('anteckningsblock','1|block'),
('anteckningsbok','1|bok'),
('antedatera','1|datum'),
('antedaterande','1|antedatera'),
('antedaterbar','1|antedatera'),
('antedaterbarhet','1|antedaterbar'),
('antedatering','1|antedatera'),
('antediluviansk','1|urmodig'),
('antefix','1|takfot'),
('antenn','1|uppfånga'),
('antenn','2|känselspröt'),
('antennkabel','1|kabel'),
('antennkörtel','1|körtel'),
('antennuttag','1|uttag'),
('antependium','1|förhänge'),
('antepenultima','1|stavelse'),
('anti','1|mot'),
('antiabortlag','1|lag'),
('antiamerikansk','1|USA'),
('antibakteriell','1|bakterie'),
('antibarbarus','1|lärobok'),
('antibiotika','1|medicin'),
('antibiotika','1|medicin'),
('antibiotikabehandling','1|behandling'),
('antibiotikaresistens','1|antibiotikaresistent'),
('antibiotikaresistent','1|resistent'),
('antibiotisk','1|antibiotika'),
('antichambrera','1|lobby'),
('antichambrerande','1|antichambrera'),
('antichambrerbar','1|antichambrera'),
('antichambrerbarhet','1|antichambrerbar'),
('antichambrering','1|antichambrera'),
('anticyklon','1|högtryck'),
('antidemokrat','1|antidemokratisk'),
('antidemokratisk','1|demokratisk'),
('antidepressiv','1|medicin'),
('antidiskrimineringsbyrå','1|byrå'),
('antidot','1|motgift'),
('antielitistisk','1|elitism'),
('antietablissemangsretorik','1|retorik'),
('antieuropeisk','1|Europa'),
('antiexpressionistisk','1|expressionism'),
('antifascistisk','1|fascism'),
('antifoni','1|växelsång'),
('antifosfolipidsyndrom','1|immunsystemrubbning'),
('antifundamentalistisk','1|fundamentalism'),
('anti-gbm-sjukdom','1|immunsystemrubbning'),
('antigen','1|antikropp'),
('Antigua','1|ö'),
('antiguan','1|Antigua_och_Barbuda'),
('antiguansk','1|Antigua_och_Barbuda'),
('antiguanska','1|antiguan'),
('antihelix','1|öronmussla'),
('antihistamin','1|medicin'),
('antihjälte','1|hjälte'),
('antihumanistisk','1|humanism'),
('antiidealistisk','1|idealism'),
('antiimperialistisk','1|imperialism'),
('antiindividualistisk','1|individualism'),
('antiinflammatorisk','1|inflammation'),
('antiintellektualism','1|antiintellektuell'),
('antiintellektualistisk','1|antiintellektualism'),
('antiintellektuell','1|praktisk'),
('antiislamistisk','1|islamism'),
('antijudisk','1|antisemitisk'),
('antik','1|forntida'),
('antik','2|gammal'),
('antikbehandla','1|behandla'),
('antikbehandlande','1|antikbehandla'),
('antiken','1|epok'),
('antikfynda','1|fynda'),
('antikfyndande','1|antikfynda'),
('antikisera','1|antik'),
('antikiserande','1|antikisera'),
('antikiserbar','1|antikisera'),
('antikiserbarhet','1|antikiserbar'),
('antikisering','1|antikisera'),
('antiklerikal','1|kyrka'),
('antiklimax','1|klimax'),
('antiklinal','1|veckning'),
('antikljus','1|ljus'),
('antikommunism','1|kommunism'),
('antikommunistisk','1|antikommunism'),
('antikonceptionell','1|befruktning'),
('antikorruptionsaktivist','1|aktivist'),
('antikorruptionskonferens','1|konferens'),
('Antikrist','1|antikrist'),
('antikrist','1|Kristus'),
('antikristlig','1|kristlig'),
('antikropp','1|kropp'),
('antikroppsbrist','1|brist'),
('antiksamling','1|konstsamling'),
('antikva','1|tryck'),
('antikvariat','1|bokhandel'),
('antikvarie','1|kulturminnesvård'),
('antikvarisk','1|antikvariat'),
('antikvarisk','2|forntida'),
('antikverad','1|föråldrad'),
('antikvitet','1|föremål'),
('antikvitetshandel','1|affär'),
('antikvitetshandlare','1|handlare'),
('antikvitetsjägare','1|leta'),
('antikvitetssamling','1|samling'),
('antikvärde','1|värde'),
('Antillerna','1|Västindien'),
('antilop','1|djur'),
('antimakass','1|möbelöverdrag'),
('antimateria','1|materia'),
('antimilitarism','1|militarism'),
('antimilitarist','1|antimilitarism'),
('antimilitaristisk','1|antimilitarism'),
('antimon','1|grundämne'),
('antimon','1|grundämne'),
('antimonglans','1|antimon'),
('antimögelbehandlad','1|behandla'),
('antinazistisk','1|nazistisk'),
('antingen','1|eller'),
('antinomi','1|motsägelse'),
('antioxidant','1|oxidera'),
('antioxidationsmedel','1|medel'),
('antipartikel','1|partikel'),
('antipassad','1|vind'),
('antipati','1|motvilja'),
('antipatisk','1|antipati'),
('antipod','1|punkt'),
('antipodisk','1|antipod'),
('antipolitisk','1|politik'),
('antipsykiatri','1|psykiatri'),
('antirasistisk','1|rasism'),
('antireflexbehandla','1|behandla'),
('antireligiös','1|religion'),
('antirojalistisk','1|rojalistisk'),
('antirullningsfena','1|metallfena'),
('antirynkkräm','1|kräm'),
('antisemit','1|jude'),
('antisemitisk','1|antisemit'),
('antisemitism','1|antisemit'),
('antisemitledare','1|ledare'),
('antiseptik','1|antiseptisk'),
('antiseptika','1|antiseptisk'),
('antiseptisk','1|bakteriedödande'),
('antisionism','1|antisemitism'),
('antisionistisk','1|antisionism'),
('antiskating','1|skivspelare'),
('antisladdsystem','1|system'),
('antistatisk','1|skydd'),
('antistatmedel','1|medel'),
('antisyrisk','1|syrisk'),
('antites','1|tes'),
('antitetisk','1|motsatt'),
('antitoxin','1|motgift'),
('antitragus','1|örflik'),
('antivibrationshandtag','1|handtag'),
('antiviral','1|virus'),
('antivirusexpert','1|expert'),
('antivirusprogram','1|program'),
('antiålderskräm','1|antirynkkräm'),
('antologi','1|bok'),
('antonym','1|ord'),
('antonym','2|antonym'),
('antracit','1|stenkol'),
('antracitkol','1|antracit'),
('antrakos','1|dammlunga'),
('antrakosilikos','1|koldammslunga'),
('antrax','1|mjältbrand'),
('antropisk','1|mänsklig'),
('antropocentrisk','1|centrum'),
('antropofag','1|kannibal'),
('antropofagi','1|antropofag'),
('antropoid','1|apa'),
('antropolog','1|antropologi'),
('antropologi','1|vetenskap'),
('antropologisk','1|antropologi'),
('antropomorf','1|människoliknande'),
('antropomorfisk','1|antropisk'),
('antropomorfism','1|antropomorf'),
('antropomorfistisk','1|antropomorfism'),
('antroposof','1|antroposofi'),
('antroposofi','1|åskådning'),
('antroposofisk','1|antroposofi'),
('anträda','1|påbörja'),
('anträdande','1|anträda'),
('anträde','1|anträda'),
('anträffa','1|träffa'),
('anträffande','1|anträffa'),
('anträffbar','1|träffa'),
('anträffbarhet','1|anträffbar'),
('antvarda','1|överantvarda'),
('antvardande','1|antvarda'),
('antyda','1|säga'),
('antydan','1|antyda'),
('antydande','1|antyda'),
('antydning','1|antyda'),
('antydningsvis','1|antydning'),
('antåg','1|antåga'),
('antåga','1|närma_sig'),
('antågande','1|antåga'),
('antända','1|tända'),
('antändande','1|antända'),
('antändbar','1|antända'),
('antändbarhet','1|antändbar'),
('antändning','1|antända'),
('anuri','1|njursjukdom'),
('anus','1|ändtarm'),
('anvisa','1|visa'),
('anvisa','2|tilldela'),
('anvisande','1|anvisa'),
('anvisande','2|anvisa'),
('anvisning','1|anvisa'),
('anvisning','2|anvisa'),
('anvisningskommun','1|asylmottagning'),
('anvisningsläkare','1|läkare'),
('använd','1|använda'),
('använda','1|med'),
('användande','1|använda'),
('användare','1|använda'),
('användargrupp','1|internetanvändare'),
('användarvänlig','1|lämplig'),
('användarvänlighet','1|användarvänlig'),
('användbar','1|använda'),
('användbarhet','1|användbar'),
('användbarhetsaspekt','1|användbarhet'),
('användning','1|använda'),
('användningslösning','1|lösning'),
('användningsmöjlighet','1|möjlighet'),
('användningsområde','1|område'),
('användningssätt','1|användning'),
('aorist','1|tempus'),
('aorta','1|blodåder'),
('aortaaneurysm','1|aneurysm'),
('aortabristning','1|bristning'),
('aortabråck','1|bråck'),
('aortabåge','1|båge'),
('aortabågesyndrom','1|kärlsjukdom'),
('aortadissektion','1|dissektion'),
('aortaförträngning','1|förträngning'),
('aortainflammation','1|inflammation'),
('aortainsufficiens','1|insufficiens'),
('aortaklaff','1|klaff'),
('aortaklaffinsufficiens','1|insufficiens'),
('aortaklaffläckage','1|läckage'),
('aortaklaffprolaps','1|prolaps'),
('aortaklaffstenos','1|stenos'),
('aortaklafförträngning','1|förträngning'),
('aortakoarktation','1|koarktation'),
('aortaruptur','1|ruptur'),
('aortasjukdom','1|sjukdom'),
('aortastenos','1|stenos'),
('aortit','1|inflammation'),
('aortit-syndrom','1|kärlsjukdom'),
('apa','1|djur'),
('apa','2|segel'),
('apa','3|djurisk'),
('apa','4|dålig'),
('apache','1|indianstam'),
('apanage','1|underhåll'),
('apanagebelopp','1|apanage'),
('apart','1|art'),
('apart','2|egendomlig'),
('apartheid','1|rasdiskriminering'),
('apartheidlag','1|lag'),
('apartheidregim','1|regim'),
('apati','1|apatisk'),
('apatisk','1|likgiltig'),
('apatit','1|mineral'),
('apbrödsträd','1|träd'),
('apc-resistens','1|blodsjukdom'),
('apekatt','1|apa'),
('apel','1|äppelträd'),
('apelgrå','1|grå'),
('apelkastad','1|färg'),
('apelsin','1|frukt'),
('apelsingelé','1|gelé'),
('apelsinglass','1|glass'),
('apelsinjuice','1|juice'),
('apelsinklyfta','1|klyfta'),
('apelsinmarmelad','1|marmelad'),
('apelsinmousse','1|mousse'),
('apelsinmoussetårta','1|tårta'),
('apelsinsaft','1|saft'),
('apelsinskal','1|skal'),
('apelsinträd','1|träd'),
('aperi','1|apa_sig'),
('aperitif','1|aptitretare'),
('apermi','1|ofruktsamhet'),
('apertur','1|öppning'),
('apetidin','1|morfin'),
('apex','1|astronomi'),
('apex','2|flygbiljett'),
('aphelium','1|avlägsen'),
('aphelium','1|avlägsen'),
('aphjärna','1|fårskalle'),
('aphona','1|apa'),
('apkoppor','1|virussjukdom'),
('aplik','1|lik'),
('aplik','2|lik'),
('apliknande','1|apa'),
('aplomb','1|säker'),
('apmänniska','1|apa'),
('apné','1|andningsstillestånd'),
('apné','1|andningsstillestånd'),
('apodiktisk','1|oemotsäglig'),
('apogeum','1|avlägsen'),
('apokalyps','1|undergång'),
('apokalyptisk','1|apokalyps'),
('apokope','1|bortfall'),
('apokrin','1|svettkörtel'),
('apokryferna','1|Bibeln'),
('apokryfisk','1|tvivelaktig'),
('apolitisk','1|politisk'),
('apollinisk','1|harmonisk'),
('apollinisk','1|harmonisk'),
('apollofjäril','1|fjäril'),
('Apollon','1|gud'),
('Apollon','1|gud'),
('Apolloprogrammet','1|rymdprogram'),
('apologet','1|apologetik'),
('apologetik','1|försvara'),
('apologetisk','1|apologetik'),
('apologi','1|försvara'),
('apologist','1|apologi'),
('apomorfi','1|särdrag'),
('apoplektisk','1|apoplexi'),
('apoplexi','1|slaganfall'),
('apostel','1|förkunna'),
('aposteriorisk','1|erfarenhet'),
('apostlahästarna','1|till_fots'),
('apostolisk','1|apostel'),
('apostrof','1|utelämningstecken'),
('apostrof','2|hänvändelse'),
('apostrofera','1|apostrof'),
('apostroferande','1|apostrofera'),
('apostroferbar','1|apostrofera'),
('apostroferbarhet','1|apostroferbar'),
('apostrofering','1|apostrofera'),
('apotek','1|affär'),
('apotekare','1|apotek'),
('apotekskedja','1|affärskedja'),
('apotekskö','1|kö'),
('apoteksvåg','1|våg'),
('apoteksväxt','1|medicinalväxt'),
('apoteos','1|förhärligande'),
('apothesium','1|lav'),
('app','1|applikation'),
('appa','1|app'),
('Appalacherna','1|bergskedja'),
('apparans','1|utseende'),
('apparat','1|använda'),
('apparatrum','1|vårdavdelning'),
('apparatur','1|apparat'),
('apparition','1|yttre'),
('appell','1|bön'),
('appellant','1|appell'),
('appellationsdomstol','1|domstol'),
('appellativ','1|substantiv'),
('appellera','1|appell'),
('appellerande','1|appellera'),
('appellerbar','1|appellera'),
('appellerbarhet','1|appellerbar'),
('appellering','1|appellera'),
('appendicit','1|blindtarmsinflammation'),
('appendix','1|tillägg'),
('appendix','2|blindtarm'),
('appendixcancer','1|cancer'),
('appendixtumör','1|tumör'),
('apperception','1|förnimmelse'),
('applicera','1|tillämpa'),
('applicera','2|stryka_på'),
('applicerande','1|applicera'),
('applicerande','2|applicera'),
('applicerbar','1|applicera'),
('applicerbar','2|applicera'),
('applicerbarhet','1|applicerbar'),
('applicerbarhet','2|applicerbar'),
('applicering','1|applicera'),
('applikation','1|applicera'),
('applikation','2|brodera'),
('applikation','3|datorprogram'),
('applikator','1|ögonskugga'),
('applikatorisk','1|applicera'),
('applikatur','1|fingersättning'),
('applåd','1|klappa'),
('applådera','1|applåd'),
('applåderande','1|applådera'),
('applåderbar','1|applådera'),
('applåderbarhet','1|applåderbar'),
('applådering','1|applådera'),
('applådsalva','1|applåd'),
('applådåska','1|applåd'),
('apport','1|apportera'),
('apportera','1|hämta'),
('apporterande','1|apportera'),
('apporterbar','1|apportera'),
('apporterbarhet','1|apporterbar'),
('apportering','1|apportera'),
('apposition','1|bestämning'),
('appreciera','1|valuta'),
('apprecierande','1|appreciera'),
('apprecierbar','1|appreciera'),
('apprecierbarhet','1|apprecierbar'),
('appreciering','1|appreciera'),
('appretera','1|appretyr'),
('appreterande','1|appretera'),
('appreterbar','1|appretera'),
('appreterbarhet','1|appreterbar'),
('appretering','1|appretera'),
('appretyr','1|styvhet'),
('appretyr','1|styvhet'),
('approach','1|grepp'),
('approbabel','1|godtagbar'),
('approbatur','1|godkänd'),
('approchera','1|närma_sig'),
('approcherande','1|approchera'),
('approcherbar','1|approchera'),
('approcherbarhet','1|approcherbar'),
('approchering','1|approchera'),
('approximation','1|approximera'),
('approximationsteori','1|teori'),
('approximationsvis','1|approximation'),
('approximativ','1|approximera'),
('approximera','1|ungefär'),
('approximerande','1|approximera'),
('approximerbar','1|approximera'),
('approximerbarhet','1|approximerbar'),
('approximering','1|approximera'),
('aprak','1|full'),
('apraxi','1|rörelseoförmåga'),
('aprikos','1|frukt'),
('april','1|månad'),
('aprildag','1|dag'),
('aprilskämt','1|skämt'),
('aprilsnö','1|snö'),
('aprilväder','1|väder'),
('aprilväder','2|väder'),
('apriorisk','1|förnuft'),
('apropå','1|angå'),
('apropå','2|oväntad'),
('apropå','3|påpeka'),
('apsjukdom','1|sjukdom'),
('apsort','1|apart'),
('apspel','1|gyckelspel'),
('aptera','1|färdigställa'),
('apterande','1|aptera'),
('apterbar','1|aptera'),
('apterbarhet','1|apterbar'),
('aptering','1|aptera'),
('aptit','1|äta'),
('aptitlig','1|läcker'),
('aptitlighet','1|aptitlig'),
('aptitlöshet','1|aptit'),
('aptitretande','1|aptit'),
('aptitretare','1|aptitretande'),
('apudom','1|tumör'),
('ar','1|mått'),
('ara','1|papegoja'),
('arab','1|folk'),
('arabesk','1|ornament'),
('arabeskmönster','1|arabesk'),
('Arabien','1|Saudiarabien'),
('arabisk','1|arab'),
('arabiska','1|språk'),
('arabiska','2|arab'),
('arabiskspråkig','1|arabiska'),
('arabisktalande','1|arabiska'),
('arabist','1|arabiska'),
('arabland','1|land'),
('arabvärlden','1|värld'),
('araknidism','1|spindelbett'),
('araknodaktyli','1|missbildning'),
('araknoidalcysta','1|cysta'),
('araknoidit','1|inflammation'),
('aralia','1|krukväxt'),
('arameiska','1|språk'),
('aramid','1|polyamid'),
('arbeta','1|göra'),
('arbetande','1|arbeta'),
('arbetarbostad','1|bostad'),
('arbetare','1|arbeta'),
('arbetarförening','1|förening'),
('arbetargrupp','1|grupp'),
('arbetarinstitut','1|institut'),
('arbetarklass','1|klass'),
('arbetarkommun','1|avdelning'),
('arbetarkvarter','1|kvarter'),
('arbetarparti','1|parti'),
('arbetarparti','1|parti'),
('arbetarregering','1|regering'),
('arbetarråd','1|råd'),
('arbetarrörelse','1|rörelse'),
('arbetarskydd','1|skydd'),
('arbetarskyddsstyrelse','1|styrelse'),
('arbetarstam','1|arbetare'),
('arbetarsång','1|sång'),
('arbetaruppror','1|uppror'),
('arbetarväljare','1|väljare'),
('arbete','1|arbeta'),
('arbete','2|verk'),
('arbetsam','1|arbeta'),
('arbetsamhet','1|arbetsam'),
('arbetsanstalt','1|fängelse'),
('arbetsavtal','1|avtal'),
('arbetsbas','1|bas'),
('arbetsbelastning','1|mängd'),
('arbetsbelysning','1|belysning'),
('arbetsbeskrivning','1|instruktion'),
('arbetsbesparande','1|minska'),
('arbetsbesparing','1|bespara'),
('arbetsbetyg','1|betyg'),
('arbetsbi','1|bi'),
('arbetsblus','1|blus'),
('arbetsbok','1|dokument'),
('arbetsbord','1|bord'),
('arbetsbredd','1|bredd'),
('arbetsbrist','1|brist'),
('arbetsbyte','1|byte'),
('arbetsbås','1|arbetsplats'),
('arbetsbänk','1|snickarbänk'),
('arbetsbörda','1|arbete'),
('arbetschef','1|chef'),
('arbetsdag','1|dag'),
('arbetsdelning','1|delning'),
('arbetsdjur','1|djur'),
('arbetsdomstol','1|domstol'),
('arbetsdräkt','1|dräkt'),
('arbetsdräng','1|dräng'),
('arbetsduglig','1|duglig'),
('arbetsduglighet','1|arbetsduglig'),
('arbetsfolk','1|arbetare'),
('arbetsform','1|organisation'),
('arbetsfred','1|arbetstvist'),
('arbetsfri','1|arbete'),
('arbetsfånge','1|fånge'),
('arbetsfält','1|fält'),
('arbetsför','1|förmå'),
('arbetsfördelning','1|arbetsuppgift'),
('arbetsförhet','1|arbetsför'),
('arbetsförhållande','1|förhållande'),
('arbetsförman','1|förman'),
('arbetsförmedlare','1|arbetsförmedling'),
('arbetsförmedling','1|förmedla'),
('arbetsförmåga','1|förmåga'),
('arbetsförmågeutredning','1|utredning'),
('arbetsförtjänst','1|ersättning'),
('arbetsgivaravgift','1|avgift'),
('arbetsgivare','1|anställa'),
('arbetsgivarförening','1|förening'),
('arbetsgivarförening','1|förening'),
('arbetsgivarinträde','1|sjukpenning'),
('arbetsgivarorganisation','1|organisation'),
('arbetsglädje','1|glädje'),
('arbetsgrupp','1|grupp'),
('arbetshandikapp','1|handikapp'),
('arbetshandikappad','1|handikappad'),
('arbetshandske','1|handske'),
('arbetshus','1|anstalt'),
('arbetshypotes','1|hypotes'),
('arbetshäst','1|häst'),
('arbetsinkomst','1|inkomst'),
('arbetsinrättning','1|arbetshus'),
('arbetsinsats','1|insats'),
('arbetsinställelse','1|strejk'),
('arbetsintensitet','1|intensitet'),
('arbetsintensiv','1|arbetsam'),
('arbetsintervju','1|anställningsintervju'),
('arbetsiver','1|iver'),
('arbetsjacka','1|jacka'),
('arbetskamrat','1|kamrat'),
('arbetskarl','1|arbetare'),
('arbetsklimat','1|klimat'),
('arbetskläder','1|kläder'),
('arbetskommendering','1|kommendering'),
('arbetskonflikt','1|konflikt'),
('arbetskostnad','1|kostnad'),
('arbetskraft','1|arbetare'),
('arbetskraftsintensiv','1|intensiv'),
('arbetskraftsinvandrare','1|arbetskraftsinvandring'),
('arbetskraftsinvandring','1|invandring'),
('arbetskrävande','1|kräva'),
('arbetsköpare','1|köpare'),
('arbetslag','1|arbeta'),
('arbetsledande','1|leda'),
('arbetsledare','1|ledare'),
('arbetsliv','1|arbete'),
('arbetsliv','2|liv'),
('arbetslivserfarenhet','1|erfarenhet'),
('arbetslivsfond','1|fond'),
('arbetslokal','1|lokal'),
('arbetslust','1|lust'),
('arbetsläger','1|fångläger'),
('arbetslängd','1|längd'),
('arbetslön','1|lön'),
('arbetslös','1|arbete'),
('arbetslöshet','1|arbetslös'),
('arbetslöshetsförsäkring','1|försäkring'),
('arbetslöshetsperiod','1|period'),
('arbetslöshetsstatistik','1|statistik'),
('arbetsmanskap','1|arbetare'),
('arbetsmarknad','1|marknad'),
('arbetsmarknadskonflikt','1|konflikt'),
('arbetsmarknadsminister','1|minister'),
('arbetsmarknadsmässig','1|arbetsmarknad'),
('arbetsmarknadspolitik','1|politik'),
('arbetsmarknadspolitisk','1|arbetsmarknadspolitik'),
('arbetsmarknadsstatistik','1|statistik'),
('arbetsmarknadsutbildning','1|utbildning'),
('arbetsmarknadsåtgärd','1|arbetsmarknadspolitik'),
('arbetsmaskin','1|omvandla'),
('arbetsmaterial','1|material'),
('arbetsmetod','1|metod'),
('arbetsmiljö','1|miljö'),
('arbetsmiljöbrott','1|brott'),
('arbetsmiljömål','1|mål'),
('arbetsmiljömässig','1|arbetsmiljö'),
('arbetsminne','1|datorminne'),
('arbetsminnestest','1|test'),
('arbetsmoment','1|moment'),
('arbetsmoral','1|moral'),
('arbetsmyra','1|flitig'),
('arbetsmängd','1|mängd'),
('arbetsmänniska','1|arbeta'),
('arbetsmässig','1|arbete'),
('arbetsmätning','1|arbetsstudier'),
('arbetsnamn','1|namn'),
('arbetsnarkoman','1|flitig'),
('arbetsnedläggelse','1|strejk'),
('arbetsnämnd','1|nämnd'),
('arbetsoförmögen','1|oförmögen'),
('arbetsområde','1|arbetsfält'),
('arbetsordning','1|ordning'),
('arbetsorganisation','1|organisation'),
('arbetspass','1|arbeta'),
('arbetspendla','1|pendla'),
('arbetspendlande','1|arbetspendla'),
('arbetspersonal','1|personal'),
('arbetsplan','1|plan'),
('arbetsplats','1|plats'),
('arbetsplatsolycka','1|olycka'),
('arbetsplenum','1|riksdagssammanträde'),
('arbetspremiss','1|premiss'),
('arbetsprogram','1|program'),
('arbetsprov','1|prov'),
('arbetsredskap','1|redskap'),
('arbetsrelaterad','1|relatera'),
('arbetsrelation','1|relation'),
('arbetsro','1|ostörd'),
('arbetsrum','1|rum'),
('arbetsrätt','1|lag'),
('arbetsrättslig','1|arbetsrätt'),
('arbetssal','1|sal'),
('arbetsschema','1|schema'),
('arbetsseger','1|seger'),
('arbetssituation','1|situation'),
('arbetsskada','1|skada'),
('arbetsskadad','1|arbetsskada'),
('arbetsskicklig','1|yrkesskicklig'),
('arbetsskicklighet','1|arbetsskicklig'),
('arbetsskräck','1|arbetsskygg'),
('arbetsskygg','1|skygg'),
('arbetsskygghet','1|arbetsskygg'),
('arbetsstudieman','1|arbetsstudier'),
('arbetsstudier','1|undersökning'),
('arbetsstycke','1|föremål'),
('arbetsstyrka','1|styrka'),
('arbetssång','1|sång'),
('arbetssätt','1|sätt'),
('arbetssökande','1|arbetssökande'),
('arbetssökande','2|söka'),
('arbetssökande','3|sökande'),
('arbetstagare','1|arbetare'),
('arbetstakt','1|takt'),
('arbetstemperatur','1|temperatur'),
('arbetsterapeut','1|arbetsterapi'),
('arbetsterapi','1|terapi'),
('arbetstid','1|tid'),
('arbetstidsförkortning','1|förkortning'),
('arbetstidsregel','1|arbetstidsreglering'),
('arbetstidsreglering','1|reglering'),
('arbetstillfälle','1|tillfälle'),
('arbetstillstånd','1|tillstånd'),
('arbetstimme','1|timme'),
('arbetsträna','1|träna'),
('arbetstränande','1|arbetsträna'),
('arbetsträning','1|arbetsträna'),
('arbetstvist','1|tvist'),
('arbetsuppgift','1|uppgift'),
('arbetsutskott','1|utskott'),
('arbetsvan','1|van'),
('arbetsvana','1|arbetsvan'),
('arbetsvanor','1|vana'),
('arbetsvecka','1|vecka'),
('arbetsverktyg','1|verktyg'),
('arbetsvilja','1|vilja'),
('arbetsvillig','1|villig'),
('arbetsvillighet','1|arbetsvillig'),
('arbetsvillkor','1|villkor'),
('arbetsvård','1|hjälp'),
('arbetsvärdering','1|värdering'),
('arbetsväska','1|väska'),
('arbetsår','1|år'),
('arbitrage','1|valuta'),
('arbiträr','1|godtycklig'),
('Arboga','1|stad'),
('arboretum','1|träd'),
('arborist','1|trädvård'),
('arborr','1|borr'),
('arborra','1|arborr'),
('arborrande','1|arborra'),
('arbovirusencefalit','1|hjärninflammation'),
('arbovirusinfektion','1|virusinfektion'),
('Archangelsk','1|stad'),
('Archimedes','1|matematiker'),
('arcusmoln','1|molnrulle'),
('ardenner','1|häst'),
('area','1|yta'),
('areal','1|yta'),
('arealmässig','1|areal'),
('arena','1|scen'),
('arenabygge','1|bygge'),
('arenateater','1|teater'),
('arenavirusinfektion','1|virusinfektion'),
('areometer','1|sänkvåg'),
('areopag','1|domstol'),
('Ares','1|gud'),
('arg','1|glad'),
('argbigga','1|kvinna'),
('Argentina','1|land'),
('argentinare','1|Argentina'),
('argentinsk','1|Argentina'),
('argentinska','1|argentinare'),
('arghet','1|arg'),
('argininbärnstensaciduri','1|ämnesomsättningsrubbning'),
('Argo','1|skepp'),
('argon','1|gas'),
('argon','2|grundämne'),
('argon','2|grundämne'),
('argot','1|slang'),
('argsint','1|arg'),
('argsinthet','1|argsint'),
('argument','1|skäl'),
('argument','2|funktion'),
('argumentation','1|argument'),
('argumentationsanalys','1|analys'),
('argumentativ','1|argument'),
('argumentera','1|argument'),
('argumenterande','1|argumentera'),
('argumenterbar','1|argumentera'),
('argumenterbarhet','1|argumenterbar'),
('argumentering','1|argument'),
('argumentrik','1|argument'),
('argumentrikedom','1|argumentrik'),
('Argus','1|jätte'),
('argusöga','1|blick'),
('argyri','1|hudmissfärgning'),
('arhinencefali','1|missbildning'),
('aria','1|sång'),
('ariadnetråd','1|ledtråd'),
('arian','1|arianism'),
('Arianeraket','1|raket'),
('arianism','1|sekt'),
('ariansk','1|arianism'),
('arid','1|torr'),
('Ariel','1|måne'),
('arier','1|arisk'),
('arier','2|arisk'),
('arioso','1|musik'),
('arisk','1|ras'),
('arisk','2|folk'),
('Aristofanes','1|dramatiker'),
('aristokrat','1|stånd'),
('aristokrati','1|aristokrat'),
('aristokratisk','1|aristokrat'),
('aristokratvälde','1|välde'),
('Aristoteles','1|filosof'),
('aritet','1|ställighet'),
('aritmetik','1|matematik'),
('aritmetiker','1|aritmetik'),
('aritmetisk','1|aritmetik'),
('Arizona','1|delstat'),
('ark','1|papper'),
('ark','2|Noaks_ark'),
('arkad','1|pelargång'),
('arkadgång','1|gång'),
('arkadisk','1|idyllisk'),
('arkadspel','1|spelautomat'),
('arkaisera','1|arkaisk'),
('arkaiserande','1|arkaisera'),
('arkaiserbar','1|arkaisera'),
('arkaiserbarhet','1|arkaiserbar'),
('arkaisering','1|arkaisera'),
('arkaisk','1|ålderdomlig'),
('arkaism','1|ord'),
('arkaistisk','1|arkaisk'),
('Arkansas','1|delstat'),
('arkebusera','1|avrätta'),
('arkebuserande','1|arkebusera'),
('arkebuserbar','1|arkebusera'),
('arkebuserbarhet','1|arkebuserbar'),
('arkebusering','1|arkebusera'),
('arkeikum','1|era'),
('arkeolog','1|arkeologi'),
('arkeologi','1|arkeologisk'),
('arkeologisk','1|forntid'),
('arkeologiämne','1|arkeologi'),
('arkeologkongress','1|kongress'),
('arketyp','1|urbild'),
('arketypisk','1|arketyp'),
('arkiater','1|läkare'),
('arkipelag','1|skärgård'),
('arkitekt','1|bygga'),
('arkitektonik','1|arkitektur'),
('arkitektonisk','1|arkitektur'),
('arkitektur','1|stil'),
('arkitekturpolitik','1|politik'),
('arkitekturpolitisk','1|arkitekturpolitik'),
('arkitekturritning','1|ritning'),
('arkitrav','1|tvärbjälke'),
('arkiv','1|förvara'),
('arkivalier','1|dokument'),
('arkivalieskåp','1|skåp'),
('arkivalisk','1|arkiv'),
('arkivarbetare','1|arkivarbete'),
('arkivarbete','1|arbete'),
('arkivarie','1|arkiv'),
('arkivera','1|arkiv'),
('arkiverande','1|arkivera'),
('arkiverbar','1|arkivera'),
('arkiverbarhet','1|arkiverbar'),
('arkivering','1|arkivera'),
('arkivexemplar','1|bok'),
('arkivforskning','1|forskning'),
('arkivmaterial','1|arkiv'),
('arkivolt','1|valvbåge'),
('arkivsamling','1|samling'),
('arkivstudie','1|studie'),
('arksignatur','1|tryck'),
('Arktis','1|Nordpolen'),
('arktisk','1|pol'),
('arkvis','1|ark'),
('arla','1|morgon'),
('Arlanda','1|flygplats'),
('arm','1|kropp'),
('arm','2|fattig'),
('arm','3|utskjutande'),
('armada','1|flotta'),
('armagnac','1|konjak'),
('armatur','1|belysning'),
('armband','1|smycke'),
('armbandslås','1|lås'),
('armbandsur','1|ur'),
('armbindel','1|bindel'),
('armborst','1|pilbåge'),
('armborstpil','1|pil'),
('armborstskytt','1|skytt'),
('armbrott','1|brott'),
('armbrytning','1|kraftmätning'),
('armbågande','1|armbåga_sig'),
('armbåge','1|arm'),
('armbågsben','1|ben'),
('armbågsled','1|led'),
('armbågsnerv','1|nerv'),
('armbågsrum','1|svängrum'),
('armbågsskydd','1|skydd'),
('armbågssträckare','1|muskel'),
('armbågsutskott','1|benutskott'),
('armböjning','1|armhävning'),
('armcylinder','1|grävmaskin'),
('armdyna','1|dyna'),
('armé','1|krig'),
('arméattaché','1|försvarsattaché'),
('arméavdelning','1|armé'),
('arméchef','1|chef'),
('arméförband','1|förband'),
('arméfördelning','1|armé'),
('arméförvaltning','1|förvaltning'),
('armégeneral','1|general'),
('armégevär','1|gevär'),
('arméhelikopter','1|helikopter'),
('arméhäst','1|häst'),
('armékommuniké','1|kommuniké'),
('armékår','1|förband'),
('Armenien','1|land'),
('armenier','1|Armenien'),
('armenisk','1|Armenien'),
('armeniska','1|språk'),
('armeniska','2|armenier'),
('arméorganisation','1|organisation'),
('armera','1|förstärka'),
('armera','2|beväpna'),
('armerande','1|armera'),
('armerande','2|armera'),
('armerbar','1|armera'),
('armerbar','2|armera'),
('armerbarhet','1|armerbar'),
('armerbarhet','2|armerbar'),
('armering','1|armera'),
('armering','2|armera'),
('armering','3|magnet'),
('armeringsjärn','1|armera'),
('arméstab','1|stab'),
('arméunderstöd','1|understöd'),
('armfläta','1|nerv'),
('armfoting','1|skaldjur'),
('armföring','1|rörelse'),
('armgång','1|förflytta_sig'),
('armhet','1|arm'),
('armhåla','1|arm'),
('armhålsstöd','1|axillarkrycka'),
('armhävning','1|gymnastik'),
('Arminius','1|hövding'),
('armkraft','1|kraft'),
('armkrok','1|hålla'),
('armkrokskedja','1|kedja'),
('armled','1|led'),
('armljusstake','1|ljusstake'),
('armlås','1|brottningsgrepp'),
('armlängd','1|längdmått'),
('armlängd','1|längdmått'),
('armlängd','2|längd'),
('armmudd','1|mudd'),
('armmuskel','1|muskel'),
('armod','1|arm'),
('armodslöfte','1|löfte'),
('armpolyp','1|nässeldjur'),
('armring','1|ring'),
('armrörelse','1|röra'),
('armskada','1|skada'),
('armslång','1|lång'),
('armstark','1|stark'),
('armstjock','1|tjock'),
('armstol','1|stol'),
('armsträckning','1|sträcka_ut'),
('armstump','1|stump'),
('armstyrka','1|styrka'),
('armstöd','1|stol'),
('armsvag','1|svag'),
('armsvett','1|svett'),
('armtag','1|gripa'),
('armtrakt','1|arm'),
('armveck','1|arm'),
('arom','1|lukt'),
('aromatisk','1|arom'),
('aromglas','1|glas'),
('aromkupa','1|aromglas'),
('arpeggio','1|ackord'),
('arr','1|arrangemang'),
('arra','1|arrangera'),
('arrak','1|arrakpunsch'),
('arrakpunch','1|punch'),
('arrakpunsch','1|punsch'),
('arrakspunsch','1|punsch'),
('arrakssmak','1|smak'),
('arrakstoddy','1|toddy'),
('arrangemang','1|arrangera'),
('arrangemang','2|arrangera'),
('arrangemangsmässig','1|arrangemang'),
('arrangemangsmässig','2|arrangemang'),
('arrangera','1|ordna'),
('arrangera','2|musik'),
('arrangerande','1|arrangera'),
('arrangerande','2|arrangera'),
('arrangerbar','1|arrangera'),
('arrangerbar','2|arrangera'),
('arrangerbarhet','1|arrangerbar'),
('arrangerbarhet','2|arrangerbar'),
('arrangering','1|arrangera'),
('arrangör','1|arrangera'),
('arrangörsmässig','1|arrangör'),
('arrendator','1|arrende'),
('arrende','1|hyra'),
('arrendeavgift','1|avgift'),
('arrendebelopp','1|belopp'),
('arrendekontrakt','1|kontrakt'),
('arrendera','1|arrende'),
('arrenderande','1|arrendera'),
('arrenderbar','1|arrendera'),
('arrenderbarhet','1|arrenderbar'),
('arrendering','1|arrendera'),
('arrendevillkor','1|villkor'),
('arrest','1|arrestera'),
('arrestant','1|arrest'),
('arrestavdelning','1|avdelning'),
('arrestera','1|fängsla'),
('arresterande','1|arrestera'),
('arresterbar','1|arrestera'),
('arresterbarhet','1|arresterbar'),
('arrestering','1|arrestera'),
('arresteringsorder','1|order'),
('arrestlokal','1|arrest'),
('arrestrum','1|rum'),
('arreststraff','1|straff'),
('arresttid','1|tid'),
('arriverad','1|karriär'),
('arrivist','1|arriverad'),
('arriärgarde','1|eftertrupp'),
('arrogans','1|arrogant'),
('arrogant','1|självsäker'),
('arrondera','1|förändra'),
('arronderande','1|arrondera'),
('arronderbar','1|arrondera'),
('arronderbarhet','1|arronderbar'),
('arrondering','1|arrondera'),
('arrondissement','1|indelning'),
('arrondissement','1|indelning'),
('arrowrot','1|stärkelse'),
('arsel','1|stjärt'),
('arsel','1|stjärt'),
('arsel','1|stjärt'),
('arsel','1|stjärt'),
('arsel','1|stjärt'),
('arsel','1|stjärt'),
('arsenal','1|förråd'),
('arsenalsbyggnad','1|byggnad'),
('arsenik','1|grundämne'),
('arsenik','1|grundämne'),
('arsenikdos','1|dos'),
('arsenikfri','1|arsenik'),
('arsenikförgiftning','1|förgiftning'),
('arsenikhalt','1|halt'),
('arsenikhaltig','1|arsenikhalt'),
('arsenikkis','1|mineral'),
('arsenikmord','1|mord'),
('arsenikväte','1|väte'),
('arsiner','1|förening'),
('art','1|slag'),
('artbank','1|bevara'),
('artbeskrivning','1|beskrivning'),
('artbestämma','1|bestämma'),
('artbestämmande','1|artbestämma'),
('artbestämning','1|artbestämma'),
('artbildning','1|bildning'),
('artbildningsteori','1|teori'),
('artdatabank','1|databank'),
('artefakt','1|föremål'),
('artegen','1|art'),
('artegenhet','1|artegen'),
('Artemis','1|gudinna'),
('arteriell','1|artär'),
('arterioskleros','1|åderförkalkning'),
('arterit','1|inflammation'),
('arterivirusinfektion','1|virusinfektion'),
('artesisk','1|brunn'),
('artfrämmande','1|art'),
('artfrände','1|samma'),
('artförändring','1|förändring'),
('artificiell','1|naturlig'),
('artig','1|uppfostra'),
('artighet','1|artig'),
('artighetsbetygelse','1|handling'),
('artighetsbevis','1|artighetsbetygelse'),
('artighetsfras','1|fras'),
('artighetsvisit','1|visit'),
('artikel','1|läsa'),
('artikel','2|vara'),
('artikel','3|ordklass'),
('artikelförfattare','1|författare'),
('artikelserie','1|serie'),
('artikulation','1|artikulera'),
('artikulationsbas','1|bas'),
('artikulationsrubbning','1|rubbning'),
('artikulationsställe','1|ställe'),
('artikulera','1|tala'),
('artikulerande','1|artikulera'),
('artikulerbar','1|artikulera'),
('artikulerbarhet','1|artikulerbar'),
('artikulering','1|artikulera'),
('artilleri','1|kanon'),
('artilleribatteri','1|batteri'),
('artilleribeskjutning','1|artillerield'),
('artilleriduell','1|duell'),
('artillerield','1|eld'),
('artilleriförband','1|förband'),
('artillerigranat','1|granat'),
('artillerimanskap','1|manskap'),
('artilleripjäs','1|pjäs'),
('artilleriregemente','1|regemente'),
('artillerist','1|soldat'),
('artillerivapen','1|vapen'),
('artist','1|konstnär'),
('artistbana','1|artist'),
('artisteri','1|skicklighet'),
('artistframträdande','1|framträdande'),
('artistisk','1|artist'),
('artistliv','1|artist'),
('artistmässig','1|artist'),
('artistnamn','1|namn'),
('artnamn','1|benämning'),
('artnamn','2|appellativ'),
('arton','1|tal'),
('arton','1|tal'),
('artonde','1|arton'),
('artonde','1|arton'),
('artonhundranittiotalet','1|årtionde'),
('artonhundranittiotalet','1|årtionde'),
('artonhundrasjuttiotalet','1|årtionde'),
('artonhundrasjuttiotalet','1|årtionde'),
('artonhundratalet','1|århundrade'),
('artonhundratalet','1|århundrade'),
('artonhundratalet','1|århundrade'),
('artonhundratalsmode','1|mode'),
('artonhundratalsmode','1|mode'),
('artonhundraåttiotalet','1|årtionde'),
('artonhundraåttiotalet','1|årtionde'),
('artonsnåret','1|klockslag'),
('artonårig','1|år'),
('artonåring','1|artonårig'),
('artonårsdag','1|födelsedag'),
('artonårsmyndighet','1|myndighet'),
('artotek','1|galleri'),
('artralgi','1|ledvärk'),
('artrik','1|art'),
('artrikhet','1|artrik'),
('artrit','1|ledinflammation'),
('artrogrypos','1|missbildning'),
('artros','1|ledförslitning'),
('artroskopi','1|titthålskirurgi'),
('artskild','1|skilja_sig'),
('artskildhet','1|artskild'),
('artskillnad','1|artskild'),
('artär','1|blodåder'),
('artärbråck','1|bråck'),
('artärinflammation','1|inflammation'),
('artärvägg','1|vägg'),
('arv','1|överta'),
('arv','2|växt'),
('arvedel','1|arvslott'),
('arvegods','1|gods'),
('arvejord','1|jord'),
('arvfiende','1|fiende'),
('arvfurste','1|tronarvinge'),
('arvföljdskrig','1|krig'),
('arvförening','1|tronföljdsordning'),
('Arvika','1|stad'),
('arvinge','1|arv'),
('arvkonung','1|kung'),
('arvland','1|land'),
('arvlåtare','1|arv'),
('arvlös','1|arv'),
('arvlöshet','1|arvlös'),
('arvode','1|betala'),
('arvodera','1|arvode'),
('arvoderande','1|arvodera'),
('arvoderbar','1|arvodera'),
('arvoderbarhet','1|arvoderbar'),
('arvodering','1|arvodera'),
('arvodesbelopp','1|arvode'),
('arvord','1|ord'),
('arvprins','1|prins'),
('arvrike','1|tron'),
('arvsanlag','1|arv'),
('arvsanspråk','1|anspråk'),
('arvsberättigad','1|berättigad'),
('arvsfaktor','1|arvsanlag'),
('arvsfond','1|fond'),
('arvsfråga','1|fråga'),
('arvsföljd','1|följd'),
('arvsföljd','1|följd'),
('arvshygien','1|hygien'),
('arvskifte','1|dela'),
('arvslott','1|del'),
('arvsmassa','1|massa'),
('arvsmedel','1|arv'),
('arvsmolekyl','1|molekyl'),
('arvsmässig','1|arv'),
('arvsordning','1|arvsföljd'),
('arvsrätt','1|rätt'),
('arvssak','1|sak'),
('arvsskatt','1|skatt'),
('arvsskatt','1|skatt'),
('arvstvist','1|tvist'),
('arvsynd','1|synd'),
('arvtagare','1|arvinge'),
('arvtant','1|tant'),
('arytmi','1|hjärtverksamhet'),
('as','1|död'),
('as','2|gud'),
('as','3|usling'),
('asa','1|glida'),
('asagud','1|as'),
('asalära','1|asatro'),
('asande','1|asa'),
('asasläkt','1|as'),
('asatid','1|period'),
('asatro','1|tro'),
('asatroende','1|asatro'),
('asbagge','1|skalbagge'),
('asberusad','1|stupfull'),
('asbest','1|ämne'),
('asbestarbetare','1|arbetare'),
('asbestartad','1|asbest'),
('asbestcement','1|cement'),
('asbestlunga','1|lungsjukdom'),
('asbestos','1|sjukdom'),
('asbestplatta','1|platta'),
('asbestsanering','1|sanering'),
('asbesttråd','1|tråd'),
('ascaridiasis','1|ascarididainfektion'),
('ascarididainfektion','1|parasitinfektion'),
('ascendent','1|astrologi'),
('asch','1|bagatell'),
('ascites','1|bukvätska'),
('ASEA','1|företag'),
('ASEA','1|företag'),
('asenkel','1|enkel'),
('aseptik','1|aseptisk'),
('aseptisk','1|steril'),
('asexuell','1|könlös'),
('asfalt','1|vägbana'),
('asfaltemulsion','1|emulsion'),
('asfaltera','1|asfalt'),
('asfalterande','1|asfaltera'),
('asfalterbar','1|asfaltera'),
('asfalterbarhet','1|asfalterbar'),
('asfaltering','1|asfaltera'),
('asfaltlack','1|rostskyddsmedel'),
('asfaltmoped','1|asfaltera'),
('asfaltplatta','1|platta'),
('asfluga','1|fluga'),
('asfull','1|stupfull'),
('asfyxi','1|syrebrist'),
('asfyxiskada','1|kvävningsskada'),
('asfågel','1|fågel'),
('asförbannad','1|förbannad'),
('asgam','1|gam'),
('asgam','2|gam'),
('asgarva','1|garva'),
('ashkenaz','1|jude'),
('ashkenazisk','1|ashkenaz'),
('asiat','1|Asien'),
('asiaten','1|influensa'),
('asiatisk','1|Asien'),
('asiatiska','1|asiat'),
('Asien','1|världsdel'),
('Asien-rundresa','1|rundresa'),
('ask','1|låda'),
('Ask','1|människa'),
('ask','2|träd'),
('aska','1|eld'),
('aska','2|aska'),
('askande','1|aska'),
('askblond','1|blond'),
('aske','1|virke'),
('askenas','1|jude'),
('askeruption','1|eruption'),
('askes','1|leva'),
('asket','1|askes'),
('asketisk','1|askes'),
('asketism','1|askes'),
('asketliv','1|liv'),
('askexplosion','1|explosion'),
('askfat','1|fat'),
('askfri','1|vulkanaska'),
('askfrihet','1|askfri'),
('askgrå','1|grå'),
('askhot','1|hot'),
('askhög','1|hög'),
('Askja','1|vulkan'),
('askkoncentration','1|koncentration'),
('askkopp','1|askfat'),
('askkris','1|flygkaos'),
('Asklepios','1|gud'),
('asklock','1|lock'),
('askmoln','1|moln'),
('askonsdag','1|onsdag'),
('askorbinsyra','1|C-vitamin'),
('askorbinsyrabrist','1|brist'),
('askpartikel','1|partikel'),
('askpuff','1|puff'),
('askregn','1|regn'),
('askskott','1|skott'),
('askskottssjuka','1|sjuka'),
('askspridning','1|spridning'),
('asktipp','1|tipp'),
('askträ','1|trä'),
('askunge','1|Askungen'),
('Askungen','1|saga'),
('askurna','1|urna'),
('asocial','1|kriminell'),
('asocialitet','1|asocial'),
('asp','1|träd'),
('asp','2|fisk'),
('aspackad','1|stupfull'),
('aspartylglukosaminuri','1|ämnesomsättningsrubbning'),
('aspbark','1|bark'),
('aspdunge','1|dunge'),
('aspe','1|virke'),
('aspekt','1|avseende'),
('aspekt','2|verbform'),
('aspergillos','1|svampinfektion'),
('aspgren','1|gren'),
('asphänge','1|hänge'),
('aspirant','1|aspirera'),
('aspirata','1|aspirerad'),
('aspiration','1|aspirera'),
('aspiration','2|aspirera'),
('aspiration','3|inandas'),
('aspirationspneumoni','1|lunginflammation'),
('aspirera','1|eftersträva'),
('aspirera','2|konsonant'),
('aspirerad','1|aspirera'),
('aspirerad','2|aspirera'),
('aspirerande','1|aspirera'),
('aspirerande','2|aspirera'),
('aspirerbar','1|aspirera'),
('aspirerbar','2|aspirera'),
('aspirerbarhet','1|aspirerbar'),
('aspirerbarhet','2|aspirerbar'),
('aspirering','1|aspirera'),
('aspirering','2|aspirera'),
('aspirin','1|medicin'),
('asplöv','1|löv'),
('aspsly','1|busksly'),
('ass','1|assurera'),
('assegaj','1|spjut'),
('assessor','1|jurist'),
('assiett','1|tallrik'),
('assiettgaffel','1|gaffel'),
('assignant','1|assignation'),
('assignation','1|utbetalningsorder'),
('assignera','1|assignation'),
('assignerande','1|assignera'),
('assignerbar','1|assignera'),
('assignerbarhet','1|assignerbar'),
('assignering','1|assignera'),
('assimilation','1|assimilera'),
('assimilationsprocess','1|assimilation'),
('assimilera','1|omvandla'),
('assimilerande','1|assimilera'),
('assimilerbar','1|assimilera'),
('assimilerbarhet','1|assimilerbar'),
('assimilering','1|assimilera'),
('assist','1|passning'),
('assistans','1|assistera'),
('assistdrottning','1|assistkung'),
('assistent','1|assistera'),
('assistera','1|hjälpa'),
('assisterande','1|assistera'),
('assisterbar','1|assistera'),
('assisterbarhet','1|assisterbar'),
('assistering','1|assistera'),
('assistkung','1|assist'),
('association','1|associera'),
('associationsbana','1|sätt'),
('associationskedja','1|kedja'),
('associationslexikon','1|lexikon'),
('associationspsykologi','1|psykologi'),
('associationsrik','1|rik'),
('associationsrikedom','1|associationsrik'),
('associativ','1|association'),
('associera','1|förbinda'),
('associerande','1|associera'),
('associerbar','1|associera'),
('associerbarhet','1|associerbar'),
('associering','1|associera'),
('assonans','1|halvrim'),
('assuradör','1|försäkringsgivare'),
('assurans','1|assurera'),
('assuransspruta','1|brandspruta'),
('assurera','1|försäkra'),
('assurerande','1|assurera'),
('assurerbar','1|assurera'),
('assurerbarhet','1|assurerbar'),
('assurering','1|assurera'),
('Assyrien','1|land'),
('assyrier','1|Assyrien'),
('assyrisk','1|Assyrien'),
('assyriska','1|assyrier'),
('assyriska','2|språk'),
('astat','1|grundämne'),
('astat','1|grundämne'),
('asteni','1|kraftlöshet'),
('asteniker','1|asteni'),
('astenisk','1|asteni'),
('astenopi','1|ögontrötthet'),
('astenozoospermi','1|spermie'),
('aster','1|växt'),
('asterisk','1|tecken'),
('Asterix','1|seriefigur'),
('Asterix','2|serie'),
('asteroid','1|småplanet'),
('asteroidnedfall','1|nedfall'),
('asteroidnedslag','1|nedslag'),
('astigmatiker','1|astigmatisk'),
('astigmatisk','1|avbildningsfel'),
('astigmatism','1|astigmatisk'),
('A-stjärnan','1|stjärna'),
('astma','1|sjukdom'),
('astmatiker','1|astma'),
('astmatisk','1|astma'),
('Astrachan','1|stad'),
('astrakan','1|äpple'),
('astrakan','2|lammskinn'),
('astral','1|stjärna'),
('astralkropp','1|kropp'),
('astrocytom','1|hjärntumör'),
('astrofotografi','1|fotografi'),
('astrofysik','1|fysik'),
('astrofysiker','1|astrofysik'),
('astrolabium','1|mätinstrument'),
('astrolog','1|astrologi'),
('astrologi','1|spå'),
('astrologisk','1|astrologi'),
('astronaut','1|rymdfarare'),
('astronautik','1|rymdtrafik'),
('astronom','1|astronomi'),
('astronomi','1|vetenskap'),
('astronomisk','1|stjärna'),
('astronomisk','2|stor'),
('astrovirusinfektion','1|virusinfektion'),
('asyl','1|tillflykt'),
('asylland','1|land'),
('asylmottagning','1|mottagning'),
('asylpolitik','1|politik'),
('asylrätt','1|rättighet'),
('asylskäl','1|skäl'),
('asylsökande','1|söka'),
('asylsökande','2|asylsökande'),
('asymmetri','1|asymmetrisk'),
('asymmetrisk','1|symmetrisk'),
('asymptot','1|geometri'),
('asyndes','1|bindeord'),
('asyndetisk','1|asyndes'),
('asyndeton','1|asyndes'),
('asynja','1|as'),
('asynkron','1|synkron'),
('asystoli','1|hjärtstillestånd'),
('asätare','1|äta'),
('ataktisk','1|ataxi'),
('ataraktika','1|medicin'),
('ataraxi','1|själsro'),
('atavism','1|utvecklingsstadium'),
('atavistisk','1|atavism'),
('ataxi','1|sjukdom'),
('ateism','1|gudsförnekelse'),
('ateist','1|ateism'),
('ateistisk','1|ateism'),
('atelektas','1|lungkollaps'),
('ateljé','1|rum'),
('ateljébild','1|bild'),
('ateljéfönster','1|fönster'),
('ateljévåning','1|våning'),
('atemi','1|kampsport'),
('atenienn','1|hylla'),
('atensk','1|Athen'),
('aterogenes','1|åderförkalkning'),
('aterom','1|cysta'),
('ateroskleros','1|arterioskleros'),
('atetos','1|hyperkinesi'),
('Athen','1|huvudstad'),
('Athen','1|huvudstad'),
('Athen','1|huvudstad'),
('Athena','1|gudinna'),
('Atlanta','1|huvudstad'),
('Atlanten','1|hav'),
('atlantisk','1|Atlanten'),
('Atlantpakten','1|pakt'),
('atlantångare','1|ångare'),
('Atlas','1|Atlasbergen'),
('atlas','1|kartbok'),
('atlas','2|siden'),
('Atlasbergen','1|bergskedja'),
('atlasbindning','1|atlas'),
('atlaskota','1|kota'),
('atlasspinnare','1|fjäril'),
('atlet','1|atletisk'),
('atlet','2|idrott'),
('atletisk','1|kroppsbyggnad'),
('atletklubb','1|klubb'),
('AT-läkare','1|läkare'),
('atmosfär','1|luft'),
('atmosfär','2|atmosfärstryck'),
('atmosfärforskare','1|forskare'),
('atmosfärisk','1|atmosfär'),
('atmosfärkemist','1|kemist'),
('atmosfärsförhållande','1|atmosfär'),
('atmosfärslager','1|luftlager'),
('atmosfärstryck','1|tryck'),
('atmosfärtryck','1|tryck'),
('atoll','1|korallrev'),
('atom','1|materia'),
('atombomb','1|bomb'),
('atombomba','1|bomba'),
('atombombande','1|atombomba'),
('atombombsfällning','1|bombfällning'),
('atombombsöverlevande','1|överlevande'),
('atombrygga','1|brygga'),
('atomdriven','1|driva'),
('atomenergi','1|energi'),
('Atomenergi','1|kraftbolag'),
('atomenergiorgan','1|FN-organ'),
('atomenergiorganisation','1|organisation'),
('atomfysik','1|fysik'),
('atomgrupp','1|atom'),
('atomism','1|helhet'),
('atomistisk','1|atomism'),
('atomjon','1|jon'),
('atomklocka','1|klocka'),
('atomkraft','1|kraft'),
('atomkraftmikroskop','1|mikroskop'),
('atomkraftsutbyggnad','1|utbyggnad'),
('atomkärna','1|kärna'),
('atomlära','1|lära'),
('atommassa','1|massa'),
('atommodell','1|modell'),
('atomnummer','1|ordningstal'),
('atomreaktor','1|kärnreaktor'),
('atomspektrum','1|linjespektrum'),
('atomteori','1|teori'),
('atomubåt','1|ubåt'),
('atomur','1|atomklocka'),
('atomvapen','1|kärnvapen'),
('atomvikt','1|vikt'),
('atomvinter','1|kärnvapenkrig'),
('atomär','1|atom'),
('atonal','1|musik'),
('atoni','1|förslappning'),
('atopi','1|allergi'),
('ATP','1|pension'),
('atrieflimmer','1|hjärtflimmer'),
('atrium','1|gårdsrum'),
('atrofi','1|förtvina'),
('atrofiera','1|atrofi'),
('atrofierande','1|atrofiera'),
('atrofierbar','1|atrofiera'),
('atrofierbarhet','1|atrofierbar'),
('atrofiering','1|atrofiera'),
('atrofisk','1|atrofi'),
('atropin','1|medicin'),
('att','1|den'),
('attaché','1|diplomat'),
('attachéväska','1|portfölj'),
('attack','1|anfalla'),
('attack','2|anfall'),
('attackdykare','1|grodman'),
('attackera','1|attack'),
('attackerande','1|attackera'),
('attackerbar','1|attackera'),
('attackerbarhet','1|attackerbar'),
('attackering','1|attackera'),
('attackflyg','1|attackplan'),
('attackflygplan','1|stridsflygplan'),
('attackförmåga','1|förmåga'),
('attackhelikopter','1|helikopter'),
('attackplan','1|attackflygplan'),
('attacksignal','1|signal'),
('attan','1|djävul'),
('attan','2|attan'),
('attentat','1|förstöra'),
('attentator','1|attentatsman'),
('attentatsman','1|attentat'),
('attest','1|intyg'),
('attestera','1|attest'),
('attesterande','1|attestera'),
('attesterbar','1|attestera'),
('attesterbarhet','1|attesterbar'),
('attestering','1|attestera'),
('attika','1|överbyggnad'),
('Attila','1|härskare'),
('attila','1|uniformsrock'),
('attiraljer','1|föremål'),
('attisk','1|Athen'),
('attityd','1|inställning'),
('attitydförändring','1|förändring'),
('attitydmässig','1|attityd'),
('attitydpåverkan','1|påverkan'),
('attitydundersökning','1|undersökning'),
('attrahera','1|dragningskraft'),
('attraherande','1|attrahera'),
('attraherbar','1|attrahera'),
('attraherbarhet','1|attraherbar'),
('attrahering','1|attrahera'),
('attraktion','1|attrahera'),
('attraktionskraft','1|attraktion'),
('attraktionslag','1|lag'),
('attraktiv','1|attrahera'),
('attraktivitet','1|attraktiv'),
('attrapp','1|ersätta'),
('attrappera','1|imitera'),
('attrapperande','1|attrappera'),
('attrapperbar','1|attrappera'),
('attrapperbarhet','1|attrapperbar'),
('attrappering','1|attrappera'),
('attribuera','1|tillskriva'),
('attribuerande','1|attribuera'),
('attribuerbar','1|attribuera'),
('attribuerbarhet','1|attribuerbar'),
('attribuering','1|attribuera'),
('attribut','1|egenskap'),
('attribut','2|bestämning'),
('attribution','1|attribuera'),
('attributiv','1|attribut'),
('attributsamling','1|samling'),
('attributsats','1|sats'),
('att-sats','1|bisats'),
('atypi','1|otypisk'),
('atypisk','1|atypi'),
('aubergine','1|grönsak'),
('aubergine','1|grönsak'),
('Audhumbla','1|ko'),
('Audi','1|bilmärke'),
('audiens','1|tillstånd'),
('audiensdag','1|dag'),
('audienssal','1|sal'),
('audienssökande','1|sökande'),
('audiogram','1|mäta'),
('audiologi','1|vetenskap'),
('audiometer','1|audiogram'),
('audit','1|granska'),
('auditiv','1|hörsel'),
('auditorium','1|hörsal'),
('auditör','1|jurist'),
('audivisuell','1|syn'),
('audivisuell','1|syn'),
('auerlampa','1|gaslampa'),
('auerstrumpa','1|auerlampa'),
('augiasstall','1|stordåd'),
('augment','1|förled'),
('augur','1|teckentydare'),
('Augusta','1|huvudstad'),
('augusti','1|månad'),
('augustidag','1|dag'),
('augustimånsken','1|månsken'),
('augustinatt','1|natt'),
('Augustinus','1|kyrkofader'),
('augustipäron','1|päron'),
('augustisol','1|sol'),
('augustnominerad','1|nominera'),
('Augustpriset','1|pris'),
('Augustus','1|kejsare'),
('auktion','1|försäljning'),
('auktionera','1|auktion'),
('auktionerande','1|auktionera'),
('auktionerare','1|auktionera'),
('auktionerbar','1|auktionera'),
('auktionerbarhet','1|auktionerbar'),
('auktionering','1|auktionera'),
('auktionist','1|auktion'),
('auktionsbridge','1|bridge'),
('auktionsdag','1|dag'),
('auktionsförrättare','1|auktion'),
('auktionsinrop','1|inrop'),
('auktionskammare','1|auktion'),
('auktionsklubba','1|klubba'),
('auktionsprotokoll','1|protokoll'),
('auktionsutropare','1|auktion'),
('auktionsverk','1|auktion'),
('auktor','1|upphovsman'),
('auktorisation','1|befogenhet'),
('auktorisera','1|auktorisation'),
('auktoriserande','1|auktorisera'),
('auktoriserbar','1|auktorisera'),
('auktoriserbarhet','1|auktoriserbar'),
('auktorisering','1|auktorisera'),
('auktoritativ','1|auktoritet'),
('auktoritet','1|sakkunskap'),
('auktoritet','2|auktoritär'),
('auktoritetsbunden','1|tro'),
('auktoritetsbundenhet','1|auktoritetsbunden'),
('auktoritetstro','1|auktoritetsbunden'),
('auktoritär','1|makt'),
('auktorrätt','1|upphovsrätt'),
('auktorrätt','1|upphovsrätt'),
('auktorskap','1|auktor'),
('aula','1|samlingssal'),
('aura','1|strålglans'),
('auramigrän','1|migrän'),
('Auschwitz','1|koncentrationsläger'),
('auskultant','1|auskultera'),
('auskultation','1|auskultera'),
('auskultera','1|praktisera'),
('auskulterande','1|auskultera'),
('auskulterbar','1|auskultera'),
('auskulterbarhet','1|auskulterbar'),
('auskultering','1|auskultera'),
('auspicier','1|framtidsutsikt'),
('Austerlitz','1|slag'),
('Austin','1|bilmärke'),
('Austin','2|huvudstad'),
('Australien','1|världsdel'),
('Australien','2|land'),
('australier','1|Australien'),
('australier','1|Australien'),
('australisk','1|Australien'),
('australisk','1|Australien'),
('australiska','1|australier'),
('autarki','1|envälde'),
('autenticitet','1|autentisk'),
('autenticitet','1|autentisk'),
('autentisera','1|identifiera'),
('autentisera','1|identifiera'),
('autentisera','1|identifiera'),
('autentiserande','1|autentisera'),
('autentiserande','1|autentisera'),
('autentiserande','1|autentisera'),
('autentiserbar','1|autentisera'),
('autentiserbar','1|autentisera'),
('autentiserbar','1|autentisera'),
('autentiserbarhet','1|autentiserbar'),
('autentiserbarhet','1|autentiserbar'),
('autentiserbarhet','1|autentiserbar'),
('autentisering','1|autentisera'),
('autentisering','1|autentisera'),
('autentisering','1|autentisera'),
('autentisk','1|äkta'),
('auteur','1|filmskapare'),
('autism','1|sjukdom'),
('autist','1|autism'),
('autistisk','1|autism'),
('autodafé','1|bränna'),
('autodidakt','1|självlärd'),
('autodigestion','1|autolys'),
('autodrom','1|bilbana'),
('autograf','1|namnteckning'),
('autografjägare','1|jaga'),
('autografsamling','1|samling'),
('autoimmun','1|immun'),
('autoklav','1|kokkärl'),
('autokrat','1|diktator'),
('autokrati','1|autokrat'),
('autokratisk','1|autokrat'),
('autokton','1|inhemsk'),
('autolys','1|självnedbrytning'),
('automagisk','1|automatisk'),
('automat','1|automatisk'),
('automat','2|automatateori'),
('automat','3|automat'),
('automatateori','1|matematik'),
('automatateori','1|matematik'),
('automateld','1|eld'),
('automatgevär','1|gevär'),
('automatik','1|automatisk'),
('automation','1|automatisera'),
('automatisera','1|automatisk'),
('automatiserande','1|automatisera'),
('automatiserbar','1|automatisera'),
('automatiserbarhet','1|automatiserbar'),
('automatisering','1|automatisera'),
('automatisk','1|arbeta'),
('automatkarbin','1|karbin'),
('automatsäkring','1|säkring'),
('automatuttag','1|uttag'),
('automatvapen','1|vapen'),
('automobil','1|bil'),
('autonom','1|självständig'),
('autonomi','1|autonom'),
('auto-PEEP','1|andningsbesvär'),
('autopilot','1|självstyrande'),
('autopsi','1|själviakttagelse'),
('autostrada','1|motorväg'),
('autotypi','1|kliché'),
('av','1|från'),
('av','2|på'),
('av','3|bryta'),
('av','4|slippa'),
('ava','1|avannons'),
('ava','2|ava'),
('avaktivera','1|inaktivera'),
('avaktiverande','1|avaktivera'),
('avaktiverbar','1|avaktivera'),
('avaktiverbarhet','1|avaktiverbar'),
('avaktivering','1|avaktivera'),
('avancemang','1|avancera'),
('avancera','1|framåt'),
('avancerad','1|svår'),
('avancerande','1|avancera'),
('avancerbar','1|avancera'),
('avancerbarhet','1|avancerbar'),
('avancering','1|avancera'),
('avande','1|ava'),
('avannons','1|program'),
('avannonsera','1|avannons'),
('avannonserande','1|avannonsera'),
('avannonserbar','1|avannonsera'),
('avannonserbarhet','1|avannonserbar'),
('avannonsering','1|avannons'),
('avans','1|vinst'),
('avantgarde','1|tåga'),
('avantgardism','1|avantgarde'),
('avantgardist','1|avantgarde'),
('avantgardistisk','1|avantgarde'),
('avantloge','1|loge'),
('avantscen','1|scen'),
('avart','1|form'),
('avatar','1|hinduism'),
('avatar','2|gestalt'),
('avbalka','1|avskilja'),
('avbalkande','1|avbalka'),
('avbalkning','1|avbalka'),
('avbarka','1|barka'),
('avbarkning','1|avbarka'),
('avbasning','1|bestraffa'),
('avbeställa','1|upphäva'),
('avbeställande','1|avbeställa'),
('avbeställning','1|avbeställa'),
('avbeta','1|beta'),
('avbetala','1|återbetala'),
('avbetalande','1|avbetala'),
('avbetalning','1|avbetala'),
('avbetalningsaffär','1|avbetalningsköp'),
('avbetalningsarrangemang','1|avbetalning'),
('avbetalningsköp','1|köpa'),
('avbetalningslån','1|lån'),
('avbetalningsplan','1|plan'),
('avbetalningsvillkor','1|villkor'),
('avbetande','1|avbeta'),
('avbetingning','1|upphäva'),
('avbetning','1|beta_av'),
('avbetning','2|beta_av'),
('avbetsling','1|betsla_av'),
('avbild','1|bild'),
('avbilda','1|bild'),
('avbildande','1|avbilda'),
('avbildning','1|bild'),
('avbildning','2|funktion'),
('avbildningsfel','1|fel'),
('avbinda','1|upphäva'),
('avbindande','1|avbinda'),
('avbindning','1|avbinda'),
('avbitare','1|avbitartång'),
('avbitartång','1|tång'),
('avbiten','1|bita'),
('avbitning','1|bita_av'),
('avbitning','2|bita_av'),
('avbitning','3|bita_av'),
('AV-block','1|hjärtsjukdom'),
('avblåsa','1|förklara'),
('avblåsa','1|förklara'),
('avblåsande','1|avblåsa'),
('avblåsning','1|avblåsa'),
('avbländning','1|blända_av'),
('avboka','1|avbeställa'),
('avbokande','1|avboka'),
('avbokning','1|avboka'),
('avborstning','1|borsta_av'),
('avbrott','1|avbryta'),
('avbruten','1|avbryta'),
('avbryta','1|upphöra'),
('avbrytande','1|avbryta'),
('avbrytare','1|strömbrytare'),
('avbrytning','1|avbryta'),
('avbrytning','2|bryta_av'),
('avbräck','1|förlust'),
('avbränning','1|kostnad'),
('avbröstning','1|kanon'),
('avbytarbänk','1|bänk'),
('avbytare','1|reserv'),
('avbärning','1|bära_av'),
('avbärning','1|bära_av'),
('avböja','1|vägra'),
('avböja','2|böja'),
('avböja','2|böja'),
('avböjande','1|avböja'),
('avböjande','2|avböja'),
('avböjning','1|avböja'),
('avbön','1|erkänna'),
('avbörda','1|avlasta'),
('avbördande','1|avbörda'),
('avdagatagande','1|ta_av_daga'),
('avdamning','1|damma_av'),
('avdamning','2|damma_av'),
('avdankad','1|uttjänt'),
('avdela','1|avskilja'),
('avdelande','1|avdela'),
('avdelning','1|del'),
('avdelning','1|del'),
('avdelning','1|del'),
('avdelningschef','1|chef'),
('avdelningsdirektör','1|chef'),
('avdelningskontor','1|kontor'),
('avdelningsläkare','1|läkare'),
('avdelningssköterska','1|sjuksköterska'),
('avdelningsvis','1|avdelning'),
('avdikning','1|dika_av'),
('avdiskning','1|diska_av'),
('avdomning','1|domna_av'),
('avdrag','1|skatt'),
('avdrag','2|prisavdrag'),
('avdragsgill','1|giltig'),
('avdragsglad','1|gärna'),
('avdragsmöjlighet','1|möjlighet'),
('avdragsrätt','1|rätt'),
('avdramatisera','1|minska'),
('avdramatiserande','1|avdramatisera'),
('avdramatiserbar','1|avdramatisera'),
('avdramatiserbarhet','1|avdramatiserbar'),
('avdramatisering','1|avdramatisera'),
('avdrift','1|kurs'),
('avdriva','1|driva'),
('avdrivande','1|avdriva'),
('avdukning','1|duka_av'),
('avdunsta','1|försvinna'),
('avdunstande','1|avdunsta'),
('avdunstning','1|avdunsta'),
('avdämma','1|dämma'),
('avdämmande','1|avdämma'),
('avdämning','1|avdämma'),
('avdöd','1|avlida'),
('avdöma','1|döma'),
('avdömande','1|avdöma'),
('ave','1|Ave_Maria'),
('avec','1|konjak'),
('avel','1|föda_upp'),
('avelsdjur','1|djur'),
('avelsduglig','1|duglig'),
('avelshingst','1|hingst'),
('avelssto','1|sto'),
('avenbok','1|bok'),
('Aventinen','1|kulle'),
('aveny','1|gata'),
('avers','1|advers'),
('aversion','1|motvilja'),
('aversionsterapi','1|narkomanvård'),
('Avesta','1|stad'),
('avfall','1|bort'),
('avfalla','1|överge'),
('avfallande','1|avfalla'),
('avfallen','1|mager'),
('avfallsbrunn','1|brunn'),
('avfallsdike','1|dike'),
('avfallsfoder','1|foder'),
('avfallshantering','1|hantering'),
('avfallskvarn','1|kvarn'),
('avfallsråvara','1|råvara'),
('avfallsupplag','1|upplag'),
('avfallsvatten','1|vatten'),
('avfallsvirke','1|virke'),
('avfalsning','1|falsa_av'),
('avfart','1|väg'),
('avfasning','1|fasa_av'),
('avfatta','1|skriva'),
('avfattande','1|avfatta'),
('avfattning','1|avfatta'),
('avfejning','1|feja_av'),
('avfetta','1|avlägsna'),
('avfettande','1|avfetta'),
('avfettning','1|avfetta'),
('avfettningsmedel','1|medel'),
('avfilning','1|fila_av'),
('avfiltrering','1|filtrera_av'),
('avfjällning','1|fjälla_av'),
('avflagnad','1|flagna'),
('avflytta','1|flytta'),
('avflyttande','1|avflytta'),
('avflyttning','1|avflytta'),
('avflyttningsförbud','1|förbud'),
('avflöde','1|bortrinna'),
('avfolka','1|minska'),
('avfolkande','1|avfolka'),
('avfolkning','1|avfolka'),
('avfolkningsområde','1|område'),
('avfordra','1|kräva'),
('avfordran','1|avfordra'),
('avfordrande','1|avfordra'),
('avforsling','1|forsla_av'),
('avfrostande','1|frosta_av'),
('avfrostning','1|frosta_av'),
('avfukta','1|avlägsna'),
('avfuktande','1|avfukta'),
('avfuktare','1|avfukta'),
('avfyra','1|avlossa'),
('avfyra','1|avlossa'),
('avfyrande','1|avfyra'),
('avfyrning','1|avfyra'),
('avfyrningskod','1|kod'),
('avfyrningsprocedur','1|avfyrning'),
('avfällig','1|avfalla'),
('avfällighet','1|avfällig'),
('avfälling','1|avfalla'),
('avfärd','1|avresa'),
('avfärda','1|vägra'),
('avfärdande','1|avfärda'),
('avfärgning','1|färga_av_sig'),
('avföda','1|avkomma'),
('avföra','1|avlägsna'),
('avförande','1|avföra'),
('avföring','1|avfall'),
('avföringsinkontinens','1|inkontinens'),
('avföringsmedel','1|medicin'),
('avföringstransplantat','1|avföringstransplantation'),
('avföringstransplantation','1|transplantation'),
('avgaser','1|gas'),
('avgasförgiftning','1|förgiftning'),
('avgasrening','1|rening'),
('avgasrör','1|rör'),
('avge','1|ge'),
('avgift','1|betala'),
('avgifta','1|behandla'),
('avgiftande','1|avgifta'),
('avgiftning','1|avgifta'),
('avgiftningsklinik','1|klinik'),
('avgiftsbelägga','1|kräva'),
('avgiftsbeläggande','1|avgiftsbelägga'),
('avgiftsfri','1|avgift'),
('avgiftsfrihet','1|avgiftsfri'),
('avgivande','1|avge'),
('avgjord','1|avgöra'),
('avgjord','2|definitiv'),
('avgjutning','1|avbildning'),
('avglans','1|återsken'),
('avgnagning','1|gnaga'),
('avgnuggning','1|gnugga_av'),
('avgrena','1|förgrening'),
('avgrenande','1|avgrena'),
('avgrening','1|avgrena'),
('avgrund','1|bottenlös'),
('avgrundsande','1|djävul'),
('avgrundsdjup','1|oerhörd'),
('avgrundsdjup','2|avgrund'),
('avgrundseld','1|helveteseld'),
('avgrundslik','1|helvete'),
('avgrundsrand','1|helvete'),
('avgrundsskara','1|skara'),
('avgränsa','1|skilja'),
('avgränsande','1|avgränsa'),
('avgränsning','1|avgränsa'),
('avgud','1|gud'),
('avguda','1|dyrka'),
('avgudabild','1|avbild'),
('avgudadyrkan','1|dyrkan'),
('avgudadyrkare','1|dyrka'),
('avgudande','1|avguda'),
('avguderi','1|avguda'),
('avgå','1|lämna'),
('avgå','2|säga_upp_sig'),
('avgående','1|avgå'),
('avgående','2|avgå'),
('avgång','1|avgå'),
('avgång','2|avgå'),
('avgångsbetyg','1|betyg'),
('avgångsbidrag','1|ersättning'),
('avgångsersättning','1|ersättning'),
('avgångshall','1|flygplats'),
('avgångsklass','1|klass'),
('avgångskrav','1|krav'),
('avgångssignal','1|signal'),
('avgångstid','1|tid'),
('avgångsvederlag','1|vederlag'),
('avgäld','1|avgift'),
('avgärda','1|avskilja'),
('avgärdande','1|avgärda'),
('avgärdning','1|avgärda'),
('avgöra','1|fast'),
('avgörande','1|avgöra'),
('avgörande','2|avgöra'),
('avhackning','1|hacka_av'),
('avhackning','2|hacka_av'),
('avhakning','1|haka_av'),
('avhandla','1|behandla'),
('avhandlande','1|avhandla'),
('avhandling','1|bok'),
('avhaspling','1|haspla_av'),
('avhjälpa','1|rätta_till'),
('avhjälpande','1|avhjälpa'),
('avhopp','1|hoppa_av'),
('avhoppad','1|hoppa_av'),
('avhoppare','1|hoppa_av'),
('avhorna','1|avlägsna'),
('avhornande','1|avhorna'),
('avhorning','1|avhorna'),
('avhuggning','1|hugga_av'),
('avhumanisera','1|avlägsna'),
('avhumaniserande','1|avhumanisera'),
('avhumanisering','1|avhumanisera'),
('avhysa','1|vräka'),
('avhysande','1|avhysa'),
('avhysning','1|avhysa'),
('avhyvling','1|tillrättavisa'),
('avhåll','1|fira'),
('avhålla','1|avhålla_sig'),
('avhållande','1|avhålla'),
('avhållen','1|omtyckt'),
('avhållsam','1|avstå'),
('avhållsamhet','1|avhållsam'),
('avhäktning','1|häkta_av'),
('avhällning','1|hälla_av'),
('avhällningsöppning','1|öppning'),
('avhämta','1|hämta'),
('avhämtande','1|avhämta'),
('avhämtning','1|avhämta'),
('avhända','1|ta'),
('avhändande','1|avhända'),
('avhändbar','1|avhända'),
('avhändbarhet','1|avhändbar'),
('avhänga','1|bero'),
('avhängande','1|avhänga'),
('avhängd','1|frånkörd'),
('avhängig','1|avhänga'),
('avhängighet','1|avhängig'),
('avhärda','1|mjukgöra'),
('avhärdande','1|avhärda'),
('avhästning','1|häst'),
('avhöra','1|meddela'),
('avhörande','1|avhöra'),
('avhösta','1|skörda'),
('avhöstande','1|avhösta'),
('avi','1|meddelande'),
('aviarium','1|fågelbur'),
('aviatik','1|flygkonst'),
('aviatiker','1|aviatik'),
('aviatisk','1|aviatik'),
('aviatör','1|flygare'),
('Avicenna','1|filosof'),
('avig','1|insida'),
('avig','2|dålig'),
('avigan','1|avigsida'),
('avigsida','1|avig'),
('avindividualisera','1|avlägsna'),
('avindividualiserande','1|avindividualisera'),
('avindividualisering','1|avindividualisera'),
('avinstallera','1|upphäva'),
('avinstallerande','1|avinstallera'),
('avinstallerbar','1|avinstallera'),
('avinstallering','1|avinstallera'),
('avintellektualisera','1|avlägsna'),
('avintellektualiserande','1|avintellektualisera'),
('avintellektualiserbar','1|avintellektualisera'),
('avintellektualisering','1|avintellektualisera'),
('avisa','1|avlägsna'),
('avisa','2|tidning'),
('avisa','2|tidning'),
('avisande','1|avisa'),
('avisera','1|meddela'),
('aviserande','1|avisera'),
('aviserbar','1|avisera'),
('aviserbarhet','1|aviserbar'),
('avisering','1|avisera'),
('aviseringsperiod','1|period'),
('avisning','1|avisa'),
('avisningsanläggning','1|anläggning'),
('avisofartyg','1|örlogsfartyg'),
('avista','1|växel'),
('avista','1|växel'),
('A-vitamin','1|vitamin'),
('A-vitaminbrist','1|brist'),
('A-vitaminbrist','1|brist'),
('avitaminos','1|sjukdom'),
('avjaga','1|avdriva'),
('avjagande','1|avjaga'),
('avjämna','1|jämna'),
('avjämnande','1|avjämna'),
('avjämning','1|avjämna'),
('avkalka','1|avlägsna'),
('avkalkande','1|avkalka'),
('avkapning','1|kapa_av'),
('avkasta','1|avkastning'),
('avkastande','1|avkasta'),
('avkastning','1|resultat'),
('avkastningskrav','1|krav'),
('avklappning','1|tryck'),
('avklara','1|rena'),
('avklarande','1|klara_av'),
('avklarande','2|avklara'),
('avklarnad','1|klarna'),
('avklinga','1|minska'),
('avklingande','1|avklinga'),
('avklippning','1|klippa_av'),
('avklädande','1|klä_av'),
('avklädning','1|klä_av'),
('avknackning','1|knacka_av'),
('avknipning','1|knipa'),
('avknoppa','1|bilda'),
('avknoppa','1|bilda'),
('avknoppande','1|avknoppa'),
('avknoppning','1|avknoppa'),
('avknoppningsföretag','1|företag'),
('avknäppning','1|knäppa_av'),
('avknäppning','2|knäppa_av'),
('avkok','1|koka'),
('avkokning','1|koka'),
('avkolonisera','1|upphäva'),
('avkoloniserande','1|avkolonisera'),
('avkoloniserbar','1|avkolonisera'),
('avkoloniserbarhet','1|avkoloniserbar'),
('avkolonisering','1|avkolonisera'),
('avkomling','1|ättling'),
('avkomma','1|barn'),
('avkomst','1|avkastning'),
('avkomsträtt','1|rätt'),
('avkoppla','1|avbryta'),
('avkopplande','1|avkoppla'),
('avkoppling','1|paus'),
('avkorta','1|minska'),
('avkortande','1|avkorta'),
('avkortning','1|avkorta'),
('avkrattning','1|kratta_av'),
('avkriminalisera','1|kriminalisera'),
('avkriminaliserande','1|avkriminalisera'),
('avkriminaliserbar','1|avkriminalisera'),
('avkriminaliserbarhet','1|avkriminaliserbar'),
('avkriminalisering','1|avkriminalisera'),
('avkristna','1|kristen'),
('avkristnande','1|avkristna'),
('avkristning','1|avkristna'),
('avkrok','1|avlägsen'),
('avkrokning','1|kroka_av'),
('avkrängning','1|kränga_av'),
('avkräva','1|kräva'),
('avkrävande','1|avkräva'),
('avkrävning','1|avkräva'),
('avkunna','1|meddela'),
('avkunnande','1|avkunna'),
('avkvistning','1|kvista_av'),
('avkylare','1|kyla_av'),
('avkylning','1|kyla_av'),
('avkännare','1|känna_av'),
('avkänning','1|känna_av'),
('avkänningssystem','1|system'),
('avköna','1|avlägsna'),
('avkönande','1|avköna'),
('avkörningsramp','1|nedfart'),
('avla','1|skapa'),
('avlagd','1|oanvändbar'),
('avlagra','1|lager'),
('avlagrande','1|avlagra'),
('avlagring','1|avlagra'),
('avlande','1|avla'),
('avlassning','1|lassa_av'),
('avlasta','1|hjälpa'),
('avlastande','1|avlasta'),
('avlastare','1|avlasta'),
('avlastning','1|avlasta'),
('avlastningsort','1|ort'),
('avlastningsplats','1|plats'),
('avlat','1|syndaförlåtelse'),
('avlatsbrev','1|intyg'),
('avleda','1|leda'),
('avleda','2|ordbildning'),
('avledande','1|avleda'),
('avledande','2|avleda'),
('avledare','1|avleda'),
('avledning','1|avleda'),
('avledningsdike','1|dike'),
('avledningsrör','1|rör'),
('avledningsändelse','1|ändelse'),
('avlelse','1|avla'),
('avleverera','1|leverera'),
('avleverering','1|avleverera'),
('avlida','1|dö'),
('avlidande','1|avlida'),
('avliden','1|avlida'),
('avlindning','1|linda_av'),
('avling','1|avla'),
('avlinge','1|egendom'),
('avliva','1|döda'),
('avlivande','1|avliva'),
('avljud','1|vokalväxling'),
('avljudsvokal','1|avljud'),
('avlocka','1|förmå'),
('avlockande','1|avlocka'),
('avlopp','1|leda'),
('avloppsbrunn','1|avlopp'),
('avloppsdike','1|dike'),
('avloppskanal','1|kanal'),
('avloppsledning','1|ledning'),
('avloppsledningsrör','1|rör'),
('avloppsrensare','1|rensa'),
('avloppsrensning','1|rensning'),
('avloppsrensningsslang','1|slang'),
('avloppsränna','1|ränna'),
('avloppsrör','1|avloppsledningsrör'),
('avloppsslam','1|slam'),
('avloppssystem','1|avlopp'),
('avloppstrumma','1|trumma'),
('avloppsvatten','1|vatten'),
('avlossa','1|skjuta'),
('avlossande','1|avlossa'),
('avlusa','1|avlägsna'),
('avlusande','1|avlusa'),
('avlusning','1|avlusa'),
('avlusningsmedel','1|medel'),
('avlutande','1|luta_av'),
('avlysa','1|ställa_in'),
('avlysande','1|avlysa'),
('avlysning','1|avlysa'),
('avlyssna','1|lyssna'),
('avlyssnande','1|avlyssna'),
('avlyssning','1|avlyssna'),
('avlyssningsapparatur','1|apparatur'),
('avlyssningshärva','1|härva'),
('avlyssningsskandal','1|skandal'),
('avlyssningsutrustning','1|utrustning'),
('avlång','1|lång'),
('avlånghet','1|avlång'),
('avlåta','1|avsända'),
('avlåtande','1|avlåta'),
('avlägga','1|fullgöra'),
('avlägga','2|avge'),
('avläggande','1|avlägga'),
('avläggande','2|avlägga'),
('avläggare','1|dotterföretag'),
('avläggare','2|växt'),
('avläggning','1|avläggare'),
('avlägsen','1|avstånd'),
('avlägsenhet','1|avlägsen'),
('avlägsna','1|bort'),
('avlägsnande','1|avlägsna'),
('avlämna','1|lämna'),
('avlämna','1|lämna'),
('avlämnande','1|avlämna'),
('avlämning','1|överlämna'),
('avlänka','1|avleda'),
('avlänkande','1|avlänka'),
('avläsande','1|läsa_av'),
('avläsande','2|läsa_av'),
('avläsande','3|läsa_av'),
('avläsare','1|läsa_av'),
('avläsbar','1|läsa_av'),
('avläsbar','2|läsa_av'),
('avläsbar','3|läsa_av'),
('avläsbarhet','1|avläsbar'),
('avläsbarhet','2|avläsbar'),
('avläsbarhet','3|avläsbar'),
('avläsning','1|läsa_av'),
('avlöna','1|avlöning'),
('avlönande','1|avlöna'),
('avlöning','1|lön'),
('avlöpa','1|sluta'),
('avlöpande','1|avlöpa'),
('avlöpning','1|sjösätta'),
('avlösa','1|ersätta'),
('avlösande','1|avlösa'),
('avlösning','1|avlösa'),
('avlöva','1|avlägsna'),
('avlövande','1|avlöva'),
('avlövning','1|avlöva'),
('avlövningsmedel','1|medel'),
('avmagnetisera','1|avlägsna'),
('avmagnetiserande','1|avmagnetisera'),
('avmagnetiserbar','1|avmagnetisera'),
('avmagnetiserbarhet','1|avmagnetiserbar'),
('avmagnetisering','1|avmagnetisera'),
('avmagnetiseringsprocess','1|avmagnetisering'),
('avmagrad','1|mager'),
('avmagring','1|magra'),
('avmarsch','1|marsch'),
('avmaska','1|avsluta'),
('avmaska','2|avlägsna'),
('avmaskande','1|avmaska'),
('avmaskande','2|avmaska'),
('avmaskning','1|avmaska'),
('avmaskning','2|avmaska'),
('avmaskningskur','1|kur'),
('avmasta','1|avlägsna'),
('avmastande','1|avmasta'),
('avmatta','1|försvaga'),
('avmattande','1|avmatta'),
('avmattas','1|avmatta'),
('avmattning','1|avmatta'),
('avmattningsperiod','1|period'),
('avmejning','1|meja_av'),
('avmejsling','1|mejsla_av'),
('avmystifiera','1|minska'),
('avmystifierande','1|avmystifiera'),
('avmystifierbar','1|avmystifiera'),
('avmystifierbarhet','1|avmystifierbar'),
('avmystifiering','1|avmystifiera'),
('avmålning','1|måla_av'),
('avmäta','1|mäta'),
('avmätande','1|avmäta'),
('avmätning','1|virke'),
('avmätt','1|behärskad'),
('avmätthet','1|avmätt'),
('avmönstring','1|mönstra_av'),
('avnavla','1|avlägsna'),
('avnavlande','1|avnavla'),
('avnazifiera','1|avnazifiering'),
('avnazifierande','1|avnazifiera'),
('avnazifierbar','1|avnazifiera'),
('avnazifierbarhet','1|avnazifierbar'),
('avnazifiering','1|avlägsna'),
('avnjuta','1|uppleva'),
('avnjutande','1|avnjuta'),
('avnypning','1|nypa_av'),
('avnystning','1|nysta_av'),
('avnämare','1|konsument'),
('avnötning','1|nöta'),
('avocadosås','1|sås'),
('avocadosås','1|sås'),
('avog','1|ovänlig'),
('avoghet','1|avog'),
('avokado','1|frukt'),
('avokado','1|frukt'),
('avpackning','1|packa_av'),
('avpassa','1|passa'),
('avpassande','1|avpassa'),
('avpassning','1|avpassa'),
('avpatrullera','1|kontrollera'),
('avpatrullerande','1|avpatrullera'),
('avpatrullerbar','1|avpatrullera'),
('avpatrullerbarhet','1|avpatrullerbar'),
('avpatrullering','1|avpatrullera'),
('avpersonifiera','1|utplåna'),
('avpersonifierande','1|avpersonifiera'),
('avpersonifiering','1|avpersonifiera'),
('Avpixlat','1|hatsajt'),
('avplana','1|jämna'),
('avplanande','1|avplana'),
('avplaning','1|avplana'),
('avplockning','1|plocka_av'),
('avpolering','1|polera_av'),
('avpolitisera','1|avlägsna'),
('avpolitiserande','1|avpolitisera'),
('avpolitiserbar','1|avpolitisera'),
('avpolitiserbarhet','1|avpolitiserbar'),
('avpolitisering','1|avpolitisera'),
('avpollettera','1|avskeda'),
('avpolletterande','1|avpollettera'),
('avpolletterbar','1|avpollettera'),
('avpolletterbarhet','1|avpolletterbar'),
('avpollettering','1|avpollettera'),
('avporträttera','1|porträtt'),
('avporträtterande','1|avporträttera'),
('avporträtterbar','1|avporträttera'),
('avporträtterbarhet','1|avporträtterbar'),
('avporträttering','1|avporträttera'),
('avpressa','1|tvinga'),
('avpressande','1|avpressa'),
('avprickning','1|pricka_av'),
('avputsning','1|putsa_av'),
('avrad','1|arrende'),
('avradikalisera','1|radikalisera'),
('avradikaliserande','1|avradikalisera'),
('avradikalisering','1|avradikalisera'),
('avrakad','1|raka'),
('avreagera','1|frigöra'),
('avreagerande','1|avreagera'),
('avreagerbar','1|avreagera'),
('avreagerbarhet','1|avreagerbar'),
('avreagering','1|avreagera'),
('avreda','1|sås'),
('avredande','1|avreda'),
('avredning','1|avreda'),
('avregistrera','1|avlägsna'),
('avregistrerande','1|avregistrera'),
('avregistrerbar','1|avregistrera'),
('avregistrerbarhet','1|avregistrerbar'),
('avregistrering','1|avregistrera'),
('avreglera','1|avlägsna'),
('avreglerande','1|avreglera'),
('avreglerbar','1|avreglera'),
('avreglerbarhet','1|avreglerbar'),
('avreglering','1|avreglera'),
('avrens','1|rensa'),
('avrensning','1|rensa_av'),
('avresa','1|resa'),
('avresa','2|avresa'),
('avresande','1|avresa'),
('avringning','1|avsluta'),
('avrinna','1|rinna'),
('avrinnande','1|avrinna'),
('avrinning','1|avrinna'),
('avritning','1|rita_av'),
('avrivning','1|dusch'),
('avromantisera','1|avlägsna'),
('avromantiserande','1|avromantisera'),
('avromantiserbar','1|avromantisera'),
('avromantiserbarhet','1|avromantiserbar'),
('avromantisering','1|avromantisera'),
('avrop','1|avtal'),
('avrullning','1|rulla_av'),
('avrullning','2|rulla_av'),
('avrullning','3|rulla_av'),
('avrunda','1|rund'),
('avrunda','1|rund'),
('avrunda','2|jämn'),
('avrunda','2|jämn'),
('avrundande','1|avrunda'),
('avrundande','2|avrunda'),
('avrundning','1|avrunda'),
('avrundning','2|avrunda'),
('avrusta','1|avskaffa'),
('avrustande','1|avrusta'),
('avrustning','1|avrusta'),
('avråda','1|råda'),
('avrådan','1|avråda'),
('avrådande','1|avråda'),
('avräkna','1|avräkning'),
('avräknande','1|avräkna'),
('avräkning','1|avdrag'),
('avräkningsnota','1|dokument'),
('avrätta','1|döda'),
('avrättande','1|avrätta'),
('avrättning','1|avrätta'),
('avrättningsdag','1|dag'),
('avrättningslista','1|lista'),
('avrättningsplats','1|plats'),
('avröjning','1|avlägsna'),
('avsadling','1|sadla_av'),
('avsaknad','1|brist'),
('avsaktning','1|sakta_av'),
('avsalta','1|avlägsna'),
('avsaltande','1|avsalta'),
('avsalu','1|försäljning'),
('avsats','1|plan'),
('avse','1|tänka'),
('avsedd','1|avse'),
('avseende','1|avse'),
('avseende','2|uppmärksamma'),
('avsegla','1|segla'),
('avseglande','1|avsegla'),
('avsegling','1|avsegla'),
('avseglingsdag','1|dag'),
('avseglingsort','1|ort'),
('avselning','1|sela_av'),
('avsevärd','1|mycken'),
('avsides','1|belägen'),
('avsides','2|avsides'),
('avsidesliv','1|liv'),
('avsigkommen','1|förfallen'),
('avsigkommenhet','1|avsigkommen'),
('avsikt','1|avse'),
('avsiktlig','1|avsikt'),
('avsiktligen','1|avsiktlig'),
('avsiktlighet','1|avsiktlig'),
('avsiktsbisats','1|bisats'),
('avsiktsförklaring','1|förklaring'),
('avsiktslös','1|avsikt'),
('avsiktssats','1|sats'),
('avsilning','1|sila_av'),
('avsittning','1|avstigning'),
('avsjunga','1|sjunga'),
('avsjungande','1|avsjunga'),
('avskaffa','1|avlägsna'),
('avskaffande','1|avskaffa'),
('avskaffning','1|avskaffa'),
('avskakning','1|skaka_av'),
('avskakning','2|skaka_av'),
('avskalning','1|skala_av'),
('avskava','1|skava'),
('avskavande','1|avskava'),
('avskavning','1|avskava'),
('avsked','1|lämna'),
('avsked','2|avskeda'),
('avskeda','1|bort'),
('avskedande','1|avskeda'),
('avskedsansökan','1|ansökan'),
('avskedsbrev','1|brev'),
('avskedsbägare','1|avskedsskål'),
('avskedsdikt','1|dikt'),
('avskedsfest','1|fest'),
('avskedsföreställning','1|föreställning'),
('avskedshälsning','1|hälsning'),
('avskedskalas','1|kalas'),
('avskedsknull','1|knull'),
('avskedskyss','1|kyss'),
('avskedsmiddag','1|middag'),
('avskedsord','1|ord'),
('avskedspredikan','1|predikan'),
('avskedsskål','1|skål'),
('avskedssång','1|sång'),
('avskedstagande','1|avsked'),
('avskedstal','1|tal'),
('avskedsturné','1|turné'),
('avskedsuppvaktning','1|uppvaktning'),
('avskedsvisit','1|visit'),
('avskeppa','1|skeppa'),
('avskeppning','1|avskeppa'),
('avskeppningshamn','1|hamn'),
('avskeppningsort','1|ort'),
('avskild','1|isolerad'),
('avskildhet','1|avskild'),
('avskilja','1|skilja'),
('avskilja','1|skilja'),
('avskiljande','1|avskilja'),
('avskiljbar','1|avskilja'),
('avskiljbarhet','1|avskiljbar'),
('avskiljning','1|avskilja'),
('avskjuta','1|avlossa'),
('avskjuta','2|skjuta'),
('avskjuta','2|skjuta'),
('avskjutande','1|avskjuta'),
('avskjutande','2|avskjuta'),
('avskjutning','1|avskjuta'),
('avskjutning','2|avskjuta'),
('avskogning','1|avlägsna'),
('avskottning','1|skotta_av'),
('avskottning','2|skotta_av'),
('avskrap','1|avfall'),
('avskrapning','1|skrapa_av'),
('avskrift','1|skriva_av'),
('avskriva','1|avsluta'),
('avskriva','1|avsluta'),
('avskrivande','1|skriva_av'),
('avskrivande','2|avskriva'),
('avskrivare','1|skriva_av'),
('avskrivning','1|avskriva'),
('avskrivningsobjekt','1|objekt'),
('avskrot','1|verktyg'),
('avskrubbning','1|skrubba_av'),
('avskruvning','1|skruva_av'),
('avskruvning','2|skruva_av'),
('avskräcka','1|skrämma'),
('avskräckande','1|avskräcka'),
('avskräckning','1|avskräcka'),
('avskräckningsmedel','1|avskräckning'),
('avskräckningspolitik','1|politik'),
('avskräda','1|jämna'),
('avskrädande','1|avskräda'),
('avskräde','1|avfall'),
('avskrädeshög','1|hög'),
('avskrädning','1|avskräda'),
('avskuddning','1|skudda_av'),
('avskum','1|slödder'),
('avskumning','1|skumma_av'),
('avskurning','1|skura_av'),
('avsky','1|hata'),
('avsky','2|avsky'),
('avskydd','1|avsky'),
('avskyende','1|avsky'),
('avskyffling','1|skyffla_av'),
('avskyväckande','1|avskyvärd'),
('avskyvärd','1|hemsk'),
('avskyvärdhet','1|avskyvärd'),
('avskära','1|hindra'),
('avskärande','1|avskära'),
('avskärare','1|avskära'),
('avskärare','2|skära_av'),
('avskärma','1|skärm'),
('avskärma','1|skärm'),
('avskärmande','1|avskärma'),
('avskärmning','1|avskärma'),
('avskärning','1|avskära'),
('avsköljning','1|skölja_av'),
('avslag','1|nej'),
('avslagen','1|fräsch'),
('avslagenhet','1|avslagen'),
('avslappnad','1|slapp'),
('avslappning','1|avslappnad'),
('avslappningsskiva','1|skiva'),
('avslappningsövning','1|övning'),
('avslickning','1|slicka_av'),
('avslipa','1|slipa'),
('avslipande','1|avslipa'),
('avslipning','1|avslipa'),
('avslita','1|slita'),
('avslitande','1|avslita'),
('avslut','1|överenskommelse'),
('avsluta','1|sluta'),
('avslutande','1|avsluta'),
('avslutning','1|avsluta'),
('avslutningsfest','1|fest'),
('avslutningsvis','1|avslutning'),
('avslå','1|nej'),
('avslående','1|avslå'),
('avslängning','1|slänga'),
('avsläppning','1|släppa_av'),
('avslöja','1|visa'),
('avslöja','2|upptäcka'),
('avslöjande','1|avslöja'),
('avslöjande','2|avslöja'),
('avslöjning','1|avslöja'),
('avslöjning','2|avslöja'),
('avsmak','1|motvilja'),
('avsmaka','1|bedöma'),
('avsmakande','1|avsmaka'),
('avsmakning','1|avsmaka'),
('avsmalna','1|smalna'),
('avsmalnande','1|avsmalna'),
('avsmalning','1|avsmalna'),
('avsmältning','1|smälta'),
('avsnitt','1|del'),
('avsnoppad','1|avvisa'),
('avsnoppande','1|snoppa_av'),
('avsnäsning','1|snäsa_av'),
('avsnöra','1|avskära'),
('avsnörande','1|avsnöra'),
('avsnörning','1|avsnöra'),
('avsnörningsteori','1|teori'),
('avsocialisera','1|privatisera'),
('avsocialiserande','1|avsocialisera'),
('avsocialiserbar','1|avsocialisera'),
('avsocialiserbarhet','1|avsocialiserbar'),
('avsocialisering','1|avsocialisera'),
('avsomna','1|avlida'),
('avsomnande','1|avsomna'),
('avsopning','1|sopa_av'),
('avspark','1|fotboll'),
('avsparkning','1|sparka_av'),
('avspegla','1|spegla'),
('avspeglande','1|avspegla'),
('avspegling','1|avspegla'),
('avspela','1|spela'),
('avspelande','1|avspela'),
('avspelning','1|avspela'),
('avspisa','1|avfärda'),
('avspisande','1|avspisa'),
('avspisning','1|avspisa'),
('avspolning','1|spola_av'),
('avspolning','2|spola_av'),
('avsprång','1|sidosprång'),
('avspänd','1|lugn'),
('avspändhet','1|avspänd'),
('avspänning','1|lugn'),
('avspänningspedagog','1|pedagog'),
('avspärra','1|spärra'),
('avspärrande','1|avspärra'),
('avspärrning','1|avspärra'),
('avspärrningsband','1|plastband'),
('avstalinisera','1|avstalinisering'),
('avstaliniserande','1|avstalinisera'),
('avstaliniserbar','1|avstalinisera'),
('avstaliniserbarhet','1|avstaliniserbar'),
('avstalinisering','1|uppmjukningspolitik'),
('avstamp','1|hoppa'),
('avstanna','1|stanna'),
('avstannande','1|avstanna'),
('avstava','1|ord'),
('avstavande','1|avstava'),
('avstavning','1|avstava'),
('avstavningsregel','1|regel'),
('avstavningssätt','1|avstavning'),
('avsteg','1|avvika'),
('avstickare','1|avvika'),
('avstickning','1|svarva'),
('avstigning','1|stiga_av'),
('avstigningsplats','1|plats'),
('avstjälpning','1|stjälpa_av'),
('avstjälpning','2|sopor'),
('avstjälpningscentral','1|avstjälpning'),
('avstjälpningsplats','1|avstjälpning'),
('avstressa','1|avstressad'),
('avstressad','1|lugn'),
('avstressande','1|avstressa'),
('avstycka','1|avskilja'),
('avstyckande','1|avstycka'),
('avstyckning','1|avstycka'),
('avstyra','1|hindra'),
('avstyrande','1|avstyra'),
('avstyrka','1|nej'),
('avstyrkande','1|avstyrka'),
('avstå','1|få'),
('avstå','2|låta_bli'),
('avstående','1|avstå'),
('avstående','2|avstå'),
('avstånd','1|borta'),
('avståndsbedömning','1|bedömning'),
('avståndsinformation','1|information'),
('avståndskraft','1|avståndsverkan'),
('avståndsmätare','1|mäta'),
('avståndsmätning','1|mätning'),
('avståndstagande','1|ta_avstånd'),
('avståndsverkan','1|verkan'),
('avställa','1|ställa'),
('avställande','1|avställa'),
('avställning','1|avregistrera'),
('avställningsyta','1|yta'),
('avstämmande','1|stämma_av'),
('avstämning','1|stämma_av'),
('avstämpling','1|notering'),
('avstängande','1|stänga_av'),
('avstängande','2|stänga_av'),
('avstängande','3|stänga_av'),
('avstängare','1|stänga_av'),
('avstängare','2|stänga_av'),
('avstängare','3|stänga_av'),
('avstängning','1|stänga_av'),
('avstängning','2|stänga_av'),
('avstängning','3|stänga_av'),
('avstöra','1|avlägsna'),
('avstörande','1|avstöra'),
('avstöta','1|stöta'),
('avstötande','1|avstöta'),
('avstötning','1|avstöta'),
('avsugning','1|suga_av'),
('avsutten','1|sluta'),
('avsvalkning','1|svalka'),
('avsvalna','1|svalna'),
('avsvalnande','1|avsvalna'),
('avsvalning','1|avsvalna'),
('avsvalningshastighet','1|hastighet'),
('avsvavla','1|avlägsna'),
('avsvavlande','1|avsvavla'),
('avsvimmande','1|svimma_av'),
('avsvimning','1|svimma_av'),
('avsvuren','1|avsvärja'),
('avsvärja','1|förneka'),
('avsvärjande','1|avsvärja'),
('avsvärjning','1|avsvärja'),
('avsyna','1|kontrollera'),
('avsynande','1|avsyna'),
('avsynare','1|avsyna'),
('avsyning','1|avsyna'),
('avsågande','1|såga_av'),
('avsågning','1|såga_av'),
('avsäga','1|avkunna'),
('avsägande','1|avsäga'),
('avsägelse','1|avsäga_sig'),
('avsända','1|sända'),
('avsändande','1|avsända'),
('avsändare','1|sända'),
('avsändarnummer','1|telefonnummer'),
('avsändning','1|avsända'),
('avsätta','1|bort'),
('avsätta','2|reservera'),
('avsätta','2|reservera'),
('avsätta','3|sälja'),
('avsätta','4|resultera'),
('avsättande','1|avsätta'),
('avsättande','2|avsätta'),
('avsättande','3|avsätta'),
('avsättande','4|avsätta'),
('avsättlig','1|avsätta'),
('avsättlighet','1|avsättlig'),
('avsättning','1|avsätta'),
('avsättning','2|avsätta'),
('avsättning','3|avsätta'),
('avsättningsbassäng','1|bassäng'),
('avsöka','1|söka'),
('avsökande','1|avsöka'),
('avsökare','1|registrera'),
('avsöndra','1|utsöndra'),
('avsöndrande','1|avsöndra'),
('avsöndring','1|avsöndra'),
('avta','1|minska'),
('avtacka','1|tacka'),
('avtackande','1|avtacka'),
('avtacklad','1|tärd'),
('avtackling','1|tackla_av'),
('avtackning','1|avtacka'),
('avtagande','1|avta'),
('avtagande','2|avta'),
('avtagbar','1|loss'),
('avtagbarhet','1|avtagbar'),
('avtagning','1|ta_av'),
('avtagsväg','1|väg'),
('avtal','1|överens'),
('avtala','1|avtal'),
('avtalande','1|avtala'),
('avtalsbrott','1|bryta'),
('avtalsenlig','1|avtal'),
('avtalsenlighet','1|avtalsenlig'),
('avtalsfrihet','1|avtalsrätt'),
('avtalsförhandling','1|förhandling'),
('avtalsmässig','1|avtal'),
('avtalspension','1|tjänstepension'),
('avtalspensionär','1|avtalspension'),
('avtalsperiod','1|period'),
('avtalsrätt','1|rätt'),
('avtalsrörelse','1|avtalsförhandling'),
('avtalssekreterare','1|sekreterare'),
('avtalsslutande','1|sluta_avtal'),
('avtalsstridig','1|mot'),
('avtappa','1|rinna'),
('avtappande','1|avtappa'),
('avtappning','1|minska'),
('avtappning','2|tappa'),
('avteckna','1|teckna'),
('avtecknande','1|avteckna'),
('avteckning','1|avteckna'),
('avtjäna','1|straff'),
('avtjäna','1|straff'),
('avtjänande','1|avtjäna'),
('avtona','1|nyansera'),
('avtonande','1|avtona'),
('avtoning','1|avtona'),
('avtorkning','1|torka_av'),
('avtrappa','1|minska'),
('avtrappande','1|avtrappa'),
('avtroppning','1|troppa_av'),
('avtrubba','1|förslöa'),
('avtrubba','1|förslöa'),
('avtrubbande','1|avtrubba'),
('avtrubbning','1|avtrubba'),
('avtryck','1|spår'),
('avtryckare','1|avlossa'),
('avtryckning','1|trycka_av'),
('avtryckning','2|trycka_av'),
('avträda','1|överlåta'),
('avträdande','1|avträda'),
('avträdare','1|avträda'),
('avträde','1|avträda'),
('avträde','2|toalett'),
('avträdelse','1|avträda'),
('avtunna','1|tunna'),
('avtunnande','1|avtunna'),
('avtunning','1|avtunna'),
('avtvagning','1|tvagning'),
('avtvinga','1|tvinga'),
('avtvingande','1|avtvinga'),
('avtvå','1|tvätta'),
('avtvående','1|avtvå'),
('avtvättning','1|tvätta_av'),
('avtyning','1|tyna_av'),
('avtåg','1|avmarsch'),
('avtåga','1|avtåg'),
('avtågande','1|avtåga'),
('avtäcka','1|avlägsna'),
('avtäckande','1|avtäcka'),
('avtäckning','1|avtäcka'),
('avtäckningsceremoni','1|ceremoni'),
('avtändande','1|stimulera'),
('avtärd','1|mager'),
('avtärdhet','1|avtärd'),
('avulavirusinfektion','1|virusinfektion'),
('avund','1|missunna'),
('avundas','1|avund'),
('avundsam','1|avundsjuk'),
('avundsamhet','1|avundsam'),
('avundsfri','1|avund'),
('avundsfull','1|avund'),
('avundsjuk','1|avund'),
('avundsjuka','1|avundsjuk'),
('avundsjukhet','1|avundsjuk'),
('avundsman','1|avundsjuk'),
('avundsvärd','1|avund'),
('avundsvärdhet','1|avundsvärd'),
('avvakta','1|vänta'),
('avvaktande','1|avvakta'),
('avvand','1|avvänja'),
('avvara','1|utan'),
('avvarad','1|avvara'),
('avvarande','1|avvara'),
('avvattna','1|avlägsna'),
('avvattnande','1|avvattna'),
('avvattning','1|avvattna'),
('avveckla','1|upphöra'),
('avvecklande','1|avveckla'),
('avveckling','1|avveckla'),
('avvecklingsbeslut','1|beslut'),
('avverka','1|resultat'),
('avverka','2|fälla'),
('avverkande','1|avverka'),
('avverkande','2|avverka'),
('avverkning','1|avverka'),
('avverkningsarbete','1|avverkning'),
('avverkningsrätt','1|rätt'),
('avvika','1|lämna'),
('avvika','2|skilja_sig'),
('avvikande','1|avvika'),
('avvikande','2|avvika'),
('avvikande','3|avvika'),
('avvikare','1|avvika'),
('avvikelse','1|avvika'),
('avvikelse','2|avvika'),
('avvikelseprocent','1|procent'),
('avviken','1|avvika'),
('avvindning','1|vinda_av'),
('avvinna','1|utvinna'),
('avvinnande','1|avvinna'),
('avvisa','1|vägra'),
('avvisa','2|förvägra'),
('avvisande','1|avvisa'),
('avvisande','2|avvisa'),
('avvisare','1|räcke'),
('avvisning','1|avvisa'),
('avvisningsbeslut','1|beslut'),
('avvita','1|vettlös'),
('avvitande','1|avvita'),
('avvittra','1|vittra'),
('avvittrande','1|avvittra'),
('avväg','1|väg'),
('avväga','1|väga'),
('avväga','2|mäta'),
('avvägande','1|avväga'),
('avvägande','2|avväga'),
('avvägning','1|avväga'),
('avvägning','2|avväga'),
('avvägningsinstrument','1|instrument'),
('avvältring','1|vältra_av'),
('avvända','1|förhindra'),
('avvändande','1|avvända'),
('avvändning','1|avvända'),
('avvänja','1|vänja'),
('avvänjande','1|avvänja'),
('avvänjning','1|avvänja'),
('avvänjningstid','1|tid'),
('avväpna','1|frånta'),
('avväpnande','1|försonande'),
('avväpnande','2|avväpna'),
('avvärja','1|hindra'),
('avvärjande','1|avvärja'),
('avvärjning','1|avvärja'),
('avväxling','1|växla_av'),
('avytterlig','1|avyttra'),
('avytterlighet','1|avytterlig'),
('avyttra','1|sälja'),
('avyttrande','1|avyttra'),
('avåkning','1|åka_av'),
('aväta','1|inta'),
('avätande','1|aväta'),
('ax','1|säd'),
('ax','2|nyckelax'),
('ax','3|acceleration'),
('axa','1|accelerera'),
('axande','1|axa'),
('axblommig','1|ax'),
('axel','1|kropp'),
('axel','2|hjul'),
('axelband','1|band'),
('axelbred','1|axel'),
('axelbössa','1|nav'),
('axeldiameter','1|diameter'),
('axelfraktur','1|fraktur'),
('axelgehäng','1|bära'),
('axelhål','1|hål'),
('axelhölster','1|hölster'),
('axelinflammation','1|inflammation'),
('axelklaff','1|prydnad'),
('axelkoppling','1|koppling'),
('axellager','1|lager'),
('axelled','1|led'),
('axelledsdislokation','1|dislokation'),
('axelledsluxation','1|luxation'),
('axellång','1|lång'),
('axelmuff','1|axelkoppling'),
('axelrem','1|bärrem'),
('axelremsväska','1|väska'),
('axelriktning','1|riktning'),
('axelring','1|ring'),
('axelryckning','1|likgiltig'),
('axelset','1|set'),
('axelsmärta','1|smärta'),
('axelsprint','1|sprint'),
('axelvadd','1|stoppning'),
('axformig','1|ax'),
('axial','1|axel'),
('axillarkrycka','1|krycka'),
('axiom','1|sann'),
('axiom','2|självklar'),
('axiomatisera','1|axiom'),
('axiomatiserande','1|axiomatisera'),
('axiomatiserbar','1|axiomatisera'),
('axiomatiserbarhet','1|axiomatiserbar'),
('axiomatisering','1|axiomatisera'),
('axiomatisk','1|axiom'),
('axiomatisk','2|självklar'),
('axion','1|partikel'),
('axionförtätning','1|förtätning'),
('axla','1|överta'),
('axla','2|axel'),
('axlande','1|axla'),
('axlande','2|axla'),
('axplock','1|urval'),
('axsvingel','1|gräs'),
('ayahuasca','1|naturmedicin'),
('ayatolla','1|präst'),
('ayatolla','1|präst'),
('ayatolla','2|maktfullkomlig'),
('ayrshireboskap','1|nötkreatur'),
('azalea','1|krukväxt'),
('azerbajdzjan','1|Azerbajdzjan'),
('Azerbajdzjan','1|land'),
('azerbajdzjansk','1|Azerbajdzjan'),
('azerbajdzjanska','1|azerbajdzjan'),
('azerbajdzjanska','2|språk'),
('azimut','1|läge'),
('azimut','1|läge'),
('azoospermi','1|spermie'),
('azotemi','1|blodsjukdom'),
('aztek','1|indianfolk'),
('aztekisk','1|aztek'),
('azur','1|azurblå'),
('azurblå','1|blå'),
('azurfärg','1|azur'),
('b','1|bokstav'),
('B','1|initial'),
('ba','1|säga'),
('babbel','1|babbla'),
('Babbitt','1|roman'),
('babbla','1|prata'),
('babblande','1|babbla'),
('babblare','1|babbla'),
('babian','1|apa'),
('babian','2|usling'),
('babianröv','1|röv'),
('babord','1|vänster'),
('babord','2|vänster'),
('babordsida','1|babord'),
('babordsvakt','1|besättning'),
('babordsåra','1|åra'),
('babusjka','1|mormor'),
('babusjka','2|tant'),
('baby','1|barn'),
('babyboom','1|ökning'),
('babybyxa','1|byxor'),
('babydräkt','1|dräkt'),
('babykläder','1|kläder'),
('Babylon','1|huvudstad'),
('Babylon','1|huvudstad'),
('Babylonien','1|land'),
('babylonier','1|Babylon'),
('babylonisk','1|Babylon'),
('babylycka','1|lycklig'),
('babysim','1|simma'),
('babysitter','1|stol'),
('babysketch','1|sketch'),
('baccarat','1|kortspel'),
('Bacchus','1|gud'),
('Bachfuga','1|fuga'),
('bacill','1|smittämne'),
('bacill','2|bakterie'),
('bacillbärare','1|bärare'),
('bacillfri','1|bacill'),
('bacillskräck','1|skräck'),
('back','1|fotbollsspelare'),
('back','2|växel'),
('back','3|förvara'),
('back','4|fördäck'),
('backa','1|bakåt'),
('backa','2|långrev'),
('backa','3|igen'),
('backa','4|ändra_sig'),
('backanal','1|dryckeslag'),
('backanalant','1|backanal'),
('backanalisk','1|backanal'),
('backande','1|backa'),
('backande','2|backa'),
('backanis','1|anis'),
('backant','1|kvinna'),
('backe','1|luta'),
('backfisch','1|tonåring'),
('backgammon','1|spel'),
('backhammer','1|brottningsgrepp'),
('backhand','1|tennis'),
('backhoppare','1|backhoppning'),
('backhoppning','1|hopp'),
('backig','1|backe'),
('backighet','1|backig'),
('backkrön','1|krön'),
('backlandskap','1|landskap'),
('backning','1|backa'),
('backning','2|backa'),
('backpacker','1|backpacking'),
('backpacking','1|ryggsäcksturism'),
('backsignal','1|signal'),
('backsippa','1|sippa'),
('backslag','1|axel'),
('backspegel','1|spegel'),
('backstag','1|mast'),
('backström','1|ström'),
('backstuga','1|stuga'),
('backstugusittare','1|backstuga'),
('backsvala','1|svala'),
('backsöta','1|ärtväxt'),
('backtimjan','1|timjan'),
('backup','1|data'),
('backup','1|data'),
('backupa','1|backup'),
('backupa','1|backup'),
('backupande','1|backupa'),
('backupande','1|backupa'),
('backvial','1|vial'),
('backväxel','1|växel'),
('bacon','1|sidfläsk'),
('bad','1|bada'),
('bad','2|doppa'),
('bada','1|vatten'),
('badande','1|bada'),
('badanka','1|anka'),
('badanläggning','1|anläggning'),
('badanstalt','1|anstalt'),
('badare','1|bada'),
('badbassäng','1|bassäng'),
('badbild','1|bild'),
('badborste','1|borste'),
('badbyxor','1|byxor'),
('badda','1|fukta'),
('baddande','1|badda'),
('baddare','1|skicklig'),
('baddjävel','1|sommargäst'),
('baddning','1|badda'),
('baddräkt','1|dräkt'),
('Baden-Baden','1|kurort'),
('badensare','1|Baden-Baden'),
('badensisk','1|Baden-Baden'),
('badflicka','1|flicka'),
('badförbud','1|förbud'),
('badgäst','1|turist'),
('badhandduk','1|handduk'),
('badhus','1|bad'),
('badhytt','1|omklädningsrum'),
('badinrättning','1|inrättning'),
('badkappa','1|kläder'),
('badkar','1|bad'),
('badkarseffekt','1|effekt'),
('badkarskant','1|kant'),
('badklippa','1|klippa'),
('badkläder','1|kläder'),
('badlakan','1|handduk'),
('badläkare','1|läkare'),
('badminton','1|sport'),
('badmintonboll','1|boll'),
('badmintonracket','1|racket'),
('badmintonracket','1|racket'),
('badmössa','1|mössa'),
('badning','1|bada'),
('badort','1|ort'),
('badortsliv','1|liv'),
('badortsstad','1|stad'),
('badplats','1|plats'),
('badresa','1|resa'),
('badrum','1|rum'),
('badrumsdörr','1|dörr'),
('badrumsfläkt','1|fläkt'),
('badrumsfärg','1|färg'),
('badrumsgolv','1|golv'),
('badrumskakel','1|kakel'),
('badrumsmöbel','1|möbel'),
('badrumsskåp','1|skåp'),
('badrumsspegel','1|spegel'),
('badsalt','1|badvatten'),
('badsemester','1|semester'),
('badsjö','1|sjö'),
('badsko','1|sko'),
('badstrand','1|strand'),
('badstuga','1|sommarstuga'),
('badställe','1|ställe'),
('badtoffel','1|toffel'),
('badtunna','1|tunna'),
('badturist','1|turist'),
('badvakt','1|vakt'),
('badvatten','1|vatten'),
('bag','1|väska'),
('bag','1|väska'),
('bagage','1|resa'),
('bagage','2|bagageutrymme'),
('bagagehylla','1|hylla'),
('bagageinlämning','1|förvara'),
('bagagekärra','1|kärra'),
('bagagelucka','1|bagageutrymme'),
('bagagerum','1|rum'),
('bagagestropp','1|stropp'),
('bagageutrymme','1|förvara'),
('bagagevagn','1|vagn'),
('bagarbod','1|sälja'),
('bagare','1|baka'),
('bagare','2|bagis'),
('bagarmössa','1|mössa'),
('bagarstuga','1|bageri'),
('bagatell','1|småsak'),
('bagatellartad','1|bagatell'),
('bagatellisera','1|bagatell'),
('bagatelliserande','1|bagatellisera'),
('bagatelliserbar','1|bagatellisera'),
('bagatelliserbarhet','1|bagatelliserbar'),
('bagatellisering','1|bagatellisera'),
('bagatellmål','1|mål'),
('Bagdad','1|huvudstad'),
('bagel','1|bröd'),
('bageri','1|baka'),
('bagerimargarin','1|margarin'),
('bagerirörelse','1|rörelse'),
('baggböla','1|baggböleri'),
('baggbölande','1|baggböla'),
('baggbölare','1|baggböla'),
('baggböleri','1|svindleri'),
('bagge','1|får'),
('bag-in-box','1|lådvin'),
('bag-in-box','1|lådvin'),
('bagis','1|krona'),
('baguette','1|bröd'),
('bah','1|fy'),
('bahaman','1|Bahamas'),
('bahamansk','1|Bahamas'),
('bahamanska','1|bahaman'),
('Bahamas','1|ö'),
('Bahrain','1|land'),
('Bahrain','1|land'),
('bahrainare','1|Bahrain'),
('bahrainsk','1|Bahrain'),
('bahrainska','1|bahrainare'),
('bahytt','1|mössa'),
('baissa','1|baisse'),
('baissande','1|baissa'),
('baisse','1|börs'),
('baissespekulation','1|spekulation'),
('baja','1|bajsa'),
('bajadär','1|danserska'),
('bajamaja','1|dass'),
('bajamaja','1|dass'),
('bajande','1|baja'),
('bajersk','1|Bayern'),
('bajonett','1|vapen'),
('bajonettanfall','1|anfall'),
('bajonettbalja','1|fodral'),
('bajonettfattning','1|koppla'),
('bajonettförsedd','1|förse'),
('bajonettspets','1|spets'),
('bajrare','1|Bayern'),
('bajs','1|bajsa'),
('bajsa','1|avföring'),
('bajsande','1|bajsa'),
('bajsbrun','1|brun'),
('bajshög','1|hög'),
('bajsig','1|bajs'),
('bajskorv','1|bajs'),
('bajsnödig','1|nödig'),
('bajstransplantat','1|avföringstransplantat'),
('bajstransplantation','1|avföringstransplantation'),
('bak','1|framme'),
('bak','2|stjärt'),
('bak','3|baka'),
('baka','1|bröd'),
('bakande','1|baka'),
('bakarv','1|bakarvinge'),
('bakarvinge','1|arvinge'),
('bakaxel','1|axel'),
('bakaxelväxel','1|växel'),
('bakben','1|ben'),
('bakbinda','1|binda'),
('bakbinda','2|förhindra'),
('bakbindande','1|bakbinda'),
('bakbindande','2|bakbinda'),
('bakbindning','1|bakbinda'),
('bakbindning','2|bakbinda'),
('bakblåsare','1|eldvapen'),
('bakböjd','1|bakåtböjd'),
('bakdanta','1|baktala'),
('bakdantande','1|bakdanta'),
('bakdantare','1|bakdanta'),
('bakdanteri','1|bakdanta'),
('bakdel','1|del'),
('bakdel','2|stjärt'),
('bakdäck','1|däck'),
('bakdörr','1|dörr'),
('bakefter','1|bak'),
('bakelit','1|plast'),
('bakelse','1|bakverk'),
('bakerst','1|bak'),
('bakersta','1|bak'),
('bakficka','1|ficka'),
('bakflygel','1|bilkaross'),
('bakfot','1|fot'),
('bakfram','1|motsatt'),
('bakfull','1|full'),
('bakfullhet','1|bakfull'),
('bakfylla','1|bakfull'),
('bakgata','1|gata'),
('bakgrund','1|bak'),
('bakgrundsfigur','1|figur'),
('bakgrundsljud','1|ljud'),
('bakgrundsmusik','1|musik'),
('bakgrundsreportage','1|reportage'),
('bakgrundsskildring','1|skildring'),
('bakgrundssorl','1|sorl'),
('bakgrundsstrålning','1|strålning'),
('bakgrundstal','1|tal'),
('bakgrundston','1|ton'),
('bakgrundsvariabel','1|variabel'),
('bakgård','1|gård'),
('bakhal','1|hal'),
('bakhas','1|bakben'),
('bakhjul','1|hjul'),
('bakhjulsdriven','1|driva'),
('bakhov','1|hov'),
('bakhuvud','1|huvud'),
('bakhåll','1|lura'),
('baki','1|bak'),
('baki','2|baki'),
('bakifrån','1|från'),
('bakifrån','2|bakifrån'),
('bakis','1|bakfull'),
('bakjour','1|jour'),
('bakkant','1|kant'),
('bakkappa','1|skydd'),
('bakkropp','1|kropp'),
('bakladdare','1|eldvapen'),
('bakladdning','1|bakladdare'),
('baklampa','1|bakljus'),
('bakland','1|inland'),
('bakljus','1|billjus'),
('bakljusramp','1|ramp'),
('baklucka','1|bagageutrymme'),
('baklukt','1|lukt'),
('baklänges','1|bakåt'),
('baklängesordbok','1|ordbok'),
('baklängesvandring','1|vandring'),
('bakläxa','1|underkänd'),
('bakning','1|baka'),
('bakom','1|bak'),
('bakom','2|dum'),
('bakomliggande','1|bakom'),
('bakomsittande','1|sitta'),
('bakomvarande','1|bakom'),
('bakplåt','1|plåt'),
('bakplåtspapper','1|papper'),
('bakport','1|port'),
('bakprojektion','1|film'),
('bakpulver','1|baka'),
('bakpå','1|bak'),
('bakpå','2|bakpå'),
('bakre','1|bak'),
('bakrus','1|bakfull'),
('bakruta','1|bilruta'),
('baksida','1|bak'),
('baksidesreklam','1|reklam'),
('baksidestext','1|text'),
('bakslag','1|motgång'),
('bakslagsventil','1|ventil'),
('bakslug','1|slug'),
('bakslughet','1|bakslug'),
('baksmälla','1|bakfull'),
('bakspår','1|spår'),
('baksteg','1|steg'),
('bakstreck','1|snedstreck'),
('baksträvare','1|bakåtsträvare'),
('bakström','1|bakvatten'),
('bakstycke','1|del'),
('baksäte','1|bilsäte'),
('baktal','1|baktala'),
('baktala','1|förtala'),
('baktalande','1|baktala'),
('baktalare','1|baktala'),
('baktanke','1|tanke'),
('baktass','1|tass'),
('baktericid','1|bakteriedödande'),
('baktericid','2|bakteriedödande'),
('bakterie','1|mikroorganism'),
('bakterieart','1|art'),
('bakteriedödande','1|döda'),
('bakterieflora','1|bakterie'),
('bakteriefri','1|bakterie'),
('bakteriehärd','1|anhopning'),
('bakterieinfektion','1|infektion'),
('bakteriekultur','1|kultur'),
('bakteriell','1|bakterie'),
('bakteriesmittad','1|smitta'),
('bakteriofag','1|virus'),
('bakteriolog','1|bakteriologi'),
('bakteriologi','1|vetenskap'),
('bakteriologisk','1|bakterie'),
('baktill','1|bak'),
('baktrappa','1|trappa'),
('baktung','1|tung'),
('baktunghet','1|baktung'),
('bakugn','1|ugn'),
('bakut','1|bak'),
('bakut','1|bak'),
('bakvagn','1|vagn'),
('bakvatten','1|ström'),
('bakverk','1|baka'),
('bakvid','1|bak'),
('bakvid','2|bakvid'),
('bakvikt','1|baktung'),
('bakvinge','1|vinge'),
('bakväg','1|gå'),
('bakvägg','1|vägg'),
('bakvänd','1|bakfram'),
('bakvändhet','1|bakvänd'),
('bakåt','1|bak'),
('bakåtblickande','1|blicka'),
('bakåtböjd','1|böja'),
('bakåtkammad','1|kamma'),
('bakåtlutad','1|luta'),
('bakåtriktad','1|bakåt'),
('bakåträknande','1|räkna'),
('bakåtsteg','1|danssteg'),
('bakåtsträvande','1|reaktionär'),
('bakåtsträvare','1|bakåtsträvande'),
('bakända','1|del'),
('bakända','1|del'),
('baköver','1|bakåt'),
('baköver','2|baköver'),
('bal','1|dansa'),
('bal','2|packe'),
('bala','1|bal'),
('balaklava','1|skidmössa'),
('balaklava','1|skidmössa'),
('balalajka','1|instrument'),
('balalajkaspelare','1|balalajka'),
('balande','1|bala'),
('balans','1|jämn'),
('balans','2|skillnad'),
('balansakt','1|balans'),
('balansakt','2|balansgång'),
('balansera','1|jämvikt'),
('balansera','2|balans'),
('balanserad','1|balansera'),
('balanserande','1|balansera'),
('balanserande','2|balansera'),
('balanserbar','1|balansera'),
('balanserbarhet','1|balanserbar'),
('balansering','1|balansera'),
('balansering','2|balansera'),
('balanserstång','1|lindansare'),
('balansgång','1|manövrera'),
('balansgång','2|balansera'),
('balanshjul','1|svänghjul'),
('balanskonstnär','1|balansera'),
('balanskonto','1|konto'),
('balansnummer','1|nummer'),
('balansorgan','1|organ'),
('balansplog','1|plog'),
('balansroder','1|roder'),
('balansrubbning','1|rubbning'),
('balansräkning','1|balanskonto'),
('balanssinne','1|sinne'),
('balansvåg','1|våg'),
('balata','1|isoleringsmaterial'),
('baldakin','1|tak'),
('Balder','1|gud'),
('baldersbrå','1|blomma'),
('baldrottning','1|bal'),
('bale','1|fågelbo'),
('balett','1|dansa'),
('balettdans','1|balett'),
('balettdansör','1|dansör'),
('balettdansös','1|dansös'),
('balettflicka','1|balettdansös'),
('balettmästare','1|ledare'),
('balgäst','1|gäst'),
('Bali','1|ö'),
('balinesisk','1|Bali'),
('balja','1|kar'),
('balja','2|fröhus'),
('baljväxt','1|växt'),
('balk','1|bära'),
('balk','2|lagbalk'),
('balk','3|vapensköld'),
('Balkan','1|Sydeuropa'),
('balkanfolk','1|folk'),
('balkaniserad','1|balkanisering'),
('balkanisering','1|söndra'),
('balkanländerna','1|Balkan'),
('balkansk','1|Balkan'),
('balkknä','1|fartyg'),
('balklänning','1|festklänning'),
('balkmått','1|mått'),
('balkong','1|hus'),
('balkongdörr','1|dörr'),
('balkongdörr','2|dörr'),
('balkonglåda','1|låda'),
('balkongräcke','1|räcke'),
('balksko','1|beslag'),
('balkverk','1|balk'),
('balkvägare','1|däcksbalk'),
('ball','1|kul'),
('ballad','1|sång'),
('balladdiktning','1|ballad'),
('balle','1|testikel'),
('ballerina','1|balettdansös'),
('ballhet','1|ball'),
('ballistik','1|projektil'),
('ballistisk','1|projektilbana'),
('Ballograf','1|kulspetspenna'),
('Ballograf','1|kulspetspenna'),
('ballong','1|rund'),
('ballongbluff','1|ballongfamiljen'),
('ballongboll','1|bollspel'),
('ballongburen','1|bära'),
('ballongdäck','1|däck'),
('ballongfamiljen','1|familj'),
('ballongfärd','1|färd'),
('ballonggas','1|gas'),
('ballonggondol','1|gondol'),
('ballongmage','1|magbesvär'),
('ballongpojken','1|ballongfamiljen'),
('ballongprick','1|sjömärke'),
('ballongsegel','1|segel'),
('ballongvisp','1|visp'),
('balloptikon','1|episkop'),
('ballotera','1|omröstning'),
('balloterande','1|ballotera'),
('balloterbar','1|ballotera'),
('balloterbarhet','1|balloterbar'),
('ballotering','1|ballotera'),
('balneolog','1|balneologi'),
('balneologi','1|vetenskap'),
('balneologisk','1|balneologi'),
('balsa','1|balsaträ'),
('balsal','1|sal'),
('balsam','1|olja'),
('balsamdoftande','1|dofta'),
('balsamera','1|konservera'),
('balsamerande','1|balsamera'),
('balsamerbar','1|balsamera'),
('balsamerbarhet','1|balsamerbar'),
('balsamering','1|balsamera'),
('balsamin','1|krukväxt'),
('balsamisk','1|balsam'),
('balsamterpentin','1|terpentin'),
('balsaträ','1|trä'),
('balt','1|Baltikum'),
('Baltikum','1|Östersjön'),
('Baltimore','1|stad'),
('baltisk','1|Baltikum'),
('baltiska','1|balt'),
('baltutlämning','1|utlämning'),
('baluns','1|bal'),
('baluster','1|pelare'),
('balustrad','1|räcke'),
('bamba','1|barnbespisning'),
('Bambara','1|skalbagge'),
('bambu','1|gräs'),
('bamburör','1|virke'),
('bambusoffa','1|soffa'),
('Bamse','1|seriefigur'),
('ban','1|städ'),
('ban','2|furste'),
('bana','1|väg'),
('bana','2|plan'),
('banal','1|vanlig'),
('banalisera','1|banal'),
('banaliserande','1|banalisera'),
('banaliserbar','1|banalisera'),
('banaliserbarhet','1|banaliserbar'),
('banalisering','1|banalisera'),
('banalitet','1|banal'),
('banan','1|frukt'),
('bananbana','1|partikelbana'),
('bananfluga','1|fluga'),
('bananformad','1|banan'),
('banankontakt','1|stickpropp'),
('bananrepublik','1|u-land'),
('bananstock','1|banan'),
('bananträd','1|träd'),
('banarbete','1|arbete'),
('banbrytande','1|pionjär'),
('banbrytare','1|pionjär'),
('band','1|binda'),
('band','2|omslag'),
('band','3|grupp'),
('band','4|samman'),
('band','5|magnetband'),
('band','6|transportband'),
('banda','1|spela_in'),
('bandage','1|förband'),
('bandande','1|banda'),
('bandel','1|del'),
('banderoll','1|plakat'),
('banderoll','1|plakat'),
('bandfordon','1|fordon'),
('bandformig','1|band'),
('bandgenerator','1|generator'),
('bandhund','1|hund'),
('bandit','1|brottsling'),
('banditaktig','1|bandit'),
('banditgäng','1|gäng'),
('bandjärn','1|band'),
('bandkantning','1|kantning'),
('bandkniv','1|kniv'),
('bandmedlem','1|medlem'),
('bandolär','1|bantlär'),
('bandotek','1|ljudband'),
('bandspektrum','1|färgspektrum'),
('bandspelare','1|spela_in'),
('bandstation','1|läsa'),
('bandstump','1|band'),
('bandsåg','1|såg'),
('bandtraktor','1|traktor'),
('bandupptagning','1|ljudupptagning'),
('bandvimpel','1|vimpel'),
('bandy','1|sport'),
('bandyboll','1|boll'),
('bandyfanatiker','1|fanatiker'),
('bandyklubba','1|klubba'),
('bandyrör','1|skridsko'),
('bandyslag','1|slag'),
('bane','1|döda'),
('banehugg','1|hugg'),
('baneman','1|bane'),
('baner','1|fana'),
('banerförare','1|bärare'),
('banesår','1|sår'),
('bang','1|knall'),
('Bang','2|journalist'),
('bang','2|ängslig'),
('banghet','1|bang'),
('Bangkok','1|huvudstad'),
('Bangladesh','1|land'),
('bangladeshare','1|Bangladesh'),
('bangladeshier','1|Bangladesh'),
('bangladeshisk','1|Bangladesh'),
('bangladeshiska','1|bangladeshier'),
('bangolf','1|minigolf'),
('bangård','1|järnväg'),
('banhall','1|järnvägsstation'),
('baning','1|nervcell'),
('banjo','1|instrument'),
('banjoinstrument','1|banjo'),
('bank','1|pengar'),
('bank','2|grund'),
('bank','3|vall'),
('banka','1|slå'),
('bankande','1|banka'),
('bankanställd','1|anställd'),
('bankbok','1|notera'),
('bankdirektion','1|direktion'),
('bankdirektör','1|direktör'),
('bankett','1|måltid'),
('bankfack','1|förvara'),
('bankföretag','1|bank'),
('bankgiro','1|bank'),
('bankhus','1|hus'),
('bankinrättning','1|bank'),
('bankinspektion','1|inspektion'),
('bankir','1|bank'),
('bankirfirma','1|firma'),
('bankirhustru','1|hustru'),
('bankkamrer','1|kamrer'),
('bankkapital','1|kapital'),
('bankkassör','1|kassör'),
('bankkollaps','1|kollaps'),
('bankkonto','1|konto'),
('bankkontor','1|bank'),
('bankkort','1|kontokort'),
('bankkund','1|kund'),
('banklag','1|lag'),
('banklån','1|lån'),
('banklån','1|lån'),
('bankman','1|anställd'),
('bankmässig','1|bank'),
('banknisse','1|bankman'),
('banko','1|mynt'),
('banko','1|mynt'),
('bankofullmäktig','1|fullmäktig'),
('bankomat','1|automat'),
('bankomatkort','1|kort'),
('bankomatkupp','1|kupp'),
('bankomatrånare','1|rånare'),
('bankpalats','1|palats'),
('bankpanik','1|panik'),
('bankreglering','1|reglering'),
('bankrutt','1|konkurs'),
('bankrutt','2|bankrutt'),
('bankruttera','1|bankrutt'),
('bankrutterande','1|bankruttera'),
('bankrutterbar','1|bankruttera'),
('bankrutterbarhet','1|bankrutterbar'),
('bankruttering','1|bankruttera'),
('bankruttförklaring','1|förklara'),
('bankruttmässig','1|bankrutt'),
('bankruttör','1|bankrutt'),
('bankrån','1|rån'),
('bankrånare','1|bankrån'),
('bankränta','1|ränta'),
('bankrörelse','1|rörelse'),
('banksektor','1|sektor'),
('banksparande','1|spara'),
('bankstyrelse','1|styrelse'),
('banktjänsteman','1|tjänsteman'),
('bankväsen','1|bank'),
('bankväxel','1|växel'),
('banlöpning','1|löpning'),
('bann','1|bannlysa'),
('banna','1|förebrå'),
('bannande','1|banna'),
('bannbulla','1|bannlysa'),
('bannlysa','1|utstöta'),
('bannlysa','2|förbjuda'),
('bannlysande','1|bannlysa'),
('bannlysande','2|bannlysa'),
('bannlysning','1|bannlysa'),
('bannlysning','2|bannlysa'),
('bannor','1|banna'),
('bannstråle','1|bannlysa'),
('bannät','1|nät'),
('banrekord','1|rekord'),
('banrörelse','1|rörelse'),
('banskjutning','1|banskytte'),
('banskytte','1|skytte'),
('banta','1|minska'),
('banta','2|skära_ner'),
('Bantam','1|Serang'),
('bantamvikt','1|viktklass'),
('bantamviktare','1|bantamvikt'),
('bantande','1|banta'),
('bantlär','1|patronväska'),
('bantning','1|banta'),
('bantningshysteri','1|hysteri'),
('bantningskur','1|kur'),
('bantningsmedel','1|medel'),
('bantningspiller','1|piller'),
('bantufolk','1|folk'),
('bantuspråk','1|språk'),
('banunderhåll','1|underhåll'),
('banvagn','1|järnväg'),
('banvakt','1|järnväg'),
('banvall','1|järnväg'),
('Banverket','1|verk'),
('Banverket','1|verk'),
('Banverkspersonal','1|personal'),
('Banverkspersonal','1|personal'),
('baptism','1|baptist'),
('baptist','1|sekt'),
('baptistdop','1|dop'),
('baptisterium','1|dopbassäng'),
('baptistisk','1|baptism'),
('baptistpastor','1|pastor'),
('baptistpredikant','1|predikant'),
('bar','1|naken'),
('bar','2|lokal'),
('bar','3|mått'),
('bara','1|PRIM'),
('bara','2|bara'),
('barack','1|bostad'),
('barackläger','1|läger'),
('bararmad','1|arm'),
('baraxlad','1|axel'),
('barbadier','1|Barbados'),
('barbadisk','1|Barbados'),
('barbadiska','1|barbadier'),
('Barbados','1|ö'),
('barbar','1|primitiv'),
('Barbara','1|Barbro'),
('barbarhövding','1|hövding'),
('barbari','1|barbar'),
('barbarisk','1|barbar'),
('barbarism','1|barbar'),
('barbent','1|strumpa'),
('barberare','1|frisör'),
('barberarstol','1|frisörstol'),
('barbiturat','1|medicin'),
('barbröstad','1|bröst'),
('barbröstad','2|bröst'),
('Barcelona','1|stad'),
('bard','1|tand'),
('bard','2|skald'),
('bardisan','1|spjut'),
('bardisk','1|bar'),
('bardun','1|stag'),
('bardval','1|val'),
('barett','1|mössa'),
('barfota','1|sko'),
('barfotad','1|barfota'),
('barfotalasse','1|fattig'),
('barfotaläkare','1|läkare'),
('barfotalöpning','1|löpning'),
('barfotamunk','1|munk'),
('barfrost','1|frost'),
('barhet','1|bar'),
('barhuvad','1|mössa'),
('barhänt','1|handske'),
('barium','1|grundämne'),
('barium','1|grundämne'),
('bariumförening','1|förening'),
('bariumsalt','1|salt'),
('bariumsulfat','1|bariumsalt'),
('bark','1|skal'),
('bark','2|segelfartyg'),
('barka','1|avlägsna'),
('barka','2|bära_hän'),
('barka','3|garva'),
('barkande','1|barka'),
('barkande','2|barka'),
('barkande','3|barka'),
('barkaroll','1|roddarsång'),
('barkass','1|båt'),
('barkborre','1|skalbagge'),
('barkbröd','1|bröd'),
('barkbåt','1|leksaksbåt'),
('barklag','1|extrakt'),
('barkskepp','1|bark'),
('barkspade','1|barka'),
('barktäkt','1|insamla'),
('barkund','1|kund'),
('barkympa','1|ympa'),
('barkympande','1|barkympa'),
('barlast','1|last'),
('barlast','1|last'),
('barlasta','1|barlast'),
('barlastande','1|barlasta'),
('barlastköl','1|köl'),
('barlastning','1|barlasta'),
('barm','1|bröst'),
('barmark','1|snö'),
('barmhärtig','1|nåd'),
('barmhärtighet','1|barmhärtig'),
('barmhärtighetsgärning','1|gärning'),
('barmhärtighetsmord','1|mord'),
('barmhärtighetsverk','1|barmhärtighet'),
('barn','1|människa'),
('barn','1|människa'),
('barn','2|förälder'),
('barn','2|förälder'),
('barnadödlighet','1|dödlighet'),
('barnafar','1|far'),
('barnafödande','1|föda'),
('barnaföderska','1|föda'),
('barnaga','1|aga'),
('barnahjärta','1|oskyldig'),
('barnalstrande','1|alstrande'),
('barnamord','1|mord'),
('barnamordanstiftan','1|anstiftan'),
('barnamördare','1|mörda'),
('barnansikte','1|ansikte'),
('barnarbete','1|arbete'),
('barnarbetskraft','1|arbetskraft'),
('barnarov','1|röva_bort'),
('barnarov','1|röva_bort'),
('barnasinne','1|sinne'),
('barnasjäl','1|oskyldig'),
('barnaskara','1|skara'),
('barnatro','1|tro'),
('barnavård','1|vård'),
('barnavårdscentral','1|hälsokontroll'),
('barnavårdsman','1|hjälpa'),
('barnavårdsnämnd','1|nämnd'),
('barnbarn','1|barn'),
('barnbarnsbarn','1|barnbarn'),
('barnbeck','1|avföring'),
('barnbegränsning','1|begränsning'),
('barnbespisning','1|matsal'),
('barnbesök','1|besök'),
('barnbidrag','1|bidrag'),
('barnbok','1|bok'),
('barnboksfigur','1|figur'),
('barnby','1|inrättning'),
('barnbördshus','1|förlossningsanstalt'),
('barncrosshjälm','1|crosshjälm'),
('barncykel','1|cykel'),
('barndaghem','1|daghem'),
('barndom','1|barn'),
('barndomsforskning','1|forskning'),
('barndomshem','1|hem'),
('barndomskompis','1|kompis'),
('barndomsminne','1|minne'),
('barndomsparadis','1|paradis'),
('barndomsstad','1|stad'),
('barndomstillstånd','1|barndom'),
('barndomsupplevelse','1|upplevelse'),
('barndomsvän','1|vän'),
('barndop','1|dop'),
('barndos','1|dos'),
('barnfamilj','1|familj'),
('barnfattigdom','1|fattigdom'),
('barnfetma','1|fetma'),
('barnflicka','1|sköta'),
('barnfotomodell','1|fotomodell'),
('barnfödd','1|född'),
('barnförbjuden','1|film'),
('barnförbjudenhet','1|barnförbjuden'),
('barnförlamning','1|polio'),
('barngrupp','1|barn'),
('barnhem','1|vårda'),
('barnhemsbarn','1|barn'),
('barnhemsplacering','1|placering'),
('barnhus','1|barnhem'),
('barnhusbarn','1|barnhemsbarn'),
('barnhuvud','1|huvud'),
('barnjungfru','1|barnpassning'),
('barnkalas','1|kalas'),
('barnkammare','1|rum'),
('barnkammarfönster','1|fönster'),
('barnkammarsaga','1|saga'),
('barnklinik','1|klinik'),
('barnkläder','1|kläder'),
('barnknullare','1|pedofil'),
('barnkoloni','1|sommarvistelse'),
('barnkonvention','1|konvention'),
('barnkorståg','1|korståg'),
('barnkropp','1|kropp'),
('barnkär','1|älska'),
('barnkör','1|kör'),
('barnledig','1|tjänstledig'),
('barnledighet','1|barnledig'),
('barnlek','1|lek'),
('barnlek','2|uppgift'),
('barnläkare','1|läkare'),
('barnläkarskrå','1|skrå'),
('barnlös','1|barn'),
('barnlöshet','1|barnlös'),
('barnmat','1|mat'),
('barnmedicin','1|medicin'),
('barnmedicin','2|medicin'),
('barnmedicinsk','1|barnmedicin'),
('barnmisshandel','1|misshandel'),
('barnmorska','1|sjuksköterska'),
('barnneurolog','1|neurolog'),
('barnomsorg','1|omsorg'),
('barnomsorgsavgift','1|avgift'),
('barnomsorgskostnad','1|kostnad'),
('barnparkering','1|barnpassning'),
('barnpassning','1|vakta'),
('barnpiga','1|barnpassning'),
('barnplågeri','1|plåga'),
('barnpornografi','1|pedofili'),
('barnpornografisk','1|barnpornografi'),
('barnporr','1|barnpornografi'),
('barnporranklagad','1|anklaga'),
('barnporrhärva','1|härva'),
('barnporrmål','1|mål'),
('barnprogram','1|program'),
('barnpsykiatri','1|psykiatri'),
('barnpsykiatrisk','1|barnpsykiatri'),
('barnrik','1|barn'),
('barnrättskämpe','1|kämpa'),
('barnröst','1|röst'),
('barnsaga','1|saga'),
('barnsak','1|barnlek'),
('barnsbörd','1|förlossning'),
('barnsjukdom','1|infektionssjukdom'),
('barnsjukdom','2|initialsvårighet'),
('barnsjukhus','1|sjukhus'),
('barnsko','1|sko'),
('barnskottkärra','1|skottkärra'),
('barnskratt','1|skratt'),
('barnskrik','1|skrik'),
('barnskötare','1|skötare'),
('barnskötarlinje','1|utbildningslinje'),
('barnsköterska','1|sköterska'),
('barnslig','1|barn'),
('barnslighet','1|barnslig'),
('barnsmugglare','1|barnsmuggling'),
('barnsmugglarliga','1|liga'),
('barnsmuggling','1|smuggling'),
('barnsnor','1|snor'),
('barnsnöd','1|nöd'),
('barnsoldat','1|soldat'),
('barnspråk','1|språk'),
('barnstuga','1|daghem'),
('barnsäker','1|säker'),
('barnsäkerhet','1|barnsäker'),
('barnsäng','1|förlossning'),
('barnsängsfeber','1|febersjukdom'),
('barnsängskvinna','1|gravid'),
('barnteckning','1|teckning'),
('barntillsyn','1|barnomsorg'),
('barntillåten','1|tillåta'),
('barntillåtenhet','1|barntillåten'),
('barntoalett','1|toalett'),
('barnunge','1|barn'),
('barnuppfostran','1|uppfostran'),
('barnvagn','1|vagn'),
('barnvakt','1|barnpassning'),
('barnvattenkanna','1|vattenkanna'),
('barnvisa','1|visa'),
('barnvälgörenhetsorganisation','1|välgörenhetsorganisation'),
('barnvänlig','1|passa'),
('barock','1|stil'),
('barock','2|orimlig'),
('barockkonst','1|konst'),
('barocklyrik','1|lyrik'),
('barockmusik','1|musik'),
('barockmålare','1|målare'),
('barockmässig','1|barock'),
('barockpalats','1|palats'),
('barockpärla','1|pärla'),
('barockstil','1|barock'),
('barograf','1|barometer'),
('barogram','1|diagram'),
('barometer','1|mäta'),
('barometerfall','1|minska'),
('barometerstånd','1|lufttryck'),
('barometrisk','1|lufttryck'),
('baron','1|adelsman'),
('baronessa','1|baron'),
('barospirator','1|respirator'),
('barr','1|träd'),
('barr','2|gymnastikredskap'),
('barr','3|tacka'),
('barr','4|hår'),
('barra','1|barr'),
('barrande','1|barra'),
('barrdoft','1|doft'),
('barre','1|lägenhet'),
('barrig','1|barr'),
('barrikad','1|hinder'),
('barrikadera','1|barrikad'),
('barrikaderande','1|barrikadera'),
('barrikaderbar','1|barrikadera'),
('barrikaderbarhet','1|barrikaderbar'),
('barrikadering','1|barrikadera'),
('barrikadkämpe','1|kämpe'),
('barrikadstrid','1|strid'),
('barriär','1|hinder'),
('barriärrev','1|korallrev'),
('barrskog','1|skog'),
('barrskogsgräns','1|gräns'),
('barrskogsnunna','1|nunna'),
('barrskogsregion','1|region'),
('barrskogstäckt','1|täcka'),
('barrträd','1|träd'),
('barrträdskotte','1|kotte'),
('barrträdsplanta','1|planta'),
('barrträdssort','1|sort'),
('barrved','1|ved'),
('Barsebäck','1|kärnkraftverk'),
('barservering','1|bar'),
('barsk','1|sträng'),
('barskhet','1|barsk'),
('barskrapad','1|fattig'),
('barskåp','1|skåp'),
('barstol','1|stol'),
('bartender','1|bar'),
('barvinter','1|snö'),
('barysfär','1|jorden'),
('baryt','1|tungspat'),
('baryton','1|röst'),
('baryton','1|röst'),
('bas','1|grund'),
('bas','2|chef'),
('bas','3|utgå'),
('bas','4|röst'),
('bas','5|basisk'),
('bas','6|stryk'),
('bas','7|instrument'),
('bas','8|ton'),
('basa','1|bas'),
('basal','1|bas'),
('basalt','1|bergart'),
('basande','1|basa'),
('basar','1|handel'),
('basbelopp','1|belopp'),
('baseboll','1|bollspel'),
('baseboll','1|bollspel'),
('baseboll','2|boll'),
('basebollträ','1|bollträ'),
('basebollträ','1|bollträ'),
('basebollträ','1|bollträ'),
('basebollträ','1|bollträ'),
('basedow','1|Basedows_sjukdom'),
('Basel','1|stad'),
('basenhet','1|enhet'),
('basera','1|bas'),
('baserande','1|basera'),
('baserbar','1|basera'),
('baserbarhet','1|baserbar'),
('basering','1|basera'),
('basfiol','1|stråkinstrument'),
('basfiolsfodral','1|fodral'),
('basfiolsfodralsmakare','1|tillverka'),
('basfiolsfodralsmakaregesäll','1|gesäll'),
('basfärdighet','1|färdighet'),
('basföda','1|föda'),
('basgitarr','1|gitarr'),
('basilika','1|kyrka'),
('basilika','2|krydda'),
('basilisk','1|fabeldjur'),
('basis','1|bas'),
('basisk','1|sur'),
('basist','1|basfiol'),
('bask','1|Baskien'),
('basker','1|mössa'),
('basket','1|basketboll'),
('basketboll','1|bollspel'),
('basketboll','2|boll'),
('basketproffs','1|proffs'),
('Baskien','1|provins'),
('baskisk','1|Baskien'),
('baskiska','1|språk'),
('baskiska','2|bask'),
('basklarinett','1|klarinett'),
('basklav','1|klav'),
('baslinje','1|linje'),
('basläger','1|läger'),
('basning','1|uppmjuka'),
('basnot','1|not'),
('basorganisation','1|organisation'),
('baspar','1|gen'),
('basparti','1|parti'),
('basplatta','1|platta'),
('basrelief','1|lågrelief'),
('basrelieftavla','1|tavla'),
('basröst','1|bas'),
('basse','1|värnpliktig'),
('basset','1|hundras'),
('bassetthorn','1|blåsinstrument'),
('bassning','1|tillrättavisa'),
('basstation','1|radiosändare'),
('bassträcka','1|baslinje'),
('bassträng','1|sträng'),
('basstämma','1|bas'),
('bassångare','1|bas'),
('bassäng','1|förvara'),
('bassäng','2|bäcken'),
('bast','1|växtfiber'),
('bast','2|år'),
('basta','1|bastu'),
('bastande','1|basta'),
('bastant','1|kraftig'),
('bastant','2|stor'),
('bastanthet','1|bastant'),
('bastanthet','2|bastant'),
('bastard','1|korsning'),
('bastardform','1|bastard'),
('bastardnäktergal','1|sångarfågel'),
('bastcell','1|cell'),
('bastfiber','1|bast'),
('Bastiljen','1|fästning'),
('bastingering','1|förvaringsutrymme'),
('bastion','1|fästning'),
('bastkjol','1|kjol'),
('bastmatta','1|matta'),
('baston','1|ton'),
('bastonad','1|stryk'),
('bastrep','1|rep'),
('bastrumma','1|trumma'),
('bastu','1|bad'),
('bastuaggregat','1|bastu'),
('bastuba','1|blåsinstrument'),
('bastubad','1|bastu'),
('bastuförening','1|förening'),
('bastuklubb','1|tillfälligt_sex'),
('bastuklubb','2|bastuförening'),
('bastuklubb','3|beslutsfattande'),
('bastuugn','1|bastuaggregat'),
('bastuvärme','1|värme'),
('basun','1|trumpet'),
('basunblåsande','1|blåsa'),
('basunist','1|basun'),
('basunklang','1|klang'),
('basunregister','1|register'),
('basunstöt','1|stöt'),
('basvara','1|vara'),
('basvinkel','1|vinkel'),
('basväg','1|väg'),
('basyta','1|yta'),
('basår','1|år'),
('batalj','1|slag'),
('bataljmålare','1|bataljmålning'),
('bataljmålning','1|målning'),
('bataljon','1|förband'),
('bataljonsadjutant','1|adjutant'),
('bataljonschef','1|chef'),
('bataljonsvis','1|bataljon'),
('batat','1|sötpotatis'),
('batik','1|tygtryck'),
('batist','1|tyg'),
('batong','1|käpp'),
('batongslag','1|slag'),
('batongstånd','1|stånd'),
('batongsvingande','1|svinga'),
('batongsvingande','2|svinga'),
('battens','1|plank'),
('batteri','1|elektricitet'),
('batteri','2|förband'),
('batteridrift','1|batteridriven'),
('batteridriven','1|driva'),
('batterield','1|artillerield'),
('batteriklämma','1|klämma'),
('batteriladdare','1|ladda'),
('batteriladdning','1|laddning'),
('batteriprovare','1|prova'),
('batteriradio','1|radio'),
('batterisekatör','1|sekatör'),
('batterist','1|jazzorkester'),
('batteritändning','1|motor'),
('batterivatten','1|vatten'),
('batting','1|pojke'),
('batysfär','1|farkost'),
('baud','1|mått'),
('bautasten','1|gravsten'),
('bauxit','1|bergart'),
('baxa','1|förflytta'),
('baxande','1|baxa'),
('baxna','1|häpna'),
('baxnande','1|baxna'),
('Bayern','1|Tyskland'),
('bayersk','1|Bayern'),
('Bayeuxtapeten','1|tapet'),
('Bayreuth','1|ort'),
('bazooka','1|raketgevär'),
('BBC','1|radio'),
('BDSM','1|sexuell'),
('be','1|vilja'),
('be','2|be'),
('bea','1|bearnaisesås'),
('beagle','1|drevhund'),
('beakta','1|märka'),
('beaktande','1|beakta'),
('beaktansvärd','1|beakta'),
('bearbeta','1|behandla'),
('bearbetande','1|bearbeta'),
('bearbetare','1|bearbeta'),
('bearbetning','1|bearbeta'),
('bearnaise','1|bearnaisesås'),
('bearnaise','1|bearnaisesås'),
('bearnaise','1|bearnaisesås'),
('bearnaise','1|bearnaisesås'),
('bearnaise','1|bearnaisesås'),
('bearnaisesås','1|sås'),
('bearnaisesås','1|sås'),
('bearnaisesås','1|sås'),
('bearnaisesås','1|sås'),
('bearnaisesås','1|sås'),
('beatifiera','1|saligförklara'),
('beatifierande','1|beatifiera'),
('beatifierbar','1|beatifiera'),
('beatifierbarhet','1|beatifierbar'),
('beatifiering','1|beatifiera'),
('Beatles','1|popgrupp'),
('beatnik','1|rörelse'),
('Beatrice','1|Divina_Commedia'),
('beblandande','1|beblanda_sig'),
('beblandelse','1|beblanda_sig'),
('bebo','1|bo'),
('bebodd','1|bebo'),
('beboelig','1|bebo'),
('beboelig','1|bebo'),
('beboelighet','1|beboelig'),
('beboelighet','1|beboelig'),
('beboende','1|bebo'),
('bebop','1|jazz'),
('bebygga','1|bebyggelse'),
('bebyggande','1|bebygga'),
('bebyggare','1|bebygga'),
('bebyggelse','1|byggnad'),
('bebyggelsenamn','1|namn'),
('bebåda','1|förebåda'),
('bebådande','1|bebåda'),
('bebådelse','1|bebåda'),
('bebådelsedag','1|dag'),
('bebådning','1|bebåda'),
('becherovka','1|likör'),
('Bechuanaland','1|Botswana'),
('beck','1|tjära'),
('becka','1|beck'),
('beckande','1|becka'),
('beckasin','1|fågel'),
('beckig','1|beck'),
('beckighet','1|beckig'),
('beckmörk','1|mörk'),
('beckmörker','1|mörker'),
('beckpärla','1|pärla'),
('becksvart','1|svart'),
('becquerel','1|mått'),
('becquerel','1|mått'),
('Beda','1|munk'),
('bedagad','1|gammal'),
('bedarra','1|minska'),
('bedarrande','1|bedarra'),
('bedarrning','1|bedarra'),
('bedjande','1|be'),
('bedjande','1|be'),
('bedjande','2|be'),
('bedjande','2|be'),
('bedjande','3|be'),
('bedjande','3|be'),
('bedra','1|falsk'),
('bedragande','1|bedra'),
('bedragare','1|bedra'),
('bedragerska','1|bedragare'),
('bedrift','1|gärning'),
('bedriva','1|handla'),
('bedrivande','1|bedriva'),
('bedrägeri','1|bedra'),
('bedrägeribrott','1|brott'),
('bedrägerirotel','1|rotel'),
('bedräglig','1|bedra'),
('bedräglighet','1|bedräglig'),
('bedröva','1|ledsen'),
('bedrövad','1|ledsen'),
('bedrövande','1|bedröva'),
('bedrövelse','1|bedrövad'),
('bedrövlig','1|sorglig'),
('bedrövlighet','1|bedrövlig'),
('beduin','1|arab'),
('bedyra','1|försäkra'),
('bedyrande','1|bedyra'),
('bedåra','1|hänföra'),
('bedårande','1|bedåra'),
('bedårande','2|bedåra'),
('bedöma','1|värdera'),
('bedömande','1|bedöma'),
('bedömare','1|bedöma'),
('bedömning','1|bedöma'),
('bedöva','1|känsel'),
('bedövande','1|bedöva'),
('bedövning','1|bedöva'),
('bedövningsmedel','1|bedövning'),
('beediga','1|ed'),
('beedigande','1|beediga'),
('Beethovensonat','1|sonat'),
('befalla','1|tvinga'),
('befallande','1|befalla'),
('befallande','2|befalla'),
('befallning','1|befalla'),
('befallningshavande','1|myndighet'),
('befallningsman','1|fogde'),
('befara','1|rädd'),
('befara','2|resa'),
('befarande','1|befara'),
('befarande','2|befara'),
('befaren','1|berest'),
('befattning','1|tjänst'),
('befattningshavare','1|befattning'),
('befattningsmässig','1|befattning'),
('befinna','1|finna'),
('befinnande','1|välbefinnande'),
('befinnas','1|visa_sig'),
('befintlig','1|finnas'),
('befintlighet','1|befinna_sig'),
('befjädrad','1|fjäderklädd'),
('befjädring','1|fjäderdräkt'),
('befläcka','1|vanära'),
('befläckande','1|befläcka'),
('befläckelse','1|befläcka'),
('befogad','1|skäl'),
('befogenhet','1|makt'),
('befogenhetsförskjutning','1|förskjutning'),
('befolka','1|folk'),
('befolkande','1|befolka'),
('befolkning','1|folk'),
('befolkning','2|befolka'),
('befolkning','3|befolkning'),
('befolkningsexplosion','1|befolkningsökning'),
('befolkningsgrupp','1|grupp'),
('befolkningsmässig','1|befolkning'),
('befolkningspolitik','1|politik'),
('befolkningspolitisk','1|befolkningspolitik'),
('befolkningspyramid','1|diagram'),
('befolkningsstatistik','1|statistik'),
('befolkningstillväxt','1|tillväxt'),
('befolkningsundersökning','1|undersökning'),
('befolkningsökning','1|ökning'),
('befordra','1|upphöja'),
('befordra','2|transport'),
('befordran','1|befordra'),
('befordran','2|befordra'),
('befordrande','1|befordra'),
('befordrande','2|befordra'),
('befordrare','1|befordra'),
('befordrare','2|befordra'),
('befordring','1|befordran'),
('befordring','2|befordran'),
('befordringsgrund','1|orsak'),
('befordringsgång','1|ordning'),
('befrakta','1|frakta'),
('befraktande','1|befrakta'),
('befraktare','1|befrakta'),
('befraktning','1|befrakta'),
('befransad','1|fransförsedd'),
('befria','1|fri'),
('befriande','1|befria'),
('befriande','2|befria'),
('befriare','1|befria'),
('befrielse','1|befria'),
('befrielseakt','1|akt'),
('befrielsearmé','1|armé'),
('befrielsefront','1|front'),
('befrielsekamp','1|kamp'),
('befrielsekrig','1|krig'),
('befrielserörelse','1|rörelse'),
('befrukta','1|fortplanta_sig'),
('befrukta','2|stimulera'),
('befruktande','1|befrukta'),
('befruktande','2|befrukta'),
('befruktning','1|befrukta'),
('befruktning','2|befrukta'),
('befruktningsorgan','1|organ'),
('befruktningsögonblick','1|ögonblick'),
('befrynda','1|befryndad'),
('befryndad','1|besläktad'),
('befryndande','1|befrynda'),
('befrämja','1|hjälpa'),
('befrämjande','1|befrämja'),
('befrämjare','1|befrämja'),
('befullmäktiga','1|fullmakt'),
('befullmäktigande','1|befullmäktiga'),
('befäl','1|ledare'),
('befäl','2|befalla'),
('befälhavande','1|befäl'),
('befälhavare','1|chef'),
('befälselev','1|elev'),
('befälsföring','1|befäl'),
('befälsgrad','1|rang'),
('befälsordning','1|befäl'),
('befälsperson','1|befäl'),
('befälsställning','1|befäl'),
('befälstalang','1|talang'),
('befälstalang','2|talang'),
('befälstecken','1|örlogsflagga'),
('befälsuppdrag','1|uppdrag'),
('befängd','1|tokig'),
('befängdhet','1|befängd'),
('befästa','1|fast'),
('befästande','1|befästa'),
('befästning','1|försvar'),
('befästningsgrav','1|befästningsskydd'),
('befästningskonst','1|konst'),
('befästningslinje','1|linje'),
('befästningsskydd','1|skydd'),
('befästningsverk','1|befästning'),
('begabba','1|håna'),
('begabbande','1|begabba'),
('begabbare','1|begabba'),
('begabberi','1|begabba'),
('begagna','1|använda'),
('begagnad','1|begagna'),
('begagnande','1|begagna'),
('begagnatköp','1|köp'),
('begapa','1|stirra'),
('begapande','1|begapa'),
('begapning','1|begapa'),
('begeistrad','1|ivrig'),
('begeistring','1|begeistrad'),
('beginerå','1|rå'),
('begivande','1|medgivande'),
('begiven','1|lysten'),
('begivenhet','1|händelse'),
('begivenhet','2|begiven'),
('begjuta','1|hälla'),
('begjutande','1|begjuta'),
('begjutning','1|begjuta'),
('beglänsa','1|glans'),
('beglänsande','1|beglänsa'),
('beglänsning','1|beglänsa'),
('begonia','1|krukväxt'),
('begrava','1|grav'),
('begravande','1|begrava'),
('begravning','1|begrava'),
('begravningsakt','1|akt'),
('begravningsbok','1|register'),
('begravningsbyrå','1|byrå'),
('begravningsceremoni','1|ceremoni'),
('begravningsdag','1|dag'),
('begravningsentreprenör','1|begravningsbyrå'),
('begravningsgäst','1|deltagare'),
('begravningshjälp','1|bidrag'),
('begravningshögtidlighet','1|högtidlighet'),
('begravningskalas','1|kalas'),
('begravningskassa','1|begravningshjälp'),
('begravningskostnader','1|kostnad'),
('begravningskrans','1|krans'),
('begravningsmarsch','1|marsch'),
('begravningsmin','1|min'),
('begravningsplats','1|plats'),
('begravningspoesi','1|poesi'),
('begravningsprocession','1|procession'),
('begravningspsalm','1|psalm'),
('begravningsringning','1|klockringning'),
('begravningsspel','1|spel'),
('begravningståg','1|tåg'),
('begrepp','1|tanke'),
('begreppsanalys','1|analys'),
('begreppsanalytisk','1|begreppsanalys'),
('begreppsapparat','1|uppsättning'),
('begreppsbestämning','1|definition'),
('begreppsbildning','1|begrepp'),
('begreppsexercis','1|exercis'),
('begreppsförvirring','1|förvirring'),
('begreppsindelning','1|begrepp'),
('begreppsinnehåll','1|innehåll'),
('begreppslig','1|begrepp'),
('begreppslighet','1|begreppslig'),
('begreppsmässig','1|begrepp'),
('begreppsmässighet','1|begreppsmässig'),
('begreppsnivå','1|nivå'),
('begreppssystem','1|begrepp'),
('begripa','1|förstå'),
('begripande','1|begripa'),
('begriplig','1|begripa'),
('begriplighet','1|begriplig'),
('begrunda','1|fundera'),
('begrundan','1|begrunda'),
('begrundande','1|begrunda'),
('begrundansvärd','1|begrunda'),
('begråta','1|gråta'),
('begråtande','1|begråta'),
('begränsa','1|minska'),
('begränsad','1|begränsa'),
('begränsande','1|begränsa'),
('begränsning','1|begränsa'),
('begränsningslinje','1|gräns'),
('begränsningsyta','1|yta'),
('begynna','1|börja'),
('begynnande','1|begynna'),
('begynnelse','1|begynna'),
('begynnelsebokstav','1|bokstav'),
('begynnelsehastighet','1|hastighet'),
('begynnelselön','1|lön'),
('begynnelserim','1|rim'),
('begynnelseskede','1|skede'),
('begynnelsespråk','1|språk'),
('begynnelsestadium','1|stadium'),
('begynnelsevärde','1|värde'),
('begå','1|göra'),
('begående','1|begå'),
('begåva','1|ge'),
('begåvad','1|begåvning'),
('begåvande','1|begåva'),
('begåvning','1|förmåga'),
('begåvning','2|begåvad'),
('begåvningsmässig','1|begåvning'),
('begåvningsreserv','1|reserv'),
('begär','1|lust'),
('begära','1|be'),
('begäran','1|begära'),
('begärande','1|begära'),
('begärelse','1|åtrå'),
('begärlig','1|efterfrågad'),
('begärlighet','1|begärlig'),
('begärsliv','1|liv'),
('behag','1|behaga'),
('behag','2|behaga'),
('behag','3|skönhet'),
('behag','4|kvinnobröst'),
('behaga','1|tycka_om'),
('behaga','2|vilja'),
('behagande','1|behaga'),
('behagande','2|behaga'),
('behagfull','1|behaglig'),
('behagfullhet','1|behagfull'),
('behaglig','1|angenäm'),
('behaglighet','1|behaglig'),
('behagsjuk','1|kokett'),
('behagsjuka','1|behagsjuk'),
('behagsjukhet','1|behagsjuk'),
('behandla','1|göra'),
('behandla','2|bota'),
('behandla','3|diskutera'),
('behandlande','1|behandla'),
('behandlande','2|behandla'),
('behandlande','3|behandla'),
('behandling','1|behandla'),
('behandling','2|behandla'),
('behandling','3|behandla'),
('behandlingsalternativ','1|alternativ'),
('behandlingsbar','1|bota'),
('behandlingsbarhet','1|behandlingsbar'),
('behandlingsenhet','1|sjukhus'),
('behandlingshem','1|hem'),
('behandlingsmetod','1|metod'),
('behandlingsmässig','1|behandling'),
('behandlingsprogram','1|program'),
('behandlingsrum','1|sjukhus'),
('behandlingssätt','1|sätt'),
('behandskad','1|handske'),
('behaviorism','1|beteende'),
('behaviorist','1|behaviorism'),
('behavioristisk','1|behaviorism'),
('behjälplig','1|hjälpa'),
('behjälplighet','1|behjälplig'),
('behjärtad','1|modig'),
('behjärtansvärd','1|värd'),
('behjärtenhet','1|behjärtad'),
('behornad','1|horn'),
('behov','1|behöva'),
('behovlös','1|behov'),
('behovlöshet','1|behovlös'),
('behovsprincip','1|ersättning'),
('behovsprövad','1|behovsprövning'),
('behovsprövning','1|prövning'),
('behovstillfredsställelse','1|tillfredsställelse'),
('behovstryck','1|publicera'),
('behå','1|bröst'),
('behå','1|bröst'),
('behålla','1|hålla'),
('behållande','1|behålla'),
('behållare','1|förvara'),
('behållen','1|behålla'),
('behållning','1|vinst'),
('behårad','1|hårbevuxen'),
('behåring','1|hår'),
('behäftad','1|fel'),
('behändig','1|praktisk'),
('behändighet','1|behändig'),
('behänga','1|hänga'),
('behängande','1|behänga'),
('behängning','1|behänga'),
('behärska','1|kunna'),
('behärskad','1|behärska_sig'),
('behärskande','1|behärska'),
('behärskning','1|behärska_sig'),
('behörig','1|kompetent'),
('behörigen','1|vederbörligen'),
('behörighet','1|behörig'),
('behörighetsbevis','1|bevis'),
('behöva','1|nödvändig'),
('behövande','1|behöva'),
('behövande','2|behöva'),
('behövas','1|nödvändig'),
('behövlig','1|behöva'),
('behövlighet','1|behövlig'),
('beige','1|färg'),
('beige','2|beige'),
('beige','3|intetsägande'),
('Beira','1|stad'),
('Beirut','1|huvudstad'),
('beivra','1|straffa'),
('beivran','1|beivra'),
('beivrande','1|beivra'),
('beivrare','1|beivra'),
('bej','1|hövding'),
('bejaka','1|ja'),
('bejakande','1|bejaka'),
('bejakning','1|bejaka'),
('bejubla','1|jubla'),
('bejublande','1|bejubla'),
('bekaja','1|belasta'),
('bekajande','1|bekaja'),
('bekant','1|känna'),
('bekant','2|bekant'),
('bekanta','1|bekant'),
('bekantande','1|bekanta'),
('bekantgöra','1|bekant'),
('bekantgörande','1|bekantgöra'),
('bekanting','1|bekant'),
('bekantskap','1|bekant'),
('bekantskapskrets','1|krets'),
('bekika','1|stirra'),
('bekikande','1|bekika'),
('beklaga','1|klaga'),
('beklagande','1|beklaga'),
('beklagansvärd','1|värd'),
('beklaglig','1|beklaga'),
('beklagligen','1|beklaga'),
('beklaglighet','1|beklaglig'),
('beklagligtvis','1|beklaga'),
('beklä','1|klä'),
('beklädande','1|beklä'),
('beklädnad','1|kläder'),
('beklädning','1|beklä'),
('beklämd','1|ledsen'),
('beklämdhet','1|beklämd'),
('beklämmande','1|sorglig'),
('beklämning','1|beklämd'),
('beknip','1|rep'),
('beknipa','1|beknip'),
('beknipande','1|beknipa'),
('bekomma','1|inverka'),
('bekommande','1|bekomma'),
('bekosta','1|betala'),
('bekostande','1|bekosta'),
('bekostnad','1|bekosta'),
('bekransa','1|krans'),
('bekransande','1|bekransa'),
('bekransning','1|bekransa'),
('bekriga','1|kriga'),
('bekrigande','1|bekriga'),
('bekräfta','1|ja'),
('bekräfta','2|giltig'),
('bekräftande','1|bekräfta'),
('bekräftande','2|bekräfta'),
('bekräftelse','1|bekräfta'),
('bekräftelse','2|bekräfta'),
('bekräftelsebehov','1|behov'),
('bekräftelsesökande','1|söka'),
('bekröna','1|pryda'),
('bekrönande','1|bekröna'),
('bekröning','1|bekröna'),
('bekväm','1|bra'),
('bekväm','2|obesvärad'),
('bekvämhet','1|bekväm'),
('bekvämlighet','1|bekväm'),
('bekvämlighetsflagg','1|flaggning'),
('bekvämlighetshänsyn','1|hänsyn'),
('bekvämlighetsinrättning','1|toalett'),
('bekymmer','1|oro'),
('bekymmer','2|orosmoment'),
('bekymmersam','1|bekymmer'),
('bekymmersamhet','1|bekymmersam'),
('bekymmersfri','1|bekymmer'),
('bekymmersfri','1|bekymmer'),
('bekymmersfull','1|bekymmer'),
('bekymmerslös','1|bekymmer'),
('bekymmerslöshet','1|bekymmerslös'),
('bekymmersrynka','1|rynka'),
('bekymra','1|bekymmer'),
('bekymrad','1|bekymra_sig'),
('bekymrad','2|bekymra'),
('bekymrande','1|bekymra'),
('bekyttad','1|ängslig'),
('bekämpa','1|kämpa'),
('bekämpande','1|bekämpa'),
('bekämpare','1|bekämpa'),
('bekämpning','1|bekämpa'),
('bekämpningsmedel','1|medel'),
('bekänna','1|erkänna'),
('bekännande','1|bekänna'),
('bekännare','1|bekänna_sig'),
('bekännelse','1|bekänna'),
('bekännelsefrihet','1|trosfrihet'),
('Bekännelser','1|Augustinus'),
('bekännelseroman','1|självbiografi'),
('bekännelseskrift','1|skrift'),
('belacka','1|förtala'),
('belackande','1|belacka'),
('belackare','1|belacka'),
('belag','1|glid'),
('belamra','1|fylla'),
('belamrande','1|belamra'),
('belanga','1|anbelanga'),
('belangande','1|belanga'),
('belasta','1|last'),
('belasta','2|påfrestning'),
('belasta','3|omständighet'),
('belastande','1|belasta'),
('belastande','2|belasta'),
('belastande','3|belasta'),
('belastning','1|belasta'),
('belastning','2|belasta'),
('belastning','3|belasta'),
('belastningsregister','1|brottsregister'),
('belastningsskada','1|skada'),
('belastningsuppgift','1|uppgift'),
('bele','1|le'),
('beledsaga','1|följa'),
('beledsagande','1|beledsaga'),
('beledsagare','1|beledsaga'),
('beledsagning','1|beledsaga'),
('beleende','1|bele'),
('belemnit','1|fossil'),
('belevad','1|bildad'),
('belevenhet','1|belevad'),
('Belfast','1|huvudstad'),
('belgare','1|Belgien'),
('Belgien','1|land'),
('belgier','1|belgare'),
('belgisk','1|Belgien'),
('belgiska','1|belgier'),
('Belgrad','1|huvudstad'),
('Belize','1|land'),
('belizier','1|Belize'),
('belizisk','1|Belize'),
('beliziska','1|belizier'),
('beljuga','1|ljuga'),
('beljugande','1|beljuga'),
('belladonna','1|drog'),
('belletrist','1|författare'),
('belletristik','1|skönlitteratur'),
('belletristisk','1|belletristik'),
('bellis','1|tusensköna'),
('bellit','1|sprängämne'),
('belopp','1|tal'),
('belysa','1|lysa'),
('belysande','1|klargöra'),
('belysande','2|belysa'),
('belysning','1|belysa'),
('belysningsarmatur','1|armatur'),
('belysningsmässa','1|mässa'),
('belysningsström','1|ström'),
('belysningsstyrka','1|styrka'),
('belåna','1|låna'),
('belånande','1|belåna'),
('belåning','1|belåna'),
('belåningsgrad','1|grad'),
('belåten','1|nöjd'),
('belåtenhet','1|belåten'),
('belägen','1|läge'),
('belägenhet','1|situation'),
('belägg','1|förekomst'),
('belägga','1|beläggning'),
('belägga','2|påföljd'),
('belägga','3|förtöja'),
('belägga','4|plats'),
('belägga','5|påvisa'),
('beläggande','1|belägga'),
('beläggande','2|belägga'),
('beläggande','3|belägga'),
('beläggande','4|belägga'),
('beläggande','5|belägga'),
('beläggning','1|skikt'),
('beläggning','2|belägga'),
('beläggning','3|belägga'),
('beläggningsgrad','1|grad'),
('beläggningsring','1|förtöjningsring'),
('beläggningssnöre','1|prydnadssnöre'),
('beläggningsstämpel','1|kontrollmärke'),
('beläggställe','1|belägg'),
('belägra','1|inta'),
('belägrande','1|belägra'),
('belägring','1|belägra'),
('belägringsartilleri','1|artilleri'),
('belägringskonst','1|konst'),
('belägringstillstånd','1|undantagstillstånd'),
('belägringstorn','1|torn'),
('beläsenhet','1|beläst'),
('beläst','1|bildning'),
('belästhet','1|beläst'),
('beläte','1|avbild'),
('belöna','1|ge'),
('belönande','1|belöna'),
('belöning','1|belöna'),
('belöningsmedalj','1|medalj'),
('belöningssystem','1|system'),
('bemanna','1|manskap'),
('bemannad','1|bemanna'),
('bemannande','1|bemanna'),
('bemanning','1|bemanna'),
('bemanningsföretag','1|uthyrning'),
('bemanningsverksamhet','1|verksamhet'),
('bemantla','1|förse'),
('bemantlande','1|bemantla'),
('bemedla','1|medla'),
('bemedlad','1|välbärgad'),
('bemedlande','1|bemedla'),
('bemedling','1|bemedla'),
('bemyndiga','1|befogenhet'),
('bemyndigande','1|bemyndiga'),
('bemåla','1|måla'),
('bemålande','1|bemåla'),
('bemålning','1|bemåla'),
('bemälde','1|omnämna'),
('bemänga','1|blanda'),
('bemängande','1|bemänga'),
('bemärka','1|märka'),
('bemärkande','1|bemärka'),
('bemärkelse','1|avseende'),
('bemärkelsedag','1|dag'),
('bemärkt','1|känd'),
('bemärkthet','1|bemärkt'),
('bemästra','1|klara'),
('bemästrande','1|bemästra'),
('bemödande','1|bemöda_sig'),
('bemöta','1|svara'),
('bemöta','2|ta_emot'),
('bemötande','1|bemöta'),
('bemötande','2|bemöta'),
('ben','1|kropp'),
('ben','2|kropp'),
('ben','3|bära'),
('bena','1|hår'),
('bena','2|bena'),
('bena','3|avlägsna'),
('benande','1|bena'),
('benande','2|bena'),
('benaska','1|aska'),
('benbildning','1|bildning'),
('benbrosk','1|brosk'),
('benbrott','1|brott'),
('Bender','1|kalabalik'),
('benediktin','1|munk'),
('benediktinerkloster','1|kloster'),
('benediktinerkloster','1|kloster'),
('benediktinermunk','1|munk'),
('benediktinerorden','1|klosterorden'),
('benediktinerorden','1|klosterorden'),
('beneficium','1|förmån'),
('benefik','1|beneficium'),
('benfisk','1|fisk'),
('benfragment','1|fragment'),
('benfri','1|ben'),
('benfärgad','1|benvit'),
('Bengalen','1|provins'),
('bengalisk','1|Bengalen'),
('benget','1|mager'),
('bengädda','1|gädda'),
('benhinna','1|hinna'),
('benhinneinflammation','1|inflammation'),
('benhus','1|förvara'),
('benhård','1|orubblig'),
('benhårdhet','1|benhård'),
('Benidorm','1|badort'),
('benig','1|knepig'),
('benig','2|ben'),
('benign','1|godartad'),
('Benin','1|land'),
('beninier','1|Benin'),
('beninsk','1|Benin'),
('beninska','1|beninier'),
('benjamin','1|ung'),
('benjaminfikus','1|fikus'),
('benkirurg','1|kirurg'),
('benkläder','1|underbyxor'),
('benknota','1|ben'),
('benknäckare','1|knäcka'),
('benling','1|skinn'),
('benlås','1|brottningsgrepp'),
('benmjöl','1|gödselmedel'),
('benmuskel','1|muskel'),
('benmärg','1|märg'),
('benmärgscancer','1|cancer'),
('Benny','1|Goodman'),
('benpipa','1|pipa'),
('benpipa','2|pipa'),
('benporslin','1|porslin'),
('benprotes','1|ben'),
('benrangel','1|skelett'),
('benrangelsman','1|död'),
('benrest','1|rest'),
('benröta','1|inflammation'),
('bensen','1|kolväte'),
('bensin','1|bränsle'),
('bensinautomat','1|automat'),
('bensinbolag','1|bolag'),
('bensinbomb','1|brandbomb'),
('bensinbrist','1|brist'),
('bensindriven','1|driva'),
('bensindunk','1|dunk'),
('bensinförbrukning','1|förbrukning'),
('bensinförsäljning','1|försäljning'),
('bensinmack','1|bensinstation'),
('bensinmotor','1|motor'),
('bensinpris','1|pris'),
('bensinpump','1|pump'),
('bensinskatt','1|skatt'),
('bensinskattehöjning','1|höjning'),
('bensinslukande','1|bensinförbrukning'),
('bensinsnål','1|bensinförbrukning'),
('bensinsnålhet','1|bensinsnål'),
('bensinstation','1|tanka'),
('bensinstopp','1|motorstopp'),
('bensintank','1|tank'),
('bensintillsats','1|tillsats'),
('benskada','1|skada'),
('benskena','1|benskydd'),
('benskydd','1|skydd'),
('benskör','1|benskörhet'),
('benskörhet','1|skörhet'),
('bensoe','1|harts'),
('bensoesyra','1|konserveringsmedel'),
('bensol','1|bensen'),
('benspets','1|pilspets'),
('benstamp','1|kvarn'),
('benstomme','1|skelett'),
('benstråle','1|ben'),
('bensträckare','1|paus'),
('bensubstans','1|benvävnad'),
('bensvulst','1|svulst'),
('bensår','1|sjukdom'),
('Bentley','1|bilmärke'),
('bentonit','1|lera'),
('bentonitlager','1|lager'),
('bentrakt','1|ben'),
('bentry','1|buske'),
('bentuberkulos','1|tuberkulos'),
('bentyl','1|bränsle'),
('benutskott','1|utskott'),
('benved','1|buske'),
('benvit','1|vit'),
('benvärmare','1|kläder'),
('benvävnad','1|vävnad'),
('benåda','1|upphäva'),
('benådande','1|benåda'),
('benådning','1|benåda'),
('benägen','1|vilja'),
('benägenhet','1|benägen'),
('benämna','1|kalla'),
('benämnande','1|benämna'),
('benämning','1|namn'),
('beordra','1|befalla'),
('beordrande','1|beordra'),
('beostare','1|fågel'),
('Beowulf','1|hjältedikt'),
('bepansra','1|förse'),
('bepansrande','1|bepansra'),
('bepansring','1|bepansra'),
('beprisa','1|lovprisa'),
('beprisande','1|beprisa'),
('beprisning','1|beprisa'),
('bepryda','1|pryda'),
('beprydande','1|bepryda'),
('beprövad','1|pröva'),
('bepudra','1|pudra'),
('bepudrande','1|bepudra'),
('beramad','1|tillkännage'),
('beramad','2|beryktad'),
('berber','1|folk'),
('berberis','1|buske'),
('berceuse','1|vaggvisa'),
('bereda','1|bearbeta'),
('bereda','2|förbereda'),
('bereda','3|utjämna'),
('beredande','1|bereda'),
('beredande','2|bereda'),
('beredande','3|bereda'),
('beredare','1|bereda'),
('beredd','1|färdig'),
('beredelse','1|förberedelse'),
('beredning','1|bereda'),
('beredning','2|kommitté'),
('beredning','3|bereda'),
('beredningsnämnd','1|beskattningsnämnd'),
('beredningssätt','1|bereda'),
('beredningsutskott','1|beredning'),
('beredskap','1|beredd'),
('beredskapsarbete','1|arbetslös'),
('beredskapskommissarie','1|kommissarie'),
('beredskapslager','1|reservlager'),
('beredskapslagring','1|beredskapslager'),
('beredskapsmässig','1|beredskap'),
('beredskapsplan','1|plan'),
('beredskapsstat','1|krismedel'),
('beredskapstid','1|beredskap'),
('beredskapstjänst','1|försvarsberedskap'),
('beredvillig','1|hjälpsam'),
('beredvillighet','1|beredvillig'),
('berest','1|resa'),
('beresthet','1|berest'),
('berg','1|hög'),
('berg','2|sten'),
('bergakung','1|bergtroll'),
('bergamott','1|citrusfrukt'),
('bergamott','2|päron'),
('bergand','1|and'),
('bergart','1|berg'),
('bergartslager','1|lager'),
('bergbana','1|järnväg'),
('bergborr','1|borr'),
('bergborrning','1|borrning'),
('bergbäck','1|bäck'),
('Bergen','1|stad'),
('bergfast','1|övertygad'),
('bergfin','1|ädelmetall'),
('bergfink','1|fink'),
('berggrund','1|grund'),
('berggylta','1|fisk'),
('berghäll','1|klippa'),
('bergig','1|berg'),
('bergighet','1|bergig'),
('bergis','1|bröd'),
('bergis','1|bröd'),
('bergis','1|bröd'),
('bergis','2|bergsäker'),
('bergklack','1|berg'),
('bergknalle','1|berg'),
('bergkristall','1|ädelsten'),
('bergkulle','1|kulle'),
('bergland','1|land'),
('berglandskap','1|landskap'),
('bergnymf','1|nymf'),
('berg-och-dalbana','1|åkattraktion'),
('bergolja','1|råolja'),
('bergpass','1|pass'),
('bergras','1|ras'),
('bergrum','1|skyddsrum'),
('bergsartilleri','1|artilleri'),
('bergsbestigare','1|bergsklättrare'),
('bergsbestigare','1|bergsklättrare'),
('bergsbestigning','1|bergsbestigare'),
('bergsbestigning','1|bergsbestigare'),
('bergsbestigningsexpedition','1|expedition'),
('bergsbestigningsolycka','1|olycka'),
('bergsbrant','1|brant'),
('bergsbruk','1|bergshantering'),
('bergsbygd','1|bygd'),
('bergsdrift','1|bergsbruk'),
('bergsformation','1|formation'),
('bergsget','1|get'),
('bergsglaciär','1|glaciär'),
('bergsgorilla','1|gorilla'),
('bergshantering','1|gruvdrift'),
('bergsingenjör','1|ingenjör'),
('bergsjägare','1|fältjägare'),
('bergskam','1|bergsrygg'),
('bergskam','1|bergsrygg'),
('bergskedja','1|berg'),
('bergskedjebildning','1|bildning'),
('bergsklack','1|klippa'),
('bergsklimat','1|klimat'),
('bergsklyfta','1|klyfta'),
('bergsklättrare','1|bergsklättring'),
('bergsklättring','1|klättring'),
('bergskred','1|skred'),
('bergskreva','1|skreva'),
('bergskrön','1|krön'),
('bergskrön','1|krön'),
('bergslag','1|område'),
('bergslager','1|lager'),
('bergslandskap','1|landskap'),
('bergsluft','1|luft'),
('bergsman','1|bergshantering'),
('bergsmassiv','1|berg'),
('bergsområde','1|område'),
('bergspets','1|bergstopp'),
('bergsplatå','1|platå'),
('Bergspredikan','1|predikan'),
('bergsrygg','1|bergskrön'),
('bergsrygg','1|bergskrön'),
('bergssida','1|sida'),
('bergsskola','1|skola'),
('bergssluttning','1|sluttning'),
('bergsstam','1|stam'),
('bergstopp','1|topp'),
('bergstopp','1|topp'),
('bergstrakt','1|trakt'),
('bergstup','1|stup'),
('bergstup','1|stup'),
('bergsyra','1|kråksyra'),
('bergszebra','1|zebra'),
('bergsäker','1|säker'),
('bergsäkerhet','1|bergsäker'),
('bergtagen','1|förtrolla'),
('bergtall','1|tall'),
('bergtroll','1|troll'),
('berguv','1|uggla'),
('bergvandrare','1|vandrare'),
('bergvandring','1|vandring'),
('bergvind','1|vind'),
('bergvägg','1|bergstup'),
('bergvärme','1|värme'),
('bergås','1|ås'),
('beriberi','1|sjukdom'),
('beridare','1|hästdressyr'),
('beriden','1|rida'),
('berika','1|rik'),
('berikande','1|berika'),
('beriktiga','1|korrigera'),
('beriktigande','1|beriktiga'),
('Berkeley','1|universitet'),
('berkelium','1|grundämne'),
('berkelium','1|grundämne'),
('Berlin','1|stad'),
('berlinerblå','1|berlinerblått'),
('berlinerblått','1|färgämne'),
('Berlinmuren','1|mur'),
('berlock','1|smycke'),
('bermudarigg','1|rigg'),
('bermudashorts','1|shorts'),
('Bern','1|stad'),
('bero','1|om'),
('bero','2|avvakta'),
('beroende','1|bero'),
('beroende','2|behöva'),
('beroende','3|bero'),
('beroendeframkallande','1|framkalla'),
('beroendeförhållande','1|förhållande'),
('beroendeproblem','1|problem'),
('beroendeställning','1|ställning'),
('berså','1|uterum'),
('berusa','1|yr'),
('berusad','1|berusa'),
('berusande','1|berusa'),
('berusande','2|berusa'),
('berusning','1|berusa'),
('berusningsgrad','1|grad'),
('beryktad','1|rykte'),
('beryll','1|ädelsten'),
('beryllgrön','1|grön'),
('beryllium','1|metall'),
('beryllium','2|grundämne'),
('beryllium','2|grundämne'),
('beräkna','1|räkna'),
('beräkna','2|förutse'),
('beräknad','1|beräkna'),
('beräknad','2|beräkna'),
('beräknande','1|fördel'),
('beräknande','2|beräkna'),
('beräknande','3|beräkna'),
('beräknelig','1|beräkna'),
('beräknelighet','1|beräknelig'),
('beräkning','1|beräkna'),
('beräkning','2|beräkna'),
('beräkningsgrund','1|grund'),
('beräkningsmetod','1|metod'),
('beräkningsmässig','1|beräkning'),
('beräkningssätt','1|sätt'),
('berätta','1|säga'),
('berättande','1|berätta'),
('berättande','2|berätta'),
('berättarbegåvning','1|begåvning'),
('berättare','1|berätta'),
('berättarförmåga','1|förmåga'),
('berättarglädje','1|glädje'),
('berättarjag','1|författarjag'),
('berättarkonst','1|epik'),
('berättarmässig','1|berättare'),
('berättarperspektiv','1|perspektiv'),
('berättarröst','1|röst'),
('berättarstil','1|stil'),
('berättartalang','1|talang'),
('berättartalang','2|talang'),
('berättarteknik','1|teknik'),
('berättarteknisk','1|berättarteknik'),
('berättelse','1|berätta'),
('berättiga','1|rätt'),
('berättigad','1|berättiga'),
('berättigande','1|berättiga'),
('beröm','1|berömma'),
('berömd','1|känd'),
('berömdhet','1|berömd'),
('berömlig','1|beröm'),
('berömlighet','1|berömlig'),
('berömma','1|bra'),
('berömmande','1|berömma'),
('berömmelse','1|rykte'),
('berömvärd','1|beröm'),
('berömvärdhet','1|berömvärd'),
('beröra','1|röra'),
('beröra','2|angå'),
('berörande','1|beröra'),
('berörande','2|beröra'),
('berörd','1|beröra'),
('beröring','1|kontakt'),
('beröringsassociation','1|association'),
('beröringselektricitet','1|elektricitet'),
('beröringsfri','1|röra'),
('beröringspunkt','1|punkt'),
('beröringsskräck','1|skräck'),
('beröringsångest','1|ångest'),
('beröva','1|frånta'),
('berövande','1|beröva'),
('besanna','1|sann'),
('besannande','1|besanna'),
('besatt','1|galen'),
('besatthet','1|besatt'),
('bese','1|titta'),
('beseende','1|bese'),
('besegla','1|avgöra'),
('beseglande','1|besegla'),
('besegling','1|besegla'),
('besegra','1|segra'),
('besegrande','1|besegra'),
('besegrare','1|besegra'),
('besick','1|kortspel'),
('besick','1|kortspel'),
('besick','1|kortspel'),
('besiffrad','1|ackord'),
('besiffring','1|besiffrad'),
('besiktiga','1|granska'),
('besiktigande','1|besiktiga'),
('besiktning','1|besiktiga'),
('besiktningsinstrument','1|dokument'),
('besiktningsman','1|besiktiga'),
('besiktningsprotokoll','1|protokoll'),
('besinna','1|tänka'),
('besinnad','1|genomtänkt'),
('besinnande','1|besinna'),
('besinning','1|besinna_sig'),
('besinningsfull','1|besinning'),
('besinningsfullhet','1|besinningsfull'),
('besinningslös','1|besinning'),
('besinningslöshet','1|besinningslös'),
('besitta','1|äga'),
('besittande','1|besitta'),
('besittning','1|besitta'),
('besittningshavare','1|besittning'),
('besittningsrätt','1|rätt'),
('besittningsskydd','1|skydd'),
('besittningstagande','1|ta_i_besittning'),
('besittningstid','1|tid'),
('besjunga','1|lovprisa'),
('besjungande','1|besjunga'),
('besjungen','1|besjunga'),
('besjäla','1|själ'),
('besjälad','1|besjäla'),
('besjälande','1|besjäla'),
('besk','1|smak'),
('besk','2|brännvin'),
('beska','1|besk'),
('beskaffad','1|egenskap'),
('beskaffenhet','1|beskaffad'),
('beskatta','1|skatt'),
('beskattande','1|beskatta'),
('beskattning','1|beskatta'),
('beskattningsbar','1|beskattning'),
('beskattningsbarhet','1|beskattningsbar'),
('beskattningsgrund','1|skatteprincip'),
('beskattningsgrundande','1|grunda'),
('beskattningsmakt','1|makt'),
('beskattningsnämnd','1|nämnd'),
('beskattningsprincip','1|princip'),
('beskattningsrätt','1|beskattningsmakt'),
('beskattningssätt','1|beskatta'),
('beskattningsår','1|år'),
('besked','1|veta'),
('beskedlig','1|snäll'),
('beskedlighet','1|beskedlig'),
('beskhet','1|besk'),
('beskicka','1|bergshantering'),
('beskickande','1|beskicka'),
('beskickning','1|ambassad'),
('beskickningschef','1|chef'),
('beskjuta','1|skjuta'),
('beskjutande','1|beskjuta'),
('beskjutning','1|beskjuta'),
('beskriva','1|visa'),
('beskrivande','1|beskriva'),
('beskrivande','2|beskriva'),
('beskrivbar','1|beskriva'),
('beskrivbarhet','1|beskrivbar'),
('beskrivning','1|beskriva'),
('besksöta','1|buske'),
('beskugga','1|skugga'),
('beskuggande','1|beskugga'),
('beskuggning','1|beskugga'),
('beskydd','1|beskydda'),
('beskydda','1|skydda'),
('beskyddande','1|beskydda'),
('beskyddare','1|beskydda'),
('beskyddarverksamhet','1|beskydda'),
('beskylla','1|anklaga'),
('beskyllande','1|beskylla'),
('beskyllning','1|beskylla'),
('beskåda','1|titta'),
('beskådan','1|beskådande'),
('beskådande','1|beskåda'),
('beskådning','1|beskåda'),
('beskäftig','1|ivrig'),
('beskäftighet','1|beskäftig'),
('beskällare','1|avelshingst'),
('beskällarsjuka','1|könssjukdom'),
('beskällarsjuka','1|könssjukdom'),
('beskänkt','1|berusad'),
('beskära','1|minska'),
('beskära','2|skära'),
('beskära','3|unna'),
('beskärande','1|beskära'),
('beskärande','2|beskära'),
('beskärande','3|beskära'),
('beskärd','1|förutbestämma'),
('beskärm','1|skydd'),
('beskärma','1|beskärm'),
('beskärmande','1|beskärma'),
('beskärmare','1|beskärma'),
('beskärmelse','1|beskärma_sig'),
('beskärning','1|beskära'),
('beslag','1|förstärkning'),
('beslag','2|beslagta'),
('beslagare','1|beslagta'),
('beslaglägga','1|beslagta'),
('beslagläggande','1|beslaglägga'),
('beslagsband','1|beslå'),
('beslagsrätt','1|rätt'),
('beslagssmed','1|beslagssmide'),
('beslagssmide','1|smide'),
('beslagta','1|frånta'),
('beslagta','1|frånta'),
('beslagtagande','1|beslagta'),
('Beslan','1|skolmassaker'),
('beslut','1|besluta'),
('besluta','1|avgöra'),
('beslutande','1|besluta'),
('beslutanderätt','1|rätt'),
('besluten','1|besluta'),
('beslutenhet','1|besluten'),
('beslutenlig','1|enligt'),
('beslutenlig','1|enligt'),
('beslutenlighet','1|beslutenlig'),
('beslutenlighet','1|beslutenlig'),
('beslutsam','1|besluta'),
('beslutsamhet','1|beslutsam'),
('beslutsfattande','1|fatta_beslut'),
('beslutsfattande','1|fatta_beslut'),
('beslutsfattande','2|fatta_beslut'),
('beslutsfattande','2|fatta_beslut'),
('beslutsfattare','1|fatta_beslut'),
('beslutsfattare','1|fatta_beslut'),
('beslutsför','1|berättigad'),
('beslutsför','1|berättigad'),
('beslutsförhet','1|beslutsför'),
('beslutsförhet','1|beslutsför'),
('beslutsförmåga','1|förmåga'),
('beslutshierarki','1|hierarki'),
('beslutskaos','1|kaos'),
('beslutskapabel','1|kapabel'),
('beslutskorridor','1|korridor'),
('beslutsmässig','1|berättigad'),
('beslutsmässig','1|berättigad'),
('beslutsmässighet','1|beslutsmässig'),
('beslutsmässighet','1|beslutsmässig'),
('beslutsnivå','1|nivå'),
('beslutsnivå','1|nivå'),
('beslutsprocess','1|process'),
('beslutsrum','1|rum'),
('beslutsrum','2|besluta'),
('beslutsrymd','1|beslutsrum'),
('beslutsrätt','1|beslutanderätt'),
('beslutsunderlag','1|underlag'),
('beslutsångest','1|ångest'),
('beslå','1|beslag'),
('beslå','2|binda'),
('beslå','3|avslöja'),
('beslå','4|beläggning'),
('beslående','1|beslå'),
('beslående','2|beslå'),
('beslående','3|beslå'),
('beslående','4|beslå'),
('besläktad','1|släkt'),
('beslöja','1|beslöjad'),
('beslöjad','1|slöja'),
('beslöjande','1|beslöja'),
('beslöjning','1|beslöja'),
('besman','1|våg'),
('besmanskrok','1|besman'),
('besmitta','1|smitta'),
('besmittande','1|besmitta'),
('besmittelse','1|besmitta'),
('besmörja','1|smörja'),
('besmörjande','1|besmörja'),
('besockra','1|sockra'),
('besockrande','1|besockra'),
('besolda','1|sold'),
('besoldande','1|besolda'),
('besoldning','1|besolda'),
('bespara','1|slippa'),
('besparande','1|bespara'),
('besparing','1|spara'),
('besparingskrav','1|krav'),
('besparingsskog','1|skog'),
('besparingstorped','1|genomdriva'),
('bespeja','1|speja'),
('bespejande','1|bespeja'),
('bespejning','1|bespeja'),
('bespisa','1|bjuda'),
('bespisande','1|bespisa'),
('bespisning','1|bespisa'),
('bespola','1|spola'),
('bespolande','1|bespola'),
('bespotta','1|håna'),
('bespottande','1|bespotta'),
('bespottare','1|bespotta'),
('bespottelse','1|bespotta'),
('bespruta','1|växt'),
('besprutande','1|bespruta'),
('besprutning','1|bespruta'),
('besprutningsmedel','1|bekämpningsmedel'),
('besprutningsvätska','1|besprutningsmedel'),
('bessemerblåsning','1|bessemerprocessen'),
('bessemermetoden','1|bessemerprocessen'),
('bessemerprocessen','1|järnframställning'),
('bessemerstål','1|stål'),
('bessemerugn','1|bessemerprocessen'),
('besserwisser','1|veta'),
('besserwisser','1|veta'),
('besserwisserattityd','1|attityd'),
('besserwissra','1|besserwisser'),
('besserwissrande','1|besserwissra'),
('best','1|djur'),
('bestialisk','1|grym'),
('bestialitet','1|bestialisk'),
('bestick','1|redskap'),
('bestick','2|kurs'),
('besticka','1|muta'),
('bestickande','1|förledande'),
('bestickande','2|besticka'),
('bestickföring','1|bestick'),
('besticklig','1|besticka'),
('besticklighet','1|besticklig'),
('bestickning','1|besticka'),
('bestiga','1|klättra'),
('bestiga','2|betäcka'),
('bestigande','1|bestiga'),
('bestigande','2|bestiga'),
('bestigning','1|bestiga'),
('bestigning','2|bestiga'),
('bestjäla','1|stjäla'),
('bestjälande','1|bestjäla'),
('bestorma','1|ansätta'),
('bestormande','1|bestorma'),
('bestormning','1|bestorma'),
('bestraffa','1|straffa'),
('bestraffande','1|bestraffa'),
('bestraffning','1|bestraffa'),
('bestraffningskrig','1|krig'),
('bestraffningsmedel','1|medel'),
('bestraffningssätt','1|bestraffa'),
('bestrida','1|förneka'),
('bestrida','2|betala'),
('bestridande','1|bestrida'),
('bestridande','2|bestrida'),
('bestryka','1|pensel'),
('bestryka','2|svepa'),
('bestrykande','1|bestryka'),
('bestrykande','2|bestryka'),
('bestrykning','1|bestryka'),
('bestråla','1|strålning'),
('bestrålande','1|bestråla'),
('bestrålning','1|bestråla'),
('beströ','1|strö'),
('beströende','1|beströ'),
('bestseller','1|bok'),
('bestsellerförfattare','1|författare'),
('bestycka','1|utrusta'),
('bestyckande','1|bestycka'),
('bestyckning','1|bestycka'),
('bestyr','1|göromål'),
('bestyra','1|bestyr'),
('bestyrande','1|bestyra'),
('bestyrka','1|intyga'),
('bestyrkande','1|bestyrka'),
('bestå','1|förekomst'),
('bestå','2|existera'),
('bestå','3|tillhandahålla'),
('bestå','4|utgöra'),
('bestående','1|bestå'),
('bestående','2|bestå'),
('bestående','3|bestå'),
('bestående','4|bestå'),
('bestående','5|bestå'),
('bestånd','1|bestå'),
('beståndande','1|fortbestånd'),
('beståndsbildande','1|bestånd'),
('beståndsdel','1|bestå'),
('beståndsmässig','1|bestånd'),
('beställa','1|begära'),
('beställa','2|arbeta'),
('beställande','1|beställa'),
('beställande','2|beställa'),
('beställare','1|beställa'),
('beställning','1|beställa'),
('beställningsarbete','1|arbete'),
('beställningsavgift','1|avgift'),
('beställningsmord','1|mord'),
('beställningsverk','1|beställningsarbete'),
('beställsam','1|beställa'),
('beställsamhet','1|beställsam'),
('beställt','1|tillstånd'),
('bestämbar','1|bestämma'),
('bestämbarhet','1|bestämbar'),
('bestämd','1|bestämma'),
('bestämd','2|beslutsam'),
('bestämdhet','1|bestämd'),
('bestämma','1|avgöra'),
('bestämma','2|bestämma_sig'),
('bestämmande','1|bestämma'),
('bestämmande','2|bestämma'),
('bestämmanderätt','1|rätt'),
('bestämmelse','1|regel'),
('bestämmelseort','1|mål'),
('bestämning','1|bestämma'),
('bestämning','2|egenskap'),
('bestämningsord','1|bestämning'),
('beständig','1|ständig'),
('beständig','2|förändra'),
('beständighet','1|beständig'),
('bestänka','1|stänka'),
('bestänkande','1|bestänka'),
('bestänkning','1|bestänka'),
('bestört','1|häpen'),
('bestörthet','1|bestört'),
('bestörtning','1|bestört'),
('besudla','1|befläcka'),
('besudlande','1|besudla'),
('besudling','1|besudla'),
('besutten','1|rik'),
('besuttenhet','1|besutten'),
('besvara','1|svara'),
('besvarande','1|besvara'),
('besvikelse','1|besviken'),
('besviken','1|nöjd'),
('besvikenhet','1|besviken'),
('besvågrad','1|släkt'),
('besvär','1|besvärlig'),
('besvär','2|klagomål'),
('besvär','3|sjukdom'),
('besvära','1|besvärlig'),
('besvärad','1|besvära'),
('besvärande','1|besvär'),
('besvärande','2|besvära'),
('besvärja','1|besvärjelse'),
('besvärjande','1|besvärja'),
('besvärjare','1|besvärja'),
('besvärjelse','1|trollformel'),
('besvärjelseformel','1|besvärjelse'),
('besvärjning','1|besvärja'),
('besvärlig','1|svår'),
('besvärlighet','1|besvärlig'),
('besvärsfri','1|besvär'),
('besvärsgrund','1|besvär'),
('besvärshandling','1|handling'),
('besvärshänvisning','1|hänvisning'),
('besvärsinlaga','1|inlaga'),
('besvärsinstans','1|instans'),
('besvärsmyndighet','1|myndighet'),
('besvärsmål','1|mål'),
('besvärsrätt','1|rätt'),
('besvärsskrift','1|skrift'),
('besvärssubjekt','1|besvär'),
('besvärstid','1|tid'),
('besvärsväg','1|besvär'),
('besynnerlig','1|underlig'),
('besynnerlighet','1|besynnerlig'),
('beså','1|så'),
('besående','1|beså'),
('besätta','1|inta'),
('besätta','2|anställa'),
('besätta','3|upptagen'),
('besätta','4|pryda'),
('besättande','1|besätta'),
('besättande','2|besätta'),
('besättande','3|besätta'),
('besättande','4|besätta'),
('besättning','1|besätta'),
('besättning','2|kreatursbesättning'),
('besättning','3|uppsättning'),
('besättningsband','1|band'),
('besättningsman','1|besättning'),
('besättningsmedlem','1|besättningsman'),
('besök','1|besöka'),
('besöka','1|komma'),
('besökande','1|besökare'),
('besökande','2|besöka'),
('besökare','1|besöka'),
('besöksadress','1|adress'),
('besöksbok','1|bok'),
('besöksdag','1|dag'),
('besöksfåtölj','1|fåtölj'),
('besöksförbud','1|förbud'),
('besöksnäring','1|näring'),
('besöksrekord','1|rekord'),
('besöksrestriktion','1|restriktion'),
('besöksrum','1|rum'),
('besöksstol','1|stol'),
('besökstid','1|tid'),
('besökstopp','1|kulmen'),
('besörja','1|ombesörja'),
('besörjande','1|besörja'),
('bet','1|straff'),
('beta','1|äta'),
('beta','2|tillsätta'),
('beta','3|rotfrukt'),
('beta','4|bokstav'),
('beta','5|frånta'),
('beta','6|betagen'),
('beta','7|grundbehandla'),
('beta','8|bete'),
('betablockerare','1|medicin'),
('betagande','1|beta'),
('betagande','2|beta'),
('betagande','3|beta'),
('betagen','1|fängsla'),
('betagenhet','1|betagen'),
('betala','1|pengar'),
('betalande','1|betala'),
('betalare','1|betala'),
('betalartikel','1|internetartikel'),
('betalbar','1|betala'),
('betalbarhet','1|betalbar'),
('betalkort','1|kreditkort'),
('betalkurs','1|kurs'),
('betalning','1|betala'),
('betalningsanmärkning','1|anmärkning'),
('betalningsanstånd','1|anstånd'),
('betalningsavtal','1|avtal'),
('betalningsbalans','1|balans'),
('betalningsbevis','1|bevis'),
('betalningsdag','1|dag'),
('betalningsfri','1|betalning'),
('betalningsfrist','1|betalningsanstånd'),
('betalningsföreläggande','1|förelägga'),
('betalningsförmåga','1|förmåga'),
('betalningsgill','1|rätt'),
('betalningsinställelse','1|konkurs'),
('betalningsmedel','1|medel'),
('betalningsskyldig','1|skyldig'),
('betalningsskyldighet','1|betalningsskyldig'),
('betalningssäkra','1|säkra'),
('betalningstermin','1|period'),
('betalningstid','1|betalningstermin'),
('betalningsvilja','1|vilja'),
('betalningsvillkor','1|villkor'),
('betalsex','1|sex'),
('betaltjänst','1|betala'),
('betande','1|beta'),
('betande','2|beta'),
('betande','3|beta'),
('betande','4|beta'),
('betapartikel','1|partikel'),
('betastrålande','1|betastrålning'),
('betastrålning','1|strålning'),
('betasönderfall','1|sönderfall'),
('betatron','1|accelerator'),
('bete','1|fånga'),
('bete','2|beta'),
('bete','3|tand'),
('beteckna','1|tecken'),
('betecknande','1|typisk'),
('betecknande','2|beteckna'),
('beteckning','1|tecken'),
('beteckningssätt','1|beteckna'),
('beteende','1|bete_sig'),
('beteendebehandling','1|beteendeterapi'),
('beteendeforskning','1|forskning'),
('beteendemässig','1|beteende'),
('beteendemönster','1|mönster'),
('beteendepsykologi','1|psykologi'),
('beteenderubbning','1|rubbning'),
('beteendeterapeut','1|beteendeterapi'),
('beteendeterapi','1|terapi'),
('beteendevetare','1|beteendevetenskap'),
('beteendevetenskap','1|vetenskap'),
('beteendevetenskaplig','1|beteendevetenskap'),
('betel','1|njutningsmedel'),
('betelblad','1|blad'),
('Betelguese','1|röd_jätte'),
('betelnöt','1|nöt'),
('betelpalm','1|palm'),
('betelpeppar','1|peppar'),
('beteltuggare','1|beteltuggning'),
('beteltuggning','1|tugga'),
('betesgång','1|bete'),
('beteshage','1|hage'),
('betesland','1|betesmark'),
('betesmark','1|mark'),
('betesområde','1|område'),
('betesplats','1|plats'),
('betessläpp','1|släppa_ut'),
('betesutsläpp','1|betessläpp'),
('beting','1|arbete'),
('beting','2|förtöja'),
('betinga','1|villkor'),
('betinga','2|kosta'),
('betingad','1|betinga'),
('betingad','2|betingning'),
('betingande','1|betinga'),
('betingande','2|betinga'),
('betingelse','1|villkor'),
('betingning','1|lära'),
('betingsarbete','1|beting'),
('betingsläsning','1|läxa'),
('betitla','1|benämna'),
('betitlande','1|betitla'),
('betitta','1|stirra'),
('betittande','1|betitta'),
('betjäna','1|tjäna'),
('betjänande','1|betjäna'),
('betjäning','1|betjäna'),
('betjäningsavgift','1|dricks'),
('betjänt','1|betjäna'),
('betjänt','2|nytta'),
('betjänte','1|statstjänsteman'),
('betkampanj','1|skörd'),
('Betlehem','1|födelsestad'),
('betmedel','1|beta'),
('betning','1|beta'),
('betodling','1|odling'),
('betona','1|framhålla'),
('betonad','1|betona'),
('betonande','1|betona'),
('betong','1|byggnadsmaterial'),
('betongbjälklag','1|bjälklag'),
('betongblandare','1|betong'),
('betongblock','1|block'),
('betongbädd','1|underlag'),
('betongera','1|betong'),
('betongerande','1|betongera'),
('betongerbar','1|betongera'),
('betongerbarhet','1|betongerbar'),
('betongering','1|betongera'),
('betongfärg','1|färg'),
('betonggolv','1|golv'),
('betonghinder','1|hinder'),
('betonghäck','1|politiker'),
('betongmaskin','1|betongblandare'),
('betongparti','1|parti'),
('betongpåle','1|påle'),
('betongsugga','1|betonghinder'),
('betongvalv','1|valv'),
('betongvibrator','1|vibrator'),
('betoning','1|betona'),
('betrakta','1|se'),
('betraktande','1|betrakta'),
('betraktare','1|betrakta'),
('betraktelse','1|bedömning'),
('betraktelsesätt','1|sätt'),
('betro','1|anförtro'),
('betrodd','1|betro'),
('betroddhet','1|betrodd'),
('betroende','1|betro'),
('betryck','1|tillstånd'),
('betrycka','1|betryckt'),
('betryckande','1|betrycka'),
('betryckt','1|ledsen'),
('betryckthet','1|betryckt'),
('betrygga','1|trygg'),
('betryggande','1|trygg'),
('betryggande','2|betrygga'),
('beträda','1|gå'),
('beträdande','1|beträda'),
('beträffa','1|angå'),
('beträffande','1|beträffa'),
('beträffande','2|beträffa'),
('beträngd','1|trångmål'),
('beträngdhet','1|beträngd'),
('bets','1|färgämne'),
('betsa','1|bets'),
('betsande','1|betsa'),
('betsel','1|styra'),
('betsla','1|betsel'),
('betslande','1|betsla'),
('betsling','1|betsla'),
('betsmedel','1|bets'),
('betsning','1|betsa'),
('betsocker','1|socker'),
('betsockerindustri','1|industri'),
('bett','1|bita'),
('bett','2|tand'),
('bett','3|betsel'),
('bettel','1|plåtkärl'),
('bettel','1|plåtkärl'),
('bettla','1|bettleri'),
('bettlande','1|bettla'),
('bettlare','1|bettleri'),
('bettleri','1|tigga'),
('bettskena','1|skydd'),
('Betty','1|Elisabet'),
('betunga','1|tung'),
('betungande','1|betunga'),
('betungande','2|betunga'),
('betuttad','1|förälskad'),
('betvinga','1|övervinna'),
('betvingande','1|hänföra'),
('betvingande','2|betvinga'),
('betvingare','1|betvinga'),
('betvivla','1|tvivla'),
('betvivlande','1|betvivla'),
('betyda','1|veta'),
('betydande','1|viktig'),
('betydande','2|betyda'),
('betydelse','1|betyda'),
('betydelse','2|viktig'),
('betydelsebärande','1|betydelse'),
('betydelsefattig','1|betydelse'),
('betydelsefull','1|viktig'),
('betydelsefullhet','1|betydelsefull'),
('betydelseförskjutning','1|betydelseförändring'),
('betydelseförändring','1|förändring'),
('betydelseglidning','1|betydelseförändring'),
('betydelselager','1|betydelseskikt'),
('betydelselära','1|semantik'),
('betydelselös','1|betydelse'),
('betydelselöshet','1|betydelselös'),
('betydelsemässig','1|betydelse'),
('betydelsemässig','2|betydelse'),
('betydelsenyans','1|nyans'),
('betydelseskikt','1|skikt'),
('betydelseutveckling','1|utveckling'),
('betydenhet','1|betydande'),
('betydlig','1|avsevärd'),
('betydlighet','1|betydlig'),
('betyg','1|bedöma'),
('betyga','1|försäkra'),
('betygande','1|betyga'),
('betygelse','1|betyga'),
('betyghöjning','1|höjning'),
('betyghöjning','1|höjning'),
('betygkramare','1|förespråkare'),
('betygsavskrift','1|avskrift'),
('betygsfri','1|betyg'),
('betygsgrad','1|betyg'),
('betygshets','1|hets'),
('betygsjäkt','1|betygshets'),
('betygskatalog','1|förteckning'),
('betygsnämnd','1|nämnd'),
('betygsskala','1|skala'),
('betygsstress','1|stress'),
('betygsänkning','1|sänkning'),
('betygsänkning','1|sänkning'),
('betygsätta','1|betyg'),
('betygsätta','1|betyg'),
('betygsättande','1|betygsätta'),
('betygsättande','1|betygsätta'),
('betygsättning','1|betygsätta'),
('betygsättning','1|betygsätta'),
('betäcka','1|täcka'),
('betäcka','2|parning'),
('betäckande','1|betäcka'),
('betäckande','2|betäcka'),
('betäckning','1|betäcka'),
('betäckning','2|betäcka'),
('betäckning','3|ta_betäckning'),
('betäckningsavgift','1|avgift'),
('betänka','1|tänka'),
('betänkande','1|betänka'),
('betänketid','1|tid'),
('betänklig','1|dålig'),
('betänklighet','1|betänksam'),
('betänksam','1|betänka'),
('betänksamhet','1|betänksam'),
('betänkt','1|avsikt'),
('beundra','1|imponera'),
('beundran','1|beundra'),
('beundrande','1|beundra'),
('beundransvärd','1|värd'),
('beundransvärdhet','1|beundransvärd'),
('beundrare','1|beundra'),
('beundrarinna','1|beundrare'),
('bevaka','1|kontrollera'),
('bevakande','1|bevaka'),
('bevakning','1|bevaka'),
('bevakningsinlaga','1|rätt'),
('bevakningsinsats','1|insats'),
('bevakningskedja','1|kedja'),
('bevakningsområde','1|område'),
('bevakningsuppdrag','1|uppdrag'),
('bevandrad','1|veta'),
('bevara','1|kvar'),
('bevara','1|kvar'),
('bevarande','1|bevara'),
('bevarandeomständighet','1|omständighet'),
('bevars','1|minsann'),
('bevattna','1|vattna'),
('bevattnande','1|bevattna'),
('bevattning','1|bevattna'),
('bevattningsanläggning','1|anläggning'),
('bevattningsförbud','1|förbud'),
('bevattningskanal','1|kanal'),
('bevattningsregel','1|regel'),
('bevattningssystem','1|system'),
('beveka','1|vädja'),
('bevekande','1|beveka'),
('bevekande','2|beveka'),
('bevekelse','1|beveka'),
('bevekelsegrund','1|motiv'),
('bevilja','1|tillåta'),
('beviljande','1|bevilja'),
('bevillning','1|skatt'),
('bevillningsavgift','1|bevillning'),
('bevillningsutskott','1|utskott'),
('bevingad','1|vinge'),
('bevis','1|bevisa'),
('bevis','2|intyg'),
('bevisa','1|visa'),
('bevisande','1|bevisa'),
('bevisbar','1|bevisa'),
('bevisbarhet','1|bevisbar'),
('bevisbörda','1|skyldighet'),
('bevisföring','1|bevisa'),
('bevisförvanskning','1|förvanskning'),
('beviskedja','1|kedja'),
('beviskraft','1|förmåga'),
('beviskraftig','1|beviskraft'),
('beviskraftighet','1|beviskraftig'),
('beviskrav','1|krav'),
('bevislig','1|bevisbar'),
('bevisligen','1|bevis'),
('bevislighet','1|bevislig'),
('bevismaterial','1|material'),
('bevismedel','1|medel'),
('bevismässig','1|bevis'),
('bevisning','1|bevisa'),
('bevisprövning','1|prövning'),
('bevisskyldig','1|bevisbörda'),
('bevisskyldighet','1|bevisskyldig'),
('bevissvårighet','1|svårighet'),
('bevissäkring','1|säkring'),
('bevista','1|närvaro'),
('bevistande','1|bevista'),
('bevisvärde','1|värde'),
('bevisvärdering','1|bevisvärde'),
('bevittna','1|se'),
('bevittna','2|intyga'),
('bevittnande','1|bevittna'),
('bevittnande','2|bevittna'),
('bevuxen','1|växa'),
('bevågen','1|välvillig'),
('bevågenhet','1|bevågen'),
('bevänt','1|duga'),
('beväpna','1|förse'),
('beväpnad','1|vapen'),
('beväpnande','1|beväpna'),
('beväpning','1|vapen'),
('bevära','1|örlogsfartyg'),
('bevärande','1|bevära'),
('bevärdiga','1|nedlåta_sig'),
('bevärdigande','1|bevärdiga'),
('beväring','1|värnpliktig'),
('beväxt','1|bevuxen'),
('Bhopal','1|gaskatastrof'),
('Bhutan','1|land'),
('bhutanes','1|Bhutan'),
('bhutanesisk','1|Bhutan'),
('bhutanesiska','1|bhutanes'),
('bi','1|insekt'),
('bi','2|bisexuell'),
('biaccent','1|bitryck'),
('bias','1|snedvridning'),
('biavel','1|avel'),
('biavsikt','1|baktanke'),
('bibana','1|sidobana'),
('bibehålla','1|behålla'),
('bibehållande','1|bibehålla'),
('bibehållen','1|bibehålla'),
('bibel','1|bok'),
('bibelcitat','1|citat'),
('bibelexeget','1|exeget'),
('bibelforskning','1|forskning'),
('bibelförklaring','1|förklaring'),
('bibelhandskrift','1|handskrift'),
('bibelkanon','1|kanon'),
('bibelkommission','1|kommission'),
('bibelkonkordans','1|konkordans'),
('bibelkristen','1|bibeltrogen'),
('bibelkristenhet','1|bibelkristen'),
('bibelkritik','1|kritik'),
('bibelkunnig','1|kunnig'),
('bibelkunnighet','1|bibelkunnig'),
('Bibeln','1|skrift'),
('bibelord','1|bibelcitat'),
('bibelsamtal','1|andakt'),
('bibelspråk','1|ordspråk'),
('bibelsprängd','1|bibelkunnig'),
('bibelsprängdhet','1|bibelsprängd'),
('bibelställe','1|textavsnitt'),
('bibelsällskap','1|mission'),
('bibeltext','1|Bibeln'),
('bibeltolkning','1|tolkning'),
('bibeltroende','1|tro'),
('bibeltrogen','1|överensstämma'),
('bibeltrogenhet','1|bibeltrogen'),
('bibelvers','1|kapitel'),
('bibelöversättning','1|översättning'),
('bibestämning','1|bestämning'),
('bibetydelse','1|betydelsenyans'),
('biblicism','1|sekt'),
('biblicistisk','1|biblicism'),
('bibliofil','1|samlare'),
('bibliofilupplaga','1|bok'),
('bibliograf','1|bibliografi'),
('bibliografi','1|litteraturförteckning'),
('bibliografisk','1|bibliografi'),
('biblioman','1|bibliomani'),
('bibliomani','1|bibliofil'),
('bibliometri','1|utvärdera'),
('bibliotek','1|bok'),
('bibliotekarie','1|bibliotek'),
('biblioteksavgift','1|avgift'),
('biblioteksband','1|band'),
('biblioteksbelysning','1|belysning'),
('biblioteksbord','1|bord'),
('biblioteksbrand','1|brand'),
('bibliotekshögskola','1|högskola'),
('bibliotekskatalog','1|katalog'),
('bibliotekslån','1|boklån'),
('bibliotekslån','1|boklån'),
('biblisk','1|Bibeln'),
('biblomma','1|befruktning'),
('bibringa','1|ge'),
('bibringande','1|bibringa'),
('bibröd','1|föda'),
('biceps','1|bicepsmuskel'),
('bicepsmuskel','1|muskel'),
('bicepssena','1|sena'),
('bida','1|vänta'),
('bidan','1|bida'),
('bidande','1|bida'),
('bidé','1|tvättställ'),
('bidevind','1|vind'),
('bidevindare','1|segelbåt'),
('bidevindsegel','1|segel'),
('bidevindseglare','1|fartyg'),
('bidevindseglare','2|manet'),
('bidra','1|ge'),
('bidrag','1|bidra'),
('bidrag','2|delta'),
('bidragande','1|bidra'),
('bidragande','2|bidra'),
('bidragsberoende','1|beroende'),
('bidragsdel','1|del'),
('bidragsfusk','1|fusk'),
('bidragsfuskare','1|fuska'),
('bidragsförskott','1|förskott'),
('bidragsgivare','1|givare'),
('bidragsgrundande','1|grunda'),
('bidragsmiljon','1|miljon'),
('bidragsskyldighet','1|skyldighet'),
('bidrottning','1|bi'),
('biedermeierstil','1|stil'),
('bieffekt','1|effekt'),
('bienn','1|tvåårig'),
('biennal','1|konstutställning'),
('bifall','1|bifalla'),
('bifalla','1|ja'),
('bifallande','1|bifalla'),
('bifallsnick','1|nick'),
('bifallsrop','1|rop'),
('bifallsstorm','1|bifallsrop'),
('bifallsyttring','1|bifall'),
('bifenyl','1|miljögift'),
('biff','1|kött'),
('biff','2|klar'),
('biffdjur','1|kött'),
('biffig','1|muskulös'),
('biffighet','1|biffig'),
('biffko','1|biffdjur'),
('biffrad','1|ryggparti'),
('biffstek','1|biff'),
('biffyxa','1|köttyxa'),
('bifigur','1|person'),
('bifilär','1|dubbeltrådig'),
('bifilär','1|dubbeltrådig'),
('biflod','1|flod'),
('biflöde','1|biflod'),
('bifoga','1|tillägga'),
('bifogande','1|bifoga'),
('bifokalglas','1|glasögon'),
('biform','1|variant'),
('bifurkation','1|flod'),
('biförtjänst','1|biinkomst'),
('bigami','1|tvegifte'),
('bigamist','1|bigami'),
('bigarrå','1|körsbär'),
('bigata','1|sidogata'),
('bigift','1|gift'),
('bigott','1|intolerant'),
('bigotteri','1|bigott'),
('bigram','1|symbolsekvens'),
('bigård','1|biodling'),
('bihandling','1|intrig'),
('bihang','1|del'),
('bihav','1|hav'),
('bihus','1|bikupa'),
('bihustru','1|hustru'),
('bihuva','1|huva'),
('bihåla','1|skalle'),
('bihåleinflammation','1|inflammation'),
('biinkomst','1|inkomst'),
('bijouterier','1|smycke'),
('bikarbonat','1|natriumbikarbonat'),
('bikini','1|baddräkt'),
('bikiniprydd','1|pryda'),
('biklöv','1|klöv'),
('bikonkav','1|konkav'),
('bikonvex','1|konvex'),
('bikrona','1|kronblad'),
('bikt','1|bikta'),
('bikta','1|erkänna'),
('biktande','1|bikta'),
('biktbarn','1|bikt'),
('biktfar','1|bikt'),
('biktstol','1|bikt'),
('bikupa','1|bi'),
('bikvadrat','1|dignitet'),
('bikvadratisk','1|fjärdegradsekvation'),
('bil','1|åka'),
('bila','1|yxa'),
('bila','2|bila'),
('bila','3|bil'),
('bila','4|bilmaskin'),
('bila','5|blad'),
('bilabial','1|labial'),
('bilaccis','1|skatt'),
('bilaffär','1|affär'),
('bilaffär','2|affär'),
('bilaga','1|bifoga'),
('bilagd','1|bilägga'),
('bilagd','2|bilägga'),
('biland','1|område'),
('bilande','1|bila'),
('bilande','2|bila'),
('bilande','3|bila'),
('bilantenn','1|antenn'),
('bilateral','1|ömsesidig'),
('bilbana','1|bana'),
('bilbatteri','1|batteri'),
('bilbesiktning','1|besiktning'),
('bilbingo','1|bingo'),
('bilboké','1|leksak'),
('bilbrand','1|brand'),
('bilbranschen','1|bransch'),
('bilbroms','1|broms'),
('bilburen','1|bil'),
('bilbyggeri','1|biltillverkning'),
('bilbälte','1|säkerhetsbälte'),
('bild','1|visa'),
('bilda','1|skapa'),
('bilda','2|lära'),
('bildad','1|veta'),
('bildammsugare','1|dammsugare'),
('bildande','1|bilda'),
('bildande','2|bilda'),
('bildande','3|bilda'),
('bildband','1|band'),
('bildbar','1|bilda'),
('bildbarhet','1|bildbar'),
('bildberättelse','1|berättelse'),
('bildbevis','1|bevis'),
('bilddyrkan','1|dyrka'),
('bilderbok','1|barnbok'),
('bildflöde','1|flöde'),
('bildgalleri','1|galleri'),
('bildgåta','1|rebus'),
('bildhuggare','1|skulptör'),
('bildhuggarkonst','1|konst'),
('bildhuggarmejsel','1|mejsel'),
('bildhuggeri','1|bildhuggare'),
('bildhållning','1|TV-bild'),
('bildinnehav','1|innehav'),
('bildkarta','1|karta'),
('bildkonst','1|konst'),
('bildkryss','1|korsord'),
('bildlig','1|överförd'),
('bildlighet','1|bildlig'),
('bildlik','1|lik'),
('bildlikhet','1|bildlik'),
('bildmanipulation','1|manipulation'),
('bildmaterial','1|bild'),
('bildminne','1|minne'),
('bildmonitor','1|video'),
('bildmässig','1|bild'),
('bildmässighet','1|bildmässig'),
('bildning','1|bildad'),
('bildning','2|bilda'),
('bildningsanstalt','1|skola'),
('bildningsaristokrat','1|bildningshögfärd'),
('bildningsfel','1|lyte'),
('bildningsföraktare','1|förakta'),
('bildningsförbund','1|studieförbund'),
('bildningsgrad','1|bildning'),
('bildningsgång','1|utbildning'),
('bildningshögfärd','1|högfärd'),
('bildningsmässig','1|bildning'),
('bildningsnivå','1|nivå'),
('bildningsorganisation','1|bildningsförbund'),
('bildningsroman','1|roman'),
('bildningstörst','1|längtan'),
('bildningsverksamhet','1|bildning'),
('bildningsvärme','1|värme'),
('bildprakt','1|prakt'),
('bildradio','1|radio'),
('bildredaktör','1|redaktör'),
('bildreportage','1|reportage'),
('bildrik','1|bild'),
('bildrikedom','1|bildrik'),
('bildrulle','1|bilförare'),
('bildrulle','2|rulle'),
('bildruta','1|TV-ruta'),
('bildrör','1|bildskärm'),
('bildsida','1|sida'),
('bildsignal','1|signal'),
('bildskrift','1|skrift'),
('bildskärm','1|visa'),
('bildskärpa','1|skärpa'),
('bildskön','1|skön'),
('bildskönhet','1|bildskön'),
('bildsnidare','1|skulptör'),
('bildsnideri','1|bildsnidare'),
('bildspel','1|spel'),
('bildspråk','1|språk'),
('bildsten','1|minnesmärke'),
('bildstod','1|staty'),
('bildstormare','1|angripa'),
('bildstrid','1|strid'),
('bildsvit','1|svit'),
('bildtelefon','1|telefon'),
('bildtelegrafi','1|telegrafi'),
('bildtext','1|text'),
('bildtolkning','1|tolkning'),
('bildverk','1|bok'),
('bildvävnad','1|vävnad'),
('bildäck','1|däck'),
('bildöverföring','1|överföring'),
('bilfabrik','1|fabrik'),
('bilfabrikör','1|bilfabrik'),
('bilfri','1|bil'),
('bilfärd','1|fara'),
('bilfärja','1|färja'),
('bilfönster','1|bilruta'),
('bilförare','1|bil'),
('bilförsäkring','1|försäkring'),
('bilförsäljare','1|försäljare'),
('bilgolv','1|golv'),
('bilhammare','1|bilmaskin'),
('bilhjul','1|hjul'),
('bilhögtalare','1|högtalare'),
('bilindustri','1|industri'),
('bilingual','1|tvåspråkig'),
('bilingualism','1|bilingual'),
('bilism','1|bil'),
('bilist','1|bil'),
('bilistisk','1|bilism'),
('biljard','1|spel'),
('biljard','2|tal'),
('biljard','2|tal'),
('biljardboll','1|boll'),
('biljardbollsuniversum','1|universum'),
('biljardbord','1|bord'),
('biljardkäpp','1|käpp'),
('biljardkö','1|käpp'),
('biljardsalong','1|lokal'),
('biljardspel','1|biljard'),
('biljett','1|tillstånd'),
('biljett','2|meddelande'),
('biljettautomat','1|automat'),
('biljettbok','1|biljetthäfte'),
('biljettbokning','1|bokning'),
('biljettbråk','1|bråk'),
('biljettexpedition','1|expedition'),
('biljettficka','1|ficka'),
('biljettförsäljare','1|biljettförsäljning'),
('biljettförsäljning','1|försäljning'),
('biljetthäfte','1|biljett'),
('biljetthärva','1|härva'),
('biljettinkomst','1|inkomst'),
('biljettkontor','1|biljettexpedition'),
('biljettkontroll','1|kontroll'),
('biljettköp','1|köp'),
('biljettlucka','1|biljettförsäljning'),
('biljettlös','1|biljett'),
('biljettmaskin','1|biljettkontroll'),
('biljettpris','1|pris'),
('biljettsläpp','1|släpp'),
('biljettvisering','1|biljettkontroll'),
('biljettång','1|tång'),
('biljon','1|tal'),
('biljon','1|tal'),
('biljonte','1|biljon'),
('biljonte','1|biljon'),
('biljud','1|ljud'),
('bilkaross','1|kaross'),
('bilkarta','1|karta'),
('bilklädsel','1|klädsel'),
('bilkonstruktör','1|konstruera'),
('bilkrasch','1|krasch'),
('bilkrock','1|krock'),
('bilkupé','1|kupé'),
('bilkyrkogård','1|bilskrot'),
('bilkår','1|kår'),
('bilkårist','1|bilkår'),
('bilkö','1|kö'),
('bilköp','1|köp'),
('bilkörning','1|köra'),
('bill','1|plogbill'),
('bill','2|lagförslag'),
('billa','1|getingbilla'),
('billampa','1|billjus'),
('billast','1|last'),
('Billdal','1|Göteborg'),
('billig','1|dyr'),
('billig','2|skälig'),
('billighet','1|rätt'),
('billighet','2|billig'),
('billighet','3|billig'),
('billighetsupplaga','1|bok'),
('Billingen','1|berg'),
('Billings','1|stad'),
('billjus','1|belysning'),
('billots','1|lots'),
('Billy','1|Bill'),
('billykta','1|strålkastare'),
('billån','1|bilstöld'),
('billås','1|lås'),
('bilmaskin','1|hugga'),
('bilmekaniker','1|mekaniker'),
('bilmotor','1|motor'),
('bilmålvakt','1|målvakt'),
('bilmärke','1|märke'),
('bilnavigator','1|GPS'),
('bilning','1|bila'),
('bilnummer','1|registreringsnummer'),
('bilnyckel','1|nyckel'),
('bilolycka','1|olycka'),
('bilpark','1|bestånd'),
('bilparkering','1|parkeringsplats'),
('bilplåt','1|plåt'),
('bilpool','1|hyrbil'),
('bilprovning','1|kontroll'),
('bilradio','1|radio'),
('bilradioapparat','1|bilradio'),
('bilrally','1|biltävling'),
('bilratt','1|ratt'),
('bilregister','1|register'),
('bilrengöring','1|biltvätt'),
('bilresa','1|resa'),
('bilring','1|gummidäck'),
('bilrock','1|rock'),
('bilruta','1|glasruta'),
('bilschampo','1|medel'),
('bilschamposvamp','1|svamp'),
('bilsjuk','1|illamående'),
('bilsjuka','1|illamående'),
('bilsjukhet','1|bilsjuk'),
('bilskatt','1|skatt'),
('bilskojare','1|skojare'),
('bilskola','1|skola'),
('bilskrot','1|anläggning'),
('bilskrotning','1|skrota'),
('bilskrotningspremie','1|premie'),
('bilsläpkärra','1|släpkärra'),
('bilspackel','1|spackel'),
('bilstol','1|bilsäte'),
('bilstöld','1|stöld'),
('bilsäte','1|säte'),
('biltak','1|tak'),
('biltelefon','1|radiotelefon'),
('biltillverkare','1|tillverkare'),
('biltillverkning','1|tillverkning'),
('biltjuv','1|tjuv'),
('biltog','1|fredlös'),
('biltoghet','1|biltog'),
('biltrafik','1|trafik'),
('biltull','1|vägtull'),
('biltunnel','1|tunnel'),
('biltur','1|tur'),
('biltvätt','1|tvätt'),
('biltvätt','2|tvätt'),
('biltvättborste','1|borste'),
('biltävling','1|tävling'),
('bilvax','1|vax'),
('bilverkstad','1|verkstad'),
('bilvrak','1|bil'),
('bilväg','1|väg'),
('bilyxa','1|bila'),
('bilåkning','1|bil'),
('bilägare','1|ägare'),
('biläger','1|bröllop'),
('bilägga','1|bilaga'),
('bilägga','2|avsluta'),
('biläggande','1|bilägga'),
('biläggande','2|bilägga'),
('biläggning','1|bilägga'),
('biläggning','2|bilägga'),
('bimbo','1|kvinna'),
('bimbofilm','1|film'),
('bimetall','1|metall'),
('bimetallism','1|penningsystem'),
('bimåne','1|fläck'),
('binamn','1|namn'),
('bind','1|band'),
('binda','1|ihop'),
('binda','2|skydd'),
('binda','3|bindande'),
('bindande','1|skyldighet'),
('bindande','2|binda'),
('bindande','3|binda'),
('bindare','1|bindsten'),
('bindbjälke','1|bjälke'),
('bindehinna','1|hinna'),
('bindehinneinflammation','1|inflammation'),
('bindel','1|band'),
('bindemedel','1|medel'),
('bindenyckel','1|bikt'),
('bindeord','1|konjunktion'),
('binderi','1|krans'),
('bindestreck','1|avstava'),
('bindesubstans','1|vävnad'),
('bindesäck','1|bindehinna'),
('bindevokal','1|vokal'),
('bindgalen','1|galen'),
('bindgalenhet','1|bindgalen'),
('bindgarn','1|snöre'),
('bindning','1|binda'),
('bindning','2|binda'),
('bindningstid','1|tid'),
('bindnål','1|nål'),
('bindsle','1|skida'),
('bindsle','1|skida'),
('bindsten','1|mursten'),
('bindsula','1|sula'),
('bindtråd','1|tråd'),
('bindväv','1|vävnad'),
('bindvävsfiber','1|fiber'),
('bindvävshinna','1|hinna'),
('bindvävskapsel','1|kapsel'),
('bindvävssjukdom','1|sjukdom'),
('bindvävssäck','1|säck'),
('bindvävstråd','1|tråd'),
('bindämne','1|bindemedel'),
('binga','1|hög'),
('binge','1|lår'),
('bingel','1|växt'),
('bingo','1|hasardspel'),
('bingobricka','1|spelbricka'),
('bingosugen','1|sugen'),
('bingosugenhet','1|bingosugen'),
('binjure','1|njure'),
('binjurebark','1|binjure'),
('binka','1|aster'),
('binnikemask','1|parasit'),
('binokel','1|glasögon'),
('binokulär','1|öga'),
('binom','1|matematik'),
('binomial','1|binom'),
('binär','1|två'),
('binäring','1|näring'),
('bio','1|biograf'),
('bioaktuell','1|aktuell'),
('biobank','1|bevara'),
('biobankning','1|biobank'),
('biobesök','1|besök'),
('biobiljett','1|biljett'),
('biobränsle','1|bränsle'),
('biocid','1|bekämpningsmedel'),
('biodlare','1|bi'),
('biodling','1|biodlare'),
('biodrivmedel','1|drivmedel'),
('bioduk','1|biograf'),
('biodynamik','1|vetenskap'),
('biodynamisk','1|odla'),
('biofilm','1|film'),
('biofilm','2|film'),
('biofysik','1|biofysisk'),
('biofysisk','1|vetenskap'),
('bioföreställning','1|föreställning'),
('biogas','1|bränsle'),
('biogasanläggning','1|anläggning'),
('biogasdriven','1|driva'),
('biogasproduktion','1|produktion'),
('biogasrening','1|rena'),
('biogen','1|ämne'),
('biogenes','1|biogenetisk'),
('biogenetisk','1|ursprung'),
('biogeografi','1|utbredning'),
('biograf','1|visa'),
('biografbyrå','1|filmgranskning'),
('biografera','1|biografi'),
('biograferande','1|biografera'),
('biograferbar','1|biografera'),
('biograferbarhet','1|biograferbar'),
('biografering','1|biografera'),
('biografföreståndare','1|föreståndare'),
('biografi','1|skildring'),
('biografisk','1|biografi'),
('biografmässig','1|biograf'),
('biograforgel','1|stumfilm'),
('biografpublik','1|publik'),
('biografteater','1|biograf'),
('biokemi','1|vetenskap'),
('biokemisk','1|kemisk'),
('biokemist','1|biokemi'),
('bioklimatologi','1|klimatologi'),
('biokronologi','1|kronologi'),
('biolog','1|biologi'),
('biologi','1|vetenskap'),
('biologibok','1|lärobok'),
('biologisk','1|liv'),
('biologisk','1|liv'),
('biomassa','1|massa'),
('biomedicin','1|medicin'),
('biomedicinsk','1|medicinsk'),
('biometri','1|mätning'),
('biometrisk','1|biometri'),
('biomständighet','1|omständighet'),
('biopremiär','1|filmpremiär'),
('bioreaktor','1|reaktor'),
('biorytm','1|rytm'),
('biosalong','1|salong'),
('biosfär','1|område'),
('bioteknik','1|bioteknisk'),
('bioteknisk','1|process'),
('bioteknologisk','1|teknologisk'),
('biotisk','1|organism'),
('biotop','1|livsmiljö'),
('biotyp','1|arvsanlag'),
('biperson','1|bifigur'),
('biplan','1|flygplan'),
('biplanet','1|drabant'),
('bipolaritet','1|biogeografi'),
('bipolär','1|bipolaritet'),
('bipolär','2|pol'),
('bipolär','3|manodepressiv'),
('biprodukt','1|produkt'),
('bir','1|öl'),
('bira','1|öl'),
('birdie','1|golf'),
('birem','1|fartyg'),
('birfilare','1|fiolspelare'),
('Birmingham','1|stad'),
('Birmingham','2|stad'),
('biroll','1|roll'),
('birot','1|rot'),
('bisak','1|sak'),
('bisam','1|pälsverk'),
('bisamhälle','1|samhälle'),
('bisamoxe','1|myskoxe'),
('bisamråtta','1|sork'),
('bisamsvin','1|svin'),
('bisarr','1|underlig'),
('bisarreri','1|bisarr'),
('bisarrhet','1|bisarr'),
('bisats','1|sats'),
('bisatsordföljd','1|ordföljd'),
('bischoff','1|vinbål'),
('bisektris','1|vinkel'),
('bisexualitet','1|sexualitet'),
('bisexuell','1|bisexualitet'),
('bisfenol','1|ämne'),
('bisittare','1|biträda'),
('biskop','1|präst'),
('biskoplig','1|biskop'),
('biskoplighet','1|biskoplig'),
('biskopsdöme','1|stift'),
('biskopskors','1|kors'),
('biskopskräkla','1|kräkla'),
('biskopskräkla','1|kräkla'),
('biskopsmössa','1|mössa'),
('biskopsmöte','1|möte'),
('biskopsskrud','1|skrud'),
('biskopsstav','1|stav'),
('biskopsstift','1|stift'),
('biskopsstol','1|biskop'),
('biskopssäte','1|biskop'),
('biskopsval','1|val'),
('biskopsvisitation','1|visitation'),
('biskvi','1|kaka'),
('bisköldkörtel','1|körtel'),
('biskötsel','1|biodling'),
('bismak','1|smak'),
('Bismarck','1|huvudstad'),
('bisol','1|fläck'),
('bison','1|bisonoxe'),
('bisonoxe','1|buffel'),
('bisp','1|biskop'),
('bispringa','1|hjälpa'),
('bispringande','1|bispringa'),
('bissauguinean','1|Guinea_Bissau'),
('bissauguineansk','1|Guinea_Bissau'),
('bissauguineanska','1|bissauguinean'),
('bissera','1|repetera'),
('bisserande','1|bissera'),
('bisserbar','1|bissera'),
('bisserbarhet','1|bisserbar'),
('bissering','1|bissera'),
('bister','1|allvarlig'),
('bister','2|vattenfärg'),
('bisterhet','1|bister'),
('bistick','1|stick'),
('bisting','1|bistick'),
('bisting','1|bistick'),
('bistock','1|bikupa'),
('bistro','1|bar'),
('bisträcka','1|hjälpa'),
('bisträckande','1|bisträcka'),
('bisturi','1|kniv'),
('bistå','1|hjälpa'),
('bistå','1|hjälpa'),
('bistående','1|bistå'),
('bistånd','1|hjälp'),
('biståndsförvaltning','1|förvaltning'),
('biståndsland','1|land'),
('biståndsminister','1|minister'),
('biståndsmål','1|mål'),
('biståndsorgan','1|organ'),
('biståndspolitik','1|politik'),
('biståndspolitisk','1|biståndspolitik'),
('biståndsprogram','1|program'),
('biståndsprojekt','1|projekt'),
('biståndsskepp','1|skepp'),
('bisvärm','1|svärm'),
('bisyssla','1|syssla'),
('bisätta','1|bisättning'),
('bisättande','1|bisätta'),
('bisättning','1|begravning'),
('bit','1|stycke'),
('bit','2|siffra'),
('bita','1|ihop'),
('bita','2|bit'),
('bitande','1|köld'),
('bitande','2|bita'),
('bitande','3|bita'),
('bitanke','1|baktanke'),
('bitas','1|bita'),
('bitch','1|otrevlig'),
('bitchig','1|bitch'),
('bitecken','1|heraldik'),
('biten','1|intresserad'),
('bitestikel','1|organ'),
('bitmärke','1|märke'),
('biton','1|undermening'),
('bitryck','1|betoning'),
('biträda','1|hjälpa'),
('biträdande','1|biträda'),
('biträdande','2|biträda'),
('biträde','1|biträda'),
('bits','1|stycke'),
('bitshållare','1|hållare'),
('bitsk','1|bita'),
('bitskhet','1|bitsk'),
('bitsocker','1|sockerbit'),
('bitsår','1|sår'),
('bitteliten','1|liten'),
('bittelitenhet','1|bitteliten'),
('bitter','1|smak'),
('bitter','2|ledsen'),
('bitterhet','1|bitter'),
('bitterkall','1|kall'),
('bitterligen','1|bitter'),
('bitterljuv','1|ljuv'),
('bitterljuvhet','1|bitterljuv'),
('bittermandel','1|mandel'),
('bittermandelolja','1|olja'),
('bittersalt','1|avföringsmedel'),
('bittersalt','2|salt'),
('bittersta','1|liten'),
('bittersöt','1|söt'),
('bittersöta','1|besksöta'),
('bittervatten','1|vatten'),
('bittida','1|morgon'),
('bitumen','1|förening'),
('bituminös','1|bitumen'),
('bitvarg','1|ilsken'),
('bitvis','1|bit'),
('bivack','1|nattläger'),
('bivackera','1|bivack'),
('bivackerande','1|bivackera'),
('bivackerbar','1|bivackera'),
('bivackerbarhet','1|bivackerbar'),
('bivackering','1|bivackera'),
('bivax','1|vax'),
('biverkan','1|verkan'),
('biverkning','1|inverkan'),
('biverkningsfall','1|fall'),
('biverkningsrapport','1|rapport'),
('bivråk','1|vråk'),
('biväg','1|sidoväg'),
('biyngel','1|bi'),
('biämne','1|skolämne'),
('biätare','1|fågel'),
('bjuda','1|ge'),
('bjuda','2|bud'),
('bjuda','3|bud'),
('bjudande','1|bjuda'),
('bjudande','2|bjuda'),
('bjudande','3|bjuda'),
('bjudcigarr','1|cigarr'),
('bjudning','1|fest'),
('bjugg','1|korn'),
('bjussa','1|bjuda'),
('bjussande','1|bjussa'),
('bjäbb','1|bjäbbig'),
('bjäbba','1|bjäbbig'),
('bjäbbande','1|bjäbba'),
('bjäbbig','1|uppnosig'),
('bjäbbighet','1|bjäbbig'),
('bjäfs','1|prydnad'),
('bjälke','1|bära'),
('bjälkhuvud','1|bjälke'),
('bjälklag','1|bjälke'),
('bjälkverk','1|bjälke'),
('bjällerklang','1|bjällra'),
('bjällko','1|skällko'),
('bjällra','1|klinga'),
('bjärt','1|klar'),
('bjärtgrön','1|grön'),
('bjärthet','1|bjärt'),
('bjässe','1|jätte'),
('björk','1|träd'),
('björkblad','1|björklöv'),
('björke','1|virke'),
('Björkekärr','1|Göteborg'),
('björkgren','1|gren'),
('björkgräns','1|gräns'),
('björkhage','1|hage'),
('björklag','1|björksav'),
('björklöv','1|löv'),
('björkna','1|karpfisk'),
('björknäver','1|näver'),
('björkpollen','1|pollen'),
('björkregion','1|region'),
('björkris','1|ris'),
('björksav','1|sav'),
('björkskog','1|skog'),
('björksly','1|busksly'),
('björksopp','1|svamp'),
('björktrast','1|trast'),
('björkved','1|ved'),
('björn','1|djur'),
('björna','1|kräva'),
('björnande','1|björna'),
('björnbindsle','1|kätting'),
('björnbindsle','1|kätting'),
('björnbär','1|bär'),
('björnbärsbuske','1|buske'),
('björnfloka','1|växt'),
('björngrop','1|fångstgrop'),
('björnhallon','1|björnbär'),
('björnhona','1|björn'),
('björnhund','1|hund'),
('björnide','1|ide'),
('björninna','1|björnhona'),
('björnjakt','1|jakt'),
('björnliknande','1|björn'),
('björnloka','1|växt'),
('björnmossa','1|mossa'),
('björnram','1|framben'),
('björnsax','1|fälla'),
('björnskall','1|björnjakt'),
('björnskinn','1|skinn'),
('björnskinnsmössa','1|mössa'),
('björnskådning','1|turism'),
('björntjänst','1|otjänst'),
('björntjänst','2|tjänst'),
('björntråd','1|sytråd'),
('Björnvaktaren','1|stjärnbild'),
('black','1|färg'),
('black','2|pank'),
('black','3|häst'),
('blackhet','1|black'),
('blackhet','2|black'),
('blackig','1|black'),
('blackighet','1|blackig'),
('blackout','1|medvetslös'),
('blad','1|växt'),
('blad','2|bok'),
('blad','3|platt'),
('blada','1|blad'),
('bladande','1|blada'),
('bladbagge','1|skalbagge'),
('bladbildning','1|blad'),
('bladbyte','1|byte'),
('bladder','1|struntprat'),
('bladdra','1|bladder'),
('bladdrande','1|bladdra'),
('bladfot','1|blad'),
('bladfoting','1|kräftdjur'),
('bladguld','1|guld'),
('bladig','1|berusad'),
('bladknopp','1|knopp'),
('bladkrans','1|krans'),
('bladkål','1|kål'),
('bladloppa','1|loppa'),
('bladlus','1|lus'),
('bladlängd','1|längd'),
('bladmage','1|mage'),
('bladmetall','1|metall'),
('bladminerare','1|skalbagge'),
('bladmossa','1|mossa'),
('bladmögel','1|mögelsvamp'),
('bladnerv','1|nerv'),
('bladning','1|blada'),
('bladrik','1|blad'),
('bladrullsjuka','1|sjukdom'),
('bladrött','1|färgämne'),
('bladsilver','1|silver'),
('bladskaft','1|skaft'),
('bladskärarmyra','1|myra'),
('bladspänning','1|spänning'),
('bladstekel','1|stekel'),
('bladställning','1|ställning'),
('bladverk','1|blad'),
('bladväxt','1|växt'),
('blaffa','1|fläck'),
('B-lag','1|lag'),
('blaggarn','1|garn'),
('blaj','1|struntprat'),
('blaja','1|blaj'),
('blajande','1|blaja'),
('blam','1|blamage'),
('blamage','1|klavertramp'),
('blamant','1|blamera_sig'),
('blanchera','1|koka'),
('blancherande','1|blanchera'),
('blancherbar','1|blanchera'),
('blancherbarhet','1|blancherbar'),
('blanchering','1|blanchera'),
('blancmangé','1|efterrätt'),
('bland','1|i'),
('bland','1|i'),
('blanda','1|ihop'),
('blandad','1|blanda'),
('blandande','1|blanda'),
('blandare','1|maskin'),
('blandare','2|vattenkran'),
('blanddricka','1|groggvirke'),
('blanddricka','1|groggvirke'),
('blandekonomi','1|ekonomi'),
('blandfoder','1|foder'),
('blandfolk','1|ras'),
('blandform','1|form'),
('blandfärg','1|färg'),
('blandkultur','1|kultur'),
('blandning','1|blanda'),
('blandningsförhållande','1|förhållande'),
('blandningskran','1|kran'),
('blandras','1|korsning'),
('blandrashund','1|hund'),
('blandskog','1|skog'),
('blandspråk','1|språk'),
('blandsäd','1|säd'),
('blandtyp','1|typ'),
('blandvatten','1|vatten'),
('blandvatten','2|groggvirke'),
('blandäktenskap','1|äktenskap'),
('blank','1|blänka'),
('blank','2|mellanslag'),
('blank','3|tom'),
('blanka','1|blank'),
('blanka','2|domino'),
('blanka','3|blankning'),
('blankande','1|blanka'),
('blankande','2|blanka'),
('blankborste','1|skoborste'),
('blankett','1|formulär'),
('blankettraseri','1|blankett'),
('blankettskåp','1|skåp'),
('blankgalvad','1|galva'),
('blankhet','1|blank'),
('blankhet','2|blank'),
('blankis','1|is'),
('blanklax','1|lax'),
('blankläder','1|läder'),
('blankning','1|aktiehandel'),
('blankning','2|blankoförsäljning'),
('blankningsaffär','1|blankning'),
('blankningsförbud','1|förbud'),
('blankoaccept','1|blankoväxel'),
('blankocheck','1|check'),
('blankofullmakt','1|fullmakt'),
('blankoförsäljning','1|försäljning'),
('blankokredit','1|kredit'),
('blankotransport','1|överlåta'),
('blankoväxel','1|växel'),
('blankoöverlåtelse','1|blankotransport'),
('blankpolera','1|polera'),
('blankpolerande','1|blankpolera'),
('blankpolerbar','1|blankpolera'),
('blankpolerbarhet','1|blankpolerbar'),
('blankpolering','1|blankpolera'),
('blankputsad','1|putsa'),
('blankröstare','1|rösta'),
('blanksej','1|lyrtorsk'),
('blankskinn','1|lyrtorsk'),
('blankslipa','1|slipa'),
('blankslipande','1|blankslipa'),
('blankslipning','1|blankslipa'),
('blanksliten','1|slita'),
('blanksmörja','1|skokräm'),
('blanksvärta','1|skokräm'),
('blankvatten','1|vatten'),
('blankvers','1|versmått'),
('blankål','1|ål'),
('BLARK','1|språkteknologi'),
('BLARK','1|språkteknologi'),
('blarr','1|struntprat'),
('blarra','1|blarr'),
('blarrande','1|blarra'),
('blasé','1|blaserad'),
('blaserad','1|liknöjd'),
('blasfemi','1|hädelse'),
('blasfemisk','1|blasfemi'),
('blask','1|dryck'),
('blask','2|regn'),
('blaska','1|vatten'),
('blaska','2|tidning'),
('blaskande','1|blaska'),
('blaskig','1|blask'),
('blaskig','2|blask'),
('blaskighet','1|blaskig'),
('blasonering','1|heraldik'),
('blast','1|blad'),
('blastula','1|embryo'),
('blatte','1|svartskalle'),
('blazer','1|kavaj'),
('blazerklädd','1|klä'),
('bleck','1|plåt'),
('bleckblåsinstrument','1|blåsinstrument'),
('bleckburk','1|burk'),
('bleckinstrument','1|bleckblåsinstrument'),
('bleckmusik','1|musik'),
('bleckplåt','1|bleck'),
('bleckslagare','1|plåtslagare'),
('bleckslageri','1|plåtslageri'),
('blecksmak','1|smak'),
('blek','1|färglös'),
('bleka','1|blek'),
('blekande','1|bleka'),
('blekansikte','1|ras'),
('blekblå','1|blå'),
('bleke','1|vindstilla'),
('blekeri','1|bleka'),
('blekfet','1|fet'),
('blekfethet','1|blekfet'),
('blekfis','1|blek'),
('blekglaserad','1|glasera'),
('blekgul','1|gul'),
('blekhet','1|blek'),
('bleking','1|Blekinge'),
('Blekinge','1|landskap'),
('blekingseka','1|segelbåt'),
('blekingsk','1|Blekinge'),
('blekingska','1|bleking'),
('blekingska','2|dialekt'),
('blekjord','1|jordart'),
('bleklagd','1|blek'),
('bleklagdhet','1|bleklagd'),
('blekmedel','1|medel'),
('blekna','1|blek'),
('bleknande','1|blekna'),
('blekning','1|bleka'),
('bleknos','1|blek'),
('blekröd','1|röd'),
('blekselleri','1|selleri'),
('bleksiktig','1|bleksot'),
('bleksiktighet','1|bleksiktig'),
('bleksot','1|blodbrist'),
('blekvätska','1|blekmedel'),
('blemma','1|finne'),
('blemmig','1|blemma'),
('Blend','1|cigarett'),
('blessera','1|blessyr'),
('blesserande','1|blessera'),
('blesserbar','1|blessera'),
('blesserbarhet','1|blesserbar'),
('blessering','1|blessera'),
('blessyr','1|sårskada'),
('bli','1|börja'),
('bli','2|förbli'),
('blick','1|se'),
('blicka','1|blick'),
('blickande','1|blicka'),
('blickfång','1|blick'),
('blickfält','1|blickfång'),
('blickpunkt','1|uppmärksamma'),
('blickstilla','1|stilla'),
('blid','1|vänlig'),
('blid','2|ljummen'),
('blida','1|kastmaskin'),
('blidgrad','1|blid'),
('blidhet','1|blid'),
('blidhet','2|blid'),
('blidka','1|försona'),
('blidkande','1|blidka'),
('blidvinter','1|vinter'),
('blidväder','1|blid'),
('blig','1|bliga'),
('bliga','1|stirra'),
('bligande','1|bliga'),
('blind','1|se'),
('blinda','1|rå'),
('blindalfabet','1|blindskrift'),
('blindbock','1|lek'),
('blindbotten','1|trossbotten'),
('blindbroms','1|broms'),
('blinddörr','1|dörr'),
('blindera','1|blindering'),
('blinderande','1|blindera'),
('blinderbar','1|blindera'),
('blinderbarhet','1|blinderbar'),
('blindering','1|mur'),
('blindering','2|skyddsgrav'),
('blindflygning','1|instrumentflygning'),
('blindfönster','1|fönster'),
('blindgata','1|återvändsgata'),
('blindgångare','1|granat'),
('blindhet','1|blind'),
('blindhund','1|ledarhund'),
('blindinstitut','1|blindskola'),
('blindkarta','1|karta'),
('blindlandning','1|blindflygning'),
('blindlykta','1|lykta'),
('blindnässla','1|nässla'),
('blindparti','1|blindschack'),
('blindpassagerare','1|gratispassagerare'),
('blindpatron','1|patron'),
('blindpipa','1|orgelpipa'),
('blindpressa','1|blindtryck'),
('blindpressande','1|blindpressa'),
('blindpressning','1|blindpressa'),
('blindrote','1|rote'),
('blindrå','1|rå'),
('blindschack','1|schack'),
('blindskola','1|skola'),
('blindskrift','1|skrift'),
('blindskär','1|grund'),
('blindspår','1|järnväg'),
('blindstyre','1|fumlig'),
('blindtarm','1|tarm'),
('blindtarmsinflammation','1|inflammation'),
('blindtarmsoperation','1|operation'),
('blindtryck','1|tryck'),
('bling','1|bling-bling'),
('blinga','1|bling-bling'),
('blingande','1|blinga'),
('bling-bling','1|prydnad'),
('blingning','1|blinga'),
('blini','1|boveteplätt'),
('blink','1|blinka'),
('blink','2|ögonblick'),
('blinka','1|lysa'),
('blinka','2|blunda'),
('blinkande','1|blinka'),
('blinkande','2|blinka'),
('blinker','1|körriktningsvisare'),
('blinkfyr','1|fyr'),
('blinkhinna','1|ögonlock'),
('blinkljus','1|blinka'),
('blinkning','1|blinka'),
('blinkning','2|blinka'),
('blinning','1|blindbroms'),
('blip','1|markör'),
('blip','1|markör'),
('blippa','1|blip'),
('blippande','1|blippa'),
('blippning','1|blippa'),
('blivande','1|framtida'),
('blivande','2|bli'),
('blivande','2|bli'),
('blixt','1|ljus'),
('blixt','2|åska'),
('blixtanfall','1|anfall'),
('blixtbelysning','1|blixtljus'),
('blixtbesök','1|besök'),
('blixtfoto','1|fotografi'),
('blixtfotografera','1|blixtfotografering'),
('blixtfotograferande','1|blixtfotografera'),
('blixtfotograferbar','1|blixtfotografera'),
('blixtfotograferbarhet','1|blixtfotograferbar'),
('blixtfotografering','1|fotografering'),
('blixtfyr','1|fyr'),
('blixtförälskad','1|förälska_sig'),
('blixthalka','1|halka'),
('blixtinkalla','1|inkalla'),
('blixtinkallad','1|inkalla'),
('blixtinkallande','1|blixtinkalla'),
('blixtinkallelse','1|blixtinkalla'),
('blixtinvasion','1|invasion'),
('blixtkrig','1|krig'),
('blixtlampa','1|blixtljus'),
('blixtljus','1|fotoblixt'),
('blixtlås','1|dragkedja'),
('blixtnedslag','1|nedslag'),
('blixtpatron','1|patron'),
('blixtpulver','1|blixtljus'),
('blixtra','1|blixt'),
('blixtrande','1|glänsande'),
('blixtrande','2|blixtra'),
('blixtsamtal','1|telefonsamtal'),
('blixtsnabb','1|snabb'),
('blixtsnabbhet','1|blixtsnabb'),
('blixtutryckning','1|utryckning'),
('blixtvisit','1|blixtbesök'),
('block','1|stycke'),
('block','2|häfte'),
('block','3|grupp'),
('block','4|talja'),
('blocka','1|lästblock'),
('blockad','1|blockera'),
('blockad','2|strejk'),
('blockadbrott','1|genombryta'),
('blockadbrytare','1|fartyg'),
('blockalmanacka','1|almanacka'),
('blockalmanacka','1|almanacka'),
('blockande','1|blocka'),
('blockbildning','1|block'),
('blockchoklad','1|chokladkaka'),
('blockdiagram','1|stolpdiagram'),
('blockera','1|hindra'),
('blockerande','1|blockera'),
('blockerbar','1|blockera'),
('blockerbarhet','1|blockerbar'),
('blockering','1|blockera'),
('blockflöjt','1|flöjt'),
('blockgräns','1|gräns'),
('blockhus','1|timmerhus'),
('blockig','1|block'),
('blockighet','1|blockig'),
('blockmark','1|mark'),
('blockpolitik','1|politik'),
('blockpolitisk','1|blockpolitik'),
('blocksignal','1|järnvägssignal'),
('blockskiva','1|block'),
('blocksystem','1|blocksignal'),
('blocktalja','1|talja'),
('blocktrissa','1|blockskiva'),
('blocktyg','1|block'),
('blocktänkande','1|tänkande'),
('blockvagn','1|vagn'),
('blockämne','1|läroämne'),
('blocköverskridande','1|överskrida'),
('blod','1|kropp'),
('bloda','1|blod'),
('blodande','1|bloda'),
('blodapelsin','1|apelsin'),
('blodbad','1|döda'),
('blodbank','1|förråd'),
('blodbefläckad','1|spår'),
('blodbestänkt','1|blodig'),
('blodbesudlad','1|blodbefläckad'),
('blodblåsa','1|blåsa'),
('blodbok','1|bok'),
('blodbrist','1|brist'),
('blodcancer','1|leukemi'),
('blodcell','1|blodkropp'),
('blodcirkulation','1|blodomlopp'),
('bloddoping','1|doping'),
('bloddrypande','1|våldsam'),
('bloddränkt','1|blodig'),
('blodfattig','1|färglös'),
('blodfattighet','1|blodfattig'),
('blodfläck','1|fläck'),
('blodflöde','1|flöde'),
('blodfull','1|färgstark'),
('blodfullhet','1|blodfull'),
('blodfyllning','1|fylla'),
('blodfärgämne','1|hemoglobin'),
('blodförgiftning','1|infektion'),
('blodförlust','1|förlust'),
('blodförtunnande','1|förtunna'),
('blodgenomströmning','1|genomströmning'),
('blodgivarcentral','1|central'),
('blodgivare','1|blodgivning'),
('blodgivning','1|ge'),
('blodgrape','1|grapefrukt'),
('blodgrupp','1|typ'),
('blodgång','1|blödning'),
('blod-hjärnbarriären','1|barriär'),
('blodhosta','1|hosta'),
('blodhostning','1|blodhosta'),
('blodhund','1|hundras'),
('blodig','1|blod'),
('blodigel','1|igel'),
('blodighet','1|blodig'),
('blodisande','1|kuslig'),
('blodkorv','1|korv'),
('blodkropp','1|kropp'),
('blodkräfta','1|leukemi'),
('blodkräkning','1|kräkning'),
('blodkärl','1|kärl'),
('blodkärlsbråck','1|bråck'),
('blodledare','1|blodkärl'),
('blodlever','1|blod'),
('blodlutsalt','1|salt'),
('blodlutsalt','1|salt'),
('blodlönn','1|lönn'),
('blodlös','1|blodfattig'),
('blodlöshet','1|blodlös'),
('blodmat','1|mat'),
('blodnäva','1|växt'),
('blodomlopp','1|cirkulera'),
('blodpalt','1|maträtt'),
('blodplasma','1|blod'),
('blodplätt','1|blod'),
('blodpropp','1|propp'),
('blodprotein','1|protein'),
('blodprov','1|prov'),
('blodprovstagning','1|blodprov'),
('blodpudding','1|maträtt'),
('blodpuddingsbit','1|bit'),
('blodpump','1|hjärta'),
('blodpöl','1|pöl'),
('blodrand','1|svärd'),
('blodregn','1|regn'),
('blodriska','1|svamp'),
('blodrot','1|växt'),
('blodröd','1|röd'),
('blodsband','1|släkt'),
('blodsdiamant','1|konfliktdiamant'),
('blodsdrama','1|drama'),
('blodsdroppe','1|droppe'),
('blodsdåd','1|illdåd'),
('blodserum','1|serum'),
('blodshämnare','1|blodshämnd'),
('blodshämnd','1|hämnd'),
('blodsjukdom','1|sjukdom'),
('blodskam','1|incest'),
('blodsmak','1|smak'),
('blodsmystik','1|mystik'),
('blodsocker','1|socker'),
('blodsockersvacka','1|svacka'),
('blodspenning','1|rikedom'),
('blodspillan','1|blöda'),
('blodspottning','1|spotta'),
('blodsprängd','1|öga'),
('blodsprängdhet','1|blodsprängd'),
('blodspår','1|spår'),
('blodstallning','1|urin'),
('blodsten','1|hematit'),
('blodstensmalm','1|järnmalm'),
('blodstillande','1|stoppa'),
('blodstillning','1|blodstillande'),
('blodstinn','1|stinn'),
('blodstinnhet','1|blodstinn'),
('blodstockning','1|överfull'),
('blodstänkt','1|våldsam'),
('blodstörtning','1|blödning'),
('blodsugande','1|suga'),
('blodsugare','1|suga'),
('blodsugare','2|girigbuk'),
('blodsugeri','1|blodsugare'),
('blodsugeri','2|blodsugare'),
('blodsutgjutelse','1|döda'),
('blodsvettning','1|svettning'),
('blodsvulst','1|svulst'),
('blodsystem','1|blodomlopp'),
('blodsänka','1|sänka'),
('blodtappning','1|avtappa'),
('blodtransfusion','1|överföring'),
('blodtryck','1|tryck'),
('blodtryckshöjande','1|höja'),
('blodtryckshöjning','1|höjning'),
('blodtryckssänkande','1|sänka'),
('blodtryckssänkning','1|sänkning'),
('blodtyp','1|blodgrupp'),
('blodtörst','1|blodtörstig'),
('blodtörstig','1|vilja'),
('blodtörstighet','1|blodtörstig'),
('blodutgjutning','1|utgjutning'),
('blodvallning','1|blodvåg'),
('blodvatten','1|blodserum'),
('blodvite','1|sårskada'),
('blodvittring','1|vittring'),
('blodvåg','1|rodnad'),
('blodvärde','1|värde'),
('blodvätska','1|blodplasma'),
('blodåder','1|blodkärl'),
('blodöverfyllnad','1|blodstockning'),
('blodöverföring','1|blodtransfusion'),
('blogg','1|dagbok'),
('blogg','1|dagbok'),
('blogga','1|blogg'),
('blogga','1|blogg'),
('bloggande','1|blogga'),
('bloggande','1|blogga'),
('bloggare','1|blogga'),
('bloggare','1|blogga'),
('bloggerska','1|bloggare'),
('blogginlägg','1|inlägg'),
('blogginlägg','1|inlägg'),
('bloggosfär','1|blogg'),
('bloggosfär','1|blogg'),
('blom','1|blomma'),
('blomaxel','1|blomma'),
('blombefruktning','1|befruktning'),
('blomblad','1|kronblad'),
('blombord','1|blomsterbord'),
('blombotten','1|blomaxel'),
('blombukett','1|bukett'),
('blomdoft','1|doft'),
('blomfat','1|fat'),
('blomfjäll','1|blad'),
('blomflock','1|blomställning'),
('blomfoder','1|blomhylle'),
('blomform','1|form'),
('blomfäste','1|blomaxel'),
('blomholk','1|blomkorg'),
('blomhuvud','1|blomställning'),
('blomhylle','1|blomma'),
('blomhänge','1|blomställning'),
('blomhölster','1|blomma'),
('blomjord','1|jord'),
('blomkalk','1|blomhylle'),
('blomklase','1|blomställning'),
('blomklädd','1|blomsterklädd'),
('blomknippe','1|blomställning'),
('blomknopp','1|knopp'),
('blomkolv','1|blomställning'),
('blomkorg','1|blomställning'),
('blomkrans','1|blomställning'),
('blomkrona','1|blomhylle'),
('blomkruka','1|kruka'),
('blomkvast','1|blomklase'),
('blomkål','1|grönsak'),
('blomkålshuvud','1|blomkål'),
('blomkålssvamp','1|fingersvamp'),
('blomkålsöra','1|brottning'),
('blomkäpp','1|stöd'),
('blomlåda','1|blomplanta'),
('blomma','1|växt'),
('blomma','2|blomma'),
('blommande','1|blomma'),
('blommerad','1|blommig'),
('blommig','1|mönster'),
('blommighet','1|blommig'),
('blommografera','1|blommogram'),
('blommograferande','1|blommografera'),
('blommograferbar','1|blommografera'),
('blommograferbarhet','1|blommograferbar'),
('blommografering','1|blommografera'),
('blommogram','1|skicka'),
('blommönster','1|mönster'),
('blomning','1|blomma'),
('blomningstid','1|tid'),
('blomplanta','1|planta'),
('blomskaft','1|blomstjälk'),
('blomst','1|blomster'),
('blomster','1|blomma'),
('blomsteraffär','1|affär'),
('blomsterbord','1|bord'),
('blomsterbädd','1|bädd'),
('blomsterdoft','1|doft'),
('blomsterdoftande','1|blomma'),
('blomsterflicka','1|sälja'),
('blomsterförmedling','1|blommogram'),
('blomsterförsäljerska','1|försäljerska'),
('blomstergirland','1|girland'),
('blomstergård','1|blomsterträdgård'),
('blomsterhandel','1|blomsteraffär'),
('blomsterhandlare','1|blomsterhandel'),
('blomsterhonung','1|honung'),
('blomsterklädd','1|klä'),
('blomsterkrans','1|krans'),
('blomsterkransa','1|blomsterkrans'),
('blomsterkvast','1|blombukett'),
('blomsterlåda','1|blomlåda'),
('blomsterlök','1|lök'),
('blomstermålare','1|målare'),
('blomstermånad','1|maj'),
('blomsterodling','1|odling'),
('blomsterprakt','1|blomma'),
('blomsterrabatt','1|rabatt'),
('blomstersmycka','1|smycka'),
('blomsterspruta','1|vattenspruta'),
('blomsterspråk','1|språk'),
('blomstertid','1|tid'),
('blomsterträdgård','1|trädgård'),
('blomsteruppsats','1|prydnadsblomma'),
('blomstervas','1|blomvas'),
('blomsteräng','1|äng'),
('blomstjälk','1|stjälk'),
('blomstoft','1|frömjöl'),
('blomstra','1|blomma'),
('blomstrande','1|blomstra'),
('blomstring','1|blomstra'),
('blomstringsperiod','1|period'),
('blomstringstid','1|tid'),
('blomställ','1|ställ'),
('blomställning','1|blomma'),
('blomtjuv','1|tjuv'),
('blomvas','1|vas'),
('blomvass','1|vass'),
('blomväxt','1|fanerogam'),
('blond','1|ljushårig'),
('blond','2|spets'),
('blondera','1|blond'),
('blonderande','1|blondera'),
('blonderbar','1|blondera'),
('blonderbarhet','1|blonderbar'),
('blondering','1|blondera'),
('blondhet','1|blond'),
('blondin','1|blond'),
('bloss','1|blossa'),
('bloss','2|blossa'),
('blossa','1|brinna'),
('blossa','2|röka'),
('blossande','1|blossa'),
('blossande','2|blossa'),
('blot','1|offerrit'),
('blota','1|blot'),
('blotande','1|blota'),
('blott','1|bara'),
('blott','2|blott'),
('blott','3|blott'),
('blotta','1|oskyddad'),
('blotta','2|blotta'),
('blottande','1|blotta'),
('blottare','1|blotta_sig'),
('blottlägga','1|blotta'),
('blottläggande','1|blottlägga'),
('blottläggning','1|blottlägga'),
('blottställa','1|blottställd'),
('blottställande','1|blottställa'),
('blottställd','1|värnlös'),
('blottställdhet','1|blottställd'),
('blottställning','1|blottställa'),
('blowout','1|oljeutsläpp'),
('bludder','1|struntprat'),
('bluddra','1|bludder'),
('bluddrande','1|bluddra'),
('blues','1|musik'),
('bluesklagan','1|klagan'),
('bluff','1|bedrägeri'),
('bluffa','1|bluff'),
('bluffaktura','1|faktura'),
('bluffande','1|bluffa'),
('bluffbygge','1|bygge'),
('bluffmakare','1|bluff'),
('bluffpiller','1|piller'),
('bluffprojekt','1|forskningsprojekt'),
('blund','1|sova'),
('blunda','1|titta'),
('blunda','2|bortse'),
('blundande','1|blunda'),
('blundande','2|blunda'),
('blunddocka','1|docka'),
('blunder','1|misstag'),
('blus','1|kläder'),
('blusliv','1|liv'),
('bly','1|metall'),
('bly','2|grundämne'),
('bly','2|grundämne'),
('blya','1|bly'),
('blyacetat','1|acetat'),
('blyackumulator','1|blybatteri'),
('blyaktig','1|bly'),
('blyande','1|blya'),
('blyaska','1|glasyr'),
('blyazid','1|bly'),
('blybatteri','1|batteri'),
('blyblomma','1|krukväxt'),
('blydagg','1|slagvapen'),
('blyerts','1|grafit'),
('blyertsgrå','1|grå'),
('blyertspenna','1|penna'),
('blyfolie','1|folie'),
('blyfri','1|bly'),
('blyfärg','1|färgämne'),
('blyfärgad','1|bly'),
('blyförening','1|förening'),
('blyförgiftad','1|blyförgiftning'),
('blyförgiftning','1|förgiftning'),
('blyg','1|osäker'),
('blygas','1|skämmas'),
('blygd','1|könsdelar'),
('blygdben','1|bäckenben'),
('blygdhår','1|hårväxt'),
('blygdhår','2|hår'),
('blygdläpp','1|blygd'),
('Blyger','1|dvärg'),
('blyghet','1|blyg'),
('blyglans','1|mineral'),
('blyglas','1|glas'),
('blyglete','1|blyoxid'),
('blygrå','1|grå'),
('blygsam','1|anspråkslös'),
('blygsam','2|ringa'),
('blygsamhet','1|blygsam'),
('blygsel','1|blygas'),
('blygult','1|färgämne'),
('blyhagel','1|hagel'),
('blyhalt','1|halt'),
('blyhaltig','1|blyhalt'),
('blykula','1|kula'),
('blykyld','1|kyla'),
('blyköl','1|barlastköl'),
('blylod','1|lod'),
('blymantel','1|kabelhölje'),
('blymönja','1|rostskydd'),
('blyoxid','1|bly'),
('blyplåt','1|plåt'),
('blysalva','1|salva'),
('blysocker','1|blyacetat'),
('blytetraetyl','1|blyförening'),
('blytung','1|tung'),
('blytunghet','1|blytung'),
('blytyngd','1|tyngd'),
('blyvatten','1|blyacetat'),
('blyvitt','1|färgämne'),
('blyättika','1|blyacetat'),
('blå','1|färg'),
('blå','2|höger'),
('blåaktig','1|blå'),
('blåaktighet','1|blåaktig'),
('blåanlupen','1|blå'),
('blåblodig','1|adlig'),
('blåblodighet','1|blåblodig'),
('blåbyxa','1|blåkläder'),
('blåbär','1|bär'),
('blåbär','2|oerfaren'),
('blåbärsbuske','1|blåbär'),
('blåbärspannkaka','1|pannkaka'),
('blåbärsplockare','1|plocka'),
('blåbärsris','1|blåbär'),
('blåbärssaft','1|saft'),
('blåbärssoppa','1|soppa'),
('blåbärssylt','1|sylt'),
('blåduva','1|skogsduva'),
('blådåre','1|omdömeslös'),
('blåeld','1|växt'),
('blåelse','1|färgämne'),
('blåfrusen','1|frusen'),
('blåförskjutning','1|förskjutning'),
('blågrå','1|grå'),
('blågrön','1|grön'),
('blågrönalg','1|alg'),
('blågul','1|svensk'),
('blåhaj','1|haj'),
('blåhake','1|småfågel'),
('blåhallon','1|hallon'),
('blåhet','1|blå'),
('blåhjon','1|skalbagge'),
('blåholts','1|kärnved'),
('blåis','1|is'),
('blåjacka','1|örlogsmatros'),
('blåjord','1|vivianit'),
('blåklint','1|blomma'),
('blåklocka','1|blomma'),
('blåklädd','1|klä'),
('blåkläder','1|arbetskläder'),
('blåkopia','1|kopia'),
('blåkopiera','1|blåkopiering'),
('blåkopierande','1|blåkopiera'),
('blåkopierbar','1|blåkopiera'),
('blåkopierbarhet','1|blåkopierbar'),
('blåkopiering','1|blåkopia'),
('blåkråka','1|fågel'),
('Blåkulla','1|häxa'),
('blåkullafärd','1|Blåkulla'),
('blåkål','1|kål'),
('blåköra','1|köra'),
('blåkörande','1|blåköra'),
('blålera','1|lera'),
('blålila','1|lila'),
('blåljuga','1|ljuga'),
('blåljus','1|ljussignal'),
('blålusern','1|lusern'),
('blåmes','1|mes'),
('blåmusseron','1|svamp'),
('blåmussla','1|mussla'),
('blåmålad','1|måla'),
('blåmålning','1|måla'),
('blåmärke','1|fläck'),
('blåna','1|blå'),
('blånad','1|blåmärke'),
('blånande','1|blåna'),
('blåneka','1|neka'),
('blånekande','1|blåneka'),
('blånor','1|fiber'),
('blåpenna','1|penna'),
('blåprickig','1|prickig'),
('blårandig','1|randig'),
('blåregn','1|buske'),
('blårutig','1|rutig'),
('blåräv','1|fjällräv'),
('blåröd','1|röd'),
('blåsa','1|luft'),
('blåsa','2|rund'),
('blåsa','3|lura'),
('blåsa','4|blåsa'),
('blåsa','5|blåsa'),
('blåsande','1|blåsa'),
('blåsande','2|blåsa'),
('blåsande','3|blåsa'),
('blåsande','4|blåsa'),
('blåsare','1|blåsinstrument'),
('blåsbälg','1|pump'),
('blåsfoting','1|trips'),
('blåshals','1|urinblåsa'),
('blåshalskörtel','1|prostata'),
('blåshål','1|plats'),
('blåshål','2|hål'),
('blåshål','3|hål'),
('blåsig','1|vind'),
('blåsig','2|blåsa'),
('blåsinstrument','1|instrument'),
('blåsippa','1|sippa'),
('blåsjuka','1|sjukdom'),
('blåskatarr','1|inflammation'),
('blåskimrande','1|skimra'),
('blåslagen','1|slå'),
('blåslampa','1|tryckbrännare'),
('blåsljud','1|hjärtfel'),
('blåsmask','1|dynt'),
('blåsning','1|blåsa'),
('blåsning','2|blåst'),
('blåsning','3|blåsa'),
('blåsorkester','1|orkester'),
('blåspistol','1|pistol'),
('blåsprit','1|sprit'),
('blåsrör','1|vapen'),
('blåssten','1|sten'),
('blåst','1|blåsa'),
('blåst','2|dum'),
('blåsthet','1|blåst'),
('blåstrumpa','1|kvinnosakskvinna'),
('blåstång','1|tång'),
('blåställ','1|blåkläder'),
('blåsur','1|sur'),
('blåsurhet','1|blåsur'),
('blåsvart','1|svart'),
('blåsväder','1|blåsa'),
('blåsyra','1|gift'),
('blåsört','1|ört'),
('blåtira','1|blåmärke'),
('blåtonad','1|blå'),
('blåträ','1|virke'),
('blåtunga','1|sjukdom'),
('blåtåtel','1|gräs'),
('blåval','1|val'),
('blåvarm','1|varm'),
('blåved','1|blåträ'),
('blåvinge','1|fjäril'),
('blåvinge','2|scout'),
('blåviolett','1|violett'),
('blåvit','1|vit'),
('blåvitling','1|vitlinglyra'),
('blåvärme','1|metallurgi'),
('blåögd','1|öga'),
('blåögd','2|naiv'),
('blåögdhet','1|blåögd'),
('blåögdhet','2|blåögd'),
('blä','1|fy'),
('bläck','1|vätska'),
('bläcka','1|bläck'),
('bläcka','2|märka'),
('bläcka','3|bläcka'),
('bläcka','4|supa'),
('bläckande','1|bläcka'),
('bläckande','2|bläcka'),
('bläckblåsa','1|blåsa'),
('bläckfisk','1|blötdjur'),
('bläckfläck','1|fläck'),
('bläckhorn','1|förvara'),
('bläckig','1|bläck'),
('bläckkörtel','1|körtel'),
('bläckpenna','1|penna'),
('bläckplump','1|fläck'),
('bläckpulver','1|avlägsna'),
('bläcksuddare','1|författare'),
('bläcksvamp','1|svamp'),
('bläcksvart','1|svart'),
('bläcksäck','1|bläckblåsa'),
('bläckteckning','1|teckning'),
('bläda','1|avlägsna'),
('blädande','1|bläda'),
('blädderblock','1|block'),
('blädderbok','1|barnbok'),
('bläddra','1|blad'),
('bläddra','2|bubbla'),
('bläddrande','1|bläddra'),
('blädning','1|bläda'),
('blända','1|blind'),
('blända','2|avskärma'),
('blända','3|förvilla'),
('bländande','1|blända'),
('bländande','2|blända'),
('bländande','3|blända'),
('bländande','4|blända'),
('bländare','1|objektiv'),
('blände','1|mineral'),
('bländfri','1|blända'),
('bländning','1|skyddsmur'),
('bländrisk','1|risk'),
('bländskiva','1|blända'),
('bländskydd','1|blända'),
('bländverk','1|förleda'),
('bländvit','1|vit'),
('bläng','1|blänga'),
('blänga','1|stirra'),
('blängande','1|blänga'),
('blängning','1|blänga'),
('blänk','1|blänka'),
('blänka','1|lysa'),
('blänkande','1|blänka'),
('blänkare','1|artikel'),
('blänke','1|drag'),
('blänkfyr','1|blinkfyr'),
('blänkning','1|blänka'),
('bläs','1|fläck'),
('bläsand','1|and'),
('bläsbock','1|antilop'),
('bläsgås','1|gås'),
('blästa','1|ugn'),
('blästande','1|blästa'),
('bläster','1|blästra'),
('bläster','2|blästra'),
('blästerrör','1|bläster'),
('blästerugn','1|ugn'),
('blästra','1|slipa'),
('blästra','2|masugn'),
('blästrande','1|blästra'),
('blästrande','2|blästra'),
('blöda','1|blod'),
('blödande','1|blöda'),
('blödare','1|blödarsjuka'),
('blödarsjuka','1|sjukdom'),
('blödig','1|vek'),
('blödighet','1|blödig'),
('blödning','1|blöda'),
('blöja','1|binda'),
('blöjbyte','1|byte'),
('blöjålder','1|ålder'),
('blöt','1|våt'),
('blöta','1|blöt'),
('blöta','2|slask'),
('blötande','1|blöta'),
('blötdjur','1|djur'),
('blötfoder','1|foder'),
('blöthet','1|blöt'),
('blötlägga','1|blöta'),
('blötläggande','1|blötlägga'),
('blötläggning','1|blöta'),
('blötläggningsmedel','1|blötlägga'),
('blötna','1|blöt'),
('blötnande','1|blötna'),
('blötning','1|blöta'),
('blötröta','1|sjukdom'),
('blötsnö','1|snö'),
('blötsvart','1|svart'),
('BMW','1|bilmärke'),
('B-människa','1|A-människa'),
('BNP-tillväxt','1|tillväxt'),
('bo','1|leva'),
('bo','2|bo'),
('boa','1|boaorm'),
('boa','2|krage'),
('boaorm','1|orm'),
('board','1|träplatta'),
('boardingcard','1|boardingkort'),
('boardingkort','1|flyg'),
('boasera','1|panel'),
('boaserande','1|boasera'),
('boaserbar','1|boasera'),
('boaserbarhet','1|boaserbar'),
('boasering','1|boasera'),
('bob','1|kälke'),
('bob','1|kälke'),
('bobba','1|finne'),
('bobba','2|frisyr'),
('bobbande','1|bobba'),
('bobin','1|garn'),
('boboll','1|bollspel'),
('boboll','2|boll'),
('bobsleigh','1|bob'),
('Boccaccio','1|författare'),
('boccia','1|spel'),
('bock','1|get'),
('bock','2|bära'),
('bock','3|fel'),
('bock','4|gymnastikredskap'),
('bock','5|sågbock'),
('bock','6|liderlig'),
('bocka','1|buga'),
('bocka','2|böja'),
('bockande','1|bocka'),
('bockande','2|bocka'),
('bockbent','1|ben'),
('bockbenthet','1|bockbent'),
('bockblad','1|växt'),
('bockbro','1|bro'),
('bockbränning','1|bränna'),
('bockfot','1|fot'),
('bockfot','2|djävul'),
('bockhorn','1|blåsinstrument'),
('bockhorn','2|djävul'),
('bockhornsklöver','1|kryddväxt'),
('bockhornsklöverfrö','1|frö'),
('bockning','1|bocka'),
('bockprov','1|prov'),
('bockskägg','1|skägg'),
('bocksprång','1|språng'),
('Bockstensmannen','1|mosslik'),
('bocktörne','1|buske'),
('bockverktyg','1|verktyg'),
('bockvinkel','1|vinkel'),
('bocköl','1|öl'),
('bod','1|handelsbod'),
('bod','2|hus'),
('Bodagrottorna','1|grotta'),
('Bodarna','1|Iggesund'),
('bodbetjänt','1|butiksbiträde'),
('bodega','1|restaurang'),
('bodelning','1|skilsmässa'),
('bodknodd','1|butiksbiträde'),
('bodlänga','1|länga'),
('bodmeri','1|lån'),
('bodräkt','1|stöld'),
('bodybuilding','1|muskelbyggare'),
('boende','1|bo'),
('boende','2|bosatt'),
('boendeform','1|boende'),
('boendekostnad','1|kostnad'),
('boendesegregering','1|segregering'),
('boer','1|sydafrikan'),
('boett','1|fodral'),
('boettlås','1|lås'),
('bofast','1|fast'),
('bofasthet','1|bofast'),
('bofink','1|småfågel'),
('bofinksdrill','1|drill'),
('bofinkssång','1|sång'),
('Bofors','1|ort'),
('bofällig','1|fallfärdig'),
('bofällighet','1|bofällig'),
('bog','1|skuldra'),
('bog','2|för'),
('bog','3|riktning'),
('bogankare','1|ankare'),
('bogblad','1|bog'),
('bogbruten','1|boghalt'),
('boggi','1|underrede'),
('boggitryck','1|tryck'),
('boghalt','1|halt'),
('boghöjd','1|höjd'),
('Bogota','1|huvudstad'),
('Bogota','1|huvudstad'),
('bogpropeller','1|propeller'),
('bogsera','1|dra'),
('bogserande','1|bogsera'),
('bogserare','1|bogserbåt'),
('bogserbar','1|bogsera'),
('bogserbarhet','1|bogserbar'),
('bogserbåt','1|båt'),
('bogsergalge','1|bogsera'),
('bogsering','1|bogsera'),
('bogserlina','1|lina'),
('bogsersläp','1|släp'),
('bogsertross','1|tross'),
('bogspröt','1|bog'),
('bogvisir','1|lucka'),
('bogvåg','1|svallvåg'),
('bogvågsknall','1|knall'),
('bohag','1|föremål'),
('bohagsförteckning','1|förteckning'),
('bohem','1|avvika'),
('bohemartad','1|bohem'),
('Bohème','1|opera'),
('bohemisk','1|bohem'),
('bohemliv','1|bohem'),
('bohuseka','1|eka'),
('Bohuslän','1|landskap'),
('bohuslänning','1|Bohuslän'),
('bohuslänning','1|Bohuslän'),
('bohuslänsk','1|Bohuslän'),
('bohuslänska','1|bohuslänning'),
('bohuslänska','2|dialekt'),
('Boise','1|huvudstad'),
('boj','1|flyta'),
('boj','2|livboj'),
('boj','3|ylletyg'),
('boja','1|kedja'),
('bojar','1|adelsman'),
('bojkott','1|blockad'),
('bojkotta','1|bojkott'),
('bojkottande','1|bojkotta'),
('bojkottning','1|bojkotta'),
('bok','1|läsa'),
('bok','2|träd'),
('boka','1|beställa'),
('boka','2|sönderdela'),
('bokande','1|boka'),
('bokande','2|boka'),
('bokanmälan','1|anmälan'),
('bokauktion','1|auktion'),
('bokband','1|band'),
('bokbindare','1|tillverka'),
('bokbinderi','1|bokbindare'),
('bokbindning','1|bokbindare'),
('bokbränning','1|bränna'),
('bokbuss','1|buss'),
('bokcirkel','1|cirkel'),
('bokdamm','1|damm'),
('boke','1|virke'),
('boken','1|övermogen'),
('bokenhet','1|boken'),
('bokfilm','1|bilderbok'),
('bokflod','1|bok'),
('bokform','1|bok'),
('bokformat','1|format'),
('bokföra','1|notera'),
('bokförande','1|bokföra'),
('bokförare','1|bokföra'),
('bokföring','1|ekonomi'),
('bokföringsbrott','1|brott'),
('bokföringsmässig','1|bokföring'),
('bokföringsmässighet','1|bokföringsmässig'),
('bokföringsplikt','1|plikt'),
('bokföringsskyldig','1|bokföringsplikt'),
('bokföringsskyldighet','1|bokföringsskyldig'),
('bokföringsår','1|år'),
('bokförlag','1|publicera'),
('bokförläggare','1|bokförlag'),
('bokförråd','1|förråd'),
('bokhandel','1|handel'),
('bokhandelsdisk','1|disk'),
('bokhandlare','1|bokhandel'),
('bokhantverk','1|hantverk'),
('bokhylla','1|hylla'),
('bokhållare','1|bokföring'),
('bokhålleri','1|bokhållare'),
('bokkasse','1|kasse'),
('bokkatalog','1|katalog'),
('bokklubb','1|klubb'),
('bokkännare','1|kännare'),
('boklig','1|teoretisk'),
('boklighet','1|boklig'),
('boklåda','1|bokhandel'),
('boklån','1|lån'),
('boklån','1|lån'),
('boklärd','1|boklig'),
('boklärdhet','1|boklärd'),
('boklärdom','1|lärdom'),
('bokläsande','1|läsa'),
('bokläsande','2|läsa'),
('bokmagasin','1|magasin'),
('bokmakulatur','1|makulatur'),
('bokmal','1|läsa'),
('bokmarknad','1|marknad'),
('bokmarknad','2|marknad'),
('bokmål','1|norska'),
('bokmärke','1|markera'),
('bokmässa','1|mässa'),
('bokna','1|boken'),
('boknande','1|bokna'),
('bokning','1|boka'),
('bokollon','1|ollon'),
('bokomslag','1|omslag'),
('bokpärm','1|pärm'),
('bokrad','1|rad'),
('bokrea','1|rea'),
('bokrulle','1|bok'),
('bokrygg','1|band'),
('boksamlare','1|samlare'),
('boksamling','1|samling'),
('boksida','1|sida'),
('bokskatt','1|skatt'),
('bokskog','1|skog'),
('bokskrivande','1|skriva'),
('bokskrivande','2|skriva'),
('bokskåp','1|bokhylla'),
('bokslukare','1|läsa'),
('bokslut','1|resultat'),
('bokspråk','1|skriftspråk'),
('bokstav','1|tecken'),
('bokstavera','1|bokstav'),
('bokstaverande','1|bokstavera'),
('bokstaverbar','1|bokstavera'),
('bokstaverbarhet','1|bokstaverbar'),
('bokstavering','1|bokstavera'),
('bokstavlig','1|bokstav'),
('bokstavligen','1|bokstavlig'),
('bokstavlighet','1|bokstavlig'),
('bokstavsbarn','1|barn'),
('bokstavsbeteckning','1|bokstav'),
('bokstavsdiagnos','1|diagnos'),
('bokstavsdyrkan','1|bokstavstro'),
('bokstavsföljd','1|bokstavsordning'),
('bokstavsinspiration','1|inspiration'),
('bokstavsmystik','1|mystik'),
('bokstavsordning','1|ordning'),
('bokstavsrim','1|allitteration'),
('bokstavssallad','1|obegriplig'),
('bokstavsskrift','1|bokstav'),
('bokstavsstans','1|stans'),
('bokstavstecken','1|bokstav'),
('bokstavstro','1|tro'),
('bokstavstrogen','1|översättning'),
('bokstavstrogenhet','1|bokstavstrogen'),
('bokstavsträl','1|formell'),
('bokstavsvuxen','1|vuxen'),
('bokstipendium','1|stipendium'),
('bokställ','1|ställ'),
('bokstöd','1|stöd'),
('boksynt','1|beläst'),
('boksynthet','1|boksynt'),
('boktitel','1|titel'),
('boktorn','1|bokmagasin'),
('boktrave','1|trave'),
('boktryck','1|trycka'),
('boktryckare','1|boktryck'),
('boktryckarkonsten','1|boktryck'),
('boktryckeri','1|boktryck'),
('boktrycksstil','1|stil'),
('bokuppslag','1|uppslag'),
('bokval','1|val'),
('bokverk','1|bok'),
('bokversion','1|version'),
('bokvurm','1|vurm'),
('bokvän','1|bokälskare'),
('bokälskare','1|älska'),
('bol','1|bo'),
('bola','1|samlag'),
('bolag','1|företag'),
('bolagisera','1|bolag'),
('bolagiserande','1|bolagisera'),
('bolagiserbar','1|bolagisera'),
('bolagisering','1|bolagisera'),
('bolagsman','1|bolag'),
('bolagsordning','1|regel'),
('bolagsskog','1|skog'),
('bolagsstyrelse','1|styrelse'),
('bolagsstämma','1|stämma'),
('bolagsägare','1|ägare'),
('bolande','1|bola'),
('bolare','1|bola'),
('boleri','1|bola'),
('bolero','1|dans'),
('bolid','1|meteor'),
('bolin','1|lina'),
('Bolivia','1|land'),
('bolivian','1|Bolivia'),
('boliviansk','1|Bolivia'),
('bolivianska','1|bolivian'),
('boll','1|rund'),
('bolla','1|boll'),
('bollande','1|bolla'),
('bollbehandling','1|bollspel'),
('Bolle','1|luffare'),
('bollhav','1|lekplats'),
('bollhus','1|hus'),
('bollkalle','1|bollpojke'),
('bollkastning','1|kasta'),
('bollning','1|bolla'),
('bollplan','1|plan'),
('bollplank','1|bollspel'),
('bollplank','2|idé'),
('bollpojke','1|hämta'),
('bollsinne','1|talang'),
('bollspel','1|spel'),
('bollspelare','1|bollspel'),
('bollträ','1|slå'),
('Bollywood','1|film'),
('bolma','1|ryka'),
('bolmande','1|bolma'),
('bolmört','1|ört'),
('bolmörtsgift','1|gift'),
('bolmörtsskivling','1|svamp'),
('Bologna','1|stad'),
('bolsjevik','1|kommunist'),
('bolsjevikisk','1|bolsjevik'),
('bolsjevism','1|bolsjevik'),
('bolsjevistisk','1|bolsjevik'),
('bolster','1|täcke'),
('bolsterstock','1|bottenbjälke'),
('bolstervagn','1|vagn'),
('bolstervar','1|överdrag'),
('bolån','1|bostadslån'),
('bolån','1|bostadslån'),
('bolånekris','1|kris'),
('bolånekund','1|bankkund'),
('bolåneränta','1|ränta'),
('bom','1|stång'),
('bom','2|miss'),
('bomaterial','1|material'),
('bomb','1|spränga'),
('bomba','1|bomb'),
('bombad','1|dum'),
('bombande','1|bomba'),
('bombanfall','1|anfall'),
('bombardemang','1|bombardera'),
('bombardera','1|bomba'),
('bombarderande','1|bombardera'),
('bombarderbar','1|bombardera'),
('bombarderbarhet','1|bombarderbar'),
('bombardering','1|bombardera'),
('bombare','1|bombplan'),
('bombare','2|bombdåd'),
('bombasm','1|bombastisk'),
('bombastisk','1|svulstig'),
('bombattack','1|attack'),
('bombattentat','1|attentat'),
('bombdåd','1|illdåd'),
('bomber','1|kvinnobröst'),
('bombering','1|välvning'),
('bombfast','1|bombsäker'),
('bombfasthet','1|bombfast'),
('bombflyg','1|bombplan'),
('bombfri','1|bomb'),
('bombfällning','1|bomba'),
('bombhot','1|hot'),
('bombkrater','1|krater'),
('bombkrig','1|krig'),
('bomblarm','1|larm'),
('bombman','1|bombdåd'),
('bombmatta','1|bombanfall'),
('bombnedslag','1|skönhet'),
('bombning','1|bomba'),
('bomboffer','1|offer'),
('bombplan','1|flygplan'),
('bombräd','1|bombanfall'),
('bombräd','1|bombanfall'),
('bombsikte','1|sikte'),
('bombskydd','1|skydd'),
('bombskyddssektion','1|sektion'),
('bombsplitter','1|splitter'),
('bombsäker','1|säker'),
('bombsäkerhet','1|bombsäker'),
('bombtillverkning','1|tillverkning'),
('bomcylinder','1|grävmaskin'),
('bomma','1|bom'),
('bomma','2|låna'),
('bommande','1|bomma'),
('bommande','2|bomma'),
('bomolja','1|olivolja'),
('bomsadel','1|gymnastikredskap'),
('bomsegel','1|segel'),
('bomskott','1|skott'),
('bomull','1|växt'),
('bomullsbal','1|bal'),
('bomullsband','1|band'),
('bomullsbuske','1|bomull'),
('bomullsflanell','1|bomullstyg'),
('bomullsfrö','1|frö'),
('bomullsfrökaka','1|bomullsfröolja'),
('bomullsfröolja','1|olja'),
('bomullsgarn','1|garn'),
('bomullsklänning','1|klänning'),
('bomullskrut','1|krut'),
('bomullspinne','1|pinne'),
('bomullsplantage','1|plantage'),
('bomullsplockare','1|plocka'),
('bomullsservett','1|servett'),
('bomullsskjorta','1|skjorta'),
('bomullsspinneri','1|spinneri'),
('bomullsstrumpa','1|strumpa'),
('bomullstops','1|bomullspinne'),
('bomullstrassel','1|trasa'),
('bomullstrikå','1|bomullstyg'),
('bomullstråd','1|bomull'),
('bomullstuss','1|tuss'),
('bomullstyg','1|tyg'),
('bomullsväv','1|väv'),
('bomullsvävnad','1|bomullstyg'),
('bomullsväxt','1|bomullsbuske'),
('bomärke','1|märke'),
('bona','1|vaxa'),
('bonad','1|vävnad'),
('bonande','1|bona'),
('bonbonjär','1|konfektskål'),
('bondage','1|sex'),
('bondaktig','1|bondlurk'),
('bondaktighet','1|bondaktig'),
('bondbrud','1|brud'),
('Bondbrud','1|brud'),
('bondbrud','2|brud'),
('bondböna','1|böna'),
('bonddryg','1|dumdryg'),
('bonddryghet','1|bonddryg'),
('bonddräng','1|dräng'),
('bonde','1|bruka'),
('bonde','2|schackpjäs'),
('bondearmé','1|armé'),
('bondebefolkning','1|befolkning'),
('bondefred','1|fred'),
('Bondeförbundet','1|Centerpartiet'),
('bondegeneration','1|generation'),
('bondehemman','1|lantegendom'),
('bondehär','1|bondearmé'),
('bondekultur','1|kultur'),
('bondenostalgi','1|nostalgi'),
('bondenostalgisk','1|bondenostalgi'),
('bondepraktika','1|råd'),
('bondeprotest','1|protest'),
('bondesamhälle','1|samhälle'),
('bondesjäl','1|själ'),
('bondeskog','1|skog'),
('bondesläkt','1|släkt'),
('bondestånd','1|stånd'),
('bondetåg','1|tåg'),
('bondeuppbåd','1|uppbåd'),
('bondeuppror','1|uppror'),
('bondfamilj','1|familj'),
('Bondfilm','1|agentfilm'),
('bondflicka','1|flicka'),
('bondfolk','1|bonde'),
('bondfångare','1|bedragare'),
('bondförnuft','1|förnuft'),
('bondförstånd','1|bondförnuft'),
('bondförsök','1|försök'),
('bondgumma','1|gumma'),
('bondgård','1|gård'),
('bondhustru','1|hustru'),
('bondkalas','1|kalas'),
('bondkatt','1|katt'),
('bondkomik','1|komik'),
('bondkomiker','1|bondkomik'),
('bondland','1|landsbygd'),
('bondlurk','1|lantis'),
('bondmora','1|bondhustru'),
('bondneka','1|neka'),
('bondnekande','1|bondneka'),
('bondpermis','1|bondpermission'),
('bondpermission','1|permission'),
('bondpolska','1|polska'),
('bondsk','1|bonde'),
('bondska','1|mål'),
('bondskhet','1|bondsk'),
('bondslug','1|slug'),
('bondslughet','1|bondslug'),
('bondspelman','1|spelman'),
('bondstuga','1|stuga'),
('bondtolva','1|kortspel'),
('bondtur','1|tur'),
('bondtölp','1|bondlurk'),
('bondvischan','1|landsbygd'),
('bondånger','1|ånger'),
('bong','1|kontrollmärke'),
('bong','2|beställning'),
('bonga','1|bong'),
('bongande','1|bonga'),
('bongotrumma','1|puka'),
('boning','1|bo'),
('boningshus','1|hus'),
('boningsort','1|ort'),
('boningsplats','1|plats'),
('boningsrum','1|rum'),
('bonitera','1|värdera'),
('boniterande','1|bonitera'),
('boniterbar','1|bonitera'),
('boniterbarhet','1|boniterbar'),
('bonitering','1|bonitera'),
('bonitet','1|avkastning'),
('bonjour','1|rock'),
('bonmot','1|formulering'),
('Bonn','1|huvudstad'),
('bonnett','1|damhatt'),
('Bonnierkoncernen','1|koncern'),
('Bonniers','1|bokförlag'),
('bonnig','1|lantis'),
('bonnläpp','1|lantis'),
('bonnläpp','1|lantis'),
('bonobo','1|dvärgschimpans'),
('bonus','1|rabatt'),
('bonus','2|belöning'),
('bonus','3|löneförmån'),
('bonusbarn','1|styvbarn'),
('bonusklass','1|bonus'),
('bonusregel','1|regel'),
('bonussystem','1|bonus'),
('bonvax','1|vax'),
('bookmaker','1|vad'),
('boom','1|uppsving'),
('booma','1|boom'),
('boomande','1|booma'),
('boomår','1|år'),
('boosta','1|mer'),
('boostande','1|boosta'),
('boostning','1|boosta'),
('boota','1|dator'),
('boots','1|stövel'),
('boparasit','1|parasit'),
('boplats','1|plats'),
('boplatsgrävning','1|utgrävning'),
('bopris','1|bostadspris'),
('boprisbubbla','1|bubbla'),
('bor','1|grundämne'),
('bor','1|grundämne'),
('borax','1|tvättmedel'),
('Borba','1|tidning'),
('bord','1|möbel'),
('bord','2|sida'),
('bord','3|kortspel'),
('borda','1|ombord'),
('bordande','1|borda'),
('borddans','1|spiritism'),
('bordduk','1|duk'),
('Bordeaux','1|stad'),
('bordeaux','1|vin'),
('bordeauxvin','1|bordeaux'),
('bordeauxvätska','1|växtskyddsmedel'),
('bordell','1|prostitution'),
('bordellverksamhet','1|bordell'),
('bordellvärd','1|värd'),
('bordgång','1|bordplanka'),
('bordhyvel','1|hyvel'),
('bordlägga','1|skjuta_upp'),
('bordlägga','2|bord'),
('bordläggande','1|bordlägga'),
('bordläggande','2|bordlägga'),
('bordläggning','1|bordlägga'),
('bordläggning','2|bord'),
('bordläggningsplenum','1|plenum'),
('bordlöpare','1|bordduk'),
('bordning','1|borda'),
('bordplanka','1|planka'),
('bordsben','1|bära'),
('bordsbeställning','1|restaurang'),
('bordsbön','1|bön'),
('bordsdam','1|sällskap'),
('bordsdryck','1|dryck'),
('bordsfilt','1|skydd'),
('bordsgranne','1|bredvid'),
('bordsgäst','1|matgäst'),
('bordskamrat','1|bredvid'),
('bordskant','1|kant'),
('bordskavaljer','1|sällskap'),
('bordskick','1|bete_sig'),
('bordskick','1|bete_sig'),
('bordskniv','1|kniv'),
('bordskrydda','1|krydda'),
('bordslampa','1|lampa'),
('bordslinne','1|linne'),
('bordsmargarin','1|margarin'),
('bordssalt','1|salt'),
('bordssamtal','1|samtal'),
('bordssamtal','1|samtal'),
('bordsservis','1|servis'),
('bordsservis','1|servis'),
('bordssilver','1|bestick'),
('bordssilver','1|bestick'),
('bordsskiva','1|skiva'),
('bordsskiva','1|skiva'),
('bordsspegel','1|spegel'),
('bordsstudsare','1|pendyl'),
('bordsstudsare','1|pendyl'),
('bordsställ','1|ställ'),
('bordssällskap','1|sällskap'),
('bordsuppsats','1|prydnad'),
('bordsvatten','1|mineralvatten'),
('bordsvin','1|vin'),
('bordsvisa','1|visa'),
('bordsvisa','1|visa'),
('bordtennis','1|sport'),
('bordtennisbord','1|bord'),
('bordtennisracket','1|racket'),
('bordtennisracket','1|racket'),
('bordvarts','1|bord'),
('Bore','1|kung'),
('boreal','1|nordlig'),
('boren','1|medfödd'),
('borg','1|fästning'),
('borga','1|garantera'),
('borgande','1|borga'),
('borgaras','1|as'),
('borgarbeväpning','1|borgargarde'),
('borgarbrev','1|dokument'),
('borgardöme','1|makt'),
('borgare','1|stånd'),
('borgarfamilj','1|familj'),
('borgargarde','1|milis'),
('borgarhus','1|hus'),
('borgarklass','1|klass'),
('borgarpress','1|press'),
('borgarråd','1|kommunpolitiker'),
('borgarskola','1|skola'),
('borgarsläkt','1|släkt'),
('borgarstånd','1|borgare'),
('borgen','1|säkerhet'),
('borgensförbindelse','1|borgen'),
('borgenslån','1|lån'),
('borgenslån','1|lån'),
('borgensman','1|borgen'),
('borgenssumma','1|penningsumma'),
('borgensåtagande','1|åtagande'),
('borgenär','1|fordringsägare'),
('borgenärsed','1|ed'),
('borgerlig','1|politik'),
('borgerlig','2|religiös'),
('borgerlighet','1|borgerlig'),
('borgerlighet','2|borgerlig'),
('borgerskap','1|borgare'),
('borgfred','1|fred'),
('borggård','1|gård'),
('borggårdstalet','1|tal'),
('borgis','1|tryck'),
('borgmästare','1|chef'),
('borgruin','1|ruin'),
('borgtorn','1|torn'),
('boricka','1|åsna'),
('borkarbid','1|bor'),
('Borlänge','1|stad'),
('Borneo','1|ö'),
('bornera','1|skum'),
('bornerad','1|dumdryg'),
('bornerande','1|bornera'),
('bornering','1|bornera'),
('bornyr','1|bornera'),
('borr','1|borra'),
('borr','2|borrstål'),
('borra','1|hål'),
('borrande','1|borra'),
('borrchuck','1|chuck'),
('borrdiameter','1|diameter'),
('borrelia','1|fästingvirus'),
('borreliavaccin','1|vaccin'),
('borrhammare','1|hammare'),
('borrhål','1|borra'),
('borrhålsvägg','1|vägg'),
('borrigg','1|rigg'),
('borrjigg','1|borrmaskin'),
('borrklinka','1|diameter'),
('borrkrona','1|borr'),
('borrkärna','1|kärna'),
('borrlängd','1|längd'),
('borrmaskin','1|borr'),
('borrmussla','1|mussla'),
('borrning','1|borra'),
('borrningsolycka','1|olycka'),
('borrplattform','1|plattform'),
('borrspindel','1|borr'),
('borrspån','1|spån'),
('borrstål','1|borr'),
('borrsväng','1|borr'),
('borrtorn','1|oljeborrning'),
('borrutrustning','1|borr'),
('borsjtj','1|soppa'),
('borst','1|hår'),
('borsta','1|rengöra'),
('borstande','1|borsta'),
('borstbindare','1|tillverka'),
('borstbinderi','1|borstbindare'),
('borste','1|borsta'),
('borstgarnityr','1|garnityr'),
('borstgräs','1|stagg'),
('borstig','1|borst'),
('borstighet','1|borstig'),
('borstlös','1|elmotor'),
('borstlöshet','1|borstlös'),
('borstmask','1|ringmask'),
('borstnate','1|vattenväxt'),
('borstnejlika','1|nejlika'),
('borstning','1|borsta'),
('borstsvans','1|insekt'),
('borstviskare','1|borste'),
('borsyra','1|antiseptisk'),
('bort','1|borta'),
('bort','2|borta'),
('borta','1|här'),
('borta','2|medveten'),
('borta','3|hemma'),
('bortadopterad','1|adoptera'),
('bortafiasko','1|fiasko'),
('bortaförlora','1|bortaförlust'),
('bortaförlust','1|förlust'),
('bortaförsäkring','1|försäkring'),
('bortalag','1|lag'),
('bortalagad','1|hemlagad'),
('bortamatch','1|match'),
('bortanför','1|bakom'),
('bortaplan','1|tävla'),
('bortarbetande','1|arbeta_bort'),
('bortarbetning','1|arbeta_bort'),
('bortarrendering','1|arrendera_bort'),
('bortaseger','1|seger'),
('bortasegra','1|bortavinna'),
('bortaspelare','1|spelare'),
('bortauktionering','1|auktionera_bort'),
('bortavinna','1|bortavinst'),
('bortavinst','1|bortaseger'),
('bortbjuden','1|besök'),
('bortbjudning','1|bortbjuden'),
('bortblandning','1|blanda_bort'),
('bortblåsning','1|blåsa_bort'),
('bortblåst','1|blåsa'),
('bortblåst','2|blåsa'),
('bortbyting','1|trollbarn'),
('bortdomnande','1|domna_bort'),
('bortdomning','1|domna_bort'),
('bortdrivande','1|driva_bort'),
('bortdrivande','2|driva_bort'),
('bortdrivning','1|driva_bort'),
('bortdrivning','2|driva_bort'),
('bortdunstning','1|dunsta_bort'),
('bortdöende','1|avta'),
('bortdömning','1|domslut'),
('bortefter','1|längs'),
('bortemot','1|mot'),
('bortemot','2|nästan'),
('borterst','1|bort'),
('bortfall','1|försvinna'),
('bortfalla','1|bortfall'),
('bortfalla','1|bortfall'),
('bortfallande','1|bortfalla'),
('bortflugen','1|flyga'),
('bortflyttning','1|flytta_bort'),
('bortflyttning','2|flytta_bort'),
('bortforslande','1|forsla_bort'),
('bortforsling','1|forsla_bort'),
('bortfärd','1|fara'),
('bortföra','1|avlägsna'),
('bortföra','1|avlägsna'),
('bortförande','1|bortföra'),
('bortförklara','1|svepskäl'),
('bortförklara','1|svepskäl'),
('bortförklarande','1|bortförklara'),
('bortförklaring','1|bortförklara'),
('bortförklaringsteologi','1|teologi'),
('bortgivande','1|ge_bort'),
('bortglömd','1|glömma'),
('bortglömdhet','1|bortglömd'),
('bortgå','1|försvinna'),
('bortgå','1|försvinna'),
('bortgående','1|bortgå'),
('bortgång','1|gå_bort'),
('bortgången','1|gå_bort'),
('bortgången','2|gå_bort'),
('bortifrån','1|från'),
('bortifrån','2|bortifrån'),
('bortigenom','1|genom'),
('bortkastad','1|nytta'),
('bortklippning','1|klippa'),
('bortkollring','1|kollra_bort'),
('bortkommen','1|osäker'),
('bortkommenhet','1|bortkommen'),
('bortkörd','1|köra'),
('bortlottning','1|lotta_bort'),
('bortlovande','1|lova_bort'),
('bortlåning','1|låna_bort'),
('bortläggning','1|lägga_bort'),
('bortläggning','2|lägga_bort'),
('bortmarsch','1|marschera'),
('bortmontera','1|montera'),
('bortmotande','1|mota_bort'),
('bortmotning','1|mota_bort'),
('bortnötning','1|nöta'),
('bortodling','1|mullhalt'),
('bortom','1|bakom'),
('bortom','2|bortom'),
('bortoperera','1|operera'),
('bortoperera','1|operera'),
('bortopererande','1|bortoperera'),
('bortovaro','1|frånvaro'),
('bortovaro','1|frånvaro'),
('bortplockning','1|plocka_bort'),
('bortplottrande','1|plottra_bort'),
('bortrakning','1|raka_bort'),
('bortrationalisera','1|bortrationalisering'),
('bortrationalisera','1|bortrationalisering'),
('bortrationaliserande','1|bortrationalisera'),
('bortrationalisering','1|rationalisera'),
('bortre','1|bort'),
('bortrensning','1|rensa_bort'),
('bortresa','1|resa_bort'),
('bortresonera','1|bortförklara'),
('bortresonerande','1|bortresonera'),
('bortresonerbar','1|bortresonera'),
('bortresonerbarhet','1|bortresonerbar'),
('bortresonering','1|bortresonera'),
('bortrest','1|resa'),
('bortresthet','1|bortrest'),
('bortrinna','1|rinna'),
('bortrinnande','1|bortrinna'),
('bortrivning','1|riva'),
('bortryckning','1|rycka_bort'),
('bortryckning','2|rycka_bort'),
('bortryckt','1|rycka'),
('borträknande','1|räkna_bort'),
('bortröjning','1|röja'),
('bortrövande','1|röva_bort'),
('bortschabblad','1|schabbla'),
('bortschackring','1|schackra_bort'),
('bortse','1|utom'),
('bortseende','1|bortse'),
('bortsida','1|sida'),
('bortskaffa','1|bort'),
('bortskaffande','1|bortskaffa'),
('bortskaffning','1|bortskaffa'),
('bortskjuten','1|skjuta'),
('bortskrapning','1|skrapa_bort'),
('bortskrivning','1|avskrivning'),
('bortskrämmande','1|skrämma_bort'),
('bortskrämning','1|skrämma_bort'),
('bortskämd','1|skämma_bort'),
('bortskämdhet','1|bortskämd'),
('bortskänka','1|skänka'),
('bortskänkande','1|bortskänka'),
('bortskänkning','1|bortskänka'),
('bortskärning','1|skära'),
('bortsköljning','1|skölja'),
('bortslumpa','1|sälja'),
('bortslumpa','1|sälja'),
('bortslumpande','1|bortslumpa'),
('bortslumpning','1|bortslumpa'),
('bortsluta','1|avsluta'),
('bortslutande','1|bortsluta'),
('bortspolning','1|spola_bort'),
('bortsprängning','1|spränga'),
('bortstötning','1|stöta'),
('bortsättning','1|schack'),
('borttagande','1|ta_bort'),
('borttagning','1|ta_bort'),
('borttappad','1|tappa'),
('borttappande','1|tappa_bort'),
('borttorkande','1|torka_bort'),
('borttorkande','2|torka_bort'),
('borttorkande','3|torka_bort'),
('borttränga','1|tränga'),
('bortträngande','1|undertrycka'),
('bortträngning','1|undertrycka'),
('borttvagning','1|tvagning'),
('borttvättning','1|tvätta_bort'),
('bortvikt','1|väga'),
('bortvräkande','1|vräka_bort'),
('bortväg','1|väg'),
('bortvältning','1|välta'),
('bortvältring','1|vältra_bort'),
('bortvänd','1|vända'),
('bortåt','1|mot'),
('bortåt','2|nästan'),
('bortända','1|ände'),
('bortända','1|ände'),
('bortödsling','1|ödsla_bort'),
('bortöver','1|bort'),
('bortöver','2|bortöver'),
('Borås','1|stad'),
('bosatt','1|bo'),
('bosch','1|skräp'),
('boskap','1|husdjur'),
('boskapsavel','1|avla'),
('boskapsdrift','1|boskapsuppfödning'),
('boskapsfoder','1|foder'),
('boskapshjord','1|hjord'),
('boskapsmarknad','1|marknad'),
('boskapspest','1|pest'),
('boskapsras','1|boskap'),
('boskapsskötande','1|boskapsskötsel'),
('boskapsskötare','1|boskapsskötsel'),
('boskapsskötsel','1|sköta'),
('boskapsstock','1|bestånd'),
('boskapsstängsel','1|stängsel'),
('boskapstjuv','1|tjuv'),
('boskapsuppfödning','1|boskap'),
('boskifte','1|bodelning'),
('boskillnad','1|skilsmässa'),
('bosniak','1|bosnier'),
('Bosnien','1|land'),
('bosnienkroatisk','1|kroatisk'),
('bosnienserbisk','1|serbisk'),
('bosnier','1|Bosnien'),
('bosnisk','1|Bosnien'),
('bosniska','1|bosnier'),
('boson','1|elementarpartikel'),
('boss','1|avfall'),
('boss','2|chef'),
('bossig','1|boss'),
('bossighet','1|bossig'),
('bossvälde','1|makt'),
('bostad','1|bo'),
('bostadsadress','1|adress'),
('bostadsband','1|tvång'),
('bostadsbestånd','1|bestånd'),
('bostadsbidrag','1|socialbidrag'),
('bostadsbolag','1|bolag'),
('bostadsbrist','1|brist'),
('bostadsbubbla','1|blåsa_upp'),
('bostadsbyggande','1|bygga'),
('bostadsexpert','1|expert'),
('bostadsförbättringslån','1|lån'),
('bostadsförbättringslån','1|lån'),
('bostadsföretag','1|företag'),
('bostadsförmedling','1|förmedla'),
('bostadshus','1|hus'),
('bostadsinspektion','1|inspektion'),
('bostadsklipp','1|klipp'),
('bostadskooperation','1|kooperation'),
('bostadskredit','1|bostadslån'),
('bostadskvarter','1|kvarter'),
('bostadskö','1|kö'),
('bostadsköp','1|köp'),
('bostadslån','1|banklån'),
('bostadslån','1|banklån'),
('bostadslägenhet','1|lägenhet'),
('bostadslänga','1|länga'),
('bostadslös','1|bostad'),
('bostadslöshet','1|bostadslös'),
('bostadsmarknad','1|marknad'),
('bostadsmiljö','1|miljö'),
('bostadsmässig','1|bostad'),
('bostadsnämnd','1|nämnd'),
('bostadsområde','1|område'),
('bostadspolitik','1|bostadspolitisk'),
('bostadspolitisk','1|politisk'),
('bostadspris','1|pris'),
('bostadsproduktion','1|bygga'),
('bostadsrätt','1|äga'),
('bostadsrättsförening','1|förening'),
('bostadsrättsinnehavare','1|innehavare'),
('bostadsrättspris','1|pris'),
('bostadssocial','1|social'),
('bostadssparande','1|spara'),
('bostadsstyrelse','1|ämbetsverk'),
('bostadssökande','1|sökande'),
('bostadstillägg','1|bostadsbidrag'),
('Boston','1|huvudstad'),
('boston','1|kortspel'),
('bostongurka','1|gurka'),
('bostonvals','1|vals'),
('boställe','1|bo'),
('bosättare','1|nybyggare'),
('bosättning','1|bosätta_sig'),
('bosättningsaffär','1|affär'),
('bosättningslån','1|lån'),
('bosättningslån','1|lån'),
('bosättningsort','1|ort'),
('bosättningsstopp','1|stopp'),
('bot','1|hjälp'),
('bot','2|böter'),
('bot','3|bättring'),
('bot','4|datorprogram'),
('bota','1|frisk'),
('botande','1|bota'),
('botanik','1|vetenskap'),
('botaniker','1|botanik'),
('botanikspade','1|botanistspade'),
('botanisera','1|växt'),
('botanisera','2|leta'),
('botaniserande','1|botanisera'),
('botaniserande','2|botanisera'),
('botanisering','1|botanisera'),
('botanisering','2|botanisera'),
('botanisk','1|växt'),
('botanist','1|botaniker'),
('botanistspade','1|spade'),
('botbar','1|bota'),
('botbarhet','1|botbar'),
('botdag','1|böndag'),
('botemedel','1|hjälpmedel'),
('botfärdig','1|bot'),
('botfärdighet','1|botfärdig'),
('botgörare','1|bot'),
('botgörartåg','1|tåg'),
('botgörelse','1|botgöring'),
('botgöring','1|bot'),
('botlig','1|botbar'),
('botlighet','1|botlig'),
('botox','1|skönhetsoperation'),
('botoxförlamning','1|förlamning'),
('Botswana','1|land'),
('botswanier','1|Botswana'),
('botswansk','1|Botswana'),
('botswanska','1|botswanier'),
('botten','1|nere'),
('botten','2|bottendålig'),
('bottenavlagring','1|avlagring'),
('bottenbjälke','1|bjälke'),
('bottendjur','1|djur'),
('bottendålig','1|dålig'),
('bottendålighet','1|bottendålig'),
('bottendöd','1|död'),
('bottenfast','1|fast'),
('bottenformation','1|formation'),
('bottenfrysa','1|frysa'),
('bottenfrysande','1|bottenfrysa'),
('bottenfällning','1|bottensats'),
('bottenfärg','1|färg'),
('bottengarn','1|fisknät'),
('Bottenhavet','1|Östersjön'),
('bottenhederlig','1|hederlig'),
('bottenhederlighet','1|bottenhederlig'),
('bottenis','1|is'),
('bottenkran','1|bottenventil'),
('bottenkurs','1|kurs'),
('bottenkvark','1|kvark'),
('bottenkänning','1|känna'),
('bottenlag','1|lag'),
('bottenlevande','1|botten'),
('bottenlån','1|bostadslån'),
('bottenlån','1|bostadslån'),
('bottenläge','1|läge'),
('bottenlös','1|botten'),
('bottenlöshet','1|bottenlös'),
('bottenmagnet','1|magnet'),
('bottenmorän','1|morän'),
('bottennapp','1|napp'),
('bottennapp','2|usel'),
('bottenplan','1|plan'),
('bottenplatta','1|platta'),
('bottenrekord','1|resultat'),
('bottenrev','1|segel'),
('bottenreva','1|bottenrev'),
('bottenrevande','1|bottenreva'),
('bottensats','1|fällning'),
('bottensediment','1|sediment'),
('bottenskikt','1|skikt'),
('bottenskola','1|grundskola'),
('bottenskrap','1|reserv'),
('bottenskrapa','1|skrapa'),
('bottenskrapa','2|bottenskrapa'),
('bottenskrapa','3|bottenskrap'),
('bottenskrapande','1|bottenskrapa'),
('bottenskrapande','2|bottenskrapa'),
('bottenskvätt','1|skvätt'),
('bottenskyla','1|täcka'),
('bottenslam','1|slam'),
('bottenstock','1|köl'),
('bottentryck','1|tryck'),
('bottenvatten','1|vatten'),
('bottenventil','1|ventil'),
('Bottenviken','1|Östersjön'),
('bottenvåning','1|våning'),
('bottenyta','1|yta'),
('bottin','1|galosch'),
('bottna','1|botten'),
('bottnande','1|bottna'),
('bottning','1|bottna'),
('bottnisk','1|Bottenviken'),
('botulin','1|toxin'),
('botulism','1|matförgiftning'),
('bouillabaisse','1|fisksoppa'),
('boule','1|spel'),
('boulevard','1|gata'),
('boulevard','1|gata'),
('boulevardpress','1|press'),
('bouppteckning','1|förteckning'),
('bouquet','1|arom'),
('bourbon','1|whisky'),
('bourgeoisie','1|borgarklass'),
('Bourges','1|stad'),
('bourgogne','1|vin'),
('bourgognevin','1|bourgogne'),
('boutique','1|butik'),
('boutredare','1|boutredning'),
('boutredning','1|arv'),
('boutredningsman','1|boutredning'),
('Bouvetön','1|Antarktis'),
('bouzouki','1|mandolin'),
('bov','1|brottsling'),
('bovaktig','1|bov'),
('bovaktighet','1|bovaktig'),
('bovete','1|växt'),
('boveteplätt','1|plätt'),
('bovfysionomi','1|fysionomi'),
('bowla','1|bowling'),
('bowlande','1|bowla'),
('bowlare','1|bowling'),
('bowling','1|spel'),
('bowlingbana','1|bana'),
('bowlinghall','1|lokal'),
('bowlingklot','1|klot'),
('bovstreck','1|bov'),
('box','1|låda'),
('box','2|ladugård'),
('box','3|boxning'),
('boxa','1|slå'),
('boxande','1|boxa'),
('boxare','1|boxning'),
('boxas','1|boxning'),
('boxboll','1|boll'),
('boxer','1|hundras'),
('boxershorts','1|shorts'),
('boxervalp','1|valp'),
('boxhandske','1|handske'),
('boxkalv','1|kalvskinn'),
('boxning','1|kampsport'),
('boxningslokal','1|lokal'),
('boxningsmatch','1|match'),
('boxningsring','1|arena'),
('boxningstränad','1|boxningsträning'),
('boxningsträning','1|träning'),
('boxnummer','1|nummer'),
('boyscout','1|scout'),
('boägg','1|ägg'),
('BP','1|oljebolag'),
('bra','1|PRIM'),
('bra','2|ganska'),
('bra','3|bra'),
('bra','4|frisk'),
('bra','5|mycket'),
('bracka','1|småborgerlig'),
('brackig','1|bracka'),
('brackighet','1|brackig'),
('brackvatten','1|bräckt'),
('brackvattenlevande','1|leva'),
('bragd','1|prestation'),
('bragdguld','1|guldmedalj'),
('bragdlopp','1|lopp'),
('bragdmässig','1|bragd'),
('Brage','1|gud'),
('bragelöfte','1|löfte'),
('brailleskrift','1|punktskrift'),
('brainstorming','1|idékläckning'),
('brak','1|braka'),
('braka','1|låta'),
('brakande','1|braka'),
('brakfest','1|fest'),
('brakfiasko','1|fiasko'),
('brakmiddag','1|middag'),
('brakskit','1|fis'),
('brakskiva','1|brakfest'),
('braksuccé','1|succé'),
('brakteat','1|smycke'),
('brakved','1|buske'),
('brakycefal','1|brakycefali'),
('brakycefali','1|kortskallig'),
('bralla','1|byxor'),
('brallis','1|flicka'),
('braman','1|kast'),
('bramanism','1|religion'),
('bramansk','1|bramanism'),
('bramin','1|braman'),
('bramsegel','1|rå'),
('bramstång','1|mast'),
('brand','1|brinna'),
('brandalarm','1|alarm'),
('brandalarm','1|alarm'),
('brandartikel','1|artikel'),
('brandattentat','1|attentat'),
('brandbefäl','1|befäl'),
('brandbil','1|bil'),
('brandbomb','1|bomb'),
('brandbotten','1|golv'),
('brandchef','1|chef'),
('branddike','1|förhindra'),
('branddörr','1|dörr'),
('brandfackla','1|uttalande'),
('brandfara','1|risk'),
('brandfarlig','1|brinna'),
('brandfarlighet','1|brandfarlig'),
('brandfri','1|brand'),
('brandförsvar','1|brandskydd'),
('brandförsäkra','1|brandförsäkring'),
('brandförsäkring','1|försäkring'),
('brandförsäkringsavtal','1|brandförsäkring'),
('brandförsäkringsbelopp','1|belopp'),
('brandförsäkringsbolag','1|försäkringsbolag'),
('brandförsäkringsvärde','1|brandförsäkringsbelopp'),
('brandgata','1|förhindra'),
('brandgavel','1|brandmur'),
('brandgranat','1|granat'),
('brandgrav','1|förhindra'),
('brandgul','1|orange'),
('brandhärd','1|eld'),
('brandhärdig','1|brandsäker'),
('brandhärdighet','1|brandhärdig'),
('brandhärja','1|förstöra'),
('brandhärjande','1|brandhärja'),
('brandingenjör','1|brandbefäl'),
('brandinspektion','1|inspektion'),
('brandinspektör','1|inspektör'),
('brandkapten','1|brandbefäl'),
('brandkatastrof','1|katastrof'),
('Brandklipparen','1|häst'),
('brandkår','1|släcka'),
('brandkårsfrivillig','1|frivillig'),
('brandkårsutryckning','1|utryckning'),
('brandkårsutryckning','2|insats'),
('brandlager','1|jordlager'),
('brandlukt','1|röklukt'),
('brandman','1|brandkår'),
('brandmansgrepp','1|bära'),
('brandmur','1|vägg'),
('brandoffer','1|offer'),
('brandorsak','1|orsak'),
('brandpost','1|vattenpost'),
('brandredskap','1|redskap'),
('brandrest','1|rest'),
('brandrök','1|rök'),
('brandrör','1|projektil'),
('brandschaktare','1|schaktmaskin'),
('brandsegel','1|rädda'),
('brandskada','1|skada'),
('brandskadad','1|skada'),
('brandskatt','1|skatt'),
('brandskatta','1|brandskatt'),
('brandskattande','1|brandskatta'),
('brandskattning','1|brandskatta'),
('brandskydd','1|skydd'),
('brandskyddslagstiftning','1|lagstiftning'),
('brandskåp','1|brandalarm'),
('brandslang','1|vattenslang'),
('brandsläckarattrapp','1|attrapp'),
('brandsläckare','1|redskap'),
('brandsoldat','1|brandman'),
('brandspruta','1|vattenspruta'),
('brandstation','1|station'),
('brandstege','1|stege'),
('brandstod','1|ersättning'),
('brandstodsbolag','1|brandförsäkringsbolag'),
('brandstyrka','1|brandkår'),
('brandsvamp','1|sotsvamp'),
('brandsyn','1|brandinspektion'),
('brandsäker','1|säker'),
('brandsäkerhet','1|brandsäker'),
('brandtal','1|tal'),
('brandtorn','1|upptäcka'),
('brandvakt','1|vakt'),
('brandvarnare','1|varna'),
('brandväsen','1|brandskydd'),
('brandy','1|konjak'),
('brandövning','1|övning'),
('bransch','1|näringsliv'),
('branschförening','1|förening'),
('branschledande','1|leda'),
('branschmässig','1|bransch'),
('branschorganisation','1|organisation'),
('branschråd','1|organ'),
('branschtidning','1|tidning'),
('branschvana','1|vana'),
('brant','1|slutta'),
('brant','2|sluttning'),
('branthet','1|brant'),
('brasa','1|eld'),
('Brasilia','1|huvudstad'),
('brasilianare','1|Brasilien'),
('brasilianare','1|Brasilien'),
('brasilianare','1|Brasilien'),
('brasiliansk','1|Brasilien'),
('brasilianska','1|brasilianare'),
('Brasilien','1|land'),
('braska','1|frysa'),
('braskande','1|uppseendeväckande'),
('braskande','2|braska'),
('brasklapp','1|förbehåll'),
('brass','1|mässingblåsinstrument'),
('brass','2|hasch'),
('brassa','1|kraft'),
('brassande','1|brassa'),
('brasse','1|brasilianare'),
('braständare','1|tända'),
('brasved','1|ved'),
('Bratislava','1|huvudstad'),
('brats','1|jet_set'),
('brats','1|jet_set'),
('brats','1|jet_set'),
('bravad','1|prestation'),
('bravera','1|framhäva'),
('braverande','1|bravera'),
('bravissimo','1|bravo'),
('bravo','1|bra'),
('bravorop','1|bravo'),
('bravur','1|skicklighet'),
('bravuraria','1|aria'),
('bravurnummer','1|specialitet'),
('bravurroll','1|roll'),
('braxen','1|fisk'),
('braxengräs','1|vattenväxt'),
('braxenmygga','1|insekt'),
('braxenpanka','1|braxen'),
('Brazzaville','1|huvudstad'),
('bre','1|platt'),
('break','1|vinna'),
('breakdance','1|dans'),
('breccia','1|bergart'),
('bred','1|stor'),
('bred','2|omfattande'),
('bredande','1|bre'),
('bredande','1|bre'),
('bredaxlad','1|axel'),
('bredband','1|internet'),
('bredbandsföretag','1|företag'),
('bredbar','1|bre'),
('bredbarhet','1|bredbar'),
('bredbent','1|stabil'),
('bredbenthet','1|bredbent'),
('bredbladig','1|blad'),
('bredbladighet','1|bredbladig'),
('bredbrättad','1|brätte'),
('bredbrättig','1|bredbrättad'),
('bredbrättighet','1|bredbrättig'),
('bredd','1|bred'),
('bredda','1|bred'),
('breddande','1|bredda'),
('breddgrad','1|latitud'),
('breddidrott','1|elitidrott'),
('breddmässig','1|bredd'),
('breddning','1|bredda'),
('bredhet','1|bred'),
('bredhet','2|bred'),
('bredkäftad','1|käft'),
('bredmun','1|bredmunnar'),
('bredmunnar','1|broskfiskar'),
('bredmynt','1|mun'),
('bredmynthet','1|bredmynt'),
('bredrandig','1|rand'),
('bredrandighet','1|bredrandig'),
('bredsida','1|långsida'),
('bredsida','2|kanonsalva'),
('bredsida','3|insida'),
('bredskyggig','1|bredbrättad'),
('bredskyggighet','1|bredskyggig'),
('bredspackel','1|spackel'),
('bredspektrumantiviral','1|antiviral'),
('bredspårig','1|spårvidd'),
('bredspårighet','1|bredspårig'),
('bredså','1|så'),
('bredsådd','1|bredså'),
('bredsående','1|bredså'),
('bredvid','1|vid'),
('bredvid','1|vid'),
('bredvidläsning','1|studier'),
('Brega','1|oljestad'),
('brems','1|hålla'),
('bremsa','1|brems'),
('bremsande','1|bremsa'),
('bremsning','1|bremsa'),
('bresilja','1|färgämne'),
('bretagnare','1|Bretagne'),
('bretagnare','1|Bretagne'),
('bretagnare','2|hästras'),
('bretagnare','2|hästras'),
('Bretagne','1|Frankrike'),
('breton','1|hundras'),
('bretonsk','1|Bretagne'),
('bretonsk','1|Bretagne'),
('bretonska','1|språk'),
('bretonska','1|språk'),
('bretonska','2|bretagnare'),
('bretonska','2|bretagnare'),
('brev','1|post'),
('brevbomb','1|bomb'),
('brevbärare','1|brev'),
('brevbäring','1|brevbärare'),
('brevcensur','1|censur'),
('brevdialog','1|dialog'),
('brevduva','1|duva'),
('brevenkät','1|enkät'),
('brevfack','1|fack'),
('brevfråga','1|fråga'),
('brevförsändelse','1|brev'),
('brevhemlighet','1|hemlighet'),
('brevhuvud','1|brev'),
('breviarium','1|andaktsbok'),
('brevinkast','1|brevlåda'),
('brevkort','1|postkort'),
('brevlapp','1|lapp'),
('brevledes','1|brev'),
('brevlåda','1|post'),
('brevlådeföretag','1|skatteflykt'),
('brevlådeliknande','1|brevlåda'),
('brevlådetömning','1|tömning'),
('brevpapper','1|papper'),
('brevporto','1|porto'),
('brevpress','1|skrivbord'),
('brevroman','1|roman'),
('brevsamling','1|samling'),
('brevskola','1|korrespondensundervisning'),
('brevskrivande','1|skriva'),
('brevskrivande','2|skriva'),
('brevskrivare','1|skriva'),
('brevskörd','1|brev'),
('brevstil','1|stil'),
('brevställ','1|ställ'),
('brevställare','1|handledning'),
('brevsvar','1|svar'),
('brevtelegram','1|telegram'),
('brevvåg','1|våg'),
('brevvädjan','1|vädjan'),
('brevvän','1|brevväxla'),
('brevväxla','1|skriva'),
('brevväxlande','1|brevväxla'),
('brevväxling','1|brevväxla'),
('brevöppnare','1|papperskniv'),
('bricka','1|bära'),
('bricka','2|skiva'),
('brickband','1|hänga'),
('brickbord','1|bord'),
('brickduk','1|duk'),
('bricklunch','1|lunch'),
('brickplockare','1|diskplockare'),
('brickunderlägg','1|underlägg'),
('brickvävd','1|väva'),
('brickvävning','1|brickvävd'),
('bridge','1|kortspel'),
('bridgebord','1|bord'),
('bridgejunta','1|junta'),
('Bridgeport','1|stad'),
('bridgespel','1|bridge'),
('bridong','1|bett'),
('bridreaktor','1|kärnreaktor'),
('briefa','1|informera'),
('briefande','1|briefa'),
('brigad','1|förband'),
('brigadchef','1|chef'),
('brigadgeneral','1|general'),
('brigadstab','1|stab'),
('brigadvis','1|brigad'),
('brigadvis','2|brigadvis'),
('brigadör','1|officer'),
('brigantin','1|segelfartyg'),
('brigg','1|segelfartyg'),
('briggsegel','1|segel'),
('brikett','1|stycke'),
('brikettera','1|brikett'),
('briketterande','1|brikettera'),
('briketterbar','1|brikettera'),
('briketterbarhet','1|briketterbar'),
('brikettering','1|brikettera'),
('brikettpress','1|brikett'),
('brikollstöt','1|biljard'),
('briljans','1|briljant'),
('briljant','1|diamant'),
('briljant','2|utmärkt'),
('briljanterad','1|briljant'),
('briljantglas','1|kristallglas'),
('briljantin','1|pomada'),
('briljantring','1|ring'),
('briljantsmyckad','1|briljant'),
('briljantsmycke','1|smycke'),
('briljera','1|utmärka_sig'),
('briljerande','1|briljera'),
('briljering','1|briljera'),
('brilliant','1|tryck'),
('brillor','1|glasögon'),
('bringa','1|föra'),
('bringa','2|bröstparti'),
('bringande','1|bringa'),
('brink','1|brant'),
('brinna','1|het'),
('brinna','2|engagerad'),
('brinnande','1|intensiv'),
('brinnande','2|brinna'),
('brinnande','3|brinna'),
('brinnsträcka','1|sträcka'),
('brio','1|livlighet'),
('bris','1|vind'),
('brisad','1|brisera'),
('brisans','1|sprängverkan'),
('brisansgranat','1|granat'),
('brisant','1|högexplosiv'),
('brisant','2|brisant'),
('brisera','1|explodera'),
('briserande','1|brisera'),
('briserbar','1|brisera'),
('briserbarhet','1|briserbar'),
('brisering','1|brisera'),
('brisken','1|halvsur'),
('briskenhet','1|brisken'),
('brissling','1|skarpsill'),
('brist','1|sakna'),
('brista','1|sönder'),
('brista','2|brist'),
('bristande','1|otillräcklig'),
('bristande','2|brista'),
('bristfällig','1|dålig'),
('bristfällighet','1|bristfällig'),
('bristläge','1|bristsituation'),
('bristning','1|brista'),
('bristningsgräns','1|gräns'),
('Bristol','1|stad'),
('Bristoltrakten','1|Bristol'),
('bristsituation','1|brist'),
('bristsjukdom','1|sjukdom'),
('bristvara','1|vara'),
('bristyrke','1|arbetskraft'),
('britanniametall','1|legering'),
('Britannien','1|England'),
('britannisk','1|brittisk'),
('brits','1|liggplats'),
('britt','1|brittisk'),
('brittisk','1|Storbritannien'),
('brittiska','1|britt'),
('brittmässa','1|Birgitta'),
('brittsommar','1|höst'),
('brittsommarväder','1|väder'),
('bro','1|väg'),
('broa','1|bro'),
('broande','1|broa'),
('broavgift','1|avgift'),
('brobana','1|bana'),
('brobelastning','1|belastning'),
('brobygge','1|bygge'),
('brobyggnad','1|bygga'),
('brobänk','1|skeppsbro'),
('broccoli','1|kål'),
('brochette','1|grillspett'),
('brock','1|lockbete'),
('brockfågel','1|fågel'),
('brodd','1|förhindra'),
('brodd','2|säd'),
('brodda','1|brodd'),
('broddande','1|brodda'),
('broder','1|munk'),
('brodera','1|sy'),
('brodera','2|utvikning'),
('broderande','1|brodera'),
('broderande','2|brodera'),
('broderbar','1|brodera'),
('broderbar','2|brodera'),
('broderbarhet','1|broderbar'),
('broderbarhet','2|broderbar'),
('broderbok','1|bok'),
('broderbåge','1|brodera'),
('broderfolk','1|folk'),
('brodergarn','1|garn'),
('broderi','1|brodera'),
('brodering','1|brodera'),
('broderland','1|land'),
('broderlig','1|vänskaplig'),
('broderlighet','1|broderlig'),
('brodermord','1|mord'),
('brodermördare','1|mördare'),
('brodernål','1|nål'),
('brodersax','1|sax'),
('brodersilke','1|brodergarn'),
('broderskap','1|solidaritet'),
('broderskärlek','1|kärlek'),
('brodersöm','1|brodera'),
('brodyr','1|tyg'),
('brodös','1|brodera'),
('brofäste','1|bära'),
('brohus','1|bro'),
('brohuvud','1|område'),
('broiler','1|kyckling'),
('brok','1|tåg'),
('brokad','1|siden'),
('brokanal','1|akvedukt'),
('brokar','1|brokista'),
('brokbladig','1|blad'),
('brokbladighet','1|brokbladig'),
('brokblommig','1|blomma'),
('brokblommighet','1|brokblommig'),
('brokig','1|färg'),
('brokighet','1|brokig'),
('brokista','1|bära'),
('brokspett','1|hackspett'),
('brolla','1|brorsa'),
('brolopp','1|lopp'),
('brolägga','1|bro'),
('broläggande','1|brolägga'),
('brom','1|grundämne'),
('brom','1|grundämne'),
('bromelia','1|krukväxt'),
('bromelia','1|krukväxt'),
('bromera','1|brom'),
('bromerande','1|bromera'),
('bromerbar','1|bromera'),
('bromerbarhet','1|bromerbar'),
('bromering','1|bromera'),
('bromförgiftning','1|förgiftning'),
('bromid','1|salt'),
('bromism','1|bromförgiftning'),
('bromläcka','1|läcka'),
('Bromma','1|flygplats'),
('Brommamamma','1|mamma'),
('broms','1|bromsa'),
('broms','2|insekt'),
('bromsa','1|stanna'),
('bromsande','1|bromsa'),
('bromsare','1|bromsa'),
('bromsback','1|bromskloss'),
('bromsband','1|broms'),
('bromsbelägg','1|bromskloss'),
('bromsblock','1|bromskloss'),
('bromscylinder','1|broms'),
('bromsfading','1|bromsverkan'),
('bromsfel','1|fel'),
('bromsgaller','1|elektronik'),
('bromshandtag','1|handtag'),
('bromsilverpapper','1|fotografering'),
('bromsklaff','1|broms'),
('bromskloss','1|kloss'),
('bromskloss','2|hindra'),
('bromskraft','1|friktion'),
('bromsljus','1|varningsljus'),
('bromsmedicin','1|medicin'),
('bromsning','1|bromsa'),
('bromsolja','1|bromsvätska'),
('bromspedal','1|pedal'),
('bromsraket','1|raket'),
('bromsservo','1|broms'),
('bromsskiva','1|skiva'),
('bromssko','1|bromsa'),
('bromsskärm','1|broms'),
('bromsspår','1|spår'),
('bromsstrålning','1|strålning'),
('bromssträcka','1|sträcka'),
('bromssystem','1|broms'),
('bromstrumma','1|broms'),
('bromsvagn','1|järnvägsvagn'),
('bromsverkan','1|verkan'),
('bromsvätska','1|broms'),
('bromtymolblått','1|indikator'),
('bromural','1|bromyl'),
('bromväte','1|väte'),
('bromvätesyra','1|syra'),
('bromyl','1|sömnmedel'),
('bronker','1|luftrör'),
('bronkialastma','1|astma'),
('bronkit','1|luftrörskatarr'),
('bronkografi','1|röntgen'),
('bronkoskop','1|instrument'),
('bronkoskopi','1|undersöka'),
('brons','1|legering'),
('brons','2|bronsmedalj'),
('brons','3|konstverk'),
('bronsborste','1|borste'),
('bronsera','1|brons'),
('bronserande','1|bronsera'),
('bronserbar','1|bronsera'),
('bronserbarhet','1|bronserbar'),
('bronsering','1|bronsera'),
('bronsfärg','1|färgämne'),
('bronsfärgad','1|brons'),
('bronsförgylla','1|bronsera'),
('bronsförgyllande','1|bronsförgylla'),
('bronsinfattad','1|infatta'),
('bronskanna','1|kanna'),
('bronsknapp','1|knapp'),
('bronskärl','1|kärl'),
('bronsmedalj','1|medalj'),
('bronsmedaljör','1|bronsmedalj'),
('bronsmynt','1|mynt'),
('bronsmärke','1|brons'),
('bronssmycke','1|smycke'),
('bronsspänne','1|spänne'),
('bronsstaty','1|staty'),
('bronsstatyett','1|statyett'),
('bronssvärd','1|svärd'),
('bronstavla','1|tavla'),
('bronsyxa','1|yxa'),
('bronsålder','1|period'),
('bronsåldersfynd','1|fynd'),
('bronsåldersgrav','1|grav'),
('bronsåldersmänniska','1|människa'),
('broolycka','1|olycka'),
('bropelare','1|pelare'),
('bropengar','1|broavgift'),
('bropengar','1|broavgift'),
('broplanka','1|planka'),
('bror','1|familj'),
('brorsa','1|bror'),
('brorsarv','1|arv'),
('brorsbarn','1|släkting'),
('brorsdotter','1|släkting'),
('brorskål','1|skål'),
('brorskål','1|skål'),
('brorslott','1|arvslott'),
('brorson','1|släkting'),
('brosch','1|smycke'),
('broschera','1|omslag'),
('broscherad','1|väva'),
('broscherande','1|broschera'),
('broscherbar','1|broschera'),
('broscherbarhet','1|broscherbar'),
('broschering','1|broschera'),
('broschyr','1|läsa'),
('brosk','1|kropp'),
('broskartad','1|brosk'),
('broskfisk','1|broskfiskar'),
('broskfiskar','1|fisk'),
('broskhinna','1|brosk'),
('broskskiva','1|brosk'),
('broskskivling','1|svamp'),
('brosksvamp','1|broskskivling'),
('broskverk','1|ornament'),
('broskvävnad','1|vävnad'),
('broslagning','1|bro'),
('brosme','1|lubb'),
('brospann','1|bro'),
('brossla','1|avverka'),
('brosslande','1|brossla'),
('brotsch','1|borr'),
('brotscha','1|brotsch'),
('brotschande','1|brotscha'),
('brott','1|bryta'),
('brott','2|bryta'),
('brott','3|avbryta'),
('brottare','1|brottning'),
('brottarlegendar','1|brottare'),
('brottas','1|kämpa'),
('brottas','2|grubbla'),
('brottmål','1|mål'),
('brottmål','1|mål'),
('brottmålsdomare','1|domare'),
('brottmålsdomstol','1|domstol'),
('brottmålsprocess','1|brottmål'),
('brottning','1|sport'),
('brottningsgrepp','1|grepp'),
('brottningskamp','1|brottning'),
('brottningsmatch','1|match'),
('brottningsring','1|arena'),
('brottsbalk','1|lagbalk'),
('brottsbekämpande','1|bekämpa'),
('brottsbekämpning','1|bekämpning'),
('brottsbevakning','1|bevakning'),
('brottsförebyggande','1|förebygga'),
('brottshistoria','1|historia'),
('brottsjournalistik','1|journalistik'),
('brottsjö','1|våg'),
('brottskonkurrens','1|brott'),
('brottslig','1|brott'),
('brottslighet','1|brottslig'),
('brottsling','1|brott'),
('brottsmisstanke','1|brottsmisstänkt'),
('brottsmisstänkt','1|misstänkt'),
('brottsoffer','1|offer'),
('brottsplats','1|plats'),
('brottsplatsexpert','1|expert'),
('brottsplatstekniker','1|tekniker'),
('brottsplatsundersökning','1|undersökning'),
('brottsprovokation','1|provokation'),
('brottsregister','1|register'),
('brottsrekvisit','1|villkor'),
('brottsrubricering','1|rubricering'),
('brottstillfälle','1|tillfälle'),
('brottstycke','1|fragment'),
('brottställe','1|ställe'),
('brottsutreda','1|brottsutredning'),
('brottsutredande','1|brottsutreda'),
('brottsutredning','1|utredning'),
('brottyta','1|yta'),
('brovalv','1|valv'),
('browning','1|pistol'),
('broöppning','1|öppning'),
('brr','1|usch'),
('bruckel','1|bråk'),
('bruckla','1|bruckel'),
('brucklande','1|bruckla'),
('brud','1|gifta_sig'),
('brud','2|kvinna'),
('brudand','1|and'),
('brudborste','1|tistel'),
('brudbröd','1|växt'),
('brudbukett','1|bukett'),
('brudfoto','1|bröllopsfoto'),
('brudfrämma','1|klä'),
('brudfölje','1|bröllop'),
('brudgum','1|gifta_sig'),
('brudgåva','1|bröllopsgåva'),
('brudklänning','1|klänning'),
('brudkrona','1|krona'),
('brudköp','1|köp'),
('brudmystik','1|tro'),
('brudnäbb','1|bröllop'),
('brudpall','1|bröllop'),
('brudpar','1|par'),
('brudpäll','1|baldakin'),
('brudrov','1|röva_bort'),
('brudslöja','1|slöja'),
('brudslöja','2|växt'),
('brudsporre','1|orkidé'),
('brudstol','1|bröllop'),
('brudsäng','1|bröllopsnatt'),
('brudtärna','1|bröllop'),
('brudöverlämning','1|vigselritual'),
('brugd','1|haj'),
('bruk','1|fabrik'),
('bruk','2|bruka'),
('bruk','3|murbruk'),
('bruka','1|vanlig'),
('bruka','2|använda'),
('bruka','3|odla'),
('brukande','1|bruka'),
('brukande','2|bruka'),
('brukare','1|bruka'),
('brukbar','1|bruka'),
('brukbarhet','1|brukbar'),
('bruklig','1|bruka'),
('bruklighet','1|bruka'),
('brukning','1|bruka'),
('brukningsenhet','1|enhet'),
('bruksanvisning','1|anvisning'),
('bruksarbetare','1|arbetare'),
('bruksartikel','1|bruksföremål'),
('bruksdisponent','1|disponent'),
('bruksdjur','1|djur'),
('bruksdrift','1|drift'),
('bruksföremål','1|föremål'),
('brukshund','1|hund'),
('brukskonst','1|konst'),
('brukslagare','1|brukslå'),
('brukslev','1|murslev'),
('brukslå','1|rappa'),
('brukslående','1|brukslå'),
('bruksort','1|ort'),
('brukspatron','1|chef'),
('bruksrörelse','1|bruk'),
('brukssamhälle','1|samhälle'),
('bruksvärde','1|värde'),
('bruksvärdeshyra','1|hyra'),
('brum','1|brumma'),
('brumbas','1|bas'),
('brumbjörn','1|vresig'),
('brumkör','1|sång'),
('brumma','1|läte'),
('brummande','1|brumma'),
('brummare','1|ko'),
('brumning','1|brumma'),
('brun','1|färg'),
('brun','2|högerextremistisk'),
('brunaktig','1|brun'),
('brunaktighet','1|brunaktig'),
('brunalg','1|alg'),
('brunand','1|and'),
('brunbetsa','1|betsa'),
('brunbetsande','1|brunbetsa'),
('brunbetsning','1|brunbetsa'),
('brunbränd','1|bränna'),
('brunbär','1|surkörsbär'),
('brunch','1|lunch'),
('brunchtest','1|test'),
('Brunei','1|land'),
('bruneier','1|Brunei'),
('bruneisk','1|Brunei'),
('bruneiska','1|bruneier'),
('brunera','1|skydda'),
('brunerande','1|brunera'),
('brunerbar','1|brunera'),
('brunerbarhet','1|brunerbar'),
('brunering','1|brunera'),
('brunett','1|brunhårig'),
('brunett','2|brunett'),
('brunfärga','1|brunfärgad'),
('brunfärgad','1|brun'),
('brunfärgande','1|brunfärga'),
('brunglänsande','1|glänsa'),
('brungrå','1|grå'),
('brungul','1|gul'),
('brunhet','1|brun'),
('brunhyad','1|hy'),
('brunhårig','1|hår'),
('brunhårighet','1|brunhårig'),
('brunjord','1|jordart'),
('brunkol','1|kol'),
('brunkolsdoft','1|doft'),
('brunkulla','1|orkidé'),
('brunkål','1|maträtt'),
('brunlackerad','1|lackera'),
('brunmurrig','1|brun'),
('brunmurrighet','1|brunmurrig'),
('brunmålad','1|måla'),
('brunn','1|ur'),
('brunnsdrickning','1|medicin'),
('brunnshus','1|brunn'),
('brunnskall','1|kall'),
('brunnskar','1|kar'),
('brunnskur','1|brunnsdrickning'),
('brunnsläkare','1|läkare'),
('brunnsort','1|kurort'),
('brunnspark','1|park'),
('brunnssvängel','1|brunn'),
('brunnsvatten','1|vatten'),
('brunnsöppning','1|brunn'),
('brunockra','1|ockra'),
('brunrost','1|rostsvamp'),
('brunrutig','1|rutig'),
('brunrutighet','1|brunrutig'),
('brunråtta','1|råtta'),
('brunröd','1|röd'),
('brunröta','1|sjukdom'),
('brunskjorta','1|nazist'),
('brunskära','1|växt'),
('brunsmutsig','1|smutsig'),
('brunst','1|parningsdrift'),
('brunsten','1|förening'),
('brunstig','1|brunst'),
('brunstighet','1|brunstig'),
('brunsttid','1|tid'),
('brunsvart','1|svart'),
('brunte','1|häst'),
('Brunte','1|häst'),
('brunögd','1|öga'),
('brunögdhet','1|brunögd'),
('brunört','1|ört'),
('brus','1|brusa'),
('brusa','1|låta'),
('brusande','1|brusa'),
('brusdryck','1|dryck'),
('brushane','1|vadarfågel'),
('brushuvud','1|hetsig'),
('brusig','1|brus'),
('brusighet','1|brusig'),
('brustablett','1|tablett'),
('brusten','1|brista'),
('brustenhet','1|brusten'),
('brutal','1|hård'),
('brutalisera','1|brutal'),
('brutaliserande','1|brutalisera'),
('brutaliserbar','1|brutalisera'),
('brutaliserbarhet','1|brutaliserbar'),
('brutalisering','1|brutalisera'),
('brutalitet','1|brutal'),
('bruten','1|förkrossad'),
('brutta','1|brud'),
('brutto','1|avdrag'),
('brutto','2|brutto'),
('bruttoavkastning','1|avkastning'),
('bruttobehållning','1|behållning'),
('bruttobelopp','1|belopp'),
('bruttodräktighet','1|fartyg'),
('bruttoformel','1|formel'),
('bruttoinkomst','1|inkomst'),
('bruttolön','1|lön'),
('bruttonationalprodukt','1|ekonomi'),
('bruttonationalprodukt','1|ekonomi'),
('bruttopris','1|pris'),
('bruttoregisterton','1|bruttodräktighet'),
('bruttovikt','1|vara'),
('bruttovinst','1|vinst'),
('bruttovärde','1|värde'),
('Brutus','1|mördare'),
('bry','1|bryderi'),
('bry','2|bryderi'),
('brydd','1|bryderi'),
('bryddhet','1|brydd'),
('bryderi','1|förvirring'),
('brydsam','1|bryderi'),
('brydsamhet','1|brydsam'),
('bryende','1|bry'),
('brygd','1|dryck'),
('brygga','1|tillverka'),
('brygga','2|sjö'),
('brygga','3|förena'),
('brygga','4|kommandobrygga'),
('bryggande','1|brygga'),
('bryggande','2|brygga'),
('bryggarbil','1|bil'),
('bryggare','1|brygga'),
('bryggd','1|brygga'),
('bryggdans','1|dans'),
('bryggeri','1|brygga'),
('bryggerijäst','1|jäst'),
('bryggerijätte','1|bryggeri'),
('brygghus','1|brygga'),
('bryggjäst','1|jäst'),
('bryggkaffe','1|kaffe'),
('bryggkant','1|kant'),
('bryggmald','1|mala'),
('bryggmalen','1|bryggmald'),
('bryggplats','1|båtplats'),
('bryggvåg','1|våg'),
('brylépudding','1|efterrätt'),
('brylépudding','1|efterrätt'),
('brylling','1|syssling'),
('brylå','1|glögg'),
('bryn','1|skogsbryn'),
('bryna','1|steka'),
('bryna','2|vässa'),
('bryna','3|knulla'),
('brynande','1|bryna'),
('brynande','2|bryna'),
('brynande','3|bryna'),
('bryne','1|bryna'),
('brynja','1|skydd'),
('brynset','1|set'),
('brynsten','1|bryne'),
('brynstål','1|bryne'),
('bryolog','1|bryologi'),
('bryologi','1|vetenskap'),
('brysk','1|ovänlig'),
('bryskhet','1|brysk'),
('Bryssel','1|huvudstad'),
('brysselkål','1|kål'),
('brysselmatta','1|matta'),
('brysselspets','1|spets'),
('bryta','10|öppna'),
('bryta','1|sönder'),
('bryta','2|mot'),
('bryta','3|utvinna'),
('bryta','4|språk'),
('bryta','5|bruka'),
('bryta','6|avbryta'),
('bryta','7|upphöra'),
('bryta','8|avböja'),
('bryta','9|bryta_av'),
('brytande','1|bryta'),
('brytande','2|bryta'),
('brytande','3|bryta'),
('brytande','4|bryta'),
('brytande','5|bryta'),
('brytande','6|bryta'),
('brytande','7|bryta'),
('brytande','8|bryta'),
('brytande','9|bryta'),
('brytare','1|strömbrytare'),
('brytarfel','1|fel'),
('brytbar','1|bryta'),
('brytbar','2|bryta'),
('brytbar','3|bryta'),
('brytbarhet','1|brytbar'),
('brytbarhet','2|brytbar'),
('brytbarhet','3|brytbar'),
('brytblad','1|blad'),
('brytbladskniv','1|kniv'),
('brytböna','1|böna'),
('bryte','1|träl'),
('brytning','1|bryta'),
('brytning','2|bryta'),
('brytning','3|bryta'),
('brytning','4|bryta'),
('brytning','5|bryta'),
('brytning','6|bryta'),
('brytning','7|bryta'),
('brytningsexponent','1|exponent'),
('brytningsfel','1|synfel'),
('brytningsförmåga','1|förmåga'),
('brytningsgräns','1|ljusbrytning'),
('brytningsindex','1|brytningsexponent'),
('brytningsperiod','1|förändring'),
('brytningspunkt','1|brytpunkt'),
('brytningstid','1|tid'),
('brytningsvinkel','1|vinkel'),
('brytningsår','1|ungdomstid'),
('brytpunkt','1|punkt'),
('brytpunkt','2|punkt'),
('brytvapen','1|gevär'),
('bråck','1|sjukdom'),
('bråck','1|sjukdom'),
('bråckband','1|bråck'),
('bråckband','1|bråck'),
('bråd','1|hastig'),
('bråddjup','1|djup'),
('bråddjup','2|bråddjup'),
('bråddjuphet','1|bråddjup'),
('brådhet','1|bråd'),
('brådis','1|bråttom'),
('brådmogen','1|mogen'),
('brådmogenhet','1|brådmogen'),
('brådmognad','1|brådmogen'),
('brådska','1|bråttom'),
('brådska','2|brådska'),
('brådskande','1|brådska'),
('brådskande','2|brådska'),
('brådstörtad','1|plötslig'),
('bråk','1|matematik'),
('bråk','2|bråka'),
('bråka','1|krångla'),
('bråka','2|bereda'),
('bråka','3|bråka'),
('bråkande','1|bråka'),
('bråkande','2|bråka'),
('bråkdel','1|del'),
('bråkig','1|bråk'),
('bråkighet','1|bråkig'),
('bråkmakare','1|bråk'),
('bråkräkning','1|beräkna'),
('bråkstake','1|bråkmakare'),
('bråkstreck','1|bråk'),
('bråktal','1|tal'),
('brånad','1|könsdrift'),
('brås','1|likna'),
('bråte','1|skräp'),
('bråttom','1|skynda'),
('bräck','1|bräcka'),
('bräcka','1|sönder'),
('bräcka','2|överträffa'),
('bräcka','3|steka'),
('bräcka','4|dagbräckning'),
('bräckage','1|bräcka'),
('bräckande','1|bräcka'),
('bräckande','2|bräcka'),
('bräckande','3|bräcka'),
('bräckande','4|bräcka'),
('bräckhammare','1|hammare'),
('bräckjärn','1|kofot'),
('bräckkorv','1|korv'),
('bräcklig','1|svag'),
('bräcklighet','1|bräcklig'),
('bräckning','1|bräcka'),
('bräckning','2|bräcka'),
('bräckning','3|bräcka'),
('bräckning','4|bräcka'),
('bräckt','1|vatten'),
('bräckthet','1|bräckt'),
('bräckvatten','1|saltvatten'),
('bräda','1|planka'),
('bräda','2|besegra'),
('brädande','1|bräda'),
('brädbeklä','1|beklä'),
('brädbeklädande','1|brädbeklä'),
('brädbeklädd','1|brädbeklä'),
('brädbeklädnad','1|brädbeklädd'),
('brädbeslå','1|brädbeklä'),
('brädbeslående','1|brädbeslå'),
('brädd','1|gräns'),
('brädda','1|fylla'),
('bräddande','1|brädda'),
('bräddavlopp','1|avlopp'),
('bräddfull','1|full'),
('bräddfullhet','1|bräddfull'),
('bräddfylld','1|bräddfull'),
('bräddfylldhet','1|bräddfylld'),
('bräde','1|skiva'),
('bräde','1|skiva'),
('brädfodra','1|brädbeklä'),
('brädfodrande','1|brädfodra'),
('brädgång','1|reling'),
('brädgård','1|lager'),
('brädplank','1|plank'),
('brädsegla','1|vindsurfa'),
('brädseglande','1|brädsegla'),
('brädslå','1|brädbeklä'),
('brädslående','1|brädslå'),
('brädspel','1|spel'),
('brädvägg','1|vägg'),
('bräka','1|läte'),
('bräkande','1|bräka'),
('bräken','1|ormbunke'),
('bräkning','1|bräka'),
('bräm','1|kant'),
('bräma','1|bräm'),
('brämande','1|bräma'),
('bränna','1|brinna'),
('bränna','2|framställa'),
('brännande','1|angelägen'),
('brännande','2|bränna'),
('brännande','3|bränna'),
('brännare','1|förbränning'),
('brännas','1|svida'),
('brännbar','1|bränna'),
('brännbarhet','1|brännbar'),
('brännblåsa','1|blåsa'),
('brännboll','1|bollspel'),
('brännboll','2|boll'),
('brännbollskast','1|kast'),
('brännbollsträ','1|bollträ'),
('bränne','1|bränsle'),
('bränneri','1|bränna'),
('brännglas','1|lins'),
('brännhet','1|het'),
('brännhår','1|brännässla'),
('bränning','1|våg'),
('brännjärn','1|brännmärke'),
('brännkammare','1|förbränning'),
('brännlack','1|brännlackera'),
('brännlackera','1|lackera'),
('brännlackerande','1|brännlackera'),
('brännlackerbar','1|brännlackera'),
('brännlackerbarhet','1|brännlackerbar'),
('brännlackering','1|brännlackera'),
('brännmanet','1|manet'),
('brännmaterial','1|bränsle'),
('brännmärka','1|fördöma'),
('brännmärka','2|brännmärke'),
('brännmärkande','1|brännmärka'),
('brännmärkande','2|brännmärka'),
('brännmärke','1|märke'),
('brännmärke','2|bomärke'),
('brännmärkning','1|brännmärka'),
('brännmärkning','2|brännmärka'),
('brännoffer','1|offer'),
('brännolja','1|olja'),
('brännpunkt','1|brytpunkt'),
('brännskada','1|skada'),
('brännskada','2|brännskada'),
('brännskadad','1|brännskada'),
('brännskadande','1|brännskada'),
('brännstål','1|stål'),
('brännsår','1|sår'),
('bränntorv','1|torv'),
('brännugn','1|ugn'),
('brännved','1|ved'),
('brännvidd','1|brännpunkt'),
('brännvin','1|alkohol'),
('brännvinsadvokat','1|advokat'),
('brännvinsbas','1|röst'),
('brännvinsbord','1|bord'),
('brännvinsbränneri','1|bränneri'),
('brännvinsbränning','1|brännvinsdestillering'),
('brännvinsdestilleri','1|brännvinsdestillering'),
('brännvinsdestillering','1|destillering'),
('brännvinsglas','1|glas'),
('brännvinsnäsa','1|alkoholmissbruk'),
('brännvinsprovare','1|mäta'),
('brännyta','1|ljusbrytning'),
('brännässla','1|nässla'),
('bränsle','1|brinna'),
('bränslebesparande','1|bränsle'),
('bränslebesparing','1|bränslesnål'),
('bränslebrist','1|brist'),
('bränslecell','1|cell'),
('bränslecellsdriven','1|driva'),
('bränslecellskonstruktion','1|konstruktion'),
('bränslecellskraftverk','1|kraftverk'),
('bränslecellstyp','1|typ'),
('bränsledepå','1|depå'),
('bränsleelement','1|element'),
('bränslefilter','1|filter'),
('bränslefält','1|fält'),
('bränsleförbrukning','1|förbrukning'),
('bränsleförråd','1|förråd'),
('bränslegas','1|gas'),
('bränslekanal','1|kanal'),
('bränslekris','1|kris'),
('bränslemätare','1|mäta'),
('bränsleomvandlare','1|omvandlare'),
('bränsleransonering','1|ransonering'),
('bränsleslukande','1|sluka'),
('bränslesnål','1|ekonomisk'),
('bränslesnålhet','1|bränslesnål'),
('bränslestav','1|stav'),
('bränsletank','1|tank'),
('bränsletillägg','1|tilläggskostnad'),
('bränsletyp','1|typ'),
('bränsleåtgång','1|bränsleförbrukning'),
('bräsch','1|hål'),
('bräsera','1|steka'),
('bräserande','1|bräsera'),
('bräserbar','1|bräsera'),
('bräserbarhet','1|bräserbar'),
('bräsering','1|bräsera'),
('bräsma','1|växt'),
('bräss','1|körtel'),
('brätte','1|kant'),
('bröa','1|ströbröd'),
('bröa','1|ströbröd'),
('bröande','1|bröa'),
('bröande','1|bröa'),
('bröd','1|mat'),
('brödbagge','1|skalbagge'),
('brödbak','1|bak'),
('brödbit','1|bit'),
('brödbrist','1|brist'),
('brödburk','1|burk'),
('brödfat','1|fat'),
('brödfrukt','1|frukt'),
('brödföda','1|uppehälle'),
('bröding','1|fisk'),
('brödkaka','1|bröd'),
('brödkant','1|brödbit'),
('brödkavel','1|baka'),
('brödkavel','1|baka'),
('brödkniv','1|kniv'),
('brödkorg','1|brödfat'),
('brödkö','1|kö'),
('brödlös','1|bröd'),
('brödlöshet','1|brödlös'),
('brödnagg','1|baka'),
('brödpris','1|pris'),
('brödpudding','1|efterrätt'),
('brödrafolk','1|broderfolk'),
('brödralag','1|brödraskap'),
('brödrapar','1|par'),
('brödrasinne','1|brödraskap'),
('brödraskap','1|broderskap'),
('brödrost','1|rosta'),
('brödsbrytelse','1|nattvard'),
('brödskiva','1|skiva'),
('brödskriveri','1|författa'),
('brödsmula','1|smula'),
('brödspade','1|baka'),
('brödstil','1|tryck'),
('brödstycke','1|bröd'),
('brödsäd','1|säd'),
('brödtext','1|text'),
('bröl','1|vrål'),
('bröla','1|bröl'),
('brölande','1|bröla'),
('bröllop','1|gifta_sig'),
('bröllopsbuss','1|buss'),
('bröllopsdag','1|dag'),
('bröllopsdikt','1|dikt'),
('bröllopsfest','1|fest'),
('bröllopsfoto','1|foto'),
('bröllopsgåva','1|gåva'),
('bröllopsgäst','1|gäst'),
('bröllopsinspirerad','1|inspirera'),
('bröllopskläder','1|festkläder'),
('bröllopsklänning','1|brudklänning'),
('bröllopsmarsch','1|marsch'),
('bröllopsmåltid','1|måltid'),
('bröllopsnatt','1|samlag'),
('bröllopspar','1|brudpar'),
('bröllopsplan','1|plan'),
('bröllopspoet','1|poet'),
('bröllopspresent','1|present'),
('bröllopsresa','1|bröllop'),
('bröllopsresmål','1|mål'),
('bröllopssed','1|sed'),
('bröllopssällskap','1|sällskap'),
('bröllopstårta','1|tårta'),
('bröllopsvideo','1|video'),
('bröllopsvittne','1|vittne'),
('bröllopsyra','1|yra'),
('Bröndby','1|ort'),
('bröst','1|kropp'),
('bröst','2|bröst'),
('brösta','1|seldon'),
('bröstarv','1|arv'),
('bröstarvinge','1|arvinge'),
('bröstbarn','1|barn'),
('bröstben','1|ben'),
('bröstbild','1|porträtt'),
('bröstböld','1|böld'),
('bröstcancer','1|cancer'),
('bröstcancerdiagnos','1|diagnos'),
('bröstcancerkirurgi','1|kirurgi'),
('bröstdroppar','1|medicin'),
('bröstfena','1|fena'),
('bröstficka','1|ficka'),
('bröstförstoring','1|bröstoperation'),
('bröstgång','1|lymfa'),
('bröstgänges','1|slagsmål'),
('brösthåla','1|bröstkorg'),
('brösthöjd','1|höjd'),
('bröstimplantat','1|silikonimplantat'),
('bröstingrepp','1|ingrepp'),
('bröstkaramell','1|karamell'),
('bröstkatarr','1|luftrörskatarr'),
('bröstklang','1|sjunga'),
('bröstknöl','1|knöl'),
('bröstkompression','1|kompression'),
('bröstkorg','1|bröst'),
('bröstkota','1|kota'),
('bröstkramp','1|kramp'),
('bröstkörtel','1|körtel'),
('bröstlapp','1|förkläde'),
('bröstlidande','1|sjukdom'),
('bröstmjölk','1|modersmjölk'),
('bröstmjölkspumpsutspel','1|bröstpumpsutspel'),
('bröstmur','1|bröstvärn'),
('bröstmuskel','1|muskel'),
('bröstmått','1|mått'),
('bröstning','1|vägg'),
('bröstoperation','1|operation'),
('bröstparti','1|bröst'),
('bröstpatient','1|patient'),
('bröstpump','1|bröstmjölk'),
('bröstpumpsutspel','1|utspel'),
('bröstregister','1|sjunga'),
('bröstsim','1|simma'),
('bröstsimmare','1|bröstsim'),
('bröstsimtag','1|simtag'),
('bröstsjuk','1|lungtuberkulos'),
('bröstskydd','1|skydd'),
('bröstsocker','1|kandisocker'),
('bröstsugande','1|suga'),
('bröstton','1|bröstregister'),
('bröstton','2|bestämd'),
('bröstvidd','1|bröstmått'),
('bröstvårta','1|bröst'),
('bröstvärk','1|värk'),
('bröstvärn','1|skyttevärn'),
('bröt','1|timmerbröt'),
('bröthake','1|båtshake'),
('brötling','1|kremla'),
('bu','1|fy'),
('bua','1|bu'),
('buande','1|bua'),
('bubba','1|ordna'),
('bubbande','1|bubba'),
('bubbel','1|bubbla'),
('bubbelbad','1|bad'),
('bubbelbadkar','1|badkar'),
('bubbelgum','1|tuggummi'),
('bubbelkammare','1|kärnfysik'),
('bubbelpool','1|badbassäng'),
('bubbla','1|rund'),
('bubbla','2|bubbla'),
('bubbla','3|blåsa_upp'),
('bubblande','1|bubbla'),
('bubblare','1|på_gång'),
('bubblig','1|bubbla'),
('bubblighet','1|bubblig'),
('bubon','1|sjukdom'),
('Buchenwald','1|koncentrationsläger'),
('buckla','1|inbuktning'),
('buckla','2|buckla'),
('buckla','3|pokal'),
('bucklig','1|buckla'),
('bucklighet','1|bucklig'),
('buckram','1|vävnad'),
('bud','1|meddela'),
('bud','2|norm'),
('bud','3|varubud'),
('bud','4|anbud'),
('bud','5|kortspel'),
('buda','1|bud'),
('buda','2|bud'),
('buda','3|bud'),
('budande','1|buda'),
('budande','2|buda'),
('budande','3|buda'),
('Budapest','1|huvudstad'),
('budbyrå','1|byrå'),
('budbärare','1|bud'),
('Buddha','1|buddhism'),
('buddha','1|staty'),
('buddhism','1|religion'),
('buddhism','1|religion'),
('buddhist','1|buddhism'),
('buddhist','1|buddhism'),
('buddhistisk','1|buddhism'),
('buddhistisk','1|buddhism'),
('budget','1|ekonomi'),
('budgetalternativ','1|alternativ'),
('budgetansvarig','1|ansvarig'),
('budgetarbete','1|utarbeta'),
('budgetdisciplin','1|disciplin'),
('budgetera','1|budget'),
('budgeterande','1|budgetera'),
('budgeterare','1|budgetera'),
('budgeterbar','1|budgetera'),
('budgeterbarhet','1|budgeterbar'),
('budgetering','1|budgetera'),
('budgetflyg','1|flyg'),
('budgetförordning','1|förordning'),
('budgetförslag','1|förslag'),
('budgetmotion','1|motion'),
('budgetmässig','1|budget'),
('budgetpolitik','1|politik'),
('budgetpolitisk','1|budgetpolitik'),
('budgetproposition','1|proposition'),
('budgetresa','1|resa'),
('budgetsanering','1|sanering'),
('budgetspa','1|spa'),
('budgetstup','1|finanskris'),
('budgetunderskott','1|underskott'),
('budgetvariant','1|variant'),
('budgetår','1|period'),
('budgetär','1|budget'),
('budgetöverskott','1|överskott'),
('budgivning','1|bud'),
('budkavle','1|bud'),
('budkavle','1|bud'),
('budkavlelöpning','1|stafett'),
('budning','1|buda'),
('budo','1|kampsport'),
('budoar','1|salong'),
('budoar','1|salong'),
('budoarmässig','1|budoar'),
('budord','1|Bibeln'),
('budskap','1|bud'),
('buff','1|knuff'),
('buffa','1|buff'),
('buffa','2|opera'),
('buffande','1|buffa'),
('buffaopera','1|buffa'),
('buffé','1|bord'),
('buffé','1|bord'),
('buffel','1|djur'),
('buffelaktig','1|klumpig'),
('buffelaktighet','1|buffelaktig'),
('buffelhjord','1|hjord'),
('buffert','1|stöt'),
('buffertkapacitet','1|buffertlösning'),
('buffertlager','1|lager'),
('buffertlösning','1|lösning'),
('buffertstat','1|stat'),
('bufflig','1|buffelaktig'),
('bufflighet','1|bufflig'),
('buffra','1|motverka'),
('buffrande','1|buffra'),
('buffringsförmåga','1|förmåga'),
('buga','1|hälsa'),
('bugande','1|buga'),
('bugg','1|dans'),
('bugg','2|fel'),
('bugg','2|fel'),
('bugg','3|avlyssna'),
('bugg','3|avlyssna'),
('bugga','1|bugg'),
('bugga','2|bugg'),
('buggande','1|bugga'),
('buggande','2|bugga'),
('buggfix','1|fix'),
('buggning','1|bugga'),
('bugning','1|buga'),
('Buick','1|bilmärke'),
('buk','1|mage'),
('Bukarest','1|huvudstad'),
('Bukefalos','1|häst'),
('bukett','1|blomma'),
('bukettgrönt','1|bukett'),
('bukfetma','1|fetma'),
('bukfett','1|kroppsfett'),
('bukfettslager','1|lager'),
('bukformig','1|utbuktande'),
('bukfylla','1|mat'),
('bukfyllnad','1|mat'),
('bukgjord','1|rem'),
('bukhinna','1|hinna'),
('bukhinneinflammation','1|inflammation'),
('bukhåla','1|buk'),
('bukig','1|bukformig'),
('bukighet','1|bukig'),
('buklanda','1|landa'),
('buklandande','1|buklanda'),
('bukmuskel','1|muskel'),
('bukolisk','1|idyllisk'),
('bukskott','1|skottskada'),
('bukspott','1|matsmältning'),
('bukspottkörtel','1|körtel'),
('bukstinn','1|fet'),
('bukstinnhet','1|bukstinn'),
('buksvåger','1|samlagspartner'),
('bukt','1|kust'),
('bukt','2|bukta'),
('bukta','1|krök'),
('buktala','1|tala'),
('buktalande','1|buktala'),
('buktalare','1|buktala'),
('buktaleri','1|buktala'),
('buktande','1|bukta'),
('buktig','1|bukformig'),
('buktighet','1|buktig'),
('buktning','1|bukta'),
('bukvägg','1|bukhåla'),
('bukvätska','1|vätska'),
('bula','1|svullnad'),
('bulb','1|stäv'),
('bulbjärn','1|skeppsbyggeri'),
('buldan','1|tyg'),
('bulgar','1|Bulgarien'),
('Bulgarien','1|land'),
('bulgarisk','1|Bulgarien'),
('bulgariska','1|språk'),
('bulgariska','2|bulgar'),
('bulgur','1|vete'),
('bulgur','1|vete'),
('bulimi','1|hetsätning'),
('bulimi','1|hetsätning'),
('bulimiker','1|bulimi'),
('bulimiker','1|bulimi'),
('buljong','1|soppa'),
('buljongben','1|ben'),
('buljongkött','1|kött'),
('buljongtärning','1|extrakt'),
('bulk','1|bulklast'),
('bulkfartyg','1|fartyg'),
('bulklast','1|last'),
('bulklastare','1|bulkfartyg'),
('bulkmedel','1|avföringsmedel'),
('bulla','1|skrivelse'),
('bulla','2|blåsa'),
('bullbak','1|baka'),
('bulldogg','1|hundras'),
('bulldozer','1|traktor'),
('bulle','1|bröd'),
('bulle','1|bröd'),
('bulle','2|taxi'),
('buller','1|bullra'),
('bullerbas','1|bråkmakare'),
('bullerblomster','1|smörboll'),
('bullerdämpande','1|dämpa'),
('bullerdämpning','1|bullerdämpande'),
('bullerförminskande','1|förminska'),
('bullerkrav','1|krav'),
('bullermatta','1|buller'),
('bullersam','1|bullra'),
('bullersamhet','1|bullersam'),
('bullerskada','1|skada'),
('bullerskärm','1|avskärmning'),
('bullersten','1|rullsten'),
('bullerutsatt','1|utsatt'),
('bullervall','1|skyddsvall'),
('bullervägg','1|väggkonstruktion'),
('bulletin','1|meddelande'),
('bullig','1|rund'),
('bullighet','1|bullig'),
('bullra','1|låta'),
('bullrande','1|bullra'),
('bullrig','1|bullra'),
('bullrighet','1|bullrig'),
('bullshit','1|skitprat'),
('Bulltofta','1|flygplats'),
('bulna','1|bula'),
('bulnad','1|bula'),
('bulnande','1|bulna'),
('bulsig','1|bylsig'),
('bulsighet','1|bulsig'),
('bult','1|skruv'),
('bulta','1|slå'),
('bultande','1|bulta'),
('bulthuvud','1|huvud'),
('bulthål','1|hål'),
('bultning','1|bulta'),
('bultpistol','1|bult'),
('bultsax','1|avbitartång'),
('bultskalle','1|bulthuvud'),
('bulvan','1|företräda'),
('bulvanverksamhet','1|verksamhet'),
('bumerang','1|kasta'),
('bumling','1|stenbumling'),
('bums','1|genast'),
('bunden','1|ofri'),
('bundenhet','1|bunden'),
('bundis','1|bekant'),
('bundsförvant','1|allierad'),
('bundsförvantskap','1|bundsförvant'),
('bungalow','1|villa'),
('bunke','1|skål'),
('bunker','1|stridsvärn'),
('bunker','2|förråd'),
('bunkra','1|fylla'),
('bunkrande','1|bunkra'),
('bunkring','1|bunkra'),
('bunkringsolja','1|olja'),
('bunkringsplats','1|plats'),
('bunkringsstation','1|station'),
('bunkstål','1|stål'),
('bunsenbrännare','1|gasbrännare'),
('bunt','1|samling'),
('bunta','1|bunt'),
('buntande','1|bunta'),
('buntband','1|band'),
('buntmakare','1|körsnär'),
('buntning','1|bunta'),
('buntvis','1|bunt'),
('bur','1|fångenskap'),
('burbrev','1|dokument'),
('burdus','1|häftig'),
('burfågel','1|fågel'),
('burgarbar','1|hamburgerbar'),
('burgarbar','1|hamburgerbar'),
('burgare','1|hamburgare'),
('burgare','1|hamburgare'),
('burgarrestaurang','1|hamburgerrestaurang'),
('burgarrestaurang','1|hamburgerrestaurang'),
('burgarställe','1|hamburgerställe'),
('burgarställe','1|hamburgerställe'),
('burgen','1|rik'),
('burgenhet','1|burgen'),
('burgund','1|folk'),
('burgunder','1|german'),
('burgunder','2|bourgogne'),
('burhöns','1|höns'),
('burk','1|förvara'),
('burka','1|burk'),
('burka','2|balansera'),
('burka','3|slöja'),
('burkaförbud','1|förbud'),
('burkande','1|burka'),
('burkande','2|burka'),
('burkhållare','1|hållare'),
('burkinier','1|Burkina_Faso'),
('burkinsk','1|Burkina_Faso'),
('burkinska','1|burkinier'),
('burkmat','1|mat'),
('burkslav','1|passagerare'),
('burköl','1|öl'),
('burköppnare','1|konservöppnare'),
('burlesk','1|komisk'),
('burlesk','2|teater'),
('burleskeri','1|burlesk'),
('Burlington','1|stad'),
('Burma','1|land'),
('burman','1|Burma'),
('burman','1|Burma'),
('burmansk','1|Burma'),
('burmansk','1|Burma'),
('burmanska','1|språk'),
('burmanska','1|språk'),
('burmanska','2|burman'),
('burmanska','2|burman'),
('burnus','1|mantel'),
('burr','1|hårburr'),
('burrig','1|lockig'),
('burrighet','1|burrig'),
('burschikos','1|studentikos'),
('burskap','1|rätt'),
('burspråk','1|utsprång'),
('burspråksfönster','1|burspråk'),
('Burundi','1|land'),
('burundier','1|Burundi'),
('burundisk','1|Burundi'),
('burundiska','1|burundier'),
('bus','1|busa'),
('busa','1|bråka'),
('busande','1|busa'),
('buse','1|otrevlig'),
('busenkel','1|enkel'),
('busfason','1|sätt'),
('busfrö','1|barn'),
('bush','1|buske'),
('bushman','1|folk'),
('busig','1|busa'),
('busighet','1|busig'),
('business','1|affär'),
('buska','1|buske'),
('buska','2|spela'),
('buskablyg','1|blyg'),
('buskablyghet','1|buskablyg'),
('buskage','1|buske'),
('buskagitation','1|propaganda'),
('buskande','1|buska'),
('buskartad','1|buske'),
('buskbevuxen','1|bevuxen'),
('buske','1|växt'),
('buskig','1|buske'),
('buskighet','1|buskig'),
('buskis','1|buskteater'),
('buskliknande','1|buske'),
('buskskvätta','1|trastfågel'),
('busksly','1|buske'),
('busksnår','1|buske'),
('buskteater','1|komik'),
('buskväxt','1|växt'),
('buskörare','1|buskörning'),
('buskörning','1|körning'),
('busliv','1|bus'),
('busringa','1|ringa'),
('busringande','1|busringa'),
('busringare','1|busringa'),
('busringning','1|busringa'),
('buss','1|åka'),
('buss','2|soldat'),
('buss','3|tobak'),
('buss','4|bussa'),
('buss','5|kompis'),
('bussa','1|buss'),
('bussa','2|bussning'),
('bussa','3|anfalla'),
('bussande','1|bussa'),
('bussande','2|bussa'),
('bussande','3|bussa'),
('bussankomst','1|ankomst'),
('bussarong','1|skjorta'),
('bussavgång','1|avgång'),
('busschaufför','1|chaufför'),
('bussförare','1|busschaufför'),
('bussförbindelse','1|förbindelse'),
('busshållplats','1|hållplats'),
('bussig','1|hygglig'),
('bussighet','1|bussig'),
('busskort','1|rabattkort'),
('busskrock','1|krock'),
('busskur','1|kur'),
('busslast','1|passagerare'),
('busslinje','1|bussförbindelse'),
('bussning','1|rör'),
('busspassagerare','1|passagerare'),
('bussresa','1|resa'),
('busstation','1|station'),
('busstaxa','1|taxa'),
('bussterminal','1|terminal'),
('busstidtabell','1|tidtabell'),
('busstrafik','1|trafik'),
('busstransport','1|transport'),
('busstur','1|tur'),
('busstur','2|tur'),
('Buster','1|Keaton'),
('busunge','1|unge'),
('busvissla','1|vissla'),
('busvisslande','1|busvissla'),
('busvissling','1|busvissla'),
('busväder','1|oväder'),
('butadien','1|kolväte'),
('butan','1|kolväte'),
('butanol','1|alkohol'),
('butelj','1|flaska'),
('buteljborste','1|flaskborste'),
('buteljbotten','1|fönster'),
('buteljera','1|butelj'),
('buteljerande','1|buteljera'),
('buteljerbar','1|buteljera'),
('buteljerbarhet','1|buteljerbar'),
('buteljering','1|buteljera'),
('buteljglas','1|glas'),
('buteljgrön','1|mörkgrön'),
('buteljlack','1|lack'),
('butik','1|affär'),
('butiksanställd','1|anställd'),
('butiksbaka','1|butiksbakad'),
('butiksbakad','1|baka'),
('butiksbiträde','1|affärsbiträde'),
('butiksdörr','1|dörr'),
('butiksfönster','1|skyltfönster'),
('butiksinnehavare','1|innehavare'),
('butikskedja','1|kedja'),
('butiksrån','1|rån'),
('butiksstängningslag','1|lag'),
('butikstjuv','1|tjuv'),
('butiksägare','1|ägare'),
('butler','1|betjänt'),
('Butter','1|dvärg'),
('butter','1|ovänlig'),
('butterhet','1|butter'),
('butterkaka','1|vetekaka'),
('butyl','1|kolväte'),
('butylalkohol','1|butanol'),
('buxbom','1|buske'),
('B-vitamin','1|vitamin'),
('B-vitaminbrist','1|brist'),
('by','1|samhälle'),
('by','2|vindby'),
('byalag','1|by'),
('byamål','1|jorddelning'),
('bybo','1|by'),
('byffé','1|skåp'),
('byfogde','1|ledare'),
('byfåne','1|sinnesslö'),
('bygata','1|väg'),
('bygd','1|trakt'),
('bygdeborg','1|fornborg'),
('bygdegård','1|samlingslokal'),
('bygdemål','1|dialekt'),
('bygdepatriotism','1|lokalpatriotism'),
('bygel','1|handtag'),
('bygelhorn','1|bleckblåsinstrument'),
('bygelhäst','1|gymnastikredskap'),
('bygellås','1|lås'),
('bygelrem','1|rem'),
('bygga','1|tillverka'),
('byggande','1|bygga'),
('byggarbetare','1|byggnadsarbetare'),
('byggarbetskran','1|kran'),
('byggarbetsplats','1|arbetsplats'),
('byggare','1|bygga'),
('byggbeslag','1|beslag'),
('byggcontainer','1|container'),
('byggdamm','1|damm'),
('byggdispens','1|dispens'),
('bygge','1|bygga'),
('byggelement','1|element'),
('byggenskap','1|bygga'),
('byggfirma','1|byggföretag'),
('byggflopp','1|flopp'),
('byggföretag','1|företag'),
('byggherre','1|bygga'),
('byggjätte','1|byggföretag'),
('byggkloss','1|leksak'),
('byggkostnad','1|kostnad'),
('bygglag','1|lag'),
('bygglekplats','1|lekplats'),
('bygglov','1|byggnadslov'),
('bygglåda','1|låda'),
('byggmaterial','1|material'),
('byggmiss','1|misstag'),
('byggmästardotter','1|dotter'),
('byggmästare','1|bygga'),
('byggnad','1|bygga'),
('byggnadsarbetare','1|arbetare'),
('byggnadsbråte','1|bråte'),
('byggnadsfirma','1|byggfirma'),
('byggnadsföretag','1|byggföretag'),
('byggnadsindustri','1|industri'),
('byggnadskomplex','1|byggnad'),
('byggnadskonst','1|arkitektur'),
('byggnadskonstruktion','1|konstruktion'),
('byggnadskontor','1|myndighet'),
('byggnadskredit','1|lån'),
('byggnadskreditiv','1|byggnadskredit'),
('byggnadslov','1|tillstånd'),
('byggnadslån','1|lån'),
('byggnadslån','1|lån'),
('byggnadsmaterial','1|material'),
('byggnadsminne','1|byggnad'),
('byggnadsmässig','1|byggnad'),
('byggnadsnämnd','1|nämnd'),
('byggnadsplan','1|plan'),
('byggnadsplats','1|plats'),
('byggnadssnickare','1|snickare'),
('byggnadssockel','1|sockel'),
('byggnadssten','1|byggsten'),
('byggnadsstil','1|stil'),
('byggnadsstomme','1|stomme'),
('byggnadsstyrelse','1|styrelse'),
('byggnadsställning','1|bygga'),
('byggnadssätt','1|bygga'),
('byggnadsteknik','1|teknik'),
('byggnadsteknisk','1|byggnadsteknik'),
('byggnadstillstånd','1|tillstånd'),
('byggnadstimmer','1|timmer'),
('byggnadsverk','1|byggnad'),
('byggnadsvirke','1|virke'),
('byggnation','1|bygga'),
('byggning','1|byggnad'),
('byggnorm','1|norm'),
('byggpass','1|vattenpass'),
('byggplan','1|byggnadsplan'),
('byggprojekt','1|projekt'),
('byggsats','1|del'),
('byggsektor','1|sektor'),
('byggstart','1|start'),
('byggsten','1|sten'),
('byggstopp','1|avbrott'),
('byggställning','1|ställning'),
('byggtid','1|tid'),
('byggtork','1|fläkt'),
('byggvara','1|vara'),
('byggvaruhus','1|varuhus'),
('byggvarukedja','1|affärskedja'),
('byhus','1|hus'),
('byig','1|vindby'),
('byk','1|tvätt'),
('byka','1|byk'),
('bykande','1|byka'),
('byke','1|pack'),
('bykgryta','1|gryta'),
('byling','1|polisman'),
('bylsig','1|klumpig'),
('bylsighet','1|bylsig'),
('bylte','1|paket'),
('bymoln','1|åskmoln'),
('bymoské','1|moské'),
('byområde','1|område'),
('byordning','1|lag'),
('byracka','1|hund'),
('byrett','1|glasrör'),
('byrå','1|möbel'),
('byrå','2|kontor'),
('byråassistent','1|tjänsteman'),
('byråchef','1|chef'),
('byrådirektör','1|tjänsteman'),
('byråkrat','1|byråkrati'),
('byråkrati','1|administration'),
('byråkratisera','1|byråkrati'),
('byråkratiserande','1|byråkratisera'),
('byråkratiserbar','1|byråkratisera'),
('byråkratiserbarhet','1|byråkratiserbar'),
('byråkratisering','1|byråkratisera'),
('byråkratisk','1|byråkrati'),
('byråkratism','1|byråkrati'),
('byrålåda','1|låda'),
('byråsekreterare','1|tjänsteman'),
('bysamfällighet','1|samfällighet'),
('Bysans','1|Östrom'),
('bysantin','1|Bysans'),
('bysantinism','1|kultur'),
('bysantinsk','1|Bysans'),
('bysantinsk','2|lömsk'),
('byskola','1|skola'),
('bysnille','1|talang'),
('byssja','1|skjul'),
('byst','1|skulptur'),
('byst','2|bröst'),
('bystan','1|landsbygd'),
('bystdrottning','1|kvinna'),
('bysthållare','1|behå'),
('bystmått','1|mått'),
('bystämma','1|stämma'),
('bysätta','1|häkta'),
('bysättande','1|bysätta'),
('bysättning','1|bysätta'),
('byta','1|annan'),
('bytande','1|byta'),
('byte','1|byta'),
('byte','2|fånga'),
('byte','3|datorminne'),
('bytesaffär','1|affär'),
('bytesartikel','1|bytesvara'),
('bytesbalans','1|balans'),
('bytesbalansunderskott','1|underskott'),
('bytesbalansöverskott','1|överskott'),
('bytesbrev','1|kontrakt'),
('bytesdjur','1|djur'),
('byteshandel','1|handel'),
('byteshushållning','1|hushållning'),
('byteslägenhet','1|lägenhet'),
('bytesmedel','1|betala'),
('bytesobjekt','1|objekt'),
('bytesvara','1|vara'),
('bytesvärde','1|värde'),
('byting','1|barn'),
('bytta','1|kärl'),
('byväg','1|väg'),
('byxbak','1|bak'),
('byxben','1|byxor'),
('byxdress','1|kläder'),
('byxdräkt','1|byxdress'),
('byxficka','1|ficka'),
('byxholk','1|regnkläder'),
('byxhälla','1|byxor'),
('byxis','1|byxångest'),
('byxkjol','1|kjol'),
('byxklåda','1|kåtbock'),
('byxklämma','1|klämma'),
('byxknä','1|knä'),
('byxlös','1|byxor'),
('byxlöshet','1|byxlös'),
('byxor','1|kläder'),
('byxor','1|kläder'),
('byxslag','1|slag'),
('byxångest','1|nervositet'),
('byäldste','1|byfogde'),
('båda','1|två'),
('båda','2|förebåda'),
('båda','3|skär'),
('båda','3|skär'),
('bådadera','1|båda'),
('bådande','1|båda'),
('både','1|och'),
('båg','1|lögn'),
('båga','1|båg'),
('bågande','1|båga'),
('bågbro','1|bro'),
('båge','1|kurva'),
('båge','2|motorcykel'),
('båge','3|pilbåge'),
('bågfil','1|såg'),
('bågform','1|båge'),
('bågformad','1|båge'),
('bågformig','1|båge'),
('bågformighet','1|bågformig'),
('bågfris','1|fris'),
('bågfält','1|portal'),
('bågfönster','1|fönster'),
('båggång','1|öra'),
('båggång','2|arkad'),
('bågig','1|bågformig'),
('båglampa','1|lampa'),
('båglinje','1|linje'),
('bågljus','1|ljus'),
('bågminut','1|minut'),
('bågna','1|böja'),
('bågnande','1|bågna'),
('bågsekund','1|sekund'),
('bågskytt','1|bågskytte'),
('bågskytte','1|skytte'),
('bågskyttefält','1|fält'),
('bågsträng','1|sträng'),
('bågsvetsning','1|svetsning'),
('bågsåg','1|såg'),
('bågvalv','1|valv'),
('båk','1|sjömärke'),
('bål','1|kropp'),
('bål','2|eld'),
('bål','3|dryck'),
('båld','1|stolt'),
('båldhet','1|båld'),
('bålgeting','1|geting'),
('bålrullning','1|gymnastik'),
('bålrörelse','1|rörelse'),
('bålverk','1|försvar'),
('bålväxt','1|växt'),
('bångstyrig','1|vild'),
('bångstyrighet','1|bångstyrig'),
('bår','1|bädd'),
('bårbärare','1|bärare'),
('bårbärning','1|bära'),
('bård','1|kant'),
('bårdmönster','1|mönster'),
('bårhus','1|lik'),
('bårlärka','1|sångerska'),
('bås','1|ladugård'),
('Båstad','1|ort'),
('båt','1|åka'),
('båta','1|hjälpa'),
('båtande','1|båta'),
('båtankomst','1|ankomst'),
('båtavgång','1|avgång'),
('båtben','1|ben'),
('båtbotten','1|botten'),
('båtbrygga','1|brygga'),
('båtbyggare','1|bygga'),
('båtbygge','1|båtbyggeri'),
('båtbyggeri','1|bygga'),
('båtdäck','1|däck'),
('båtfart','1|båttrafik'),
('båtformig','1|båt'),
('båtfärd','1|färd'),
('båtgrav','1|grav'),
('båthall','1|hall'),
('båthus','1|förvara'),
('båtklubb','1|klubb'),
('båtliknande','1|båt'),
('båtlägenhet','1|tur'),
('båtmotor','1|motor'),
('båtmässa','1|mässa'),
('båtmössa','1|mössa'),
('båtnad','1|nytta'),
('båtpendla','1|pendelbåt'),
('båtpendlande','1|båtpendla'),
('båtpendling','1|båtpendla'),
('båtplats','1|plats'),
('båtresa','1|resa'),
('båtshake','1|stång'),
('båtskjul','1|förvara'),
('båtskrå','1|ställning'),
('båtsman','1|förman'),
('båtsmansstol','1|fartyg'),
('båtspant','1|spant'),
('båtterminal','1|terminal'),
('båttidtabell','1|tidtabell'),
('båttrafik','1|trafik'),
('båttransport','1|transport'),
('båttur','1|tur'),
('båttur','2|tur'),
('båttävling','1|tävling'),
('båtutflykt','1|utflykt'),
('båtvagga','1|förvara'),
('båtvård','1|vårda'),
('båtvårdsmedel','1|medel'),
('båtyxa','1|stenyxa'),
('bä','1|bräka'),
('bäbis','1|barn'),
('bäbis','1|barn'),
('bäck','1|vatten'),
('bäckahäst','1|näcken'),
('bäcken','1|kärl'),
('bäcken','2|bål'),
('bäcken','3|fördjupning'),
('bäckenben','1|ben'),
('bäckenförträngning','1|förträngning'),
('bäckenhåla','1|bäcken'),
('bäckenuppluckring','1|foglossning'),
('bäckforell','1|laxöring'),
('bäckmynning','1|mynning'),
('bäckravin','1|ravin'),
('bäckröding','1|röding'),
('bäckvatten','1|bäck'),
('bäcköring','1|bäckforell'),
('bädd','1|säng'),
('bädd','2|underlag'),
('bädda','1|säng'),
('bädda','2|orsaka'),
('bäddande','1|bädda'),
('bäddande','2|bädda'),
('bäddjacka','1|jacka'),
('bäddning','1|bädda'),
('bäddsoffa','1|soffa'),
('bäddutrustning','1|utrustning'),
('bägare','1|glas'),
('bägarkorall','1|korall'),
('bägarmanet','1|manet'),
('bägarsvamp','1|svamp'),
('bägge','1|båda'),
('bäggedera','1|bådadera'),
('bälg','1|blåsbälg'),
('bälga','1|bälga_i_sig'),
('bälgande','1|bälga'),
('bälgformad','1|bälg'),
('bälgkamera','1|kamera'),
('bälgliknande','1|bälg'),
('bälgvante','1|tumvante'),
('Bälinge','1|ort'),
('bälta','1|djur'),
('bälta','2|tvångsbälte'),
('bältande','1|bälta'),
('bältdjur','1|bälta'),
('bälte','1|rem'),
('bälte','2|område'),
('bältesläggning','1|tvångsbälte'),
('bältespännare','1|tvekamp'),
('bältestvång','1|obligatorisk'),
('bältning','1|bälta'),
('bältros','1|sjukdom'),
('bända','1|bryta'),
('bändande','1|bända'),
('bändelband','1|bomullsband'),
('bändjärn','1|kofot'),
('bändning','1|bända'),
('bändsel','1|tåg'),
('bändsel','1|tåg'),
('bändsla','1|bändsel'),
('bändsla','1|bändsel'),
('bändslande','1|bändsla'),
('bändslande','1|bändsla'),
('bäng','1|galen'),
('bängel','1|slyngel'),
('bänghet','1|bäng'),
('bänk','1|möbel'),
('bänka','1|avbytarbänk'),
('bänka','2|bänkpress'),
('bänkad','1|bänka_sig'),
('bänkgranne','1|granne'),
('bänkkamrat','1|kamrat'),
('bänknummer','1|nummer'),
('bänkplats','1|sittplats'),
('bänkpress','1|tyngdlyftning'),
('bänkrad','1|rad'),
('bänkskåp','1|skåp'),
('bänkslipmaskin','1|slipmaskin'),
('bänkspis','1|spis'),
('bär','1|äta'),
('bära','1|flytta'),
('bära','2|hålla'),
('bära','3|klä'),
('bärande','1|stöd'),
('bärande','2|bära'),
('bärande','3|bära'),
('bärande','4|bära'),
('bärare','1|bära'),
('bärarlag','1|lag'),
('bärbar','1|bära'),
('bärbarhet','1|bärbar'),
('bärbjälke','1|bjälke'),
('bärbuske','1|bär'),
('bärfis','1|insekt'),
('bärfrekvens','1|frekvens'),
('bärga','1|rädda'),
('bärgande','1|bärga'),
('bärgare','1|bärga'),
('bärgarlön','1|lön'),
('bärgning','1|bärga'),
('bärgning','2|uppehälle'),
('bärgningsbil','1|bil'),
('bärgningsföretag','1|företag'),
('bärgningsledare','1|ledare'),
('bärgningspersonal','1|personal'),
('bärgningsväder','1|väder'),
('bärhandtag','1|handtag'),
('bärhjälp','1|hjälp'),
('bärig','1|bärkraftig'),
('bärig','2|flyta'),
('bärighet','1|bärig'),
('bärighet','2|bärig'),
('bäring','1|riktning'),
('bärkasse','1|bära'),
('bärkotte','1|kotte'),
('bärkraft','1|förmåga'),
('bärkraftig','1|bärkraft'),
('bärkraftighet','1|bärkraftig'),
('bärlager','1|förstärka'),
('bärlager','2|axellager'),
('bärm','1|avsats'),
('bärmark','1|mark'),
('bärnsten','1|smycke'),
('bärnsten','2|färg'),
('bärnstensfärgad','1|bärnsten'),
('bärnstenssmycke','1|bärnsten'),
('bärnstenssyra','1|syra'),
('bärpelare','1|pelare'),
('bärplan','1|bärplansbåt'),
('bärplansbåt','1|båt'),
('bärplockare','1|plocka'),
('bärplockning','1|plocka'),
('bärpåse','1|bära'),
('bärraket','1|raket'),
('bärrem','1|rem'),
('bärsa','1|öl'),
('bärsa','1|öl'),
('bärsa','2|bärsa'),
('bärsa','3|öl'),
('bärsa','3|öl'),
('bärsande','1|bärsa'),
('bärsele','1|sele'),
('bärstol','1|stol'),
('bärsärk','1|viking'),
('bärsärkagång','1|raseriutbrott'),
('bärsärkaraseri','1|bärsärkagång'),
('bärvidd','1|spännvidd'),
('bärvin','1|vin'),
('bärvåg','1|radiovåg'),
('bäst','1|bra'),
('bäst','2|när'),
('bästeman','1|styrman'),
('bästföredag','1|utgångsdatum'),
('bästföredag','1|utgångsdatum'),
('bästföredag','1|utgångsdatum'),
('bästföredag','1|utgångsdatum'),
('bästföredatum','1|utgångsdatum'),
('bästföredatum','1|utgångsdatum'),
('bästföredatum','1|utgångsdatum'),
('bästföredatum','1|utgångsdatum'),
('bästis','1|kamrat'),
('bästsäljande','1|bästsäljare'),
('bästsäljare','1|bestseller'),
('bästsäljarism','1|bästsäljare'),
('bästsäljarlista','1|lista'),
('bättra','1|bra'),
('bättrande','1|bättra'),
('bättring','1|bra'),
('bäva','1|oro'),
('bävan','1|bäva'),
('bävande','1|bäva'),
('bäver','1|djur'),
('bävergäll','1|utsöndra'),
('bävergäll','2|naturmedicin'),
('bävernylon','1|nylon'),
('bävernylonoverall','1|overall'),
('bäverpäls','1|päls'),
('bäverråtta','1|sumpbäver'),
('bävning','1|jordbävning'),
('böckling','1|strömming'),
('bödel','1|avrätta'),
('bödelsdräng','1|hantlangare'),
('bödelssvärd','1|svärd'),
('bödelsyxa','1|yxa'),
('bög','1|man'),
('bögdöd','1|död'),
('bögporr','1|porr'),
('böhmare','1|Böhmen'),
('Böhmen','1|Tjeckoslovakien'),
('böhmisk','1|Böhmen'),
('böj','1|böja'),
('böja','1|krokig'),
('böja','2|ändra'),
('böjande','1|böja'),
('böjande','2|böja'),
('böjare','1|böjarmuskel'),
('böjarmuskel','1|muskel'),
('böjbar','1|böjlig'),
('böjbarhet','1|böjbar'),
('böjd','1|böja'),
('böjd','2|benägen'),
('böjdhet','1|böjd'),
('böjelse','1|önskan'),
('böjhållfasthet','1|hållfasthet'),
('böjlig','1|böja'),
('böjlighet','1|böjlig'),
('böjmuskel','1|muskel'),
('böjning','1|böja'),
('böjning','2|böja'),
('böjningsexempel','1|exempel'),
('böjningsform','1|ordform'),
('böjningsmönster','1|mönster'),
('böjningssätt','1|böja'),
('böjningsändelse','1|ändelse'),
('böjprov','1|prov'),
('böjträ','1|trä'),
('bök','1|bökig'),
('böka','1|gräva'),
('bökande','1|böka'),
('bökig','1|oreda'),
('bökning','1|böka'),
('böl','1|böla'),
('böla','1|läte'),
('böla','2|storgråta'),
('bölande','1|böla'),
('bölande','2|böla'),
('böld','1|var'),
('böldpest','1|pest'),
('bölja','1|våg'),
('bölja','2|bölja'),
('böljande','1|bölja'),
('böljegång','1|bölja'),
('böljeslag','1|slag'),
('böljeslagsmärke','1|geologi'),
('bölning','1|böla'),
('bölning','2|böla'),
('bön','1|be'),
('bön','2|be'),
('böna','1|grönsak'),
('böna','2|flicka'),
('böna','3|be'),
('bönande','1|böna'),
('bönbok','1|bok'),
('böndag','1|helgdag'),
('böneanrop','1|anrop'),
('bönegudstjänst','1|gudstjänst'),
('bönehus','1|kapell'),
('bönehus','1|kapell'),
('böneman','1|frieri'),
('bönematta','1|islam'),
('bönemöte','1|möte'),
('böneramp','1|bönpall'),
('bönerum','1|rum'),
('bönesal','1|sal'),
('böneskrift','1|skrift'),
('bönestund','1|bön'),
('böneutropare','1|utropare'),
('bönfalla','1|vädja'),
('bönfallande','1|bönfalla'),
('bönformig','1|böna'),
('böngrodd','1|grodd'),
('bönhas','1|klåpare'),
('bönhus','1|kapell'),
('bönhöra','1|bönhörelse'),
('bönhörande','1|bönhöra'),
('bönhörelse','1|bön'),
('bönkaffe','1|kaffeböna'),
('bönlig','1|bön'),
('bönpall','1|bön'),
('bönpall','2|sits'),
('bönskida','1|balja'),
('bönväxt','1|böna'),
('böra','1|måste'),
('börande','1|böra'),
('börd','1|härkomst'),
('börda','1|bära'),
('bördig','1|riklig'),
('bördig','2|född'),
('bördighet','1|bördig'),
('bördsadel','1|adel'),
('bördsaristokrati','1|aristokrati'),
('bördshögfärd','1|högfärd'),
('bördsrätt','1|rätt'),
('bördsstolt','1|stolt'),
('bördsstolthet','1|bördsstolt'),
('börja','1|först'),
('börja','2|börja'),
('början','1|börja'),
('börjande','1|börja'),
('börs','1|portmonnä'),
('börs','2|ekonomi'),
('börsanalys','1|analys'),
('börsanalytiker','1|börsanalys'),
('börsbolag','1|bolag'),
('börsjobbare','1|vinst'),
('börskaos','1|kaos'),
('börskrasch','1|krasch'),
('börskurs','1|kurs'),
('börsmäklare','1|mäklare'),
('börsmässig','1|börs'),
('börsnotera','1|registrera'),
('börsnoterande','1|börsnotera'),
('börsnoterbar','1|börsnotera'),
('börsnoterbarhet','1|börsnoterbar'),
('börsnotering','1|börskurs'),
('börsoro','1|oro'),
('börsras','1|ras'),
('börssal','1|sal'),
('börsspekulant','1|vinst'),
('börsspekulation','1|börsspekulant'),
('börsstyrelse','1|styrelse'),
('börstelegraf','1|telegraf'),
('börsuppgång','1|uppgång'),
('börsutveckling','1|börskurs'),
('börsyra','1|yra'),
('börting','1|öring'),
('bössa','1|skjuta'),
('bössa','2|sparbössa'),
('bösshåll','1|skotthåll'),
('bössinsamling','1|insamling'),
('bösta','1|banka'),
('böstande','1|bösta'),
('böta','1|betala'),
('böta','2|utpressning'),
('böta','3|sona'),
('bötande','1|böta'),
('bötande','2|böta'),
('böter','1|böta'),
('böter','2|bötessumma'),
('bötesbelopp','1|bötessumma'),
('bötesstraff','1|böter'),
('bötessumma','1|penningsumma'),
('bötfälla','1|böta'),
('bötfällande','1|bötfälla'),
('bövel','1|djävul'),
('c','1|bokstav'),
('c','2|ton'),
('cab','1|cabriolet'),
('cab','1|cabriolet'),
('cabotage','1|sjöfart'),
('cabriolet','1|bil'),
('CaCO3','1|kalk'),
('caddie','1|golf'),
('Cadillac','1|bilmärke'),
('Caelius','1|kulle'),
('Caere','1|stad'),
('Caesar','1|härförare'),
('cafébord','1|bord'),
('cafébord','1|bord'),
('cafeteria','1|servering'),
('cafeteria','1|servering'),
('caldera','1|vulkan'),
('caldera','1|vulkan'),
('californium','1|grundämne'),
('californium','1|grundämne'),
('Caligula','1|kejsare'),
('callcenter','1|central'),
('callgirl','1|prostituerad'),
('Callisto','1|måne'),
('calmettevaccinering','1|vaccinering'),
('calvados','1|brännvin'),
('Calvinol','1|Calvinols_resa_genom_världen'),
('calypso','1|sång'),
('calzone','1|pizza'),
('calzone','1|pizza'),
('Cambodja','1|Kampuchea'),
('Cambridge','1|stad'),
('Camel','1|cigarett'),
('camembert','1|ost'),
('Camillo','1|Golgi'),
('camorra','1|maffia'),
('camp','1|föråldrad'),
('campa','1|camping'),
('campa','1|camping'),
('campande','1|campa'),
('campande','1|campa'),
('campare','1|camping'),
('campare','1|camping'),
('camphet','1|camp'),
('camping','1|tälta'),
('campingkök','1|fotogenkök'),
('campinglampa','1|lampa'),
('campingplats','1|plats'),
('campingstuga','1|stuga'),
('campus','1|område'),
('canasta','1|kortspel'),
('Canberra','1|huvudstad'),
('cancan','1|dans'),
('cancer','1|sjukdom'),
('cancerbehandling','1|behandling'),
('cancerbekämpning','1|bekämpning'),
('cancerfall','1|fall'),
('cancerfara','1|fara'),
('cancerform','1|cancer'),
('cancerforskare','1|forskare'),
('cancerforskning','1|forskning'),
('cancerframkallande','1|orsaka'),
('cancerrisk','1|risk'),
('cancersjuk','1|sjuk'),
('cancerspridning','1|spridning'),
('cancersvulst','1|svulst'),
('cancertumör','1|tumör'),
('canceruppföljning','1|uppföljning'),
('candela','1|mått'),
('Candide','1|roman'),
('cannabis','1|narkotika'),
('cannabisodling','1|odling'),
('cannabisplanta','1|planta'),
('Cannes','1|stad'),
('canossavandring','1|botgöring'),
('cantilena','1|sång'),
('cantilena','1|sång'),
('cape','1|jacka'),
('Capella','1|stjärna'),
('Capitolium','1|kulle'),
('cappuccino','1|kaffe'),
('cappuccinokopp','1|kopp'),
('Caracas','1|huvudstad'),
('Caravelle','1|flygplan'),
('cardigan','1|kofta'),
('Carema','1|vårdföretag'),
('Carlo','1|Karl'),
('Carolina','1|universitetsbibliotek'),
('carpa','1|livsnjutare'),
('cartesiansk','1|Cartesius'),
('Cartesius','1|Descartes'),
('Casanova','1|författare'),
('casanova','1|kvinnoförförare'),
('cash','1|kontant'),
('cash','2|cash'),
('cashew','1|cashewnöt'),
('cashewnöt','1|nöt'),
('cashewnöt','1|nöt'),
('Cassiodorus','1|författare'),
('Cassiopeja','1|stjärnbild'),
('casting','1|sport'),
('Castor','1|stjärna'),
('catch-as-catch-can','1|fribrottning'),
('catera','1|catering'),
('caterande','1|catera'),
('catering','1|leverera'),
('cateringbransch','1|bransch'),
('caterpillar','1|bandtraktor'),
('catgut','1|sytråd'),
('catgut','1|sytråd'),
('Catherine','1|Katarina'),
('Cato','1|romare'),
('Catullus','1|diktare'),
('catwalk','1|modeuppvisning'),
('catwalka','1|catwalk'),
('catwalkande','1|catwalka'),
('cavatina','1|aria'),
('CD','1|ljudinspelning'),
('CD','1|ljudinspelning'),
('CD-ROM','1|datorminne'),
('CD-ROM','1|datorminne'),
('CD-spelare','1|CD'),
('CD-spelare','1|CD'),
('C-dur','1|dur'),
('C-durskalan','1|skala'),
('ceder','1|träd'),
('cedera','1|fordran'),
('cederande','1|cedera'),
('cederbar','1|cedera'),
('cederbarhet','1|cederbar'),
('cedering','1|cedera'),
('cederskog','1|skog'),
('cedilj','1|skrivtecken'),
('cediljtecken','1|cedilj'),
('cedrat','1|citronskal'),
('cedroolja','1|olja'),
('celeber','1|känd'),
('celebrera','1|fira'),
('celebrerande','1|celebrera'),
('celebrerbar','1|celebrera'),
('celebrerbarhet','1|celebrerbar'),
('celebrering','1|celebrera'),
('celebritet','1|celeber'),
('celebritetsjournalistik','1|journalistik'),
('celest','1|himmel'),
('celesta','1|piano'),
('celibat','1|kyskhet'),
('celibatliv','1|celibat'),
('celibatlöfte','1|löfte'),
('cell','1|växa'),
('cell','2|instängd'),
('cell','3|element'),
('cella','1|tempel'),
('cellandning','1|andning'),
('cellbildning','1|bildning'),
('cellbiologi','1|biologi'),
('celldelning','1|delning'),
('cellfängelse','1|fängelse'),
('cellgift','1|medicin'),
('cellgiftsbehandling','1|behandling'),
('cellgranne','1|granne'),
('cellini','1|äpple'),
('cellist','1|cello'),
('cellkamrat','1|kamrat'),
('cellkärna','1|kärna'),
('cellmembran','1|membran'),
('cello','1|violoncell'),
('cellodling','1|odla'),
('cellofan','1|plast'),
('cellplasma','1|plasma'),
('cellprov','1|prov'),
('cellsjok','1|sjok'),
('cellskikt','1|skikt'),
('cellskräck','1|skräck'),
('cellspänning','1|spänning'),
('cellstoff','1|blöja'),
('cellstraff','1|cell'),
('cellstruktur','1|struktur'),
('cellsubstans','1|cell'),
('cellterapi','1|terapi'),
('celltråd','1|tråd'),
('celltyp','1|typ'),
('cellulas','1|enzym'),
('celluloid','1|plast'),
('cellulosa','1|ämne'),
('cellulosaetanol','1|etanol'),
('cellulosafabrik','1|fabrik'),
('cellulosaförtunning','1|förtunna'),
('cellulosaindustri','1|industri'),
('cellulosalack','1|lack'),
('cellulosamolekyl','1|molekyl'),
('cellulosanitrat','1|cellulosa'),
('cellulosaplast','1|plast'),
('cellulosavadd','1|cellstoff'),
('cellulär','1|cell'),
('cellvägg','1|vägg'),
('cellvävnad','1|vävnad'),
('Celsius','1|temperatur'),
('celsiusgrad','1|grad'),
('celsiusgrad','1|grad'),
('celsiusgrad','1|grad'),
('celsiusskala','1|Celsius'),
('celsiustermometer','1|termometer'),
('celt','1|yxa'),
('cembalist','1|cembalo'),
('cembalo','1|piano'),
('cembalobyggare','1|bygga'),
('cembalobygge','1|bygga'),
('cembalotillverkning','1|tillverkning'),
('cement','1|mura'),
('cementa','1|cementera'),
('cementande','1|cementa'),
('cementblandare','1|blanda'),
('cementera','1|cement'),
('cementera','2|fälla_ut'),
('cementerande','1|cementera'),
('cementerande','2|cementera'),
('cementerbar','1|cementera'),
('cementerbar','2|cementera'),
('cementerbarhet','1|cementerbar'),
('cementerbarhet','2|cementerbar'),
('cementering','1|cement'),
('cementering','2|cementera'),
('cementering','3|utfyllning'),
('cementfärg','1|betongfärg'),
('cementrör','1|rör'),
('cenakel','1|förening'),
('cendré','1|mörkblond'),
('cendréfärgad','1|cendré'),
('censor','1|övervaka'),
('censur','1|förbjuda'),
('censurera','1|censur'),
('censurerande','1|censurera'),
('censurerbar','1|censurera'),
('censurerbarhet','1|censurerbar'),
('censurering','1|censurera'),
('censurfrihet','1|censur'),
('censurförordning','1|förordning'),
('censurhinder','1|censur'),
('censurtvång','1|censur'),
('census','1|rösträtt'),
('census','2|folkräkning'),
('cent','1|dollar'),
('Centauren','1|stjärnbild'),
('centaurgestalt','1|gestalt'),
('Centauristjärna','1|stjärna'),
('Centaurisystemet','1|stjärnsystem'),
('center','1|fotbollsspelare'),
('centerback','1|center'),
('centerbord','1|köl'),
('centerforward','1|center'),
('centerhalv','1|center'),
('centerism','1|medelväg'),
('centerledare','1|ledare'),
('Centern','1|Centerpartiet'),
('Centern','1|Centerpartiet'),
('centerparti','1|mittenparti'),
('Centerpartiet','1|parti'),
('Centerpartiet','1|parti'),
('Centerpartiet','1|parti'),
('Centerpartiet','1|parti'),
('centerpartist','1|Centerpartiet'),
('centerpartistisk','1|Centerpartiet'),
('centerprofil','1|profil'),
('centigram','1|gram'),
('centiliter','1|liter'),
('centilong','1|mått'),
('centimeter','1|meter'),
('centimeter','1|meter'),
('centimeterlång','1|lång'),
('centimeterskala','1|skala'),
('centimeterstor','1|stor'),
('centimetertjock','1|tjock'),
('centner','1|mått'),
('centra','1|passa'),
('central','1|centrum'),
('central','2|central'),
('Centralafrika','1|Afrika'),
('centralafrikan','1|Centralafrika'),
('centralafrikansk','1|Centralafrika'),
('centralafrikanska','1|centralafrikan'),
('Centralamerika','1|Amerika'),
('centralamerikan','1|Centralamerika'),
('centralamerikan','1|Centralamerika'),
('centralamerikansk','1|Centralamerika'),
('centralanstalt','1|huvudanstalt'),
('centralantenn','1|antenn'),
('centralasiatisk','1|Centralasien'),
('Centralasien','1|Asien'),
('centralbank','1|bank'),
('centralbankschef','1|chef'),
('centralbyggnad','1|byggnad'),
('centralbyrå','1|centrum'),
('centraldirigerad','1|leda'),
('Centralen','1|centralstation'),
('centralenhet','1|datamaskin'),
('Centraleuropa','1|Europa'),
('centraleuropeisk','1|Centraleuropa'),
('centralfigur','1|figur'),
('centralförbund','1|förbund'),
('centralförsvar','1|försvarsstrategi'),
('centralförvaltning','1|förvaltning'),
('centralgestalt','1|gestalt'),
('centralisation','1|centralisera'),
('centralisera','1|central'),
('centraliserande','1|centralisera'),
('centraliserbar','1|centralisera'),
('centraliserbarhet','1|centraliserbar'),
('centralisering','1|centralisera'),
('centralism','1|centralisera'),
('centralistisk','1|centralism'),
('centralkommitté','1|kommunistparti'),
('centralkontor','1|kontor'),
('centralkyrka','1|kyrka'),
('centrallasarett','1|lasarett'),
('centrallyrik','1|lyrik'),
('centrallyrisk','1|centrallyrik'),
('centralmakt','1|förbund'),
('centralmått','1|mätvärde'),
('centralnämnd','1|nämnd'),
('centralorganisation','1|organisation'),
('centralort','1|ort'),
('centralpunkt','1|punkt'),
('centralradio','1|radio'),
('centralregering','1|regering'),
('centralrörelse','1|rörelsecentrum'),
('centralskola','1|skola'),
('centralstation','1|järnvägsstation'),
('centralstimulantia','1|narkotika'),
('centralstimulerande','1|stimulera'),
('centralstyrd','1|styra'),
('centralstyrelse','1|styrelse'),
('centralvärme','1|uppvärmning'),
('centrande','1|centra'),
('centrera','1|centrum'),
('centrerande','1|centrera'),
('centrerbar','1|centrera'),
('centrerbarhet','1|centrerbar'),
('centrering','1|centrera'),
('centrifug','1|rotera'),
('centrifugal','1|centrum'),
('centrifugalkraft','1|kraft'),
('centrifugalpump','1|pump'),
('centrifugera','1|centrifug'),
('centrifugerande','1|centrifugera'),
('centrifugerbar','1|centrifugera'),
('centrifugerbarhet','1|centrifugerbar'),
('centrifugering','1|centrifugera'),
('centripetal','1|centrum'),
('centripetalkraft','1|kraft'),
('centrisk','1|centrum'),
('centrum','1|mitt'),
('centrum','1|mitt'),
('centrum','2|inrättning'),
('centrum','2|inrättning'),
('centumspråk','1|indoeuropeisk'),
('centurion','1|befälhavare'),
('Cepheus','1|stjärnbild'),
('cerat','1|salva'),
('cerealier','1|sädesslag'),
('cerebral','1|hjärna'),
('cerebrospinal','1|hjärna'),
('cerebrospinalvätska','1|ryggmärg'),
('ceremoni','1|akt'),
('ceremoniel','1|ceremoni'),
('ceremoniell','1|ceremoni'),
('ceremoniell','1|ceremoni'),
('ceremonimästare','1|ceremoni'),
('ceremoniös','1|ceremoni'),
('cerise','1|rosa'),
('cerise','2|cerise'),
('cerisefärgad','1|körsbärsfärgad'),
('cerium','1|jordmetall'),
('cerium','2|grundämne'),
('cerium','2|grundämne'),
('CERN','1|forskningslaboratorium'),
('cernera','1|innesluta'),
('cernerande','1|cernera'),
('cernerbar','1|cernera'),
('cernerbarhet','1|cernerbar'),
('cernering','1|cernera'),
('cert','1|fartygstyp'),
('certeparti','1|fraktavtal'),
('certifiera','1|certifikat'),
('certifierande','1|certifiera'),
('certifiering','1|certifiera'),
('certifikat','1|intyg'),
('cervelatkorv','1|korv'),
('cesarisk','1|cesarism'),
('cesarism','1|maktutövande'),
('cesium','1|grundämne'),
('cesium','1|grundämne'),
('cesium-137','1|cesium'),
('cession','1|fordran'),
('cesur','1|paus'),
('Ceylon','1|Sri_Lanka'),
('cha-cha','1|dans'),
('chagrin','1|läder'),
('chagrin','1|läder'),
('Challenger','1|rymdfarkost'),
('Chalmers','1|högskola'),
('chalmersk','1|Chalmers'),
('chamotte','1|lera'),
('champagne','1|vin'),
('champagnebaksmälla','1|baksmälla'),
('champagnebärgning','1|bärgning'),
('champagneflaska','1|flaska'),
('champagneglas','1|glas'),
('champagnekork','1|kork'),
('champagnesabel','1|sabrera'),
('champagnesprutande','1|spruta'),
('champagnesprutande','2|spruta'),
('champagnevaskare','1|vaska'),
('champagnevisp','1|visp'),
('champinjon','1|svamp'),
('champinjonbädd','1|champinjon'),
('champion','1|mästare'),
('championat','1|pris'),
('Champs-Élysées','1|gata'),
('changemang','1|scenväxling'),
('changera','1|förfalla'),
('changera','1|förfalla'),
('changera','1|förfalla'),
('changera','1|förfalla'),
('changerande','1|changera'),
('changerande','1|changera'),
('changerande','1|changera'),
('changerande','1|changera'),
('changering','1|changera'),
('changering','1|changera'),
('changering','1|changera'),
('changering','1|changera'),
('chans','1|möjlighet'),
('chansa','1|chans'),
('chansande','1|chansa'),
('chansartad','1|chans'),
('chanslös','1|chans'),
('chanslöshet','1|chanslös'),
('chansmässig','1|chans'),
('chansning','1|chansa'),
('chanson','1|visa'),
('chansonett','1|chanson'),
('chansonett','2|sångerska'),
('chansonettsångerska','1|chansonett'),
('chanstagare','1|chans'),
('chanstagning','1|chans'),
('chapeau-claque','1|hatt'),
('char','1|vagn'),
('charabang','1|vagn'),
('charad','1|ordgåta'),
('charge','1|råvara'),
('chargé-d-affaires','1|diplomat'),
('chargera','1|överdriva'),
('chargerande','1|chargera'),
('chargerbar','1|chargera'),
('chargerbarhet','1|chargerbar'),
('chargering','1|chargera'),
('chark','1|charkuteri'),
('charkuteri','1|affär'),
('charkuterist','1|charkuteri'),
('charkuterivara','1|kött'),
('charkvara','1|charkuterivara'),
('charlatan','1|bedragare'),
('charlataneri','1|charlatan'),
('charlatanmässig','1|charlatan'),
('charleston','1|dans'),
('Charleston','1|huvudstad'),
('Charlotte','1|stad'),
('charm','1|fängsla'),
('charma','1|charm'),
('charmande','1|charma'),
('charmant','1|förtjusande'),
('charmera','1|charm'),
('charmerande','1|charmera'),
('charmerbar','1|charmera'),
('charmerbarhet','1|charmerbar'),
('charmering','1|charmera'),
('charmeuse','1|underkläder'),
('charmfull','1|charm'),
('charmfullhet','1|charmfull'),
('charmig','1|charm'),
('charmighet','1|charmig'),
('charmkurs','1|kurs'),
('charmkvark','1|kvark'),
('charmlös','1|charm'),
('charmlöshet','1|charmlös'),
('charmoffensiv','1|offensiv'),
('charmtroll','1|barn'),
('charmör','1|charm'),
('Charon','1|måne'),
('charpi','1|förband'),
('charta','1|manifest'),
('Charta77','1|manifest'),
('charter','1|charterresa'),
('charterresa','1|resa'),
('charterturist','1|turist'),
('chartra','1|hyra'),
('chartrande','1|chartra'),
('chartreuse','1|likör'),
('chassi','1|stomme'),
('chassidism','1|judendom'),
('chassidistisk','1|chassidism'),
('chateaubriand','1|oxfilé'),
('chatt','1|chatta'),
('chatt','1|chatta'),
('chatta','1|samtala'),
('chattande','1|chatta'),
('chattkonversation','1|chatta'),
('chaufför','1|köra'),
('chaussé','1|landsväg'),
('chausserad','1|sko'),
('chauvinism','1|nationalism'),
('chauvinist','1|chauvinism'),
('chauvinistisk','1|chauvinism'),
('check','1|betala'),
('check','2|checka'),
('checka','1|kontrollera'),
('checkande','1|checka'),
('checkbok','1|checkhäfte'),
('checkhäfte','1|häfte'),
('checkkonto','1|konto'),
('checkkredit','1|kredit'),
('checklista','1|lista'),
('checklön','1|lön'),
('checkräkning','1|checkkonto'),
('checksumma','1|summa'),
('Checquers','1|lantställe'),
('cheddarost','1|ost'),
('chef','1|ledare'),
('chefa','1|chef'),
('chefande','1|chefa'),
('chef-d-oeuvre','1|mästerverk'),
('chefredaktör','1|redaktör'),
('chefsegenskap','1|egenskap'),
('chefsekonom','1|ekonom'),
('chefsfartyg','1|fartyg'),
('chefsflytt','1|flytt'),
('chefsideolog','1|ideolog'),
('chefsjobb','1|jobb'),
('chefskap','1|chef'),
('chefskap','1|chef'),
('chefskirurg','1|kirurg'),
('chefsmikrobiolog','1|mikrobiolog'),
('chefsplats','1|plats'),
('chefsställning','1|chef'),
('chefstjänsteman','1|tjänsteman'),
('chefsåklagare','1|åklagare'),
('chemis','1|tyg'),
('chemisett','1|skjortbröst'),
('Cheops','1|farao'),
('cherimoya','1|frukt'),
('Chesterfield','1|cigarett'),
('chevaleresk','1|artig'),
('chevelyr','1|håruppsättning'),
('cheviot','1|ylletyg'),
('chevreau','1|getskinn'),
('Chevrolet','1|bilmärke'),
('chevrotera','1|tala'),
('chevroterande','1|chevrotera'),
('chevroterbar','1|chevrotera'),
('chevroterbarhet','1|chevroterbar'),
('chevrotering','1|chevrotera'),
('Cheyenne','1|huvudstad'),
('cheyenne','1|urbefolkning'),
('chi','1|bokstav'),
('chianti','1|vin'),
('chic','1|elegant'),
('Chicago','1|stad'),
('Chicagobaserad','1|basera'),
('Chicagobaserad','1|basera'),
('chichet','1|chic'),
('chiffer','1|språk'),
('chiffernyckel','1|tolka'),
('chifferskrift','1|skrift'),
('chiffong','1|tyg'),
('chiffonggarnering','1|garnering'),
('chiffongklänning','1|klänning'),
('chiffonjé','1|skåp'),
('chiffrera','1|chiffer'),
('chiffrerande','1|chiffrera'),
('chiffrerbar','1|chiffrera'),
('chiffrerbarhet','1|chiffrerbar'),
('chiffrering','1|chiffrera'),
('chikan','1|chikanera'),
('chikanera','1|vanhedra'),
('chikanerande','1|chikanera'),
('chikanerbar','1|chikanera'),
('chikanerbarhet','1|chikanerbar'),
('chikanering','1|chikanera'),
('Chile','1|land'),
('chilenare','1|Chile'),
('chilenare','1|Chile'),
('chilensk','1|Chile'),
('chilenska','1|chilenare'),
('chilesalpeter','1|gödningsmedel'),
('chili','1|krydda'),
('chilipeppar','1|peppar'),
('chilisås','1|sås'),
('chilla','1|slappa'),
('chilla','1|slappa'),
('chillande','1|chilla'),
('chillande','1|chilla'),
('chimpa','1|granska'),
('chimpande','1|chimpa'),
('chimpning','1|chimpa'),
('chimpning','1|chimpa'),
('chimär','1|föreställning'),
('chimärisk','1|chimär'),
('chinchilla','1|djur'),
('chinjong','1|frisyr'),
('chintz','1|tyg'),
('chips','1|potatis'),
('chips','2|kiselplatta'),
('chips','2|kiselplatta'),
('chipssug','1|sug'),
('chirre','1|chips'),
('chirre','1|chips'),
('chirre','1|chips'),
('Chisinau','1|huvudstad'),
('chock','1|sinnesrörelse'),
('chock','2|anfall'),
('chocka','1|chock'),
('chockande','1|chocka'),
('chockartad','1|chock'),
('chockbehandla','1|chockbehandling'),
('chockbehandlande','1|chockbehandla'),
('chockbehandling','1|psykiatri'),
('chockbeskatta','1|skattechock'),
('chockbeskattande','1|chockbeskatta'),
('chockbeskattning','1|chockbeskatta'),
('chockbesked','1|besked'),
('chockbild','1|bild'),
('chockera','1|chock'),
('chockerande','1|chockera'),
('chockerbar','1|chockera'),
('chockerbarhet','1|chockerbar'),
('chockering','1|chockera'),
('chockfas','1|fas'),
('chockhöja','1|höja'),
('chockhöjande','1|chockhöja'),
('chockhöjning','1|chockhöja'),
('chockreaktion','1|reaktion'),
('chockrosa','1|rosa'),
('chockterapi','1|terapi'),
('chocktillstånd','1|tillstånd'),
('chockvåg','1|våg'),
('choka','1|choke'),
('chokande','1|choka'),
('choke','1|bensinmotor'),
('choklad','1|dryck'),
('choklad','2|sötsak'),
('chokladbit','1|choklad'),
('chokladboll','1|godsak'),
('chokladbrun','1|brun'),
('chokladglass','1|glass'),
('chokladgodis','1|godis'),
('chokladgodis','2|godis'),
('chokladkaka','1|choklad'),
('chokladlins','1|chokladgodis'),
('chokladlycka','1|lycklig'),
('chokladpudding','1|efterrätt'),
('chokladtårta','1|tårta'),
('chorizo','1|korv'),
('chorizo-stoppning','1|stoppning'),
('chosefri','1|choser'),
('choser','1|tillgjord'),
('chosig','1|choser'),
('Christer','1|Krister'),
('Chrysler','1|bilmärke'),
('chuck','1|fästa'),
('chutney','1|krydda'),
('CIA','1|underrättelsetjänst'),
('Cicero','1|författare'),
('cicero','1|tryck'),
('ciceron','1|visa'),
('cider','1|dryck'),
('cif','1|frakt'),
('cigarett','1|röka'),
('cigarett','1|röka'),
('cigarettautomat','1|automat'),
('cigarettetui','1|etui'),
('cigarettfimp','1|fimp'),
('cigarettfimp','1|fimp'),
('cigarettförsäljning','1|försäljning'),
('cigarettlimpa','1|förpackning'),
('cigarettlimpa','1|förpackning'),
('cigarettpaket','1|paket'),
('cigarettpaket','1|paket'),
('cigarettrök','1|rök'),
('cigarettrök','1|rök'),
('cigarettrökning','1|cigarett'),
('cigarettuttag','1|uttag'),
('cigarettuttag','1|uttag'),
('cigarettändare','1|tända'),
('cigarettändare','1|tända'),
('cigarettändarkontakt','1|cigarettändaruttag'),
('cigarettändarkontakt','1|cigarettändaruttag'),
('cigarettändaruttag','1|uttag'),
('cigarettändaruttag','1|uttag'),
('cigarill','1|cigarr'),
('cigarill','1|cigarr'),
('cigarr','1|röka'),
('cigarrcigarett','1|cigarill'),
('cigarrcigarett','1|cigarill'),
('cigarrettobak','1|tobak'),
('cigarrlåda','1|låda'),
('cigarrsnopp','1|snopp'),
('cigarrsnoppare','1|snoppare'),
('cigarrtändare','1|tända'),
('cigg','1|cigarett'),
('cigg','1|cigarett'),
('cikada','1|insekt'),
('ciklid','1|akvariefisk'),
('ciklidfisk','1|fisk'),
('ciklidfiskfauna','1|fauna'),
('cikoria','1|kaffeersättning'),
('ciliarkropp','1|öga'),
('ciliarmuskel','1|ciliarkropp'),
('cilie','1|flimmerhår'),
('cimbrer','1|folk'),
('cineast','1|filmexpert'),
('cinematek','1|arkiv'),
('cineraria','1|krukväxt'),
('cinnober','1|färgämne'),
('cinnoberfärg','1|färg'),
('cinnoberröd','1|cinnober'),
('cirka','1|ungefär'),
('cirka','1|ungefär'),
('cirka','1|ungefär'),
('cirkapris','1|pris'),
('cirkel','1|rund'),
('cirkel','2|kurs'),
('cirkelbana','1|bana'),
('cirkelben','1|passare'),
('cirkelbevis','1|bevis'),
('cirkelbåge','1|del'),
('cirkeldefinition','1|definition'),
('cirkelform','1|cirkel'),
('cirkelformad','1|cirkelform'),
('cirkelgång','1|rundgång'),
('cirkelledare','1|ledare'),
('cirkelperiferi','1|periferi'),
('cirkelprocess','1|process'),
('cirkelrund','1|cirkel'),
('cirkelrundhet','1|cirkelrund'),
('cirkelrörelse','1|rörelse'),
('cirkelsegment','1|cirkel'),
('cirkelsektor','1|cirkel'),
('cirkelslut','1|slutledning'),
('cirkelsåg','1|såg'),
('cirkla','1|cirkel'),
('cirklande','1|cirkla'),
('cirkulation','1|cirkulera'),
('cirkulationsplats','1|rondell'),
('cirkulationspump','1|pump'),
('cirkulationsrubbning','1|rubbning'),
('cirkulera','1|röra'),
('cirkulerande','1|cirkulera'),
('cirkulerbar','1|cirkulera'),
('cirkulerbarhet','1|cirkulerbar'),
('cirkulering','1|cirkulera'),
('cirkulär','1|cirkel'),
('cirkulär','2|rundskrivelse'),
('cirkulärbrev','1|brev'),
('cirkulärledare','1|ledare'),
('cirkumflex','1|skrivtecken'),
('cirkumpolar','1|stjärna'),
('cirkumpolär','1|pol'),
('cirkumpolär','1|pol'),
('cirkus','1|skådespel'),
('cirkus','2|spektakel'),
('cirkusarena','1|arena'),
('cirkusartist','1|artist'),
('cirkusbyggnad','1|byggnad'),
('cirkusdjur','1|djur'),
('cirkuselefant','1|elefant'),
('cirkusföreställning','1|föreställning'),
('cirkusmanege','1|manege'),
('cirkusmässig','1|cirkus'),
('cirkusnummer','1|föreställning'),
('cirkustält','1|tält'),
('cirkusvagn','1|vagn'),
('cirros','1|sjukdom'),
('cirros','1|sjukdom'),
('cirrus','1|cirrusmoln'),
('cirrusmoln','1|fjädermoln'),
('cisalpinsk','1|Alperna'),
('ciselera','1|bearbeta'),
('ciselerande','1|ciselera'),
('ciselerbar','1|ciselera'),
('ciselerbarhet','1|ciselerbar'),
('ciselering','1|ciselera'),
('ciselör','1|ciselera'),
('cisperson','1|transperson'),
('ciss','1|ton'),
('cissexualitet','1|cissexuell'),
('cissexuell','1|cisperson'),
('cissus','1|krukväxt'),
('cisterciens','1|cisterciensermunk'),
('cistercienserkloster','1|kloster'),
('cisterciensermunk','1|munk'),
('cisterciensorden','1|klosterorden'),
('cisterciensorden','1|klosterorden'),
('cistern','1|behållare'),
('cisulal','1|perm'),
('citadell','1|fästning'),
('citat','1|citera'),
('citation','1|citat'),
('citationstecken','1|skrivtecken'),
('citatord','1|lånord'),
('citattecken','1|citationstecken'),
('citera','1|säga'),
('citerande','1|citera'),
('citerbar','1|citera'),
('citerbarhet','1|citerbar'),
('citering','1|citera'),
('citrat','1|salt'),
('citrin','1|bergkristall'),
('Citroen','1|bilmärke'),
('Citroen','1|bilmärke'),
('Citroen','1|bilmärke'),
('Citroen','1|bilmärke'),
('citron','1|frukt'),
('citronbakelse','1|bakelse'),
('citrondoft','1|doft'),
('citronfjäril','1|fjäril'),
('citrongräsolja','1|olja'),
('citrongul','1|gul'),
('citronläsk','1|läsk'),
('citronmarinerad','1|marinera'),
('citronmeliss','1|kryddört'),
('citronmousse','1|mousse'),
('citronolja','1|cedroolja'),
('citronsaft','1|saft'),
('citronskal','1|skal'),
('citronsorbet','1|sorbet'),
('citronsyra','1|syra'),
('citronträd','1|träd'),
('citrus','1|träd'),
('citrus','2|citrusfrukt'),
('citrusfrukt','1|frukt'),
('citrussmak','1|smak'),
('citterspel','1|spel'),
('citterspelare','1|cittra'),
('cittra','1|stränginstrument'),
('cittra','2|Citroen'),
('city','1|mitt'),
('citydress','1|dress'),
('citykärna','1|kärna'),
('cityliv','1|liv'),
('cityljus','1|ljus'),
('civil','1|militär'),
('civilanställd','1|anställd'),
('civilbefolkning','1|befolkning'),
('civilbegravning','1|begravning'),
('civildepartementet','1|departement'),
('civilekonom','1|ekonom'),
('civilflyg','1|flyg'),
('civilförsvar','1|försvar'),
('civilförsvarspersonal','1|personal'),
('civilingenjör','1|ingenjör'),
('civilisation','1|samhälle'),
('civilisationsprocess','1|civilisera'),
('civilisatorisk','1|civilisation'),
('civilisera','1|civilisation'),
('civiliserad','1|civilisation'),
('civiliserande','1|civilisera'),
('civiliserbar','1|civilisera'),
('civiliserbarhet','1|civiliserbar'),
('civilisering','1|civilisera'),
('civilist','1|civil'),
('civilklädd','1|uniform'),
('civilkurage','1|kurage'),
('civillag','1|lag'),
('civilmilitär','1|militär'),
('civilmilitär','2|civilmilitär'),
('civilminister','1|minister'),
('civilmotstånd','1|vapen'),
('civilmål','1|mål'),
('civilprocess','1|civilmål'),
('civilrätt','1|civillag'),
('civilrättslig','1|civilrätt'),
('civilstat','1|civil'),
('civilstånd','1|gifta_sig'),
('civiläktenskap','1|äktenskap'),
('Clarté','1|rörelse'),
('cleara','1|clearing'),
('cleara','1|clearing'),
('clearande','1|cleara'),
('clearande','1|cleara'),
('clearing','1|ekonomi'),
('clematis','1|klätterväxt'),
('clematis','1|klätterväxt'),
('clementin','1|citrusfrukt'),
('clementin','1|citrusfrukt'),
('clinch','1|boxning'),
('clips','1|smycke'),
('cloisonvägg','1|mellanvägg'),
('cloisonvägg','1|mellanvägg'),
('cloqué','1|tyg'),
('clou','1|höjdpunkt'),
('clown','1|cirkus'),
('clowneri','1|clown'),
('clownupptåg','1|clowneri'),
('club-blazer','1|blazer'),
('clubstek','1|nötkött'),
('c-o','1|adress'),
('coach','1|tränare'),
('cocacola','1|dryck'),
('cocacola','1|dryck'),
('cocacola','1|dryck'),
('cocacola','1|dryck'),
('cocacola','1|dryck'),
('cocacola','1|dryck'),
('cocacola','1|dryck'),
('cocacola','1|dryck'),
('cochleaimplantat','1|hörapparat'),
('cochleaimplantat','1|hörapparat'),
('cockerspaniel','1|spaniel'),
('cockney','1|engelska'),
('cockpit','1|förarkabin'),
('cocktail','1|dryck'),
('cocktailbjudning','1|bjudning'),
('cocktailbord','1|bord'),
('cocktailbär','1|bär'),
('cocktailglas','1|glas'),
('cocktailmusik','1|musik'),
('cocktailparty','1|party'),
('coda','1|avslutning'),
('Cointreau','1|likör'),
('Cointreau','1|likör'),
('coitus','1|samlag'),
('collage','1|konstverk'),
('collage','1|konstverk'),
('college','1|högskola'),
('collegeflicka','1|flicka'),
('collegepojke','1|pojke'),
('collegetröja','1|tröja'),
('collie','1|hundras'),
('collier','1|halsband'),
('collier','1|halsband'),
('cologne','1|eau-de-cologne'),
('Colombia','1|land'),
('colombian','1|Colombia'),
('colombiansk','1|Colombia'),
('colombianska','1|colombian'),
('Colombo','1|huvudstad'),
('Colorado','1|delstat'),
('Coloradofloden','1|flod'),
('Colosseum','1|arena'),
('coltan','1|konfliktmineral'),
('Columbia','1|huvudstad'),
('Columbus','2|stad'),
('come-back','1|framträda'),
('come-back','1|framträda'),
('commando','1|elitsoldat'),
('commandotrupp','1|elitförband'),
('comme-il-faut','1|lämplig'),
('complet','1|måltid'),
('Concord','1|huvudstad'),
('Connecticut','1|delstat'),
('consensus','1|enighet'),
('consensus','1|enighet'),
('container','1|förvara'),
('containerfartyg','1|lastfartyg'),
('contortatall','1|tall'),
('cool','1|lugn'),
('cool','2|bra'),
('coolhet','1|cool'),
('coolhet','2|cool'),
('copycat','1|härma'),
('copycat','1|härma'),
('copyright','1|ensamrätt'),
('copywriter','1|reklam'),
('corioliskraft','1|kraft'),
('Cornelis','2|Escher'),
('cornflakes','1|majsflingor'),
('cornichon','1|gurka'),
('Cornwall','1|grevskap'),
('coronacell','1|cell'),
('corps-de-logi','1|huvudbyggnad'),
('cortex','1|bark'),
('cortical','1|cortex'),
('Coruna','1|stad'),
('cosinus','1|trigonometri'),
('costarican','1|Costa_Rica'),
('costaricansk','1|Costa_Rica'),
('costaricanska','1|costarican'),
('cotangens','1|trigonometri'),
('cotangent','1|cotangens'),
('coulomb','1|mått'),
('country','1|countrymusik'),
('countrymusik','1|folkmusik'),
('countrysång','1|sång'),
('coupe','1|efterrätt'),
('couronne','1|biljard'),
('courtage','1|mäklararvode'),
('courtage','1|mäklararvode'),
('couscous','1|maträtt'),
('couscous','1|maträtt'),
('cowboy','1|boskapsskötare'),
('cowboyhatt','1|hatt'),
('cover','1|musik'),
('coverlåt','1|cover'),
('coverversion','1|cover'),
('covra','1|cover'),
('coyote','1|prärievarg'),
('coyote','1|prärievarg'),
('cp','1|tokig'),
('cp','1|tokig'),
('cp','1|tokig'),
('cp-skadad','1|cerebral_pares'),
('cp-skadad','1|cerebral_pares'),
('cp-skadad','1|cerebral_pares'),
('crackers','1|kex'),
('crawl','1|simma'),
('crawla','1|crawl'),
('crawlande','1|crawla'),
('crazy','1|galen'),
('credo','1|tro'),
('crème-de-la-crème','1|societet'),
('crepe','1|pannkaka'),
('crepe','1|pannkaka'),
('crepe','1|pannkaka'),
('crêpegarn','1|garn'),
('crescendo','1|tilltagande'),
('crescendo','2|crescendo'),
('cricket','1|spel'),
('cricket','1|spel'),
('cricketklubba','1|klubba'),
('croissant','1|giffel'),
('crosschecking','1|ishockey'),
('crossglasögon','1|glasögon'),
('crosshandske','1|handske'),
('crosshjälm','1|hjälm'),
('croupier','1|roulett'),
('crust','1|musik'),
('csardas','1|dans'),
('cumulus','1|cumulusmoln'),
('cumuluscell','1|cell'),
('cumulusmoln','1|stackmoln'),
('cup','1|tävling'),
('Cupido','1|Amor'),
('curaçao','1|likör'),
('curare','1|gift'),
('curare','1|gift'),
('curia','1|hov'),
('curia','1|hov'),
('curia','2|domstol'),
('curia','2|domstol'),
('curie','1|mått'),
('curie','1|mått'),
('curium','1|grundämne'),
('curium','1|grundämne'),
('curla','1|curling'),
('curla','2|curlingförälder'),
('curlande','1|curla'),
('curlande','2|curla'),
('curling','1|sport'),
('curling','2|curlingförälder'),
('curlingbarn','1|barn'),
('curlingfinal','1|final'),
('curlingförälder','1|förälder'),
('curlingtävling','1|tävling'),
('curry','1|krydda'),
('curry','1|krydda'),
('currygryta','1|gryta'),
('C-vitamin','1|vitamin'),
('C-vitaminbrist','1|brist'),
('cyan','1|förening'),
('cyanblå','1|blå'),
('cyanid','1|salt'),
('cyankalium','1|gift'),
('cyanobakterie','1|bakterie'),
('cyanos','1|sjukdom'),
('cyanväte','1|väte'),
('cyanvätesyra','1|gift'),
('cyberbrottslighet','1|brottslighet'),
('cybernetik','1|vetenskap'),
('cybernetik','1|vetenskap'),
('cybernetisk','1|information'),
('cybernetisk','1|information'),
('cyberrymden','1|internet'),
('cybersex','1|sex'),
('cyberstrategi','1|strategi'),
('cybervåld','1|trakasseri'),
('cybervärlden','1|internet'),
('cyborg','1|robot'),
('cykel','1|åka'),
('cykel','2|omgång'),
('cykelbana','1|bana'),
('cykeldäck','1|däck'),
('cykelergometer','1|testcykel'),
('cykelhjälm','1|hjälm'),
('cykelkedja','1|kedja'),
('cykelklämma','1|byxklämma'),
('cykelkrock','1|krock'),
('cykelkrok','1|krok'),
('cykellykta','1|lykta'),
('cykellås','1|lås'),
('cykelnyckel','1|nyckel'),
('cykelpump','1|pump'),
('cykelram','1|ram'),
('cykelsadel','1|sadel'),
('cykelslang','1|slang'),
('cykelstyre','1|styre'),
('cykelställ','1|ställ'),
('cykelstöld','1|stöld'),
('cykeltrupp','1|förband'),
('cykeltävling','1|tävling'),
('cykelutflykt','1|utflykt'),
('cykelventil','1|luftventil'),
('cykelväg','1|väg'),
('cykelåkning','1|cykel'),
('cykla','1|cykel'),
('cyklamat','1|sötningsmedel'),
('cyklamen','1|krukväxt'),
('cyklande','1|cykla'),
('cykling','1|cykla'),
('cyklisk','1|cykel'),
('cyklism','1|cykla'),
('cyklist','1|cykel'),
('cykloid','1|kurva'),
('cyklometer','1|varvräknare'),
('cyklon','1|storm'),
('cyklon','2|centrifugera'),
('cyklonartad','1|cyklon'),
('cyklonfamilj','1|cyklon'),
('cyklop','1|jätte'),
('cyklop','2|cyklopöga'),
('cyklopisk','1|cyklop'),
('cyklopöga','1|sportdykning'),
('cyklotron','1|acceleration'),
('cyklotym','1|humör'),
('cylinder','1|rund'),
('cylinder','2|cylinder'),
('cylinderblock','1|förbränningsmotor'),
('cylinderform','1|form'),
('cylinderformad','1|cylinder'),
('cylinderglas','1|glasögon'),
('cylinderhatt','1|hatt'),
('cylinderlås','1|lås'),
('cylinderpress','1|tryck'),
('cylinderur','1|ur'),
('cylindrisk','1|cylinderformad'),
('cymbal','1|slaginstrument'),
('cymbalklang','1|klang'),
('cyniker','1|cynisk'),
('cynisk','1|känslokall'),
('cynism','1|cynisk'),
('Cypern','1|ö'),
('cypress','1|barrträd'),
('cypresskrans','1|krans'),
('cypriot','1|Cypern'),
('cypriotisk','1|Cypern'),
('cypriotiska','1|cypriot'),
('Cyrenaika','1|provins'),
('cysta','1|blåsa'),
('cystoskop','1|instrument'),
('cystoskopi','1|undersöka'),
('cytologi','1|vetenskap'),
('cytologisk','1|cell'),
('cytoplasma','1|cell'),
('d','1|bokstav'),
('d','2|ton'),
('Dacca','1|huvudstad'),
('Dacien','1|Rumänien'),
('dadaism','1|konstriktning'),
('dadaist','1|dadaism'),
('dadaistisk','1|dadaism'),
('dadda','1|barnsköterska'),
('dadda','2|småbarn'),
('daddande','1|dadda'),
('dadel','1|frukt'),
('dadelpalm','1|palm'),
('Daewoo','1|bilmärke'),
('dag','1|tid'),
('dag','2|tid'),
('dagakarl','1|daglönare'),
('dagakarl','1|daglönare'),
('dagaktiv','1|aktiv'),
('dagas','1|gry'),
('dagavdelning','1|sjukhus'),
('dagbarn','1|barnomsorg'),
('dagbarnvårdare','1|barnomsorg'),
('dagbefäl','1|befäl'),
('dagblad','1|dagstidning'),
('dagblind','1|synsjukdom'),
('dagblindhet','1|dagblind'),
('dagbok','1|skriva'),
('dagboksanteckning','1|anteckning'),
('dagboksskrivande','1|dagbok'),
('dagboksskrivande','2|dagbok'),
('dagbrott','1|dagbrytning'),
('dagbrytning','1|bryta'),
('dagbräckning','1|gryning'),
('dagcentral','1|pensionär'),
('dagcentrum','1|dagcentral'),
('dagdjur','1|djur'),
('dagdrivare','1|sysslolös'),
('dagdrivarliv','1|dagdrivare'),
('dagdriveri','1|dagdrivare'),
('dagdröm','1|dagdrömma'),
('dagdrömma','1|drömma'),
('dagdrömmande','1|dagdrömma'),
('dagdrömmare','1|dagdrömma'),
('dagdrömmeri','1|dagdrömma'),
('dagenefterhuvudvärk','1|huvudvärk'),
('dagenefterpiller','1|abortpiller'),
('dagenefterstämning','1|bakfull'),
('dagens','1|dagens_rätt'),
('dager','1|dag'),
('dagerrotyp','1|dagerrotypi'),
('dagerrotypi','1|fotografi'),
('dagfjäril','1|fjäril'),
('dagg','1|vatten'),
('dagg','2|blydagg'),
('dagga','1|dagg'),
('daggande','1|dagga'),
('daggdroppe','1|droppe'),
('daggert','1|dolk'),
('daggfrisk','1|fräsch'),
('daggig','1|dagg'),
('daggighet','1|daggig'),
('daggkåpa','1|växt'),
('daggmask','1|mask'),
('daggpunkt','1|dagg'),
('daggryning','1|dagning'),
('daggvåt','1|våt'),
('daghavande','1|jourhavande'),
('daghavande','2|daghavande'),
('daghem','1|barnomsorg'),
('daghemsföreståndare','1|föreståndare'),
('daghemsplats','1|dagisplats'),
('dagis','1|daghem'),
('dagisfröken','1|fröken'),
('dagisplats','1|dagis'),
('dagjämning','1|dygn'),
('dagjämningspunkt','1|punkt'),
('dagledig','1|ledig'),
('daglega','1|lega'),
('daglig','1|dag'),
('dagligdags','1|dagligen'),
('dagligen','1|daglig'),
('daglighet','1|daglig'),
('dagligstuga','1|vardagsrum'),
('dagligvara','1|vara'),
('daglön','1|lön'),
('daglönare','1|daglön'),
('dagmamma','1|barnomsorg'),
('dagning','1|gryning'),
('dago','1|dagdrivare'),
('dago','1|dagdrivare'),
('dagofficer','1|officer'),
('dagorder','1|order'),
('dagordning','1|program'),
('dagort','1|ort'),
('dagpenning','1|belopp'),
('dagpenning','1|belopp'),
('dagrum','1|rum'),
('dags','1|tidpunkt'),
('dagsaktuell','1|aktuell'),
('dagsbehov','1|behov'),
('dagsbot','1|dagsböter'),
('dagsböter','1|böter'),
('dagsedel','1|örfil'),
('dagsfärsk','1|färsk'),
('dagshetta','1|hetta'),
('dagskassa','1|inkomst'),
('dagskryssning','1|kryssning'),
('dagskrönika','1|krönika'),
('dagsled','1|vägsträcka'),
('dagsljus','1|dag'),
('dagslång','1|lång'),
('dagsläge','1|nu'),
('dagslända','1|kortlivad'),
('dagsländeliv','1|dagslända'),
('dagsmarsch','1|dagsled'),
('dagsmeja','1|tö'),
('dagsnyhet','1|nyhet'),
('dagsnyheter','1|rapport'),
('dagspolitisk','1|politisk'),
('dagspress','1|dagstidning'),
('dagsprogram','1|program'),
('dagsranson','1|ranson'),
('dagsregn','1|regn'),
('dagsresa','1|vägsträcka'),
('dagstemperatur','1|temperatur'),
('dagstidning','1|tidning'),
('dagstidningsredaktör','1|redaktör'),
('dagsverkare','1|daglönare'),
('dagsverke','1|arbete'),
('dagsvers','1|vers'),
('dagsversskribent','1|skribent'),
('dagsvärde','1|värde'),
('dagteckna','1|datera'),
('dagtecknande','1|dagteckna'),
('dagteckning','1|dagteckna'),
('dagtid','1|dag'),
('dagtinga','1|eftergift'),
('dagtingan','1|dagtinga'),
('dagtingande','1|dagtinga'),
('dagtraktamente','1|traktamente'),
('dagtåg','1|tåg'),
('dagvakt','1|vakt'),
('dagvatten','1|ytvatten'),
('dagvill','1|vilsen'),
('dagvillhet','1|dagvill'),
('dagvård','1|dagcentral'),
('dagöppning','1|gruvöppning'),
('dahlia','1|trädgårdsblomma'),
('dakapo','1|igen'),
('dakapo','1|igen'),
('dakapo','2|dakapo'),
('dakapo','2|dakapo'),
('Dakar','1|huvudstad'),
('daktyl','1|versfot'),
('daktylisk','1|daktyl'),
('dal','1|nere'),
('dala','1|sjunka'),
('Dalagatan','1|gata'),
('dalahäst','1|trähäst'),
('dalamässig','1|Dalarna'),
('dalande','1|dala'),
('Dalarna','1|landskap'),
('dalbo','1|dalslänning'),
('dalbotten','1|botten'),
('daldans','1|folkdans'),
('daldansen','1|uppror'),
('daler','1|mynt'),
('Dalgatan','1|gata'),
('dalgång','1|dal'),
('dalj','1|stryk'),
('dalkarl','1|Dalarna'),
('dalkjusa','1|dal'),
('dalkulla','1|dalmas'),
('Dallas','1|stad'),
('daller','1|dallring'),
('dallergräs','1|darrgräs'),
('dallra','1|darra'),
('dallrande','1|dallra'),
('dallring','1|dallra'),
('dalmas','1|dalkarl'),
('Dalmatien','1|Kroatien'),
('dalmatiner','1|hundras'),
('dalmål','1|dialekt'),
('dalmålning','1|väggbonad'),
('dalning','1|dala'),
('dalprofil','1|profil'),
('dalripa','1|ripa'),
('Dalsjöfors','1|ort'),
('dalsk','1|Dalarna'),
('dalska','1|dalmål'),
('dalskida','1|skida'),
('Dalsland','1|landskap'),
('dalsluttning','1|sluttning'),
('dalsländsk','1|Dalsland'),
('dalsländska','1|dalslänning'),
('dalsländska','2|dialekt'),
('dalslänning','1|Dalsland'),
('dalsänka','1|dal'),
('dalt','1|omsorg'),
('dalta','1|dalt'),
('daltande','1|dalta'),
('dalvind','1|vind'),
('Dalälven','1|älv'),
('dam','1|kvinna'),
('dam','2|spel'),
('dam','3|schackpjäs'),
('damask','1|kläder'),
('damaskenerklinga','1|sabelklinga'),
('damaskenerstål','1|stål'),
('damaskering','1|damaskenerstål'),
('Damaskus','1|huvudstad'),
('damast','1|vävnad'),
('damastduk','1|duk'),
('damastservett','1|servett'),
('dambesök','1|besök'),
('dambinda','1|sanitetsbinda'),
('dambjudning','1|bjudning'),
('dambricka','1|dam'),
('dambräde','1|bräde'),
('damcykel','1|cykel'),
('damejeanne','1|glasflaska'),
('damfotboll','1|fotboll'),
('damfrisering','1|frisera'),
('damfrisör','1|damfrisering'),
('damfrisörska','1|damfrisör'),
('damgambit','1|gambit'),
('damhandske','1|handske'),
('damhatt','1|hatt'),
('damig','1|dam'),
('damkonfektion','1|konfektion'),
('damkör','1|kör'),
('damlag','1|lag'),
('damlandslag','1|landslag'),
('damm','1|vatten'),
('damm','2|torr'),
('damm','3|fördämning'),
('damma','1|damm'),
('damma','2|avlägsna'),
('damma','3|åka'),
('dammande','1|damma'),
('dammande','2|damma'),
('dammande','3|damma'),
('dammanläggning','1|damm'),
('dammbindningsmedel','1|medel'),
('dammbygge','1|bygge'),
('dammfri','1|damm'),
('dammfäste','1|damm'),
('dammförsök','1|försök'),
('dammgömma','1|samla'),
('dammhöljd','1|dammig'),
('dammig','1|damm'),
('dammighet','1|dammig'),
('dammkorn','1|korn'),
('dammkvalster','1|kvalster'),
('dammlager','1|lager'),
('dammlucka','1|reglera'),
('dammlunga','1|sjukdom'),
('dammode','1|mode'),
('dammodell','1|modell'),
('dammoln','1|moln'),
('dammport','1|dammlucka'),
('dammpump','1|vattenpump'),
('dammråtta','1|damm'),
('dammspiral','1|damm'),
('dammsuga','1|avlägsna'),
('dammsugande','1|dammsuga'),
('dammsugaragent','1|agent'),
('dammsugare','1|dammsuga'),
('dammsugare','2|bakelse'),
('dammsugarförsäljning','1|försäljning'),
('dammsugarpåse','1|påse'),
('dammsugning','1|dammsuga'),
('dammsäkerhet','1|säkerhet'),
('dammtorka','1|avlägsna'),
('dammtorkande','1|dammtorka'),
('dammtrasa','1|trasa'),
('dammussla','1|mussla'),
('dammvippa','1|dammtorka'),
('dammvirvel','1|virvel'),
('damning','1|damma'),
('damoklessvärd','1|fara'),
('DAMP','1|sjukdom'),
('DAMP','1|sjukdom'),
('dampa','1|fukta'),
('dampa','2|DAMP'),
('dampande','1|dampa'),
('dampande','2|dampa'),
('dampjäs','1|dam'),
('damrum','1|toalett'),
('damsida','1|sida'),
('damsingel','1|singel'),
('damskjorta','1|skjorta'),
('damsko','1|sko'),
('damslalom','1|slalom'),
('damspel','1|dam'),
('damstrumpa','1|strumpa'),
('damsällskap','1|sällskap'),
('damtidning','1|tidning'),
('damtoalett','1|toalett'),
('damunderkläder','1|underkläder'),
('damur','1|ur'),
('damväska','1|handväska'),
('dan','1|dålig'),
('dan','1|dålig'),
('dana','1|skapa'),
('danaarv','1|arv'),
('danad','1|dana'),
('danande','1|dana'),
('danare','1|dana'),
('Dan-Axel','1|Broström'),
('dandy','1|snobb'),
('dangla','1|svänga'),
('danglande','1|dangla'),
('daning','1|dana'),
('danism','1|danska'),
('dank','1|ljus'),
('dank','2|metallkula'),
('Danmark','1|land'),
('Danmark-Skåne','1|Danmark'),
('Dannebrogen','1|flagga'),
('danneman','1|odalman'),
('dans','1|dansa'),
('dansa','1|röra'),
('dansande','1|dansa'),
('dansant','1|dansa'),
('dansare','1|dansör'),
('dansbana','1|dansgolv'),
('dansband','1|dansorkester'),
('dansbandskultur','1|kultur'),
('dansbandsvecka','1|vecka'),
('dansbaneelände','1|elände'),
('danserska','1|dansare'),
('dansförbud','1|förbud'),
('dansgille','1|gille'),
('dansgolv','1|golv'),
('dansgolvslejon','1|hejare'),
('danshak','1|dansställe'),
('dansk','1|Danmark'),
('dansk','2|Danmark'),
('dansk','3|danska'),
('danska','1|språk'),
('danska','2|dansk'),
('danskhat','1|hat'),
('danskhet','1|dansk'),
('danskhet','2|dansk'),
('danskonst','1|dansa'),
('dansktalande','1|danska'),
('danskägd','1|äga'),
('dansledare','1|ledare'),
('danslek','1|dans'),
('danslektion','1|lektion'),
('danslysten','1|dansa'),
('dansmusik','1|musik'),
('dansmässig','1|dans'),
('dansmästare','1|mästare'),
('dansorkester','1|orkester'),
('dansrestaurang','1|restaurang'),
('dansrytm','1|rytm'),
('danssalong','1|salong'),
('danssjuka','1|sjukdom'),
('danssko','1|sko'),
('dansskola','1|skola'),
('danssteg','1|steg'),
('dansställe','1|ställe'),
('danstakt','1|takt'),
('danstillställning','1|dans'),
('dansundervisning','1|undervisning'),
('dansvimmel','1|vimmel'),
('dansvänlig','1|passa'),
('dansör','1|dansa'),
('dansös','1|dansa'),
('Dante','1|författare'),
('Daphnia','1|kräftdjur'),
('daphnier','1|Daphnia'),
('darr','1|darra'),
('darra','1|röra'),
('darrande','1|darra'),
('darrande','2|darra'),
('darrgräs','1|gräs'),
('darrhänt','1|hand'),
('darrhänthet','1|darrhänt'),
('darrig','1|darra'),
('darrighet','1|darrig'),
('darrning','1|darra'),
('darrocka','1|rocka'),
('darrål','1|ål'),
('dart','1|pilkastning'),
('dartpil','1|pil'),
('dartspel','1|dart'),
('darttavla','1|dart'),
('darwinfink','1|fink'),
('darwinism','1|utvecklingslära'),
('darwinist','1|darwinism'),
('darwinistisk','1|darwinism'),
('dask','1|stryk'),
('daska','1|dask'),
('daskande','1|daska'),
('daskig','1|sjaskig'),
('daskighet','1|daskig'),
('dass','1|toalett'),
('dassa','1|mobbing'),
('dassande','1|dassa'),
('dassig','1|dålig'),
('dassighet','1|dassig'),
('dasspapper','1|toalettpapper'),
('dat','1|prestation'),
('data','1|faktum'),
('data','2|dator'),
('dataanläggning','1|dator'),
('databank','1|dataregister'),
('databas','1|förråd'),
('databearbetning','1|bearbeta'),
('databehandla','1|databehandling'),
('databehandlande','1|databehandla'),
('databehandling','1|behandling'),
('datacentral','1|central'),
('datafil','1|fil'),
('dataformat','1|format'),
('datahackare','1|hackare'),
('datahaveri','1|datorhaveri'),
('datainsamling','1|insamling'),
('datainsamlingskampanj','1|kampanj'),
('dataintensiv','1|data'),
('dataintrång','1|datorintrång'),
('dataintrångsskandal','1|skandal'),
('datakommunikation','1|kommunikation'),
('datakraft','1|datorkraft'),
('datakrasch','1|krasch'),
('datakörning','1|dator'),
('datalagring','1|lagring'),
('datalagringsdirektiv','1|direktiv'),
('datalagringsföretag','1|företag'),
('datalingvistik','1|vetenskap'),
('datalogi','1|databehandling'),
('datamaskin','1|dator'),
('datamaskinell','1|datamaskin'),
('datamaterial','1|data'),
('dataminne','1|datorminne'),
('datamängd','1|mängd'),
('datanät','1|kommunikation'),
('datapolitik','1|politik'),
('datapolitisk','1|datapolitik'),
('dataprogram','1|datorprogram'),
('dataregister','1|register'),
('datasimulering','1|datorsimulering'),
('dataskärm','1|bildskärm'),
('dataspel','1|spel'),
('dataterminal','1|terminal'),
('datautbyte','1|informationsutbyte'),
('datautbytesöverenskommelse','1|överenskommelse'),
('datavision','1|TV'),
('datera','1|datum'),
('daterande','1|datera'),
('daterbar','1|datera'),
('daterbarhet','1|daterbar'),
('datering','1|datera'),
('dateringsmetod','1|metod'),
('dativ','1|kasus'),
('dativform','1|dativ'),
('dativobjekt','1|objekt'),
('dato','1|datum'),
('dator','1|maskin'),
('datoradress','1|adress'),
('datoranimera','1|datoranimerad'),
('datoranimerad','1|animera'),
('datoranimerande','1|datoranimera'),
('datoranimering','1|datoranimera'),
('datoranläggning','1|dator'),
('datorbaserad','1|basera'),
('datorbearbetning','1|databearbetning'),
('datorbehandling','1|databehandling'),
('datorberäkning','1|beräkning'),
('datordrift','1|dator'),
('datorfodral','1|fodral'),
('datorförsäljning','1|försäljning'),
('datorglasögon','1|glasögon'),
('datorhaveri','1|haveri'),
('datorintrång','1|intrång'),
('datorisera','1|dator'),
('datoriserande','1|datorisera'),
('datoriserbar','1|datorisera'),
('datoriserbarhet','1|datoriserbar'),
('datorisering','1|dator'),
('datorkommunikation','1|kommunikation'),
('datorkraft','1|kraft'),
('datorlingvistik','1|datalingvistik'),
('datorminne','1|datalagring'),
('datormodell','1|modell'),
('datormässa','1|mässa'),
('datorprogram','1|program'),
('datorprogrammerare','1|programmerare'),
('datorrelaterad','1|dator'),
('datorsimulera','1|simulera'),
('datorsimulerande','1|datorsimulera'),
('datorsimulering','1|datorsimulera'),
('datorskärm','1|bildskärm'),
('datorsladd','1|sladd'),
('datorstöd','1|stöd'),
('datorsystem','1|dator'),
('datorsystem','1|dator'),
('datortelefon','1|smartphone'),
('datortomografi','1|tomografi'),
('datorutrustning','1|utrustning'),
('datorvirus','1|datorprogram'),
('datorvirus','1|datorprogram'),
('datoväxel','1|växel'),
('Datsun','1|bilmärke'),
('datta','1|slå'),
('dattande','1|datta'),
('datten','1|tafatt'),
('datum','1|dag'),
('datumgräns','1|meridian'),
('datummärka','1|märka'),
('datummärkande','1|datummärka'),
('datummärkning','1|datummärka'),
('datumparkera','1|datumparkering'),
('datumparkerande','1|datumparkera'),
('datumparkerbar','1|datumparkera'),
('datumparkerbarhet','1|datumparkerbar'),
('datumparkering','1|parkering'),
('datumstämpel','1|datummärkning'),
('datumvisare','1|visa'),
('davidsstjärna','1|tecken'),
('DDR','1|Östtyskland'),
('DDT','1|gift'),
('de','1|vem'),
('deadline','1|tidsgräns'),
('deaktivera','1|inaktivera'),
('deaktiverande','1|deaktivera'),
('deaktiverbar','1|deaktivera'),
('deaktiverbarhet','1|deaktiverbar'),
('deaktivering','1|deaktivera'),
('debacle','1|misslyckande'),
('debarkera','1|i_land'),
('debarkerande','1|debarkera'),
('debarkerbar','1|debarkera'),
('debarkerbarhet','1|debarkerbar'),
('debarkering','1|debarkera'),
('debatt','1|diskutera'),
('debattartikel','1|artikel'),
('debattdeltagare','1|debattör'),
('debattera','1|debatt'),
('debatterande','1|debattera'),
('debatterbar','1|debattera'),
('debatterbarhet','1|debatterbar'),
('debattering','1|debattera'),
('debattforum','1|forum'),
('debattinlägg','1|inlägg'),
('debattknep','1|knep'),
('debattmässig','1|debatt'),
('debattprogram','1|TV-program'),
('debattsida','1|sida'),
('debattör','1|debatt'),
('debet','1|skuld'),
('debetsedel','1|skattsedel'),
('debetsida','1|debet'),
('debetsumma','1|debet'),
('debil','1|efterbliven'),
('debilitet','1|debil'),
('debit','1|bokföring'),
('debitera','1|fordra'),
('debiterande','1|debitera'),
('debiterbar','1|debitera'),
('debiterbarhet','1|debiterbar'),
('debitering','1|debit'),
('debut','1|först'),
('debutalbum','1|album'),
('debutant','1|debut'),
('debutbok','1|bok'),
('debutera','1|debut'),
('debuterande','1|debutera'),
('debutering','1|debutera'),
('debutroman','1|roman'),
('Decamerone','1|novellsamling'),
('december','1|månad'),
('decemberkväll','1|kväll'),
('decennium','1|årtionde'),
('decentralisation','1|decentralisering'),
('decentralisera','1|sprida'),
('decentraliserande','1|decentralisera'),
('decentraliserbar','1|decentralisera'),
('decentraliserbarhet','1|decentraliserbar'),
('decentralisering','1|decentralisera'),
('decharge','1|ansvarsfrihet'),
('dechargedebatt','1|debatt'),
('dechiffrera','1|uttolka'),
('dechiffrerande','1|dechiffrera'),
('dechiffrerbar','1|dechiffrera'),
('dechiffrerbarhet','1|dechiffrerbar'),
('dechiffrering','1|dechiffrera'),
('decibel','1|mått'),
('deciderad','1|bestämd'),
('deciliter','1|liter'),
('deciliter','1|liter'),
('decilitermått','1|mått'),
('decimal','1|tio'),
('decimalbråk','1|bråk'),
('decimalkomma','1|komma'),
('decimalsystem','1|talsystem'),
('decimaltal','1|decimalbråk'),
('decimaltecken','1|tecken'),
('decimera','1|minska'),
('decimerande','1|decimera'),
('decimerbar','1|decimera'),
('decimerbarhet','1|decimerbar'),
('decimering','1|decimera'),
('decimeter','1|meter'),
('decimeterlång','1|lång'),
('decimeterstor','1|stor'),
('deciton','1|ton'),
('deckardrottning','1|deckarförfattare'),
('deckare','1|detektivberättelse'),
('deckare','2|detektiv'),
('deckarförfattare','1|författare'),
('deckarkung','1|deckarförfattare'),
('dedicera','1|tillägna'),
('dedicera','1|tillägna'),
('dedicerande','1|dedicera'),
('dedicerande','1|dedicera'),
('dedicerbar','1|dedicera'),
('dedicerbar','1|dedicera'),
('dedicerbarhet','1|dedicerbar'),
('dedicerbarhet','1|dedicerbar'),
('dedicering','1|dedicera'),
('dedicering','1|dedicera'),
('dedikation','1|dedicera'),
('dedikationsexemplar','1|exemplar'),
('deducera','1|härleda'),
('deducerande','1|deducera'),
('deducerbar','1|deducera'),
('deducerbarhet','1|deducerbar'),
('deducering','1|deducera'),
('deduktion','1|deducera'),
('deduktiv','1|deducera'),
('defaitism','1|hopplöshet'),
('defaitist','1|defaitism'),
('defaitistisk','1|defaitism'),
('defekt','1|skada'),
('defekt','2|defekt'),
('defenestrera','1|avrätta'),
('defensiv','1|försvara'),
('defensiv','2|defensiv'),
('defenstrerande','1|defenestrera'),
('defenstrering','1|defenestrera'),
('defibrillator','1|hjärtflimmer'),
('deficit','1|brist'),
('defilé','1|defilera'),
('defilé','2|passage'),
('defilera','1|marschera'),
('defilerande','1|defilera'),
('defilerbar','1|defilera'),
('defilerbarhet','1|defilerbar'),
('defilering','1|defilera'),
('definiera','1|bestämma'),
('definierande','1|definiera'),
('definierbar','1|definiera'),
('definierbarhet','1|definierbar'),
('definiering','1|definiera'),
('definit','1|pronomen'),
('definithet','1|definit'),
('definition','1|definiera'),
('definitionsmängd','1|matematik'),
('definitionsmässig','1|definition'),
('definitionsmässighet','1|definitionsmässig'),
('definitiv','1|bestämma'),
('deflagration','1|explosion'),
('deflation','1|sänka'),
('defloration','1|deflorera'),
('deflorera','1|mödomshinna'),
('deflorerande','1|deflorera'),
('deflorerbar','1|deflorera'),
('deflorerbarhet','1|deflorerbar'),
('deflorering','1|deflorera'),
('deformation','1|deformera'),
('deformera','1|förändra'),
('deformerande','1|deformera'),
('deformerbar','1|deformera'),
('deformerbarhet','1|deformerbar'),
('deformering','1|deformera'),
('deformitet','1|missbildning'),
('defroster','1|frosta_av'),
('deg','1|baka'),
('deg','2|pengar'),
('dega','1|dagdrivare'),
('degande','1|dega'),
('degartad','1|deg'),
('degel','1|skål'),
('degeneration','1|degenerera'),
('degenerativ','1|degenerera'),
('degenerera','1|utveckla'),
('degenererande','1|degenerera'),
('degenererbar','1|degenerera'),
('degenererbarhet','1|degenererbar'),
('degenerering','1|degenerera'),
('Degerfors','1|ort'),
('degig','1|deg'),
('deglaciation','1|avsmältning'),
('degradation','1|vittring'),
('degradera','1|status'),
('degraderande','1|degradera'),
('degraderbar','1|degradera'),
('degraderbarhet','1|degraderbar'),
('degradering','1|degradera'),
('degrand','1|bröd'),
('degression','1|avta'),
('degspad','1|spad'),
('degspade','1|spade'),
('degustera','1|avsmaka'),
('degusterande','1|degustera'),
('degustering','1|degustera'),
('deiktisk','1|utpeka'),
('Deimos','1|måne'),
('deism','1|religion'),
('deist','1|deism'),
('deistisk','1|deism'),
('deja','1|piga'),
('dejlig','1|vacker'),
('dejlighet','1|dejlig'),
('dejsa','1|driva'),
('dejsande','1|dejsa'),
('dejt','1|möte'),
('dejt','1|möte'),
('dejt','2|partner'),
('dejt','2|partner'),
('dejta','1|dejt'),
('dejtande','1|dejta'),
('dejting','1|dejta'),
('dejtingsajt','1|sajt'),
('dejtingtips','1|tips'),
('dekad','1|tio'),
('dekadens','1|dekadent'),
('dekadens','1|dekadent'),
('dekadent','1|förfalla'),
('dekadisk','1|dekad'),
('dekal','1|bild'),
('dekalkomani','1|bild'),
('dekalogen','1|budord'),
('dekan','1|ordförande'),
('dekanat','1|dekan'),
('dekantera','1|öppna'),
('dekanterande','1|dekantera'),
('dekanterbar','1|dekantera'),
('dekanterbarhet','1|dekanterbar'),
('dekantering','1|dekantera'),
('dekanus','1|dekan'),
('dekapitera','1|halshugga'),
('dekapiterande','1|dekapitera'),
('dekapiterbar','1|dekapitera'),
('dekapiterbarhet','1|dekapiterbar'),
('dekapitering','1|dekapitera'),
('deklamation','1|deklamera'),
('deklamatorisk','1|deklamera'),
('deklamatör','1|deklamera'),
('deklamera','1|läsa_upp'),
('deklamerande','1|deklamera'),
('deklamerbar','1|deklamera'),
('deklamerbarhet','1|deklamerbar'),
('deklamering','1|deklamera'),
('deklarant','1|deklarera'),
('deklaration','1|deklarera'),
('deklarationsblankett','1|blankett'),
('deklarationsdags','1|dags'),
('deklarera','1|tillkännage'),
('deklarerande','1|deklarera'),
('deklarerbar','1|deklarera'),
('deklarerbarhet','1|deklarerbar'),
('deklarering','1|deklarera'),
('deklassera','1|status'),
('deklasserande','1|deklassera'),
('deklasserbar','1|deklassera'),
('deklasserbarhet','1|deklasserbar'),
('deklassering','1|deklassera'),
('deklination','1|böja'),
('deklination','2|missvisning'),
('deklination','3|astronomi'),
('deklinationsnål','1|kompassnål'),
('deklinera','1|deklination'),
('deklinera','2|deklination'),
('deklinera','3|försämra'),
('deklinerande','1|deklinera'),
('deklinerande','2|deklinera'),
('deklinerande','3|deklinera'),
('deklinerbar','1|deklinera'),
('deklinerbar','2|deklinera'),
('deklinerbar','3|deklinera'),
('deklinerbarhet','1|deklinerbar'),
('deklinerbarhet','2|deklinerbar'),
('deklinerbarhet','3|deklinerbar'),
('deklinering','1|deklinera'),
('deklinering','2|deklinera'),
('deklinering','3|deklinera'),
('dekokt','1|medicin'),
('dekolletage','1|urringning'),
('dekolleterad','1|dekolletage'),
('dekolletering','1|dekolletage'),
('dekomposition','1|sönderdelning'),
('dekompression','1|tryckkammare'),
('dekor','1|dekoration'),
('dekoration','1|dekorera'),
('dekoration','2|dekorera'),
('dekorationsbrasa','1|brasa'),
('dekorationsgran','1|julgran'),
('dekorationslist','1|list'),
('dekorationsmålare','1|dekorationsmålning'),
('dekorationsmålning','1|måla'),
('dekorativ','1|pryda'),
('dekoratör','1|dekorera'),
('dekorera','1|pryda'),
('dekorera','2|orden'),
('dekorerande','1|dekorera'),
('dekorerande','2|dekorera'),
('dekorerbar','1|dekorera'),
('dekorerbar','2|dekorera'),
('dekorerbarhet','1|dekorerbar'),
('dekorerbarhet','2|dekorerbar'),
('dekorering','1|dekorera'),
('dekorglans','1|glans'),
('dekorputs','1|puts'),
('dekorum','1|uppförande'),
('dekouragera','1|avskräcka'),
('dekouragerande','1|dekouragera'),
('dekouragerbar','1|dekouragera'),
('dekouragerbarhet','1|dekouragerbar'),
('dekouragering','1|dekouragera'),
('dekret','1|befallning'),
('dekretera','1|dekret'),
('dekreterande','1|dekretera'),
('dekreterbar','1|dekretera'),
('dekreterbarhet','1|dekreterbar'),
('dekretering','1|dekretera'),
('del','1|hel'),
('dela','1|del'),
('dela','2|del'),
('delabialiserad','1|labialiserad'),
('delad','1|kluven'),
('delaktig','1|delta'),
('delaktighet','1|delaktig'),
('delande','1|dela'),
('delande','2|dela'),
('delativ','1|kasus'),
('Delaware','1|delstat'),
('delbar','1|dela'),
('delbarhet','1|delbar'),
('delbetala','1|delbetalning'),
('delbetalande','1|delbetala'),
('delbetalning','1|betalning'),
('delegat','1|ombud'),
('delegation','1|delegat'),
('delegation','2|delegera'),
('delegera','1|befogenhet'),
('delegerande','1|delegera'),
('delegerbar','1|delegera'),
('delegerbarhet','1|delegerbar'),
('delegering','1|delegera'),
('Delfi','1|orakel'),
('delfin','1|djur'),
('delfinansiera','1|finansiera'),
('delfinansierande','1|delfinansiera'),
('delfinansiering','1|delfinansiera'),
('delfinsprång','1|språng'),
('Delftporslin','1|porslin'),
('delfående','1|meddelande'),
('delge','1|meddela'),
('delgivande','1|delge'),
('delgivning','1|delge'),
('delgivningsman','1|delgivning'),
('Delhi','1|stad'),
('deliciös','1|läcker'),
('delikat','1|läcker'),
('delikat','2|känslig'),
('delikatess','1|delikat'),
('delikatessdisk','1|försäljningsdisk'),
('delikatessjäv','1|jäv'),
('delikt','1|brottsling'),
('delinkvent','1|straff'),
('delirant','1|delirium'),
('delirium','1|alkoholism'),
('delkaskoförsäkring','1|kaskoförsäkring'),
('delkategori','1|kategori'),
('delkultur','1|kultur'),
('dellikvid','1|delbetalning'),
('delmängd','1|mängd'),
('delning','1|dela'),
('delningslinje','1|linje'),
('delningspunkt','1|punkt'),
('delningsstreck','1|streck'),
('delningssätt','1|sätt'),
('delperiod','1|period'),
('delprojekt','1|projekt'),
('delrepublik','1|republik'),
('dels','1|del'),
('delstat','1|stat'),
('delstatlig','1|delstat'),
('delstatsregering','1|regering'),
('delstreck','1|skala'),
('delsträcka','1|sträcka'),
('delta','1|med'),
('delta','2|mynning'),
('delta','3|bokstav'),
('deltaformad','1|delta'),
('deltagande','1|delta'),
('deltagande','2|medkänsla'),
('deltagande','3|medkänsla'),
('deltagare','1|delta'),
('deltakrokodil','1|saltvattenskrokodil'),
('deltamuskel','1|muskel'),
('deltavinge','1|flygplansvinge'),
('deltid','1|arbetstid'),
('deltidare','1|deltidsanställd'),
('deltidsanställd','1|anställd'),
('deltidsarbeta','1|arbeta'),
('deltidsarbetande','1|deltidsarbeta'),
('deltidsarbete','1|deltidsarbeta'),
('deltidsarbetslös','1|arbetslös'),
('deltidsarbetslöshet','1|deltidsarbetslös'),
('deltidssjuk','1|deltidssjukskriven'),
('deltidssjukskriven','1|sjukskriva'),
('deltävling','1|tävling'),
('delvis','1|del'),
('delvis','2|delvis'),
('delägare','1|ägare'),
('dema','1|demonstrera'),
('demagog','1|argumentera'),
('demagogi','1|demagog'),
('demagogisk','1|demagog'),
('demande','1|dema'),
('demarkationslinje','1|gräns'),
('demarsch','1|hänvändelse'),
('demaskera','1|avslöja'),
('demaskerande','1|demaskera'),
('demaskerbar','1|demaskera'),
('demaskerbarhet','1|demaskerbar'),
('demaskering','1|demaskera'),
('demens','1|sjukdom'),
('demenshandikapp','1|handikapp'),
('demenspatient','1|patient'),
('demensrelaterad','1|gälla'),
('demensrisk','1|risk'),
('demenssjuk','1|dement'),
('demenssjukdom','1|demens'),
('demensutveckling','1|utveckling'),
('dement','1|demens'),
('dementera','1|förneka'),
('dementerande','1|dementera'),
('dementerbar','1|dementera'),
('dementerbarhet','1|dementerbar'),
('dementering','1|dementera'),
('dementi','1|dementera'),
('demeriterande','1|merit'),
('demilitarisera','1|avlägsna'),
('demilitariserande','1|demilitarisera'),
('demilitariserbar','1|demilitarisera'),
('demilitariserbarhet','1|demilitariserbar'),
('demilitarisering','1|demilitarisera'),
('demimond','1|prostituerad'),
('demi-sec','1|halvtorr'),
('demission','1|avgå'),
('demissionera','1|demission'),
('demissionerande','1|demissionera'),
('demissionering','1|demissionera'),
('demiurg','1|väsen'),
('demo','1|demonstrera'),
('demobilisera','1|upphäva'),
('demobiliserande','1|demobilisera'),
('demobiliserbar','1|demobilisera'),
('demobiliserbarhet','1|demobiliserbar'),
('demobilisering','1|demobilisera'),
('demoeffekt','1|misslyckas'),
('demografi','1|vetenskap'),
('demografisk','1|befolkning'),
('demoinspelning','1|inspelning'),
('demokrat','1|demokrati'),
('demokrati','1|styra'),
('demokratibygge','1|skapa'),
('demokratiförespråkare','1|förespråkare'),
('demokratiförkämpe','1|förkämpe'),
('demokratirörelse','1|rörelse'),
('demokratisera','1|demokrati'),
('demokratiserande','1|demokratisera'),
('demokratiserbar','1|demokratisera'),
('demokratiserbarhet','1|demokratiserbar'),
('demokratisering','1|demokratisera'),
('demokratiseringsprocess','1|demokratisering'),
('demokratisk','1|demokrati'),
('demokratism','1|demokrati'),
('demokratisnack','1|snack'),
('demokratiutveckling','1|utveckling'),
('Demokritos','1|filosof'),
('demolera','1|förstöra'),
('demolerande','1|demolera'),
('demolerbar','1|demolera'),
('demolerbarhet','1|demolerbar'),
('demolering','1|demolera'),
('demon','1|väsen'),
('demoni','1|demon'),
('demonisera','1|demonisk'),
('demoniserande','1|demonisera'),
('demoniserbar','1|demonisera'),
('demoniserbarhet','1|demoniserbar'),
('demonisering','1|demonisera'),
('demonisk','1|demon'),
('demonologi','1|lära'),
('demonologisk','1|demonologi'),
('demonregissör','1|regissör'),
('demonstrant','1|demonstrera'),
('demonstration','1|demonstrera'),
('demonstration','2|demonstrera'),
('demonstration','3|demonstrera'),
('demonstrationsfrihet','1|frihet'),
('demonstrationstillstånd','1|tillstånd'),
('demonstrationståg','1|tåg'),
('demonstrativ','1|demonstrera'),
('demonstrativpronomen','1|pronomen'),
('demonstratris','1|demonstratör'),
('demonstratör','1|demonstrera'),
('demonstrera','1|visa'),
('demonstrera','2|förevisa'),
('demonstrera','3|åsiktsyttring'),
('demonstrerande','1|demonstrera'),
('demonstrerande','2|demonstrera'),
('demonstrerande','3|demonstrera'),
('demonstrerbar','1|demonstrera'),
('demonstrerbar','2|demonstrera'),
('demonstrerbarhet','1|demonstrerbar'),
('demonstrerbarhet','2|demonstrerbar'),
('demonstrering','1|demonstrera'),
('demonstrering','2|demonstrera'),
('demontera','1|isär'),
('demonterande','1|demontera'),
('demonterbar','1|demontera'),
('demonterbarhet','1|demonterbar'),
('demontering','1|demontera'),
('demonåkallan','1|åkallan'),
('demoralisation','1|demoralisera'),
('demoralisera','1|förstöra'),
('demoraliserande','1|demoralisera'),
('demoraliserbar','1|demoralisera'),
('demoraliserbarhet','1|demoraliserbar'),
('demoralisering','1|demoralisera'),
('Demosthenes','1|vältalare'),
('demotape','1|demoinspelning'),
('den','1|vad'),
('den','2|vem'),
('denar','1|mynt'),
('denaturalisation','1|denaturalisera'),
('denaturalisera','1|beröva'),
('denaturaliserande','1|denaturalisera'),
('denaturaliserbar','1|denaturalisera'),
('denaturaliserbarhet','1|denaturaliserbar'),
('denaturalisering','1|denaturalisera'),
('denaturera','1|förändra'),
('denaturerande','1|denaturera'),
('denaturerbar','1|denaturera'),
('denaturerbarhet','1|denaturerbar'),
('denaturering','1|denaturera'),
('dendrit','1|nerv'),
('dendrokronologi','1|kronologi'),
('dendrokronologisk','1|dendrokronologi'),
('dendrolog','1|dendrologi'),
('dendrologi','1|vetenskap'),
('denier','1|grovlek'),
('denim','1|tyg'),
('denna','1|den'),
('dennes','1|månad'),
('denotation','1|grundbetydelse'),
('denotativ','1|denotation'),
('denotera','1|denotation'),
('denoterande','1|denotera'),
('denoterbar','1|denotera'),
('denoterbarhet','1|denoterbar'),
('denotering','1|denotera'),
('densamma','1|samma'),
('densitet','1|täthet'),
('densitometer','1|fotografi'),
('densometer','1|densitometer'),
('dental','1|tand'),
('dental','2|konsonant'),
('dentalljud','1|dental'),
('dentist','1|tandtekniker'),
('denudation','1|denudera'),
('denudera','1|erosion'),
('denuderande','1|denudera'),
('denuderbar','1|denudera'),
('denuderbarhet','1|denuderbar'),
('denudering','1|denudera'),
('denukleariserad','1|denuklearisering'),
('denuklearisering','1|nedrustning'),
('Denver','1|huvudstad'),
('deodorant','1|avlägsna'),
('deodorisera','1|deodorant'),
('deodoriserande','1|deodorisera'),
('deodoriserbar','1|deodorisera'),
('deodoriserbarhet','1|deodoriserbar'),
('deodorisering','1|deodorisera'),
('departement','1|avdelning'),
('departemental','1|departement'),
('departementschef','1|chef'),
('departementsråd','1|tjänsteman'),
('departementsärende','1|ärende'),
('depatriera','1|beröva'),
('depatrierande','1|depatriera'),
('depatrierbar','1|depatriera'),
('depatrierbarhet','1|depatrierbar'),
('depatriering','1|depatriera'),
('dependens','1|avhängighet'),
('depens','1|utgift'),
('depensera','1|depens'),
('depenserande','1|depensera'),
('depenserbar','1|depensera'),
('depenserbarhet','1|depenserbar'),
('depensering','1|depensera'),
('depersonalisation','1|främlingskap'),
('depesch','1|skrivelse'),
('depeschbyrå','1|tidning'),
('deplacement','1|vikt'),
('deplacera','1|deplacement'),
('deplacerande','1|deplacera'),
('deplacerbar','1|deplacera'),
('deplacerbarhet','1|deplacerbar'),
('deplacering','1|deplacera'),
('depolarisator','1|motverka'),
('deponens','1|verb'),
('deponent','1|deponera'),
('deponentiell','1|deponens'),
('deponera','1|förvara'),
('deponerande','1|deponera'),
('deponerbar','1|deponera'),
('deponerbarhet','1|deponerbar'),
('deponering','1|deponera'),
('deponi','1|soptipp'),
('deportation','1|deportera'),
('deportationsort','1|ort'),
('deportera','1|förflytta'),
('deporterande','1|deportera'),
('deporterbar','1|deportera'),
('deporterbarhet','1|deporterbar'),
('deportering','1|deportera'),
('deposition','1|deponera'),
('depositionsbevis','1|bevis'),
('depositum','1|deponera'),
('deppa','1|ledsen'),
('deppad','1|deppa'),
('deppande','1|deppa'),
('deppig','1|deppa'),
('deppighet','1|deppig'),
('depprock','1|svartrock'),
('depprockare','1|depprock'),
('depravation','1|depraverad'),
('depraverad','1|förfalla'),
('depreciera','1|devalvera'),
('deprecierande','1|depreciera'),
('deprecierbar','1|depreciera'),
('deprecierbarhet','1|deprecierbar'),
('depreciering','1|depreciera'),
('depression','1|mentalsjukdom'),
('depression','2|lågkonjunktur'),
('depressionsdiagnos','1|diagnos'),
('depressionssymtom','1|symtom'),
('depressiv','1|depression'),
('deprimerad','1|ledsen'),
('deprimerande','1|deprimerad'),
('deprivation','1|avbryta'),
('deputation','1|ombud'),
('deputerad','1|deputation'),
('depå','1|förråd'),
('depåfynd','1|fynd'),
('depåstöd','1|stöd'),
('derangera','1|oordnad'),
('derangerande','1|derangera'),
('derangerbar','1|derangera'),
('derangerbarhet','1|derangerbar'),
('derangering','1|derangera'),
('derby','1|hästkapplöpning'),
('derby','2|seriematch'),
('derivat','1|förening'),
('derivata','1|matematik'),
('derivation','1|derivera'),
('derivation','2|avledning'),
('derivera','1|derivata'),
('deriverande','1|derivera'),
('deriverbar','1|derivera'),
('deriverbarhet','1|deriverbar'),
('derivering','1|derivera'),
('dermatit','1|hudinflammation'),
('dermatolog','1|dermatologi'),
('dermatologi','1|vetenskap'),
('dermatologisk','1|hudsjukdom'),
('dermatos','1|hudsjukdom'),
('dervisch','1|munk'),
('dervischdans','1|dans'),
('desarmera','1|avväpna'),
('desarmerande','1|desarmera'),
('desarmerbar','1|desarmera'),
('desarmerbarhet','1|desarmerbar'),
('desarmering','1|desarmera'),
('desavouera','1|förneka'),
('desavouerande','1|desavouera'),
('desavouerbar','1|desavouera'),
('desavouerbarhet','1|desavouerbar'),
('desavouering','1|desavouera'),
('descendens','1|härstamma'),
('descendent','1|ättling'),
('desegregation','1|avlägsna'),
('desengagemang','1|avveckla'),
('desensibilisera','1|allergi'),
('desensibiliserande','1|desensibilisera'),
('desensibiliserbar','1|desensibilisera'),
('desensibiliserbarhet','1|desensibiliserbar'),
('desensibilisering','1|desensibilisera'),
('desertera','1|rymma'),
('deserterande','1|desertera'),
('desertering','1|desertera'),
('desertör','1|desertera'),
('deshabillé','1|klädsel'),
('design','1|formgivning'),
('designa','1|design'),
('designande','1|designa'),
('designer','1|design'),
('designera','1|designa'),
('designerande','1|designera'),
('designerbar','1|designera'),
('designerbarhet','1|designerbar'),
('designering','1|designera'),
('designmässig','1|design'),
('designskola','1|skola'),
('designstudent','1|designskola'),
('designtävling','1|tävling'),
('desillusion','1|besvikelse'),
('desillusionerad','1|desillusion'),
('desinfektion','1|desinficera'),
('desinfektionsmedel','1|medel'),
('desinfektör','1|desinficera'),
('desinficera','1|avlägsna'),
('desinficera','1|avlägsna'),
('desinficerande','1|desinficera'),
('desinficerande','1|desinficera'),
('desinficerbar','1|desinficera'),
('desinficerbar','1|desinficera'),
('desinficerbarhet','1|desinficerbar'),
('desinficerbarhet','1|desinficerbar'),
('desinficering','1|desinficera'),
('desinficering','1|desinficera'),
('desinficeringsmedel','1|medel'),
('desinformation','1|desinformera'),
('desinformera','1|missleda'),
('desinformerande','1|desinformera'),
('desinformerbar','1|desinformera'),
('desinformerbarhet','1|desinformerbar'),
('desinformering','1|desinformera'),
('desinsektion','1|utrota'),
('desintegration','1|sönderdelning'),
('desintresserad','1|ointresserad'),
('deskription','1|deskriptiv'),
('deskriptiv','1|beskriva'),
('deskriptor','1|beskriva'),
('desorganisation','1|desorganisera'),
('desorganisera','1|oordnad'),
('desorganiserande','1|desorganisera'),
('desorganiserbar','1|desorganisera'),
('desorganiserbarhet','1|desorganiserbar'),
('desorganisering','1|desorganisera'),
('desorienterad','1|bortkommen'),
('desorientering','1|desorienterad'),
('DeSoto','1|bilmärke'),
('desperado','1|våldsman'),
('desperat','1|förtvivlad'),
('desperation','1|desperat'),
('despot','1|ledare'),
('despoti','1|despot'),
('despotisk','1|despot'),
('despotism','1|despot'),
('dessbättre','1|lyckligtvis'),
('dessbättre','1|lyckligtvis'),
('dessemellan','1|under'),
('dessert','1|efterrätt'),
('dessertfrukt','1|frukt'),
('dessertgaffel','1|gaffel'),
('dessertkniv','1|kniv'),
('dessertost','1|ost'),
('dessertsked','1|sked'),
('dessertskål','1|skål'),
('dessertsås','1|sås'),
('desserttallrik','1|tallrik'),
('dessertvin','1|vin'),
('dessförinnan','1|innan'),
('dessförutan','1|utan'),
('dessinatör','1|rita'),
('desslikes','1|likaså'),
('dessutom','1|också'),
('dessvärre','1|tyvärr'),
('dessvärre','1|tyvärr'),
('dessäng','1|plan'),
('destabilisera','1|instabil'),
('destabiliserande','1|destabilisera'),
('destabiliserande','2|destabilisera'),
('destabiliserbar','1|destabilisera'),
('destabiliserbarhet','1|destabiliserbar'),
('destillat','1|destillera'),
('destillation','1|destillera'),
('destillationsapparat','1|apparat'),
('destillera','1|koka'),
('destillerande','1|destillera'),
('destillerbar','1|destillera'),
('destillerbarhet','1|destillerbar'),
('destillering','1|destillera'),
('destination','1|mål'),
('destinationshamn','1|hamn'),
('destinationsort','1|destination'),
('destinatär','1|mottagare'),
('destinatör','1|avsändare'),
('destinera','1|förutbestämd'),
('destinerande','1|destinera'),
('destinerbar','1|destinera'),
('destinerbarhet','1|destinerbar'),
('destinering','1|destinera'),
('desto','1|mycken'),
('destruent','1|bryta_ned'),
('destruera','1|förstöra'),
('destruerande','1|destruera'),
('destruerbar','1|destruera'),
('destruerbarhet','1|destruerbar'),
('destruering','1|destruera'),
('destruktion','1|destruera'),
('destruktionsanläggning','1|anläggning'),
('destruktiv','1|destruera'),
('detachement','1|truppstyrka'),
('detachera','1|detachement'),
('detacherande','1|detachera'),
('detacherbar','1|detachera'),
('detacherbarhet','1|detacherbar'),
('detachering','1|detachera'),
('detachör','1|avlägsna'),
('detalj','1|del'),
('detaljanmärkning','1|anmärkning'),
('detaljarbete','1|arbete'),
('detaljbestämmelse','1|bestämmelse'),
('detaljerad','1|utförlig'),
('detaljering','1|detaljerad'),
('detaljfattig','1|detalj'),
('detaljfattigdom','1|detaljfattig'),
('detaljfixerad','1|fixerad'),
('detaljfråga','1|fråga'),
('detaljgranska','1|granska'),
('detaljgranskande','1|detaljgranska'),
('detaljhandel','1|handel'),
('detaljhandlare','1|detaljhandel'),
('detaljist','1|detaljhandlare'),
('detaljkarta','1|karta'),
('detaljkunskap','1|kunskap'),
('detaljkännedom','1|kännedom'),
('detaljplan','1|stadsplan'),
('detaljpris','1|konsumentpris'),
('detaljreglera','1|reglera'),
('detaljreglerande','1|detaljreglera'),
('detaljreglerbar','1|detaljreglera'),
('detaljreglerbarhet','1|detaljreglerbar'),
('detaljreglering','1|detaljreglera'),
('detaljrik','1|detalj'),
('detaljrikedom','1|detaljrik'),
('detaljrikhet','1|detaljrik'),
('detaljritning','1|ritning'),
('detaljskärpa','1|skärpa'),
('detaljstudium','1|studium'),
('detaljstyra','1|styra'),
('detaljstyrande','1|detaljstyra'),
('detaljstyrning','1|detaljstyra'),
('detaljuppgift','1|uppgift'),
('detaljutförande','1|utföra'),
('detektera','1|påvisa'),
('detekterande','1|detektera'),
('detekterbar','1|detektera'),
('detekterbarhet','1|detekterbar'),
('detektering','1|detektera'),
('detektiv','1|undersöka'),
('detektiv','2|detektiv'),
('detektivarbete','1|undersöka'),
('detektivberättelse','1|berättelse'),
('detektivroman','1|roman'),
('detektor','1|påvisa'),
('détente','1|avspänning'),
('detergent','1|tvättmedel'),
('determination','1|bestämning'),
('determinativ','1|pronomen'),
('determinativpronomen','1|pronomen'),
('determinera','1|bestämma'),
('determinerande','1|determinera'),
('determinerbar','1|determinera'),
('determinerbarhet','1|determinerbar'),
('determinering','1|determinera'),
('determinism','1|deterministisk'),
('determinist','1|determinism'),
('deterministisk','1|förutbestämd'),
('detgenus','1|neutrum'),
('detgenus','1|neutrum'),
('detonation','1|detonera'),
('detonationshastighet','1|hastighet'),
('detonationstryck','1|tryck'),
('detonationszon','1|zon'),
('detonator','1|sprängämne'),
('detonera','1|explodera'),
('detonerande','1|detonera'),
('detonerbar','1|detonera'),
('detonerbarhet','1|detonerbar'),
('detonering','1|detonera'),
('Detroit','1|stad'),
('detronisera','1|avsätta'),
('detroniserande','1|detronisera'),
('detroniserbar','1|detronisera'),
('detroniserbarhet','1|detroniserbar'),
('detronisering','1|detronisera'),
('detsamma','1|lyckönskning'),
('deuce','1|tennis'),
('deuterium','1|väte'),
('deutron','1|atomkärna'),
('deutron','1|atomkärna'),
('devalvera','1|minska'),
('devalverande','1|devalvera'),
('devalverbar','1|devalvera'),
('devalverbarhet','1|devalverbar'),
('devalvering','1|devalvera'),
('deviation','1|deviera'),
('deviera','1|riktning'),
('devierande','1|deviera'),
('deviering','1|deviera'),
('devis','1|motto'),
('devon','1|period'),
('devot','1|beundra'),
('dextran','1|ersättning'),
('dextrin','1|kolhydrat'),
('dhivehi','1|språk'),
('di','1|dia'),
('dia','1|suga'),
('dia','2|diapositiv'),
('diabas','1|bergart'),
('diabetes','1|sjukdom'),
('diabetesmedicin','1|medicin'),
('diabetiker','1|diabetes'),
('diabetisk','1|diabetes'),
('diabild','1|diapositiv'),
('diabolisk','1|djävulsk'),
('diadem','1|smycke'),
('diafilm','1|diapositiv'),
('diafragma','1|mellangärde'),
('diagnos','1|fastställa'),
('diagnosmetod','1|metod'),
('diagnosticera','1|diagnos'),
('diagnosticera','1|diagnos'),
('diagnosticerande','1|diagnosticera'),
('diagnosticerande','1|diagnosticera'),
('diagnosticerbar','1|diagnosticera'),
('diagnosticerbar','1|diagnosticera'),
('diagnosticerbarhet','1|diagnosticerbar'),
('diagnosticerbarhet','1|diagnosticerbar'),
('diagnosticering','1|diagnosticera'),
('diagnosticering','1|diagnosticera'),
('diagnostik','1|diagnos'),
('diagnostiker','1|diagnos'),
('diagnostisk','1|diagnos'),
('diagonal','1|tvärsöver'),
('diagonal','2|diagonal'),
('diagonala','1|skida'),
('diagonalande','1|diagonala'),
('diagonalbyggnad','1|kravellbyggd'),
('diagonallinje','1|linje'),
('diagram','1|teckna'),
('diakon','1|diakoni'),
('diakoni','1|kyrka'),
('diakonissa','1|diakon'),
('diakonissanstalt','1|anstalt'),
('diakonistyrelse','1|styrelse'),
('diakritisk','1|tecken'),
('diakronisk','1|utveckling'),
('diakronisk','1|utveckling'),
('dialekt','1|språk'),
('dialektal','1|dialekt'),
('dialektforskning','1|forskning'),
('dialektgeografi','1|utbredning'),
('dialektgeografisk','1|dialektgeografi'),
('dialektik','1|argumentation'),
('dialektiker','1|dialektik'),
('dialektisk','1|dialektik'),
('dialektolog','1|dialektologi'),
('dialektologi','1|vetenskap'),
('dialektologisk','1|dialekt'),
('dialektord','1|ord'),
('dialektordbok','1|ordbok'),
('dialektstudium','1|studium'),
('dialektuttal','1|dialekt'),
('dialog','1|samtal'),
('dialogform','1|dialog'),
('dialogisk','1|dialog'),
('dialogparti','1|parti'),
('dialogpedagogik','1|pedagogik'),
('dialys','1|rena'),
('dialysera','1|dialys'),
('dialyserande','1|dialysera'),
('dialyserbar','1|dialysera'),
('dialyserbarhet','1|dialyserbar'),
('dialysering','1|dialysera'),
('dialytisk','1|dialys'),
('diamant','1|ädelsten'),
('diamantbelagd','1|belägga'),
('diamantborr','1|borr'),
('diamantbrynstål','1|brynstål'),
('diamantbröllop','1|jubileum'),
('diamantprydd','1|pryda'),
('diamantring','1|fingerring'),
('diamantskärare','1|skära'),
('diamantsmycke','1|smycke'),
('diamanttjuv','1|tjuv'),
('diameter','1|cirkel'),
('diametral','1|motsatt'),
('Diana','2|gudinna'),
('diande','1|dia'),
('diapositiv','1|fotografi'),
('diarieföra','1|diarium'),
('diarieförande','1|diarieföra'),
('diarienummer','1|nummer'),
('diarium','1|register'),
('diarré','1|magsjuka'),
('diaspora','1|utspridd'),
('diasporagrupp','1|grupp'),
('diastas','1|enzym'),
('diastole','1|blodfyllning'),
('diastolisk','1|diastole'),
('diatermi','1|värmebehandling'),
('diatonisk','1|tonskala'),
('diatrib','1|stridsskrift'),
('dibarn','1|spädbarn'),
('dibbla','1|så'),
('dibblande','1|dibbla'),
('didaktik','1|vetenskap'),
('didaktiker','1|didaktik'),
('didaktisk','1|undervisning'),
('diddling','1|punghållande'),
('diesel','1|dieselolja'),
('dieseldriven','1|driva'),
('dieselgenerator','1|generator'),
('dieselhybrid','1|hybridbil'),
('dieselkraftverk','1|dieselgenerator'),
('dieselmotor','1|motor'),
('dieselmotorrengöring','1|rengöring'),
('dieselolja','1|olja'),
('dieselpump','1|bensinpump'),
('diet','1|kost'),
('dietetik','1|sjukvård'),
('dietetisk','1|dietetik'),
('dietik','1|diet'),
('dietisk','1|diet'),
('dietist','1|dietetik'),
('differens','1|skillnad'),
('different','1|differens'),
('differential','1|matematik'),
('differential','2|differentialväxel'),
('differentialekvation','1|ekvation'),
('differentialkalkyl','1|kalkyl'),
('differentialräkning','1|differentialkalkyl'),
('differentialspärr','1|differentialväxel'),
('differentialväxel','1|växel'),
('differentiell','1|differens'),
('differentiera','1|variera'),
('differentierande','1|differentiera'),
('differentierbar','1|differentiera'),
('differentierbarhet','1|differentierbar'),
('differentiering','1|differentiera'),
('diffraktion','1|avböjning'),
('diffraktionsspektrum','1|spektrum'),
('diffundera','1|diffusion'),
('diffunderande','1|diffundera'),
('diffunderbar','1|diffundera'),
('diffunderbarhet','1|diffunderbar'),
('diffundering','1|diffundera'),
('diffus','1|otydlig'),
('diffusion','1|spridning'),
('difteri','1|infektionssjukdom'),
('diftong','1|vokal'),
('diftongera','1|diftong'),
('diftongerande','1|diftongera'),
('diftongerbar','1|diftongera'),
('diftongerbarhet','1|diftongerbar'),
('diftongering','1|diftongera'),
('diftongisk','1|diftong'),
('diftongljud','1|diftong'),
('digel','1|digelpress'),
('digelpress','1|tryckpress'),
('diger','1|stor'),
('digerdöden','1|pest'),
('digerera','1|digestion'),
('digererande','1|digerera'),
('digererbar','1|digerera'),
('digererbarhet','1|digererbar'),
('digerering','1|digerera'),
('digestion','1|matsmältning'),
('digga','1|uppskatta'),
('diggande','1|digga'),
('digital','1|dator'),
('digitalbox','1|digital-TV'),
('digitalis','1|medicin'),
('digitalisera','1|digital'),
('digitaliserad','1|digitalisera'),
('digitaliserande','1|digitalisera'),
('digitaliserbar','1|digitalisera'),
('digitaliserbarhet','1|digitaliserbar'),
('digitalisering','1|digitalisera'),
('digitalkamera','1|kamera'),
('digitallåda','1|digital-TV'),
('digital-TV','1|TV'),
('digital-TV','1|TV'),
('digital-TV','1|TV'),
('digital-TV','1|TV'),
('digivning','1|dia'),
('diglossi','1|språk'),
('digna','1|orka'),
('dignande','1|digna'),
('dignitet','1|matematik'),
('dignitet','2|värde'),
('dignitär','1|ämbete'),
('digression','1|avvikelse'),
('dika','1|dränera'),
('dikande','1|dika'),
('dikare','1|dika'),
('dike','1|gräva'),
('dike','1|gräva'),
('dikesgrävare','1|gräva'),
('dikeskörning','1|bilolycka'),
('dikesren','1|kant'),
('diklin','1|skildkönad'),
('diklin','2|diklin'),
('dikning','1|dika'),
('dikotomi','1|tudelning'),
('dikotyledon','1|tvåhjärtbladig'),
('dikotyledon','2|dikotyledon'),
('dikt','1|författa'),
('dikt','2|nära'),
('dikta','1|dikt'),
('diktafon','1|dikteringsmaskin'),
('diktamen','1|diktera'),
('diktamensskrivning','1|skriva'),
('diktan','1|strävan'),
('diktande','1|dikta'),
('diktarbegåvning','1|begåvning'),
('diktare','1|dikt'),
('diktarfurste','1|furste'),
('diktarfursteroll','1|roll'),
('diktargrupp','1|grupp'),
('diktarskap','1|diktare'),
('diktart','1|dikt'),
('diktat','1|tvinga'),
('diktator','1|härska'),
('diktatorisk','1|diktator'),
('diktatorsfasoner','1|diktator'),
('diktatorsmakt','1|diktator'),
('diktatur','1|diktator'),
('diktaturregim','1|regim'),
('diktcykel','1|cykel'),
('diktera','1|läsa'),
('diktera','2|befalla'),
('dikterande','1|diktera'),
('dikterande','2|diktera'),
('dikterbar','1|diktera'),
('dikterbar','2|diktera'),
('dikterbarhet','1|dikterbar'),
('dikterbarhet','2|dikterbar'),
('diktering','1|diktera'),
('diktering','2|diktera'),
('dikteringsmaskin','1|registrera'),
('diktfragment','1|fragment'),
('dikthäfte','1|diktsamling'),
('diktion','1|tala'),
('diktjag','1|jag'),
('diktkonst','1|dikt'),
('diktmässig','1|dikt'),
('diktning','1|dikt'),
('diktsamling','1|samling'),
('diktverk','1|dikt'),
('dikväveoxid','1|kväveoxid'),
('dila','1|handla'),
('dilamm','1|lamm'),
('dilande','1|dila'),
('dilatation','1|utvidgning'),
('dilatationsfog','1|fog'),
('dildo','1|penisattrapp'),
('dilemma','1|svårighet'),
('dilettant','1|klåpare'),
('dilettanteri','1|dilettant'),
('dilettantisk','1|dilettant'),
('dilettantism','1|dilettant'),
('dilettantmässig','1|dilettantisk'),
('dilettantmässighet','1|dilettantmässig'),
('diligens','1|vagn'),
('dill','1|krydda'),
('dilla','1|struntprat'),
('dillande','1|dilla'),
('dille','1|delirium'),
('dilleri','1|dilla'),
('dillkrona','1|dill'),
('dillkvist','1|dill'),
('dillkött','1|kött'),
('dillsås','1|sås'),
('dimbank','1|dimma'),
('dimbildning','1|vilseleda'),
('dimblå','1|gråblå'),
('dimbåge','1|båge'),
('dimension','1|riktning'),
('dimension','2|storlek'),
('dimensionera','1|dimension'),
('dimensionerande','1|dimensionera'),
('dimensionerbar','1|dimensionera'),
('dimensionerbarhet','1|dimensionerbar'),
('dimensionering','1|dimensionera'),
('dimensionsavverkning','1|avverkning'),
('dimensionslös','1|måttenhet'),
('dimfri','1|dimma'),
('dimfrost','1|frost'),
('dimgestalt','1|gestalt'),
('dimhöljd','1|hölja'),
('diminuendo','1|avtagande'),
('diminuendo','2|diminuendo'),
('diminutiv','1|liten'),
('diminutiv','2|diminutiv'),
('dimission','1|examen'),
('dimkammare','1|partikelstrålning'),
('dimljus','1|strålkastare'),
('dimma','1|oklar'),
('dimmig','1|dimma'),
('dimmighet','1|dimmig'),
('dimmoln','1|moln'),
('dimorf','1|tvåformig'),
('dimorfi','1|kristallisera'),
('dimorfism','1|dimorf'),
('dimpa','1|falla'),
('dimpande','1|dimpa'),
('dimridå','1|vilseleda'),
('dimslöja','1|slöja'),
('dinar','1|myntenhet'),
('dinatriumvätefosfat','1|fosfat'),
('dinatriumvätefosfat','1|fosfat'),
('diné','1|måltid'),
('dinera','1|diné'),
('dinerande','1|dinera'),
('dinering','1|dinera'),
('ding','1|dingdång'),
('ding','2|galen'),
('dingdång','1|klocka'),
('dinge','1|roddbåt'),
('dingeldangel','1|grannlåt'),
('dinghet','1|ding'),
('dingla','1|svänga'),
('dinglande','1|dingla'),
('dingo','1|hundras'),
('dinkel','1|vete'),
('dinosaur','1|dinosaurie'),
('dinosaurie','1|jätteödla'),
('dinosaurieart','1|art'),
('diod','1|elektronrör'),
('diod','2|halvledardiod'),
('Diogenes','1|filosof'),
('Dione','1|måne'),
('dionysisk','1|extatisk'),
('Dionysos','1|vingud'),
('diopter','1|sikte'),
('dioptri','1|brytningsförmåga'),
('dioptrik','1|vetenskap'),
('dioptrisk','1|dioptri'),
('diorama','1|bakgrund'),
('diorit','1|granit'),
('dioskur','1|kamrat'),
('dioxin','1|gift'),
('diperiod','1|period'),
('diploid','1|kromosom'),
('diplom','1|intyg'),
('diplom','2|urkund'),
('diplomat','1|ambassad'),
('diplomatarisk','1|diplom'),
('diplomatarium','1|diplom'),
('diplomatbostad','1|bostad'),
('diplomatdotter','1|dotter'),
('diplomathustru','1|hustru'),
('diplomati','1|diplomatisk'),
('diplomatik','1|vetenskap'),
('diplomatisk','1|smidig'),
('diplomatisk','2|diplomat'),
('diplomatkrets','1|krets'),
('diplomatkår','1|diplomat'),
('diplomatkälla','1|kunskapskälla'),
('diplomatpass','1|pass'),
('diplomatportfölj','1|portfölj'),
('diplomatpost','1|post'),
('diplomera','1|diplom'),
('diplomerande','1|diplomera'),
('diplomerbar','1|diplomera'),
('diplomerbarhet','1|diplomerbar'),
('diplomering','1|diplomera'),
('diplomingenjör','1|ingenjör'),
('dipmix','1|krydda'),
('dipol','1|partikel'),
('dipp','1|dipmix'),
('dipp','1|dipmix'),
('dipp','2|nedgång'),
('dipp','2|nedgång'),
('dippa','1|dipmix'),
('dippa','2|dipp'),
('dippande','1|dippa'),
('dippande','2|dippa'),
('dipsan','1|antabus'),
('dipsoman','1|periodsupare'),
('dipsomani','1|dipsoman'),
('diptyk','1|altarprydnad'),
('direkt','1|rak'),
('direkt','2|verkligen'),
('direkt','3|genast'),
('direktdemokrati','1|demokrati'),
('direktflyg','1|flyg'),
('direkthet','1|direkt'),
('direktinflytande','1|inflytande'),
('direktinsprutning','1|motorbränsle'),
('direktion','1|styrelse'),
('direktionskraft','1|jämviktsläge'),
('direktiv','1|order'),
('direktkonfrontation','1|konfrontation'),
('direktkontakt','1|kontakt'),
('direktlinje','1|förbindelse'),
('direktlyftande','1|lyfta'),
('direktmetod','1|språkinlärning'),
('direktor','1|föreståndare'),
('direktreferat','1|referat'),
('direktreklam','1|reklam'),
('direktreklamsbolag','1|bolag'),
('direktremiss','1|remiss'),
('direktremiss','2|remiss'),
('direktris','1|direktör'),
('direktris','2|kägelsnitt'),
('direktskott','1|skott'),
('direktsända','1|direktsändning'),
('direktsändande','1|direktsändning'),
('direktsändning','1|utsändning'),
('direktträff','1|fullträff'),
('direktvald','1|välja'),
('direktverkande','1|verka'),
('direktväxel','1|växel'),
('direktör','1|chef'),
('dirigent','1|dirigera'),
('dirigera','1|orkester'),
('dirigerande','1|dirigera'),
('dirigerbar','1|dirigera'),
('dirigerbarhet','1|dirigerbar'),
('dirigering','1|dirigera'),
('dirigism','1|styrning'),
('dirk','1|lina'),
('dirka','1|dirk'),
('dirkande','1|dirka'),
('dirra','1|darra'),
('dirrande','1|dirra'),
('dis','1|luft'),
('dis','2|gudinna'),
('disackarid','1|sockerart'),
('disagio','1|värde'),
('disambiguera','1|avlägsna'),
('disambiguerande','1|disambiguera'),
('disambiguerbar','1|disambiguera'),
('disambiguerbarhet','1|disambiguerbar'),
('discessus','1|omröstning'),
('discipel','1|lärjunge'),
('disciplin','1|lyda'),
('disciplin','2|läroämne'),
('disciplinbot','1|bot'),
('disciplinera','1|disciplin'),
('disciplinerad','1|disciplinera'),
('disciplinerande','1|disciplinera'),
('disciplinerbar','1|disciplinera'),
('disciplinerbarhet','1|disciplinerbar'),
('disciplinering','1|disciplinera'),
('disciplingräns','1|gräns'),
('disciplinmål','1|mål'),
('disciplinnämnd','1|nämnd'),
('disciplinpåföljd','1|påföljd'),
('disciplinstraff','1|straff'),
('disciplinstress','1|stress'),
('disciplinär','1|disciplin'),
('disciplinärende','1|ärende'),
('disco','1|diskotek'),
('disco','1|diskotek'),
('disco','2|discomusik'),
('disco','2|discomusik'),
('discokula','1|belysning'),
('discomusik','1|dansmusik'),
('discomusik','1|dansmusik'),
('disharmoni','1|disharmonisk'),
('disharmoniera','1|disharmoni'),
('disharmonierande','1|disharmoniera'),
('disharmonierbar','1|disharmoniera'),
('disharmonierbarhet','1|disharmonierbar'),
('disharmoniering','1|disharmoniera'),
('disharmonisk','1|harmonisk'),
('disig','1|dis'),
('disighet','1|disig'),
('disjunkt','1|åtskilja'),
('disjunktion','1|sats'),
('disjunktiv','1|disjunktion'),
('disk','1|betjäna'),
('disk','2|diska'),
('disk','3|broskskiva'),
('disk','4|hårddisk'),
('diska','1|ren'),
('diska','2|diskvalificera'),
('diskande','1|diska'),
('diskande','2|diska'),
('diskant','1|ton'),
('diskantklav','1|klav'),
('diskare','1|diska'),
('diskbalja','1|balja'),
('diskblomma','1|blomma'),
('diskbråck','1|bråck'),
('diskbråck','1|bråck'),
('diskbänk','1|diska'),
('diskett','1|dator'),
('diskhandske','1|gummihandske'),
('diskho','1|diskbänk'),
('diskjockey','1|popmusik'),
('diskjockey','1|popmusik'),
('diskjockey','1|popmusik'),
('diskmaskin','1|maskin'),
('diskmedel','1|medel'),
('diskning','1|diska'),
('diskning','2|diska'),
('diskofil','1|samlare'),
('diskontera','1|växel'),
('diskonterande','1|diskontera'),
('diskonterbar','1|diskontera'),
('diskonterbarhet','1|diskonterbar'),
('diskontering','1|diskontera'),
('diskontinuerlig','1|kontinuerlig'),
('diskontinuerlighet','1|diskontinuerlig'),
('diskontinuitet','1|diskontinuerlig'),
('diskontnota','1|kvitto'),
('diskonto','1|räntesats'),
('diskontör','1|diskontera'),
('diskordans','1|överensstämmelse'),
('diskordant','1|diskordans'),
('diskotek','1|dansställe'),
('diskplockare','1|diska'),
('diskreditera','1|svartmåla'),
('diskrediterande','1|diskreditera'),
('diskrediterbar','1|diskreditera'),
('diskrediterbarhet','1|diskrediterbar'),
('diskreditering','1|diskreditera'),
('diskrepans','1|skillnad'),
('diskret','1|hänsynsfull'),
('diskret','2|kontinuerlig'),
('diskretion','1|diskret'),
('diskriminera','1|orättvis'),
('diskriminerande','1|diskriminera'),
('diskriminerbar','1|diskriminera'),
('diskriminerbarhet','1|diskriminerbar'),
('diskriminering','1|diskriminera'),
('diskrimineringsbekämpning','1|bekämpning'),
('diskrimineringslagstiftning','1|lagstiftning'),
('diskrum','1|rum'),
('diskställ','1|ställ'),
('disktorkning','1|torkning'),
('disktrasa','1|trasa'),
('diskurs','1|samtal'),
('diskursiv','1|intuitiv'),
('diskus','1|skiva'),
('diskuskastare','1|diskuskastning'),
('diskuskastning','1|sport'),
('diskussion','1|diskutera'),
('diskussionsforum','1|forum'),
('diskussionsprotokoll','1|protokoll'),
('diskussionsunderlag','1|underlag'),
('diskussionsämne','1|ämne'),
('diskutabel','1|tvivelaktig'),
('diskutera','1|samtala'),
('diskuterande','1|diskutera'),
('diskuterbar','1|diskutera'),
('diskuterbarhet','1|diskuterbar'),
('diskutering','1|diskutera'),
('diskvalificera','1|stänga_av'),
('diskvalificerande','1|diskvalificera'),
('diskvalificerbar','1|diskvalificera'),
('diskvalificerbarhet','1|diskvalificerbar'),
('diskvalificering','1|diskvalificera'),
('diskvalifikation','1|diskvalificering'),
('diskvatten','1|vatten'),
('dislokation','1|rubba'),
('disparat','1|oförenlig'),
('dispasch','1|utredning'),
('dispaschera','1|dispasch'),
('dispascherande','1|dispaschera'),
('dispascherbar','1|dispaschera'),
('dispascherbarhet','1|dispascherbar'),
('dispaschering','1|dispaschera'),
('dispaschör','1|dispasch'),
('dispens','1|befria'),
('dispensera','1|dispens'),
('dispenserande','1|dispensera'),
('dispenserbar','1|dispensera'),
('dispenserbarhet','1|dispenserbar'),
('dispensering','1|dispensera'),
('dispensär','1|klinik'),
('dispergera','1|fördela'),
('dispergerande','1|dispergera'),
('dispergerbar','1|dispergera'),
('dispergerbarhet','1|dispergerbar'),
('dispergering','1|dispergera'),
('dispers','1|dispergera'),
('dispersion','1|dispergera'),
('display','1|textskärm'),
('disponent','1|chef'),
('disponera','1|förfoga'),
('disponera','2|ordna'),
('disponera','3|disponerad'),
('disponerad','1|mottaglig'),
('disponerande','1|disponera'),
('disponerande','2|disponera'),
('disponerande','3|disponera'),
('disponerbar','1|disponera'),
('disponerbar','2|disponera'),
('disponerbar','3|disponera'),
('disponerbarhet','1|disponerbar'),
('disponerbarhet','2|disponerbar'),
('disponerbarhet','3|disponerbar'),
('disponering','1|disponera'),
('disponering','2|disponera'),
('disponering','3|disponera'),
('disponibel','1|disponera'),
('disponibilitet','1|disponibel'),
('disposition','1|disponera'),
('disposition','2|plan'),
('dispositionsfond','1|fond'),
('dispositionsrätt','1|rätt'),
('dispositiv','1|bindande'),
('disproportion','1|disproportionerlig'),
('disproportionerlig','1|oproportionerlig'),
('disproportionerlighet','1|disproportionerlig'),
('disputation','1|försvara'),
('disputationsakt','1|disputation'),
('disputera','1|disputation'),
('disputera','2|dispyt'),
('disputerande','1|disputera'),
('disputerande','2|disputera'),
('disputerbar','1|disputera'),
('disputerbar','2|disputera'),
('disputerbarhet','1|disputerbar'),
('disputerbarhet','2|disputerbar'),
('disputering','1|disputera'),
('disputering','2|disputera'),
('dispyt','1|diskutera'),
('diss','1|dissa'),
('dissa','1|usel'),
('dissande','1|dissa'),
('dissekera','1|sönderdela'),
('dissekerande','1|dissekera'),
('dissekerbar','1|dissekera'),
('dissekerbarhet','1|dissekerbar'),
('dissekering','1|dissekera'),
('dissektion','1|dissekera'),
('dissenter','1|statskyrka'),
('dissertation','1|doktorsavhandling'),
('dissident','1|oliktänkande'),
('dissimilation','1|dissimilera'),
('dissimilation','2|dissimilera'),
('dissimilera','1|bryta_ned'),
('dissimilera','2|språkljud'),
('dissimilerande','1|dissimilera'),
('dissimilerande','2|dissimilera'),
('dissimilerbar','1|dissimilera'),
('dissimilerbar','2|dissimilera'),
('dissimilerbarhet','1|dissimilerbar'),
('dissimilerbarhet','2|dissimilerbar'),
('dissimilering','1|dissimilera'),
('dissimilering','2|dissimilera'),
('dissociation','1|dissociera'),
('dissociera','1|sönderdela'),
('dissocierande','1|dissociera'),
('dissocierbar','1|dissociera'),
('dissocierbarhet','1|dissocierbar'),
('dissociering','1|dissociera'),
('dissonans','1|låta'),
('dissonant','1|dissonans'),
('dissonant','2|dissonant'),
('dissonera','1|dissonans'),
('dissonerande','1|dissonera'),
('dissonering','1|dissonera'),
('distans','1|avstånd'),
('distansbygel','1|bygel'),
('distansera','1|distans'),
('distanserande','1|distansera'),
('distanserbar','1|distansera'),
('distanserbarhet','1|distanserbar'),
('distansering','1|distansera'),
('distansflygning','1|flygning'),
('distanshögskola','1|högskola'),
('distanslös','1|distans'),
('distansminut','1|sjömil'),
('distansmätare','1|mätare'),
('distansmätning','1|avståndsmätning'),
('distansritt','1|ridsport'),
('distansundervisning','1|undervisning'),
('distikon','1|versmått'),
('disting','1|ting'),
('distingerad','1|förnäm'),
('distinkt','1|tydlig'),
('distinktion','1|skillnad'),
('distorsion','1|förvrängning'),
('distrahera','1|avleda'),
('distraherad','1|distrahera'),
('distraherande','1|distrahera'),
('distraherbar','1|distrahera'),
('distraherbarhet','1|distraherbar'),
('distrahering','1|distrahera'),
('distraktion','1|distrahera'),
('distraktor','1|distrahera'),
('distribuent','1|distribuera'),
('distribuera','1|fördela'),
('distribuerande','1|distribuera'),
('distribuerbar','1|distribuera'),
('distribuerbarhet','1|distribuerbar'),
('distribuering','1|distribuera'),
('distribunal','1|distributionscentral'),
('distribution','1|distribuera'),
('distribution','2|statistik'),
('distributionscentral','1|central'),
('distributionsföretag','1|företag'),
('distributiv','1|distribuera'),
('distributör','1|distribuera'),
('distrikt','1|område'),
('distriktsläkare','1|läkare'),
('distriktsmästare','1|mästare'),
('distriktsmästerskap','1|tävling'),
('distriktsordförande','1|ordförande'),
('disträ','1|tankspridd'),
('disös','1|deklamera'),
('dit','1|där'),
('ditflugen','1|flyga'),
('ditfärd','1|färd'),
('dithän','1|dit'),
('dithörande','1|tillhöra'),
('ditin','1|in'),
('ditintills','1|dittills'),
('ditkommen','1|komma'),
('ditkomst','1|ankomst'),
('dito','1|lika'),
('ditresa','1|resa'),
('dittills','1|då'),
('dittillsvarande','1|existera'),
('ditut','1|ut'),
('ditvägen','1|ditresa'),
('dityramb','1|dikt'),
('dityrambisk','1|dityramb'),
('ditåt','1|dit'),
('ditåt','2|ungefär'),
('diva','1|aktris'),
('divalater','1|later'),
('divan','1|soffa'),
('divergens','1|divergera'),
('divergent','1|divergera'),
('divergera','1|isär'),
('divergerande','1|divergera'),
('divergerbar','1|divergera'),
('divergerbarhet','1|divergerbar'),
('divergering','1|divergera'),
('diverse','1|blanda'),
('diverse','1|blanda'),
('diverse','1|blanda'),
('diversearbetare','1|arbetare'),
('diversehandel','1|affär'),
('diversifiera','1|diverse'),
('diversifierande','1|diversifiera'),
('diversifierbar','1|diversifiera'),
('diversifierbarhet','1|diversifierbar'),
('diversifiering','1|diversifiera'),
('diversion','1|vilseleda'),
('divertissemang','1|underhållning'),
('dividend','1|dividera'),
('dividera','1|dela'),
('dividera','2|diskutera'),
('dividerande','1|dividera'),
('dividerande','2|dividera'),
('dividerbar','1|dividera'),
('dividerbar','2|dividera'),
('dividerbarhet','1|dividerbar'),
('dividerbarhet','2|dividerbar'),
('dividering','1|dividera'),
('dividering','2|dividera'),
('divig','1|diva'),
('divinatorisk','1|profetisk'),
('divis','1|bindestreck'),
('division','1|dividera'),
('division','2|förband'),
('division','3|avdelning'),
('divisionschef','1|chef'),
('divisionschef','2|chef'),
('divisionsfana','1|fana'),
('divisionsgeneral','1|general'),
('divisor','1|dividera'),
('dixieland','1|jazz'),
('Djakarta','1|huvudstad'),
('Djibouti','1|land'),
('djiboutier','1|Djibouti'),
('djiboutisk','1|Djibouti'),
('djiboutiska','1|djiboutier'),
('djonk','1|segelfartyg'),
('djungel','1|skog'),
('Djungelboken','1|roman'),
('djungelbryn','1|bryn'),
('djungeltelegraf','1|rykte'),
('djup','1|stor'),
('djup','2|djup'),
('djupavslappning','1|avslappning'),
('djupbergart','1|bergart'),
('djupbild','1|bild'),
('djupblå','1|blå'),
('djupborra','1|djupborrning'),
('djupborrad','1|djupborrning'),
('djupborrande','1|inträngande'),
('djupborrande','2|djupborra'),
('djupborrning','1|borra'),
('djupbrytning','1|bryta'),
('djupdimension','1|dimension'),
('djupdykning','1|dykning'),
('djupfrysa','1|konservera'),
('djupfrysande','1|djupfrysa'),
('djupfuktande','1|fukta'),
('djupgrön','1|grön'),
('djupgående','1|djup'),
('djupgående','2|mått'),
('djuphav','1|hav'),
('djuphavsbotten','1|botten'),
('djuphavsfisk','1|fisk'),
('djuphavsgrav','1|djuphav'),
('djuphavsvatten','1|vatten'),
('djuphet','1|djup'),
('djuping','1|djupsinnig'),
('djupintervju','1|intervju'),
('djupkultur','1|kultur'),
('djuplek','1|djup'),
('djuplod','1|lod'),
('djuploda','1|loda'),
('djuplodande','1|analysera'),
('djuplodande','2|djuploda'),
('djuplodning','1|djuploda'),
('djupmask','1|kortspel'),
('djupna','1|djup'),
('djupnande','1|djupna'),
('djuppsykologi','1|psykologi'),
('djuprengörande','1|rengöra'),
('djuprotad','1|vana'),
('djupröd','1|mörkröd'),
('djupsinne','1|tänka'),
('djupsinnig','1|djupsinne'),
('djupsinnighet','1|djupsinne'),
('djupstruktur','1|språkform'),
('djupsömn','1|sömn'),
('djuptallrik','1|tallrik'),
('djuptryck','1|tryck'),
('djuptänkt','1|djupsinnig'),
('djuptänkthet','1|djuptänkt'),
('djupurladdning','1|urladdning'),
('djupvatten','1|vatten'),
('djupverkan','1|synintryck'),
('djur','1|varelse'),
('djuranatomi','1|anatomi'),
('djurangrepp','1|angrepp'),
('djurart','1|art'),
('djurben','1|ben'),
('djurblod','1|blod'),
('djurbok','1|bok'),
('djurdel','1|del'),
('djurdyrkan','1|dyrka'),
('djurfabel','1|fabel'),
('djurfoder','1|foder'),
('djurfot','1|fot'),
('djurförbud','1|förbud'),
('djurförsök','1|försök'),
('djurförädling','1|avel'),
('djurgeografi','1|utbredning'),
('djurgrupp','1|grupp'),
('djurgård','1|djurpark'),
('Djurgården','1|fotbollslag'),
('djurhamn','1|hamn'),
('djurhud','1|hud'),
('djurhuvud','1|huvud'),
('djurhållning','1|djuruppfödning'),
('djurhälsa','1|hälsa'),
('djurhövdad','1|djurhuvud'),
('djurisk','1|drift'),
('djuriskhet','1|djurisk'),
('djurkadaver','1|kadaver'),
('djurkretsen','1|krets'),
('djurkropp','1|kropp'),
('djurliknande','1|djur'),
('djurliv','1|djur'),
('djurläkare','1|veterinär'),
('djurläte','1|läte'),
('djurmat','1|foder'),
('djurmålning','1|målning'),
('djurmålning','2|måla'),
('djurornamentik','1|ornamentik'),
('djurpark','1|fångenskap'),
('djurparksvarg','1|varg'),
('djurplankton','1|plankton'),
('djurplågare','1|plåga'),
('djurplågeri','1|plåga'),
('djurpsykologi','1|psykologi'),
('djurriket','1|djur'),
('djurrättsaktivist','1|aktivist'),
('djurrättsfråga','1|fråga'),
('Djursholm','1|Stockholm'),
('djursjukhus','1|sjukhus'),
('djurskinn','1|skinn'),
('djurskydd','1|skydd'),
('djurskyddsförening','1|förening'),
('djurskyddsinspektör','1|inspektör'),
('djurskyddslagstiftning','1|lagstiftning'),
('djurskyddsmässig','1|djurskydd'),
('djurskötare','1|sköta'),
('djurskötsel','1|sköta'),
('djurslag','1|slag'),
('djurstig','1|stig'),
('djurtarm','1|tarm'),
('djurtillsyn','1|tillsyn'),
('djurtämjare','1|tämja'),
('djuruppfödning','1|uppfödning'),
('djurutställning','1|utställning'),
('djurvän','1|tycka_om'),
('djurvänlig','1|djurvän'),
('djurvänlighet','1|djurvänlig'),
('djurvärld','1|djur'),
('djäkne','1|elev'),
('djärv','1|modig'),
('djärvas','1|våga'),
('djärvhet','1|djärv'),
('djävul','1|väsen'),
('Djävulen','1|djävul'),
('djävulsbesvärjare','1|djävulsbesvärjelse'),
('djävulsbesvärjelse','1|utdriva'),
('djävulsk','1|lömsk'),
('djävulsk','1|lömsk'),
('djävulsk','1|lömsk'),
('djävulsk','1|lömsk'),
('djävulskonst','1|konst'),
('djävulsspiral','1|spiral'),
('djävulstro','1|tro'),
('djävulstyg','1|jävelskap'),
('djävulstyg','1|jävelskap'),
('djävulstyg','1|jävelskap'),
('djävulstyg','1|jävelskap'),
('djävulusisk','1|djävulsk'),
('DNA','1|arvsmassa'),
('DNA','1|arvsmassa'),
('DNA-kedja','1|kedja'),
('DNA-kedja','1|kedja'),
('DNA-molekyl','1|molekyl'),
('DNA-molekyl','1|molekyl'),
('DNA-profil','1|profil'),
('DNA-profil','1|profil'),
('DNA-sekvens','1|sekvens'),
('DNA-sekvens','1|sekvens'),
('DNA-sekvensering','1|sekvensera'),
('DNA-sekvensering','1|sekvensera'),
('dna-spår','1|spår'),
('DNA-sträng','1|DNA-kedja'),
('DNA-sträng','1|DNA-kedja'),
('DNA-test','1|DNA-testa'),
('DNA-test','1|DNA-testa'),
('DNA-testa','1|testa'),
('DNA-testa','1|testa'),
('DNA-testande','1|DNA-testa'),
('DNA-testande','1|DNA-testa'),
('DNA-testning','1|DNA-testa'),
('DNA-testning','1|DNA-testa'),
('DNA-uppsättning','1|uppsättning'),
('DNA-uppsättning','1|uppsättning'),
('Dnepr','1|flod'),
('doa','1|sjunga'),
('doakör','1|kör'),
('doande','1|doa'),
('dobbel','1|hasardspel'),
('dobbla','1|dobbel'),
('dobblande','1|dobbla'),
('dobblare','1|dobbla'),
('docent','1|universitet'),
('docentur','1|docent'),
('docera','1|tala'),
('docerande','1|docera'),
('docering','1|docera'),
('dock','1|men'),
('docka','1|leksak'),
('docka','2|reparera'),
('docka','3|angöra'),
('docka','4|docka'),
('docka','5|hållare'),
('dockaktig','1|docka'),
('dockaktighet','1|dockaktig'),
('dockande','1|docka'),
('dockande','2|docka'),
('dockansikte','1|ansikte'),
('dockkudde','1|kudde'),
('dockperuk','1|peruk'),
('dockskåp','1|leksak'),
('docksöt','1|söt'),
('dockteater','1|teater'),
('dodekaeder','1|figur'),
('doft','1|dofta'),
('doft','2|stoft'),
('dofta','1|lukta'),
('dofta','2|lukta'),
('doftande','1|dofta'),
('doftande','2|dofta'),
('doftfylld','1|doft'),
('doftljus','1|ljus'),
('doftlös','1|doft'),
('doftlöshet','1|doftlös'),
('doftmarkera','1|markera'),
('doftmarkerande','1|doftmarkera'),
('doftmarkerbar','1|doftmarkera'),
('doftmarkerbarhet','1|doftmarkerbar'),
('doftmarkering','1|doftmarkera'),
('doftrik','1|doft'),
('doftsinne','1|luktsinne'),
('doftsvag','1|doft'),
('doftsvaghet','1|doftsvag'),
('doftämne','1|ämne'),
('dogcart','1|hästvagn'),
('doge','1|ledare'),
('Dogepalatset','1|palats'),
('dogg','1|bulldogg'),
('dogm','1|norm'),
('dogmatik','1|åskådning'),
('dogmatiker','1|dogmatik'),
('dogmatisera','1|dogmatik'),
('dogmatiserande','1|dogmatisera'),
('dogmatiserbar','1|dogmatisera'),
('dogmatiserbarhet','1|dogmatiserbar'),
('dogmatisering','1|dogmatisera'),
('dogmatisk','1|rigid'),
('dogmatisk','2|dogmatik'),
('dogmatism','1|dogmatik'),
('dogmsystem','1|dogm'),
('doja','1|sko'),
('dok','1|slöja'),
('doktor','1|bota'),
('doktor','1|bota'),
('doktor','1|bota'),
('doktor','2|examen'),
('doktor','2|examen'),
('doktor','2|examen'),
('doktorand','1|studera'),
('doktorera','1|doktor'),
('doktorerande','1|doktorera'),
('doktorering','1|doktorera'),
('doktorsavhandling','1|avhandling'),
('doktorsdisputation','1|disputation'),
('doktorsexamen','1|doktor'),
('doktorsfisk','1|fisk'),
('doktorsgrad','1|doktor'),
('doktorshatt','1|hatt'),
('doktorska','1|fru'),
('doktorspromotion','1|promovera'),
('doktorsring','1|ring'),
('doktrin','1|norm'),
('doktrinarism','1|doktrin'),
('doktrinär','1|doktrin'),
('dokument','1|läsa'),
('dokumentalist','1|dokumentation'),
('dokumentarisk','1|dokument'),
('dokumentation','1|dokumentera'),
('dokumentation','2|kunskap'),
('dokumentera','1|styrka'),
('dokumenterande','1|dokumentera'),
('dokumenterbar','1|dokumentera'),
('dokumenterbarhet','1|dokumenterbar'),
('dokumentering','1|dokumentera'),
('dokumentkreditiv','1|kreditiv'),
('dokumentpacke','1|packe'),
('dokumentpapper','1|papper'),
('dokumentportfölj','1|portfölj'),
('dokumentsamling','1|dokument'),
('dokumentskåp','1|skåp'),
('dokumentär','1|verklig'),
('dokumentär','2|TV-program'),
('dokumentärfilm','1|film'),
('dokumentärprogram','1|program'),
('dokumentärroman','1|roman'),
('dokusåpa','1|TV-program'),
('dokusåpadeltagare','1|dokusåpa'),
('dokusåpakändis','1|kändis'),
('dold','1|dölja'),
('dold','1|dölja'),
('doldhet','1|dold'),
('doldis','1|publicitet'),
('dolikocefal','1|långskallig'),
('dolikocefal','2|dolikocefal'),
('dolikocefali','1|dolikocefal'),
('dolk','1|kniv'),
('dolkstöt','1|angrepp'),
('dolkstöt','2|stöt'),
('dolkstötslegend','1|legend'),
('dollar','1|myntenhet'),
('dollardiplomati','1|diplomati'),
('dollargrin','1|amerikanare'),
('dollarprinsessa','1|dotter'),
('dollarsedel','1|dollar'),
('dollarturist','1|turist'),
('dolma','1|kåldolma'),
('dolma','2|uniformsrock'),
('dolomit','1|bergart'),
('Dolomiterna','1|Alperna'),
('dolsk','1|illasinnad'),
('dolskhet','1|dolsk'),
('dom','1|döma'),
('dom','2|katedral'),
('domare','1|döma'),
('domare','2|döma'),
('domared','1|ed'),
('domaredans','1|sånglek'),
('domarkår','1|kår'),
('domarornat','1|ornat'),
('domarpost','1|post'),
('domarring','1|stensättning'),
('domarsäte','1|domare'),
('dombok','1|protokoll'),
('domdera','1|tala'),
('domderande','1|domdera'),
('domdering','1|domdera'),
('domedag','1|yttersta_domen'),
('domedagspredikan','1|predikan'),
('domedagspredikant','1|predikant'),
('domedagspredikning','1|predikan'),
('domedagsprofet','1|profet'),
('domedagsstämning','1|stämning'),
('domedagstänkande','1|tänkande'),
('domedagsvapen','1|vapen'),
('domesticera','1|tämja'),
('domesticerande','1|domesticera'),
('domesticerbar','1|domesticera'),
('domesticerbarhet','1|domesticerbar'),
('domesticering','1|domesticera'),
('domestik','1|tjänare'),
('domestik','2|bomullstyg'),
('domfälla','1|avkunna'),
('domfällande','1|domfälla'),
('domför','1|beslutsför'),
('domhavande','1|döma'),
('domherre','1|småfågel'),
('domicil','1|hemort'),
('domiciliera','1|växel'),
('domicilierande','1|domiciliera'),
('domicilierbar','1|domiciliera'),
('domicilierbarhet','1|domicilierbar'),
('domiciliering','1|domiciliera'),
('domina','1|sado-masochism'),
('dominans','1|dominera'),
('dominant','1|dominera'),
('dominant','2|ton'),
('dominant','3|dominant'),
('dominatrix','1|domina'),
('dominera','1|över'),
('dominerande','1|dominera'),
('dominerande','2|dominera'),
('dominerbar','1|dominera'),
('dominerbarhet','1|dominerbar'),
('dominering','1|dominera'),
('Dominica','1|land'),
('dominikan','1|munk'),
('dominikan','2|Dominikanska_republiken'),
('dominikanerkloster','1|kloster'),
('dominikanerkloster','1|kloster'),
('dominikanerorden','1|klosterorden'),
('dominikanerorden','1|klosterorden'),
('dominikanmunk','1|dominikan'),
('dominikanmunk','1|dominikan'),
('dominikansk','1|Dominikanska_republiken'),
('dominikanska','1|dominikan'),
('dominikansyster','1|syster'),
('dominiker','1|Dominica'),
('dominikisk','1|Dominica'),
('dominikiska','1|dominiker'),
('dominion','1|stat'),
('domino','1|maskeraddräkt'),
('domino','2|spel'),
('dominobricka','1|bricka'),
('dominoeffekt','1|effekt'),
('dominohav','1|böljande'),
('dominospel','1|domino'),
('dominoteori','1|teori'),
('domkapitel','1|styrelse'),
('domkraft','1|lyfta'),
('domkraftsolja','1|olja'),
('domkrets','1|område'),
('domkval','1|klandra'),
('domkyrka','1|kyrka'),
('domkyrkoadjunkt','1|präst'),
('domkyrkoförsamling','1|församling'),
('domna','1|försvinna'),
('domnande','1|domna'),
('domning','1|domna'),
('domprost','1|präst'),
('domptera','1|tvinga'),
('dompterande','1|domptera'),
('dompterbar','1|domptera'),
('dompterbarhet','1|dompterbar'),
('domptering','1|domptera'),
('domptör','1|domptera'),
('domptörsfason','1|fason'),
('domsaga','1|domkrets'),
('domskäl','1|skäl'),
('domslut','1|dom'),
('domsrätt','1|rätt'),
('domssöndag','1|kyrkoår'),
('domssöndag','1|kyrkoår'),
('domstol','1|döma'),
('domstolsbeslut','1|beslut'),
('domstolsbetjänt','1|betjänt'),
('domstolsförhandling','1|förhandling'),
('domstolsledamot','1|ledamot'),
('domstolsmål','1|mål'),
('domstolsmässig','1|domstol'),
('domstolsprotokoll','1|protokoll'),
('domstolssammanträde','1|sammanträde'),
('domstolssession','1|session'),
('domstolsverk','1|myndighet'),
('domvilla','1|rättegångsfel'),
('domvärjo','1|domsrätt'),
('domän','1|område'),
('domän','2|webbdomän'),
('domänförvaltning','1|förvalta'),
('domänförvaltning','2|förvalta'),
('domänintendent','1|statstjänsteman'),
('domänstyrelse','1|domänverk'),
('domänverk','1|skogsförvaltning'),
('Don','1|flod'),
('don','1|redskap'),
('don','2|herr'),
('dona','1|syssla'),
('dona','2|fågelsnara'),
('donande','1|dona'),
('donation','1|donera'),
('donationsbrev','1|dokument'),
('donationsjord','1|jord'),
('donationsmedel','1|pengar'),
('donator','1|donera'),
('Donatus','1|grammatiker'),
('Donau','1|flod'),
('donera','1|skänka'),
('donerande','1|donera'),
('donerbar','1|donera'),
('donerbarhet','1|donerbar'),
('donering','1|donera'),
('doning','1|don'),
('donjuan','1|kvinnoförförare'),
('donka','1|äta'),
('donkande','1|donka'),
('Donken','1|McDonalds'),
('Donken','1|McDonalds'),
('donkeypanna','1|ångpanna'),
('donläge','1|bryta'),
('donna','1|kvinna'),
('dop','1|döpa'),
('dopa','1|doping'),
('dopamin','1|signalsubstans'),
('dopaminblåsa','1|blåsa'),
('dopaminkänslig','1|känslig'),
('dopaminkänslighet','1|dopaminkänslig'),
('dopande','1|dopa'),
('dopattest','1|attest'),
('dopbassäng','1|bassäng'),
('dopfunt','1|dop'),
('doping','1|prestation'),
('doping','1|prestation'),
('dopningsbrott','1|doping'),
('dopningsbrott','1|doping'),
('dopningshärva','1|härva'),
('dopningshärva','1|härva'),
('dopningspreparat','1|preparat'),
('dopningspreparat','1|preparat'),
('dopp','1|doppa'),
('dopp','2|kaffedopp'),
('doppa','1|sänka'),
('doppa','2|dopp'),
('doppande','1|doppa'),
('doppande','2|doppa'),
('dopparedagen','1|julafton'),
('dopparedagen','1|julafton'),
('dopparedagen','1|julafton'),
('dopparedagen','1|julafton'),
('dopping','1|sjöfågel'),
('dopplereffekt','1|förskjutning'),
('doppning','1|doppa'),
('doppsko','1|beslag'),
('doppvärmare','1|värma'),
('dopskål','1|skål'),
('dopvatten','1|vatten'),
('dopvittne','1|vittne'),
('dorer','1|folk'),
('dorisk','1|byggnadsstil'),
('dormitorium','1|sovsal'),
('dorn','1|verktyg'),
('Dorpat','1|Tartu'),
('dorsal','1|språkljud'),
('dorsal','2|dorsal'),
('dorsal','3|rygg'),
('dorsk','1|lat'),
('dorskhet','1|dorsk'),
('dos','1|portion'),
('dosa','1|ask'),
('dosbarometer','1|aneroidbarometer'),
('dosekvivalent','1|dos'),
('dosera','1|dos'),
('dosera','1|dos'),
('dosera','2|lutning'),
('dosera','2|lutning'),
('doserande','1|dosera'),
('doserande','1|dosera'),
('doserande','2|dosera'),
('doserande','2|dosera'),
('doserbar','1|dosera'),
('doserbar','1|dosera'),
('doserbar','2|dosera'),
('doserbar','2|dosera'),
('doserbarhet','1|doserbar'),
('doserbarhet','1|doserbar'),
('doserbarhet','2|doserbar'),
('doserbarhet','2|doserbar'),
('dosering','1|dosera'),
('dosering','1|dosera'),
('dosering','2|dosera'),
('dosering','2|dosera'),
('dosimeter','1|mäta'),
('dosimetri','1|dosimeter'),
('dosis','1|dos'),
('doslibell','1|vattenpass'),
('dosmätare','1|dosimeter'),
('dossier','1|dokument'),
('dossier','1|dokument'),
('dotation','1|dotera'),
('dotera','1|donera'),
('doterande','1|dotera'),
('doterbar','1|dotera'),
('doterbarhet','1|doterbar'),
('dotering','1|dotera'),
('dotter','1|familj'),
('dotterbarn','1|barn'),
('dotterbolag','1|bolag'),
('dottercell','1|cell'),
('dotterdotter','1|släkting'),
('dotterföretag','1|företag'),
('dotterförsamling','1|församling'),
('dotterlig','1|dotter'),
('dotterlighet','1|dotterlig'),
('dotterskap','1|dotter'),
('dotterson','1|släkting'),
('dotterspråk','1|språk'),
('dottersvulst','1|cancersvulst'),
('dottertumör','1|metastas'),
('doublé','1|metall'),
('doublé','1|metall'),
('doublé','2|dubbelträff'),
('doublé','2|dubbelträff'),
('dov','1|svag'),
('Dover','1|huvudstad'),
('dovhet','1|dov'),
('dovhjort','1|hjort'),
('downperiod','1|period'),
('doyen','1|diplomat'),
('dra','1|röra'),
('dra','1|röra'),
('dra','2|ge_sig_av'),
('dra','3|välja_ut'),
('dra','4|färdig'),
('dra','5|gå'),
('drabant','1|livvakt'),
('drabant','2|måne'),
('drabantstat','1|stat'),
('drabba','1|slå'),
('drabbande','1|drabba'),
('drabbning','1|kraftmätning'),
('Draconiderna','1|stjärnfall'),
('Dracula','1|vampyr'),
('drag','1|dra'),
('drag','2|egenskap'),
('drag','3|blåsa'),
('drag','4|fiskedrag'),
('drag','5|schackpjäs'),
('drag','6|livad'),
('drag','7|handla'),
('dragande','1|dra'),
('dragande','2|dra'),
('dragare','1|last'),
('dragband','1|järnstag'),
('dragbasun','1|basun'),
('dragbil','1|bil'),
('dragbänk','1|rör'),
('dragdjur','1|djur'),
('dragé','1|tablett'),
('dragen','1|berusad'),
('dragen','2|dras'),
('dragenhet','1|dragen'),
('dragenhet','2|dragen'),
('dragenhet','3|maskin'),
('dragera','1|dragé'),
('dragerande','1|dragera'),
('dragerbar','1|dragera'),
('dragerbarhet','1|dragerbar'),
('dragering','1|dragera'),
('dragfri','1|drag'),
('dragg','1|ankare'),
('dragga','1|genomsöka'),
('draggande','1|dragga'),
('dragglina','1|lina'),
('draggning','1|dragga'),
('dragharmonika','1|dragspel'),
('draghjälp','1|hjälp'),
('draghållfasthet','1|hållfasthet'),
('draghäst','1|häst'),
('dragig','1|drag'),
('dragkamp','1|kamp'),
('dragkedja','1|stänga'),
('dragkista','1|byrå'),
('dragkraft','1|motorstyrka'),
('dragkrok','1|bogsera'),
('dragkärra','1|kärra'),
('draglapp','1|lapp'),
('draglina','1|bogsera'),
('draglucka','1|lucka'),
('dragläge','1|läge'),
('dragnagel','1|sup'),
('dragning','1|dra'),
('dragning','2|lotteri'),
('dragning','3|bearbeta'),
('dragning','4|böjelse'),
('dragning','5|nyans'),
('dragningskraft','1|kraft'),
('dragningskraft','2|tyngdkraft'),
('dragningslista','1|resultatlista'),
('dragnät','1|nät'),
('dragoman','1|tolk'),
('dragon','1|kavallerist'),
('dragon','2|örtkrydda'),
('Dragos','1|Fantomen'),
('Dragos','2|Fantomen'),
('dragplåster','1|attraktion'),
('dragpress','1|press'),
('dragpressning','1|dragpress'),
('dragprov','1|draghållfasthet'),
('dragracing','1|motorsport'),
('dragrem','1|rem'),
('dragrep','1|rep'),
('dragshow','1|show'),
('dragskiva','1|dragning'),
('dragsko','1|fåll'),
('dragskåp','1|fläkt'),
('dragsnöre','1|snöre'),
('dragspel','1|instrument'),
('dragspelsmusik','1|musik'),
('dragstift','1|penna'),
('dragstyrka','1|styrka'),
('dragstång','1|stång'),
('dragupprepning','1|upprepning'),
('dragväg','1|väg'),
('draja','1|dry_martini'),
('drakblod','1|harts'),
('drakblodsträd','1|träd'),
('drake','1|djur'),
('drake','2|leksak'),
('drake','3|drakskepp'),
('Draken','1|flygplan'),
('drakflygare','1|flyga'),
('drakhuvudfisk','1|fisk'),
('drakma','1|myntenhet'),
('drakma','1|myntenhet'),
('drakonisk','1|sträng'),
('Drakryggen','1|berg'),
('drakskepp','1|vikingaskepp'),
('drakslinga','1|ornament'),
('drakstjärt','1|stjärt'),
('draksådd','1|verksamhet'),
('draködla','1|ödla'),
('drama','1|teater'),
('drama','1|teater'),
('drama','2|händelse'),
('dramakonst','1|dramatik'),
('Dramaten','1|teater'),
('dramaten','1|varukasse'),
('dramaten','1|varukasse'),
('dramaten','1|varukasse'),
('Dramatenchef','1|chef'),
('dramatik','1|drama'),
('dramatik','2|drama'),
('dramatiker','1|drama'),
('dramatisera','1|dramatisk'),
('dramatisera','2|dramatisk'),
('dramatiserande','1|dramatisera'),
('dramatiserande','2|dramatisera'),
('dramatiserbar','1|dramatisera'),
('dramatiserbarhet','1|dramatiserbar'),
('dramatisering','1|dramatisera'),
('dramatisering','2|dramatisera'),
('dramatisk','1|drama'),
('dramatisk','2|drama'),
('dramaturg','1|dramatiker'),
('dramaturgi','1|drama'),
('dramaturgisk','1|dramaturgi'),
('drank','1|mäsk'),
('drapa','1|hyllningsdikt'),
('drapera','1|veck'),
('draperande','1|drapera'),
('draperbar','1|drapera'),
('draperbarhet','1|draperbar'),
('draperi','1|skydd'),
('drapering','1|drapera'),
('dras','1|uthärda'),
('dras','2|dragningskraft'),
('drastisk','1|häftig'),
('drasut','1|man'),
('dratta','1|ramla'),
('drattande','1|dratta'),
('drav','1|mäsk'),
('Drava','1|biflod'),
('dravel','1|struntprat'),
('dravid','1|dravidfolk'),
('dravidfolk','1|folk'),
('dravidisk','1|dravidfolk'),
('dravla','1|dravel'),
('dravlande','1|dravla'),
('dregel','1|dregla'),
('dregel','1|dregla'),
('dregla','1|saliv'),
('dregla','1|saliv'),
('dreglande','1|dregla'),
('dreglande','1|dregla'),
('dreja','1|forma'),
('drejande','1|dreja'),
('drejskiva','1|dreja'),
('drejvända','1|vända'),
('drejvändande','1|drejvända'),
('dress','1|kläder'),
('dressera','1|inöva'),
('dresserande','1|dressera'),
('dresserbar','1|dressera'),
('dresserbarhet','1|dresserbar'),
('dressering','1|dressera'),
('dressin','1|fordon'),
('dressing','1|sås'),
('dressyr','1|dressera'),
('dressyrridning','1|ridning'),
('dressör','1|dressera'),
('drev','1|jakt'),
('drev','2|tågvirke'),
('drev','3|kugghjul'),
('dreva','1|täta'),
('drevande','1|dreva'),
('drever','1|jakthund'),
('drevhund','1|jakthund'),
('drevjakt','1|drev'),
('drevkarl','1|drev'),
('drevkedja','1|drev'),
('drevning','1|dreva'),
('dribbla','1|fotboll'),
('dribblande','1|dribbla'),
('dribbler','1|dribbla'),
('dribbling','1|dribbla'),
('dricka','1|vatten'),
('dricka','2|dryck'),
('dricka','3|dricka'),
('dricka','4|dricka'),
('drickande','1|dricka'),
('drickankare','1|damejeanne'),
('drickbar','1|dricka'),
('drickbarhet','1|drickbar'),
('drickning','1|dricka'),
('drickning','2|dricka'),
('dricks','1|betala'),
('dricksglas','1|glas'),
('drickspengar','1|dricks'),
('dricksvatten','1|vatten'),
('drift','1|driva'),
('drift','2|begär'),
('drift','3|driva'),
('drift','4|driva'),
('drifta','1|drift'),
('driftande','1|drifta'),
('driftbudget','1|budget'),
('driftfel','1|fel'),
('driftig','1|företagsam'),
('driftighet','1|driftig'),
('driftkapital','1|kapital'),
('driftkucku','1|drift'),
('driftliv','1|drift'),
('driftmässig','1|drift'),
('driftmässig','1|drift'),
('driftning','1|drifta'),
('driftskostnad','1|kostnad'),
('driftskostnad','1|kostnad'),
('driftsstöd','1|stöd'),
('driftstillestånd','1|stillestånd'),
('driftstillstånd','1|tillstånd'),
('driftstopp','1|stopp'),
('driftsäker','1|säker'),
('driftsäkerhet','1|driftsäker'),
('driftsäkerhetsmässig','1|driftsäkerhet'),
('drifttid','1|tid'),
('drifttillgänglighet','1|tillgänglighet'),
('driftvärn','1|värn'),
('drill','1|drilla'),
('drill','2|drilla'),
('drill','3|drillborr'),
('drill','4|plöja'),
('drill','5|uppvisning'),
('drilla','1|inöva'),
('drilla','2|kvittra'),
('drilla','3|drillborr'),
('drilla','4|drill'),
('drillande','1|drilla'),
('drillande','2|drilla'),
('drillande','3|drilla'),
('drillande','4|drilla'),
('drillborr','1|borr'),
('drillflicka','1|flicka'),
('drilling','1|gevär'),
('drillprogram','1|program'),
('drillsnäppa','1|snäppa'),
('drillstav','1|stav'),
('drink','1|dryck'),
('drinkare','1|alkoholist'),
('dristig','1|drista_sig'),
('dristighet','1|dristig'),
('drittel','1|laggkärl'),
('driv','1|drev'),
('driv','2|initiativkraft'),
('driva','1|röra'),
('driva','2|göra'),
('driva','3|hög'),
('driva','4|håna'),
('driva','5|röra_sig'),
('driva','6|irra'),
('drivande','1|driftig'),
('drivande','2|driva'),
('drivande','3|driva'),
('drivande','4|driva'),
('drivande','5|driva'),
('drivankare','1|ankare'),
('drivaxel','1|axel'),
('drivband','1|band'),
('drivbänk','1|odla'),
('drive','1|kampanj'),
('drive','2|slag'),
('driven','1|skicklig'),
('drivenhet','1|driven'),
('driveri','1|driva'),
('driveri','2|driva'),
('drivfjäder','1|sporra'),
('drivflykt','1|rymdfarkost'),
('drivgarn','1|fisknät'),
('drivhjul','1|drivaxel'),
('drivhus','1|odla'),
('drivhuseffekt','1|växthuseffekt'),
('drivhusklimat','1|klimat'),
('drivhusplanta','1|planta'),
('drivis','1|is'),
('drivkedja','1|kedja'),
('drivkraft','1|kraft'),
('drivlina','1|långrev'),
('drivlina','2|drivrem'),
('drivmedel','1|bränsle'),
('drivmedelsbehov','1|behov'),
('drivning','1|metallurgi'),
('drivrem','1|rem'),
('drivsand','1|flygsand'),
('drivsnö','1|snö'),
('drivved','1|virke'),
('drivverk','1|driva'),
('drog','1|medicin'),
('droga','1|drog'),
('droga','2|droga_sig'),
('drogande','1|droga'),
('drogande','2|droga'),
('drogberoende','1|beroende'),
('drogeffekt','1|effekt'),
('drogeri','1|affär'),
('drogfri','1|drogmissbruk'),
('droghandel','1|handel'),
('droghandlare','1|narkotikahandel'),
('droghandlare','2|handlare'),
('drogliberal','1|tillåta'),
('drogliberal','2|drogliberal'),
('drogliberalism','1|drogliberal'),
('drogmissbruk','1|missbruk'),
('drogmissbrukande','1|missbruka'),
('drogmissbrukare','1|missbruka'),
('drogmyt','1|myt'),
('drogpolicy','1|policy'),
('drogpåverkad','1|påverkad'),
('drogrelaterad','1|relatera'),
('drogsug','1|sug'),
('drogtest','1|test'),
('drogtesta','1|testa'),
('drogtestande','1|drogtesta'),
('drogtestning','1|drogtesta'),
('drogvana','1|vana'),
('dromedar','1|kamel'),
('dront','1|duvfågel'),
('dropp','1|droppa'),
('dropp','2|näring'),
('droppa','1|rinna'),
('droppa','2|strunta'),
('droppande','1|droppa'),
('droppande','2|droppa'),
('droppe','1|våt'),
('droppflaska','1|dropp'),
('droppfri','1|droppa'),
('droppglas','1|pipett'),
('droppinfektion','1|infektion'),
('droppkork','1|serveringskork'),
('droppnäsa','1|avleda'),
('droppspets','1|spets'),
('droppsten','1|kalksten'),
('droppstensgrotta','1|grotta'),
('droppstilla','1|stilla'),
('droppvis','1|droppe'),
('droska','1|taxi'),
('droskbil','1|taxi'),
('droskförare','1|förare'),
('drossel','1|elektricitet'),
('drots','1|ämbetsman'),
('drott','1|hövding'),
('drottkväde','1|versmått'),
('drottning','1|kung'),
('drottning','2|schackpjäs'),
('drottningbesatt','1|besatt'),
('Drottningholm','1|slott'),
('Drottningholmsteatern','1|teater'),
('drottningkrona','1|krona'),
('drottninglik','1|likna'),
('drottningsylt','1|sylt'),
('drucken','1|berusad'),
('druckenhet','1|drucken'),
('drufs','1|drulle'),
('druid','1|präst'),
('druidisk','1|druid'),
('druidkult','1|kult'),
('drul','1|drulle'),
('drulig','1|drul'),
('drulla','1|drulle'),
('drullande','1|drulla'),
('drulle','1|slarvig'),
('drulleförsäkring','1|försäkring'),
('drullig','1|drulle'),
('drullighet','1|drullig'),
('drullputt','1|drulle'),
('drumla','1|drulla'),
('drumlande','1|drumla'),
('drumlig','1|drullig'),
('drumlighet','1|drumlig'),
('drummel','1|drulle'),
('drummelaktig','1|drummel'),
('drummelaktighet','1|drummelaktig'),
('drunkna','1|dö'),
('drunknande','1|drunkna'),
('drunkning','1|drunkna'),
('drunkningsdöd','1|drunkning'),
('drunkningsmetafor','1|metafor'),
('drunkningsolycka','1|olycka'),
('drunkningsår','1|år'),
('drus','1|geologi'),
('druser','1|folk'),
('druva','1|vindruva'),
('druvblå','1|rödblå'),
('druvbörd','1|abort'),
('druvfläder','1|fläder'),
('druvgurka','1|gurka'),
('druvhagel','1|hagel'),
('druvklase','1|druva'),
('druvrussin','1|russin'),
('druvsaft','1|saft'),
('druvsocker','1|socker'),
('dryad','1|nymf'),
('dryck','1|dricka'),
('dryck','2|dryck'),
('dryckenskap','1|supa'),
('dryckesbroder','1|vän'),
('dryckesbägare','1|bägare'),
('dryckesfrågan','1|fråga'),
('dryckesgille','1|dryckeslag'),
('dryckeshorn','1|horn'),
('dryckeskärl','1|kärl'),
('dryckeslag','1|fest'),
('dryckesoffer','1|offer'),
('dryckesorgie','1|dryckeslag'),
('dryckesservis','1|servis'),
('dryckesvana','1|vana'),
('dryckesvisa','1|snapsvisa'),
('dryckjom','1|brännvin'),
('dryfta','1|diskutera'),
('dryftande','1|dryfta'),
('dryftning','1|dryfta'),
('dryg','1|mycken'),
('dryg','2|högfärdig'),
('dryghet','1|dryg'),
('dryghet','2|dryg'),
('drygsel','1|dryg'),
('drypa','1|rinna'),
('drypande','1|drypa'),
('drypning','1|drypa'),
('dråp','1|döda'),
('dråpare','1|dråp'),
('dråplig','1|rolig'),
('dråplig','2|präktig'),
('dråplighet','1|dråplig'),
('dråplighet','2|dråplig'),
('dråprättegång','1|rättegång'),
('dråpslag','1|tillintetgöra'),
('dråsa','1|falla'),
('dråsande','1|dråsa'),
('dråse','1|hög'),
('drägg','1|slödder'),
('dräglig','1|uthärda'),
('dräglighet','1|dräglig'),
('dräkt','1|kläder'),
('dräkt','2|kostym'),
('dräktig','1|föda'),
('dräktighet','1|havandeskap'),
('dräktighet','2|last'),
('dräktskick','1|skick'),
('dräktspänne','1|spänne'),
('dräll','1|vävnad'),
('drälla','1|röra'),
('drälla','2|mången'),
('drällande','1|drälla'),
('drällande','2|drälla'),
('drämma','1|slå'),
('drämmande','1|drämma'),
('drän','1|dränering'),
('dränage','1|torka'),
('dränera','1|avlägsna'),
('dränerande','1|dränera'),
('dränerbar','1|dränera'),
('dränerbarhet','1|dränerbar'),
('dränering','1|dränera'),
('dräneringsdike','1|dike'),
('dräneringsområde','1|område'),
('dräneringsrör','1|rör'),
('dräng','1|tjäna'),
('drängtjänst','1|tjäna'),
('dränka','1|drunkna'),
('dränka','2|sänka'),
('dränkande','1|dränka'),
('dränkande','2|dränka'),
('dränkbar','1|nedsänka'),
('dränkbarhet','1|dränkbar'),
('dränkning','1|dränka'),
('dränkning','2|dränka'),
('dräpa','1|dråp'),
('dräpande','1|tillintetgörande'),
('dräpande','2|dräpa'),
('drätsel','1|drätselkammare'),
('drätselkammare','1|kommunstyrelse'),
('drätselnämnd','1|nämnd'),
('drätt','1|bonad'),
('drög','1|kälke'),
('dröglapp','1|hudveck'),
('dröja','1|stanna'),
('dröjande','1|dröja'),
('dröjsmål','1|fördröjning'),
('dröjsmålsränta','1|ränta'),
('dröm','1|verklig'),
('dröm','2|småkaka'),
('dröm','3|önskedröm'),
('drömbild','1|dröm'),
('drömbok','1|drömtydning'),
('drömboken','1|dagbok'),
('drömd','1|drömma'),
('drömd','2|drömma'),
('drömdejt','1|dejt'),
('drömgräns','1|rekord'),
('drömkandidat','1|kandidat'),
('drömlandskap','1|landskap'),
('drömlik','1|dröm'),
('drömlikhet','1|drömlik'),
('drömliknande','1|dröm'),
('drömliv','1|liv'),
('drömlön','1|lön'),
('drömma','1|dröm'),
('drömma','2|dröm'),
('drömmande','1|drömma'),
('drömmande','2|drömma'),
('drömmare','1|drömma'),
('drömmeri','1|drömma'),
('drömmilen','1|lopp'),
('drömmål','1|mål'),
('drömresa','1|resa'),
('drömrumpa','1|rumpa'),
('drömsk','1|dröm'),
('drömskapelse','1|skapelse'),
('drömskhet','1|drömsk'),
('drömslott','1|dagdröm'),
('drömstart','1|start'),
('drömsyn','1|syn'),
('drömsällskap','1|sällskap'),
('drömsömn','1|sömn'),
('drömtydande','1|tyda'),
('drömtydare','1|tyda'),
('drömtydning','1|tyda'),
('drömtydningsbok','1|drömbok'),
('drömvärld','1|dagdröm'),
('dröna','1|lat'),
('drönande','1|dröna'),
('drönarattack','1|attack'),
('drönarbas','1|bas'),
('drönare','1|bi'),
('drönare','2|dröna'),
('drönare','3|flygplan'),
('drönarförespråkare','1|förespråkare'),
('drönarliv','1|liv'),
('drönarräd','1|räd'),
('dröppel','1|gonorré'),
('drös','1|hög'),
('drösa','1|falla'),
('drösande','1|drösa'),
('drösvis','1|drös'),
('du','1|vem'),
('du','1|vem'),
('dua','1|tilltala'),
('dualform','1|dualis'),
('dualis','1|två'),
('dualis','1|två'),
('dualism','1|dubbel'),
('dualist','1|dualism'),
('dualistisk','1|dualism'),
('duande','1|dua'),
('Dubai','1|stat'),
('Dubaifrossa','1|frossa'),
('dubb','1|förhindra'),
('dubb','2|svarv'),
('dubba','1|översätta'),
('dubba','2|utse'),
('dubba','3|dubb'),
('dubbande','1|dubba'),
('dubbande','2|dubba'),
('dubbande','3|dubba'),
('dubbdocka','1|docka'),
('dubbdäck','1|vinterdäck'),
('dubbdäcksförbud','1|förbud'),
('dubbel','1|två'),
('dubbel','2|tävling'),
('dubbelagent','1|spioneri'),
('dubbelansikte','1|personlighet'),
('dubbelarbetande','1|arbeta'),
('dubbelbeckasin','1|vadarfågel'),
('dubbelbeskatta','1|beskatta'),
('dubbelbeskattande','1|dubbelbeskatta'),
('dubbelbiff','1|biff'),
('dubbelbindning','1|elektronpar'),
('dubbelbindning','2|handlingsförlamning'),
('dubbelbluff','1|bluff'),
('dubbelbotten','1|botten'),
('dubbelbottnad','1|dubbelbotten'),
('dubbelbottnad','2|undermening'),
('dubbelbredd','1|tygbredd'),
('dubbelbrytning','1|ljusbrytning'),
('dubbelbröllop','1|bröllop'),
('dubbelbössa','1|bössa'),
('dubbeldäckare','1|tvåvåningsbuss'),
('dubbeldörr','1|dörr'),
('dubbelexponera','1|exponera'),
('dubbelexponerande','1|dubbelexponera'),
('dubbelexponerbar','1|dubbelexponera'),
('dubbelexponerbarhet','1|dubbelexponerbar'),
('dubbelexponering','1|dubbelexponera'),
('dubbelfel','1|tennis'),
('dubbelfönster','1|glasruta'),
('dubbelgarage','1|garage'),
('dubbelgrepp','1|stränginstrument'),
('dubbelgångare','1|person'),
('dubbelhaka','1|haka'),
('dubbelhandsfattning','1|fattning'),
('dubbelhet','1|dubbel'),
('dubbelhytt','1|hytt'),
('dubbelhäftande','1|vidhäfta'),
('dubbelhölster','1|hölster'),
('dubbelklick','1|dubbelklicka'),
('dubbelklicka','1|klicka'),
('dubbelklickande','1|dubbelklicka'),
('dubbelklickning','1|dubbelklicka'),
('dubbelknäppt','1|knäppa'),
('dubbelkoll','1|dubbelkolla'),
('dubbelkolla','1|kolla'),
('dubbelkollande','1|dubbelkolla'),
('dubbelkollning','1|dubbelkolla'),
('dubbelkommando','1|kommando'),
('dubbelkontakt','1|kontakt'),
('dubbelkvartett','1|kvartett'),
('dubbelkör','1|kör'),
('dubbelliv','1|liv'),
('dubbelmadrass','1|madrass'),
('dubbelmening','1|tvetydig'),
('dubbelmoral','1|moral'),
('dubbelmord','1|mord'),
('dubbelnatur','1|personlighet'),
('dubbelnelson','1|brottningsgrepp'),
('dubbelnöt','1|nöt'),
('dubbelpanera','1|panera'),
('dubbelpanerande','1|dubbelpanera'),
('dubbelpanering','1|dubbelpanera'),
('dubbelpipig','1|pipa'),
('dubbelrevolution','1|revolution'),
('dubbelriktad','1|rikta'),
('dubbelroll','1|roll'),
('dubbelrum','1|hotellrum'),
('dubbelrör','1|rör'),
('dubbelsalt','1|förening'),
('dubbelseende','1|se_dubbelt'),
('dubbelsidig','1|sida'),
('dubbelspel','1|vilseleda'),
('dubbelspår','1|dubbelspårig'),
('dubbelspårig','1|järnvägsspår'),
('dubbelspårsutbyggnad','1|utbyggnad'),
('dubbelstjärna','1|stjärna'),
('dubbelstjärnsystem','1|stjärnsystem'),
('dubbelsträngad','1|sträng'),
('dubbelsyn','1|se_dubbelt'),
('dubbelsäkring','1|säkring'),
('dubbelsäng','1|säng'),
('dubbeltimme','1|lektionstimme'),
('dubbeltimme','1|lektionstimme'),
('dubbeltrast','1|trast'),
('dubbeltrådig','1|tråd'),
('dubbelträff','1|träff'),
('dubbeltydig','1|betydelse'),
('dubbeltydighet','1|dubbeltydig'),
('dubbelverkande','1|verka'),
('dubbelvikt','1|vika'),
('dubbelörn','1|riksvapen'),
('dubbfri','1|dubb'),
('dubbförbud','1|förbud'),
('dubbhöjd','1|höjd'),
('dubbla','1|fördubbla'),
('dubblande','1|dubbla'),
('dubblare','1|elektronik'),
('dubblera','1|fördubbla'),
('dubblerande','1|dubblera'),
('dubblerbar','1|dubblera'),
('dubblerbarhet','1|dubblerbar'),
('dubblering','1|dubblera'),
('dubblett','1|exemplar'),
('dubblett','1|exemplar'),
('dubblett','2|bostad'),
('dubblett','2|bostad'),
('dubbning','1|dubba'),
('dubbning','2|dubba'),
('dubbning','3|dubba'),
('dubbslitage','1|vägslitage'),
('dubier','1|tvivel'),
('dubiös','1|ifrågasätta'),
('Dublin','1|huvudstad'),
('dubror','1|dua'),
('duchesse','1|siden'),
('ducka','1|undvika'),
('duckande','1|ducka'),
('duell','1|kamp'),
('duellant','1|duell'),
('duellera','1|duell'),
('duellerande','1|duellera'),
('duellering','1|duellera'),
('duellväsen','1|duell'),
('duenna','1|förkläde'),
('duett','1|musikstycke'),
('duettsång','1|sång'),
('duffel','1|rock'),
('duga','1|bra'),
('duga','2|förmå'),
('dugande','1|duga'),
('dugande','2|duga'),
('dugande','3|duga'),
('dugga','1|duggregna'),
('duggande','1|dugga'),
('duggregn','1|duggregna'),
('duggregna','1|regna'),
('duggregnande','1|duggregna'),
('duglig','1|duga'),
('duglighet','1|duglig'),
('duk','1|tyg'),
('duka','1|bord'),
('duka','2|orsaka'),
('dukagång','1|vävnad'),
('dukande','1|duka'),
('dukat','1|guldmynt'),
('dukning','1|duka'),
('dukt','1|tross'),
('duktig','1|kunna'),
('duktighet','1|duktig'),
('dulcian','1|instrument'),
('dum','1|klok'),
('dum','2|elak'),
('dum','3|dålig'),
('duma','1|parlament'),
('dumbom','1|dum'),
('dumburk','1|TV-apparat'),
('dumdristig','1|obetänksam'),
('dumdristighet','1|dumdristig'),
('dumdryg','1|högfärdig'),
('dumdryghet','1|dumdryg'),
('dumdumkula','1|gevärskula'),
('dumhet','1|dum'),
('dumhuvud','1|dum'),
('dumkåt','1|kåt'),
('dummer','1|dumbom'),
('dummerjöns','1|dumbom'),
('dumming','1|dum'),
('dummy','1|imitera'),
('dumpa','1|last'),
('dumpa','2|sänka'),
('dumpa','3|avbryta'),
('dumpande','1|dumpa'),
('dumpande','2|dumpa'),
('dumpande','3|dumpa'),
('dumper','1|lastbil'),
('dumpning','1|dumpa'),
('dumpning','2|dumpa'),
('dumskalle','1|dumbom'),
('dumskallemajoritet','1|majoritet'),
('dumsnut','1|dumbom'),
('dumsnål','1|snål'),
('dumstrut','1|häckla'),
('dun','1|fjäder'),
('duna','1|dun'),
('dunande','1|duna'),
('dunboll','1|fågelunge'),
('dunboll','2|boll'),
('dunbolster','1|bolster'),
('dunbädd','1|bädd'),
('Dundee','1|stad'),
('dunder','1|dundra'),
('dundergud','1|gud'),
('dunderhonung','1|honung'),
('dunderkur','1|kur'),
('dundermedicin','1|botemedel'),
('dundra','1|dåna'),
('dundrande','1|dundra'),
('dunge','1|skog'),
('dunig','1|dun'),
('dunk','1|behållare'),
('dunk','2|dunka'),
('dunk','3|dunk'),
('dunk','3|dunk'),
('dunka','1|slå'),
('dunka','1|slå'),
('dunkande','1|dunka'),
('dunkande','1|dunka'),
('dunkel','1|mörk'),
('dunkel','2|dunkel'),
('dunkel','3|oklar'),
('dunkelblå','1|blå'),
('dunkelhet','1|dunkel'),
('dunkning','1|dunka'),
('dunkudde','1|kudde'),
('dunlätt','1|lätt'),
('dunmjuk','1|mjuk'),
('duns','1|dunsa'),
('dunsa','1|falla'),
('dunsande','1|dunsa'),
('dunst','1|lukt'),
('dunsta','1|avdunsta'),
('dunsta','2|ge_sig_av'),
('dunstande','1|dunsta'),
('dunstande','2|dunsta'),
('dunstig','1|töcknig'),
('dunstighet','1|dunstig'),
('duntäcke','1|täcke'),
('dununge','1|fågelunge'),
('duo','1|duett'),
('duodecimalsystem','1|talsystem'),
('duodes','1|tryck'),
('duodesformat','1|duodes'),
('dupera','1|vilseleda'),
('duperande','1|dupera'),
('duperbar','1|dupera'),
('duperbarhet','1|duperbar'),
('dupering','1|dupera'),
('duplett','1|dubblett'),
('duplexfärg','1|tryckfärg'),
('duplicera','1|mångfaldiga'),
('duplicerande','1|duplicera'),
('duplicerbar','1|duplicera'),
('duplicerbarhet','1|duplicerbar'),
('duplicering','1|duplicera'),
('duplik','1|försvarsskrift'),
('duplikat','1|kopia'),
('duplikator','1|duplicera'),
('dur','1|tonart'),
('durabel','1|varaktig'),
('durackord','1|ackord'),
('duralexglas','1|glas'),
('duraluminium','1|aluminium'),
('durativ','1|fortlöpa'),
('dureform','1|reform'),
('durk','1|golv'),
('durka','1|skena'),
('durkande','1|durka'),
('durkdriven','1|skicklig'),
('durkmönster','1|mönster'),
('durkslag','1|sil'),
('duroplast','1|plast'),
('durra','1|sädesslag'),
('durskala','1|skala'),
('durtonart','1|dur'),
('durumvete','1|vete'),
('dus','1|tvåa'),
('dusch','1|duscha'),
('duscha','1|bada'),
('duschande','1|duscha'),
('duschbrunn','1|avloppsbrunn'),
('duschdraperi','1|draperi'),
('duschhandduk','1|handduk'),
('duschhandtag','1|handtag'),
('duschkräm','1|kräm'),
('duschslang','1|vattenslang'),
('duschvana','1|vana'),
('duschvägg','1|vägg'),
('dusk','1|regn'),
('duska','1|dusk'),
('duskande','1|duska'),
('duskål','1|dua'),
('dussin','1|tolv'),
('dussinarbete','1|arbete'),
('dussinmänniska','1|människa'),
('dussinroman','1|roman'),
('dussintal','1|dussin'),
('dussintals','1|dussin'),
('dussinvara','1|vara'),
('dussinvis','1|dussin'),
('dust','1|kamp'),
('dusör','1|gåva'),
('duva','1|fågel'),
('duva','2|stampa'),
('duva','3|fredlig'),
('duvande','1|duva'),
('duvblå','1|gråblå'),
('duven','1|trött'),
('duvenhet','1|duven'),
('duvfågel','1|duva'),
('duvhök','1|rovfågel'),
('duvjävel','1|jävel'),
('duvkulla','1|skogsstjärna'),
('duvna','1|duven'),
('duvnande','1|duvna'),
('duvning','1|träning'),
('duvpolitik','1|politik'),
('duvpost','1|brevduva'),
('duvslag','1|tamduva'),
('duvunge','1|oerfaren'),
('dvala','1|sömn'),
('dvallik','1|dvala'),
('DVD','1|film'),
('DVD','1|film'),
('dvd-film','1|film'),
('dvd-film','1|film'),
('DVD-ROM','1|datorminne'),
('DVD-ROM','1|datorminne'),
('DVD-spelare','1|DVD'),
('DVD-spelare','1|DVD'),
('D-vitamin','1|vitamin'),
('D-vitaminbrist','1|brist'),
('dväljas','1|bo'),
('dvärg','1|liten'),
('dvärgaktig','1|dvärg'),
('dvärgaktighet','1|dvärgaktig'),
('dvärgalåt','1|kritik'),
('dvärgartad','1|dvärg'),
('dvärgbeckasin','1|vadarfågel'),
('dvärgbjörk','1|björk'),
('dvärgbrytare','1|automatsäkring'),
('dvärgbuske','1|buske'),
('dvärggalax','1|galax'),
('dvärghamster','1|hamster'),
('dvärghund','1|hund'),
('dvärglik','1|dvärg'),
('dvärgmås','1|mås'),
('dvärgschimpans','1|schimpans'),
('dvärgtall','1|tall'),
('dvärgväxt','1|förkrympt'),
('dy','1|slam'),
('dyblad','1|vattenväxt'),
('dyblöt','1|blöt'),
('dyblöthet','1|dyblöt'),
('dyborre','1|vattenaloe'),
('dybotten','1|sjöbotten'),
('dyckert','1|spik'),
('dygd','1|god'),
('dygdemönster','1|förebild'),
('dygderik','1|dygdig'),
('dygdig','1|dygd'),
('dygdighet','1|dygdig'),
('dygn','1|dag'),
('dygnetruntöppen','1|öppen'),
('dygnsgammal','1|dygn'),
('dygnslång','1|dygn'),
('dygnsring','1|ring'),
('dygnsrytm','1|rytm'),
('dygnsvila','1|vila'),
('dygnsvill','1|vilsen'),
('dygnsvillhet','1|dygnsvill'),
('dygnsvis','1|dygn'),
('dygnsvis','2|dygnsvis'),
('dyig','1|dy'),
('dyighet','1|dyig'),
('dyka','1|ner'),
('dykand','1|and'),
('dykande','1|dyka'),
('dykarbagge','1|skalbagge'),
('dykardräkt','1|dräkt'),
('dykare','1|dyka'),
('dykare','2|skalbagge'),
('dykarklocka','1|dykning'),
('dykarsjuka','1|besvär'),
('dykarutrustning','1|utrustning'),
('dykdalb','1|påle'),
('dykeri','1|dyka'),
('dykning','1|dyka'),
('dykningsolycka','1|olycka'),
('dykolycka','1|dykningsolycka'),
('dylik','1|sådan'),
('dymedelst','1|sätt'),
('dymedelst','1|sätt'),
('dymling','1|träplugg'),
('dymlingförband','1|förband'),
('dymmelonsdag','1|askonsdag'),
('dymmelveckan','1|vecka'),
('dyn','1|hög'),
('dyn','2|mått'),
('dyna','1|sitta'),
('dynamik','1|kraft'),
('dynamisk','1|kraft'),
('dynamism','1|åskådning'),
('dynamistisk','1|dynamism'),
('dynamit','1|sprängämne'),
('dynamitard','1|inbrottstjuv'),
('dynamitgubbe','1|dynamit'),
('dynamo','1|generator'),
('dynamometer','1|mäta'),
('dynasti','1|släkt'),
('dynastigrundare','1|grundare'),
('dynastisk','1|dynasti'),
('dynga','1|gödsel'),
('dyngbagge','1|skalbagge'),
('dyngfluga','1|fluga'),
('dyngfull','1|full'),
('dynggrep','1|grep'),
('dyngig','1|dynga'),
('dyngrak','1|stupfull'),
('dyngspridare','1|smutskasta'),
('dyngsur','1|sur'),
('dyngsurhet','1|dyngsur'),
('dyning','1|havsvåg'),
('dynlandskap','1|landskap'),
('dynt','1|larv'),
('dypöl','1|pöl'),
('dyr','1|kosta'),
('dyr','2|älska'),
('dyrbar','1|dyr'),
('dyrbarhet','1|dyrbar'),
('dyrgrip','1|dyrbarhet'),
('dyrhet','1|dyr'),
('dyrhet','2|dyr'),
('dyrk','1|nyckel'),
('dyrka','1|beundra'),
('dyrkan','1|dyrka'),
('dyrkande','1|dyrka'),
('dyrkansvärd','1|dyrka'),
('dyrkansvärdhet','1|dyrkansvärd'),
('dyrkare','1|dyrka'),
('dyrkfri','1|dyrka_upp'),
('dyrköpt','1|dyr'),
('dyrköpthet','1|dyrköpt'),
('dyrort','1|ort'),
('dyrortsgrupp','1|grupp'),
('dyrortsgruppering','1|dyrortsgrupp'),
('dyrtid','1|dyr'),
('dyrtidstillägg','1|lönetillägg'),
('dys','1|dysa'),
('dysa','1|munstycke'),
('dyscha','1|soffa'),
('dyschatell','1|dyscha'),
('dyschatell','1|dyscha'),
('dysenteri','1|sjukdom'),
('dysergi','1|synergi'),
('dysfori','1|depression'),
('dysfunktionell','1|funktionsoduglig'),
('dyslektiker','1|dyslektisk'),
('dyslektiker','1|dyslektisk'),
('dyslektisk','1|dyslexi'),
('dyslektisk','1|dyslexi'),
('dyslexi','1|ordblind'),
('dyspepsi','1|rubbning'),
('dysprosium','1|grundämne'),
('dysprosium','1|grundämne'),
('Düsseldorf','1|stad'),
('dyster','1|ledsen'),
('dysterhet','1|dyster'),
('dysterkvist','1|dyster'),
('dystopi','1|framtidsvision'),
('dystopisk','1|dystopi'),
('dystopiskhet','1|dystopisk'),
('dystrof','1|sötvatten'),
('dystrofi','1|rubbning'),
('dyvelsträck','1|medicin'),
('dyvik','1|vik'),
('dyvika','1|tapp'),
('dyvika','1|tapp'),
('dyvika','1|tapp'),
('dyvåt','1|dyblöt'),
('då','1|när'),
('då','2|eftersom'),
('då','3|följa'),
('dåd','1|gärning'),
('dådkraft','1|dåd'),
('dådkraftig','1|dådkraft'),
('dådlös','1|dåd'),
('dådlöshet','1|dådlös'),
('dådra','1|gräs'),
('dådrafrö','1|frö'),
('dåförtiden','1|då'),
('dålig','1|bra'),
('dålig','2|sjuk'),
('dålighet','1|dålig'),
('dålighet','2|dålig'),
('dåligheter','1|omoral'),
('dåmera','1|då'),
('dån','1|dåna'),
('dån','2|ogräs'),
('dåna','1|låta'),
('dåna','2|svimma'),
('dånande','1|dåna'),
('dånande','2|dåna'),
('dång','1|dingdång'),
('dåning','1|dåna'),
('dåning','2|dåna'),
('dåra','1|förleda'),
('dåraktig','1|dåre'),
('dåraktighet','1|dåraktig'),
('dårande','1|dåra'),
('dårdoktor','1|psykdoktor'),
('dåre','1|oförnuftig'),
('dårfink','1|dåre'),
('dårhus','1|mentalsjukhus'),
('dårhusmässig','1|dårhus'),
('dårskap','1|dåre'),
('dås','1|dåsighet'),
('dåsa','1|halvsova'),
('dåsande','1|dåsa'),
('dåsig','1|dåsa'),
('dåsighet','1|dåsig'),
('dåtida','1|då'),
('dåtiden','1|tid'),
('dåvarande','1|då'),
('däck','1|hjul'),
('däck','2|båt'),
('däcka','1|däck'),
('däcka','2|slå_ner'),
('däckad','1|sängliggande'),
('däckande','1|däcka'),
('däckande','2|däcka'),
('däckavtagning','1|avtagning'),
('däckbytarhelg','1|helg'),
('däckbyte','1|byte'),
('däckdimension','1|dimension'),
('däckel','1|sele'),
('däckel','2|topplock'),
('däckel','3|tryckpress'),
('däcker','1|skinn'),
('däckglans','1|glans'),
('däckhotell','1|förvaring'),
('däckhållare','1|hållare'),
('däckjärn','1|däckavtagning'),
('däckmärkning','1|märka'),
('däckmärkningsklämma','1|klämma'),
('däckpåse','1|förvara'),
('däcksbalk','1|spant'),
('däckslast','1|last'),
('däcksmanskap','1|manskap'),
('däckspassagerare','1|passagerare'),
('däcksplanka','1|planka'),
('däckventil','1|luftventil'),
('däckverkstad','1|verkstad'),
('dägga','1|dia'),
('däggande','1|dägga'),
('däggdjur','1|djur'),
('däggdjursgrupp','1|däggdjur'),
('däggdjurstand','1|tand'),
('däggdjurstyp','1|typ'),
('däggdjursunge','1|däggdjur'),
('däld','1|dal'),
('dämma','1|fördämning'),
('dämmande','1|dämma'),
('dämmare','1|tonstyrka'),
('dämme','1|fördämning'),
('dämning','1|fördämning'),
('dämpa','1|svag'),
('dämpad','1|lugn'),
('dämpande','1|dämpa'),
('dämpare','1|dämpa'),
('dämpbox','1|dämpa'),
('dämpning','1|dämpa'),
('dän','1|bort'),
('dän','1|bort'),
('däng','1|dänga'),
('dänga','1|slå'),
('dängande','1|dänga'),
('dänka','1|stänka'),
('dänkande','1|dänka'),
('där','1|var'),
('därav','1|av'),
('därbakom','1|bakom'),
('därborta','1|där'),
('därbortom','1|bortom'),
('därefter','1|efter'),
('däremellan','1|mellan'),
('däremot','1|men'),
('därest','1|om'),
('därframme','1|framme'),
('därför','1|för'),
('därför','1|för'),
('därförinnan','1|dessförinnan'),
('därförutan','1|dessförutan'),
('därhemma','1|hemma'),
('därhän','1|dit'),
('däri','1|i'),
('däribland','1|bland'),
('därifrån','1|från'),
('därigenom','1|genom'),
('därinifrån','1|inifrån'),
('därinnanför','1|innanför'),
('därinne','1|inne'),
('därjämte','1|dessutom'),
('därmed','1|med'),
('därnedanför','1|nedanför'),
('därnere','1|nere'),
('därnäst','1|näst'),
('därom','1|om'),
('däromkring','1|omkring'),
('däromkring','1|omkring'),
('däromkring','2|omkring'),
('däromkring','2|omkring'),
('därovanför','1|ovanför'),
('därproducerad','1|härproducerad'),
('därpå','1|sedan'),
('därstädes','1|plats'),
('därtappad','1|härtappad'),
('därtill','1|till'),
('därunder','1|under'),
('däruppe','1|uppe'),
('däruppe','1|uppe'),
('däruppifrån','1|uppifrån'),
('därur','1|ur'),
('därutanför','1|utanför'),
('därutav','1|därav'),
('därute','1|ute'),
('därutinnan','1|därom'),
('därutur','1|därur'),
('därutöver','1|dessutom'),
('därvarande','1|där'),
('därvid','1|då'),
('därvidlag','1|avse'),
('däråt','1|dit'),
('däröver','1|över'),
('däst','1|proppmätt'),
('dästhet','1|däst'),
('däven','1|unken'),
('dävenhet','1|däven'),
('dävert','1|lyfta'),
('dävna','1|däven'),
('dävnande','1|dävna'),
('däxel','1|yxa'),
('dö','1|leva'),
('döbattang','1|dörr'),
('död','1|dö'),
('död','2|dö'),
('död','3|livlös'),
('döda','1|dö'),
('döda','2|ogiltig'),
('dödande','1|döda'),
('dödande','2|döda'),
('dödande','3|döda'),
('dödbakad','1|bröd'),
('dödbränd','1|gips'),
('döddansare','1|person'),
('dödfull','1|full'),
('dödfull','1|full'),
('dödfödd','1|född'),
('dödförklara','1|förklara'),
('dödförklarande','1|dödförklara'),
('dödgrävare','1|gräva'),
('dödgrävare','2|skalbagge'),
('dödhet','1|död'),
('dödhet','2|död'),
('dödis','1|is'),
('dödkött','1|sår'),
('dödlig','1|dö'),
('dödlig','2|döda'),
('dödlighet','1|dö'),
('dödlighet','2|dödlig'),
('dödlighetsprocent','1|procent'),
('dödläge','1|still'),
('dödmansgrepp','1|säkerhetsanordning'),
('dödperiod','1|period'),
('dödsannons','1|annons'),
('dödsattest','1|attest'),
('dödsbakterie','1|bakterie'),
('dödsbevis','1|dödsattest'),
('dödsblek','1|likblek'),
('dödsblek','1|likblek'),
('dödsblekhet','1|dödsblek'),
('dödsblekhet','1|dödsblek'),
('dödsbo','1|kvarlåtenskap'),
('dödsbringande','1|dödlig'),
('dödsbud','1|bud'),
('dödsbädd','1|dö'),
('dödscell','1|fängelsecell'),
('dödsdag','1|dag'),
('dödsdans','1|dans'),
('dödsdom','1|dödsdömd'),
('dödsdömd','1|döma'),
('dödsfall','1|dö'),
('dödsfara','1|fara'),
('dödsfas','1|fas'),
('dödsfiende','1|fiende'),
('dödsflygning','1|flygning'),
('dödsfälla','1|fälla'),
('dödsförakt','1|modig'),
('dödsföraktande','1|dödsförakt'),
('dödsförbannad','1|förbannad'),
('dödsförbannad','1|förbannad'),
('dödsförskräckt','1|skräckslagen'),
('dödsförskräckt','1|skräckslagen'),
('dödshjälp','1|hjälp'),
('dödshjälpsdebatt','1|debatt'),
('dödshot','1|hot'),
('dödsjö','1|dyning'),
('dödskalle','1|skalle'),
('dödskallefjäril','1|fjäril'),
('dödskallefynd','1|fynd'),
('dödskamp','1|kamp'),
('dödsklinik','1|klinik'),
('dödskrasch','1|dödsolycka'),
('dödskval','1|kval'),
('dödskyla','1|kyla'),
('dödslista','1|lista'),
('dödslängtan','1|längtan'),
('dödsmarsch','1|marsch'),
('dödsmask','1|ansikte'),
('dödsmetall','1|hårdrock'),
('dödsmetall','1|hårdrock'),
('dödsminut','1|minut'),
('dödsmisshandel','1|misshandel'),
('dödsmärkt','1|dödssjuk'),
('dödsoffer','1|dödsfall'),
('dödsolycka','1|olycka'),
('dödsorsak','1|orsak'),
('dödsorsaksregister','1|register'),
('dödspatrull','1|patrull'),
('dödsriket','1|rike'),
('dödsringning','1|klockringning'),
('dödsrossling','1|rossling'),
('dödsruna','1|levnadsteckning'),
('dödsryckning','1|döende'),
('dödsryckningar','1|dö'),
('dödssiffra','1|dödstal'),
('dödssjuk','1|sjuk'),
('dödssjuk','1|sjuk'),
('dödssjukhet','1|dödssjuk'),
('dödsskjuta','1|skjuta'),
('dödsskjutande','1|dödsskjuta'),
('dödsskjuten','1|dödsskjuta'),
('dödsskjutning','1|dödsskjuta'),
('dödsskott','1|dödsskjuta'),
('dödsskugga','1|dö'),
('dödsskvadron','1|dödspatrull'),
('dödsslam','1|avloppsslam'),
('dödsslummer','1|död'),
('dödsstelhet','1|likstelhet'),
('dödsstilla','1|dödstyst'),
('dödsstillhet','1|dödsstilla'),
('dödsstjärna','1|stjärna'),
('dödsstraff','1|straff'),
('dödsstraffsanhängare','1|anhängare'),
('dödsstund','1|död'),
('dödsstörta','1|störta'),
('dödsstörtande','1|dödsstörta'),
('dödsstörtning','1|dödsstörta'),
('dödsstöt','1|slut'),
('dödssynd','1|synd'),
('dödssätt','1|dö'),
('dödssömn','1|död'),
('dödstal','1|antal'),
('dödstillfälle','1|död'),
('dödstimme','1|timme'),
('dödstråkig','1|tråkig'),
('dödstråkig','1|tråkig'),
('dödstråkighet','1|dödstråkig'),
('dödstrött','1|trött'),
('dödstrött','1|trött'),
('dödströtthet','1|dödstrött'),
('dödstyst','1|tyst'),
('dödstyst','1|tyst'),
('dödstystnad','1|tystnad'),
('dödsur','1|skalbagge'),
('dödsvånda','1|vånda'),
('dödsångest','1|ångest'),
('dödsår','1|år'),
('dödsängel','1|ängel'),
('dödtid','1|tid'),
('dödvatten','1|stillastående'),
('dödvikt','1|last'),
('döende','1|dö'),
('döende','2|dö'),
('dögling','1|näbbval'),
('döing','1|dö'),
('döing','1|dö'),
('dölja','1|gömma'),
('dölja','2|hemlig'),
('döljande','1|dölja'),
('döma','1|lag'),
('döma','2|bestämma'),
('dömande','1|döma'),
('dömande','2|döma'),
('dömd','1|döma'),
('dömd','2|döma'),
('dön','1|dån'),
('döna','1|dön'),
('dönande','1|döna'),
('döpa','1|namn'),
('döpande','1|döpa'),
('döpare','1|döpa'),
('döpelse','1|dop'),
('dörj','1|fiskredskap'),
('dörja','1|dörj'),
('dörjande','1|dörja'),
('dörr','1|öppning'),
('dörr','2|öppna'),
('dörrblad','1|dörr'),
('dörrfärg','1|färg'),
('dörrförhänge','1|förhänge'),
('dörrförsäljare','1|försäljare'),
('dörrhake','1|hake'),
('dörrhandtag','1|handtag'),
('dörrkarm','1|karm'),
('dörrkedja','1|säkerhetskedja'),
('dörrklinka','1|klinka'),
('dörrklocka','1|klocka'),
('dörrknackare','1|dörrförsäljare'),
('dörrknackning','1|knacka_dörr'),
('dörrknackningskampanj','1|kampanj'),
('dörrknackningsoperation','1|dörrknackning'),
('dörrkrans','1|prydnadskrans'),
('dörrlås','1|lås'),
('dörrmatta','1|matta'),
('dörrnyckel','1|nyckel'),
('dörrpost','1|dörrkarm'),
('dörrspegel','1|dörr'),
('dörrstolpe','1|dörr'),
('dörrstängare','1|stänga'),
('dörrvakt','1|ordningsvakt'),
('dörrvaktare','1|vakta'),
('dörrvred','1|dörrhandtag'),
('dörröga','1|titthål'),
('dörröppnare','1|öppna'),
('dörröppnare','2|kontaktman'),
('dörröppning','1|dörr'),
('dös','1|grav'),
('döskraj','1|skraj'),
('dösnack','1|skitsnack'),
('döv','1|höra'),
('döva','1|dämpa'),
('dövande','1|döva'),
('dövblind','1|blind'),
('dövblindhet','1|dövblind'),
('dövhet','1|döv'),
('dövning','1|döva'),
('dövstum','1|döv'),
('dövstumhet','1|dövstum'),
('e','1|bokstav'),
('E','1|initial'),
('e','2|energi'),
('e','3|ton'),
('eau-de-cologne','1|parfym'),
('eau-de-cologne','1|parfym'),
('eau-de-toilette','1|parfym'),
('eau-de-vie','1|konjak'),
('ebb','1|tidvatten'),
('ebba','1|minska'),
('ebbande','1|ebba'),
('ebenholts','1|träslag'),
('ebenholtsbetsad','1|betsa'),
('ebenist','1|finsnickare'),
('e-bok','1|bok'),
('e-bokläsare','1|läsplatta'),
('ebolavirus','1|virus'),
('ebonit','1|hårdgummi'),
('ebonitstav','1|stav'),
('e-brev','1|e-post'),
('e-brev','1|e-post'),
('e-brevledes','1|e-postledes'),
('e-brevledes','1|e-postledes'),
('echaufferad','1|rodna'),
('echelong','1|trupp'),
('ecklesiastik','1|kyrka'),
('ecklesiastikdepartement','1|utbildningsdepartement'),
('ecklesiastikminister','1|minister'),
('ecklesiastisk','1|ecklesiastik'),
('Ecuador','1|land'),
('ecuadorian','1|Ecuador'),
('ecuadoriansk','1|Ecuador'),
('ecuadorianska','1|ecuadorian'),
('ed','1|svära'),
('ed','2|näs'),
('eda','1|bakvatten'),
('edamerost','1|ost'),
('Edasi','1|tidning'),
('edda','1|litteratur'),
('Eddan','1|diktverk'),
('Eddie','1|Edward'),
('edelweiss','1|blomma'),
('Eden','2|lustgård'),
('edera','1|edition'),
('ederande','1|edera'),
('ederbar','1|edera'),
('ederbarhet','1|ederbar'),
('edering','1|edera'),
('edfäst','1|edfästa'),
('edfästa','1|bekräfta'),
('edfästande','1|edfästa'),
('edgång','1|ed'),
('edikt','1|kungörelse'),
('edil','1|ämbetsman'),
('edition','1|utgåva'),
('edlig','1|ed'),
('edligen','1|ed'),
('edlighet','1|edlig'),
('edsansvar','1|ansvar'),
('edsbrott','1|bryta'),
('Edsbyn','1|ort'),
('edsförpliktelse','1|ed'),
('edsgång','1|gå_ed'),
('edsvuren','1|ed'),
('edsöre','1|ed'),
('edsöresbrott','1|brott'),
('EEC','1|EG'),
('EEG','1|hjärnaktivitet'),
('EEG','1|hjärnaktivitet'),
('Eemhavet','1|Östersjön'),
('efedrin','1|medicin'),
('efemerid','1|dagslända'),
('efemerider','1|tabell'),
('efemeridtid','1|tid'),
('efemär','1|kortlivad'),
('effacera','1|utplåna'),
('effacerande','1|effacera'),
('effacerbar','1|effacera'),
('effacerbarhet','1|effacerbar'),
('effacering','1|effacera'),
('effekt','1|verkan'),
('effekt','2|bagage'),
('effektfaktor','1|faktor'),
('effektfrånskiljare','1|frånskiljare'),
('effektfull','1|effekt'),
('effektfullhet','1|effektfull'),
('effektförstärkare','1|högtalare'),
('effektgarn','1|garn'),
('effektiv','1|effekt'),
('effektivera','1|effektivisera'),
('effektiverande','1|effektivera'),
('effektiverbar','1|effektivera'),
('effektiverbarhet','1|effektiverbar'),
('effektivering','1|effektivera'),
('effektivisera','1|effektiv'),
('effektiviserande','1|effektivisera'),
('effektiviserbar','1|effektivisera'),
('effektiviserbarhet','1|effektiviserbar'),
('effektivisering','1|effektivisera'),
('effektivitet','1|effektiv'),
('effektivitetsargument','1|argument'),
('effektivitetsmässig','1|effektivitet'),
('effektläge','1|inställning'),
('effektlös','1|effekt'),
('effektlös','2|effekt'),
('effektlöshet','1|effektlös'),
('effektlöshet','2|effektlös'),
('effektmässig','1|effekt'),
('effektskapande','1|skapa'),
('effektsökeri','1|söka'),
('effektuera','1|verkställa'),
('effektuerande','1|effektuera'),
('effektuerbar','1|effektuera'),
('effektuerbarhet','1|effektuerbar'),
('effektuering','1|effektuera'),
('effektökning','1|ökning'),
('effeminerad','1|feminin'),
('efor','1|ledare'),
('eforus','1|biskop'),
('EFTA','1|förbund'),
('EFTA','1|förbund'),
('Efta-land','1|land'),
('efter','1|före'),
('efter','1|före'),
('efter','2|eftersom'),
('efter','3|efterbliven'),
('efteraccept','1|accept'),
('efteranmäla','1|anmäla'),
('efterapa','1|härma'),
('efterapa','1|härma'),
('efterapande','1|efterapa'),
('efterapare','1|efterapa'),
('efterapning','1|efterapa'),
('efterarbete','1|arbete'),
('efterbehandla','1|behandla'),
('efterbehandlande','1|efterbehandla'),
('efterbesiktning','1|besiktning'),
('efterbeskattning','1|beskattning'),
('efterbeställning','1|beställning'),
('efterbetalning','1|betalning'),
('efterbevakning','1|konkurs'),
('efterbild','1|synintryck'),
('efterbilda','1|härma'),
('efterbildande','1|efterbilda'),
('efterbildare','1|efterbilda'),
('efterbildning','1|efterbilda'),
('efterbliven','1|sen'),
('efterblivenhet','1|efterbliven'),
('efterblomning','1|blomning'),
('efterblomstring','1|efterblomning'),
('efterblödning','1|blödning'),
('efterbrännare','1|skott'),
('efterbrännkammare','1|brännkammare'),
('efterbörd','1|förlossning'),
('efterbörs','1|börs'),
('efterdatera','1|datera'),
('efterdaterande','1|efterdatera'),
('efterdaterbar','1|efterdatera'),
('efterdaterbarhet','1|efterdaterbar'),
('efterdatering','1|efterdatera'),
('efterdebitera','1|debitera'),
('efterdebiterande','1|efterdebitera'),
('efterdebiterbar','1|efterdebitera'),
('efterdebiterbarhet','1|efterdebiterbar'),
('efterdebitering','1|efterdebitera'),
('efterdyning','1|efter'),
('efterdöme','1|föredöme'),
('efterdömlig','1|efterdöme'),
('efterdömlighet','1|efterdömlig'),
('efterfest','1|fest'),
('efterforska','1|undersöka'),
('efterforskande','1|efterforska'),
('efterforskning','1|efterforska'),
('efterfråga','1|önska'),
('efterfrågad','1|populär'),
('efterfrågan','1|ha'),
('efterfrågande','1|efterfråga'),
('efterfrågning','1|efterfrågan'),
('efterfölja','1|följa'),
('efterföljande','1|efterfölja'),
('efterföljansvärd','1|förebildlig'),
('efterföljare','1|efterfölja'),
('efterföljd','1|efterfölja'),
('efterföljelse','1|efterföljd'),
('efterge','1|förlåta'),
('eftergift','1|medge'),
('eftergift','2|efterskänka'),
('eftergivande','1|efterge'),
('eftergiven','1|foglig'),
('eftergivenhet','1|eftergiven'),
('eftergivlig','1|eftergiven'),
('eftergivlighet','1|eftergivlig'),
('eftergjord','1|imitera'),
('efterglans','1|glans'),
('eftergranskning','1|granskning'),
('eftergymnasial','1|gymnasium'),
('eftergöra','1|imitera'),
('eftergörande','1|eftergöra'),
('efterhand','1|kortspel'),
('efterhandskonstruktion','1|förklara'),
('efterhålla','1|gräns'),
('efterhållande','1|efterhålla'),
('efterhängsen','1|ihärdig'),
('efterhängsenhet','1|efterhängsen'),
('efterhärma','1|härma'),
('efterhärmande','1|efterhärma'),
('efterhärmare','1|efterhärma'),
('efterhärmning','1|efterhärma'),
('efterhöra','1|reda'),
('efterhörande','1|efterhöra'),
('efterhöst','1|senhöst'),
('efterjäsning','1|jäsa'),
('efterklang','1|klang'),
('efterklok','1|inse'),
('efterklokhet','1|efterklok'),
('efterkokning','1|kokning'),
('efterkomma','1|hörsamma'),
('efterkommande','1|släkt'),
('efterkommande','2|efterkomma'),
('efterkonstruktion','1|efterhandskonstruktion'),
('efterkontroll','1|kontroll'),
('efterkrav','1|betala'),
('efterkrigsdecennium','1|decennium'),
('efterkrigstid','1|tid'),
('Efterkrigstyskland','1|Tyskland'),
('efterkultur','1|kultur'),
('efterkänning','1|efterverkan'),
('efterled','1|sammansättningsled'),
('efterleva','1|hörsamma'),
('efterlevande','1|efter'),
('efterlevande','2|efterleva'),
('efterlevandeskydd','1|skydd'),
('efterleverska','1|änka'),
('efterlevnad','1|efterleva'),
('efterlevnadskontroll','1|kontroll'),
('efterliggande','1|försumma'),
('efterlikna','1|likna'),
('efterliknande','1|efterlikna'),
('efterlysa','1|söka'),
('efterlysa','2|jaga'),
('efterlysande','1|efterlysa'),
('efterlysande','2|efterlysa'),
('efterlysning','1|efterlysa'),
('efterlysning','2|efterlysa'),
('efterlåta','1|underlåta'),
('efterlåtande','1|efterlåta'),
('efterlåten','1|eftergiven'),
('efterlåtenhet','1|efterlåten'),
('efterlämna','1|lämna'),
('efterlämnande','1|efterlämna'),
('efterlämning','1|kvar'),
('efterlängtad','1|längta'),
('eftermassage','1|massage'),
('eftermiddag','1|dag'),
('eftermiddagsbris','1|bris'),
('eftermiddagsjobb','1|jobb'),
('eftermiddagskaffe','1|kaffe'),
('eftermiddagslur','1|lur'),
('eftermiddagspass','1|pass'),
('eftermiddagsrusning','1|rusning'),
('eftermiddagssejour','1|eftermiddagspass'),
('eftermiddagsskymning','1|skymning'),
('eftermiddagste','1|te'),
('eftermiddagstimme','1|timme'),
('eftermiddagstrafik','1|trafik'),
('eftermogna','1|mogna'),
('eftermognad','1|eftermogna'),
('eftermognande','1|eftermogna'),
('eftermäle','1|omdöme'),
('efternamn','1|namn'),
('efternatten','1|natt'),
('efterord','1|avsluta'),
('efterplock','1|rest'),
('efterplockning','1|plocka_bort'),
('efterprövning','1|betyg'),
('efterputs','1|putsa'),
('efterrationalisera','1|efterrationalisering'),
('efterrationaliserande','1|efterrationalisera'),
('efterrationaliserbar','1|efterrationalisera'),
('efterrationaliserbarhet','1|efterrationaliserbar'),
('efterrationalisering','1|förklara'),
('efterräkning','1|konsekvens'),
('efterrätt','1|rätt'),
('efterrättelse','1|lydnad'),
('efterrättssoppa','1|soppa'),
('eftersaknad','1|sakna'),
('eftersaknad','2|eftersaknad'),
('eftersats','1|slutledning'),
('eftersats','2|bisats'),
('efterseende','1|se_efter'),
('eftersinna','1|besinna'),
('eftersinnande','1|eftersinna'),
('eftersinnande','2|eftersinna'),
('eftersits','1|umgänge'),
('efterskalv','1|jordskalv'),
('efterskickning','1|skicka_efter'),
('efterskott','1|betala'),
('efterskrift','1|skrift'),
('efterskänka','1|avstå'),
('efterskänkande','1|efterskänka'),
('efterskänkning','1|efterskänka'),
('efterskörd','1|skörd'),
('efterslag','1|ton'),
('efterslåtter','1|slåtter'),
('eftersläckning','1|släcka'),
('eftersläckning','2|fest'),
('eftersläng','1|efterkänning'),
('eftersläng','2|tackla'),
('eftersläntrande','1|eftersläntrare'),
('eftersläntrare','1|försening'),
('eftersläpning','1|försening'),
('eftersmak','1|smak'),
('eftersnack','1|snack'),
('eftersom','1|därför'),
('eftersommar','1|sensommar'),
('efterspana','1|spana'),
('efterspanad','1|efterspana'),
('efterspanande','1|efterspana'),
('efterspaning','1|efterspana'),
('efterspel','1|efterräkning'),
('efterst','1|efter'),
('efterstava','1|eftersäga'),
('efterstavande','1|efterstava'),
('efterstavning','1|efterstava'),
('eftersträva','1|sträva'),
('eftersträvande','1|eftersträva'),
('eftersträvansvärd','1|eftersträva'),
('eftersträvansvärdhet','1|eftersträvansvärd'),
('efterstygn','1|stygn'),
('efterställd','1|huvudord'),
('eftersupning','1|supa'),
('eftersyn','1|se_efter'),
('eftersynkronisera','1|eftersynkronisering'),
('eftersynkroniserande','1|eftersynkronisera'),
('eftersynkroniserbar','1|eftersynkronisera'),
('eftersynkroniserbarhet','1|eftersynkroniserbar'),
('eftersynkronisering','1|synkronisering'),
('eftersäga','1|upprepa'),
('eftersägande','1|eftersäga'),
('eftersägare','1|eftersäga'),
('eftersägning','1|eftersäga'),
('eftersända','1|post'),
('eftersändande','1|eftersända'),
('eftersändning','1|eftersända'),
('eftersändning','2|sända_efter'),
('eftersätta','1|försumma'),
('eftersättande','1|eftersätta'),
('eftersättsblad','1|blad'),
('eftersök','1|spårning'),
('eftersöka','1|söka'),
('eftersökande','1|eftersöka'),
('eftersökning','1|eftersöka'),
('eftersökt','1|populär'),
('eftersökthet','1|eftersökt'),
('eftertanke','1|fundera'),
('eftertaxera','1|eftertaxering'),
('eftertaxerande','1|eftertaxera'),
('eftertaxerbar','1|eftertaxera'),
('eftertaxerbarhet','1|eftertaxerbar'),
('eftertaxering','1|efterbeskattning'),
('eftertextnot','1|not'),
('eftertorkning','1|torkning'),
('eftertrakta','1|önska'),
('eftertraktande','1|eftertrakta'),
('eftertraktansvärd','1|åtråvärd'),
('eftertraktansvärdhet','1|eftertraktansvärd'),
('eftertrav','1|eftertrupp'),
('eftertrupp','1|trupp'),
('eftertryck','1|betona'),
('eftertryck','2|omtryck'),
('eftertrycklig','1|betona'),
('eftertryckligen','1|eftertryck'),
('eftertrycklighet','1|eftertrycklig'),
('eftertrå','1|eftertrakta'),
('eftertrående','1|eftertrå'),
('efterträda','1|följa'),
('efterträdande','1|efterträda'),
('efterträdare','1|efterträda'),
('efterträdarkandidat','1|kandidat'),
('eftertänksam','1|tänka'),
('eftertänksamhet','1|eftertänksam'),
('efterundersökning','1|efterkontroll'),
('efterutbildning','1|utbildning'),
('eftervalsanalys','1|analys'),
('eftervalsdebatt','1|debatt'),
('efterverkan','1|verkan'),
('efterverkning','1|efterverkan'),
('eftervinter','1|senvinter'),
('eftervis','1|efterklok'),
('eftervishet','1|eftervis'),
('eftervård','1|vård'),
('eftervärk','1|värk'),
('eftervärkar','1|förlossning'),
('eftervärld','1|mänsklighet'),
('eftervärme','1|värme'),
('efterväxt','1|växt'),
('efteråt','1|efter'),
('EG','1|marknad'),
('egal','1|likgiltig'),
('egalisera','1|egalitet'),
('egaliserande','1|egalisera'),
('egaliserbar','1|egalisera'),
('egaliserbarhet','1|egaliserbar'),
('egalisering','1|egalisera'),
('egalitet','1|likhet'),
('egalitet','2|jämlikhet'),
('egalitär','1|egalitet'),
('egard','1|hänsyn'),
('egeisk','1|Egeiska_havet'),
('egen','1|ha'),
('egen','2|egendomlig'),
('egenart','1|egenskap'),
('egenartad','1|underlig'),
('egendesignad','1|designa'),
('egendiagnos','1|självdiagnos'),
('egendiagnostik','1|egendiagnos'),
('egendom','1|äga'),
('egendomlig','1|underlig'),
('egendomlighet','1|egendomlig'),
('egendomsaffär','1|affär'),
('egendomsbrott','1|förmögenhetsbrott'),
('egendomsfolk','1|jude'),
('egendomsförsäkring','1|försäkring'),
('egendomsförsäljning','1|försäljning'),
('egendomsgemenskap','1|gemenskap'),
('egendomsköp','1|köp'),
('egendomslös','1|egendom'),
('egendomslöshet','1|egendomslös'),
('egenfrekvens','1|egensvängning'),
('egenhet','1|egendomlig'),
('egenhändig','1|själv'),
('egenhändighet','1|egenhändig'),
('egenintresse','1|intresse'),
('egenkomponerad','1|komponera'),
('egenkonstruerad','1|konstruera'),
('egenkär','1|egoistisk'),
('egenkärlek','1|egenkär'),
('egenmäktig','1|hänsyn'),
('egenmäktighet','1|egenmäktig'),
('egennamn','1|namn'),
('egennytta','1|självisk'),
('egennyttig','1|egennytta'),
('egennyttighet','1|egennyttig'),
('egenodlad','1|odla'),
('egenproducerad','1|producera'),
('egenremiss','1|remiss'),
('egenrådig','1|egenmäktig'),
('egenrådighet','1|egenrådig'),
('egenrättfärdig','1|självgod'),
('egenrättfärdighet','1|egenrättfärdig'),
('egenrörelse','1|rörelse'),
('egensinne','1|egensinnig'),
('egensinnig','1|envis'),
('egensinnighet','1|egensinnig'),
('egenskap','1|sådan'),
('egenskapsgenitiv','1|genitiv'),
('egenskapsord','1|adjektiv'),
('egensvänga','1|egensvängning'),
('egensvängande','1|egensvänga'),
('egensvängning','1|svängning'),
('egentid','1|tid'),
('egentillverkad','1|tillverka'),
('egentlig','1|faktisk'),
('egentligen','1|faktisk'),
('egenvarm','1|varmblodig'),
('egenvärde','1|värde'),
('egg','1|vass'),
('egga','1|uppmuntra'),
('eggande','1|egga'),
('eggelse','1|egga'),
('eggjärn','1|verktyg'),
('eggvapen','1|vapen'),
('eggvass','1|egg'),
('eggverktyg','1|verktyg'),
('egid','1|skydd'),
('egnahem','1|villa'),
('ego','1|jag'),
('egoboosta','1|ego'),
('egoboostande','1|egoboosta'),
('egoboostning','1|egoboosta'),
('egocentricitet','1|egocentrisk'),
('egocentriker','1|egocentrisk'),
('egocentrisk','1|självupptagen'),
('E-godkänd','1|godkänd'),
('egoism','1|egoist'),
('egoist','1|egoistisk'),
('egoistisk','1|självisk'),
('egotism','1|egenkär'),
('egotripp','1|egotrippad'),
('egotrippad','1|egoist'),
('egotrippare','1|egotrippad'),
('Egypten','1|land'),
('egyptienne','1|tryck'),
('egyptier','1|Egypten'),
('egyptier','1|Egypten'),
('egyptisk','1|Egypten'),
('egyptiska','1|språk'),
('egyptiska','2|egyptier'),
('egyptolog','1|egyptologi'),
('egyptologi','1|vetenskap'),
('egyptomani','1|mani'),
('ehec','1|virussjukdom'),
('ehec','1|virussjukdom'),
('ehec-smitta','1|smitta'),
('ehec-smitta','1|smitta'),
('eho','1|vem'),
('ehuru','1|fastän'),
('ehurudan','1|hurudan'),
('ehuruväl','1|ehuru'),
('eidetik','1|vetenskap'),
('eidetisk','1|synförnimmelse'),
('Eiffeltornet','1|torn'),
('einherjar','1|kämpe'),
('einsteinium','1|grundämne'),
('einsteinium','1|grundämne'),
('einsteinsk','1|Einstein'),
('Eisenhowerepoken','1|epok'),
('ej','1|inte'),
('eja','1|ack'),
('ejakulat','1|ejakulera'),
('ejakulation','1|ejakulera'),
('ejakulera','1|sperma'),
('ejakulerande','1|ejakulera'),
('ejakulering','1|ejakulera'),
('ejder','1|sjöfågel'),
('ejderdun','1|dun'),
('ejderdunskudde','1|kudde'),
('ejderhona','1|ejder'),
('ejderunge','1|ejder'),
('ejektor','1|pump'),
('ek','1|träd'),
('eka','1|båt'),
('eka','2|eko'),
('eka','3|ekfatslagra'),
('ekande','1|eka'),
('ekande','2|eka'),
('ekarté','1|kortspel'),
('ekavverkning','1|avverkning'),
('ekavverkningsförbud','1|förbud'),
('ekbacke','1|backe'),
('ekbock','1|skalbagge'),
('ekdörr','1|dörr'),
('eke','1|virke'),
('eker','1|hjul'),
('ekfat','1|fat'),
('ekfatslagra','1|förädla'),
('ekfatslagrande','1|ekfatslagra'),
('EKG','1|hjärtaktivitet'),
('EKG','1|hjärtaktivitet'),
('ekipage','1|åkdon'),
('ekipage','2|fordon'),
('ekipage','3|ridsport'),
('ekipera','1|kläder'),
('ekiperande','1|ekipera'),
('ekiperbar','1|ekipera'),
('ekiperbarhet','1|ekiperbar'),
('ekipering','1|ekipera'),
('ekiperingsaffär','1|affär'),
('ekivok','1|oanständig'),
('eklampsi','1|kramp'),
('eklatant','1|uppenbar'),
('eklatera','1|tillkännage'),
('eklaterande','1|eklatera'),
('eklaterbar','1|eklatera'),
('eklaterbarhet','1|eklaterbar'),
('eklatering','1|eklatera'),
('eklatt','1|eklatera'),
('eklekticism','1|eklektisk'),
('eklektiker','1|eklektisk'),
('eklektisk','1|blanda'),
('eklips','1|solförmörkelse'),
('ekliptika','1|bana'),
('eklog','1|herdedikt'),
('eklut','1|garvmedel'),
('eklut','2|prövning'),
('eklärera','1|upplysa'),
('eklärerande','1|eklärera'),
('eklärerbar','1|eklärera'),
('eklärerbarhet','1|eklärerbar'),
('eklärering','1|eklärera'),
('eklöv','1|löv'),
('eko','1|ljud'),
('ekoaktivism','1|aktivism'),
('ekoaktivist','1|ekoaktivism'),
('ekobrott','1|ekonomisk_brottslighet'),
('ekofascistisk','1|fascistisk'),
('ekokammare','1|kammare'),
('ekollon','1|ollon'),
('ekolobby','1|lobby'),
('ekolod','1|mäta'),
('ekoloda','1|ekolod'),
('ekolodande','1|ekoloda'),
('ekolog','1|ekologi'),
('ekologi','1|vetenskap'),
('ekologisk','1|miljö'),
('ekologisk','1|miljö'),
('ekonom','1|ekonomi'),
('ekonometri','1|ekonomi'),
('ekonomexamen','1|examen'),
('ekonomi','1|pengar'),
('ekonomi','2|vetenskap'),
('ekonomiansvarig','1|ansvarig'),
('ekonomiavdelning','1|avdelning'),
('ekonomibiträde','1|biträde'),
('ekonomibrev','1|brev'),
('ekonomibyggnad','1|byggnad'),
('ekonomichef','1|chef'),
('ekonomie','1|ekonomexamen'),
('ekonomiföreståndare','1|föreståndare'),
('ekonomiförpackning','1|förpackning'),
('ekonomiförvaltare','1|förvalta'),
('ekonomiklass','1|resa'),
('ekonomikrönikör','1|krönikör'),
('ekonomilära','1|ämne'),
('ekonomipaket','1|ekonomiförpackning'),
('ekonomipersonal','1|personal'),
('ekonomirätt','1|rätt'),
('ekonomisera','1|hushålla'),
('ekonomiserande','1|ekonomisera'),
('ekonomiserbar','1|ekonomisera'),
('ekonomiserbarhet','1|ekonomiserbar'),
('ekonomisering','1|ekonomisera'),
('ekonomisk','1|ekonomi'),
('ekonomisk','1|ekonomi'),
('ekonomisk','2|sparsam'),
('ekonomisk','3|ekonomi'),
('ekonomisk-politisk','1|politik'),
('ekonomisk-politisk','1|politik'),
('ekonomisk-politisk','1|politik'),
('ekonomisk-politisk','1|politik'),
('ekonomiutbildning','1|utbildning'),
('ekonomlinje','1|utbildningslinje'),
('ekonomutbildning','1|utbildning'),
('ekoodlad','1|odla'),
('ekoporr','1|porr'),
('ekoporr','1|porr'),
('ekoradio','1|radar'),
('ekorrbär','1|växt'),
('ekorrdjur','1|ekorre'),
('ekorre','1|djur'),
('ekorrhjul','1|arbete'),
('ekorrliknande','1|ekorre'),
('ekorröd','1|röd'),
('ekosystem','1|system'),
('ekoturist','1|turist'),
('ekotyp','1|art'),
('ekovin','1|vin'),
('ekoxe','1|skalbagge'),
('ekrin','1|svettkörtel'),
('eksem','1|sjukdom'),
('Eksjö','1|ort'),
('ekskog','1|skog'),
('ekspinnare','1|fjäril'),
('ekstock','1|eka'),
('ekstock','1|eka'),
('ektoderm','1|cellskikt'),
('ektomi','1|avlägsna'),
('ekumenik','1|ekumenisk'),
('ekumenisk','1|religion'),
('ekumenism','1|ekumenisk'),
('ekvation','1|lika'),
('ekvator','1|mittlinje'),
('Ekvatorguinea','1|Ekvatorialguinea'),
('ekvatorial','1|ekvator'),
('ekvatorialbälte','1|område'),
('Ekvatorialguinea','1|Guinea'),
('ekvatorialguinean','1|Ekvatorialguinea'),
('ekvatorialguineansk','1|Ekvatorguinea'),
('ekvatorialguineanska','1|ekvatorialguinean'),
('ekvatorialström','1|havsström'),
('ekvatorialzon','1|ekvatorialbälte'),
('ekvatoriell','1|ekvator'),
('ekvatorn','1|ekvator'),
('ekvatorshöjd','1|astronomi'),
('ekvatorsplan','1|plan'),
('ekvecklare','1|fjäril'),
('ekvidistans','1|nivåkurva'),
('ekvidistans','2|intervall'),
('ekvidistant','1|ekvidistans'),
('ekvilibrera','1|balansera'),
('ekvilibrerande','1|ekvilibrera'),
('ekvilibrist','1|akrobat'),
('ekvilibristik','1|ekvilibrist'),
('ekvilibristisk','1|ekvilibrist'),
('ekvilibrium','1|jämvikt'),
('ekvipotentiallinje','1|elektrod'),
('ekvipotentialyta','1|potentialyta'),
('ekvirke','1|virke'),
('ekvivalens','1|ekvivalent'),
('ekvivalent','1|likvärdig'),
('ekvivalent','2|ekvivalent'),
('ekvivalentvikt','1|kemi'),
('el','1|elektricitet'),
('elaborera','1|utarbeta'),
('elaborerande','1|elaborera'),
('elaborerbar','1|elaborera'),
('elaborerbarhet','1|elaborerbar'),
('elaborering','1|elaborera'),
('elak','1|god'),
('elak','2|dålig'),
('elakartad','1|svårartad'),
('elakhet','1|elak'),
('elaking','1|elak'),
('elallergi','1|allergi'),
('élan','1|hänförelse'),
('eland','1|antilop'),
('elandantilop','1|eland'),
('elapparat','1|apparat'),
('elasticitet','1|elastisk'),
('elasticitetsgräns','1|gräns'),
('elastisera','1|elastisk'),
('elastiserande','1|elastisera'),
('elastiserbar','1|elastisera'),
('elastiserbarhet','1|elastiserbar'),
('elastisering','1|elastisera'),
('elastisk','1|böjlig'),
('elativ','1|kasus'),
('elavbrott','1|strömavbrott'),
('elavläsning','1|avläsning'),
('Elbe','1|flod'),
('elbil','1|bil'),
('elbilsförespråkare','1|förespråkare'),
('elbilspionjär','1|pionjär'),
('elborste','1|släpkontakt'),
('elbörs','1|börs'),
('elchock','1|chockbehandling'),
('eld','1|brinna'),
('eld','2|skjuta'),
('eld','3|elda'),
('elda','1|eld'),
('eldande','1|elda'),
('eldare','1|ångpanna'),
('eldavstånd','1|avstånd'),
('eldbegängelse','1|kremering'),
('eldbrand','1|brand'),
('elddisciplin','1|disciplin'),
('elddon','1|eld'),
('elddop','1|prövning'),
('elddyrkan','1|dyrka'),
('elddyrkan','1|dyrka'),
('elddyrkare','1|elddyrkan'),
('elddyrkare','1|elddyrkan'),
('eldfara','1|brandfara'),
('eldfarlig','1|brandfarlig'),
('eldfarlighet','1|eldfarlig'),
('eldfast','1|tåla'),
('eldfasthet','1|eldfast'),
('eldfluga','1|skalbagge'),
('eldfängd','1|lättantändlig'),
('eldfängdhet','1|eldfängd'),
('eldgaffel','1|redskap'),
('eldgaffelsrak','1|rak'),
('eldgivning','1|skottlossning'),
('eldgnista','1|gnista'),
('eldhandvapen','1|skjutvapen'),
('eldhastighet','1|hastighet'),
('eldhav','1|brand'),
('eldhund','1|ved'),
('eldhus','1|eldstad'),
('eldhärd','1|eld'),
('eldhärdig','1|eldfast'),
('eldhärdighet','1|eldhärdig'),
('eldhärja','1|förstöra'),
('eldhärjande','1|eldhärja'),
('eldig','1|lidelsefull'),
('eldighet','1|eldig'),
('eldkanal','1|kanal'),
('eldkastare','1|eldspruta'),
('eldkol','1|glöd'),
('eldkommando','1|kommando'),
('eldkraft','1|kraft'),
('eldkula','1|eld'),
('eldkvast','1|eld'),
('eldledare','1|eldledning'),
('eldledning','1|ledning'),
('eldlinje','1|linje'),
('eldning','1|elda'),
('eldningsolja','1|olja'),
('eldorado','1|paradis'),
('eldpelare','1|eld'),
('eldprov','1|slutprov'),
('eldredskap','1|redskap'),
('eldregn','1|eld'),
('eldrift','1|eldriven'),
('eldriven','1|driva'),
('eldrum','1|pannrum'),
('eldröd','1|röd'),
('eldrör','1|rör'),
('eldsalamander','1|salamander'),
('eldsats','1|laddning'),
('eldsignal','1|signal'),
('eldsignalering','1|eldsignal'),
('eldsjäl','1|entusiast'),
('eldsken','1|sken'),
('eldskrift','1|tecken'),
('eldskur','1|eld'),
('eldskydd','1|skydd'),
('Eldslandet','1|Sydamerika'),
('eldsljus','1|ljus'),
('eldslukare','1|cirkusartist'),
('eldslåga','1|låga'),
('eldsläckare','1|brandsläckare'),
('eldsläckning','1|släcka'),
('eldsländare','1|Eldslandet'),
('eldsmärke','1|födelsemärke'),
('eldspruta','1|eld'),
('eldsprutande','1|spruta'),
('eldstad','1|elda'),
('eldstod','1|pelare'),
('eldstorm','1|storm'),
('eldstrid','1|strid'),
('eldstrimma','1|eld'),
('eldstål','1|eld'),
('eldställning','1|stridsställning'),
('eldsvåda','1|brand'),
('eldsvådetillbud','1|eldsvåda'),
('eldsvådeunge','1|eldsvåda'),
('eldsäker','1|säker'),
('eldsäkerhet','1|eldsäker'),
('eldsäkra','1|eldsäker'),
('eldsäkrande','1|eldsäkra'),
('eldtång','1|tång'),
('eldunderstöd','1|understöd'),
('eldupphör','1|upphöra'),
('eldupphörorder','1|order'),
('eldvakt','1|vakt'),
('eldvakta','1|eldvakt'),
('eldvaktande','1|eldvakta'),
('eldvaktare','1|eldvakta'),
('eldvapen','1|skjutvapen'),
('eldvatten','1|brännvin'),
('eldverkan','1|verkan'),
('eldyta','1|värmepanna'),
('eldöverfall','1|eldgivning'),
('elefant','1|djur'),
('elefantbete','1|bete'),
('elefantgräs','1|gräs'),
('elefanthanne','1|elefant'),
('elefanthud','1|hud'),
('elefantiasis','1|elefantsjuka'),
('elefantinhopp','1|ingripa'),
('elefantnäbbmus','1|näbbmus'),
('elefantsjuka','1|sjukdom'),
('elefantsköldpadda','1|sköldpadda'),
('elefantupplopp','1|upplopp'),
('elegans','1|elegant'),
('elegant','1|vacker'),
('elegi','1|dikt'),
('elegisk','1|elegi'),
('e-legitimation','1|legitimation'),
('e-legitimation','1|legitimation'),
('e-legitimation','1|legitimation'),
('elektor','1|val'),
('elektorsröst','1|röst'),
('elektorsval','1|val'),
('elektricitet','1|energi'),
('elektricitetsmängd','1|mängd'),
('elektricitetsorsakad','1|orsaka'),
('elektricitetsverk','1|företag'),
('elektrifiera','1|elektricitet'),
('elektrifiera','1|elektricitet'),
('elektrifierande','1|elektrifiera'),
('elektrifierande','1|elektrifiera'),
('elektrifierbar','1|elektrifiera'),
('elektrifierbar','1|elektrifiera'),
('elektrifierbarhet','1|elektrifierbar'),
('elektrifierbarhet','1|elektrifierbar'),
('elektrifiering','1|elektrifiera'),
('elektrifiering','1|elektrifiera'),
('elektriker','1|elektricitet'),
('elektrikermejsel','1|mejsel'),
('elektrikermejselsats','1|sats'),
('elektrisera','1|laddning'),
('elektriserande','1|elektrisera'),
('elektriserbar','1|elektrisera'),
('elektriserbarhet','1|elektriserbar'),
('elektrisering','1|elektrisera'),
('elektrisk','1|elektricitet'),
('elektrisk','1|elektricitet'),
('elektroakustik','1|akustik'),
('elektroakustisk','1|akustisk'),
('elektrochock','1|elchock'),
('elektrod','1|elektrisk'),
('elektrodynamik','1|dynamik'),
('elektroencefalografi','1|EEG'),
('elektrofilter','1|rena'),
('elektrofor','1|elektricitet'),
('elektrofores','1|kemi'),
('elektrofysik','1|fysik'),
('elektrofysiologi','1|fysiologi'),
('elektroingenjör','1|ingenjör'),
('elektrokardiografi','1|EKG'),
('elektrokemi','1|kemi'),
('elektrokemisk','1|kemisk'),
('elektrolys','1|sönderdela'),
('elektrolyt','1|lösning'),
('elektrolytisk','1|elektrolyt'),
('elektromagnet','1|magnet'),
('elektromagnetisk','1|magnetisk'),
('elektromagnetism','1|elektromagnetisk'),
('elektromekanisk','1|mekanisk'),
('elektrometallurgi','1|metallurgi'),
('elektrometer','1|mäta'),
('elektromotor','1|motor'),
('elektromotorisk','1|elektrometer'),
('elektron','1|partikel'),
('elektron','1|partikel'),
('elektron','2|legering'),
('elektronbana','1|bana'),
('elektronblixt','1|fotografi'),
('elektronegativitet','1|negativ'),
('elektronhölje','1|elektron'),
('elektronik','1|elektronisk'),
('elektronikkedja','1|affärskedja'),
('elektronikkomponent','1|komponent'),
('elektronikmejsel','1|mejsel'),
('elektronisk','1|elektrisk'),
('elektronkamera','1|kamera'),
('elektronmikroskop','1|mikroskop'),
('elektronmikroskopbild','1|bild'),
('elektronmikroskopi','1|elektronmikroskop'),
('elektronmoln','1|elektronhölje'),
('elektronneutrino','1|elektron'),
('elektronpar','1|par'),
('elektronparbindning','1|elektronpar'),
('elektronrör','1|rör'),
('elektronrörsdiod','1|elektronrör'),
('elektronskal','1|elektronhölje'),
('elektronstråle','1|stråle'),
('elektronugn','1|mikrovågsugn'),
('elektronvolt','1|volt'),
('elektronvolt','1|volt'),
('elektroskop','1|mäta'),
('elektrostatik','1|vetenskap'),
('elektrostatisk','1|laddning'),
('elektrostriktion','1|elektricitet'),
('elektrostål','1|stål'),
('elektrosvag','1|svag'),
('elektroteknik','1|teknik'),
('elektrotekniker','1|elektroteknik'),
('elektroteknisk','1|elektroteknik'),
('elektroterapi','1|bota'),
('elektrotyp','1|tryck'),
('element','1|värma'),
('element','2|ämne'),
('element','3|del'),
('element','4|grupp'),
('element','5|batteri'),
('elementa','1|grund'),
('elementaranalys','1|analys'),
('elementarande','1|ande'),
('elementarbok','1|nybörjarbok'),
('elementarladdning','1|laddning'),
('elementarläroverk','1|skola'),
('elementarpartikel','1|partikel'),
('elementarskola','1|läroverk'),
('elementfärg','1|färg'),
('elementpensel','1|pensel'),
('elementär','1|enkel'),
('elementär','1|enkel'),
('elementärkraft','1|naturkraft'),
('elenergi','1|energi'),
('elev','1|studera'),
('elev','2|anhängare'),
('elevation','1|lyfta'),
('elevator','1|hiss'),
('elevfartyg','1|fartyg'),
('elevhem','1|hem'),
('elevhälsovård','1|skolhälsovård'),
('elevlista','1|lista'),
('elevråd','1|råd'),
('elevskola','1|skola'),
('elevunderlag','1|underlag'),
('elevvård','1|skolhälsovård'),
('elfenben','1|material'),
('elfenbensbit','1|bit'),
('elfenbensfärgad','1|gulvit'),
('Elfenbenskusten','1|land'),
('elfenbenspalm','1|palm'),
('elfenbenspapper','1|papper'),
('elfenbenssvärta','1|svärta'),
('elfenbenstorn','1|avskildhet'),
('elfenbensvit','1|vit'),
('elfordon','1|fordon'),
('elfte','1|elva'),
('elfteplats','1|tävling'),
('elförbrukning','1|förbrukning'),
('elförsörjning','1|försörjning'),
('elförzinkad','1|förzinka'),
('elgenerator','1|generator'),
('elgitarr','1|gitarr'),
('elgräsklippare','1|gräsklippare'),
('elhybrid','1|elhybridbil'),
('elhybridbil','1|bil'),
('elhyvel','1|hyvel'),
('elhyvel','2|rakhyvel'),
('Elia','1|profet'),
('elidera','1|slutvokal'),
('eliderande','1|elidera'),
('eliderbar','1|elidera'),
('eliderbarhet','1|eliderbar'),
('elidering','1|elidera'),
('elimination','1|eliminera'),
('eliminera','1|avlägsna'),
('eliminerande','1|eliminera'),
('eliminerbar','1|eliminera'),
('eliminerbarhet','1|eliminerbar'),
('eliminering','1|eliminera'),
('elintensiv','1|intensiv'),
('elisabetansk','1|Elizabeth'),
('elision','1|elidera'),
('elit','1|ypperst'),
('elitförband','1|förband'),
('elitgymnastik','1|gymnastik'),
('elitidrott','1|idrott'),
('elitidrottsman','1|idrottsman'),
('elitisk','1|elitistisk'),
('elitism','1|elit'),
('elitistisk','1|elit'),
('elitkår','1|elitförband'),
('elitlag','1|lag'),
('elitmässig','1|elit'),
('elitnivå','1|nivå'),
('elitserie','1|elit'),
('elitseriemässig','1|elitserie'),
('elitsoldat','1|soldat'),
('elitteori','1|teori'),
('elittrupp','1|trupp'),
('elittänk','1|tänk'),
('elittänkande','1|elitteori'),
('elixir','1|dryck'),
('Elizabeth','1|drottning'),
('eljest','1|annars'),
('eljest','1|annars'),
('elkabel','1|kabel'),
('elkedjesåg','1|kedjesåg'),
('elkonsumtion','1|konsumtion'),
('elkoppling','1|koppling'),
('elkraft','1|kraft'),
('elkraftsaggregat','1|aggregat'),
('ellande','1|illande'),
('elledning','1|ledning'),
('eller','1|två'),
('Ellingkvinnan','1|mosslik'),
('ellips','1|oval'),
('ellips','2|förkortning'),
('ellipsformad','1|ellips'),
('ellipsoid','1|ellips'),
('elliptisk','1|ellips'),
('elliptisk','2|ellips'),
('elljus','1|ljus'),
('elljusslinga','1|elljusspår'),
('elljusspår','1|motionsspår'),
('ellok','1|lok'),
('Ellos','1|postorderföretag'),
('elmanövrerad','1|manövrera'),
('elmarknad','1|marknad'),
('elmotor','1|motor'),
('elmotordrift','1|elmotordriven'),
('elmotordriven','1|driva'),
('elmseld','1|åska'),
('elmutterdragare','1|mutterdragare'),
('elmätare','1|mäta'),
('elnät','1|nät'),
('eloge','1|beröm'),
('elokvens','1|elokvent'),
('elokvent','1|vältalig'),
('elongation','1|avstånd'),
('eloquentia','1|elokvens'),
('elorgel','1|orgel'),
('eloxera','1|oxidera'),
('eloxerande','1|eloxera'),
('eloxerbar','1|eloxera'),
('eloxerbarhet','1|eloxerbar'),
('eloxering','1|eloxera'),
('elpistol','1|pistol'),
('elplatta','1|elspis'),
('elpris','1|pris'),
('elpropp','1|säkring'),
('elritsa','1|karpfisk'),
('elsevir','1|tryck'),
('elsevir','1|tryck'),
('elskandal','1|skandal'),
('elskrot','1|skrot'),
('elspis','1|köksspis'),
('elstolpe','1|stolpe'),
('elström','1|ström'),
('elstängsel','1|stängsel'),
('elstöt','1|stöt'),
('eltejp','1|tejp'),
('eludera','1|undvika'),
('eluderande','1|eludera'),
('eluderbar','1|eludera'),
('eluderbarhet','1|eluderbar'),
('eludering','1|eludera'),
('eluera','1|lösa'),
('eluerande','1|eluera'),
('eluerbar','1|eluera'),
('eluerbarhet','1|eluerbar'),
('eluering','1|eluera'),
('elusion','1|eludera'),
('eluttag','1|uttag'),
('eluvial','1|vittra'),
('eluvium','1|eluvial'),
('elva','1|tal'),
('elva','2|fotbollslag'),
('elvadimensionell','1|dimension'),
('elvahundratalet','1|århundrade'),
('elvahundratalet','1|århundrade'),
('elvamannalag','1|lag'),
('elvasnåret','1|klockslag'),
('elvatiden','1|klockslag'),
('elvaårig','1|år'),
('elvaåring','1|elvaårig'),
('elvaårsgräns','1|gräns'),
('elvaårsperiod','1|period'),
('elverk','1|kraftverk'),
('Elvis','1|Presley'),
('elvisp','1|visp'),
('elvispfabrik','1|fabrik'),
('elvärme','1|uppvärmning'),
('Elyséepalatset','1|palats'),
('elyseisk','1|paradisisk'),
('elända','1|eländig'),
('elände','1|dålig'),
('eländesförutsägelse','1|förutsägelse'),
('eländesrapportering','1|rapportering'),
('eländesskildring','1|skildring'),
('eländig','1|elände'),
('eländighet','1|eländig'),
('elöverkänslig','1|överkänslig'),
('e-mail','1|mejl'),
('e-mail','1|mejl'),
('e-mail','2|mejl'),
('e-mail','2|mejl'),
('e-maila','1|e-mail'),
('e-mailande','1|e-maila'),
('emalj','1|ämne'),
('emalj','2|tand'),
('emaljera','1|emalj'),
('emaljerande','1|emaljera'),
('emaljerbar','1|emaljera'),
('emaljerbarhet','1|emaljerbar'),
('emaljering','1|emaljera'),
('emaljfyllning','1|emalj'),
('emaljfärg','1|färg'),
('emaljglas','1|emalj'),
('emaljinläggning','1|dekoration'),
('emaljlack','1|lack'),
('emaljmålning','1|måla'),
('emaljplomb','1|emaljfyllning'),
('emaljöga','1|ögonprotes'),
('emaljör','1|konstnär'),
('emanation','1|utflöde'),
('emancipation','1|frigörelse'),
('emancipera','1|emancipation'),
('emanciperande','1|emancipera'),
('emanciperbar','1|emancipera'),
('emanciperbarhet','1|emanciperbar'),
('emancipering','1|emancipera'),
('emanera','1|ursprung'),
('emanerande','1|emanera'),
('emanering','1|emanera'),
('emballage','1|förpackning'),
('emballera','1|emballage'),
('emballerande','1|emballera'),
('emballerbar','1|emballera'),
('emballerbarhet','1|emballerbar'),
('emballering','1|emballera'),
('embargo','1|beslagta'),
('embargo','2|förbud'),
('embarkera','1|ombord'),
('embarkerande','1|embarkera'),
('embarkerbar','1|embarkera'),
('embarkerbarhet','1|embarkerbar'),
('embarkering','1|embarkera'),
('embarras','1|bryderi'),
('embellera','1|vacker'),
('embellerande','1|embellera'),
('embellerbar','1|embellera'),
('embellerbarhet','1|embellerbar'),
('embellering','1|embellera'),
('Embla','1|Ask'),
('emblem','1|symbol'),
('emblematik','1|vetenskap'),
('emblematisk','1|emblematik'),
('emblematiskhet','1|emblematisk'),
('emboli','1|blodkärl'),
('embonpoint','1|kalaskula'),
('embryo','1|början'),
('embryolog','1|embryologi'),
('embryologi','1|vetenskap'),
('embryonal','1|embryo'),
('embryonisk','1|outvecklad'),
('embryosäck','1|embryo'),
('emedan','1|eftersom'),
('emellan','1|mellan'),
('emellan','2|ömsesidig'),
('emellanåt','1|ibland'),
('emellertid','1|men'),
('emendation','1|rättning'),
('emendera','1|emendation'),
('emenderande','1|emendera'),
('emenderbar','1|emendera'),
('emenderbarhet','1|emenderbar'),
('emendering','1|emendera'),
('emergent','1|framväxande'),
('emeritus','1|pensionera'),
('emfas','1|betona'),
('emfatisk','1|emfas'),
('emfysem','1|sjukdom'),
('emigrant','1|emigrera'),
('emigration','1|emigrera'),
('emigrera','1|utvandra'),
('emigrerande','1|emigrera'),
('emigrerbar','1|emigrera'),
('emigrerbarhet','1|emigrerbar'),
('emigrering','1|emigrera'),
('eminens','1|kardinal'),
('eminent','1|framstående'),
('eminenthet','1|eminent'),
('emir','1|furste'),
('emiratier','1|Förenade_Arabemiraten'),
('emiratisk','1|Förenade_Arabemiraten'),
('emiratiska','1|emiratier'),
('emissarie','1|sändebud'),
('emission','1|ge_ut'),
('emissionskurs','1|kurs'),
('emitter','1|elektrod'),
('emittera','1|emission'),
('emitterande','1|emittera'),
('emitterbar','1|emittera'),
('emitterbarhet','1|emitterbar'),
('emittering','1|emittera'),
('emma','1|fåtölj'),
('emmentaler','1|ost'),
('emmer','1|vete'),
('emmervete','1|emmer'),
('emo','1|person'),
('emollition','1|uppmjukning'),
('emotion','1|emotionell'),
('emotionalisera','1|emotionell'),
('emotionaliserande','1|emotionalisera'),
('emotionalisering','1|emotionalisera'),
('emotionell','1|känslig'),
('emotiv','1|emotionell'),
('emotse','1|framtid'),
('emotse','1|framtid'),
('emotseende','1|emotse'),
('emotseende','1|emotse'),
('emotstående','1|stå_emot'),
('emotstående','1|stå_emot'),
('empati','1|inlevelse'),
('empatibefriad','1|empati'),
('empatilös','1|empati'),
('empatisk','1|empati'),
('empatistörd','1|sakna'),
('empir','1|stil'),
('empir','1|stil'),
('empirestil','1|stil'),
('empiri','1|empirisk'),
('empiriker','1|empirisk'),
('empirisk','1|erfarenhet'),
('empirism','1|empirisk'),
('empirist','1|empirisk'),
('empiristisk','1|empirism'),
('empyem','1|var'),
('emsersalt','1|medicin'),
('emservatten','1|emsersalt'),
('emu','1|struts'),
('emulgera','1|emulsion'),
('emulgerande','1|emulgera'),
('emulgerbar','1|emulgera'),
('emulgerbarhet','1|emulgerbar'),
('emulgering','1|emulgera'),
('emulsion','1|blandning'),
('emulsionsfärg','1|färg'),
('emulsionssprängämne','1|sprängämne'),
('en','1|tal'),
('en','1|tal'),
('en','2|den'),
('en','3|träd'),
('en','4|ungefär'),
('ena','1|förena'),
('ena','2|annan'),
('ena','3|enris'),
('enahanda','1|tråkig'),
('enaktare','1|akt'),
('enande','1|ena'),
('enande','2|ena'),
('enarmad','1|arm'),
('enarmig','1|enarmad'),
('enarådande','1|allenarådande'),
('enas','1|ena'),
('enastående','1|fantastisk'),
('enaxlad','1|axel'),
('enaxlig','1|stjälk'),
('enaxlighet','1|enaxlig'),
('enbacke','1|backe'),
('enbart','1|bara'),
('enbasisk','1|bas'),
('enbent','1|ben'),
('enbenthet','1|enbent'),
('enbet','1|enspann'),
('enbladig','1|blad'),
('enblommig','1|blomma'),
('enbuske','1|en'),
('enbyggare','1|sambyggare'),
('enbäddsrum','1|enkelrum'),
('enbär','1|bär'),
('enbärsbrännvin','1|brännvin'),
('encefalit','1|hjärninflammation'),
('encefalografi','1|röntgen'),
('Enceladus','1|måne'),
('encellig','1|cell'),
('encellighet','1|encellig'),
('encyklika','1|rundskrivelse'),
('encyklopedi','1|uppslagsbok'),
('encyklopedisk','1|encyklopedi'),
('encyklopedist','1|encyklopedi'),
('enda','1|bara'),
('endagsbesök','1|besök'),
('endast','1|bara'),
('endast','2|om'),
('endaste','1|enda'),
('endels','1|delvis'),
('endemi','1|sjukdom'),
('endemisk','1|endemi'),
('endemisk','2|inhemsk'),
('endera','1|en'),
('endera','2|antingen'),
('endimensionell','1|dimension'),
('endiv','1|grönsak'),
('endogen','1|inre'),
('endokrin','1|inresekretorisk'),
('endokrinolog','1|endokrinologi'),
('endokrinologi','1|vetenskap'),
('endonym','1|benämning'),
('endorfin','1|signalsubstans'),
('endoskopi','1|undersökning'),
('endoskopisk','1|endoskopi'),
('endossat','1|endossement'),
('endossement','1|överlåta'),
('endossement','1|överlåta'),
('endossent','1|endossement'),
('endossera','1|endossement'),
('endosserande','1|endossera'),
('endosserbar','1|endossera'),
('endosserbarhet','1|endosserbar'),
('endossering','1|endossera'),
('endotermisk','1|uppta'),
('endräkt','1|enighet'),
('endräktig','1|endräkt'),
('ene','1|virke'),
('energi','1|kraft'),
('energialternativ','1|alternativ'),
('energibehov','1|behov'),
('energibesparande','1|energisparande'),
('energibrist','1|brist'),
('energidepartement','1|departement'),
('energidryck','1|dryck'),
('energieffektiv','1|effektiv'),
('energieffektivisering','1|energieffektiv'),
('energieffektivitet','1|energieffektiv'),
('energiform','1|energi'),
('energiförbrukande','1|förbruka'),
('energiförbrukare','1|energiförbrukning'),
('energiförbrukning','1|förbrukning'),
('energiförlust','1|förlust'),
('energiförsörjning','1|försörjning'),
('energigivande','1|ge'),
('energiinnehåll','1|innehåll'),
('energiintag','1|kaloriintag'),
('energiintensiv','1|intensiv'),
('energiknippe','1|energisk'),
('energikoncentration','1|koncentration'),
('energikrävande','1|kräva'),
('energikälla','1|källa'),
('energilös','1|energi'),
('energimarknad','1|marknad'),
('energimix','1|mix'),
('energimängd','1|mängd'),
('energimässig','1|energi'),
('energiomställning','1|omställning'),
('energiomsättning','1|omsättning'),
('energiomvandling','1|omvandling'),
('energiomvandlingscentrum','1|centrum'),
('energipolitik','1|politik'),
('energipolitisk','1|energipolitik'),
('energiprincipen','1|energi'),
('energiproduktion','1|produktion'),
('energirik','1|energi'),
('energirikhet','1|energirik'),
('energisk','1|kraftig'),
('energiskatt','1|skatt'),
('energiskog','1|skog'),
('energislukande','1|sluka'),
('energislöseri','1|slöseri'),
('energisnål','1|sparsam'),
('energisparande','1|spara'),
('energisystem','1|system'),
('energiteori','1|teori'),
('energitillstånd','1|tillstånd'),
('energiuppgörelse','1|uppgörelse'),
('energiupptagande','1|uppta'),
('energiutstrålning','1|utstrålning'),
('energiutveckling','1|utveckling'),
('energiverk','1|företag'),
('energivinst','1|vinst'),
('energiåtgång','1|åtgång'),
('enervera','1|irritera'),
('enerverande','1|enervera'),
('enerverbar','1|enervera'),
('enerverbarhet','1|enerverbar'),
('enervering','1|enervera'),
('enfald','1|enfaldig'),
('enfaldeligen','1|enkel'),
('enfaldig','1|dum'),
('enfaldighet','1|enfaldig'),
('enfamiljshus','1|hus'),
('enfas','1|elektricitet'),
('enfasig','1|enfas'),
('enformig','1|tråkig'),
('enformighet','1|enformig'),
('enfotad','1|fot'),
('enfoting','1|fantasifigur'),
('enfrågeparti','1|parti'),
('enfärgad','1|färg'),
('enfödd','1|barn'),
('enföräldersfamilj','1|familj'),
('engagemang','1|engagera'),
('engagera','1|delta'),
('engagerad','1|engagera'),
('engagerande','1|engagera'),
('engagerbar','1|engagera'),
('engagerbarhet','1|engagerbar'),
('engagering','1|engagera'),
('engelsk','1|England'),
('engelsk','1|England'),
('engelsk','2|engelska'),
('engelska','1|språk'),
('engelska','2|engelsman'),
('engelskkurs','1|kurs'),
('engelskkurs','1|kurs'),
('engelsklektion','1|lektion'),
('engelsklektion','1|lektion'),
('engelsklärare','1|lärare'),
('engelsklärare','1|lärare'),
('engelskspråkig','1|engelska'),
('engelskspråkighet','1|engelskspråkig'),
('engelskspåkig','1|engelska'),
('engelskspåkighet','1|engelskspåkig'),
('engelsktalande','1|engelska'),
('engelskundervisning','1|undervisning'),
('engelskundervisning','1|undervisning'),
('engelsman','1|England'),
('engifte','1|äktenskap'),
('England','1|land'),
('englergrad','1|mått'),
('engram','1|minnesspår'),
('engrossist','1|grosshandlare'),
('engång','1|gång'),
('engång','1|gång'),
('engångs','1|gång'),
('engångsartikel','1|artikel'),
('engångsdos','1|dos'),
('engångsflaska','1|flaska'),
('engångsföreteelse','1|företeelse'),
('engångshandduk','1|handduk'),
('engångskaraktär','1|karaktär'),
('engångskostnad','1|kostnad'),
('engångsligg','1|tillfälligt_sex'),
('engångsnatur','1|engångskaraktär'),
('engångsnäsduk','1|näsduk'),
('engångsservett','1|servett'),
('engångsskatt','1|skatt'),
('engångstallrik','1|tallrik'),
('engångsvärde','1|värde'),
('enharmonisk','1|musik'),
('enhet','1|en'),
('enhet','2|avdelning'),
('enhet','3|del'),
('enhetlig','1|enhet'),
('enhetlighet','1|enhetlig'),
('enhetscirkel','1|cirkel'),
('enhetsflygplan','1|flygplan'),
('enhetsfront','1|front'),
('enhetsladdning','1|elementarladdning'),
('enhetslast','1|last'),
('enhetsmått','1|grundmått'),
('enhetsparti','1|parti'),
('enhetspatron','1|patron'),
('enhetsporto','1|porto'),
('enhetspris','1|pris'),
('enhetsskola','1|skola'),
('enhetssträvande','1|sträva'),
('enhetsvektor','1|vektor'),
('enhjulig','1|hjul'),
('enhjulighet','1|enhjulig'),
('enhjuling','1|cykel'),
('enhjärtbladig','1|hjärtblad'),
('enhällig','1|överens'),
('enhällighet','1|enhällig'),
('enhänt','1|hand'),
('enhörning','1|fantasidjur'),
('enig','1|överens'),
('enighet','1|enig'),
('enigmatisk','1|gåtfull'),
('Eniro','1|katalogföretag'),
('enjambemang','1|sammanbindning'),
('enkammarsystem','1|parlament'),
('enkannerligen','1|i_synnerhet'),
('enkel','1|lätt'),
('enkel','2|en'),
('enkel','3|naturlig'),
('enkel','4|anspråkslös'),
('enkelbeckasin','1|vadarfågel'),
('enkelbiff','1|biff'),
('enkelbiljett','1|biljett'),
('enkelbredd','1|tygbredd'),
('enkelhet','1|enkel'),
('enkelhet','2|enkel'),
('enkelhet','3|enkel'),
('enkelkikare','1|tubkikare'),
('enkelknäppning','1|knäppning'),
('enkelknäppt','1|enkelknäppning'),
('enkelkvartett','1|kvartett'),
('enkelladdare','1|gevär'),
('enkelnervig','1|nerv'),
('enkelpipig','1|pipa'),
('enkelrad','1|tipsrad'),
('enkelrenad','1|brännvin'),
('enkelrikta','1|enkelriktad'),
('enkelriktad','1|riktning'),
('enkelriktad','2|ytlig'),
('enkelriktande','1|enkelrikta'),
('enkelrum','1|säng'),
('enkelskriva','1|konsonant'),
('enkelskrivande','1|enkelskriva'),
('enkelspel','1|singelspel'),
('enkelspårig','1|järnvägsspår'),
('enkelspårig','2|ytlig'),
('enkelspårighet','1|enkelspårig'),
('enkelstjärna','1|stjärna'),
('enkelsträngad','1|sträng'),
('enkelsäng','1|säng'),
('enkelteckna','1|enkelskriva'),
('enkeltecknande','1|enkelteckna'),
('enkeltimme','1|lektion'),
('enkeltimme','1|lektion'),
('enkla','1|avlägsna'),
('enklande','1|enkla'),
('enklang','1|klang'),
('enklav','1|område'),
('enklavisering','1|enklav'),
('enklitisk','1|ord'),
('enkom','1|enbart'),
('enkomponents','1|enkomponentskitt'),
('enkomponentskitt','1|kitt'),
('enkorn','1|vete'),
('enkrona','1|mynt'),
('enkät','1|undersökning'),
('enkätsvar','1|svar'),
('enkätundersökning','1|enkät'),
('enkönad','1|kön'),
('enkönsregel','1|regel'),
('enlevera','1|kvinnorov'),
('enleverande','1|enlevera'),
('enleverbar','1|enlevera'),
('enleverbarhet','1|enleverbar'),
('enlevering','1|enlevera'),
('enligt','1|följa'),
('enmansföreställning','1|föreställning'),
('enmansgrav','1|grav'),
('enmanslivbåt','1|livbåt'),
('enmanspublik','1|publik'),
('enmansshow','1|show'),
('enmansteater','1|teater'),
('enmansvalkrets','1|valkrets'),
('enmastad','1|mast'),
('enmastare','1|mast'),
('enmotorig','1|motor'),
('enorm','1|stor'),
('enormhet','1|enorm'),
('enpartistat','1|stat'),
('enpersonsfamilj','1|familj'),
('enpersonshushåll','1|ensamhushåll'),
('enplanshus','1|hus'),
('enplansvilla','1|villa'),
('enpolig','1|pol'),
('enpolighet','1|enpolig'),
('enpucklig','1|puckel'),
('enpucklighet','1|enpucklig'),
('enris','1|en'),
('enrisrökt','1|röka'),
('enrollera','1|anlita'),
('enrollerande','1|enrollera'),
('enrollerbar','1|enrollera'),
('enrollerbarhet','1|enrollerbar'),
('enrollering','1|enrollera'),
('enrummare','1|enrumslägenhet'),
('enrumslägenhet','1|lägenhet'),
('enrådig','1|egenmäktig'),
('ens','1|inte'),
('ens','2|rak'),
('ensa','1|stämma'),
('ensak','1|privat'),
('ensam','1|en'),
('ensamagerande','1|agera'),
('ensamanländande','1|anlända'),
('ensamflygning','1|flygning'),
('ensamförälder','1|förälder'),
('ensamgård','1|gård'),
('ensamhet','1|ensam'),
('ensamhushåll','1|hushåll'),
('ensamkommande','1|komma'),
('ensamrätt','1|nyttjanderätt'),
('ensamseglare','1|segla'),
('ensamstående','1|leva'),
('ensamvarg','1|ensam'),
('ensande','1|ensa'),
('ensartad','1|lik'),
('ense','1|överens'),
('ense','1|överens'),
('ensemble','1|grupp'),
('ensemble','2|kläder'),
('ensemblespel','1|ensemble'),
('ensfyr','1|fyr'),
('ensidig','1|enkel'),
('ensidighet','1|ensidig'),
('ensiffrig','1|siffra'),
('ensilage','1|foder'),
('ensilera','1|ensilage'),
('ensilerande','1|ensilera'),
('ensilerbar','1|ensilera'),
('ensilerbarhet','1|ensilerbar'),
('ensilering','1|ensilera'),
('ensitsig','1|sits'),
('ensittare','1|enstöring'),
('Enskede','1|Stockholm'),
('enskeppig','1|skepp'),
('enskifte','1|jordområde'),
('enskild','1|en'),
('enskildhet','1|enskild'),
('enslig','1|isolerad'),
('enslighet','1|enslig'),
('ensling','1|enstöring'),
('enslinje','1|ens'),
('enspann','1|hästspann'),
('enspråkig','1|språk'),
('enspråkighet','1|enspråkig'),
('enspänd','1|enspann'),
('enstaka','1|en'),
('enstavig','1|stavelse'),
('enstavighet','1|enstavig'),
('enstavighetsaccent','1|akut'),
('enstegstätad','1|täta'),
('enstensmur','1|mur'),
('enstjärnig','1|kvalitet'),
('enstämmig','1|stämma'),
('enstämmig','2|enhällig'),
('enstämmighet','1|enstämmig'),
('enständig','1|enträgen'),
('enständighet','1|enständig'),
('enstörig','1|enstöring'),
('enstörighet','1|enstörig'),
('enstöring','1|bo'),
('ental','1|tal'),
('entalpi','1|mått'),
('entalsform','1|ental'),
('entente','1|förbindelse'),
('entente','1|förbindelse'),
('enter','1|retur'),
('enterknapp','1|enter'),
('entertainer','1|underhållare'),
('entertangent','1|enter'),
('entita','1|småfågel'),
('entitet','1|ting'),
('entlediga','1|avskeda'),
('entledigande','1|entlediga'),
('entomolog','1|entomologi'),
('entomologi','1|vetenskap'),
('entomologisk','1|insekt'),
('entonig','1|ton'),
('entonighet','1|entonig'),
('en-tous-cas','1|grus'),
('entré','1|ingång'),
('entréavgift','1|inträdesavgift'),
('entrébiljett','1|biljett'),
('entrecote','1|nötkött'),
('entrecote','1|nötkött'),
('entrédörr','1|dörr'),
('entrédörr','2|dörr'),
('entreprenad','1|arbete'),
('entreprenadmaskin','1|maskin'),
('entreprenör','1|entreprenad'),
('entreprenörsanda','1|företagaranda'),
('entreprenörskap','1|entreprenör'),
('entrérätt','1|förrätt'),
('entresol','1|mellanvåning'),
('entresol','1|mellanvåning'),
('entresolvåning','1|entresol'),
('entropi','1|energiförlust'),
('enträgen','1|angelägen'),
('enträgenhet','1|enträgen'),
('entumsspik','1|spik'),
('entusiasm','1|entusiastisk'),
('entusiasmera','1|entusiastisk'),
('entusiasmerande','1|entusiasmera'),
('entusiasmerbar','1|entusiasmera'),
('entusiasmerbarhet','1|entusiasmerbar'),
('entusiasmering','1|entusiasmera'),
('entusiast','1|entusiastisk'),
('entusiastisk','1|ivrig'),
('entusiastsajt','1|sajt'),
('entydig','1|klar'),
('entydighet','1|entydig'),
('entypsbåt','1|segelbåt'),
('enumeration','1|uppräkning'),
('envar','1|varje'),
('enveten','1|envis'),
('envetenhet','1|enveten'),
('envig','1|tvekamp'),
('environg','1|omgivning'),
('envis','1|vilja'),
('envisas','1|envis'),
('envishet','1|envis'),
('envoyé','1|chef'),
('envåldshärskare','1|diktator'),
('envåldsmakt','1|envälde'),
('envåningsbarack','1|barack'),
('envåningshus','1|enplanshus'),
('envägskommunikation','1|kommunikation'),
('envälde','1|styra'),
('enväldig','1|envälde'),
('enväldighet','1|enväldig'),
('envärd','1|elektron'),
('enzym','1|ämne'),
('enzymrubbning','1|rubbning'),
('enzymsystem','1|system'),
('enzymtvättmedel','1|tvättmedel'),
('enäggstvilling','1|tvilling'),
('enär','1|eftersom'),
('enögd','1|öga'),
('enögd','2|inskränkt'),
('enögdhet','1|enögd'),
('enögdhet','2|enögd'),
('eoarkeikum','1|arkeikum'),
('eocen','1|paleogen'),
('eoler','1|folk'),
('eoler','1|folk'),
('eolisk','1|vind'),
('eolsharpa','1|harpa'),
('eon','1|period'),
('eosin','1|färgämne'),
('EP','1|grammofonskiva'),
('epatraktor','1|lastbil'),
('epicentrum','1|centrum'),
('epicykel','1|omloppsbana'),
('epidemi','1|sjukdom'),
('epidemiologi','1|vetenskap'),
('epidemiologisk','1|epidemi'),
('epidemisjukhus','1|sjukhus'),
('epidemisk','1|epidemi'),
('epidemolog','1|expert'),
('epidermis','1|överhud'),
('epiduralblockad','1|bedövning'),
('epifani','1|uppenbarelse'),
('epifanisk','1|epifani'),
('epifenomen','1|fenomen'),
('epifys','1|tallkottkörtel'),
('epifys','2|ben'),
('epifyt','1|växt'),
('epigenetisk','1|läsa_av'),
('epigon','1|efterbilda'),
('epigoneri','1|epigon'),
('epigrafik','1|vetenskap'),
('epigram','1|dikt'),
('epigrammatisk','1|epigram'),
('epik','1|dikt'),
('epiker','1|episk'),
('epikuré','1|epikurism'),
('epikureisk','1|epikurism'),
('epikuréism','1|epikuré'),
('epikurism','1|filosofi'),
('Epikuros','1|epikurism'),
('epilepsi','1|sjukdom'),
('epileptiker','1|epilepsi'),
('epileptisk','1|epilepsi'),
('epilera','1|avlägsna'),
('epilerande','1|epilera'),
('epilerbar','1|epilera'),
('epilerbarhet','1|epilerbar'),
('epilering','1|epilera'),
('epilog','1|avslutning'),
('epinefrin','1|adrenalin'),
('episk','1|berätta'),
('episk','2|storslagen'),
('episkop','1|projektor'),
('episkopal','1|biskop'),
('episkopalkyrka','1|kyrka'),
('episkopat','1|biskopsdöme'),
('episod','1|händelse'),
('episodisk','1|episod'),
('epistel','1|brev'),
('epistel','2|bibeltext'),
('epistemologi','1|kunskapsteori'),
('epistolär','1|epistel'),
('epistyl','1|arkitrav'),
('epitaf','1|epitafium'),
('epitafium','1|minnesskrift'),
('epitel','1|vävnad'),
('epitelcell','1|cell'),
('epitet','1|attribut'),
('epitet','2|attribut'),
('epizoisk','1|epizooti'),
('epizooti','1|epidemi'),
('epok','1|period'),
('epokgörande','1|betydelsefull'),
('epos','1|diktverk'),
('e-post','1|post'),
('e-post','1|post'),
('e-posta','1|e-post'),
('e-posta','1|e-post'),
('e-postande','1|e-posta'),
('e-postande','1|e-posta'),
('e-postare','1|e-post'),
('e-postare','1|e-post'),
('e-postbrev','1|e-brev'),
('e-postbrev','1|e-brev'),
('e-postledes','1|e-post'),
('e-postledes','1|e-post'),
('e-postmeddelande','1|e-brev'),
('e-postmeddelande','1|e-brev'),
('epoxi','1|härdplast'),
('epoxylim','1|lim'),
('epsilon','1|bokstav'),
('epålett','1|prydnad'),
('era','1|period'),
('Erato','1|musa'),
('erbarmlig','1|dålig'),
('erbarmligen','1|erbarmlig'),
('erbarmlighet','1|erbarmlig'),
('erbium','1|grundämne'),
('erbium','1|grundämne'),
('erbjuda','1|ge'),
('erbjudan','1|erbjudande'),
('erbjudande','1|erbjuda'),
('erektion','1|styvnad'),
('erektionsnöd','1|impotens'),
('eremit','1|bo'),
('eremitage','1|lustslott'),
('eremitisk','1|eremit'),
('eremitkräfta','1|kräfta'),
('eremitliv','1|eremit'),
('erfara','1|veta'),
('erfarande','1|erfara'),
('erfaren','1|van'),
('erfarenhet','1|erfaren'),
('erfarenhetsbank','1|erfarenhet'),
('erfarenhetsbaserad','1|erfarenhet'),
('erfarenhetsgrundad','1|erfarenhetsbaserad'),
('erfarenhetsmässig','1|erfarenhet'),
('erfarenhetsmässighet','1|erfarenhetsmässig'),
('erfarenhetssfär','1|sfär'),
('erfarenhetsvärld','1|värld'),
('erforderlig','1|behöva'),
('erforderlighet','1|erforderlig'),
('erfordra','1|behöva'),
('erfordrande','1|erfordra'),
('ergativ','1|kasus'),
('ergativ','2|ergativ'),
('ergativ','3|verbform'),
('ergativsubjekt','1|subjekt'),
('ergo','1|följaktligen'),
('ergometer','1|mäta'),
('ergonom','1|ergonomi'),
('ergonometrisk','1|passa'),
('ergonomi','1|vetenskap'),
('ergonomisk','1|arbeta'),
('erhålla','1|få'),
('erhållande','1|erhålla'),
('Ericsson','2|telefonbolag'),
('erigera','1|erektion'),
('erigerande','1|erigera'),
('erigerbar','1|erigera'),
('erigerbarhet','1|erigerbar'),
('erigering','1|erigera'),
('Eriksberg','1|stadsdel'),
('eriksgata','1|resa'),
('erinnye','1|hämndgudinna'),
('erinra','1|minnas'),
('erinran','1|erinra'),
('erinran','2|anmärkning'),
('erinrande','1|erinra'),
('erinring','1|erinran'),
('erisäpple','1|tvistefrö'),
('Eritrea','1|land'),
('eritrean','1|Eritrea'),
('eritreansk','1|Eritrea'),
('eritreanska','1|eritrean'),
('eritreanska','2|språk'),
('erkänd','1|erkänna'),
('erkändhet','1|erkänd'),
('erkänna','1|medge'),
('erkänna','2|status'),
('erkännande','1|erkänna'),
('erkännande','2|erkänna'),
('erkännansvärd','1|berömvärd'),
('erkännsam','1|berömma'),
('erkännsamhet','1|erkännsam'),
('erkänsla','1|tacksamhet'),
('Erle','1|Kaufmann'),
('erlägga','1|betala'),
('erläggande','1|erlägga'),
('ernå','1|uppnå'),
('ernåelig','1|ernå'),
('ernående','1|ernå'),
('erodera','1|vittra'),
('eroderande','1|erodera'),
('eroderbar','1|erodera'),
('eroderbarhet','1|eroderbar'),
('erodering','1|erodera'),
('erogen','1|retning'),
('Eros','1|gud'),
('erosion','1|erodera'),
('erosionsskada','1|skada'),
('erosionsstrand','1|strand'),
('erotik','1|erotisk'),
('erotiker','1|erotik'),
('erotisera','1|erotisk'),
('erotiserande','1|erotisera'),
('erotisering','1|erotisera'),
('erotisk','1|älska'),
('erotogen','1|erogen'),
('erotoman','1|erotisk'),
('erotoman','2|erotoman'),
('erotomani','1|erotoman'),
('errata','1|tryckfel'),
('erratisk','1|förflyttning'),
('ersmässa','1|marknad'),
('ersätta','1|byta'),
('ersätta','2|betala'),
('ersättande','1|ersätta'),
('ersättande','2|ersätta'),
('ersättare','1|ersätta'),
('ersättlig','1|ersätta'),
('ersättlighet','1|ersättlig'),
('ersättning','1|ersätta'),
('ersättning','2|ersätta'),
('ersättningsanspråk','1|anspråk'),
('ersättningsansvar','1|ansvar'),
('ersättningsbelopp','1|ersättning'),
('ersättningsberättigad','1|berättiga'),
('ersättningsbuss','1|buss'),
('ersättningsnivå','1|nivå'),
('ersättningsskyldig','1|skyldig'),
('ersättningsskyldighet','1|skyldighet'),
('ertappa','1|avslöja'),
('ertappande','1|ertappa'),
('ertappning','1|ertappa'),
('eruption','1|vulkanutbrott'),
('eruptiv','1|eruption'),
('eruptivbergart','1|bergart'),
('erytropoitin','1|hormon'),
('erövra','1|inta'),
('erövra','2|skaffa_sig'),
('erövrande','1|erövra'),
('erövrare','1|erövra'),
('erövring','1|erövra'),
('erövringslysten','1|erövra'),
('erövringståg','1|tåg'),
('Esau','1|Bibeln'),
('escudo','1|myntenhet'),
('eselhuvud','1|mast'),
('eskader','1|flotta'),
('eskalation','1|eskalera'),
('eskalera','1|trappa_upp'),
('eskalerande','1|eskalera'),
('eskalerbar','1|eskalera'),
('eskalerbarhet','1|eskalerbar'),
('eskalering','1|eskalera'),
('eskapad','1|äventyr'),
('eskapism','1|verklighetsflykt'),
('eskapistisk','1|eskapism'),
('eskarp','1|befästningsgrav'),
('eskatolog','1|eskatologi'),
('eskatologi','1|föreställning'),
('eskatologisk','1|efter'),
('Eskilstuna','1|stad'),
('eskimå','1|folk'),
('eskimåhund','1|spets'),
('eskimåiska','1|språk'),
('eskort','1|följe'),
('eskortbranschen','1|eskortkvinna'),
('eskortera','1|eskort'),
('eskorterande','1|eskortera'),
('eskorterbar','1|eskortera'),
('eskorterbarhet','1|eskorterbar'),
('eskortering','1|eskortera'),
('eskortflicka','1|prostituerad'),
('eskortkvinna','1|eskortflicka'),
('eskulap','1|läkare'),
('eskulapstav','1|stav'),
('esomoftast','1|alltsomoftast'),
('esoterisk','1|mystisk'),
('espadrill','1|sandal'),
('espagnolett','1|spanjolett'),
('esparto','1|espartogräs'),
('espartogräs','1|fiber'),
('esperantist','1|esperanto'),
('esperanto','1|språk'),
('esplanad','1|gata'),
('espresso','1|kaffe'),
('espressobryggare','1|kaffebryggare'),
('espri','1|spirituell'),
('espri','1|spirituell'),
('espri','2|prydnadsfjäder'),
('espri','2|prydnadsfjäder'),
('Esquilinen','1|kulle'),
('ess','1|spelkort'),
('ess','1|spelkort'),
('essens','1|essentiell'),
('essens','2|ämne'),
('essentiell','1|väsentlig'),
('essiv','1|kasus'),
('Essunga','1|ort'),
('essä','1|uppsats'),
('essä','1|uppsats'),
('essäbok','1|bok'),
('essäfråga','1|fråga'),
('essäist','1|essä'),
('essäist','1|essä'),
('essäistik','1|essä'),
('essäistik','1|essä'),
('essäistisk','1|essä'),
('essäistisk','1|essä'),
('essäsamling','1|samling'),
('essäsamling','1|samling'),
('essäskrivande','1|skriva'),
('essäskrivande','2|skrivande'),
('essäuppgift','1|essäfråga'),
('est','1|Estland'),
('ester','1|förening'),
('esterplast','1|polyester'),
('estet','1|estetisk'),
('esteticera','1|esteticism'),
('esteticera','1|esteticism'),
('esteticerande','1|esteticera'),
('esteticerande','1|esteticera'),
('esteticerbar','1|esteticera'),
('esteticerbar','1|esteticera'),
('esteticerbarhet','1|esteticerbar'),
('esteticerbarhet','1|esteticerbar'),
('esteticering','1|esteticera'),
('esteticering','1|esteticera'),
('esteticism','1|estetisk'),
('estetik','1|estetisk'),
('estetiker','1|estet'),
('estetisk','1|skön'),
('estimera','1|uppskatta'),
('estimerande','1|estimera'),
('estimerbar','1|estimera'),
('estimerbarhet','1|estimerbar'),
('estimering','1|estimera'),
('Estland','1|land'),
('estländare','1|est'),
('estländsk','1|estnisk'),
('estländska','1|estniska'),
('estnisk','1|Estland'),
('estniska','1|språk'),
('estniska','2|est'),
('Estonia','1|färja'),
('estrad','1|scen'),
('estradartist','1|artist'),
('estraddebatt','1|paneldebatt'),
('estradplats','1|plats'),
('estradsamtal','1|estraddebatt'),
('estradör','1|estradartist'),
('et','1|och'),
('eta','1|bokstav'),
('etablera','1|börja'),
('etablerad','1|erkänd'),
('etablerande','1|etablera'),
('etablerbar','1|etablera'),
('etablerbarhet','1|etablerbar'),
('etablering','1|etablera'),
('etablissemang','1|anläggning'),
('etablissemang','1|anläggning'),
('etablissemanget','1|etablera'),
('etablissemangsföreträdare','1|företrädare'),
('etage','1|plan'),
('etagevåning','1|lägenhet'),
('etagär','1|hylla'),
('etalong','1|likare'),
('etan','1|gas'),
('etanol','1|alkohol'),
('etanolbil','1|bil'),
('etanoldriven','1|driva'),
('etapp','1|stadium'),
('etapplinje','1|frontförbindelse'),
('etappstation','1|station'),
('etappvis','1|etapp'),
('etappväsen','1|armé'),
('etcetera','1|mycken'),
('etcetera','1|mycken'),
('etcetera','1|mycken'),
('etcetera','1|mycken'),
('eten','1|gas'),
('etenplast','1|polyeten'),
('eter','1|bedöva'),
('eter','2|rymd'),
('eterflaska','1|flaska'),
('eterisation','1|eterisering'),
('eterisera','1|eter'),
('eteriserande','1|eterisera'),
('eteriserbar','1|eterisera'),
('eteriserbarhet','1|eteriserbar'),
('eterisering','1|eterisera'),
('eterisk','1|flyktig'),
('eterisk','2|bräcklig'),
('etermediemonopol','1|monopol'),
('etermedium','1|radio'),
('etermedium','1|radio'),
('eternell','1|blomma'),
('e-tidning','1|tidning'),
('e-tidskrift','1|tidskrift'),
('etik','1|etisk'),
('etiker','1|etik'),
('etikett','1|märke'),
('etikett','2|uppfostran'),
('etikettera','1|etikett'),
('etiketterande','1|etikettera'),
('etiketterbar','1|etikettera'),
('etiketterbarhet','1|etiketterbar'),
('etikettering','1|etikettera'),
('etikettmoln','1|tagg'),
('etikettråd','1|råd'),
('etikettsfel','1|fel'),
('etikettsfråga','1|fråga'),
('etikettsmässig','1|etikett'),
('etikpröva','1|pröva'),
('etikprövande','1|etikpröva'),
('etikprövning','1|etikpröva'),
('etikprövningslag','1|lag'),
('etiolering','1|ljusbrist'),
('etiologi','1|vetenskap'),
('etiologisk','1|orsak'),
('etiop','1|etiopier'),
('Etiopien','1|land'),
('etiopier','1|Etiopien'),
('etiopisk','1|Etiopien'),
('etiopiska','1|språk'),
('etiopiska','2|etiopier'),
('etisk','1|moral'),
('Etna','1|vulkan'),
('etnicitet','1|etnisk'),
('etnifiera','1|etnisk'),
('etnifierande','1|etnifiera'),
('etnifierbar','1|etnifiera'),
('etnifierbarhet','1|etnifierbar'),
('etnifiering','1|etnifiera'),
('etnisk','1|folk'),
('etnocentrisk','1|etnisk'),
('etnocentrism','1|etnocentrisk'),
('etnograf','1|etnografi'),
('etnografi','1|vetenskap'),
('etnografisk','1|etnisk'),
('etnolog','1|etnologi'),
('etnologi','1|vetenskap'),
('etnologisk','1|etnisk'),
('etolog','1|etologi'),
('etologi','1|vetenskap'),
('etologisk','1|beteende'),
('etrusk','1|folk'),
('etrusk','1|folk'),
('etruskisk','1|etrusk'),
('etruskiska','1|språk'),
('etruskiska','2|etrusk'),
('etruskologi','1|vetenskap'),
('etsa','1|gravera'),
('etsa','2|fräta'),
('etsande','1|etsa'),
('etsande','2|etsa'),
('etsare','1|etsa'),
('etsmedel','1|etsa'),
('etsning','1|etsa'),
('etsnål','1|nål'),
('ett','1|i_samklang'),
('etta','1|siffra'),
('etta','2|enrumslägenhet'),
('etta','3|förstaplatsen'),
('ettdera','1|endera'),
('etter','1|gift'),
('ettermyra','1|myra'),
('ettiden','1|klockslag'),
('ettrig','1|ilsken'),
('ettrighet','1|ettrig'),
('ettrumslägenhet','1|enrumslägenhet'),
('ettsnåret','1|klockslag'),
('ettstruken','1|oktav'),
('ettårig','1|år'),
('ettåring','1|ettårig'),
('ettöring','1|mynt'),
('etui','1|ask'),
('etyd','1|musikstycke'),
('etyl','1|kolväte'),
('etylalkohol','1|alkohol'),
('etylen','1|eten'),
('etymolog','1|etymologi'),
('etymologi','1|vetenskap'),
('etymologisera','1|etymologi'),
('etymologiserande','1|etymologisera'),
('etymologiserbar','1|etymologisera'),
('etymologiserbarhet','1|etymologiserbar'),
('etymologisering','1|etymologisera'),
('etymologisk','1|ursprung'),
('etyn','1|acetylen'),
('EU','1|union'),
('EU','1|union'),
('EU','1|union'),
('eudemonism','1|lycka'),
('eufemism','1|förskönande_omskrivning'),
('eufemistisk','1|eufemism'),
('eufoni','1|harmoni'),
('euforbia','1|törel'),
('eufori','1|känsla'),
('euforisk','1|eufori'),
('eugenik','1|arvshygien'),
('EU-intern','1|EU'),
('eukalyptus','1|träd'),
('eukalyptusdoftande','1|dofta'),
('eukalyptusolja','1|olja'),
('eukaryot','1|organism'),
('Euklides','1|matematiker'),
('euklidisk','1|geometri'),
('EU-kommissionen','1|styre'),
('EU-korrespondent','1|korrespondent'),
('EU-land','1|medlemsland'),
('eumenid','1|hämndgudinna'),
('EU-migrant','1|migrant'),
('EU-minister','1|minister'),
('eunuck','1|man'),
('EU-parlamentariker','1|EU-parlamentet'),
('EU-parlamentet','1|parlament'),
('Eurasien','1|Europa'),
('eurasier','1|Eurasien'),
('eurasisk','1|Eurasien'),
('eurasiska','1|eurasier'),
('Euripides','1|dramatiker'),
('euro','1|myntenhet'),
('euro','1|myntenhet'),
('eurodollar','1|dollar'),
('euroislam','1|islam'),
('eurokalabalik','1|kalabalik'),
('eurokommunism','1|kommunism'),
('eurokommunistisk','1|eurokommunism'),
('eurokris','1|kris'),
('euroland','1|land'),
('Europa','1|världsdel'),
('Europa','2|måne'),
('europabörs','1|börs'),
('europamästare','1|mästare'),
('europamästerskap','1|tävling'),
('europamästerskap','1|tävling'),
('Europaparlamentet','1|EU-parlamentet'),
('europaparlamentsval','1|val'),
('Europarådet','1|råd'),
('Europarådsparlamentariker','1|Europarådsparlamentet'),
('Europarådsparlamentet','1|parlament'),
('Europaunionen','1|union'),
('europaväg','1|vägnät'),
('europavänstern','1|vänster'),
('europé','1|Europa'),
('europeisera','1|Europa'),
('europeiserande','1|europeisera'),
('europeiserbar','1|europeisera'),
('europeiserbarhet','1|europeiserbar'),
('europeisering','1|europeisera'),
('europeisk','1|Europa'),
('europeisk','1|Europa'),
('europeiska','1|europé'),
('europid','1|ras'),
('europid','2|europid'),
('europium','1|grundämne'),
('europium','1|grundämne'),
('eurosamarbete','1|samarbete'),
('euroskeptisk','1|skeptisk'),
('eurovaluta','1|valuta'),
('eurovision','1|TV'),
('eurytmi','1|rytmik'),
('EU-skeptisk','1|skeptisk'),
('eusocialitet','1|myrsamhälle'),
('eutanasi','1|dödshjälp'),
('Euterpe','1|musa'),
('eutrof','1|näringsrik'),
('EU-utvidgning','1|utvidgning'),
('EU-val','1|val'),
('eva','1|kvinna'),
('evad','1|vare_sig'),
('evad','2|vad_än'),
('evakostym','1|naken'),
('evakuera','1|tömma'),
('evakuerande','1|evakuera'),
('evakuerbar','1|evakuera'),
('evakuerbarhet','1|evakuerbar'),
('evakuering','1|evakuera'),
('evaluera','1|värdera'),
('evaluerande','1|evaluera'),
('evaluerbar','1|evaluera'),
('evaluerbarhet','1|evaluerbar'),
('evaluering','1|evaluera'),
('evalvera','1|omräkna'),
('evalverande','1|evalvera'),
('evalverbar','1|evalvera'),
('evalverbarhet','1|evalverbar'),
('evalvering','1|evalvera'),
('evangeliebok','1|bok'),
('evangelietext','1|evangelium'),
('evangelisation','1|evangelisera'),
('evangelisera','1|mission'),
('evangeliserande','1|evangelisera'),
('evangelisering','1|evangelisera'),
('evangelisk','1|evangelium'),
('evangelist','1|evangelium'),
('evangelist','2|predikant'),
('evangelium','1|budskap'),
('evaporation','1|evaporera'),
('evaporera','1|avdunsta'),
('evaporerande','1|evaporera'),
('evaporerbar','1|evaporera'),
('evaporerbarhet','1|evaporerbar'),
('evaporering','1|evaporera'),
('evar','1|varhelst'),
('evart','1|varthelst'),
('evem','1|vem_helst'),
('evenemang','1|händelse'),
('eventualitet','1|eventuell'),
('eventuell','1|kanske'),
('eventuell','1|kanske'),
('eventuell','1|kanske'),
('evergreen','1|schlager'),
('evertebrat','1|djur'),
('e-vetenskap','1|vetenskap'),
('evidens','1|bevis'),
('evidensbaserad','1|basera'),
('evident','1|uppenbar'),
('evig','1|ständig'),
('evighet','1|tid'),
('evighetsblomma','1|eternell'),
('evighetsfilter','1|filter'),
('evighetsgäldenär','1|skuldsatt'),
('evighetskalender','1|kalender'),
('evighetslång','1|lång'),
('evighetsmaskin','1|fungera'),
('evinnerlig','1|evig'),
('evinnerlig','2|ständig'),
('evinnerligen','1|evinnerlig'),
('evinnerlighet','1|evinnerlig'),
('evinnerlighet','2|evinnerlig'),
('evolution','1|utveckling'),
('evolutionism','1|evolution'),
('evolutionist','1|evolution'),
('evolutionistisk','1|evolutionism'),
('evolutionsbiolog','1|biolog'),
('evolutionsforskning','1|forskning'),
('evolutionsmekanism','1|mekanism'),
('evolutionsmässig','1|evolution'),
('evolutionsmässighet','1|evolutionsmässig'),
('evolutionsteorin','1|teori'),
('evolutionär','1|evolution'),
('evärdlig','1|evig'),
('evärdlighet','1|evärdlig'),
('ex','1|före_detta'),
('exabyte','1|byte'),
('exabyte','1|byte'),
('exakt','1|precis'),
('exakthet','1|exakt'),
('exaltation','1|exhalterad'),
('exalterad','1|upphetsad'),
('examen','1|prov'),
('examen','2|utbildning'),
('examensarbete','1|examensuppgift'),
('examensfråga','1|fråga'),
('examensuppgift','1|uppgift'),
('examinand','1|examen'),
('examination','1|examen'),
('examinator','1|examen'),
('examinatorium','1|examinera'),
('examinera','1|undersöka'),
('examinera','2|prov'),
('examinerande','1|examinera'),
('examinerande','2|examinera'),
('examinerbar','1|examinera'),
('examinerbar','2|examinera'),
('examinerbarhet','1|examinerbar'),
('examinerbarhet','2|examinerbar'),
('examinering','1|examinera'),
('examinering','2|examinera'),
('exantem','1|utslag'),
('excellens','1|minister'),
('excellent','1|utmärkt'),
('excellera','1|utmärka_sig'),
('excellerande','1|excellera'),
('excellering','1|excellera'),
('excenter','1|rotera'),
('excenteraxel','1|axel'),
('excenterskiva','1|skiva'),
('excenterstång','1|stång'),
('excentricitet','1|excentrisk'),
('excentricitet','2|excentrisk'),
('excentriker','1|excentrisk'),
('excentrisk','1|originell'),
('excentrisk','2|cirkelform'),
('exceptionell','1|undantag'),
('excerpera','1|söka'),
('excerperande','1|excerpera'),
('excerperbar','1|excerpera'),
('excerperbarhet','1|excerperbar'),
('excerpering','1|excerpera'),
('excerpist','1|excerpera'),
('excerpt','1|excerpera'),
('excess','1|överdrift'),
('excessiv','1|excess'),
('excision','1|avlägsna'),
('excitation','1|excitera'),
('excitera','1|stimulera'),
('exciterande','1|excitera'),
('exciterbar','1|excitera'),
('exciterbarhet','1|exciterbar'),
('excitering','1|excitera'),
('exeges','1|förklara'),
('exeget','1|exeges'),
('exegetik','1|exeges'),
('exegetisk','1|exegetik'),
('exekution','1|avrättning'),
('exekution','2|verkställa'),
('exekutionspluton','1|pluton'),
('exekutiv','1|verkställa'),
('exekutiv','2|exekutiv'),
('exekutor','1|exekutiv'),
('exekutorisk','1|exekutiv'),
('exekutör','1|exekutiv'),
('exekvera','1|utföra'),
('exekverande','1|exekvera'),
('exekverbar','1|exekvera'),
('exekverbarhet','1|exekverbar'),
('exekvering','1|exekvera'),
('exempel','1|förekomma'),
('exempel','1|förekomma'),
('exempel','1|förekomma'),
('exempellös','1|makalös'),
('exempellöshet','1|exempellös'),
('exempelsamling','1|samling'),
('exempelvis','1|exempel'),
('exemplar','1|kopia'),
('exemplarisk','1|föredömlig'),
('exemplifiera','1|exempel'),
('exemplifierande','1|exemplifiera'),
('exemplifierbar','1|exemplifiera'),
('exemplifierbarhet','1|exemplifierbar'),
('exemplifiering','1|exemplifiera'),
('exemplifikation','1|exemplifiering'),
('exercera','1|exercis'),
('exercerande','1|exercera'),
('exercerbar','1|exercera'),
('exercerbarhet','1|exercerbar'),
('exercering','1|exercera'),
('exercis','1|öva'),
('exercisfält','1|fält'),
('exflickvän','1|flickvän'),
('exfru','1|exhustru'),
('exhalterad','1|upprörd'),
('exhibitionism','1|visa'),
('exhibitionist','1|exhibitionism'),
('exhibitionistisk','1|exhibitionism'),
('exhustru','1|hustru'),
('exigibel','1|kräva'),
('exil','1|landsflykt'),
('exilhuvudstad','1|huvudstad'),
('exin','1|ytterhölje'),
('existens','1|existera'),
('existensberättigande','1|berättigande'),
('existensform','1|existens'),
('existensmedel','1|medel'),
('existensminimum','1|minimum'),
('existensvillkor','1|villkor'),
('existentialism','1|filosofi'),
('existentialistisk','1|existentialism'),
('existentiell','1|existens'),
('existentiell','1|existens'),
('existera','1|vara'),
('existerande','1|existera'),
('existerande','2|existera'),
('exklamation','1|utrop'),
('exklamatorisk','1|exklamation'),
('exklav','1|enklav'),
('exkludera','1|utesluta'),
('exkluderande','1|exkludera'),
('exkluderbar','1|exkludera'),
('exkluderbarhet','1|exkluderbar'),
('exkludering','1|exkludera'),
('exklusiv','1|enastående'),
('exklusiv','2|unik'),
('exklusive','1|utom'),
('exklusive','1|utom'),
('exklusive','1|utom'),
('exklusivitet','1|exklusiv'),
('exkommunicera','1|bannlysa'),
('exkommunicerande','1|exkommunicera'),
('exkommunicerbar','1|exkommunicera'),
('exkommunicerbarhet','1|exkommunicerbar'),
('exkommunicering','1|exkommunicera'),
('exkommunikation','1|exkommunicera'),
('exkommunistisk','1|kommunistisk'),
('exkonung','1|kung'),
('exkrement','1|avföring'),
('exkremental','1|exkrement'),
('exkret','1|utsöndra'),
('exkretion','1|exkret'),
('exkung','1|kung'),
('exkurs','1|utvikning'),
('exkursion','1|resa'),
('exlibris','1|ägare'),
('exodus','1|utvandring'),
('exoftalmometer','1|mäta'),
('exoftalmus','1|glosögdhet'),
('exogen','1|påverka'),
('exonym','1|benämning'),
('exoplanet','1|planet'),
('exorcism','1|utdriva'),
('exorcist','1|exorcism'),
('exorcistisk','1|exorcism'),
('exoterisk','1|populär'),
('exotermisk','1|avge'),
('exotisk','1|utländsk'),
('exotism','1|konstriktning'),
('exotistisk','1|exotism'),
('expandera','1|utvidga'),
('expanderande','1|expandera'),
('expanderbar','1|expandera'),
('expanderbarhet','1|expanderbar'),
('expandering','1|expandera'),
('expansibel','1|expandera'),
('expansion','1|expandera'),
('expansionism','1|expandera'),
('expansionistisk','1|expansionism'),
('expansionskraft','1|expansion'),
('expansionskärl','1|kärl'),
('expansionsplan','1|plan'),
('expansionstakt','1|takt'),
('expansionsvilja','1|vilja'),
('expansiv','1|expandera'),
('expatriera','1|landsförvisa'),
('expatrierande','1|expatriera'),
('expatrierbar','1|expatriera'),
('expatrierbarhet','1|expatrierbar'),
('expatriering','1|expatriera'),
('expediera','1|betjäna'),
('expedierande','1|expediera'),
('expedierbar','1|expediera'),
('expedierbarhet','1|expedierbar'),
('expediering','1|expediera'),
('expedit','1|expediera'),
('expedit','2|rask'),
('expedition','1|kontor'),
('expedition','2|resa'),
('expedition','3|verkställa'),
('expeditionschef','1|chefstjänsteman'),
('expeditionskår','1|kår'),
('expeditionsledare','1|ledare'),
('expeditionsministär','1|expeditionsregering'),
('expeditionsregering','1|regering'),
('expeditionsvakt','1|vakt'),
('expeditör','1|expediera'),
('expektoration','1|expektorera'),
('expektorera','1|upphostning'),
('expektorerande','1|expektorera'),
('expektorerbar','1|expektorera'),
('expektorerbarhet','1|expektorerbar'),
('expektorering','1|expektorera'),
('expenser','1|omkostnader'),
('experiment','1|försök'),
('experimentalfysiker','1|fysiker'),
('experimentalkirurgi','1|kirurgi'),
('experimentator','1|experiment'),
('experimentell','1|experiment'),
('experimentell','1|experiment'),
('experimentera','1|experiment'),
('experimenterande','1|experimentera'),
('experimentering','1|experimentera'),
('experimentfält','1|område'),
('experimentgymnasium','1|gymnasium'),
('experimentlusta','1|lust'),
('experimentstation','1|kontrollstation'),
('expert','1|kunna'),
('expertgrupp','1|expert'),
('expertis','1|expert'),
('expertkommentator','1|kommentator'),
('expertkommitté','1|kommitté'),
('expertkrets','1|krets'),
('expertspråk','1|språk'),
('expertutlåtande','1|utlåtande'),
('expertutredare','1|utredare'),
('explanativ','1|förklara'),
('explicera','1|förklara'),
('explicerande','1|explicera'),
('explicerbar','1|explicera'),
('explicerbarhet','1|explicerbar'),
('explicering','1|explicera'),
('explicit','1|tydlig'),
('explicithet','1|explicit'),
('explikation','1|explicera'),
('exploatera','1|utnyttja'),
('exploaterande','1|exploatera'),
('exploaterbar','1|exploatera'),
('exploaterbarhet','1|exploaterbar'),
('exploatering','1|exploatera'),
('exploateringsyta','1|yta'),
('exploatör','1|exploatera'),
('explodera','1|sönder'),
('exploderande','1|explodera'),
('exploderbar','1|explodera'),
('exploderbarhet','1|exploderbar'),
('explodering','1|explodera'),
('Explorer','1|webbläsare'),
('Explorer','2|vodka'),
('explosion','1|explodera'),
('explosion','2|explosionsartad'),
('explosionsartad','1|explosion'),
('explosionsförlopp','1|förlopp'),
('explosionshärd','1|härd'),
('explosionsmotor','1|motor'),
('explosionsområde','1|område'),
('explosionsrisk','1|risk'),
('explosionssätt','1|sätt'),
('explosionsögonblick','1|ögonblick'),
('explosiv','1|explodera'),
('explosiva','1|konsonant'),
('expo','1|utställning'),
('expojkvän','1|pojkvän'),
('exponent','1|representant'),
('exponent','2|matematik'),
('exponentialfunktion','1|funktion'),
('exponentiell','1|exponent'),
('exponentiell','1|exponent'),
('exponentiell','2|ökning'),
('exponentiell','2|ökning'),
('exponera','1|visa'),
('exponera','2|utsätta'),
('exponerande','1|exponera'),
('exponerande','2|exponera'),
('exponerbar','1|exponera'),
('exponerbar','2|exponera'),
('exponerbarhet','1|exponerbar'),
('exponerbarhet','2|exponerbar'),
('exponering','1|exponera'),
('exponeringsmätare','1|mäta'),
('export','1|exportera'),
('exportartikel','1|export'),
('exportberoende','1|beroende'),
('exportberoende','2|beroende'),
('exportbolag','1|bolag'),
('exportera','1|forsla'),
('exporterande','1|exportera'),
('exporterbar','1|exportera'),
('exporterbarhet','1|exporterbar'),
('exportering','1|exportera'),
('exportfrämjande','1|främja'),
('exportförbud','1|förbud'),
('exporthandel','1|handel'),
('exportindustri','1|industri'),
('exportinkomst','1|inkomst'),
('exportmarknad','1|marknad'),
('exportsprit','1|alkohol'),
('exportöl','1|starköl'),
('exportör','1|exportera'),
('exposé','1|framställning'),
('exposition','1|utställning'),
('exposition','2|parti'),
('exposition','3|exponering'),
('expresident','1|president'),
('express','1|snabb'),
('express','2|tåg'),
('expressbefordran','1|befordra'),
('expressbrev','1|brev'),
('expressbud','1|bud'),
('expressbyrå','1|byrå'),
('Expressen','1|tidning'),
('expressförsändelse','1|försändelse'),
('expressionism','1|konstriktning'),
('expressionist','1|expressionism'),
('expressionistisk','1|expressionism'),
('expressiv','1|uttrycksfull'),
('expressivitet','1|expressiv'),
('expresståg','1|tåg'),
('expropriation','1|expropriera'),
('expropriationslag','1|lag'),
('expropriera','1|inlösa'),
('exproprierande','1|expropriera'),
('exproprierbar','1|expropriera'),
('exproprierbarhet','1|exproprierbar'),
('expropriering','1|expropriera'),
('exregent','1|regent'),
('exsickat','1|växt'),
('exsickator','1|exsickat'),
('exspektans','1|avvakta'),
('exspiration','1|utandning'),
('exspiratorisk','1|exspiration'),
('exstirpera','1|utrota'),
('exstirperande','1|exstirpera'),
('exstirperbar','1|exstirpera'),
('exstirperbarhet','1|exstirperbar'),
('exstirpering','1|exstirpera'),
('exsudat','1|blod'),
('extas','1|hänryckning'),
('extatisk','1|extas'),
('extempore','1|oförberedd'),
('extempore','1|oförberedd'),
('extemporera','1|extempore'),
('extemporerande','1|extemporera'),
('extemporerbar','1|extemporera'),
('extemporerbarhet','1|extemporerbar'),
('extemporering','1|extemporera'),
('extension','1|tänja_ut'),
('extension','2|betydelse'),
('extensiv','1|omfattande'),
('extensiv','2|intensiv'),
('exteriör','1|yttre'),
('exteriör','2|exteriör'),
('exteriörbedömning','1|bedömning'),
('extern','1|utanför'),
('extern','2|utanför'),
('externat','1|skola'),
('exterritorialrätt','1|rätt'),
('exterritoriell','1|utomlands'),
('exterritoriell','1|utomlands'),
('extra','1|mycken'),
('extra','2|extra'),
('extraarbete','1|arbete'),
('extrafilt','1|filt'),
('extrafin','1|fin'),
('extrafin','2|fin'),
('extrafin','3|fin'),
('extrahera','1|dra_ut'),
('extraherande','1|extrahera'),
('extraherbar','1|extrahera'),
('extraherbarhet','1|extraherbar'),
('extrahering','1|extrahera'),
('extrahud','1|hud'),
('extrainkallad','1|inkalla'),
('extrainkomst','1|inkomst'),
('extrajobb','1|jobb'),
('extrajudiciell','1|rätt'),
('extraknäck','1|extraknäcka'),
('extraknäcka','1|förtjäna'),
('extraknäckande','1|extraknäcka'),
('extrakongress','1|partikongress'),
('extrakontant','1|kontant'),
('extrakt','1|koncentrat'),
('extraktion','1|härkomst'),
('extraktion','2|frigöra'),
('extraktion','3|dra_ut'),
('extraktivämne','1|ämne'),
('extraktor','1|dra_ut'),
('extraktor','2|centrifug'),
('extralampa','1|glödlampa'),
('extraljus','1|billjus'),
('extralärare','1|lärare'),
('extramural','1|institution'),
('extranummer','1|nummer'),
('extranummer','2|extraupplaga'),
('extraordinarie','1|anställd'),
('extraordinarie','2|extraordinarie'),
('extraordinär','1|ovanlig'),
('extrapersonal','1|personal'),
('extrapolation','1|extrapolera'),
('extrapolera','1|approximera'),
('extrapolerande','1|extrapolera'),
('extrapolerbar','1|extrapolera'),
('extrapolerbarhet','1|extrapolerbar'),
('extrapolering','1|extrapolera'),
('extrapris','1|billig'),
('extraranson','1|ranson'),
('extrasol','1|sol'),
('extrastämma','1|stämma'),
('extraterritoriell','1|territorium'),
('extratur','1|tur'),
('extratåg','1|tåg'),
('extraupplaga','1|upplaga'),
('extrauterin','1|utomkvedshavandeskap'),
('extravagans','1|extravagant'),
('extravagant','1|lyxig'),
('extrem','1|mycken'),
('extrem','1|mycken'),
('extrem','1|mycken'),
('extrem','1|mycken'),
('extrem','1|mycken'),
('extrem','1|mycken'),
('extrem','1|mycken'),
('extrem','1|mycken'),
('extrem','1|mycken'),
('extrem','2|extrem'),
('extremfall','1|fall'),
('extremhöger','1|högerextremism'),
('extremism','1|åsikt'),
('extremist','1|extremism'),
('extremistisk','1|extremism'),
('extremitet','1|lem'),
('extremkyla','1|kyla'),
('extremnationalist','1|nationalist'),
('extremskidåkare','1|extremskidåkning'),
('extremskidåkning','1|skidåkning'),
('extremväder','1|väder'),
('extremvänster','1|vänsterextremism'),
('extremvärde','1|värde'),
('extrinsisk','1|intrinsisk'),
('extrovert','1|öppen'),
('extroverthet','1|extrovert'),
('eye-liner','1|smink'),
('eye-liner','1|smink'),
('Eyjafjallajökull','1|vulkan'),
('f','1|bokstav'),
('F','1|initial'),
('f','2|ton'),
('fabel','1|saga'),
('fabelaktig','1|osannolik'),
('fabelaktighet','1|fabelaktig'),
('fabeldiktare','1|diktare'),
('fabeldjur','1|fantasidjur'),
('fabelhjälte','1|hjälte'),
('fabla','1|fantisera'),
('fablande','1|fabla'),
('fabricera','1|tillverka'),
('fabricera','2|ljuga'),
('fabricerande','1|fabricera'),
('fabricerande','2|fabricera'),
('fabricerbar','1|fabricera'),
('fabricerbar','2|fabricera'),
('fabricerbarhet','1|fabricerbar'),
('fabricerbarhet','2|fabricerbar'),
('fabricering','1|fabricera'),
('fabrik','1|tillverka'),
('fabrikant','1|fabrik'),
('fabrikat','1|tillverkning'),
('fabrikation','1|tillverkning'),
('fabriksanläggning','1|fabrik'),
('fabriksarbetande','1|arbeta'),
('fabriksarbetare','1|arbetare'),
('fabriksbyggnad','1|byggnad'),
('fabrikskomplex','1|komplex'),
('fabrikskvarter','1|kvarter'),
('fabrikslänga','1|länga'),
('fabriksmässig','1|industriell'),
('fabriksmässighet','1|fabriksmässig'),
('fabriksny','1|ny'),
('fabriksområde','1|område'),
('fabrikspipa','1|siren'),
('fabriksport','1|port'),
('fabrikspris','1|grossistpris'),
('fabriksskorsten','1|skorsten'),
('fabrikstomt','1|tomt'),
('fabrikör','1|fabrik'),
('fabulera','1|berätta'),
('fabulerande','1|fabulera'),
('fabulerbar','1|fabulera'),
('fabulerbarhet','1|fabulerbar'),
('fabulering','1|fabulera'),
('fabulös','1|otrolig'),
('facebook','1|mötesplats'),
('facebook','1|mötesplats'),
('facebooka','1|facebook'),
('facebookande','1|facebooka'),
('facebookbild','1|bild'),
('facebookbild','1|bild'),
('facebookgrupp','1|grupp'),
('facebookgrupp','1|grupp'),
('facebooksida','1|webbsida'),
('facil','1|rimlig'),
('facilitet','1|underlätta'),
('facit','1|resultat'),
('Facit','1|skrivmaskinstillverkare'),
('fack','1|förvara'),
('fack','2|fackförening'),
('fack','3|yrke'),
('fackelblomster','1|blomma'),
('fackelbärare','1|bärare'),
('fackelbärare','2|person'),
('fackelsken','1|sken'),
('fackeltåg','1|tåg'),
('fackförbund','1|fackförening'),
('fackförening','1|förening'),
('fackföreningsfientlig','1|fientlig'),
('fackföreningsrörelse','1|rörelse'),
('fackhögskola','1|högskola'),
('fackidiot','1|fackman'),
('fackklubb','1|fackförening'),
('fackkunnig','1|fackman'),
('fackkunnighet','1|fackkunnig'),
('fackkunskap','1|kunskap'),
('fackla','1|brinna'),
('facklig','1|fackförening'),
('facklighet','1|facklig'),
('facklig-politisk','1|politik'),
('facklig-politisk','1|politik'),
('facklig-politisk','1|politik'),
('facklig-politisk','1|politik'),
('facklitteratur','1|litteratur'),
('facklärare','1|yrkeslärare'),
('fackman','1|expert'),
('fackmannamässig','1|fackman'),
('fackminister','1|minister'),
('fackmässig','1|fack'),
('fackmässighet','1|fackmässig'),
('fackordbok','1|ordbok'),
('fackorgan','1|organ'),
('fackorgan','2|organ'),
('fackpress','1|press'),
('fackprosa','1|prosa'),
('fackskola','1|yrkesskola'),
('fackspråk','1|språk'),
('fackstudium','1|studier'),
('fackterm','1|term'),
('facktidskrift','1|tidskrift'),
('fackutskottsprincip','1|princip'),
('fackverk','1|konstruktion'),
('fackverksbom','1|spärrbom'),
('fackverksmast','1|mast'),
('factoring','1|bolag'),
('fadd','1|smak'),
('fadder','1|dopvittne'),
('fadderbarn','1|barn'),
('faddergala','1|gala'),
('faddergåva','1|gåva'),
('fadderskap','1|fadder'),
('faddhet','1|fadd'),
('fader','1|präst'),
('faderlig','1|far'),
('faderlig','2|beskydda'),
('faderlighet','1|faderlig'),
('faderlighet','2|faderlig'),
('faderlös','1|far'),
('fadermord','1|mord'),
('fadermördare','1|krage'),
('fadersarv','1|arv'),
('fadersarv','1|arv'),
('fadersfigur','1|ersättare'),
('fadersgestalt','1|gestalt'),
('fadershjärta','1|hjärta'),
('fadershus','1|föräldrahem'),
('faderskap','1|far'),
('faderskomplex','1|komplex'),
('faderskärlek','1|kärlek'),
('fadersnamn','1|namn'),
('fadersuppror','1|uppror'),
('fadersvälde','1|makt'),
('fadervår','1|bön'),
('fadervår','1|bön'),
('fading','1|radiovåg'),
('fading','2|bromsfading'),
('fadäs','1|misstag'),
('faffa','1|farfar'),
('fager','1|skön'),
('fagott','1|träblåsinstrument'),
('fagottist','1|fagott'),
('fajans','1|keramik'),
('fajansfabrik','1|fabrik'),
('fajansfat','1|fat'),
('fajanskärl','1|kärl'),
('fajansskål','1|skål'),
('fajt','1|kamp'),
('fajt','1|kamp'),
('fajtas','1|fajt'),
('fajtas','1|fajt'),
('fakir','1|självplågare'),
('faksimil','1|tryck'),
('faksimil','1|tryck'),
('faksimilera','1|faksimil'),
('faksimiltryck','1|faksimil'),
('faksimiltryck','1|faksimil'),
('faktabaserad','1|basera'),
('faktafel','1|fel'),
('faktafolder','1|folder'),
('faktagranskning','1|granskning'),
('faktagroda','1|groda'),
('faktakoll','1|koll'),
('faktamässig','1|faktum'),
('faktaspäckad','1|fullspäckad'),
('fakticitet','1|faktisk'),
('faktisk','1|vara'),
('faktiskhet','1|faktisk'),
('faktoid','1|myt'),
('faktor','1|inverka'),
('faktor','2|multiplikation'),
('faktor','3|arbetsledare'),
('faktoranalys','1|matematik'),
('faktori','1|vapenfabrik'),
('faktori','2|filial'),
('faktotum','1|allt_i_allo'),
('faktum','1|faktisk'),
('faktum','1|faktisk'),
('faktur','1|yteffekt'),
('faktur','2|komponera'),
('faktura','1|räkning'),
('fakturera','1|faktura'),
('fakturerande','1|fakturera'),
('fakturerbar','1|fakturera'),
('fakturerbarhet','1|fakturerbar'),
('fakturering','1|fakturera'),
('fakultativ','1|frivillig'),
('fakultet','1|universitet'),
('fakultet','2|matematik'),
('fakultetsgräns','1|gräns'),
('fakultetsopponent','1|opponent'),
('fakultetssammanträde','1|sammanträde'),
('fal','1|ohederlig'),
('falafel','1|maträtt'),
('falafelbulle','1|falafel'),
('falang','1|åsikt'),
('falang','2|ben'),
('falangist','1|falang'),
('falangstrid','1|strid'),
('falerner','1|vin'),
('falhet','1|fal'),
('falk','1|rovfågel'),
('falka','1|sträva'),
('falkande','1|falka'),
('falkblick','1|blick'),
('Falkenberg','1|stad'),
('falkenerare','1|falkjakt'),
('falkjakt','1|jakt'),
('Falklandsöarna','1|ögrupp'),
('falkonett','1|kanon'),
('falköga','1|öga'),
('Falköping','1|stad'),
('fall','1|falla'),
('fall','2|förekomma'),
('fall','3|nederlag'),
('fall','4|takfall'),
('falla','1|ner'),
('fallande','1|falla'),
('fallandesjuka','1|epilepsi'),
('fallandesot','1|epilepsi'),
('fallbeskrivning','1|beskrivning'),
('fallbila','1|giljotin'),
('fallen','1|fallenhet'),
('fallen','2|avla'),
('fallenhet','1|talang'),
('fallera','1|fungera'),
('fallera','2|tralla'),
('fallerande','1|fallera'),
('fallering','1|fallera'),
('fallfara','1|fara'),
('fallfrukt','1|frukt'),
('fallfärdig','1|sönderfalla'),
('fallfärdighet','1|fallfärdig'),
('fallgrop','1|fälla'),
('fallhammare','1|hammare'),
('fallhöjd','1|höjd'),
('fallissemang','1|bankrutt'),
('fallmålstavla','1|måltavla'),
('fallolycka','1|olycka'),
('fallos','1|penis'),
('fallout','1|nedfall'),
('fallrep','1|trappa'),
('fallrepstrappa','1|fallrep'),
('fallseger','1|seger'),
('fallskada','1|skada'),
('fallskärm','1|falla'),
('fallskärm','2|avgångsvederlag'),
('fallskärmsförbund','1|förbund'),
('fallskärmshopp','1|hoppa_fallskärm'),
('fallskärmshoppande','1|hoppa_fallskärm'),
('fallskärmshoppare','1|hoppa_fallskärm'),
('fallskärmshoppning','1|hoppa_fallskärm'),
('fallskärmsjägare','1|jägare'),
('fallskärmsklubb','1|klubb'),
('fallskärmsliknande','1|fallskärm'),
('fallskärmsolycka','1|olycka'),
('fallskärmstrick','1|trick'),
('fallskärmstrupp','1|trupp'),
('fallstudie','1|studie'),
('falltavla','1|fallmålstavla'),
('fallucka','1|fälla'),
('fallverk','1|hejare'),
('fallvind','1|vind'),
('falna','1|slockna'),
('falnande','1|falna'),
('fals','1|kant'),
('fals','2|spont'),
('fals','3|veck'),
('falsa','1|fals'),
('falsa','2|fals'),
('falsa','3|fals'),
('falsande','1|falsa'),
('falsande','2|falsa'),
('falsande','3|falsa'),
('falsarium','1|bedrägeri'),
('falsett','1|röst'),
('falsettilsken','1|ilsken'),
('falsettröst','1|falsett'),
('falsettsång','1|sång'),
('falsifiera','1|vederlägga'),
('falsifierande','1|falsifiera'),
('falsifierbar','1|falsifiera'),
('falsifierbarhet','1|falsifierbar'),
('falsifiering','1|falsifiera'),
('falsifikat','1|förfalskning'),
('falsk','1|fel'),
('falsk','1|fel'),
('falsk','2|disharmonisk'),
('falskeligen','1|falsk'),
('falskhet','1|falsk'),
('falskhet','2|falsk'),
('falskmynta','1|falskmyntare'),
('falskmyntande','1|falskmynta'),
('falskmyntare','1|pengar'),
('falskmyntning','1|falskmynta'),
('falskskylta','1|registreringsskylt'),
('falskskyltande','1|falskskylta'),
('falskskyltning','1|falskskylta'),
('falskspel','1|spel'),
('falskspelare','1|falskspel'),
('Falstaff','1|opera'),
('Falsterbo','1|stad'),
('falubo','1|Falun'),
('falubo','1|Falun'),
('falukorv','1|korv'),
('Falun','1|stad'),
('faluröd','1|färg'),
('familj','1|släkt'),
('familj','2|art'),
('familjaritet','1|familjär'),
('familjeangelägenhet','1|angelägenhet'),
('familjearkiv','1|arkiv'),
('familjeband','1|band'),
('familjebidrag','1|bidrag'),
('familjebild','1|bild'),
('familjebiljett','1|biljett'),
('familjebolag','1|bolag'),
('familjedaghem','1|daghem'),
('familjedrag','1|drag'),
('familjedrama','1|drama'),
('familjefar','1|far'),
('familjefejd','1|fejd'),
('familjeflicka','1|flicka'),
('familjefoto','1|foto'),
('familjeföretag','1|företag'),
('familjeförsörjare','1|försörja'),
('familjegods','1|gods'),
('familjegrav','1|grav'),
('familjehem','1|fosterhem'),
('familjehemlighet','1|hemlighet'),
('familjehotell','1|servicehus'),
('familjeideal','1|ideal'),
('familjejordbruk','1|jordbruk'),
('familjekrets','1|familj'),
('familjekänsla','1|känsla'),
('familjeliv','1|liv'),
('familjemedlem','1|familj'),
('familjemiddag','1|middag'),
('familjemys','1|mys'),
('familjemässig','1|familj'),
('familjenamn','1|släktnamn'),
('familjepenning','1|familjebidrag'),
('familjepension','1|änkepension'),
('familjeplanering','1|barnbegränsning'),
('familjeplaneringsregel','1|regel'),
('familjepolitik','1|politik'),
('familjepolitisk','1|familjepolitik'),
('familjeprogram','1|program'),
('familjerabatt','1|rabatt'),
('familjerådgivning','1|rådgivning'),
('familjerätt','1|rätt'),
('familjerättslig','1|familjerätt'),
('familjestiftelse','1|stiftelse'),
('familjeterapi','1|terapi'),
('familjetillhörighet','1|tillhörighet'),
('familjetradition','1|tradition'),
('familjeunderhållning','1|familjeprogram'),
('familjevåld','1|misshandel'),
('familjevård','1|vård'),
('familjeöverhuvud','1|överhuvud'),
('familjär','1|otvungen'),
('famla','1|söka'),
('famlande','1|famla'),
('famlande','2|famla'),
('fammo','1|farmor'),
('famn','1|omfamna'),
('famn','2|mått'),
('famn','3|livmoder'),
('famn','4|underliv'),
('famna','1|famn'),
('famnande','1|famna'),
('famntag','1|famn'),
('famös','1|ökänd'),
('fan','1|djävul'),
('fan','2|beundrare'),
('fan','3|fågelfjäder'),
('fan','4|fan'),
('fan','4|fan'),
('fana','1|flagga'),
('fanatiker','1|fanatisk'),
('fanatisk','1|tro'),
('fanatism','1|fanatisk'),
('fanborg','1|fana'),
('fanbärare','1|bärare'),
('fanbärare','2|person'),
('fandango','1|flamenco'),
('faned','1|ed'),
('faner','1|träskiva'),
('fanera','1|faner'),
('fanerogam','1|växt'),
('fanerogam','2|fanerogam'),
('fanerozoikum','1|period'),
('fanfar','1|hyllning'),
('fanflykt','1|desertera'),
('fanjunkare','1|underofficer'),
('fanken','1|fan'),
('fanskap','1|otrevlig'),
('fanstyg','1|fanskap'),
('fantasi','1|overklig'),
('fantasialster','1|fantasi'),
('fantasibild','1|fantasi'),
('fantasidjur','1|djur'),
('fantasieggande','1|egga'),
('fantasifigur','1|figur'),
('fantasifoster','1|fantasi'),
('fantasifull','1|fantasi'),
('fantasifullhet','1|fantasifull'),
('fantasigestalt','1|gestalt'),
('fantasikraft','1|fantasi'),
('fantasiliv','1|fantasi'),
('fantasilös','1|fantasi'),
('fantasilöshet','1|fantasilös'),
('fantasiprodukt','1|fantasi'),
('fantasirik','1|fantasi'),
('fantasirikedom','1|fantasirik'),
('fantasirikhet','1|fantasirik'),
('fantasiskapelse','1|fantasi'),
('fantasispel','1|fantasi'),
('fantasivarelse','1|varelse'),
('fantasivärld','1|värld'),
('fantast','1|extrem'),
('fantasteri','1|fantast'),
('fantastik','1|fantasteri'),
('fantastisk','1|bra'),
('fantisera','1|fantasi'),
('fantiserande','1|fantisera'),
('fantiserbar','1|fantisera'),
('fantiserbarhet','1|fantiserbar'),
('fantisering','1|fantisera'),
('fantom','1|vålnad'),
('fantom','2|enastående'),
('fantombild','1|teckning'),
('Fantomen','1|seriefigur'),
('Fantomen','1|seriefigur'),
('Fantomen','2|serie'),
('Fantomen','2|serie'),
('fantomlik','1|fantom'),
('fantomsmärta','1|smärta'),
('fantomsnygg','1|ursnygg'),
('fantomsnygghet','1|fantomsnygg'),
('fanvakt','1|vakt'),
('far','1|man'),
('fara','1|resa'),
('fara','2|farlig'),
('fara','3|må'),
('fara','4|söka'),
('farad','1|mått'),
('farande','1|fara'),
('farande','2|fara'),
('farao','1|kung'),
('faraokatt','1|mangust'),
('faraonisk','1|farao'),
('farbar','1|fara'),
('farbarhet','1|farbar'),
('farbroderlig','1|faderlig'),
('farbroderlighet','1|farbroderlig'),
('farbror','1|släkting'),
('farbror','2|man'),
('fardag','1|dag'),
('farfar','1|släkting'),
('farfarsfar','1|släkting'),
('farförälder','1|släkting'),
('fargalt','1|galt'),
('Fargo','1|stad'),
('farhåga','1|befara'),
('farin','1|råsocker'),
('farinsocker','1|farin'),
('farisé','1|hycklare'),
('fariseisk','1|farisé'),
('fariseism','1|farisé'),
('fariséism','1|farisé'),
('farkost','1|fara'),
('farled','1|vattenväg'),
('farledsfyr','1|fyr'),
('farlig','1|säker'),
('farlighet','1|farlig'),
('farlighetsstämpel','1|stämpel'),
('farm','1|lantgård'),
('farmaceut','1|apotekare'),
('farmaceut','1|apotekare'),
('farmaceutisk','1|medicin'),
('farmaceutisk','1|medicin'),
('farmaci','1|vetenskap'),
('farmacie','1|farmaceut'),
('farmaka','1|medicin'),
('farmakognosi','1|vetenskap'),
('farmakolog','1|farmakologi'),
('farmakologi','1|farmakologisk'),
('farmakologisk','1|medicin'),
('farmakopé','1|förteckning'),
('farmardomkraft','1|domkraft'),
('farmare','1|farm'),
('farmor','1|släkting'),
('farofylld','1|fara'),
('farofylldhet','1|farofylld'),
('farozon','1|fara'),
('fars','1|pjäs'),
('farsa','1|far'),
('farsartad','1|fars'),
('farsgubben','1|far'),
('farsi','1|persiska'),
('farsot','1|sjukdom'),
('farsotsår','1|år'),
('Farsta','1|ort'),
('farstu','1|rum'),
('farstutrappa','1|trappa'),
('fart','1|fort'),
('fartblind','1|underskatta'),
('fartblindhet','1|fartblind'),
('fartdåre','1|fart'),
('fartfena','1|fena'),
('fartfylld','1|fart'),
('fartfylldhet','1|fartfylld'),
('farthinder','1|hinder'),
('farthållare','1|hålla'),
('farthållare','2|hålla'),
('fartkamera','1|kamera'),
('fartminskning','1|minskning'),
('fartrand','1|dekoration'),
('fartreglage','1|reglera'),
('fartspärr','1|spärr'),
('fartupplevelse','1|upplevelse'),
('fartvind','1|vind'),
('fartyg','1|båt'),
('fartygsanpassad','1|anpassa'),
('fartygsbesättning','1|besättning'),
('fartygsbotten','1|botten'),
('fartygsbyggartradition','1|tradition'),
('fartygsdäck','1|däck'),
('fartygsflagg','1|flagga'),
('fartygsincident','1|incident'),
('fartygskapten','1|kapten'),
('fartygskatastrof','1|katastrof'),
('fartygskollision','1|kollision'),
('fartygskonvoj','1|konvoj'),
('fartygskurs','1|kurs'),
('fartygslast','1|last'),
('fartygslucka','1|lucka'),
('fartygsorkester','1|orkester'),
('fartygsproviant','1|proviant'),
('fartygssida','1|sida'),
('fartygsskrov','1|skrov'),
('fartygsstormning','1|stormning'),
('fartygstjänstgöring','1|tjänstgöring'),
('fartygstrafik','1|trafik'),
('fartygstyp','1|typ'),
('fartygsvrak','1|vrak'),
('farvatten','1|färdas'),
('farväl','1|lämna'),
('farväl','2|farväl'),
('faryngal','1|svalg'),
('fas','1|stadium'),
('fas','2|läge'),
('fas','3|tillstånd'),
('fas','4|kant'),
('fasa','1|skräck'),
('fasa','2|fas'),
('fasa','3|fasa'),
('fasad','1|vägg'),
('fasadpanel','1|panel'),
('fasadpensel','1|pensel'),
('fasadplatta','1|platta'),
('fasadtegel','1|tegel'),
('fasan','1|fågel'),
('fasande','1|fasa'),
('fasande','2|fasa'),
('fasansfull','1|fasa'),
('fasansfullhet','1|fasansfull'),
('fasaväckande','1|fasa'),
('fascination','1|fascinera'),
('fascinera','1|fängsla'),
('fascinerad','1|fascinera'),
('fascinerande','1|fascinera'),
('fascinerbar','1|fascinera'),
('fascinerbarhet','1|fascinerbar'),
('fascinering','1|fascinera'),
('fascism','1|politik'),
('fascist','1|fascism'),
('fascistfasoner','1|fascist'),
('fascistisk','1|fascism'),
('fascistoid','1|fascism'),
('fasen','1|fan'),
('fasett','1|ädelsten'),
('fasett','1|ädelsten'),
('fasettera','1|fasett'),
('fasettera','1|fasett'),
('fasetterad','1|mångsidig'),
('fasetterad','1|mångsidig'),
('fasetterande','1|fasettera'),
('fasetterande','1|fasettera'),
('fasetterbar','1|fasettera'),
('fasetterbar','1|fasettera'),
('fasetterbarhet','1|fasetterbar'),
('fasetterbarhet','1|fasetterbar'),
('fasettering','1|fasettera'),
('fasettering','1|fasettera'),
('fasettöga','1|öga'),
('fasettöga','1|öga'),
('fasförskjutning','1|växelström'),
('fashionabel','1|lyxig'),
('fasingen','1|fasen'),
('faskikel','1|häfte'),
('faskin','1|kvist'),
('faskinkniv','1|kniv'),
('faslig','1|hemsk'),
('faslighet','1|faslig'),
('fason','1|utformning'),
('fason','2|uppförande'),
('fasonera','1|fason'),
('fasonerande','1|fasonera'),
('fasonerbar','1|fasonera'),
('fasonerbarhet','1|fasonerbar'),
('fasonering','1|fasonera'),
('fasonlig','1|fason'),
('fasonlig','2|fason'),
('fasspänning','1|växelström'),
('fast','1|röra'),
('fast','2|fånga'),
('fast','3|men'),
('fasta','1|avhålla_sig'),
('fasta','2|fasta'),
('fastage','1|tunna'),
('fastan','1|fasta'),
('fastan','1|fasta'),
('fastande','1|fasta'),
('fastanställd','1|anställd'),
('fastbindning','1|binda_fast'),
('fastboende','1|bo'),
('fastebrev','1|lagfart'),
('fastedag','1|dag'),
('fastemånad','1|månad'),
('faster','1|släkting'),
('fastetiden','1|fasta'),
('fastfrusen','1|fast'),
('fastfrysning','1|frysa_fast'),
('fastgjord','1|fastgöra'),
('fastgöra','1|fästa'),
('fastgöra','1|fästa'),
('fastgörande','1|fastgöra'),
('fasthakning','1|haka'),
('fasthet','1|fast'),
('fasthålla','1|fast'),
('fasthållande','1|fasthålla'),
('fasthållning','1|fasthålla'),
('fasthängande','1|hänga_fast'),
('fastighet','1|hus'),
('fastighetsaffär','1|affär'),
('fastighetsbolag','1|bolag'),
('fastighetsbranschen','1|bransch'),
('fastighetsbubbla','1|blåsa_upp'),
('fastighetsbyrå','1|fastighetsmäklare'),
('fastighetsförsäljning','1|försäljning'),
('fastighetsindex','1|index'),
('fastighetskontor','1|kontor'),
('fastighetskris','1|kris'),
('fastighetsköp','1|köp'),
('fastighetslån','1|lån'),
('fastighetsmogul','1|mogul'),
('fastighetsmäklare','1|mäklare'),
('fastighetsnämnd','1|nämnd'),
('fastighetspris','1|pris'),
('fastighetsskatt','1|skatt'),
('fastighetsskötare','1|sköta'),
('fastighetsspekulation','1|spekulation'),
('fastighetstaxera','1|fastighetstaxering'),
('fastighetstaxerande','1|fastighetstaxera'),
('fastighetstaxerbar','1|fastighetstaxera'),
('fastighetstaxerbarhet','1|fastighetstaxerbar'),
('fastighetstaxering','1|taxering'),
('fastighetsägare','1|ägare'),
('fastkedja','1|kedja'),
('fastkedjande','1|kedja_fast'),
('fastklistra','1|klistra'),
('fastklistrande','1|fastklistra'),
('fastklämning','1|fästa'),
('fastkoppling','1|koppla'),
('fastlagen','1|påsk'),
('fastlagsbulle','1|semla'),
('fastlagsbulle','1|semla'),
('fastlagsris','1|påskris'),
('fastlagssöndag','1|kyrkoår'),
('fastlagsvecka','1|vecka'),
('fastland','1|land'),
('fastlandsbo','1|fastland'),
('fastlandsklimat','1|klimat'),
('fastlimning','1|limma_fast'),
('fastlåst','1|orubblig'),
('fastlägga','1|bestämma'),
('fastläggande','1|fastlägga'),
('fastlänning','1|fastland'),
('fastlödning','1|fästa'),
('fastmer','1|i_stället'),
('fastmer','1|i_stället'),
('fastna','1|fast'),
('fastnaglad','1|nagla'),
('fastnagling','1|nagla'),
('fastnande','1|fastna'),
('fastnitning','1|nita'),
('fastskruvad','1|skruva'),
('fastskruvning','1|skruva_fast'),
('fastslagning','1|fastslå'),
('fastslå','1|fast'),
('fastslå','1|fast'),
('fastslående','1|fastslå'),
('fastspikad','1|spika_fast'),
('fastspikning','1|spika_fast'),
('fastspänning','1|spänna_fast'),
('fastställa','1|fast'),
('fastställande','1|fastställa'),
('fastställd','1|fastställa'),
('fastställelse','1|fastställa'),
('fastsurrad','1|surra'),
('fastsurrning','1|surra'),
('fastsättande','1|sätta_fast'),
('fastsättning','1|sätta_fast'),
('fastta','1|fånga'),
('fasttagande','1|ta_fast'),
('fasttagning','1|fastta'),
('fasttagning','2|ta_fast'),
('fasttejpad','1|tejpa'),
('fasttråckling','1|fästa'),
('fastväxning','1|växa_fast'),
('fastän','1|men'),
('fat','1|platt'),
('fat','2|tunna'),
('fatabur','1|förråd'),
('fatabur','1|förråd'),
('fatal','1|olycka'),
('fataliedag','1|fatalier'),
('fatalier','1|fatalietid'),
('fatalietid','1|tidsfrist'),
('fatalism','1|ödesbestämd'),
('fatalist','1|fatalism'),
('fatalistisk','1|fatalism'),
('fatalitet','1|fatal'),
('fatt','1|må'),
('fatta','1|ta'),
('fatta','2|förstå'),
('fatta','3|plötslig'),
('fattad','1|samlad'),
('fattande','1|fatta'),
('fattande','2|fatta'),
('fattande','3|fatta'),
('fattas','1|saknas'),
('fattbar','1|fatta'),
('fattbarhet','1|fattbar'),
('fattig','1|rik'),
('fattig','2|utan'),
('fattigbarn','1|barn'),
('fattigdom','1|fattig'),
('fattigdom','2|fattig'),
('fattigdomsbevis','1|bevis'),
('fattigdomsfälla','1|fälla'),
('fattigdomslöfte','1|löfte'),
('fattigdomsminskning','1|minskning'),
('fattigdomsstreck','1|nivå'),
('fattighjon','1|fattighjälp'),
('fattighjälp','1|hjälp'),
('fattighus','1|fattigvård'),
('fattigkvarter','1|kvarter'),
('fattiglapp','1|fattig'),
('fattigstuga','1|anstalt'),
('Fattig-Sverige','1|Sverige'),
('fattigunderstöd','1|fattighjälp'),
('fattigvård','1|fattighjälp'),
('fattlig','1|fattbar'),
('fattlighet','1|fattlig'),
('fattning','1|behärska_sig'),
('fattning','2|fatta'),
('fattning','3|version'),
('fattning','4|infattning'),
('fattningsförmåga','1|förmåga'),
('fattningsgåva','1|förstånd'),
('fatwa','1|dom'),
('fatöl','1|öl'),
('faun','1|skogsgud'),
('fauna','1|djur'),
('faunist','1|fauna'),
('faunistik','1|fauna'),
('faunistisk','1|fauna'),
('Faust','1|drama'),
('faute','1|misstag'),
('faute','1|misstag'),
('favorisera','1|gynna'),
('favoriserande','1|favorisera'),
('favoriserbar','1|favorisera'),
('favoriserbarhet','1|favoriserbar'),
('favorisering','1|favorisera'),
('favorit','1|omtyckt'),
('favoritaccessoar','1|accessoarer'),
('favoritbild','1|bild'),
('favoritfik','1|fik'),
('favoritförfattare','1|författare'),
('favorithak','1|hak'),
('favoritknep','1|knep'),
('favoritmelodi','1|melodi'),
('favoritnöje','1|nöje'),
('favoritplats','1|plats'),
('favoritpsalm','1|psalm'),
('favoritrestaurang','1|restaurang'),
('favoriträtt','1|maträtt'),
('favoritskådespelerska','1|skådespelerska'),
('favoritstrand','1|badstrand'),
('favoritsystem','1|system'),
('favorittippad','1|tippa'),
('favvo','1|favorit'),
('favvo','1|favorit'),
('favör','1|fördel'),
('fax','1|kommunikation'),
('fax','2|faxa'),
('faxa','1|fax'),
('faxande','1|faxa'),
('FBI','1|underrättelsetjänst'),
('fe','1|väsen'),
('featureprogram','1|dokumentärprogram'),
('feber','1|sjuk'),
('feber','2|upphetsad'),
('feberaktig','1|febril'),
('feberaktighet','1|feberaktig'),
('feberanfall','1|anfall'),
('feberdröm','1|dröm'),
('feberdämpande','1|febernedsättande'),
('feberepidemi','1|epidemi'),
('feberfantasi','1|fantasi'),
('feberfri','1|feber'),
('feberhet','1|febrig'),
('feberhetta','1|hetta'),
('feberkurva','1|kurva'),
('febernedsättande','1|feber'),
('febersjuk','1|feber'),
('febersjukdom','1|sjukdom'),
('feberstillande','1|feberdämpande'),
('febertermometer','1|termometer'),
('febertopp','1|topp'),
('feberyra','1|yra'),
('febrig','1|feber'),
('febrighet','1|febrig'),
('febril','1|intensiv'),
('februari','1|månad'),
('februarilov','1|lov'),
('februarioffensiv','1|offensiv'),
('februarisol','1|sol'),
('federal','1|federation'),
('federalism','1|federation'),
('federalist','1|federalism'),
('federalistisk','1|federalism'),
('federation','1|förbund'),
('federativ','1|federalism'),
('federerad','1|ansluta'),
('fedrottning','1|drottning'),
('feedback','1|återkoppling'),
('feel','1|känsla'),
('feeri','1|stämning'),
('feg','1|modig'),
('fega','1|feg'),
('feghet','1|feg'),
('fegis','1|feg'),
('fegspel','1|feghet'),
('feja','1|städa'),
('Fejan','1|facebook'),
('Fejan','2|ö'),
('fejande','1|feja'),
('fejd','1|kamp'),
('fejda','1|fejd'),
('fejda','2|tona_bort'),
('fejka','1|låtsas'),
('fejkande','1|fejka'),
('fejning','1|feja'),
('fekal','1|avföring'),
('fekalier','1|avföring'),
('fel','1|rätt'),
('fel','2|fel'),
('fel','3|skuld'),
('fela','1|fel'),
('fela','2|felas'),
('fela','3|fiol'),
('felaktig','1|fel'),
('felaktighet','1|felaktig'),
('felande','1|fela'),
('felande','2|fela'),
('felas','1|fattas'),
('felbedöma','1|bedöma'),
('felbedömande','1|felbedöma'),
('felbedömning','1|felbedöma'),
('felbehandlad','1|behandla'),
('felbehandling','1|behandling'),
('felberäkning','1|beräkning'),
('felbeskuren','1|beskära'),
('felciterad','1|citera'),
('feldaterad','1|datera'),
('feldatering','1|feldaterad'),
('feldiagnos','1|diagnos'),
('feldosera','1|dosera'),
('feldosera','2|dosera'),
('feldoserande','1|feldosera'),
('feldoserande','2|feldosera'),
('feldosering','1|feldosera'),
('feldosering','2|feldosera'),
('feldrag','1|misstag'),
('felfinnare','1|söka'),
('felfinneri','1|felfinnare'),
('felfri','1|fel'),
('felfrihet','1|felfri'),
('felgrepp','1|misstag'),
('felhandling','1|handling'),
('felinformerad','1|informera'),
('felinvestering','1|investering'),
('felkokt','1|koka'),
('felkonstruerad','1|konstruera'),
('felkälla','1|orsak'),
('felköp','1|köp'),
('felläsning','1|läsa'),
('felmarginal','1|marginal'),
('felnavigera','1|navigera'),
('felnavigerande','1|felnavigera'),
('felnavigering','1|felnavigera'),
('felparkera','1|felparkering'),
('felparkerande','1|felparkera'),
('felparkerbar','1|felparkera'),
('felparkerbarhet','1|felparkerbar'),
('felparkering','1|parkering'),
('felplacerad','1|placera'),
('felprioritera','1|prioritera'),
('felprioriterande','1|felprioritera'),
('felprioritering','1|felprioritera'),
('felprocent','1|procent'),
('felriktad','1|rikta'),
('felräkning','1|räkna'),
('felräkningspengar','1|kassabrist'),
('felsatsning','1|satsning'),
('felskriven','1|felskrivning'),
('felskrivning','1|skriva'),
('felslagen','1|ouppfylld'),
('felslut','1|slutledning'),
('felslående','1|slå_fel'),
('felstavad','1|stava'),
('felsteg','1|handling'),
('felställd','1|ställa_in'),
('felsyn','1|uppfattning'),
('felsägning','1|säga'),
('felsökare','1|söka'),
('feltolka','1|tolka'),
('feltolkande','1|feltolka'),
('feltolkning','1|feltolka'),
('feltryck','1|tryckfel'),
('feltryckt','1|feltryck'),
('feltänk','1|tänk'),
('felunderrättad','1|underrätta'),
('felutveckling','1|utveckling'),
('felval','1|val'),
('fem','1|ental'),
('fem','1|ental'),
('femaktare','1|skådespel'),
('femarmad','1|arm'),
('femarmad','1|arm'),
('fembarnsmamma','1|mamma'),
('femcylindrig','1|cylinder'),
('femdagarsvecka','1|arbetsvecka'),
('femdelning','1|dela'),
('femdubbel','1|gång'),
('femdubbla','1|femdubbel'),
('femdubblande','1|femdubbla'),
('femdubbling','1|femdubbla'),
('femdygnsprognos','1|väderprognos'),
('femetta','1|fullträff'),
('femfaldig','1|gång'),
('femfaldiga','1|femfaldig'),
('femfaldigande','1|femfaldiga'),
('femfemma','1|efterbliven'),
('femfemma','2|segelbåt'),
('femfilmskontrakt','1|kontrakt'),
('femflikig','1|flik'),
('femgradig','1|grad'),
('femhundra','1|tal'),
('femhundrade','1|femhundra'),
('femhundrakronorssedel','1|sedel'),
('femhörnig','1|hörn'),
('femhörning','1|femhörnig'),
('feminin','1|kvinnlig'),
('feminin','2|femininum'),
('femininbildning','1|femininform'),
('femininform','1|femininum'),
('femininum','1|genus'),
('femininändelse','1|ändelse'),
('feminiserad','1|feminin'),
('feminism','1|frigörelse'),
('feminist','1|feminism'),
('feministisk','1|feminism'),
('feministtjafs','1|tjafs'),
('femkamp','1|tävling'),
('femkort','1|kortspel'),
('femkrona','1|femkronorsmynt'),
('femkronorsmynt','1|mynt'),
('femling','1|syskon'),
('femma','1|femkrona'),
('femma','2|siffra'),
('femma','3|betyg'),
('femma','4|femrumslägenhet'),
('femmarkerkorv','1|korv'),
('femmilen','1|skidtävling'),
('femprocentig','1|procent'),
('fempunktslaser','1|laser'),
('fempunktslaser','1|laser'),
('fempunktsplan','1|plan'),
('femrummare','1|femrumslägenhet'),
('femrumslägenhet','1|lägenhet'),
('femsidig','1|sida'),
('femsiffrig','1|siffra'),
('femsitsig','1|sits'),
('femsnåret','1|klockslag'),
('femstjärnig','1|stjärna'),
('femstämmig','1|stämma'),
('femtal','1|fem'),
('femte','1|fem'),
('femtedel','1|bråkdel'),
('femtekolonn','1|femtekolonnare'),
('femtekolonnare','1|landsförrädare'),
('femteplats','1|plats'),
('femtiden','1|klockslag'),
('femtielfte','1|femtielva'),
('femtielfte','1|femtielva'),
('femtielva','1|antal'),
('femtielva','1|antal'),
('femtilapp','1|femtiokronorssedel'),
('femtiliters','1|liter'),
('femtio','1|tal'),
('femtio','1|tal'),
('femtio','1|tal'),
('femtiodollarsedel','1|sedel'),
('femtiodollarsedel','1|sedel'),
('femtiokronorssedel','1|sedel'),
('femtiokronorssedel','1|sedel'),
('femtiometerssträcka','1|sträcka'),
('femtionde','1|femtio'),
('femtiotal','1|femtio'),
('femtiotal','1|femtio'),
('femtiotalet','1|nittonhundrafemtiotalet'),
('femtiotalet','1|nittonhundrafemtiotalet'),
('femtiotalet','1|nittonhundrafemtiotalet'),
('femtiotalsinspirerad','1|inspirera'),
('femtiotalsinspirerad','1|inspirera'),
('femtioårig','1|år'),
('femtioårsdag','1|födelsedag'),
('femtioårsdag','1|födelsedag'),
('femtioårsjubileum','1|jubileum'),
('femtioöring','1|mynt'),
('femtioöring','1|mynt'),
('femtitalist','1|författare'),
('femtitalist','1|författare'),
('femtocell','1|basstation'),
('femton','1|tal'),
('femtonbarnsmamma','1|mamma'),
('femtonde','1|femton'),
('femtondel','1|bråkdel'),
('femtondel','1|bråkdel'),
('femtonhundrameterslopp','1|lopp'),
('femtonhundratalet','1|århundrade'),
('femtonhundratalet','1|århundrade'),
('femtonsnåret','1|klockslag'),
('femtonspel','1|spel'),
('femtontal','1|femton'),
('femtonårig','1|år'),
('femtonåring','1|femtonårig'),
('femtonårsstraff','1|straff'),
('femtonårsstraff','1|straff'),
('femtumsspik','1|spik'),
('femuddig','1|udd'),
('femväxlad','1|växel'),
('femårig','1|år'),
('femåring','1|femårig'),
('femårsperiod','1|period'),
('femårsplan','1|plan'),
('femöring','1|mynt'),
('fena','1|simma'),
('fena','2|expert'),
('fender','1|fartyg'),
('fender','1|fartyg'),
('fenedrin','1|amfetamin'),
('fenicier','1|folk'),
('fenicisk','1|fenicier'),
('Fenix','1|fågel'),
('fenixbål','1|Fenix'),
('fenköl','1|köl'),
('fenmetralin','1|narkotika'),
('fennicism','1|finska'),
('fennoman','1|fennomani'),
('fennomani','1|nationalism'),
('fenol','1|ämne'),
('fenolftalein','1|indikator'),
('fenolisk','1|fenol'),
('fenomen','1|företeelse'),
('fenomen','2|fenomenal'),
('fenomen','3|filosofi'),
('fenomenal','1|enastående'),
('fenomenalism','1|fenomen'),
('fenomenologi','1|fenomen'),
('fenomenologisk','1|fenomenologi'),
('fenomenvärld','1|värld'),
('fenoplast','1|bakelit'),
('fenotyp','1|utvecklingslära'),
('fenoxisyra','1|fenoxisyror'),
('fenoxisyror','1|bekämpningsmedel'),
('fenval','1|bardval'),
('feodal','1|livegen'),
('feodalherre','1|herre'),
('feodalism','1|feodal'),
('feodalistisk','1|feodalism'),
('feodalväsen','1|feodalism'),
('ferie','1|ledig'),
('ferieskola','1|skola'),
('ferietid','1|ferie'),
('ferm','1|snabb'),
('ferm','1|snabb'),
('fermat','1|vilopunkt'),
('ferment','1|enzym'),
('fermentera','1|jäsa'),
('fermenterande','1|fermentera'),
('fermenterbar','1|fermentera'),
('fermenterbarhet','1|fermenterbar'),
('fermentering','1|fermentera'),
('fermhet','1|ferm'),
('fermitet','1|ferm'),
('fermitet','1|ferm'),
('fermium','1|grundämne'),
('fermium','1|grundämne'),
('fernissa','1|lack'),
('fernissa','2|fernissa'),
('fernissande','1|fernissa'),
('feromon','1|doftämne'),
('feromoner','1|doftämne'),
('Ferrari','1|bilmärke'),
('ferrit','1|järn'),
('ferritkärna','1|elektromagnetisk'),
('ferrolegering','1|järnlegering'),
('ferrum','1|järn'),
('fertil','1|fruktsam'),
('fertilitet','1|fertil'),
('fesljummen','1|ljummen'),
('fest','1|glad'),
('festa','1|fest'),
('festande','1|festa'),
('festarrangör','1|arrangör'),
('festbord','1|bord'),
('festdag','1|dag'),
('festdeltagare','1|deltagare'),
('festdräkt','1|festkläder'),
('festfixare','1|fixa'),
('festföremål','1|föremål'),
('festgeneral','1|huvudansvarig'),
('festglädje','1|glädje'),
('festival','1|fest'),
('festivalbiljett','1|biljett'),
('festivaljury','1|prisutdelningsjury'),
('festivalluff','1|luff'),
('festivaltält','1|tält'),
('festivitas','1|feststämning'),
('festivitet','1|fest'),
('festkamrat','1|festkompis'),
('festklädd','1|uppklädd'),
('festkläder','1|kläder'),
('festklänning','1|klänning'),
('festkompis','1|kompis'),
('festkväll','1|kväll'),
('festlig','1|fest'),
('festlig','2|rolig'),
('festlighet','1|fest'),
('festlighet','2|festlig'),
('festlokal','1|lokal'),
('festmiddag','1|middag'),
('festmåltid','1|måltid'),
('festong','1|ornament'),
('festong','1|ornament'),
('festplanering','1|planera'),
('festprisse','1|festa'),
('festprogram','1|program'),
('festsal','1|sal'),
('festskrift','1|skrift'),
('festspel','1|föreställning'),
('feststämning','1|glad'),
('festtal','1|tal'),
('festtalare','1|talare'),
('festtåg','1|procession'),
('festutstyrsel','1|utstyrsel'),
('festvåning','1|lokal'),
('festvärdinna','1|värdinna'),
('fet','1|tjock'),
('fet','2|bördig'),
('fetaost','1|fårost'),
('fetblad','1|växt'),
('fetera','1|fira'),
('feterande','1|fetera'),
('feterbar','1|fetera'),
('feterbarhet','1|feterbar'),
('fetering','1|fetera'),
('fethet','1|fet'),
('fethet','2|fet'),
('fetisch','1|föremål'),
('fetischism','1|fetisch'),
('fetischist','1|fetisch'),
('fetischistisk','1|fetischism'),
('fetknopp','1|fetblad'),
('fetknopp','2|tjockis'),
('fetlagd','1|fet'),
('fetlagdhet','1|fetlagd'),
('fetma','1|fet'),
('fetma','2|fet'),
('fetmaepidemi','1|epidemi'),
('fetmande','1|fetma'),
('fetna','1|fetma'),
('fetnande','1|fetna'),
('fetsill','1|sill'),
('fetstil','1|tryck'),
('fett','1|ämne'),
('fett','2|bra'),
('fettförbränning','1|förbränning'),
('fettglänsande','1|fett'),
('fetthalt','1|halt'),
('fetthaltig','1|fetthalt'),
('fetthaltighet','1|fetthaltig'),
('fetthjärta','1|sjukdom'),
('fetthärdning','1|fett'),
('fettisdag','1|fastlagen'),
('fettisdagsbulle','1|semla'),
('fettisdagsbulle','1|semla'),
('fettklump','1|klump'),
('fettkörtel','1|körtel'),
('fettlever','1|sjukdom'),
('fettlösande','1|lösa'),
('fettlöslig','1|lösa'),
('fettlöslighet','1|fettlöslig'),
('fetto','1|tjockis'),
('fettprocent','1|procent'),
('fettpärla','1|droppe'),
('fettreserv','1|reserv'),
('fettrik','1|fett'),
('fettrikhet','1|fettrik'),
('fettsnål','1|fett'),
('fettsot','1|fetma'),
('fettspruta','1|spruta'),
('fettsvansfår','1|får'),
('fettsyra','1|syra'),
('fettvalk','1|tjock'),
('fettväv','1|fettvävnad'),
('fettvävnad','1|vävnad'),
('fettämne','1|fett'),
('fetvadd','1|vadd'),
('fez','1|hatt'),
('fez','1|hatt'),
('fi','1|bokstav'),
('fi','1|bokstav'),
('fia','1|brädspel'),
('fia','1|brädspel'),
('fial','1|torn'),
('fiasko','1|misslyckas'),
('fiaskoartad','1|fiasko'),
('fiaskokonferens','1|konferens'),
('Fiat','1|bilmärke'),
('fibbla','1|växt'),
('fiber','1|tråd'),
('fiberblandning','1|blandning'),
('fiberkabel','1|kabel'),
('fiberoptik','1|optik'),
('fiberoptisk','1|fiberoptik'),
('fiberplatta','1|platta'),
('fiberrik','1|fiber'),
('fiberrikhet','1|fiberrik'),
('fiberspik','1|spik'),
('fibertillsats','1|tillsats'),
('fiberväxt','1|växt'),
('fibrig','1|fiber'),
('fibrighet','1|fibrig'),
('fibrill','1|tråd'),
('fibrillin','1|protein'),
('fibrin','1|äggviteämne'),
('fibrinogen','1|protein'),
('fibromyalgi','1|värk'),
('fibrös','1|fiber'),
('fibula','1|dräktspänne'),
('ficka','1|förvara'),
('fickformat','1|format'),
('fickhandbok','1|handbok'),
('fickkalkylator','1|miniräknare'),
('fickkniv','1|kniv'),
('ficklampa','1|lykta'),
('ficklock','1|lock'),
('fickparkera','1|parkera'),
('fickparkerande','1|fickparkera'),
('fickparkerbar','1|fickparkera'),
('fickparkerbarhet','1|fickparkerbar'),
('fickparkering','1|fickparkera'),
('fickpeng','1|fickpengar'),
('fickpengar','1|pengar'),
('fickplunta','1|flaska'),
('fickspegel','1|spegel'),
('fickstöld','1|ficktjuv'),
('ficktjuv','1|tjuv'),
('fickur','1|ur'),
('fiction','1|skönlitteratur'),
('fiction-novell','1|novell'),
('fideikommiss','1|egendom'),
('Fidias','1|skulptör'),
('fidus','1|travhäst'),
('fiende','1|ovän'),
('fiendearmé','1|armé'),
('fiendeland','1|land'),
('fiendelinje','1|frontlinje'),
('fiendesoldat','1|soldat'),
('fiendskap','1|fiende'),
('fientlig','1|fiende'),
('fientlighet','1|fientlig'),
('fiffel','1|fiffla'),
('fiffig','1|påhittig'),
('fiffighet','1|fiffig'),
('fiffla','1|lura'),
('fifflande','1|fiffla'),
('fifflare','1|fiffla'),
('Figge','1|Fingal'),
('fighter','1|kämpa'),
('fighter','1|kämpa'),
('figur','1|form'),
('figur','2|person'),
('figur','3|kroppsform'),
('figurant','1|balett'),
('figurant','2|figurera'),
('figuration','1|musik'),
('figurativ','1|föreställande'),
('figurera','1|förekomma'),
('figurerande','1|figurera'),
('figurering','1|figurera'),
('figurlig','1|bildlig'),
('figurlighet','1|figurlig'),
('figursydd','1|åtsittande'),
('figurteckning','1|teckning'),
('figuråkare','1|konståkare'),
('figuråkning','1|konståkning'),
('Fiji','1|land'),
('fijian','1|Fiji'),
('fijian','1|Fiji'),
('fijiansk','1|Fiji'),
('fijianska','1|fijian'),
('fijianska','2|språk'),
('fik','1|kafé'),
('fika','1|kaffe'),
('fika','2|fika'),
('fika','3|sträva'),
('fikadags','1|dags'),
('fikahörna','1|hörna'),
('fikande','1|fika'),
('fikande','2|fika'),
('fikapaus','1|paus'),
('fikarum','1|rum'),
('fiken','1|fika'),
('fikenhet','1|fiken'),
('fikon','1|frukt'),
('fikonlöv','1|skyla'),
('fikonspråk','1|språk'),
('fikonträd','1|träd'),
('fiktion','1|fantasi'),
('fiktion','2|antagande'),
('fiktionalism','1|fiktion'),
('fiktionsprosa','1|prosa'),
('fiktiv','1|fiktion'),
('fikus','1|krukväxt'),
('fikus','2|homosexuell'),
('fil','1|rad'),
('fil','2|verktyg'),
('fil','3|filmjölk'),
('fil','4|datorminne'),
('fil','5|körfält'),
('fila','1|fil'),
('Filadelfia','1|pingströrelsen'),
('filande','1|fila'),
('filantrop','1|osjälvisk'),
('filantropi','1|filantrop'),
('filantropisk','1|filantrop'),
('filare','1|fila'),
('filateli','1|samlare'),
('filatelist','1|filateli'),
('filatelistisk','1|filateli'),
('filatelistklubb','1|klubb'),
('filbunke','1|mjölk'),
('filbyte','1|byte'),
('fildelare','1|fildelning'),
('fildelning','1|nerladdning'),
('filé','1|kött'),
('filé','1|kött'),
('filé','2|stämpel'),
('filé','2|stämpel'),
('filé','3|brodergarn'),
('filé','3|brodergarn'),
('filea','1|bena'),
('filea','1|bena'),
('fileande','1|filea'),
('fileande','1|filea'),
('filera','1|fil'),
('filera','2|ton'),
('filerande','1|filera'),
('filerande','2|filera'),
('filerbar','1|filera'),
('filerbar','2|filera'),
('filerbarhet','1|filerbar'),
('filerbarhet','2|filerbar'),
('filering','1|filera'),
('filering','2|filera'),
('filering','3|filea'),
('filhandtag','1|handtag'),
('filharmoni','1|filharmonisk'),
('filharmoniker','1|filharmoni'),
('Filharmonikerna','1|orkester'),
('filharmonisk','1|orkester'),
('filial','1|underavdelning'),
('filialavdelning','1|filial'),
('filialkontor','1|kontor'),
('filibuster','1|tal'),
('filibustring','1|filibuster'),
('filigran','1|smycke'),
('filigran','1|smycke'),
('filipin','1|lek'),
('filippik','1|angrepp'),
('filippinare','1|Filippinerna'),
('Filippinerna','1|land'),
('filippinsk','1|Filippinerna'),
('filippinska','1|filippinare'),
('filisté','1|folk'),
('filister','1|småborgerlig'),
('filiströs','1|filister'),
('filklove','1|fila'),
('filkörning','1|körning'),
('filler','1|byggnadsmaterial'),
('film','1|bild'),
('film','2|fotografera'),
('film','3|skikt'),
('filma','1|film'),
('filma','2|låtsas'),
('filmaffisch','1|reklamaffisch'),
('filmande','1|filma'),
('filmande','2|filma'),
('filmare','1|film'),
('filmaskin','1|maskin'),
('filmateljé','1|filminspelning'),
('filmatisera','1|film'),
('filmatiserande','1|filmatisera'),
('filmatiserbar','1|filmatisera'),
('filmatiserbarhet','1|filmatiserbar'),
('filmatisering','1|filmatisera'),
('filmatisk','1|filmisk'),
('filmavsnitt','1|avsnitt'),
('filmberättande','1|berättande'),
('filmbild','1|film'),
('filmbolag','1|bolag'),
('filmbransch','1|bransch'),
('filmbranschen','1|bransch'),
('filmcensur','1|censur'),
('filmdebut','1|debut'),
('filmdebutera','1|debutera'),
('filmdebuterande','1|filmdebutera'),
('filmdebutering','1|filmdebutera'),
('filmexpert','1|expert'),
('filmfars','1|fars'),
('filmfestival','1|festival'),
('filmfotograf','1|fotograf'),
('filmframkallning','1|framkalla'),
('filmgestalt','1|person'),
('filmgranskning','1|granskning'),
('filmhistoria','1|historia'),
('filmhistorisk','1|filmhistoria'),
('filmindustri','1|industri'),
('filminspelning','1|inspelning'),
('Filminstitutet','1|institut'),
('filmintresserad','1|intresserad'),
('filmisk','1|film'),
('filmjölk','1|mjölk'),
('filmkamera','1|kamera'),
('filmklipp','1|filmavsnitt'),
('filmklippning','1|klippning'),
('filmkomedi','1|komedi'),
('filmmanuskript','1|manuskript'),
('filmmatiné','1|matiné'),
('filmmusik','1|musik'),
('filmmässig','1|film'),
('filmning','1|filma'),
('filmning','2|filma'),
('filmotek','1|film'),
('filmpremiär','1|premiär'),
('filmpris','1|pris'),
('filmproducent','1|producent'),
('filmproduktion','1|produktion'),
('filmprofessor','1|professor'),
('filmregissör','1|regissör'),
('filmroll','1|roll'),
('filmrulle','1|film'),
('filmscen','1|scen'),
('filmskapare','1|skapare'),
('filmskådespelare','1|skådespelare'),
('filmskådespelerska','1|filmskådespelare'),
('filmsnutt','1|snutt'),
('filmstjärna','1|filmskådespelare'),
('filmstudio','1|filminspelning'),
('filmstudio','2|förening'),
('filmtecknare','1|tecknare'),
('filmtidskrift','1|tidskrift'),
('filmtittande','1|tittande'),
('filmtittande','2|titta'),
('filmtrave','1|trave'),
('filmversion','1|version'),
('filmvetenskap','1|vetenskap'),
('filmvisning','1|visning'),
('filning','1|fila'),
('filolog','1|filologi'),
('filologi','1|vetenskap'),
('filologisk','1|språkvetenskap'),
('filosof','1|filosofi'),
('filosofem','1|teori'),
('filosofera','1|filosofi'),
('filosoferande','1|filosofera'),
('filosofering','1|filosofera'),
('filosofi','1|tänka'),
('filosofie','1|fakultet'),
('filosofilärare','1|lärare'),
('filosofisk','1|filosofi'),
('filosofkollega','1|kollega'),
('filspån','1|spån'),
('filt','1|täcke'),
('filt','2|material'),
('filta','1|filt'),
('filtande','1|filta'),
('filter','1|avskilja'),
('filtercigarett','1|cigarett'),
('filterludd','1|ludd'),
('filterpåse','1|kaffefilter'),
('filthatt','1|hatt'),
('filtrat','1|filtrera'),
('filtrera','1|filter'),
('filtrerande','1|filtrera'),
('filtrerbar','1|filtrera'),
('filtrerbarhet','1|filtrerbar'),
('filtrering','1|filtrera'),
('filtrerpapper','1|papper'),
('filtspets','1|spets'),
('filttoffel','1|toffel'),
('filttomte','1|jultomte'),
('filttäckt','1|täcka'),
('filtyta','1|yta'),
('filur','1|skämtare'),
('fimbulvinter','1|vinter'),
('fimmelstång','1|skakel'),
('fimmelstång','1|skakel'),
('fimp','1|stump'),
('fimpa','1|släcka'),
('fimpa','2|avskaffa'),
('fimpande','1|fimpa'),
('fimpande','2|fimpa'),
('fimpkastare','1|kasta'),
('fimpsug','1|sug'),
('fin','1|vacker'),
('fin','2|bra'),
('fin','3|tunn'),
('final','1|slut'),
('final','2|bisats'),
('finaldags','1|dags'),
('finalist','1|final'),
('finalklar','1|klar'),
('finalmiss','1|misslyckande'),
('finalplats','1|final'),
('finalsats','1|sats'),
('finalseger','1|seger'),
('finans','1|sällskapsspel'),
('finans','1|sällskapsspel'),
('finanschef','1|chef'),
('finansdebatt','1|debatt'),
('finansdepartement','1|departement'),
('finansdistrikt','1|distrikt'),
('finanser','1|ekonomi'),
('finansförvaltning','1|förvalta'),
('finanshaj','1|finansman'),
('finansiell','1|finanser'),
('finansiera','1|finanser'),
('finansierande','1|finansiera'),
('finansierbar','1|finansiera'),
('finansierbarhet','1|finansierbar'),
('finansiering','1|finansiera'),
('finansinspektion','1|inspektion'),
('finansiär','1|finansiera'),
('finanskrasch','1|krasch'),
('finanskris','1|kris'),
('finansman','1|finanser'),
('finansmarknad','1|marknad'),
('finansminister','1|minister'),
('finansministerium','1|ministerium'),
('finansnetto','1|kapitalinkomst'),
('finansplan','1|plan'),
('finanspolitik','1|politik'),
('finanspolitisk','1|finanspolitik'),
('finansrätt','1|rätt'),
('finansrättslig','1|finansrätt'),
('finansskojare','1|skojare'),
('finansutskott','1|utskott'),
('finansvalp','1|finansman'),
('finbruk','1|bruk'),
('finbränna','1|rena'),
('finbrännande','1|finbränna'),
('finemang','1|utmärkt'),
('finess','1|elegans'),
('finess','2|speciell'),
('finfin','1|fin'),
('finfördela','1|fördela'),
('finfördelande','1|finfördela'),
('finger','1|hand'),
('fingera','1|låtsa'),
('fingerad','1|fingera'),
('fingerande','1|fingera'),
('fingeravtryck','1|avtryck'),
('fingeravtrycksaspekt','1|fingeravtryck'),
('fingerbar','1|fingera'),
('fingerbarhet','1|fingerbar'),
('fingerblomma','1|fingertopp'),
('fingerbläck','1|märkbläck'),
('fingerborg','1|skydd'),
('fingerborgsblomma','1|medicinalväxt'),
('fingerbred','1|fingerbredd'),
('fingerbredd','1|bredd'),
('fingerböjarmuskel','1|muskel'),
('fingerfärdig','1|skicklig'),
('fingerfärdighet','1|fingerfärdig'),
('fingerfärg','1|färg'),
('fingerhandske','1|handske'),
('fingerhud','1|hud'),
('fingering','1|fingera'),
('fingerknäppning','1|knäppa'),
('fingerkrok','1|dragkamp'),
('fingerled','1|led'),
('fingernagel','1|nagel'),
('fingernerv','1|nerv'),
('fingerprov','1|blodprov'),
('fingerring','1|ring'),
('fingerskiva','1|telefon'),
('fingerspets','1|spets'),
('fingersträckarmuskel','1|muskel'),
('fingersvamp','1|svamp'),
('fingersättning','1|instrument'),
('fingertopp','1|spets'),
('fingertoppskänsla','1|känsla'),
('fingertoppsnyans','1|nyans'),
('fingertuta','1|förband'),
('fingervante','1|vante'),
('fingervisning','1|tecken'),
('fingerört','1|ört'),
('fingerövning','1|övning'),
('fingra','1|röra'),
('fingrad','1|förgrenad'),
('fingraderad','1|gradera'),
('fingrande','1|fingra'),
('fingranska','1|granska'),
('fingranskande','1|fingranska'),
('finhacka','1|finhackad'),
('finhackad','1|hacka'),
('finhet','1|fin'),
('finhet','2|fin'),
('finhet','3|fin'),
('finhyllt','1|hy'),
('finhyllthet','1|finhyllt'),
('finingång','1|ingång'),
('fininställa','1|justera'),
('fininställande','1|fininställa'),
('finish','1|finputs'),
('finish','2|slutspurt'),
('finit','1|verbform'),
('finjustera','1|justera'),
('finjusterande','1|finjustera'),
('finjusterbar','1|finjustera'),
('finjusterbarhet','1|finjusterbar'),
('finjustering','1|finjustera'),
('fink','1|småfågel'),
('finka','1|polisarrest'),
('finka','2|godsfinka'),
('finka','3|finka'),
('finkalibrig','1|kaliber'),
('finkalibrighet','1|finkalibrig'),
('finkamma','1|genomsöka'),
('finkammande','1|finkamma'),
('finkamning','1|finkamma'),
('finkande','1|finka'),
('finkart','1|art'),
('finkel','1|brännvin'),
('finkelolja','1|alkohol'),
('finkfågel','1|fink'),
('finklädd','1|kläder'),
('finkläddhet','1|finklädd'),
('finkläder','1|kläder'),
('finkornig','1|korn'),
('finkornighet','1|finkornig'),
('finkultur','1|kultur'),
('finkulturell','1|finkultur'),
('finkunge','1|fink'),
('finkänsla','1|finkänslighet'),
('finkänslig','1|hänsyn'),
('finkänslighet','1|finkänslig'),
('Finland','1|land'),
('finlandisera','1|vilja'),
('finlandiserande','1|finlandisera'),
('finlandiserbar','1|finlandisera'),
('finlandiserbarhet','1|finlandiserbar'),
('finlandisering','1|finlandisera'),
('finlandism','1|finlandssvenska'),
('finlandssvensk','1|svensk'),
('finlandssvensk','2|svensk'),
('finlandssvenska','1|språk'),
('finlandssvenska','2|finlandssvensk'),
('finlek','1|fin'),
('finlemmad','1|späd'),
('finlir','1|lir'),
('finländare','1|Finland'),
('finländsk','1|Finland'),
('finländska','1|finländare'),
('finmala','1|mala'),
('finmalande','1|finmala'),
('finmalning','1|finmala'),
('finmaskig','1|nät'),
('finmaskighet','1|finmaskig'),
('finmat','1|mat'),
('finmekaniker','1|mekaniker'),
('finmekanisk','1|precisionsarbete'),
('finmotorik','1|motorik'),
('finna','1|få'),
('finna','2|anse'),
('Finnair','1|flygbolag'),
('finnande','1|finna'),
('finnas','1|vara'),
('finne','1|Finland'),
('finne','2|blåsa'),
('finnig','1|finne'),
('finnighet','1|finnig'),
('finnjolle','1|segelbåt'),
('finnkamp','1|idrottstävling'),
('finnmark','1|skogsområde'),
('finpapper','1|papper'),
('finpappersbruk','1|pappersbruk'),
('finputs','1|finputsa'),
('finputsa','1|putsa'),
('finputsande','1|finputsa'),
('finriven','1|riva'),
('finrum','1|rum'),
('finsikta','1|sikta'),
('finsiktande','1|finsikta'),
('finsiktning','1|finsikta'),
('finsilver','1|silver'),
('finsk','1|Finland'),
('finsk','2|finska'),
('finska','1|språk'),
('finska','2|finne'),
('finskhet','1|finsk'),
('finsko','1|sko'),
('finskspråkig','1|finska'),
('finsktalande','1|finska'),
('finsk-ugrisk','1|språkfamilj'),
('finsk-ugrisk','1|språkfamilj'),
('finskuren','1|vacker'),
('finskuren','2|skära'),
('finskåp','1|skåp'),
('finskägd','1|äga'),
('finslipa','1|slipa'),
('finslipande','1|finslipa'),
('finslipning','1|finslipa'),
('finsmakare','1|expert'),
('finsmide','1|smide'),
('finsnickare','1|snickare'),
('finsnickeri','1|finsnickare'),
('finspackel','1|spackel'),
('finsprit','1|alkohol'),
('finspunnen','1|spinna'),
('finspäntad','1|spänta'),
('finstil','1|finstilt'),
('finstilt','1|tryckstil'),
('finstrimlad','1|strimla'),
('finstruktur','1|struktur'),
('finstämd','1|stämma'),
('finstämdhet','1|finstämd'),
('fint','1|knep'),
('finta','1|fint'),
('fintande','1|finta'),
('fintlig','1|fint'),
('fintlighet','1|fintlig'),
('fintrådig','1|tråd'),
('fintvätt','1|tvätt'),
('finurlig','1|sinnrik'),
('finurlighet','1|finurlig'),
('fiol','1|instrument'),
('fiolblock','1|block'),
('fiolbyggare','1|bygga'),
('fiollåda','1|fodral'),
('fiolspel','1|fiol'),
('fiolspelare','1|fiol'),
('fiolstråke','1|stråke'),
('fiolsträng','1|sträng'),
('fiolvirtuos','1|fiolspelare'),
('fioritur','1|utsmyckning'),
('fippla','1|fipplig'),
('fipplande','1|fippla'),
('fipplig','1|fumlig'),
('fipplighet','1|fipplig'),
('fira','1|fest'),
('fira','2|dra'),
('firande','1|fira'),
('firande','2|fira'),
('Firefox','1|webbläsare'),
('firma','1|företag'),
('firmafest','1|fest'),
('firmament','1|himlavalv'),
('firmamärke','1|symbol'),
('firmanamn','1|namn'),
('firmatecknare','1|firmateckning'),
('firmateckning','1|underskrift'),
('firn','1|snö'),
('firngräns','1|glaciär'),
('firning','1|fira'),
('firning','2|fira'),
('firre','1|fisk'),
('fis','1|gas'),
('fisa','1|fis'),
('fisande','1|fisa'),
('fischy','1|halsduk'),
('fisförnäm','1|struntförnäm'),
('fisförnämhet','1|fisförnäm'),
('fisig','1|elak'),
('fisk','1|djur'),
('fisk','2|mat'),
('fisk','3|Fiskarna'),
('fisk','3|Fiskarna'),
('fiska','1|fånga'),
('fiska','2|luska'),
('fiskafänge','1|fiska'),
('fiskal','1|ekonomi'),
('fiskal','2|jurist'),
('fiskalisk','1|fiskal'),
('fiskande','1|fiska'),
('fiskare','1|fiska'),
('Fiskarna','1|stjärntecken'),
('Fiskarna','1|stjärntecken'),
('fiskart','1|art'),
('fiskben','1|ben'),
('fiskben','2|bard'),
('fiskbensmönster','1|mönster'),
('fiskbestick','1|bestick'),
('fiskblåsa','1|simblåsa'),
('fiskblåsa','2|ornament'),
('fiskbullar','1|maträtt'),
('fiskdamm','1|fiskodling'),
('fiskdamm','2|förlustelse'),
('fiskdöd','1|död'),
('fiske','1|fiska'),
('fiskeansvarig','1|ansvarig'),
('fiskebank','1|bank'),
('fiskebåt','1|båt'),
('fiskebåtsbesättning','1|besättning'),
('fiskedon','1|fiska'),
('fiskedrag','1|fiska'),
('fiskefartyg','1|fiskebåt'),
('fiskegräns','1|gräns'),
('fiskekniv','1|kniv'),
('fiskekort','1|tillstånd'),
('fiskelag','1|lag'),
('fiskelina','1|lina'),
('fiskelina','1|lina'),
('fiskelycka','1|lyckas'),
('fiskeläge','1|ort'),
('fiskenation','1|nation'),
('fiskeolycka','1|olycka'),
('fiskeri','1|fiske'),
('fiskeristyrelse','1|ämbetsverk'),
('fiskestuga','1|stuga'),
('fiskevatten','1|vatten'),
('fiskevård','1|skötsel'),
('fiskezon','1|fiskegräns'),
('fiskfilé','1|filé'),
('fiskfångst','1|fångst'),
('fiskfärs','1|färs'),
('fiskgjuse','1|rovfågel'),
('fiskguano','1|guano'),
('fiskhalster','1|halster'),
('fiskhamn','1|hamn'),
('fiskhuvud','1|huvud'),
('fiskkniv','1|kniv'),
('fiskkrok','1|krok'),
('fiskkrok','1|krok'),
('fiskleverolja','1|olja'),
('fisklevertran','1|levertran'),
('fisklik','1|fisk'),
('fisklikhet','1|fisklik'),
('fisklir','1|fotboll'),
('fiskmjöl','1|mjöl'),
('fiskmun','1|mun'),
('fiskmåltid','1|måltid'),
('fiskmås','1|mås'),
('fisknot','1|not'),
('fisknät','1|nät'),
('fisknät','1|nät'),
('fiskodling','1|odling'),
('fiskolja','1|fiskleverolja'),
('fiskpedikyr','1|pedikyr'),
('fiskpinnar','1|maträtt'),
('fiskpudding','1|maträtt'),
('fiskredskap','1|redskap'),
('fiskredskap','1|redskap'),
('fiskrens','1|rensa'),
('fiskrik','1|fisk'),
('fiskrom','1|rom'),
('fiskrätt','1|maträtt'),
('fisksoppa','1|soppa'),
('fiskspad','1|spad'),
('fiskstim','1|stim'),
('fiskstjärt','1|stjärt'),
('fisksump','1|förvara'),
('fisksås','1|sås'),
('fisktom','1|fisk'),
('fisktomhet','1|fisktom'),
('fisktrappa','1|vattenled'),
('fisktärna','1|sjöfågel'),
('fiskvandring','1|lekvandring'),
('fiskvin','1|vin'),
('fiskyngel','1|yngel'),
('fiskådra','1|fiskvandring'),
('fiskätande','1|äta'),
('fisködla','1|ödla'),
('fisköga','1|öga'),
('fissil','1|fission'),
('fission','1|kärnklyvning'),
('fissur','1|spricka'),
('fistel','1|kanal'),
('fistulös','1|fistel'),
('fitness','1|framgång'),
('fitness','2|träning'),
('fitta','1|slida'),
('fitta','2|usling'),
('fittrakt','1|fitta'),
('fittsafari','1|safari'),
('fittstim','1|kvinna'),
('fix','1|fast'),
('fix','2|fixa'),
('fix','3|kakelfix'),
('fix','4|fixera'),
('fixa','1|ordna'),
('fixa','2|skaffa'),
('fixa','3|laga'),
('fixa','4|dona'),
('fixande','1|fixa'),
('fixande','2|fixa'),
('fixande','3|fixa'),
('fixande','4|fixa'),
('fixare','1|fixa'),
('fixativ','1|ämne'),
('fixera','1|fix'),
('fixera','2|filmframkallning'),
('fixera','3|fixerad'),
('fixerad','1|mani'),
('fixerande','1|fixera'),
('fixerande','2|fixera'),
('fixerande','3|fixera'),
('fixerbad','1|lösning'),
('fixerbar','1|fixera'),
('fixerbar','2|fixera'),
('fixerbarhet','1|fixerbar'),
('fixerbarhet','2|fixerbar'),
('fixering','1|fixera'),
('fixeringsbild','1|bild'),
('fixhet','1|fix'),
('fixkam','1|verktyg'),
('fixpunkt','1|punkt'),
('fixstjärna','1|stjärna'),
('fixstjärna','2|stjärna'),
('fixtur','1|verktyg'),
('fjant','1|fjantig'),
('fjant','2|fjantig'),
('fjanta','1|fjantig'),
('fjantande','1|fjanta'),
('fjanteri','1|fjantig'),
('fjantig','1|löjlig'),
('fjantighet','1|fjantig'),
('fjantstämpel','1|stämpel'),
('fjolla','1|fjollig'),
('fjolla','2|gay'),
('fjollas','1|fjollig'),
('fjolleri','1|fjollig'),
('fjollig','1|vimsig'),
('fjollighet','1|fjollig'),
('Fjollträsk','1|Stockholm'),
('Fjollträsk','1|Stockholm'),
('fjolår','1|fjolåret'),
('fjolåret','1|i_fjol'),
('fjolårsgräs','1|gräs'),
('fjomperi','1|fjompig'),
('fjompig','1|löjlig'),
('fjompighet','1|fjompig'),
('fjong','1|erektion'),
('fjong','2|bra'),
('fjord','1|vik'),
('fjordhäst','1|häst'),
('fjording','1|fjordhäst'),
('fjortis','1|tonåring'),
('fjorton','1|tal'),
('fjorton','1|tal'),
('fjortonde','1|fjorton'),
('fjortonhundratalet','1|århundrade'),
('fjortonhundratalet','1|århundrade'),
('fjortonsnåret','1|klockslag'),
('fjortonårig','1|år'),
('fjortonåring','1|fjortonårig'),
('fjun','1|hår'),
('fjunig','1|fjun'),
('fjuttholme','1|holme'),
('fjuttig','1|futtig'),
('fjuttighet','1|fjuttig'),
('fjäder','1|fågel'),
('fjäder','2|elastisk'),
('fjäder','3|bräda'),
('fjäderbeklädnad','1|fjäderskrud'),
('fjäderboll','1|badmintonboll'),
('fjäderbuske','1|prydnadsfjäder'),
('fjäderdosa','1|dosa'),
('fjäderdräkt','1|fjäder'),
('fjäderformad','1|fjäder'),
('fjäderfä','1|fågel'),
('fjädergräs','1|gräs'),
('fjäderklädd','1|fjäder'),
('fjäderkudde','1|kudde'),
('fjäderliknande','1|fjäder'),
('fjäderluftgevär','1|luftgevär'),
('fjäderlätt','1|lätt'),
('fjäderlätthet','1|fjäderlätt'),
('fjädermoln','1|moln'),
('fjädermygga','1|mygga'),
('fjäderpensel','1|frö'),
('fjäderskrud','1|fjäder'),
('fjäderstål','1|stål'),
('fjädertyp','1|typ'),
('fjädertyp','2|typ'),
('fjädervikt','1|viktklass'),
('fjädervinge','1|skalbagge'),
('fjädervåg','1|våg'),
('fjädra','1|fjäder'),
('fjädrande','1|fjädra'),
('fjädring','1|fjäder'),
('fjädringskapacitet','1|kapacitet'),
('fjädringsmekanism','1|mekanism'),
('fjäll','1|berg'),
('fjäll','2|hud'),
('fjäll','3|täcka'),
('fjäll','4|hudflaga'),
('fjälla','1|avlägsna'),
('fjälla','2|fjäll'),
('fjälla','3|kvinna'),
('fjällande','1|fjälla'),
('fjällande','2|fjälla'),
('fjällandskap','1|landskap'),
('Fjällbacka','1|ort'),
('fjällbilist','1|bilist'),
('fjällbjörk','1|björk'),
('fjällbrud','1|växt'),
('fjällbygd','1|fjäll'),
('fjällbäck','1|bäck'),
('fjälldal','1|dal'),
('fjällig','1|fjäll'),
('fjällighet','1|fjällig'),
('fjällik','1|fjäll'),
('fjällikhet','1|fjällik'),
('fjällkedja','1|bergskedja'),
('fjällnatur','1|natur'),
('fjällning','1|fjälla'),
('fjällning','2|fjälla'),
('fjällnära','1|nära'),
('fjällpanel','1|panel'),
('fjällpanelshus','1|hus'),
('fjällpansar','1|fjäll'),
('fjällparti','1|parti'),
('fjällpipare','1|vadarfågel'),
('fjällplatå','1|platå'),
('fjällregion','1|fjäll'),
('fjällripa','1|ripa'),
('fjällrygg','1|bergsrygg'),
('fjällräv','1|räv'),
('fjällsemester','1|skidsemester'),
('fjällsippa','1|sippa'),
('fjällsjö','1|sjö'),
('fjällskivling','1|skivling'),
('fjällsluttning','1|sluttning'),
('fjällspets','1|bergstopp'),
('fjällstation','1|station'),
('fjällstuga','1|stuga'),
('fjällsyra','1|växt'),
('fjälltopp','1|bergstopp'),
('fjälltrakt','1|trakt'),
('fjällturist','1|turist'),
('fjälluft','1|luft'),
('fjälluggla','1|uggla'),
('fjällvandra','1|vandra'),
('fjällvandrande','1|fjällvandra'),
('fjällvandrare','1|fjällvandra'),
('fjällvandring','1|fjällvandra'),
('fjällvråk','1|vråk'),
('fjällvärld','1|fjäll'),
('fjällämmel','1|lämmel'),
('fjälster','1|djurtarm'),
('fjär','1|högdragen'),
('fjärd','1|vik'),
('fjärde','1|fyra'),
('fjärdedel','1|bråkdel'),
('fjärdegradsekvation','1|ekvation'),
('fjärdeplats','1|plats'),
('fjärding','1|fjärdedel'),
('fjärding','2|rymdmått'),
('fjärdingsman','1|polis'),
('fjärdingsväg','1|fjärdedel'),
('fjärhet','1|fjär'),
('fjäril','1|insekt'),
('fjärilsart','1|art'),
('fjärilsblomma','1|blomma'),
('fjärilseffekten','1|kaosteori'),
('fjärilsim','1|simsätt'),
('fjärilsim','1|simsätt'),
('fjärilslarv','1|larv'),
('fjärilslätt','1|lätt'),
('fjärilsvinge','1|vinge'),
('fjärma','1|avlägsna'),
('fjärmande','1|fjärma'),
('fjärr','1|fjärrkontroll'),
('fjärran','1|avlägsen'),
('fjärran','2|fjärran'),
('fjärran','2|fjärran'),
('fjärranblickande','1|blicka'),
('fjärrblockera','1|fjärrblockering'),
('fjärrblockerande','1|fjärrblockera'),
('fjärrblockerbar','1|fjärrblockera'),
('fjärrblockerbarhet','1|fjärrblockerbar'),
('fjärrblockering','1|järnvägstrafik'),
('fjärrhandel','1|handel'),
('fjärris','1|fjärrkontroll'),
('fjärrkontroll','1|kontroll'),
('fjärrpunkt','1|punkt'),
('fjärrseende','1|sia'),
('fjärrskrivare','1|teleprinter'),
('fjärrskrivmaskin','1|teleprinter'),
('fjärrskådande','1|fjärrskådare'),
('fjärrskådare','1|sia'),
('fjärrströmbrytare','1|strömbrytare'),
('fjärrstyrd','1|manövrera'),
('fjärrtrafik','1|trafik'),
('fjärrtåg','1|tåg'),
('fjärrvärme','1|uppvärmning'),
('fjärrvärmegranskning','1|granskning'),
('fjärrvärmepris','1|pris'),
('fjärsing','1|fisk'),
('fjärt','1|fis'),
('fjärta','1|fjärt'),
('fjärtande','1|fjärta'),
('Fjärås','1|Göteborg'),
('fjäsk','1|fjäska'),
('fjäska','1|inställsam'),
('fjäskande','1|fjäska'),
('fjäsker','1|fjäska'),
('fjäskig','1|fjäska'),
('fjäskighet','1|fjäskig'),
('fjät','1|steg'),
('fjättra','1|fängsla'),
('fjättrande','1|fjättra'),
('fjättrar','1|boja'),
('fjöl','1|brödspade'),
('fjöl','2|bräde'),
('fjöla','1|pinka'),
('flabb','1|flabba'),
('flabb','2|mun'),
('flabba','1|skratta'),
('flabbande','1|flabba'),
('flabbig','1|flabba'),
('flabbighet','1|flabbig'),
('flack','1|platt'),
('flacka','1|fara'),
('flackande','1|flacka'),
('flackbanepjäs','1|artilleripjäs'),
('flackeld','1|eld'),
('flackhet','1|flack'),
('flackland','1|slätt'),
('fladder','1|fladdra'),
('fladdermus','1|djur'),
('fladdermusfåtölj','1|fåtölj'),
('fladdermusliknande','1|fladdermus'),
('fladdra','1|svänga'),
('fladdrande','1|fladdra'),
('fladdrig','1|fladdra'),
('fladdrighet','1|fladdrig'),
('flaga','1|bit'),
('flaga','2|flaga'),
('flagande','1|flaga'),
('flagell','1|simorgan'),
('flagellant','1|gissel'),
('flagellantism','1|flagellant'),
('flagellat','1|urdjur'),
('flageolett','1|flöjt'),
('flagg','1|flagga'),
('flagga','1|symbol'),
('flagga','2|flagga'),
('flagga','3|förvarna'),
('flaggande','1|flagga'),
('flaggande','2|flagga'),
('flaggbränning','1|bränna'),
('flaggdag','1|dag'),
('flaggduk','1|tyg'),
('flaggkapten','1|stabschef'),
('flagglina','1|lina'),
('flaggman','1|officer'),
('flaggning','1|flagga'),
('flaggprydd','1|pryda'),
('flaggsignal','1|signal'),
('flaggskepp','1|främst'),
('flaggskändning','1|skändning'),
('flaggspel','1|flaggstång'),
('flaggstång','1|stång'),
('flaggvakt','1|vakt'),
('flaggviftande','1|vifta'),
('flaggviftande','2|vifta'),
('flaggviftning','1|viftning'),
('flagig','1|flaga'),
('flagna','1|flaga'),
('flagnande','1|flagna'),
('flagrant','1|uppenbar'),
('flak','1|stycke'),
('flak','2|last'),
('flak','3|låda'),
('flakmoppe','1|moppe'),
('flakong','1|parfymflaska'),
('flakvagn','1|vagn'),
('flambera','1|antända'),
('flamberande','1|flambera'),
('flamberbar','1|flambera'),
('flamberbarhet','1|flamberbar'),
('flambering','1|flambera'),
('flamenco','1|sång'),
('flamencogitarrist','1|gitarrist'),
('flamingo','1|fågel'),
('flamländare','1|Flandern'),
('flamländsk','1|Flandern'),
('flamländska','1|språk'),
('flamländska','2|flamländare'),
('flamma','1|eld'),
('flamma','2|flamma'),
('flammande','1|flamma'),
('flammig','1|rödflammig'),
('flammighet','1|flammig'),
('flampunkt','1|antända'),
('flams','1|flamsa'),
('flamsa','1|stojig'),
('flamsa','2|flamsig'),
('flamsande','1|flamsa'),
('flamsig','1|flamsa'),
('flamsighet','1|flamsig'),
('flamsk','1|flamländsk'),
('flamskhet','1|flamsk'),
('flamskvävnad','1|vävnad'),
('flamskyddsmedel','1|medel'),
('flamugn','1|ugn'),
('Flandern','1|Belgien'),
('flandrisk','1|Flandern'),
('flanell','1|tyg'),
('flanellborste','1|borste'),
('flanellkostym','1|kostym'),
('flanellograf','1|bild'),
('flanellpyjamas','1|pyjamas'),
('flanera','1|promenera'),
('flanerande','1|flanera'),
('flanering','1|flanera'),
('flank','1|sida'),
('flankanfall','1|anfall'),
('flankera','1|flank'),
('flankerande','1|flankera'),
('flankerbar','1|flankera'),
('flankerbarhet','1|flankerbar'),
('flankering','1|flankera'),
('flanör','1|flanera'),
('flark','1|fördjupning'),
('flarn','1|stycke'),
('flashig','1|tjusig'),
('flaska','1|förvara'),
('flaskbarn','1|spädbarn'),
('flaskborste','1|borste'),
('flaskbrist','1|brist'),
('flaskhals','1|hals'),
('flaskhals','2|hinder'),
('flaskhål','1|hål'),
('flaskkastning','1|kasta'),
('flaskkurbits','1|kalebass'),
('flasklock','1|ingenting'),
('flasklock','2|lock'),
('flasknosdelfin','1|öresvin'),
('flaskpost','1|post'),
('flasköppnare','1|öppnare'),
('flasköppning','1|öppning'),
('flasköppning','2|öppning'),
('flat','1|platt'),
('flata','1|handflata'),
('flata','2|lesbisk'),
('flata','3|flatsida'),
('flatbottnad','1|botten'),
('flatbröd','1|tunnbröd'),
('flateka','1|eka'),
('flatfisk','1|flundra'),
('flatgarv','1|garv'),
('flathet','1|flat'),
('flatlus','1|lus'),
('flatsida','1|sida'),
('flatskratt','1|hånskratt'),
('flatskratta','1|flatskratt'),
('flatskrattande','1|flatskratta'),
('flattera','1|smickra'),
('flatterande','1|flattera'),
('flatterbar','1|flattera'),
('flatterbarhet','1|flatterbar'),
('flattering','1|flattera'),
('flatulens','1|väderspänning'),
('flau','1|börs'),
('flax','1|tur'),
('flax','2|flaxa'),
('flaxa','1|röra'),
('flaxande','1|flaxa'),
('flaxig','1|oberäknelig'),
('flaxighet','1|flaxig'),
('flaxning','1|flaxa'),
('fleece','1|tyg'),
('fleece-foder','1|foder'),
('flegma','1|flegmatisk'),
('flegmatiker','1|flegmatisk'),
('flegmatisk','1|sävlig'),
('flektera','1|böja'),
('flekterande','1|flektera'),
('flekterbar','1|flektera'),
('flekterbarhet','1|flekterbar'),
('flektering','1|flektera'),
('flensost','1|smegma'),
('flensost','1|smegma'),
('flera','1|mången'),
('flera','1|mången'),
('flerbarnsfamilj','1|barnfamilj'),
('flerbarnsmamma','1|mamma'),
('flerbarnsmor','1|mor'),
('flerbostadshus','1|bostadshus'),
('flercellig','1|cell'),
('flercellighet','1|flercellig'),
('flerdubbel','1|dubbel'),
('flerdubbla','1|flerdubbel'),
('flerdubblande','1|flerdubbla'),
('flerfaldig','1|upprepa'),
('flerfaldiga','1|flerfaldig'),
('flerfaldigande','1|flerfaldiga'),
('flerfamiljshus','1|hus'),
('flerfärgad','1|färg'),
('flerfärgstryck','1|bild'),
('flergångs','1|gång'),
('flergångsförbrytare','1|förbrytare'),
('flerhandikapp','1|flerhandikappad'),
('flerhandikappad','1|handikapp'),
('flerhet','1|flera'),
('flermansvalkrets','1|valkrets'),
('fleromättad','1|fett'),
('flerording','1|flerordsenhet'),
('flerordsenhet','1|lexem'),
('flerpartisystem','1|system'),
('flersidig','1|sida'),
('flersiffrig','1|siffra'),
('flerspråkig','1|språk'),
('flerspråkighet','1|flerspråkig'),
('flerstammig','1|stam'),
('flerstavig','1|stavelse'),
('flerstavighet','1|flerstavig'),
('flerstädes','1|ställe'),
('flerstämmig','1|stämma'),
('flerstämmighet','1|flerstämmig'),
('flertal','1|mången'),
('flertydig','1|tolka'),
('flertydighet','1|flertydig'),
('flervalsfråga','1|fråga'),
('flervalstest','1|test'),
('flervalsuppgift','1|flervalsfråga'),
('flervåningshus','1|hus'),
('flerårig','1|år'),
('fles','1|usling'),
('flexa','1|flextid'),
('flexande','1|flexa'),
('flexibel','1|smidig'),
('flexibel','2|smidig'),
('flexibilitet','1|flexibel'),
('flexibilitet','2|flexibel'),
('flexion','1|böja'),
('flexion','1|böja'),
('flexionsform','1|flexion'),
('flexionsändelse','1|flexion'),
('flexislang','1|slang'),
('flexivisk','1|flexion'),
('flexklocka','1|stämpelur'),
('flextid','1|arbetstid'),
('flexur','1|bergart'),
('flicka','1|barn'),
('flicka','2|barn'),
('flickaktig','1|flicka'),
('flickaktighet','1|flickaktig'),
('flickansikte','1|ansikte'),
('flickbok','1|bok'),
('flickboksfantasi','1|fantasi'),
('flickbokshjältinna','1|hjältinna'),
('flickboksklassiker','1|klassiker'),
('flickbokstradition','1|tradition'),
('flickebarn','1|flicka'),
('flickfotograf','1|fotograf'),
('flickjägare','1|förföra'),
('flickkalv','1|kokalv'),
('flickkör','1|kör'),
('flickmatch','1|match'),
('flicknamn','1|namn'),
('flickpension','1|internat'),
('flickröst','1|röst'),
('flickscout','1|scout'),
('flickskola','1|skola'),
('flickslända','1|trollslända'),
('flicksnärta','1|flicka'),
('flicktycke','1|kvinnotycke'),
('flickunge','1|flicka'),
('flickvän','1|vän'),
('flight','1|tur'),
('flik','1|bit'),
('flikad','1|flikig'),
('flikig','1|flik'),
('flikighet','1|flikig'),
('flimmer','1|flimra'),
('flimmercell','1|cell'),
('flimmerhår','1|hår'),
('flimra','1|lysa'),
('flimrande','1|flimra'),
('flimrig','1|flimra'),
('flimrighet','1|flimrig'),
('flin','1|flina'),
('flina','1|le'),
('flinande','1|flina'),
('flinare','1|flina'),
('flinga','1|stycke'),
('flingsalt','1|salt'),
('flink','1|snabb'),
('flinkhet','1|flink'),
('flint','1|flintskallig'),
('flinta','1|mineral'),
('flintgods','1|porslin'),
('flinthård','1|hård'),
('flintlås','1|flintlåsgevär'),
('flintlåsgevär','1|gevär'),
('flintskalle','1|hår'),
('flintskallig','1|flintskalle'),
('flintskallighet','1|flintskallig'),
('flintyxa','1|yxa'),
('flipperkula','1|kula'),
('flipperspel','1|spelautomat'),
('flipprig','1|splittrad'),
('flis','1|flisa'),
('flis','2|bränsle'),
('flis','3|pengar'),
('flisa','1|bit'),
('flisig','1|flisa'),
('flisighet','1|flisig'),
('flit','1|flitig'),
('flitig','1|arbetsam'),
('flitig','2|ofta'),
('flo','1|ladugård'),
('floatglas','1|glas'),
('Floby','1|ort'),
('flock','1|grupp'),
('flock','2|avfall'),
('flockbeteende','1|beteende'),
('flockblommig','1|blomma'),
('flockdjur','1|djur'),
('flockig','1|flock'),
('flockighet','1|flockig'),
('flockinstinkt','1|instinkt'),
('flockkamrat','1|kamrat'),
('flockvis','1|flock'),
('flod','1|vatten'),
('flod','2|tidvatten'),
('flodarm','1|flod'),
('flodbrädd','1|flodstrand'),
('flodbåt','1|båt'),
('flodbädd','1|botten'),
('floddal','1|dal'),
('floddelta','1|delta'),
('flodfart','1|trafik'),
('flodfåra','1|flodbädd'),
('flodgud','1|gud'),
('flodhäst','1|djur'),
('flodhästunge','1|flodhäst'),
('flodiller','1|iller'),
('flodkrabba','1|krabba'),
('flodkrök','1|krök'),
('flodmynning','1|mynning'),
('flodområde','1|avrinna'),
('flodprofil','1|vattenstånd'),
('flodslätt','1|slätt'),
('flodstrand','1|strand'),
('flodsvin','1|vattensvin'),
('flodsystem','1|flod'),
('flodterrass','1|terrass'),
('flodvatten','1|vatten'),
('flodvåg','1|våg'),
('flodångare','1|flodbåt'),
('flodövergång','1|övergång'),
('flopp','1|misslyckande'),
('flopp','1|misslyckande'),
('floppa','1|flopp'),
('floppande','1|floppa'),
('floppning','1|floppa'),
('floppsatsning','1|satsning'),
('flor','1|slöja'),
('flor','2|blomstring'),
('flora','1|växt'),
('flora','2|bok'),
('flora','3|samling'),
('florbehängd','1|flor'),
('Florens','1|stad'),
('florentinsk','1|Florens'),
('florera','1|utbreda_sig'),
('florerande','1|florera'),
('florering','1|florera'),
('florett','1|fäktning'),
('florettfäktning','1|florett'),
('florettfäktningskurs','1|kurs'),
('florettstick','1|stick'),
('Florida','1|delstat'),
('florilegium','1|samling'),
('florin','1|guldmynt'),
('florist','1|floristik'),
('florist','2|blomma'),
('floristik','1|flora'),
('floristisk','1|flora'),
('florsocker','1|socker'),
('floskel','1|fras'),
('floskelpatriot','1|patriot'),
('floskulös','1|floskel'),
('flossa','1|vävnad'),
('flossa','2|tandtråda'),
('flossad','1|flossa'),
('flossande','1|flossa'),
('flossning','1|flossa'),
('flotation','1|gråberg'),
('flott','1|fett'),
('flott','2|elegant'),
('flott','3|grund'),
('flotta','1|fartyg'),
('flotta','2|timmer'),
('flottande','1|flotta'),
('flottare','1|flotta'),
('flottbas','1|bas'),
('flottbesök','1|besök'),
('flottbro','1|bro'),
('flotte','1|flyta'),
('flottenhet','1|enhet'),
('flottfläck','1|fläck'),
('flotthet','1|flott'),
('flottig','1|flott'),
('flottighet','1|flottig'),
('flottilj','1|förband'),
('flottist','1|sjöman'),
('flottled','1|led'),
('flottning','1|flotta'),
('flottningstimmer','1|timmer'),
('flottstrateg','1|strateg'),
('flottstyrman','1|styrman'),
('flottyr','1|flott'),
('flottyrkoka','1|koka'),
('flottyrkokande','1|flottyrkoka'),
('flottör','1|vätskenivå'),
('flottövning','1|militärövning'),
('flox','1|växt'),
('fluffig','1|luftig'),
('fluffighet','1|fluffig'),
('fluga','1|insekt'),
('fluga','2|rosett'),
('fluga','3|modenyck'),
('fluga','4|drag'),
('flugblomster','1|orkidé'),
('flugfiske','1|fiske'),
('flugpapper','1|fånga'),
('flugsmuts','1|smuts'),
('flugsmälla','1|smälla'),
('flugsnappare','1|småfågel'),
('flugsvamp','1|svamp'),
('flugvifta','1|vifta'),
('flugvikt','1|viktklass'),
('fluid','1|fluidum'),
('fluidisera','1|fluidum'),
('fluidiserande','1|fluidisera'),
('fluidiserbar','1|fluidisera'),
('fluidiserbarhet','1|fluidiserbar'),
('fluidisering','1|fluidisera'),
('fluidum','1|vätska'),
('flukt','1|flukta'),
('flukta','1|titta'),
('fluktande','1|flukta'),
('fluktuation','1|fluktuera'),
('fluktuera','1|variera'),
('fluktuerande','1|fluktuera'),
('fluktuering','1|fluktuera'),
('flum','1|flummig'),
('flumkurs','1|kurs'),
('flumma','1|flummig'),
('flummande','1|flumma'),
('flummig','1|oklar'),
('flummighet','1|flummig'),
('flumpedagogik','1|pedagogik'),
('flundra','1|fisk'),
('flundra','1|fisk'),
('flunsa','1|influensa'),
('fluor','1|grundämne'),
('fluor','1|grundämne'),
('fluorbehandling','1|skydda'),
('fluorescens','1|utstrålning'),
('fluorescera','1|fluorescens'),
('fluorescerande','1|fluorescera'),
('fluorescering','1|fluorescera'),
('fluorhalt','1|halt'),
('fluorhaltig','1|fluorhalt'),
('fluorid','1|salt'),
('fluoridera','1|fluorbehandling'),
('fluoridera','1|fluorbehandling'),
('fluoriderande','1|fluoridera'),
('fluoriderande','1|fluoridera'),
('fluoriderbar','1|fluoridera'),
('fluoriderbar','1|fluoridera'),
('fluoriderbarhet','1|fluoriderbar'),
('fluoriderbarhet','1|fluoriderbar'),
('fluoridering','1|fluoridera'),
('fluoridering','1|fluoridera'),
('fluss','1|smältpunkt'),
('flussglas','1|glas'),
('flussmedel','1|fluss'),
('flusspat','1|mineral'),
('fluster','1|bikupa'),
('fluvial','1|flod'),
('fly','1|bort'),
('fly','2|räcka'),
('fly','3|insekt'),
('fly','4|gungfly'),
('fly','5|ankarfly'),
('flyende','1|fly'),
('flyende','2|fly'),
('flyfotad','1|snabb'),
('flyfotadhet','1|flyfotad'),
('flyg','1|flygplan'),
('flyg','2|flygtrafik'),
('flyga','1|röra'),
('flyga','2|resa'),
('flygande','1|flyga'),
('flygande','2|flyga'),
('flyganfall','1|anfall'),
('flygankomst','1|ankomst'),
('flygare','1|flygplan'),
('flygattaché','1|försvarsattaché'),
('flygattack','1|attack'),
('flygavgång','1|avgång'),
('flygbas','1|bas'),
('flygbasbarack','1|barack'),
('flygbensin','1|bensin'),
('flygbild','1|bild'),
('flygbiljett','1|biljett'),
('flygblad','1|propaganda'),
('flygbolag','1|bolag'),
('flygbomb','1|bomb'),
('flygbomba','1|bomba'),
('flygbombande','1|flygbomba'),
('flygbro','1|korridor'),
('flygbränsle','1|bränsle'),
('flygbuss','1|buss'),
('flygbåt','1|sjöflygplan'),
('flygcertifikat','1|certifikat'),
('flygdrama','1|drama'),
('flygekorre','1|fladdermus'),
('flygel','1|piano'),
('flygel','2|byggnad'),
('flygelbyggnad','1|flygel'),
('flygfisk','1|fisk'),
('flygflotta','1|flygplan'),
('flygfoto','1|flygbild'),
('flygfotogen','1|bränsle'),
('flygfotografi','1|flygfoto'),
('flygfrakt','1|frakt'),
('flygfä','1|insekt'),
('flygfält','1|flygplats'),
('flygfärd','1|flyga'),
('flygfärdig','1|färdig'),
('flygfärdighet','1|flygfärdig'),
('flygförare','1|flygplan'),
('flygförband','1|förband'),
('flygförbud','1|förbud'),
('flygförbudszon','1|zon'),
('flygg','1|flygfärdig'),
('flygghet','1|flygg'),
('flyghastighet','1|hastighet'),
('flyghavre','1|ogräs'),
('flyghund','1|fladdermus'),
('flyghål','1|hål'),
('flygindustri','1|industri'),
('flygkaos','1|kaos'),
('flygkapacitet','1|kapacitet'),
('flygkapning','1|kapning'),
('flygkapten','1|chef'),
('flygkatastrof','1|katastrof'),
('flygkonst','1|konst'),
('flygkorridor','1|korridor'),
('flygkropp','1|flygplan'),
('flygkår','1|förband'),
('flyglarm','1|larm'),
('flygledare','1|flygledning'),
('flygledarstrejk','1|strejk'),
('flygledes','1|flyg'),
('flygledning','1|ledning'),
('flyglinje','1|flygtrafik'),
('flyglägenhet','1|tur'),
('flygmaskin','1|flygplan'),
('flygmyra','1|myra'),
('flygning','1|flyga'),
('flygpassagerare','1|passagerare'),
('flygpersonal','1|flygplansbesättning'),
('flygplan','1|flyga'),
('flygplansbesättning','1|besättning'),
('flygplanshangar','1|hangar'),
('flygplanskabin','1|kabin'),
('flygplansluft','1|luftkvalitet'),
('flygplansmodell','1|modell'),
('flygplansroder','1|roder'),
('flygplanstillverkare','1|tillverkare'),
('flygplanstoa','1|toa'),
('flygplansvinge','1|vinge'),
('flygplats','1|plats'),
('flygplatsservering','1|servering'),
('flygpost','1|post'),
('flygresa','1|resa'),
('flygräd','1|räd'),
('flygrädd','1|rädd'),
('flygrönn','1|rönn'),
('flygrönn','1|rönn'),
('flygsand','1|sand'),
('flygsandsfält','1|fält'),
('flygskrift','1|flygblad'),
('flygstol','1|stol'),
('flygstopp','1|stopp'),
('flygstörning','1|flygkaos'),
('flygsäkerhet','1|säkerhet'),
('flygsäkerhetsexpert','1|expert'),
('flygsäkerhetskonsult','1|konsult'),
('flygtaxi','1|taxi'),
('flygterminal','1|flygplats'),
('flygtidtabell','1|tidtabell'),
('flygtrafik','1|trafik'),
('flygtrafikledare','1|trafikledare'),
('flygtrafikledning','1|flygledning'),
('flygtransport','1|transport'),
('flygtur','1|tur'),
('flygtur','2|tur'),
('flygutbildning','1|utbildning'),
('flygvapen','1|försvar'),
('flygvapenchef','1|chef'),
('flygväg','1|väg'),
('flygvärdinna','1|service'),
('flygödla','1|ödla'),
('flyhänt','1|snabb'),
('flyhänthet','1|flyhänt'),
('flykt','1|fly'),
('flykt','2|flyga'),
('flykta','1|fly'),
('flyktande','1|flykta'),
('flyktfara','1|fara'),
('flyktfordon','1|fordon'),
('flyktförsök','1|försök'),
('flyktig','1|avdunsta'),
('flyktig','2|tillfällig'),
('flyktighet','1|flyktig'),
('flyktighet','2|flyktig'),
('flykting','1|fly'),
('flyktingbarn','1|barn'),
('flyktingfamilj','1|familj'),
('flyktinggömmare','1|gömma'),
('flyktinglik','1|lik'),
('flyktingläger','1|läger'),
('flyktingmottagande','1|mottagande'),
('flyktingmottagning','1|mottagning'),
('flyktingpolitik','1|politik'),
('flyktingström','1|ström'),
('flyktmekanism','1|mekanism'),
('flyktmöjlighet','1|möjlighet'),
('flyktreaktion','1|reaktion'),
('flyktrisk','1|risk'),
('flyktväg','1|väg'),
('flyt','1|fungera'),
('flyta','1|rinna'),
('flyta','2|vatten'),
('flyta','3|flytspackla'),
('flytande','1|flyta'),
('flytande','2|flyta'),
('flytande','3|flyta'),
('flytdocka','1|docka'),
('flytetyg','1|båt'),
('flythjälp','1|hjälp'),
('flytjord','1|jord'),
('flytning','1|slem'),
('flytsand','1|kvicksand'),
('flytspackel','1|spackel'),
('flytspackla','1|flytspackel'),
('flytspacklande','1|flytspackla'),
('flytspackling','1|flytspackla'),
('flytt','1|flytta'),
('flytt','2|flytta'),
('flytta','1|röra'),
('flytta','2|bo'),
('flyttande','1|flytta'),
('flyttande','2|flytta'),
('flyttbar','1|flytta'),
('flyttbarhet','1|flyttbar'),
('flyttbestyr','1|flyttning'),
('flyttblock','1|stenblock'),
('flyttdag','1|dag'),
('flyttdag','1|dag'),
('flyttfågel','1|fågel'),
('flyttgröt','1|mat'),
('flyttkarl','1|flytta'),
('flyttkartong','1|kartong'),
('flyttlass','1|lass'),
('flyttlasspolitik','1|politik'),
('flyttlåda','1|låda'),
('flyttning','1|flytta'),
('flyttning','2|flytta'),
('flyttningsförbud','1|förbud'),
('flyttningstid','1|tid'),
('flyttningstid','1|tid'),
('flytträtt','1|rätt'),
('flyttsak','1|sak'),
('flyttstök','1|stök'),
('flytungad','1|vältalig'),
('flytungadhet','1|flytungad'),
('flytväst','1|flyta'),
('flytvästlag','1|lag'),
('flå','1|avlägsna'),
('flåbuse','1|buse'),
('flådig','1|flott'),
('flående','1|flå'),
('flåhacka','1|hacka'),
('flåhacka','2|flåhacka'),
('flåhackande','1|flåhacka'),
('flåhackning','1|flåhacka'),
('flås','1|flåsa'),
('flås','2|kondition'),
('flåsa','1|andas'),
('flåsande','1|flåsa'),
('flåsig','1|flåsa'),
('flåsning','1|flåsa'),
('flåspatos','1|patos'),
('fläck','1|märke'),
('fläck','2|yta'),
('fläcka','1|fläck'),
('fläckande','1|fläcka'),
('fläckborttagning','1|avlägsna'),
('fläckborttagningsmedel','1|medel'),
('fläckfeber','1|fläcktyfus'),
('fläckfri','1|moralisk'),
('fläckfrihet','1|fläckfri'),
('Fläckgrottan','1|grotta'),
('fläckig','1|fläck'),
('fläckig','2|fläck'),
('fläckighet','1|fläckig'),
('fläcklös','1|fläck'),
('fläcktyfus','1|sjukdom'),
('fläckvis','1|fläck'),
('fläder','1|buske'),
('fläderbär','1|bär'),
('flädermus','1|fladdermus'),
('flädermärg','1|märg'),
('flädermärgskula','1|elektricitet'),
('fläka','1|klyva'),
('fläkande','1|fläka'),
('fläkning','1|fläka'),
('fläkt','1|vind'),
('fläkt','2|apparat'),
('fläkta','1|fläkt'),
('fläktande','1|fläkta'),
('fläktning','1|fläkta'),
('flämta','1|andas'),
('flämtande','1|flämta'),
('flämtning','1|flämta'),
('fläng','1|jäkt'),
('fläng','2|galen'),
('flänga','1|fläng'),
('flänga','2|flå'),
('flängande','1|flänga'),
('flängande','2|flänga'),
('flänghet','1|fläng'),
('flängig','1|fläng'),
('flängighet','1|flängig'),
('flängning','1|flänga'),
('flängning','2|flänga'),
('fläns','1|rör'),
('flänsa','1|fläns'),
('flänsa','2|skära'),
('flänsande','1|flänsa'),
('flänsande','2|flänsa'),
('flänskniv','1|flänsa'),
('flärd','1|prakt'),
('flärdfri','1|flärd'),
('flärdfrihet','1|flärdfri'),
('flärdfull','1|flärd'),
('flärdfullhet','1|flärdfull'),
('flärdlös','1|flärd'),
('flärdlöshet','1|flärdlös'),
('flärp','1|flik'),
('flärpa','1|leksak'),
('flärpa','1|leksak'),
('fläsk','1|kött'),
('fläskfilé','1|filé'),
('fläskfärs','1|köttfärs'),
('fläskhare','1|fläskfilé'),
('fläskig','1|fet'),
('fläskighet','1|fläskig'),
('fläskkarré','1|kotlettrad'),
('fläskkorv','1|korv'),
('fläskkotlett','1|kotlett'),
('fläskkött','1|fläsk'),
('fläsklägg','1|lägg'),
('fläskläpp','1|läpp'),
('fläskpannkaka','1|maträtt'),
('fläskstycke','1|stycke'),
('fläsktärning','1|tärning'),
('fläskänger','1|skalbagge'),
('fläta','1|samman'),
('fläta','2|fläta'),
('flätande','1|fläta'),
('flätning','1|fläta'),
('flätverk','1|fläta'),
('flöda','1|rinna'),
('flödande','1|flöda'),
('flöde','1|flöda'),
('flödesdiagram','1|diagram'),
('flödesschema','1|flödesdiagram'),
('flöjel','1|vindflöjel'),
('flöjel','1|vindflöjel'),
('flöjla','1|vrida'),
('flöjlande','1|flöjla'),
('flöjt','1|blåsinstrument'),
('flöjta','1|vissla'),
('flöjtande','1|flöjta'),
('flöjtist','1|flöjt'),
('flöjtspel','1|flöjt'),
('flöjtton','1|ton'),
('flöjttravär','1|tvärflöjt'),
('flört','1|papper'),
('flört','2|uppvakta'),
('flört','2|uppvakta'),
('flörta','1|flört'),
('flörta','1|flört'),
('flörtande','1|flörta'),
('flörtande','1|flörta'),
('flörtig','1|flörta'),
('flörtig','1|flörta'),
('flörtighet','1|flörtig'),
('flörtighet','1|flörtig'),
('flörtkula','1|kula'),
('flörtlampa','1|lampa'),
('flöte','1|flyta'),
('flöts','1|lager'),
('FN','1|sammanslutning'),
('FN','1|sammanslutning'),
('FN','1|sammanslutning'),
('fnas','1|skrapa'),
('fnasig','1|fnas'),
('fnask','1|prostituerad'),
('fnaska','1|fnask'),
('fnaskande','1|fnaska'),
('fnasker','1|pojkfnasker'),
('fnatt','1|galen'),
('fnatta','1|röra'),
('fnattande','1|fnatta'),
('fniss','1|fnissa'),
('fnissa','1|skratta'),
('fnissande','1|fnissa'),
('fnissig','1|fnissa'),
('fnissighet','1|fnissig'),
('fnissning','1|fnissa'),
('fnitter','1|fnittra'),
('fnittra','1|skratta'),
('fnittrande','1|fnittra'),
('fnittrig','1|fnittra'),
('fnittrighet','1|fnittrig'),
('FN-organ','1|organ'),
('fnoskig','1|tokig'),
('fnoskighet','1|fnoskig'),
('FN-tribunal','1|tribunal'),
('fnysa','1|förakt'),
('fnysande','1|fnysa'),
('fnysning','1|fnysa'),
('fnöske','1|lättantändlig'),
('fnösksvamp','1|svamp'),
('fnöskticka','1|fnösksvamp'),
('foajé','1|hall'),
('foajé','1|hall'),
('foajé','1|hall'),
('fob','1|frakt'),
('fobi','1|fruktan'),
('fobiträning','1|avlägsna'),
('fock','1|segel'),
('focka','1|avskeda'),
('fockande','1|focka'),
('fockmast','1|mast'),
('fockning','1|focka'),
('focksegel','1|segel'),
('foder','1|mat'),
('foder','2|kläder'),
('foder','3|skydd'),
('foderbeta','1|beta'),
('foderblad','1|blomma'),
('foderbrist','1|brist'),
('foderkaka','1|foder'),
('foderlada','1|lada'),
('fodermark','1|mark'),
('fodermängd','1|mängd'),
('foderpåse','1|påse'),
('fodersäd','1|säd'),
('fodertyg','1|tyg'),
('fodervärd','1|värd'),
('fodervärde','1|näringsvärde'),
('foderväxt','1|växt'),
('fodra','1|utfodra'),
('fodra','2|foder'),
('fodra','3|foder'),
('fodral','1|förvara'),
('fodrande','1|fodra'),
('fodrande','2|fodra'),
('fodrande','3|fodra'),
('fog','1|kant'),
('fog','2|skäl'),
('foga','1|fog'),
('foga','2|tillfoga'),
('fogande','1|foga'),
('fogande','2|foga'),
('fogde','1|polis'),
('fogemorfem','1|morfem'),
('fogeord','1|konjunktion'),
('foglig','1|anpassa'),
('foglighet','1|foglig'),
('foglossning','1|bäcken'),
('fogmassa','1|massa'),
('fogning','1|foga'),
('fogskum','1|fogmassa'),
('fogspruta','1|spruta'),
('fogstryka','1|fog'),
('fogstryka','2|fila'),
('fogstrykande','1|fogstryka'),
('fogstrykande','2|fogstryka'),
('fogstrykning','1|fogstryka'),
('fogstrykning','2|fogstryka'),
('fogsvans','1|såg'),
('fokal','1|fokus'),
('fokaldistans','1|brännvidd'),
('fokalplan','1|lins'),
('fokus','1|brännpunkt'),
('fokus','1|brännpunkt'),
('fokus','2|uppmärksamhet'),
('fokusera','1|uppmärksamma'),
('fokuserande','1|fokusera'),
('fokuserbar','1|fokusera'),
('fokuserbarhet','1|fokuserbar'),
('fokusering','1|fokusera'),
('folder','1|trycksak'),
('foliant','1|bok'),
('folie','1|blad'),
('foliehatt','1|konspirationsteoretiker'),
('foliera','1|folio'),
('foliera','2|folie'),
('folierande','1|foliera'),
('folierande','2|foliera'),
('folierbar','1|foliera'),
('folierbar','2|foliera'),
('folierbarhet','1|folierbar'),
('folierbarhet','2|folierbar'),
('foliering','1|foliera'),
('foliering','2|foliera'),
('folio','1|folioformat'),
('folio','2|sidnummer'),
('folioformat','1|bok'),
('folk','1|människa'),
('folk','2|man'),
('folk','3|allmänhet'),
('folk','4|folkslag'),
('folkanda','1|anda'),
('folkarmé','1|armé'),
('folkbank','1|bank'),
('folkbibliotek','1|bibliotek'),
('folkbildande','1|folkbildning'),
('folkbildning','1|bilda'),
('folkbildningstidskrift','1|tidskrift'),
('folkbok','1|bok'),
('folkbokföra','1|bokföra'),
('folkbokförande','1|folkbokföra'),
('folkbokföring','1|register'),
('folkbokförning','1|folkbokföra'),
('folkbåt','1|segelbåt'),
('folkdans','1|dans'),
('folkdansare','1|folkdans'),
('folkdemokrati','1|folkrepublik'),
('folkdemokratisk','1|folkdemokrati'),
('folkdikt','1|dikt'),
('folkdiktning','1|diktning'),
('folkdjup','1|folklig'),
('folkdomstol','1|domstol'),
('folkdräkt','1|dräkt'),
('folketing','1|riksdag'),
('folketing','1|riksdag'),
('folketymologi','1|etymologi'),
('folketymologisk','1|folketymologi'),
('folkfest','1|fest'),
('folkfront','1|organisation'),
('folkförakt','1|förakt'),
('folkfördrivning','1|fördrivning'),
('folkförsamling','1|besluta'),
('folkförsörjning','1|försörjning'),
('folkgrupp','1|befolkningsgrupp'),
('folkhav','1|folkmassa'),
('folkhem','1|hem'),
('folkhemmet','1|välfärdssamhälle'),
('folkhemsideologi','1|ideologi'),
('folkhemsidyll','1|idyll'),
('folkhemsk','1|folkhem'),
('folkhemskoryfé','1|koryfé'),
('folkhemsnostalgi','1|nostalgi'),
('folkhemstanke','1|tanke'),
('folkhjälte','1|hjälte'),
('folkhop','1|hop'),
('folkhumor','1|humor'),
('folkhälsa','1|hälsa'),
('folkhälsoarbete','1|arbete'),
('folkhögskola','1|skola'),
('folkilsken','1|ilsken'),
('folkilskenhet','1|folkilsken'),
('folkis','1|folköl'),
('folkkommissarie','1|Sovjetryssland'),
('folkkommun','1|kommun'),
('folkkongress','1|besluta'),
('folkkonst','1|konst'),
('folkkär','1|populär'),
('folkkök','1|kök'),
('folklager','1|klass'),
('folkland','1|landskap'),
('folkledare','1|ledare'),
('folklek','1|lek'),
('folklig','1|enkel'),
('folklighet','1|folklig'),
('folkliv','1|folk'),
('folklivsforskare','1|folkliv'),
('folklivsforskning','1|vetenskap'),
('folklivsskildring','1|skildring'),
('folklore','1|kultur'),
('folklorist','1|folklore'),
('folkloristik','1|folklore'),
('folkloristisk','1|folklore'),
('folklustspel','1|lustspel'),
('folklynne','1|lynne'),
('folkmakt','1|makt'),
('folkmassa','1|massa'),
('folkmedicin','1|medicin'),
('folkmedicin','2|medicin'),
('folkmedicin','3|medicin'),
('folkmedvetande','1|medvetande'),
('folkmelodi','1|melodi'),
('folkminne','1|tradition'),
('folkminskning','1|minskning'),
('folkmord','1|mord'),
('folkmordsåtalad','1|åtala'),
('folkmusik','1|musik'),
('folkmusiker','1|folkmusik'),
('folkmål','1|dialekt'),
('folkmängd','1|antal'),
('folkmängd','2|folkmassa'),
('folkmöte','1|möte'),
('folknöje','1|nöje'),
('folkomflyttning','1|omflyttning'),
('folkomrösta','1|folkomröstning'),
('folkomröstande','1|folkomrösta'),
('folkomröstning','1|omröstning'),
('folkopinion','1|opinion'),
('folkpark','1|område'),
('folkparksorkester','1|orkester'),
('folkparti','1|parti'),
('Folkpartiet','1|parti'),
('Folkpartiet','1|parti'),
('Folkpartiet','1|parti'),
('Folkpartiet','1|parti'),
('folkpartist','1|Folkpartiet'),
('folkpartistisk','1|Folkpartiet'),
('folkpension','1|pension'),
('folkpensionär','1|folkpension'),
('folkpoesi','1|poesi'),
('folkrepresentant','1|representant'),
('folkrepresentation','1|besluta'),
('folkrepublik','1|stat'),
('folkresning','1|uppror'),
('folkrik','1|människa'),
('folkrikhet','1|folkrik'),
('folkriksdag','1|riksdag'),
('folkrädd','1|skygg'),
('folkräkning','1|räkna'),
('folkrätt','1|lag'),
('folkrättslig','1|folkrätt'),
('folkrörelse','1|rörelse'),
('folksaga','1|saga'),
('folksamling','1|folkhop'),
('folksjukdom','1|sjukdom'),
('folkskock','1|skock'),
('folkskockning','1|folkskock'),
('folkskola','1|grundskola'),
('folkskollärare','1|lärare'),
('folkskollärare','1|lärare'),
('folkskygg','1|skygg'),
('folkskygghet','1|folkskygg'),
('folkslag','1|slag'),
('folkspillra','1|spillra'),
('folkspråk','1|latin'),
('folkstam','1|folk'),
('folkstorm','1|protest'),
('folkstyre','1|styra'),
('folksång','1|sång'),
('folksägen','1|folkminne'),
('folktalare','1|talare'),
('folktandvård','1|tandvård'),
('folkteater','1|teater'),
('folkting','1|ting'),
('folktom','1|folk'),
('folktomhet','1|folktom'),
('folkton','1|folkmusik'),
('folktribun','1|ämbete'),
('folktro','1|tro'),
('folkträngsel','1|trängsel'),
('folktät','1|invånare'),
('folktäthet','1|folktät'),
('folkundervisning','1|undervisning'),
('folkuniversitet','1|studieförbund'),
('folkupplaga','1|upplaga'),
('folkupplysning','1|upplysning'),
('folkuppviglare','1|uppvigla'),
('folkvald','1|val'),
('folkvandring','1|vandring'),
('folkvandringstiden','1|period'),
('folkvett','1|förmåga'),
('folkvettsexpert','1|expert'),
('folkvilja','1|vilja'),
('folkvimmel','1|vimmel'),
('folkvisa','1|visa'),
('folkviseton','1|folkvisa'),
('folkvälde','1|välde'),
('folkvän','1|vän'),
('folkökning','1|befolkningsökning'),
('folköl','1|öl'),
('folle','1|folköl'),
('follikel','1|äggblåsa'),
('follikelstimulerande','1|stimulera'),
('fon','1|fonem'),
('fon','2|ljudstyrka'),
('fond','1|bakgrund'),
('fond','2|tillgångar'),
('fond','3|buljong'),
('fondaktie','1|aktie'),
('fondbestämmelse','1|bestämmelse'),
('fondbolag','1|bolag'),
('fondbörs','1|börs'),
('fondemission','1|emission'),
('fondera','1|fond'),
('fonderande','1|fondera'),
('fonderbar','1|fondera'),
('fonderbarhet','1|fonderbar'),
('fondering','1|fondera'),
('fondkommissionär','1|handel'),
('fondmålning','1|målning'),
('fondmäklarbransch','1|bransch'),
('fondmäklare','1|mäklare'),
('fondmäklarfirma','1|firma'),
('fondmäkleri','1|fondmäklare'),
('fondpapper','1|fondaktie'),
('fondstämpel','1|avgift'),
('fondtapet','1|tapet'),
('fondue','1|maträtt'),
('fondue','1|maträtt'),
('fonem','1|språkljud'),
('fonematisk','1|fonem'),
('fonetik','1|vetenskap'),
('fonetiker','1|fonetik'),
('fonetisk','1|språkljud'),
('foniater','1|foniatri'),
('foniatri','1|vetenskap'),
('foniatrik','1|foniatri'),
('foniatriker','1|foniater'),
('foniatrisk','1|sjukdom'),
('fonograf','1|grammofon'),
('fonogram','1|ljud'),
('fonolog','1|fonologi'),
('fonologi','1|fonetik'),
('fonologisk','1|ljudsystem'),
('fonotek','1|ljudinspelning'),
('font','1|tecken'),
('fontanell','1|springa'),
('Fontanka','1|flodarm'),
('fontän','1|spruta'),
('fontänkräkas','1|kräkas'),
('fontänkräkning','1|fontänkräkas'),
('fontänpump','1|vattenpump'),
('foppatoffel','1|sko'),
('foppatoffel','1|sko'),
('fora','1|last'),
('forcera','1|påskynda'),
('forcera','2|genomtränga'),
('forcerad','1|forcera'),
('forcerande','1|forcera'),
('forcerande','2|forcera'),
('forcerbar','1|forcera'),
('forcerbar','2|forcera'),
('forcerbarhet','1|forcerbar'),
('forcerbarhet','2|forcerbar'),
('forcering','1|forcera'),
('Ford','1|bilmärke'),
('fordom','1|tidigare'),
('fordomdags','1|fordom'),
('fordon','1|åka'),
('fordonskolonn','1|kolonn'),
('fordonsuppställning','1|uppställning'),
('fordonsuppställning','2|uppställning'),
('fordonsvikt','1|vikt'),
('fordra','1|kräva'),
('fordran','1|fordra'),
('fordrande','1|fordra'),
('fordrande','2|fordra'),
('fordras','1|fordra'),
('fordring','1|fordra'),
('fordringsfull','1|fordring'),
('fordringsfullhet','1|fordringsfull'),
('fordringslös','1|fordring'),
('fordringsägare','1|fordra'),
('fordskrälle','1|skrälle'),
('forechecka','1|ishockey'),
('forecheckande','1|forechecka'),
('forehand','1|slag'),
('forell','1|laxfisk'),
('forensisk','1|brottsutredning'),
('form','1|bilda'),
('form','2|slag'),
('form','3|forma'),
('form','4|kondition'),
('forma','1|bilda'),
('formaldehyd','1|formalin'),
('formalia','1|formalitet'),
('formalia','1|formalitet'),
('formalin','1|konservera'),
('formalisera','1|formell'),
('formaliserande','1|formalisera'),
('formaliserbar','1|formalisera'),
('formaliserbarhet','1|formaliserbar'),
('formalisering','1|formalisera'),
('formalism','1|formell'),
('formalism','2|formalisera'),
('formalist','1|formalism'),
('formalistisk','1|formalism'),
('formaliter','1|formell'),
('formalitet','1|regel'),
('formande','1|forma'),
('formant','1|tonområde'),
('formare','1|forma'),
('format','1|storlek'),
('format','2|organisation'),
('formatera','1|dataformat'),
('formaterande','1|formatera'),
('formatering','1|formatera'),
('formation','1|form'),
('formatspecifikation','1|specifikation'),
('formbakelse','1|sandbakelse'),
('formbar','1|forma'),
('formbarhet','1|formbar'),
('formbildning','1|form'),
('formbildningsproblem','1|problem'),
('formbröd','1|bröd'),
('formbunden','1|form'),
('formbundenhet','1|formbunden'),
('formel','1|formell'),
('formel','2|kemi'),
('formel','3|recept'),
('formel','4|recept'),
('formelbil','1|tävlingsbil'),
('formelenhet','1|formel'),
('formell','1|form'),
('formell','1|form'),
('formera','1|form'),
('formerande','1|formera'),
('formerbar','1|formera'),
('formerbarhet','1|formerbar'),
('formering','1|uppställning'),
('formfaktor','1|storlek'),
('formfel','1|fel'),
('formfranska','1|formbröd'),
('formfråga','1|fråga'),
('formfulländad','1|fulländad'),
('formfulländning','1|formfulländad'),
('formge','1|forma'),
('formgivande','1|formge'),
('formgivare','1|formge'),
('formgivning','1|formge'),
('formgjuta','1|gjuta'),
('formgjutande','1|formgjuta'),
('formgods','1|form'),
('formidabel','1|enorm'),
('formkurva','1|kurva'),
('formlig','1|verklig'),
('formligen','1|verkligen'),
('formlighet','1|formlig'),
('formlära','1|ordform'),
('formlös','1|form'),
('formlöshet','1|formlös'),
('formmässig','1|form'),
('formmässighet','1|formmässig'),
('formning','1|forma'),
('formord','1|innehållsord'),
('Formosa','1|Taiwan'),
('formpressa','1|form'),
('formpressande','1|formpressa'),
('formpressning','1|formpressa'),
('formrik','1|form'),
('formrikedom','1|formrik'),
('formrikhet','1|formrik'),
('formsak','1|formalitet'),
('formsand','1|form'),
('formsinne','1|sinne'),
('formskum','1|skumplast'),
('formskön','1|skön'),
('formskönhet','1|formskön'),
('formspel','1|form'),
('formspråk','1|uttryck'),
('formstark','1|i_högform'),
('formstridig','1|form'),
('formsvacka','1|svacka'),
('formula','1|beståndsdel'),
('formulera','1|uttrycka'),
('formulerande','1|formulera'),
('formulerbar','1|formulera'),
('formulerbarhet','1|formulerbar'),
('formulering','1|formulera'),
('formulär','1|fylla_i'),
('formvidrig','1|form'),
('formvidrighet','1|formvidrig'),
('forn','1|forntid'),
('fornborg','1|befästning'),
('Fornegypten','1|Egypten'),
('fornegyptier','1|Fornegypten'),
('fornegyptisk','1|egyptisk'),
('fornegyptiska','1|språk'),
('fornfolk','1|folk'),
('fornforskare','1|forskare'),
('fornforskning','1|forskning'),
('fornfynd','1|fynd'),
('forngrekisk','1|grekisk'),
('fornhet','1|forn'),
('fornisländsk','1|isländsk'),
('Fornitalien','1|Italien'),
('fornitaliensk','1|italiensk'),
('fornkeltisk','1|keltisk'),
('fornkunskap','1|arkeologi'),
('fornlämning','1|fornfynd'),
('fornminne','1|fornfynd'),
('fornminnesbrott','1|brott'),
('fornminnesförening','1|förening'),
('fornminneslag','1|lag'),
('fornminnessamling','1|samling'),
('fornminnesskylt','1|skylt'),
('fornnordisk','1|nordisk'),
('fornromersk','1|romersk'),
('fornsak','1|fornfynd'),
('fornskrift','1|skrift'),
('fornspråk','1|språk'),
('fornstor','1|stor'),
('fornsvensk','1|svensk'),
('forntid','1|gammal'),
('forntida','1|forntid'),
('forntysk','1|tysk'),
('fornvästnordisk','1|västnordisk'),
('fornyrdislag','1|versmått'),
('fors','1|strömma'),
('forsa','1|fors'),
('forsande','1|forsa'),
('forsbåt','1|båt'),
('forsfärd','1|färd'),
('forshuvud','1|fors'),
('forska','1|undersöka'),
('forskande','1|forska'),
('forskarassistent','1|universitet'),
('forskare','1|forska'),
('forskargrupp','1|grupp'),
('forskarkonspiration','1|konspiration'),
('forskarlag','1|lag'),
('forskarledighet','1|ledighet'),
('forskarmässig','1|forskare'),
('forskarutbildning','1|utbildning'),
('forskarvärlden','1|värld'),
('forskning','1|forska'),
('forskningsarbete','1|forskning'),
('forskningsbibliotek','1|bibliotek'),
('forskningscenter','1|centrum'),
('forskningsetik','1|etik'),
('forskningsetisk','1|forskningsetik'),
('forskningsfartyg','1|fartyg'),
('forskningsfinansiering','1|finansiering'),
('forskningsframsteg','1|framsteg'),
('forskningsfusk','1|fusk'),
('forskningsfält','1|fält'),
('forskningsfärd','1|färd'),
('forskningsfäste','1|fäste'),
('forskningsingenjör','1|ingenjör'),
('forskningsinriktning','1|inriktning'),
('forskningsinsats','1|insats'),
('forskningsinstitut','1|institut'),
('forskningskompetens','1|kompetens'),
('forskningskvalitet','1|kvalitet'),
('forskningslaboratorium','1|laboratorium'),
('forskningsmetodik','1|metodik'),
('forskningsmiljö','1|miljö'),
('forskningsmässig','1|forskning'),
('forskningsområde','1|område'),
('forskningsorganisation','1|organisation'),
('forskningspolitik','1|politik'),
('forskningspolitisk','1|forskningspolitik'),
('forskningsprocess','1|forskning'),
('forskningsprogram','1|program'),
('forskningsprojekt','1|projekt'),
('forskningsproposition','1|proposition'),
('forskningsresa','1|resa'),
('forskningsresande','1|expedition'),
('forskningsresultat','1|resultat'),
('forskningsråd','1|råd'),
('Forskningsrådsnämnden','1|nämnd'),
('forskningsrön','1|resultat'),
('forskningssatellit','1|satellit'),
('forskningsstation','1|station'),
('forskningsstödjande','1|stödja'),
('forskningssyfte','1|syfte'),
('forsla','1|föra'),
('forslande','1|forsla'),
('forsling','1|forsla'),
('Forsmark','1|kärnkraftverk'),
('forsränning','1|tävling'),
('forstväsen','1|skogsskötsel'),
('forsythia','1|buske'),
('forsärla','1|ärla'),
('fort','1|PRIM'),
('fort','2|fästning'),
('fortbestå','1|fortbestånd'),
('fortbestående','1|fortbestå'),
('fortbestånd','1|bestå'),
('fortbildning','1|fortbilda_sig'),
('fortbildningskurs','1|kurs'),
('forte','1|kraft'),
('forte','2|forte'),
('fortel','1|tryck'),
('fortepiano','1|piano'),
('fortfara','1|fortsätta'),
('fortfarande','1|ännu'),
('fortfarande','2|fortfara'),
('fortfärdig','1|fort'),
('fortfärdighet','1|fortfärdig'),
('fortgå','1|fortsätta'),
('fortgående','1|pågå'),
('fortgående','2|fortgå'),
('fortgång','1|fortgå'),
('fortifikation','1|befästning'),
('fortifikationsförvaltning','1|förvaltning'),
('fortifikationskår','1|kår'),
('fortis','1|konsonant'),
('fortissimo','1|forte'),
('fortissimo','2|fortissimo'),
('fortkomst','1|framgång'),
('fortköra','1|fortkörning'),
('fortkörande','1|fortköra'),
('fortkörare','1|fortkörning'),
('fortkörning','1|bilkörning'),
('fortleva','1|existera'),
('fortlevande','1|fortleva'),
('fortlöpa','1|fortlöpande'),
('fortlöpande','1|pågå'),
('fortlöpande','2|fortlöpa'),
('fortplantning','1|fortplanta_sig'),
('fortplantningsdrift','1|drift'),
('fortplantningsförmåga','1|förmåga'),
('fortplantningshastighet','1|hastighet'),
('fortplantningsmässig','1|fortplantning'),
('fortplantningsområde','1|område'),
('fortplantningsorgan','1|könsorgan'),
('fortran','1|programmeringsspråk'),
('fortsatt','1|i_fortsättningen'),
('fortskaffa','1|flytta'),
('fortskaffande','1|fortskaffa'),
('fortskaffning','1|fortskaffa'),
('fortskaffningsmedel','1|transport'),
('fortskaffningssätt','1|färdsätt'),
('fortskrida','1|fortsätta'),
('fortskridande','1|fortskrida'),
('fortskridning','1|fortskrida'),
('fortsätta','1|framåt'),
('fortsätta','2|fortsätta'),
('fortsättande','1|fortsätta'),
('fortsättande','2|fortsätta'),
('fortsättare','1|fortsätta'),
('fortsättning','1|fortsätta'),
('fortsättningskriget','1|krig'),
('fortsättningsskola','1|folkskola'),
('fortsättningsvis','1|fortsätta'),
('Fortuna','1|gudinna'),
('fortuna','1|spel'),
('fortvara','1|fortvaro'),
('fortvarande','1|fortvara'),
('fortvaro','1|existera'),
('forum','1|plats'),
('forumtidning','1|tidning'),
('forward','1|anfallsspelare'),
('fosfat','1|konstgödsel'),
('fosfatera','1|grundbehandla'),
('fosfaterande','1|fosfatera'),
('fosfaterbar','1|fosfatera'),
('fosfaterbarhet','1|fosfaterbar'),
('fosfatering','1|fosfatera'),
('fosfor','1|grundämne'),
('fosfor','1|grundämne'),
('fosforescens','1|fosforescera'),
('fosforescent','1|fosforescera'),
('fosforescera','1|självlysande'),
('fosforescerande','1|fosforescera'),
('fosforescering','1|fosforescera'),
('fosforit','1|apatit'),
('fosforsyra','1|syra'),
('fosforsyracell','1|cell'),
('fosforutsläpp','1|utsläpp'),
('fosgen','1|stridsgas'),
('fossil','1|rest'),
('fossil','2|kvarleva'),
('fossil','3|fossil'),
('fossilbransch','1|bransch'),
('fossilbränsle','1|bränsle'),
('fossilfri','1|miljövänlig'),
('fossilfynd','1|fynd'),
('fossilförsäljning','1|försäljning'),
('fossilgas','1|naturgas'),
('fossilgasledning','1|gasledning'),
('fossilgasnät','1|nät'),
('fossilisation','1|fossilisera'),
('fossilisera','1|fossil'),
('fossiliserande','1|fossilisera'),
('fossiliserbar','1|fossilisera'),
('fossiliserbarhet','1|fossiliserbar'),
('fossilisering','1|fossilisera'),
('fossiljägare','1|fossilletare'),
('fossilletande','1|letande'),
('fossilletare','1|leta'),
('fossilletarexpedition','1|expedition'),
('fossilminskning','1|minskning'),
('fossilsamling','1|samling'),
('fossing','1|fot'),
('fostbrödralag','1|vänskap'),
('foster','1|barn'),
('fosterbarn','1|barn'),
('fosterbror','1|bror'),
('fosterdotter','1|fosterbarn'),
('fosterfamilj','1|fosterhem'),
('fosterfar','1|far'),
('fosterfördrivning','1|abort'),
('fosterförälder','1|förälder'),
('fosterhem','1|hem'),
('fosterhinna','1|hinna'),
('fosterjord','1|fosterland'),
('fosterland','1|land'),
('fosterlandsförrädare','1|förrädare'),
('fosterlandsförsvarare','1|försvarare'),
('fosterlandskärlek','1|kärlek'),
('fosterlandssinnad','1|patriot'),
('fosterlandsvän','1|vän'),
('fosterlandsälskande','1|fosterland'),
('fosterljud','1|hjärtljud'),
('fosterläge','1|läge'),
('fosterländsk','1|fosterland'),
('fosterländskhet','1|fosterländsk'),
('fostermor','1|mor'),
('fosterskada','1|skada'),
('fosterson','1|fosterbarn'),
('fosterställning','1|fosterläge'),
('fostersyskon','1|syskon'),
('fostersyster','1|syster'),
('fostertest','1|test'),
('fosterutveckling','1|utveckling'),
('fostervatten','1|foster'),
('fostra','1|uppfostra'),
('fostran','1|fostra'),
('fostrande','1|fostra'),
('fostrare','1|uppfostra'),
('fot','1|kroppsdel'),
('fot','2|mått'),
('fot','3|nere'),
('fota','1|grunda'),
('fota','2|sparka'),
('fotabjälle','1|fot'),
('fotande','1|fota'),
('fotande','2|fota'),
('fotangel','1|spikhinder'),
('fotarbete','1|boxning'),
('fotavtryck','1|fotspår'),
('fotbad','1|bad'),
('fotbeklädnad','1|sko'),
('fotbjudning','1|fosterläge'),
('fotblad','1|fotsula'),
('fotboja','1|straff'),
('fotboll','1|sport'),
('fotboll','2|boll'),
('fotbollsarena','1|fotbollsplan'),
('fotbollsbråk','1|bråk'),
('fotbollsdomare','1|domare'),
('fotbollsdominerad','1|dominera'),
('fotbollsexpert','1|expert'),
('fotbollsfeber','1|feber'),
('fotbollsförbund','1|förbund'),
('fotbollsförbund','1|förbund'),
('fotbollshuligan','1|huligan'),
('fotbollskedja','1|fotboll'),
('fotbollskrig','1|krig'),
('fotbollslag','1|lag'),
('fotbollslandslag','1|landslag'),
('fotbollsledare','1|ledare'),
('fotbollsläktare','1|läktare'),
('fotbollsmatch','1|match'),
('fotbollsmål','1|mål'),
('fotbollsmässig','1|fotboll'),
('fotbollsplan','1|plan'),
('fotbollsspelande','1|fotboll'),
('fotbollsspelande','2|fotboll'),
('fotbollsspelare','1|spelare'),
('fotbollsstadion','1|stadion'),
('fotbollsstjärna','1|stjärna'),
('fotbollstips','1|tips'),
('fotbollstokig','1|tokig'),
('fotbollstränare','1|tränare'),
('fotbollsturnering','1|turnering'),
('fotbollstuta','1|vuvuzela'),
('fotbollsvärlden','1|värld'),
('fotbroms','1|broms'),
('fotfel','1|tennis'),
('fotfolk','1|infanterist'),
('fotfäste','1|bas'),
('fotgängare','1|gå'),
('fotino','1|ljuspartikel'),
('fotknöl','1|ankel'),
('fotknölssågning','1|såga_jäms_med_fotknölarna'),
('fotled','1|led'),
('fotlist','1|list'),
('fotnot','1|anmärkning'),
('foto','1|fotografi'),
('fotoaffär','1|affär'),
('fotoateljé','1|ateljé'),
('fotoautomat','1|automat'),
('fotoblixt','1|blixt'),
('fotocell','1|registrera'),
('fotoelektricitet','1|elektricitet'),
('fotoelektrisk','1|fotoelektricitet'),
('fotogen','1|bränsle'),
('fotogendunk','1|dunk'),
('fotogenique','1|fotogenisk'),
('fotogenisk','1|utseende'),
('fotogenkök','1|spis'),
('fotogenlampa','1|lampa'),
('fotogenmotor','1|motor'),
('fotograf','1|fotografera'),
('fotografera','1|bild'),
('fotograferande','1|fotografera'),
('fotograferbar','1|fotografera'),
('fotograferbarhet','1|fotograferbar'),
('fotografering','1|fotografera'),
('fotografi','1|bild'),
('fotografik','1|grafik'),
('fotografiplåt','1|fotografi'),
('fotografisk','1|fotografi'),
('fotogram','1|fotogrammetri'),
('fotogrammetri','1|vetenskap'),
('fotogrammetrisk','1|mäta'),
('fotogravyr','1|djuptryck'),
('fotohandlare','1|fotoaffär'),
('fotointresse','1|intresse'),
('fotokarriär','1|karriär'),
('fotokarta','1|karta'),
('fotokemi','1|vetenskap'),
('fotokemisk','1|kemisk'),
('fotokonst','1|konst'),
('fotokopia','1|fotostatkopia'),
('fotokopiera','1|fotokopia'),
('fotokopierande','1|fotokopiera'),
('fotokopierbar','1|fotokopiera'),
('fotokopierbarhet','1|fotokopierbar'),
('fotokopiering','1|fotokopiera'),
('fotolitografi','1|litografi'),
('fotometer','1|mäta'),
('fotometri','1|fotometer'),
('fotomodell','1|mannekäng'),
('fotomontage','1|montage'),
('foton','1|partikel'),
('fotopris','1|pris'),
('fotoresistor','1|resistor'),
('fotosfär','1|yta'),
('fotostatkopia','1|kopia'),
('fotostatkopiera','1|fotostatkopiering'),
('fotostatkopierande','1|fotostatkopiera'),
('fotostatkopierbar','1|fotostatkopiera'),
('fotostatkopierbarhet','1|fotostatkopierbar'),
('fotostatkopiering','1|fotostatkopia'),
('fotosyntes','1|syntes'),
('fotosättning','1|tryck'),
('fotpall','1|pall'),
('fotpanel','1|panel'),
('fotpedal','1|pedal'),
('fotplatta','1|fotstöd'),
('fotriktig','1|passa'),
('fotriktighet','1|fotriktig'),
('foträt','1|korrekt'),
('fotsack','1|täcke'),
('fotsid','1|lång'),
('fotskada','1|skada'),
('fotskrapa','1|skrapa'),
('fotsoldat','1|infanterist'),
('fotspår','1|spår'),
('fotsteg','1|kliva'),
('fotsteg','2|trappsteg'),
('fotställning','1|ställning'),
('fotställning','2|ställning'),
('fotstöd','1|stöd'),
('fotsula','1|fot'),
('fotsvett','1|svett'),
('fottvagning','1|tvätta'),
('fotvalv','1|hålfot'),
('fotvandra','1|vandra'),
('fotvandrande','1|fotvandra'),
('fotvandrare','1|fotvandra'),
('fotvandring','1|fotvandra'),
('fotvård','1|vård'),
('fotvårdssalong','1|fotvård'),
('fotvårta','1|vårta'),
('fotvänlig','1|fotriktig'),
('fotvänlighet','1|fotvänlig'),
('fotända','1|säng'),
('fotända','1|säng'),
('foul','1|regelbrott'),
('foulard','1|vävnad'),
('foxterrier','1|hundras'),
('foxtrot','1|dans'),
('foxtrot','1|dans'),
('foxtrottakt','1|takt'),
('frack','1|kläder'),
('frackklädd','1|frack'),
('fradga','1|skum'),
('fradga','2|fradga'),
('fradgande','1|fradga'),
('fradgig','1|fradga'),
('fragil','1|bräcklig'),
('fragment','1|del'),
('fragmentarisk','1|fullständig'),
('fragmentera','1|fragment'),
('fragmentera','1|fragment'),
('fragmenterande','1|fragmentera'),
('fragmenterande','1|fragmentera'),
('fragmenterbar','1|fragmentera'),
('fragmenterbar','1|fragmentera'),
('fragmenterbarhet','1|fragmenterbar'),
('fragmenterbarhet','1|fragmenterbar'),
('fragmentering','1|fragmentera'),
('fragmentering','1|fragmentera'),
('frakt','1|frakta'),
('frakta','1|forsla'),
('fraktal','1|matematik'),
('fraktande','1|frakta'),
('fraktavtal','1|avtal'),
('fraktbolag','1|bolag'),
('fraktfirma','1|firma'),
('fraktfri','1|fraktkostnad'),
('fraktgods','1|gods'),
('fraktion','1|åsikt'),
('fraktion','2|destillering'),
('fraktionera','1|fraktion'),
('fraktionerande','1|fraktionera'),
('fraktionerbar','1|fraktionera'),
('fraktionerbarhet','1|fraktionerbar'),
('fraktionering','1|fraktionera'),
('fraktionism','1|splittring'),
('fraktjätte','1|fraktfirma'),
('fraktkostnad','1|kostnad'),
('fraktsats','1|sats'),
('fraktsedel','1|dokument'),
('fraktterminal','1|terminal'),
('fraktur','1|tryck'),
('fraktur','2|benbrott'),
('frakturstil','1|fraktur'),
('fralla','1|franskbröd'),
('fram','1|framme'),
('fram','2|framme'),
('fram','3|framme'),
('framavla','1|avla'),
('framavla','1|avla'),
('framavlande','1|framavla'),
('framaxel','1|axel'),
('framben','1|ben'),
('frambesvärja','1|framkalla'),
('frambesvärjande','1|frambesvärja'),
('frambesvärjning','1|frambesvärja'),
('frambringa','1|skapa'),
('frambringande','1|frambringa'),
('frambringare','1|frambringa'),
('frambrytande','1|bryta_fram'),
('frambära','1|bära'),
('frambärande','1|frambära'),
('framdel','1|del'),
('framdeles','1|i_fortsättningen'),
('framdragning','1|dra_fram'),
('framdriva','1|driva'),
('framdrivande','1|framdriva'),
('framdrivning','1|framdriva'),
('framemot','1|mot'),
('FrameNet','1|lexikon'),
('framextremitet','1|extremitet'),
('framfall','1|organ'),
('framfarande','1|fara_fram'),
('framfaren','1|fara_fram'),
('framfart','1|våldsam'),
('framficka','1|ficka'),
('framflytta','1|flytta'),
('framflyttande','1|framflytta'),
('framflyttning','1|flytta_fram'),
('framflyttning','2|framflytta'),
('framforsling','1|forsla_fram'),
('framfot','1|fot'),
('framfusig','1|fräck'),
('framfusighet','1|framfusig'),
('framfärd','1|resa'),
('framföda','1|föda'),
('framfödande','1|framföda'),
('framför','1|framme'),
('framföra','1|säga'),
('framföra','1|säga'),
('framföra','2|framförande'),
('framföra','3|köra'),
('framförallt','1|främst'),
('framförallt','1|främst'),
('framförande','1|skådespel'),
('framförande','2|framföra'),
('framförande','3|framföra'),
('framförande','4|framföra'),
('framförhandla','1|förhandla'),
('framförhandlande','1|framförhandla'),
('framförhandling','1|framförhandla'),
('framförhållning','1|planera'),
('framförsittande','1|sitta'),
('framförvarande','1|framför'),
('framgaffel','1|framhjul'),
('framgent','1|fortsättningsvis'),
('framglidning','1|glida'),
('framgå','1|visa_sig'),
('framgående','1|framgå'),
('framgång','1|lyckas'),
('framgångsevangelist','1|evangelist'),
('framgångshets','1|hets'),
('framgångshistoria','1|historia'),
('framgångskoncept','1|koncept'),
('framgångsrecept','1|recept'),
('framgångsrik','1|framgång'),
('framgångsrikhet','1|framgångsrik'),
('framgångssaga','1|framgång'),
('framgångsteologi','1|teologi'),
('framgångsvind','1|framgång'),
('framhjul','1|hjul'),
('framhjulsdriven','1|driva'),
('framhov','1|hov'),
('framhålla','1|säga'),
('framhållande','1|framhålla'),
('framhämtning','1|hämta_fram'),
('framhärda','1|envis'),
('framhärdande','1|framhärda'),
('framhäva','1|framhålla'),
('framhävande','1|framhäva'),
('framifrån','1|från'),
('framimproviserad','1|improvisera'),
('framkalla','1|förorsaka'),
('framkalla','2|fotografi'),
('framkallande','1|framkalla'),
('framkallande','2|framkalla'),
('framkallare','1|framkalla'),
('framkallning','1|framkalla'),
('framkallningsapparat','1|apparat'),
('framkant','1|kant'),
('framkasta','1|yttra'),
('framkasta','1|yttra'),
('framkastande','1|framkasta'),
('framkläckning','1|kläcka'),
('framknuffning','1|knuffa_fram'),
('framkomlig','1|köra'),
('framkomlighet','1|framkomlig'),
('framkomma','1|avslöja'),
('framkomma','1|avslöja'),
('framkommande','1|framkomma'),
('framkomst','1|ankomst'),
('framkomst','2|framkomlighet'),
('framkonstruering','1|konstruera'),
('framkropp','1|kropp'),
('framkrystning','1|krysta_fram'),
('framkörning','1|taxi'),
('framladdare','1|framladdning'),
('framladdning','1|ladda'),
('framlagd','1|lägga_fram'),
('framleva','1|leva'),
('framlevande','1|framleva'),
('framlida','1|avlida'),
('framlidande','1|framlida'),
('framliden','1|sen'),
('framlob','1|pannlob'),
('framlockning','1|locka_fram'),
('framläggande','1|lägga_fram'),
('framläggning','1|lägga_fram'),
('framlämning','1|lämna_fram'),
('framlänges','1|fram'),
('framläspning','1|läspa_fram'),
('frammana','1|framkalla'),
('frammanande','1|frammana'),
('frammaning','1|frammana'),
('frammarsch','1|marsch'),
('frammatning','1|mata_fram'),
('framme','1|PRIM'),
('framme','2|här'),
('framme','3|till'),
('frammmatande','1|mata_fram'),
('frammumla','1|mumla'),
('frammumlande','1|frammumla'),
('frammumling','1|frammumla'),
('framom','1|framför'),
('framorkestrerad','1|orkestrera'),
('framplockning','1|plocka_fram'),
('frampressa','1|pressa'),
('frampressning','1|frampressa'),
('frampå','1|framtill'),
('frampå','2|under'),
('framropning','1|ropa_fram'),
('framrusande','1|rusa'),
('framryckning','1|rycka'),
('framräckning','1|räcka_fram'),
('framröstad','1|rösta_fram'),
('framsida','1|sida'),
('framsippring','1|sippra_fram'),
('framskaffning','1|skaffa_fram'),
('framskina','1|antyda'),
('framskinande','1|framskina'),
('framskjuta','1|skjuta'),
('framskjutande','1|utskjutande'),
('framskjutande','2|framskjuta'),
('framskjuten','1|ställning'),
('framskjutning','1|framskjuta'),
('framskrida','1|skrida'),
('framskrida','2|förflyta'),
('framskridande','1|framskrida'),
('framskridande','2|framskrida'),
('framskriden','1|sen'),
('framskuffning','1|skuffa_fram'),
('framskymta','1|skymta'),
('framskymtande','1|framskymta'),
('framslungning','1|slunga_fram'),
('framsläpning','1|släpa_fram'),
('framsläppning','1|släppa'),
('framsnyftning','1|snyfta_fram'),
('framsparkning','1|sparka_fram'),
('framspelad','1|spela_fram'),
('framspelare','1|framspelning'),
('framspelning','1|passa'),
('framspringande','1|framskjutande'),
('framstam','1|förstäv'),
('framstamning','1|stamma_fram'),
('framsteg','1|utveckla'),
('framstegsanda','1|anda'),
('framstegsman','1|framsteg'),
('framstegsoptimism','1|optimism'),
('framstegsparti','1|parti'),
('Framstegspartiet','1|parti'),
('framstegstro','1|tro'),
('framstegsvänlig','1|framsteg'),
('framstegsvänlighet','1|framstegsvänlig'),
('framstjärt','1|slida'),
('framstupa','1|stupa'),
('framstycke','1|framsida'),
('framstå','1|visa_sig'),
('framstående','1|viktig'),
('framstående','2|framstå'),
('framställa','1|säga'),
('framställa','2|tillverka'),
('framställan','1|begäran'),
('framställande','1|framställa'),
('framställande','2|framställa'),
('framställning','1|framställa'),
('framställning','2|framställa'),
('framställningsförmåga','1|förmåga'),
('framställningskonst','1|framställa'),
('framställningssätt','1|framställa'),
('framstörtning','1|störta_fram'),
('framstöt','1|anfall'),
('framstötning','1|framstöt'),
('framsynt','1|förutseende'),
('framsynthet','1|framsynt'),
('framsäga','1|säga'),
('framsägande','1|framsäga'),
('framsägning','1|framsäga'),
('framsäte','1|bilsäte'),
('framsättning','1|sätta_fram'),
('framtagning','1|ta_fram'),
('framtagning','2|ta_fram'),
('framtand','1|tand'),
('framtass','1|tass'),
('framtid','1|tid'),
('framtida','1|framtid'),
('framtidsbild','1|framtidsvy'),
('framtidsbransch','1|bransch'),
('framtidsdröm','1|dröm'),
('framtidsforskare','1|forskare'),
('framtidsforskning','1|forskning'),
('framtidsfråga','1|fråga'),
('framtidsförutsägelse','1|spådom'),
('framtidsinriktad','1|inrikta'),
('framtidskalkyl','1|kalkyl'),
('framtidsland','1|land'),
('framtidslöfte','1|person'),
('framtidsman','1|person'),
('framtidsmål','1|mål'),
('framtidsorienterad','1|framtidsinriktad'),
('framtidsplan','1|plan'),
('framtidssatsning','1|satsning'),
('framtidsscenario','1|scenario'),
('framtidsspaning','1|spaning'),
('framtidssyn','1|framtidsvision'),
('framtidstanke','1|tanke'),
('framtidstro','1|tro'),
('framtidsutsikt','1|utsikt'),
('framtidsversion','1|framtidsvision'),
('framtidsvision','1|vision'),
('framtidsvy','1|vy'),
('framtill','1|framme'),
('framtona','1|synas'),
('framtona','1|synas'),
('framtonande','1|framtona'),
('framtoning','1|framtona'),
('framtrollning','1|trolla_fram'),
('framträda','1|visa_sig'),
('framträdande','1|framträda'),
('framträdande','2|viktig'),
('framtränga','1|tränga'),
('framträngande','1|framtränga'),
('framträngande','2|framtränga'),
('framtung','1|tung'),
('framtunghet','1|framtung'),
('framtvinga','1|tvinga'),
('framtvingande','1|framtvinga'),
('framvagn','1|bil'),
('framvinge','1|vinge'),
('framvisa','1|visa'),
('framvisande','1|framvisa'),
('framviskning','1|viska_fram'),
('framvisning','1|framvisa'),
('framvältring','1|vältra_fram'),
('framväxa','1|växa'),
('framväxande','1|framväxa'),
('framväxt','1|framväxa'),
('framåt','1|fram'),
('framåt','2|framåt'),
('framåtanda','1|anda'),
('framåtblickande','1|blicka'),
('framåtböjd','1|böjd'),
('framåtlutad','1|luta'),
('framåtriktad','1|rikta'),
('framåtskridande','1|utveckla'),
('framåtsträvande','1|sträva'),
('framåtsyftande','1|syfta'),
('framända','1|ände'),
('framända','1|ände'),
('framöver','1|efter'),
('franc','1|myntenhet'),
('franchising','1|arrendera'),
('Franciscus','1|helgon'),
('franciskan','1|franciskanermunk'),
('franciskanerkloster','1|kloster'),
('franciskanerkloster','1|kloster'),
('franciskanermunk','1|munk'),
('franciskanerorden','1|klosterorden'),
('franciskanerorden','1|klosterorden'),
('francium','1|grundämne'),
('francium','1|grundämne'),
('frangulabark','1|bark'),
('frank','1|uppriktig'),
('Frankenstein','1|monster'),
('Frankenstein','1|monster'),
('franker','1|folk'),
('frankera','1|frimärke'),
('frankerande','1|frankera'),
('frankerbar','1|frankera'),
('frankerbarhet','1|frankerbar'),
('frankering','1|frankera'),
('Frankfort','1|huvudstad'),
('Frankfurt','1|stad'),
('frankhet','1|frank'),
('frankisk','1|franker'),
('frankist','1|Franco'),
('franko','1|portofri'),
('frankostämpel','1|stämpel'),
('frankotecken','1|tecken'),
('Frankrike','1|land'),
('frans','1|kant'),
('fransa','1|frans'),
('fransad','1|frans'),
('fransande','1|fransa'),
('fransförsedd','1|frans'),
('fransig','1|sliten'),
('fransighet','1|fransig'),
('fransk','1|Frankrike'),
('fransk','2|franska'),
('franska','1|språk'),
('franska','2|franskbröd'),
('franskbröd','1|bröd'),
('franskfödd','1|född'),
('franskhet','1|fransk'),
('franskklassicism','1|klassicism'),
('franskklassicistisk','1|franskklassicism'),
('franskklassisk','1|franskklassicism'),
('franskkurs','1|kurs'),
('franskkurs','1|kurs'),
('fransklektion','1|lektion'),
('fransklektion','1|lektion'),
('fransklärare','1|lärare'),
('fransklärare','1|lärare'),
('franskspråkig','1|franska'),
('franskspråkighet','1|franskspråkig'),
('franskstyrd','1|styra'),
('fransktalande','1|franska'),
('franskundervisning','1|undervisning'),
('fransman','1|Frankrike'),
('fransos','1|fransman'),
('fransyska','1|fransman'),
('fransäs','1|dans'),
('frappant','1|frappera'),
('frappera','1|slå'),
('frapperande','1|frappera'),
('frapperande','2|frappera'),
('frappering','1|frappera'),
('fras','1|säga'),
('fras','2|frasa'),
('fras','3|ord'),
('fras','4|konstituent'),
('frasa','1|låta'),
('frasande','1|frasa'),
('fraseologi','1|fras'),
('fraseologisk','1|fraseologi'),
('frasera','1|paus'),
('fraserande','1|frasera'),
('fraserbar','1|frasera'),
('fraserbarhet','1|fraserbar'),
('frasering','1|frasera'),
('frasig','1|luftig'),
('frasliberal','1|liberal'),
('frasliberal','2|frasliberal'),
('frasmakare','1|fras'),
('frasmakeri','1|struntprat'),
('frasnät','1|lexikon'),
('frasradikal','1|radikal'),
('frasradikal','2|frasradikal'),
('frasridå','1|ridå'),
('Frasse','1|smeknamn'),
('frasvåffla','1|våffla'),
('frat','1|råtthål'),
('fraternisera','1|umgås'),
('fraterniserande','1|fraternisera'),
('fraternisering','1|fraternisera'),
('freak','1|intresserad'),
('fred','1|lugn'),
('freda','1|skydda'),
('fredag','1|dag'),
('fredag','1|dag'),
('fredag','1|dag'),
('fredagsbilaga','1|tidningsbilaga'),
('fredagsbön','1|bön'),
('fredagsbörs','1|börs'),
('fredagseftermiddag','1|eftermiddag'),
('fredagseftermiddag','1|eftermiddag'),
('fredagskväll','1|kväll'),
('fredagskväll','1|kväll'),
('fredagsmiddag','1|middag'),
('fredagsmorgon','1|morgon'),
('fredagsmorgon','1|morgon'),
('fredagsmys','1|mys'),
('fredagsöl','1|öl'),
('fredande','1|freda'),
('fredframtvingande','1|framtvinga'),
('fredlig','1|fred'),
('fredlighet','1|fredlig'),
('fredlös','1|skydd'),
('fredlöshet','1|fredlös'),
('Fredrika-Bremer-Förbundet','1|kvinnorörelse'),
('Fredrikshald','1|ihjälskjuten'),
('fredsaktivist','1|aktivist'),
('fredsavtal','1|fredsfördrag'),
('fredsbefrämjande','1|befrämja'),
('fredsbevarande','1|bevara'),
('fredsbrott','1|bryta'),
('fredsdomare','1|domare'),
('fredsdomstol','1|domstol'),
('fredsduva','1|symbol'),
('fredsflagga','1|flagga'),
('fredsforskning','1|forskning'),
('fredsfrämjande','1|fredsbefrämjande'),
('fredsfördrag','1|fördrag'),
('fredsförening','1|förening'),
('fredsförhandlare','1|fredsförhandling'),
('fredsförhandling','1|förhandling'),
('fredsförslag','1|förslag'),
('fredskonferens','1|konferens'),
('fredskongress','1|kongress'),
('fredskår','1|kår'),
('fredsmäklare','1|mäkla'),
('fredsmäkling','1|mäkla'),
('fredspipa','1|pipa'),
('fredsplikt','1|plikt'),
('fredspris','1|nobelpris'),
('fredspristagare','1|fredspris'),
('fredspristagarfavorit','1|favorit'),
('fredsprisval','1|val'),
('fredsprocess','1|sluta_fred'),
('fredsrörelse','1|rörelse'),
('fredssamtal','1|samtal'),
('fredsskapande','1|skapa'),
('fredsslut','1|sluta'),
('fredsstiftare','1|stifta'),
('fredssträvan','1|strävan'),
('fredssträvande','1|strävan'),
('fredsstyrka','1|styrka'),
('fredstid','1|tid'),
('fredstida','1|fredstid'),
('fredstraktat','1|traktat'),
('fredsuppdrag','1|utlandsuppdrag'),
('fredsvillkor','1|villkor'),
('fredsvän','1|tycka_om'),
('fredsvänlig','1|fredsälskande'),
('fredsvänlighet','1|fredsvänlig'),
('fredsår','1|år'),
('fredsälskande','1|tycka_om'),
('fredsängel','1|ängel'),
('fredsöverenskommelse','1|fredsfördrag'),
('free-style','1|kassettbandspelare'),
('free-style','1|kassettbandspelare'),
('fregatt','1|segelfartyg'),
('fregattfågel','1|pelikan'),
('Freiburg','1|stad'),
('Frej','1|gud'),
('Freja','1|gudinna'),
('frejd','1|anseende'),
('frejdad','1|berömd'),
('frejdig','1|modig'),
('frejdighet','1|frejdig'),
('frekvens','1|ofta'),
('frekvensband','1|frekvensområde'),
('frekvensmodulera','1|frekvensmodulering'),
('frekvensmodulerande','1|frekvensmodulera'),
('frekvensmodulerbar','1|frekvensmodulera'),
('frekvensmodulerbarhet','1|frekvensmodulerbar'),
('frekvensmodulering','1|modulering'),
('frekvensområde','1|område'),
('frekvenspolygon','1|diagram'),
('frekvent','1|frekvens'),
('frekventera','1|besöka'),
('frekventerande','1|frekventera'),
('frekventerbar','1|frekventera'),
('frekventerbarhet','1|frekventerbar'),
('frekventering','1|frekventera'),
('frenesi','1|iver'),
('frenetisk','1|frenesi'),
('frenolog','1|frenologi'),
('frenologi','1|vetenskap'),
('frenologisk','1|själsegenskap'),
('freon','1|gas'),
('fresia','1|växt'),
('fresk','1|målning'),
('freskomålare','1|freskomålning'),
('freskomålning','1|fresk'),
('fresta','1|locka'),
('fresta','2|anstränga'),
('frestad','1|fresta'),
('frestande','1|fresta'),
('frestande','2|fresta'),
('frestande','3|fresta'),
('frestare','1|fresta'),
('frestelse','1|fresta'),
('freudiansk','1|Freud'),
('fri','1|röra_sig'),
('fri','2|gratis'),
('fri','3|utan'),
('fri','4|fången'),
('fri','5|hinder'),
('fria','1|gifta_sig'),
('fria','2|frikänna'),
('friande','1|fria'),
('friande','2|fria'),
('friarbrev','1|brev'),
('friare','1|fria'),
('friarfärd','1|färd'),
('fribiljett','1|biljett'),
('fribladig','1|kronblad'),
('fribonde','1|bonde'),
('fribord','1|bord'),
('friboren','1|född'),
('fribrev','1|befria'),
('fribrottare','1|fribrottning'),
('fribrottning','1|brottning'),
('fribytare','1|fribyteri'),
('fribytarskara','1|fribytare'),
('fribyteri','1|sjöröveri'),
('fribärande','1|stöd'),
('frid','1|ro'),
('fridag','1|dag'),
('fridfull','1|frid'),
('fridfullhet','1|fridfull'),
('fridlysa','1|skydda'),
('fridlysande','1|fridlysa'),
('fridlysning','1|fridlysa'),
('fridlös','1|frid'),
('fridlöshet','1|fridlös'),
('fridsam','1|frid'),
('fridsamhet','1|fridsam'),
('fridskränkning','1|kränkning'),
('fridstörande','1|fridstörare'),
('fridstörare','1|störa'),
('frieri','1|fria'),
('friexemplar','1|exemplar'),
('frifräsare','1|frifräsig'),
('frifräsig','1|frispråkig'),
('frifräsighet','1|frifräsig'),
('friförsamling','1|församling'),
('frige','1|fri'),
('friggebod','1|stuga'),
('frigid','1|kall'),
('frigiditet','1|frigid'),
('frigivande','1|frige'),
('frigivning','1|frige'),
('frigivningsnämnd','1|nämnd'),
('frigivningsvillkor','1|villkor'),
('frigjord','1|fri'),
('frigjordhet','1|frigjord'),
('frigående','1|fri'),
('frigång','1|fri'),
('frigång','2|urkopplad'),
('frigöra','1|fri'),
('frigörande','1|frigöra'),
('frigörare','1|frigöra'),
('frigörelse','1|frigöra'),
('frihamn','1|hamn'),
('frihandel','1|handel'),
('frihandelsfördrag','1|fördrag'),
('frihandelsförhandling','1|förhandling'),
('frihandelsområde','1|område'),
('frihandelsvänlig','1|sympatisera'),
('frihandelszon','1|zon'),
('frihandsteckning','1|teckning'),
('friherre','1|adelsman'),
('friherrlig','1|friherre'),
('frihet','1|fri'),
('frihetlig','1|frihet'),
('frihetlighet','1|frihetlig'),
('frihetsanda','1|anda'),
('frihetsapostel','1|apostel'),
('frihetsbegär','1|frihetslängtan'),
('frihetsberöva','1|beröva'),
('frihetsberövande','1|frihetsberöva'),
('frihetsberövning','1|frihetsberöva'),
('frihetsbrev','1|försäkran'),
('frihetsfientlig','1|frihet'),
('frihetsförkvävande','1|förkväva'),
('frihetsförlust','1|förlust'),
('frihetsgrad','1|mått'),
('Frihetsgudinnan','1|staty'),
('frihetshjälte','1|hjälte'),
('frihetskamp','1|kamp'),
('frihetskrig','1|krig'),
('frihetskämpe','1|frihetskamp'),
('frihetslängtan','1|längtan'),
('frihetslängtande','1|längta'),
('frihetsstraff','1|fängelsestraff'),
('frihetsstrid','1|strid'),
('frihetssträvande','1|strävande'),
('frihetssymbol','1|symbol'),
('frihetstiden','1|period'),
('frihetsälskande','1|älska'),
('frihjul','1|hjul'),
('friholt','1|fartyg'),
('friholt','1|fartyg'),
('friidrott','1|idrott'),
('friidrottare','1|friidrott'),
('friidrottsförbund','1|förbund'),
('friidrottslandslag','1|landslag'),
('frikadell','1|köttbulle'),
('frikalla','1|befria'),
('frikallande','1|frikalla'),
('frikallelse','1|frikalla'),
('frikassé','1|maträtt'),
('frikast','1|kast'),
('frikativ','1|konsonant'),
('frikativa','1|frikativ'),
('frikoppla','1|koppla'),
('frikopplande','1|frikoppla'),
('frikoppling','1|frikoppla'),
('frikort','1|fribiljett'),
('frikostig','1|generös'),
('frikostighet','1|frikostig'),
('frikrets','1|fack'),
('friktion','1|glida'),
('friktionsfri','1|friktion'),
('friktionskoefficient','1|koefficient'),
('friktionstal','1|grad'),
('friktionsvärme','1|värme'),
('friktionsväxling','1|växel'),
('frikyrka','1|kyrka'),
('frikyrklig','1|frikyrka'),
('frikyrklighet','1|frikyrklig'),
('frikyrkoförsamling','1|församling'),
('frikyrkopastor','1|pastor'),
('frikyrkorörelse','1|frikyrka'),
('frikår','1|förband'),
('frikänna','1|oskyldig'),
('frikännande','1|frikänna'),
('frikännelse','1|frikänna'),
('friköp','1|friköpa'),
('friköpa','1|köpa'),
('friköpande','1|friköpa'),
('friköpning','1|friköpa'),
('friland','1|odla'),
('frilans','1|uppdrag'),
('frilans','1|uppdrag'),
('frilansa','1|frilans'),
('frilansande','1|frilansa'),
('frilansare','1|frilans'),
('frilansjournalist','1|journalist'),
('frilansskribent','1|skribent'),
('frilansskådespelare','1|skådespelare'),
('frilanstillvaro','1|tillvaro'),
('frilansvillkor','1|villkor'),
('frilevande','1|fri'),
('friliggande','1|ligga'),
('frilista','1|tillåta'),
('frilista','2|frilista'),
('frilistande','1|frilista'),
('frilla','1|älskarinna'),
('frilla','2|frisyr'),
('frilla','3|damfrisörska'),
('Frillesås','1|Göteborg'),
('friluftsbad','1|bad'),
('friluftsdag','1|skoldag'),
('friluftshåll','1|friluftsintresse'),
('friluftsintresse','1|intresse'),
('friluftsliv','1|liv'),
('friluftsmiljö','1|miljö'),
('friluftsmuseum','1|museum'),
('friluftsområde','1|område'),
('friluftsskog','1|skog'),
('friluftsvanor','1|vana'),
('friluftsändamål','1|ändamål'),
('friläge','1|läge'),
('frilägga','1|synlig'),
('friläggande','1|frilägga'),
('frimickel','1|frikyrklig'),
('frimodig','1|orädd'),
('frimodighet','1|frimodig'),
('frimurare','1|frimurarorden'),
('frimurarloge','1|avdelning'),
('frimurarorden','1|orden'),
('frimurarorden','1|orden'),
('frimurarorden','1|orden'),
('frimurarorden','1|orden'),
('frimurartecken','1|tecken'),
('frimureri','1|frimurarorden'),
('frimärka','1|frankera'),
('frimärkande','1|frimärka'),
('frimärke','1|porto'),
('frimärkssamlare','1|samla'),
('frimärkssamling','1|samling'),
('fripass','1|gratis'),
('fripassagerare','1|biljett'),
('friplats','1|plats'),
('friplåt','1|fribiljett'),
('frireligiös','1|frikyrklig'),
('fris','1|ornament'),
('fris','2|panel'),
('fris','3|ylletyg'),
('fris','4|folk'),
('frisbee','1|plastskiva'),
('frisedel','1|befria'),
('frisera','1|frisyr'),
('frisera','2|tillrättalägga'),
('friserande','1|frisera'),
('friserande','2|frisera'),
('friserbar','1|frisera'),
('friserbarhet','1|friserbar'),
('frisering','1|frisera'),
('frisering','2|frisera'),
('frisersalong','1|salong'),
('frisim','1|simma'),
('frisinnad','1|liberal'),
('frisinnad','1|liberal'),
('frisinne','1|frisinnad'),
('frisinthet','1|frisinnad'),
('frisisk','1|fris'),
('frisiska','1|språk'),
('frisiska','2|fris'),
('frisk','1|bra'),
('frisk','2|ren'),
('frisk','3|kraft'),
('friska','1|frisk'),
('friskande','1|friska'),
('friskanmäla','1|anmäla'),
('friskanmälande','1|friskanmäla'),
('friskara','1|armé'),
('friskförklara','1|förklara'),
('friskförklarande','1|friskförklara'),
('friskhet','1|frisk'),
('friskhet','2|frisk'),
('friskhet','3|frisk'),
('friskintyg','1|intyg'),
('friskluft','1|luft'),
('friskluftsintag','1|tillföra'),
('friskluftsventilation','1|ventilation'),
('friskola','1|skola'),
('friskrapportera','1|friskanmäla'),
('friskrapporterande','1|friskrapportera'),
('friskrapportering','1|friskrapportera'),
('friskriven','1|befria'),
('friskrivning','1|friskriven'),
('friskskriva','1|intyga'),
('friskskrivande','1|friskskriva'),
('frisksport','1|friluftsliv'),
('frisksporta','1|frisksport'),
('frisksportande','1|frisksporta'),
('frisksportare','1|idrottsman'),
('friskus','1|hurtig'),
('friskvård','1|förebygga'),
('friskytt','1|skytt'),
('frislag','1|bandy'),
('frisläppa','1|frige'),
('frisläppande','1|frisläppa'),
('frispark','1|fotboll'),
('frispel','1|spel'),
('frispela','1|fotboll'),
('frispelande','1|frispela'),
('frispråkig','1|uppriktig'),
('frispråkighet','1|frispråkig'),
('frissa','1|damfrisörska'),
('frist','1|period'),
('fristad','1|tillflyktsort'),
('fristad','2|stad'),
('fristat','1|stat'),
('fristil','1|fribrottning'),
('fristående','1|självständig'),
('friställa','1|avskeda'),
('friställande','1|friställa'),
('frisyr','1|klippa'),
('frisyrgelé','1|gelé'),
('frisäga','1|ansvarsbefrielse'),
('frisägande','1|frisäga'),
('frisägelse','1|frisäga'),
('frisätta','1|fri'),
('frisättande','1|frisätta'),
('frisör','1|frisyr'),
('frisörelev','1|elev'),
('frisörsalong','1|frisör'),
('frisörska','1|frisör'),
('frisörstol','1|stol'),
('frita','1|befria'),
('fritagande','1|frita'),
('fritagen','1|frita'),
('fritagning','1|frita'),
('fritagningsförsök','1|försök'),
('fritera','1|koka'),
('friterande','1|fritera'),
('friterbar','1|fritera'),
('friterbarhet','1|friterbar'),
('fritering','1|fritera'),
('friteringsfett','1|fritera'),
('fritid','1|ledig'),
('fritidsaktivitet','1|aktivitet'),
('fritidsbebyggelse','1|bebyggelse'),
('fritidsby','1|stugby'),
('fritidsbåt','1|båt'),
('fritidsförvaltning','1|organ'),
('fritidsgård','1|lokal'),
('fritidshem','1|barnomsorg'),
('fritidshus','1|hus'),
('fritidshusägare','1|ägare'),
('fritidsklädsel','1|klädsel'),
('fritidsledare','1|leda'),
('fritidslokal','1|lokal'),
('fritidsnämnd','1|nämnd'),
('fritidsområde','1|område'),
('fritidspedagog','1|pedagog'),
('fritidspolitik','1|politik'),
('fritidspolitiker','1|politiker'),
('fritidspolitisk','1|fritidspolitik'),
('fritidspolitisk','2|fritidspolitiker'),
('fritidsproblem','1|problem'),
('fritidsstuga','1|stuga'),
('fritidssysselsättning','1|sysselsättning'),
('fritis','1|fritidshem'),
('frityr','1|fritera'),
('frityrdeg','1|frityr'),
('fritänkande','1|fritänkare'),
('fritänkare','1|ateist'),
('fritänkeri','1|fritänkare'),
('frivakt','1|ledig'),
('frivecka','1|vecka'),
('frivillig','1|tvinga'),
('frivillighet','1|frivillig'),
('frivilligorganisation','1|organisation'),
('frivilligtjänst','1|tjänstgöring'),
('frivol','1|oanständig'),
('frivolitet','1|frivol'),
('frivolitet','2|spets'),
('frivolt','1|volt'),
('frivård','1|kriminalvård'),
('frizon','1|zon'),
('friåkning','1|konståkning'),
('friår','1|arbetsmarknadsåtgärd'),
('frodas','1|växa'),
('frodig','1|frodas'),
('frodig','2|fet'),
('frodighet','1|frodig'),
('frodighet','2|frodig'),
('from','1|religiös'),
('from','2|lugn'),
('fromage','1|efterrätt'),
('fromhet','1|from'),
('fromhet','2|from'),
('fromhetsiver','1|iver'),
('fromla','1|hyckla'),
('fromlande','1|fromla'),
('fromleri','1|fromla'),
('fromsint','1|from'),
('fromsinthet','1|fromsint'),
('frondera','1|opponera'),
('fronderande','1|frondera'),
('fronderbar','1|frondera'),
('fronderbarhet','1|fronderbar'),
('frondering','1|frondera'),
('frondör','1|frondera'),
('front','1|framme'),
('front','2|framkant'),
('fronta','1|ordna'),
('frontal','1|front'),
('frontalangrepp','1|angrepp'),
('frontalkrock','1|krock'),
('frontalkrocka','1|frontalkrock'),
('frontalkrockande','1|frontalkrocka'),
('frontallob','1|pannlob'),
('frontallobsstörning','1|störning'),
('frontande','1|fronta'),
('frontanfall','1|frontalangrepp'),
('frontavsnitt','1|del'),
('frontbildning','1|bildning'),
('frontespis','1|tak'),
('frontespis','2|titelblad'),
('frontfigur','1|förgrundsfigur'),
('frontförbindelse','1|förbindelse'),
('frontkommendering','1|kommendering'),
('frontlinje','1|linje'),
('frontmatad','1|mata'),
('frontmonterad','1|montera'),
('frontnederbörd','1|nederbörd'),
('fronton','1|gavel'),
('fronton','1|gavel'),
('frontsoldat','1|soldat'),
('fronttjänst','1|fronttjänstgöring'),
('fronttjänstgöring','1|tjänstgöring'),
('frontzon','1|zon'),
('frontzon','2|zon'),
('frosch','1|stråke'),
('frossa','1|skaka'),
('frossa','2|äta'),
('frossande','1|frossa'),
('frossanfall','1|anfall'),
('frossare','1|frossa'),
('frossbrytning','1|frossa'),
('frosseri','1|frossa'),
('frossfeber','1|feber'),
('frosskakning','1|frossa'),
('frosskänning','1|frossa'),
('frost','1|kall'),
('frosta','1|yta'),
('frostande','1|frosta'),
('frostbiten','1|skada'),
('frostdimma','1|dimma'),
('frostfjäril','1|fjäril'),
('frostfri','1|frost'),
('frosthärdig','1|tåla'),
('frosthärdighet','1|frosthärdig'),
('frostig','1|frost'),
('frostighet','1|frostig'),
('frostkänslig','1|känslig'),
('frostkänslighet','1|frostkänslig'),
('frostnatt','1|natt'),
('frostning','1|frosta'),
('frostskada','1|skada'),
('frostskadad','1|frostbiten'),
('frostskyddsvätska','1|förhindra'),
('frostsprängning','1|söndersprängning'),
('frosttålig','1|tåla'),
('frosttålighet','1|frosttålig'),
('frostverkan','1|tjäle'),
('frotté','1|tyg'),
('frottéhandduk','1|handduk'),
('frottera','1|gnida'),
('frotterande','1|frottera'),
('frotterbar','1|frottera'),
('frotterbarhet','1|frotterbar'),
('frottering','1|frottera'),
('frottérock','1|badkappa'),
('frottör','1|kladda'),
('fru','1|kvinna'),
('fruga','1|hustru'),
('frugal','1|enkel'),
('frugalitet','1|frugal'),
('frukost','1|måltid'),
('frukostbord','1|frukost'),
('frukostbricka','1|bricka'),
('frukostbuffé','1|buffé'),
('frukostdags','1|frukost'),
('frukostera','1|frukost'),
('frukosterande','1|frukostera'),
('frukostering','1|frukostera'),
('frukostmeny','1|meny'),
('frukostmiddag','1|lunch'),
('frukostrast','1|rast'),
('frukostvärdinna','1|värdinna'),
('frukostägg','1|ägg'),
('frukostätare','1|frukost'),
('frukt','1|äta'),
('frukta','1|rädd'),
('fruktaffär','1|affär'),
('fruktan','1|frukta'),
('fruktande','1|frukta'),
('fruktansvärd','1|hemsk'),
('fruktansvärdhet','1|fruktansvärd'),
('fruktansvärt','1|mycket'),
('fruktbar','1|riklig'),
('fruktbarhet','1|fruktbar'),
('fruktbarhetsgud','1|gud'),
('fruktbildning','1|frukt'),
('fruktbringande','1|fruktbärande'),
('fruktbärande','1|fruktbar'),
('frukthandlare','1|handlare'),
('fruktig','1|frukt'),
('fruktighet','1|fruktig'),
('fruktkaka','1|kaka'),
('fruktkniv','1|kniv'),
('fruktkompott','1|kompott'),
('fruktkorg','1|korg'),
('fruktkärna','1|frukt'),
('fruktkött','1|kött'),
('fruktliknande','1|frukt'),
('fruktlös','1|förgäves'),
('fruktlöshet','1|fruktlös'),
('fruktodlare','1|fruktodling'),
('fruktodling','1|odla'),
('fruktos','1|fruktsocker'),
('fruktplockare','1|plocka'),
('fruktpåse','1|påse'),
('fruktsaft','1|saft'),
('fruktsallad','1|efterrätt'),
('fruktsalt','1|salt'),
('fruktsam','1|föda'),
('fruktsamhet','1|fruktsam'),
('fruktskorv','1|sjukdom'),
('fruktskål','1|skål'),
('fruktskörd','1|skörd'),
('fruktsmak','1|smak'),
('fruktsocker','1|socker'),
('fruktsoppa','1|soppa'),
('fruktsort','1|frukt'),
('fruktsporre','1|fruktved'),
('fruktsås','1|sås'),
('fruktsättning','1|börja'),
('frukttallrik','1|tallrik'),
('fruktträd','1|träd'),
('fruktträdgård','1|trädgård'),
('fruktved','1|fruktträd'),
('fruktvin','1|vin'),
('fruktvägg','1|frukt'),
('fruktämne','1|pistill'),
('frunch','1|brunch'),
('fruntimmer','1|kvinna'),
('fruntimmerskarl','1|kvinnotycke'),
('fruntimmersveckan','1|juli'),
('frusa','1|välla'),
('frusande','1|frusa'),
('frusen','1|frysa'),
('frusenhet','1|frusen'),
('frusning','1|frusa'),
('frusta','1|väsa'),
('frustande','1|frusta'),
('frustning','1|frusta'),
('frustration','1|frustrerad'),
('frustrera','1|frustrerad'),
('frustrerad','1|besviken'),
('frustrerande','1|frustrera'),
('frustrerbar','1|frustrera'),
('frustrerbarhet','1|frustrerbar'),
('frustrering','1|frustrera'),
('fryna','1|rynka'),
('frynande','1|fryna'),
('fryntlig','1|godmodig'),
('fryntlighet','1|fryntlig'),
('frys','1|frysbox'),
('frysa','1|kall'),
('frysa','2|frysa_in'),
('frysande','1|frysa'),
('frysande','2|frysa'),
('frysbox','1|förvara'),
('frysdisk','1|frysbox'),
('fryseri','1|frysa'),
('frysfack','1|fack'),
('frysförpackning','1|förpackning'),
('frysförsök','1|försök'),
('frysloppa','1|knottra_sig'),
('frysning','1|frysa'),
('frysning','2|frysa'),
('fryspunkt','1|temperatur'),
('frysrum','1|rum'),
('fryst','1|frysa'),
('frystejp','1|tejp'),
('frystest','1|test'),
('frystesta','1|frystest'),
('frystestande','1|frystesta'),
('frystorka','1|konservera'),
('frystorkande','1|frystorka'),
('frystålig','1|tåla'),
('frystålighet','1|frystålig'),
('fråga','1|be'),
('fråga','2|fråga'),
('fråga','3|gälla'),
('fråga','4|bry_sig_om'),
('frågande','1|fråga'),
('frågeform','1|fråga'),
('frågeformulär','1|formulär'),
('frågementalitet','1|mentalitet'),
('frågeord','1|ord'),
('frågesats','1|sats'),
('frågespalt','1|spalt'),
('frågesport','1|tävling'),
('frågestund','1|utfrågning'),
('frågeställare','1|fråga'),
('frågeställning','1|fråga'),
('frågetecken','1|tecken'),
('frågetest','1|test'),
('frågeton','1|tonfall'),
('frågetävling','1|frågesport'),
('frågvis','1|nyfiken'),
('frågvishet','1|frågvis'),
('från','1|till'),
('från','1|till'),
('från','2|från'),
('fråndockning','1|lösgöra'),
('fråndragning','1|dra_ifrån'),
('fråndöma','1|frånta'),
('fråndömande','1|fråndöma'),
('frånfälle','1|avlida'),
('frångå','1|avvika'),
('frångående','1|frångå'),
('frånkoppling','1|koppla_ifrån'),
('frånkoppling','2|koppla_ifrån'),
('frånkänna','1|frånta'),
('frånkännande','1|frånkänna'),
('frånkörd','1|köra'),
('frånlandsvind','1|vind'),
('frånräkna','1|räkna'),
('frånräknande','1|frånräkna'),
('frånräkning','1|frånräkna'),
('frånse','1|bortse'),
('frånseende','1|frånse'),
('frånsett','1|utom'),
('frånsida','1|baksida'),
('frånsilning','1|sila_ifrån'),
('frånskild','1|skild'),
('frånskilja','1|ta_bort'),
('frånskiljande','1|frånskilja'),
('frånskiljare','1|elektricitet'),
('frånskiljbar','1|frånskilja'),
('frånskiljbarhet','1|frånskiljbar'),
('frånskiljning','1|frånskilja'),
('frånskruvning','1|skruva_ifrån'),
('frånslitning','1|slita'),
('frånspela','1|förlora'),
('frånspela','2|frånta'),
('frånspelande','1|frånspela'),
('frånspelande','2|frånspela'),
('frånspännande','1|spänna_ifrån'),
('frånspänning','1|spänna_ifrån'),
('frånstötande','1|motbjudande'),
('frånta','1|ta'),
('fråntagande','1|frånta'),
('frånträda','1|avgå'),
('frånträdande','1|frånträda'),
('frånträde','1|frånträda'),
('frånvarande','1|närvarande'),
('frånvaro','1|frånvarande'),
('frånvarodag','1|dag'),
('frånvänd','1|vända'),
('frånåkt','1|åka'),
('fräck','1|mild'),
('fräckhet','1|fräck'),
('fräckis','1|anekdot'),
('fräken','1|ormbunke'),
('fräken','1|ormbunke'),
('fräken','2|fläck'),
('fräknig','1|fräken'),
('fräknighet','1|fräknig'),
('frälsa','1|kristen'),
('frälsande','1|frälsa'),
('frälsare','1|frälsa'),
('frälsarkrans','1|livboj'),
('frälse','1|adel'),
('frälse','2|frälse'),
('frälsebonde','1|bonde'),
('frälsegods','1|gods'),
('frälsehemman','1|hemman'),
('frälsejord','1|jord'),
('frälseman','1|man'),
('frälsning','1|frälsa'),
('Frälsningsarmén','1|trossamfund'),
('Frälsningsarmén','1|trossamfund'),
('frälsningsmöte','1|väckelsemöte'),
('frälsningssoldat','1|Frälsningsarmén'),
('frälsningsupplevelse','1|upplevelse'),
('frälst','1|religiös'),
('frälst','2|gilla'),
('frälsthet','1|frälst'),
('frälsthet','2|frälst'),
('främja','1|hjälpa'),
('främjande','1|främja'),
('främjare','1|främja'),
('främling','1|främmande'),
('främlingsfientlig','1|fientlig'),
('främlingsfientlighet','1|främlingsfientlig'),
('främlingshat','1|hat'),
('främlingskap','1|främling'),
('främlingslegionen','1|förband'),
('främlingslegionär','1|främlingslegionen'),
('främlingspass','1|pass'),
('främmande','1|okänd'),
('främmande','2|gäst'),
('främmat','1|främmande'),
('främre','1|framme'),
('främst','1|före'),
('främst','2|framme'),
('främst','3|viktig'),
('frän','1|skarp'),
('frän','2|häftig'),
('frände','1|släkting'),
('frändskap','1|frände'),
('fränhet','1|frän'),
('fränhet','2|frän'),
('fränka','1|frände'),
('fräs','1|fräsa'),
('fräs','2|fart'),
('fräs','3|skära'),
('fräsa','1|låta'),
('fräsa','2|fräs'),
('fräsa','3|steka'),
('fräsande','1|fräsa'),
('fräsande','2|fräsa'),
('fräsande','3|fräsa'),
('fräsch','1|frisk'),
('fräschhet','1|fräsch'),
('fräschör','1|fräsch'),
('fräsig','1|fräs'),
('fräsmaskin','1|fräs'),
('fräsning','1|fräsa'),
('fräsning','2|fräsa'),
('fräsning','3|fräsa'),
('frässtål','1|stål'),
('fräta','1|förstöra'),
('fräta','2|fräta'),
('frätande','1|fräta'),
('frätande','2|fräta'),
('frätning','1|fräta'),
('frätskada','1|skada'),
('Frö','1|Frej'),
('frö','1|växa'),
('frö','2|busfrö'),
('fröa','1|frö'),
('fröande','1|fröa'),
('fröfäste','1|fäste'),
('frögömme','1|fröhus'),
('fröhus','1|frö'),
('fröhylsa','1|frö'),
('Fröja','1|Freja'),
('fröjd','1|glädje'),
('fröjda','1|fröjd'),
('fröjdande','1|fröjda'),
('fröjdas','1|fröjd'),
('fröjdefull','1|fröjd'),
('fröjdefullhet','1|fröjdefull'),
('fröjderik','1|fröjd'),
('frökapsel','1|frö'),
('fröken','1|kvinna'),
('fröken','2|skolfröken'),
('frökenspel','1|spel'),
('Frölunda','1|Göteborg'),
('frömjöl','1|befrukta'),
('fröodling','1|odling'),
('fröparti','1|parti'),
('fröplanta','1|planta'),
('fröplantage','1|plantage'),
('fröskal','1|skal'),
('fröskida','1|frö'),
('frösort','1|frö'),
('frötall','1|tall'),
('fröträd','1|träd'),
('frövita','1|frö'),
('fröväxt','1|fanerogam'),
('fröämne','1|frö'),
('FSH','1|hormon'),
('ftalat','1|förening'),
('ftalsyra','1|syra'),
('fubb','1|fusk'),
('fuchsia','1|krukväxt'),
('fuffens','1|ofog'),
('fuga','1|musik'),
('fugerad','1|fuga'),
('fugu','1|fiskrätt'),
('fuksin','1|färgämne'),
('fukt','1|fuktig'),
('fukta','1|fuktig'),
('fuktande','1|fukta'),
('fuktfläck','1|fläck'),
('fuktfri','1|fukt'),
('fuktgivande','1|fukta'),
('fukthal','1|hal'),
('fuktig','1|våt'),
('fuktighet','1|fuktig'),
('fuktning','1|fukta'),
('fuktskada','1|skada'),
('fuktskadad','1|skada'),
('fukttekniker','1|tekniker'),
('Fukushima','1|kärnkraftverk'),
('ful','1|vacker'),
('ful','2|förundersökningsledare'),
('fulhet','1|ful'),
('fuling','1|ful'),
('fulkultur','1|finkultur'),
('full','1|mycken'),
('full','2|berusad'),
('fulladdad','1|ladda'),
('fullastad','1|last'),
('fullbelagd','1|belägga'),
('fullbetald','1|betala'),
('fullbildad','1|utvecklad'),
('fullblod','1|häst'),
('fullblodig','1|fullblod'),
('fullblodighet','1|fullblodig'),
('fullblodsaristokrat','1|aristokrat'),
('fullblodshäst','1|fullblod'),
('fullblodsindian','1|indian'),
('fullblodsproffs','1|proffs'),
('fullbokad','1|upptagen'),
('fullborda','1|färdig'),
('fullbordan','1|fullborda'),
('fullbordande','1|fullborda'),
('fullbordare','1|fullborda'),
('fulleren','1|kol'),
('fullfjädrad','1|van'),
('fullfärdig','1|färdig'),
('fullfölja','1|avsluta'),
('fullföljande','1|fullfölja'),
('fullföljd','1|rättegång'),
('fullgjord','1|fullgöra'),
('fullgod','1|bra'),
('fullgodhet','1|fullgod'),
('fullgången','1|utvecklad'),
('fullgångenhet','1|fullgången'),
('fullgöra','1|avsluta'),
('fullgörande','1|fullgöra'),
('fullgörare','1|fullgöra'),
('fullgörelsetalan','1|talan'),
('fullhet','1|full'),
('fullhet','2|full'),
('fullklistrad','1|klistra_upp'),
('fullklottrad','1|klottra'),
('fullkomlig','1|bra'),
('fullkomligen','1|total'),
('fullkomlighet','1|fullkomlig'),
('fullkomna','1|fullkomlig'),
('fullkomnande','1|fullkomna'),
('fullkomning','1|fullkomna'),
('fullkorn','1|sädeskärna'),
('fullkornsbröd','1|bröd'),
('fullkornsmjöl','1|mjöl'),
('fullmakt','1|tillåtelse'),
('fullmaktslag','1|lag'),
('fullmatad','1|full'),
('fullmogen','1|mogen'),
('fullmogenhet','1|fullmogen'),
('fullmyndig','1|myndig'),
('fullmyndig','2|myndig'),
('fullmåne','1|månen'),
('fullmäktig','1|besluta'),
('fullmäktigskap','1|fullmäktig'),
('fullpackad','1|full'),
('fullproppad','1|full'),
('fullproppande','1|proppa_full'),
('fullproppning','1|proppa_full'),
('fullriggad','1|fullriggare'),
('fullriggare','1|segelfartyg'),
('fullsatt','1|full'),
('fullskalig','1|skala'),
('fullskalighet','1|fullskalig'),
('fullsmockad','1|fullproppad'),
('fullspikad','1|fullsatt'),
('fullspäckad','1|full'),
('fullstaplad','1|stapla'),
('fullstor','1|i_full_storlek'),
('fullstämmig','1|stämma'),
('fullstämmighet','1|fullstämmig'),
('fullständig','1|hel'),
('fullständiga','1|fullständig'),
('fullständigande','1|fullständiga'),
('fullständighet','1|fullständig'),
('fulltalig','1|antal'),
('fulltalighet','1|fulltalig'),
('fulltankad','1|tanka'),
('fulltecknad','1|upptagen'),
('fulltonig','1|ton'),
('fulltonighet','1|fulltonig'),
('fullträff','1|träff'),
('fulltränad','1|vältränad'),
('fullviktig','1|vikt'),
('fullviktig','2|duglig'),
('fullvuxen','1|växa'),
('fullvuxenhet','1|fullvuxen'),
('fullväpnad','1|beväpnad'),
('fullvärdesförsäkring','1|försäkring'),
('fullvärdig','1|bra'),
('fullvärdighet','1|fullvärdig'),
('fullväxt','1|växa'),
('fullända','1|fulländad'),
('fulländad','1|fullkomlig'),
('fulländande','1|fullända'),
('fulländare','1|fullända'),
('fulländning','1|fulländad'),
('fullärd','1|lärd'),
('fullödig','1|äkta'),
('fullödighet','1|fullödig'),
('fulsnygg','1|attraktiv'),
('fulsnygghet','1|fulsnygg'),
('fulvinkla','1|vinkla'),
('fulvinklande','1|fulvinkla'),
('fulvinkling','1|fulvinkla'),
('fumla','1|fumlig'),
('fumlande','1|fumla'),
('fumlig','1|tafatt'),
('fumlighet','1|fumlig'),
('fundament','1|grund'),
('fundamental','1|grundlig'),
('fundamentalism','1|renlärig'),
('fundamentalist','1|fanatisk'),
('fundamentalistisk','1|fundamentalist'),
('fundamentalsats','1|sats'),
('funder','1|list'),
('fundera','1|tänka'),
('funderande','1|fundera'),
('funderare','1|fundera'),
('fundering','1|fundera'),
('fundersam','1|fundera'),
('fundersamhet','1|fundersam'),
('fungera','1|bra'),
('fungera','2|hur'),
('fungera','3|som'),
('fungerande','1|fungera'),
('fungerande','2|fungera'),
('fungerande','3|fungera'),
('funk','1|rockmusik'),
('funka','1|fungera'),
('funkande','1|funka'),
('funkig','1|funkis'),
('funkis','1|funktionalism'),
('funktion','1|fungera'),
('funktion','2|matematik'),
('funktion','3|fungera'),
('funktion','4|fungera'),
('funktionalism','1|konstriktning'),
('funktionalist','1|funktionalism'),
('funktionalistisk','1|funktionalism'),
('funktionalitet','1|funktionell'),
('funktionell','1|fungera'),
('funktionera','1|fungera'),
('funktionerande','1|funktionera'),
('funktionering','1|funktionera'),
('funktionsduglig','1|fungera'),
('funktionsduglighet','1|funktionsduglig'),
('funktionshinder','1|handikapp'),
('funktionshindrad','1|funktionshinder'),
('funktionsmässig','1|funktion'),
('funktionsmässig','2|funktion'),
('funktionsmässig','3|funktion'),
('funktionsnedsättning','1|nedsättning'),
('funktionsoduglig','1|funktionsduglig'),
('funktionsoduglighet','1|funktionsoduglig'),
('funktionssätt','1|sätt'),
('funktionsvärde','1|värde'),
('funktionär','1|tjäna'),
('funtad','1|beskaffad'),
('fur','1|furu'),
('fur','2|fura'),
('fura','1|tall'),
('furage','1|foder'),
('furan','1|gas'),
('furie','1|rasande'),
('furioso','1|häftig'),
('furioso','2|furioso'),
('furir','1|underbefäl'),
('furiös','1|rasande'),
('furnera','1|leverera'),
('furnerande','1|furnera'),
('furnerbar','1|furnera'),
('furnerbarhet','1|furnerbar'),
('furnering','1|furnera'),
('furnissör','1|furnera'),
('furong','1|kambrium'),
('furor','1|succé'),
('furor','1|succé'),
('furstbiskop','1|biskop'),
('furste','1|prins'),
('furste','1|prins'),
('furstehus','1|hus'),
('furstekrona','1|furste'),
('furstendöme','1|stat'),
('fursteätt','1|ätt'),
('furstlig','1|furste'),
('furstlighet','1|furstlig'),
('furu','1|virke'),
('furugolv','1|golv'),
('furunkel','1|inflammation'),
('furuplanka','1|planka'),
('furutrappa','1|trappa'),
('furuträ','1|furu'),
('fusion','1|sammanslagning'),
('fusion','2|sammansmältning'),
('fusion','3|blanda'),
('fusionera','1|fusion'),
('fusionerande','1|fusionera'),
('fusionerbar','1|fusionera'),
('fusionerbarhet','1|fusionerbar'),
('fusionering','1|fusionera'),
('fusionsplan','1|plan'),
('fusk','1|lura'),
('fuska','1|fusk'),
('fuska','2|amatörmässig'),
('fuska','3|slarvig'),
('fuskande','1|fuska'),
('fuskande','2|fuska'),
('fuskande','3|fuska'),
('fuskanklagelse','1|anklagelse'),
('fuskare','1|fuska'),
('fuskbyggare','1|fuskbygge'),
('fuskbygge','1|bygge'),
('fuskeri','1|fuska'),
('fuskeri','2|fuska'),
('fuskeri','3|fuska'),
('fuskflygning','1|ballongfamiljen'),
('fusklapp','1|fuska'),
('fuskpäls','1|päls'),
('fuskverk','1|arbete'),
('futhark','1|alfabet'),
('futil','1|obetydlig'),
('futilitet','1|futil'),
('futt','1|skjul'),
('futt','2|futta'),
('futta','1|tända'),
('futtande','1|futta'),
('futtig','1|liten'),
('futtighet','1|futtig'),
('futural','1|framtid'),
('futurism','1|konst'),
('futurist','1|futurism'),
('futuristisk','1|futurism'),
('futurolog','1|futurologi'),
('futurologi','1|vetenskap'),
('futurologisk','1|framtid'),
('futurum','1|tempus'),
('fux','1|häst'),
('fy','1|illa'),
('Führer','1|Hitler'),
('fylgia','1|skyddsande'),
('fylgia','1|skyddsande'),
('fylka','1|fylking'),
('fylkande','1|fylka'),
('fylkas','1|samlas'),
('fylke','1|län'),
('fylking','1|stridsuppställning'),
('fylla','1|full'),
('fylla','2|full'),
('fylla','3|full'),
('fylla','4|ålder'),
('fyllande','1|fylla'),
('fyllande','2|fylla'),
('fyllande','3|fylla'),
('fyllbult','1|full'),
('fylld','1|full'),
('fylldille','1|dille'),
('fyllebråk','1|bråk'),
('fylleri','1|full'),
('fylleriförseelse','1|förseelse'),
('fyllerist','1|fylleri'),
('fylleslag','1|fylleri'),
('fyllesnack','1|snack'),
('fyllhund','1|full'),
('fyllig','1|mycken'),
('fyllig','2|tjock'),
('fyllighet','1|fyllig'),
('fyllighet','2|fyllig'),
('fyllis','1|fyllo'),
('fyllkaja','1|full'),
('fyllna','1|full'),
('fyllnad','1|tillägg'),
('fyllnadsarbete','1|arbete'),
('fyllnadsbelopp','1|belopp'),
('fyllnadsgods','1|gods'),
('fyllnadsgrus','1|grus'),
('fyllnadsgrus','1|grus'),
('fyllnadsjord','1|jord'),
('fyllnadsjord','1|jord'),
('fyllnadslast','1|last'),
('fyllnadsmassa','1|massa'),
('fyllnadsmassa','1|massa'),
('fyllnadspension','1|pension'),
('fyllnadssten','1|sten'),
('fyllnadssten','1|sten'),
('fyllnadstjänstgöring','1|tjänstgöring'),
('fyllnadsval','1|val'),
('fyllnadsämne','1|ämne'),
('fyllnande','1|fyllna'),
('fyllning','1|fylla'),
('fyllo','1|full'),
('fylltratt','1|fyllo'),
('fylltratt','1|fyllo'),
('fylogenetisk','1|fylogeni'),
('fylogeni','1|släktskapsträd'),
('fynd','1|finna'),
('fynda','1|köpa'),
('fyndande','1|fynda'),
('fyndgruva','1|fyndplats'),
('fyndig','1|påhittig'),
('fyndig','2|malmförande'),
('fyndighet','1|förekomst'),
('fyndighet','2|fyndig'),
('fyndjakt','1|jakt'),
('fyndomständighet','1|omständighet'),
('fyndort','1|fyndplats'),
('fyndplats','1|plats'),
('fyndpris','1|fynda'),
('fyr','1|lysa'),
('fyr','2|person'),
('fyra','1|ental'),
('fyra','1|ental'),
('fyra','2|siffra'),
('fyra','3|fyrarumslägenhet'),
('fyrahundratalet','1|århundrade'),
('fyraprocentsspärren','1|spärr'),
('fyrarummare','1|fyrarumslägenhet'),
('fyrarumslägenhet','1|lägenhet'),
('fyrarumslägenhet','1|lägenhet'),
('fyrasnåret','1|klockslag'),
('fyratiden','1|klockslag'),
('fyratimmarsflygning','1|flygning'),
('fyratåg','1|tåg'),
('fyravåningshus','1|hus'),
('fyraårig','1|år'),
('fyraåring','1|fyraårig'),
('fyrbackslinje','1|back'),
('fyrbening','1|fyrbent'),
('fyrbent','1|ben'),
('fyrbåk','1|fyr'),
('fyrcylindrig','1|cylinder'),
('fyrdela','1|dela'),
('fyrdelad','1|fyrdela'),
('fyrdelande','1|fyrdela'),
('fyrdelning','1|fyrdela'),
('fyrdimensionell','1|dimension'),
('fyrdubbel','1|gång'),
('fyrdubbla','1|fyrdubbel'),
('fyrdubblande','1|fyrdubbla'),
('fyrdubbling','1|fyrdubbla'),
('fyrfaldig','1|gång'),
('fyrfaldig','1|gång'),
('fyrfaldiga','1|fyrfaldig'),
('fyrfaldigande','1|fyrfaldiga'),
('fyrfalt','1|fyrfaldig'),
('fyrfat','1|elda'),
('fyrfilig','1|fil'),
('fyrfilighet','1|fyrfilig'),
('fyrfota','1|fyrfotad'),
('fyrfotad','1|fyrbent'),
('fyrfotadjur','1|djur'),
('fyrfoting','1|fyrfotadjur'),
('fyrfärgad','1|färg'),
('fyrfärgstryck','1|tryck'),
('fyrgradig','1|grad'),
('fyrgradighet','1|fyrgradig'),
('fyrhandssättning','1|spela'),
('fyrhjulig','1|hjul'),
('fyrhjulighet','1|fyrhjulig'),
('fyrhjuling','1|fyrhjulig'),
('fyrhjulingsförare','1|förare'),
('fyrhjulsdriven','1|driva'),
('fyrhändig','1|hand'),
('fyrhänt','1|fyrhändig'),
('fyrhörning','1|figur'),
('Fyris','1|å'),
('fyrk','1|mynt'),
('fyrk','2|taxeringsenhet'),
('fyrkant','1|fyrkantig'),
('fyrkantig','1|kant'),
('fyrkantig','2|onyanserad'),
('fyrkantighet','1|fyrkantig'),
('fyrkaraktär','1|ljussken'),
('fyrkluven','1|klyva'),
('fyrklöver','1|klöver'),
('fyrling','1|syskon'),
('fyrljus','1|ljus'),
('fyrmotorig','1|motor'),
('fyrmänning','1|brylling'),
('fyrmästare','1|fyrvaktare'),
('fyrop','1|rop'),
('fyrradig','1|rad'),
('fyrradig','2|rad'),
('fyrradskorn','1|korn'),
('fyrrummare','1|fyrrumslägenhet'),
('fyrrumslägenhet','1|lägenhet'),
('fyrsidig','1|sida'),
('fyrsiding','1|fyrhörning'),
('fyrsiffrig','1|siffra'),
('fyrsitsig','1|sits'),
('fyrskaft','1|vävnad'),
('fyrskaftad','1|fyrskaft'),
('fyrskepp','1|fyr'),
('fyrspann','1|hästspann'),
('fyrsprång','1|galopp'),
('fyrstavig','1|stavelse'),
('fyrstjärnig','1|stjärna'),
('fyrstruken','1|oktav'),
('fyrstämmig','1|stämma'),
('fyrtakt','1|taktart'),
('fyrtakt','2|fyrtaktsmotor'),
('fyrtaktare','1|fyrtaktsmotor'),
('fyrtaktsmotor','1|förbränningsmotor'),
('fyrtal','1|fyra'),
('fyrtal','2|poker'),
('fyrtalig','1|fyrtal'),
('fyrtio','1|tal'),
('fyrtio','1|tal'),
('fyrtio','1|tal'),
('fyrtionde','1|fyrtio'),
('fyrtiotal','1|fyrtio'),
('fyrtiotalet','1|nittonhundrafyrtiotalet'),
('fyrtiotalet','1|nittonhundrafyrtiotalet'),
('fyrtiotalet','1|nittonhundrafyrtiotalet'),
('fyrtiotalism','1|fyrtiotalist'),
('fyrtiotalism','1|fyrtiotalist'),
('fyrtiotalist','1|författare'),
('fyrtiotalist','1|författare'),
('fyrtiotalistisk','1|fyrtiotalism'),
('fyrtiotimmarsvecka','1|arbetsvecka'),
('fyrtiotimmarsvecka','1|arbetsvecka'),
('fyrtioåring','1|år'),
('fyrtioåring','1|år'),
('fyrtioåring','1|år'),
('fyrtioårskris','1|kris'),
('fyrtioårskris','1|kris'),
('fyrtorn','1|fyr'),
('fyrtumsspik','1|spik'),
('fyrvaktare','1|vakta'),
('fyrverkare','1|artillerist'),
('fyrverkeri','1|explodera'),
('fyrverkeripjäs','1|fyrverkeri'),
('fyrväldig','1|ståndare'),
('fyrväppling','1|fyrklöver'),
('fyrväsen','1|fyr'),
('fyrväxlad','1|växel'),
('fysik','1|vetenskap'),
('fysik','2|kondition'),
('fysikalisk','1|fysisk'),
('fysikbok','1|lärobok'),
('fysiker','1|fysik'),
('fysikforskare','1|fysiker'),
('fysikforskning','1|fysik'),
('fysiklärare','1|lärare'),
('fysikprofessor','1|professor'),
('fysikvetenskap','1|fysik'),
('fysiljera','1|arkebusera'),
('fysiljerande','1|fysiljera'),
('fysiljerbar','1|fysiljera'),
('fysiljerbarhet','1|fysiljerbar'),
('fysiljering','1|fysiljera'),
('fysiokrat','1|fysiokratism'),
('fysiokratisk','1|jordbruk'),
('fysiokratism','1|teori'),
('fysiolog','1|fysiologi'),
('fysiologi','1|organism'),
('fysiologisk','1|fysiologi'),
('fysionomi','1|anletsdrag'),
('fysioterapeut','1|fysioterapi'),
('fysioterapi','1|sjukgymnastik'),
('fysisk','1|materia'),
('fysisk','2|kropp'),
('fytotron','1|laboratorium'),
('få','1|ge'),
('få','2|mången'),
('få','3|tillåta'),
('fående','1|få'),
('fåfäng','1|flärdfull'),
('fåfäng','2|förgäves'),
('fåfänga','1|fåfäng'),
('fåfänghet','1|fåfäng'),
('fåfänglig','1|fåfäng'),
('fåfänglighet','1|fåfänglig'),
('fåfänglighet','2|fåfänga'),
('fågel','1|djur'),
('fågel','2|fågel'),
('fågelart','1|fågel'),
('fågelbad','1|bad'),
('fågelbo','1|bo'),
('fågelbord','1|mata'),
('fågelbur','1|bur'),
('fågelbär','1|körsbär'),
('fågelbössa','1|bössa'),
('fågeldans','1|dans'),
('fågeldun','1|dun'),
('fågelfjäder','1|fjäder'),
('fågelfot','1|fot'),
('fågelfri','1|fredlös'),
('fågelfänge','1|fånga'),
('fågelhagel','1|hagel'),
('fågelholk','1|bo'),
('fågelhund','1|jakthund'),
('fågelinfluensa','1|influensa'),
('fågelinventerare','1|inventera'),
('fågeljakt','1|jakt'),
('fågelkam','1|kam'),
('fågelkunnig','1|kunnig'),
('fågelkunnighet','1|fågelkunnig'),
('fågelkvitter','1|kvitter'),
('fågelmat','1|mat'),
('fågelmatare','1|fågelbord'),
('fågelperspektiv','1|perspektiv'),
('fågelpopulation','1|population'),
('fågelskrämma','1|skrämma'),
('fågelskytt','1|skjuta'),
('fågelskytte','1|skjuta'),
('fågelskådare','1|teckentydare'),
('fågelskådare','2|ornitolog'),
('fågelskådning','1|fågelskådare'),
('fågelskådning','2|fågelskådare'),
('fågelsnara','1|snara'),
('fågelsträck','1|flock'),
('fågelsång','1|sång'),
('fågeltom','1|fågel'),
('fågelträck','1|träck'),
('fågelunge','1|fågel'),
('fågelvinge','1|vinge'),
('fågelvurm','1|vurm'),
('fågelvägen','1|väg'),
('fågelägg','1|ägg'),
('fågelö','1|ö'),
('fåglalåt','1|fågelsång'),
('Fåglum','1|tävlingscyklist'),
('fåkunnig','1|okunnig'),
('fåkunnighet','1|fåkunnig'),
('fåle','1|föl'),
('fåll','1|tygkant'),
('fålla','1|fåll'),
('fålla','2|inhägnad'),
('fållande','1|fålla'),
('fållbänk','1|säng'),
('fållning','1|fålla'),
('fåmannavälde','1|oligarki'),
('fåmansföretag','1|företag'),
('fåmäld','1|tystlåten'),
('fåmäld','1|tystlåten'),
('fåmäldhet','1|fåmäld'),
('fån','1|fåne'),
('fåne','1|idiot'),
('fåneri','1|fånig'),
('fång','1|rymdmått'),
('fång','2|förvärv'),
('fång','3|sjukdom'),
('fånga','1|ta'),
('fånga','2|beskriva'),
('fångande','1|fånga'),
('fångande','2|fånga'),
('fångbevakning','1|bevaka'),
('fångdräkt','1|dräkt'),
('fånge','1|fånga'),
('fången','1|fånga'),
('fångenskap','1|fånga'),
('fångeshandling','1|handling'),
('fångesman','1|fång'),
('fånggård','1|fängelsegård'),
('fångkläder','1|kläder'),
('fånglina','1|lina'),
('fångläger','1|läger'),
('fångst','1|fånga'),
('fångstanordning','1|anordning'),
('fångstfartyg','1|fiskefartyg'),
('fångstfolk','1|folk'),
('fångstgrop','1|grop'),
('fångstkrok','1|krok'),
('fångstkultur','1|kultur'),
('fångstplats','1|plats'),
('fångstredskap','1|redskap'),
('fångstsamhälle','1|samhälle'),
('fångstsätt','1|fånga'),
('fångtransport','1|transport'),
('fånguppror','1|uppror'),
('fångutväxling','1|utväxling'),
('fångvaktare','1|vakta'),
('fångvård','1|fängelse'),
('fångvårdsanstalt','1|anstalt'),
('fånig','1|löjlig'),
('fånighet','1|fånig'),
('fånskratt','1|fånskratta'),
('fånskratta','1|skratta'),
('fånskrattande','1|fånskratta'),
('fåntratt','1|fånig'),
('fåordig','1|tystlåten'),
('fåordighet','1|fåordig'),
('får','1|husdjur'),
('fåra','1|gräva'),
('fåra','2|fåra'),
('fårahage','1|hage'),
('fåraherde','1|herde'),
('fårahjord','1|hjord'),
('fåraktig','1|enfaldig'),
('fåraktighet','1|fåraktig'),
('fårande','1|fåra'),
('Fårarp','1|mosse'),
('fåravel','1|avel'),
('fårbete','1|bete'),
('fårbogsärm','1|puffärm'),
('fårbonde','1|bonde'),
('fårfarmare','1|farmare'),
('fårfiol','1|lår'),
('fårfålla','1|fålla'),
('fårhjord','1|hjord'),
('fårhund','1|vallhund'),
('fårhus','1|hus'),
('fårhuvud','1|huvud'),
('fårkätte','1|kätte'),
('fårkött','1|kött'),
('fårmjölk','1|mjölk'),
('fårost','1|ost'),
('fårsex','1|tidelag'),
('fårskalle','1|dumbom'),
('fårskinn','1|skinn'),
('fårskötsel','1|skötsel'),
('fårsvingel','1|gräs'),
('fårtarm','1|tarm'),
('fårticka','1|svamp'),
('fårull','1|ull'),
('fåtal','1|fåtalig'),
('fåtalig','1|få'),
('fåtalighet','1|fåtalig'),
('fåtölj','1|möbel'),
('fåvitsk','1|tanklös'),
('fåvitskhet','1|fåvitsk'),
('fä','1|boskap'),
('fä','2|ohyfsad'),
('fäaktig','1|fä'),
('fäaktighet','1|fäaktig'),
('fäbless','1|förkärlek'),
('fäbless','1|förkärlek'),
('fäbod','1|ladugård'),
('fäbodstinta','1|stinta'),
('fäbodställe','1|fäbod'),
('fäbodvall','1|fäbod'),
('fäderne','1|far'),
('fädernearv','1|arv'),
('fädernegård','1|gård'),
('fädernehem','1|födelsehem'),
('fädernejord','1|jord'),
('fädernesida','1|fäderne'),
('fädernesland','1|fosterland'),
('fädernesläkt','1|släkt'),
('fädernestad','1|födelsestad'),
('fäderneärvd','1|fädernearv'),
('fägata','1|väg'),
('fägna','1|glädja'),
('fägnad','1|fägna'),
('fägnande','1|fägna'),
('fägnas','1|fägna'),
('fägnesam','1|fägnad'),
('fägring','1|fager'),
('fähund','1|fä'),
('fähus','1|ladugård'),
('fäkta','1|strida'),
('fäkta','2|vifta'),
('fäktande','1|fäkta'),
('fäktande','2|fäkta'),
('fäktare','1|fäkta'),
('fäktas','1|fäkta'),
('fäktkonst','1|fäkta'),
('fäktmästare','1|mästare'),
('fäktning','1|sport'),
('fäktningsmatch','1|match'),
('fälb','1|sammet'),
('fälg','1|hjul'),
('fälgborste','1|borste'),
('fälgkors','1|skruvnyckel'),
('fälgrengöring','1|rengöring'),
('fälgtvätt','1|tvätt'),
('fäll','1|täcke'),
('fälla','1|falla'),
('fälla','2|vika'),
('fälla','3|fånga'),
('fälla','4|tappa'),
('fälla','5|dom'),
('fälla','6|döda'),
('fällande','1|fälla'),
('fällande','2|fälla'),
('fällande','3|fälla'),
('fällande','4|fälla'),
('fällbar','1|fälla_ihop'),
('fällbarhet','1|fällbar'),
('fällbom','1|bom'),
('fällbord','1|bord'),
('fällkil','1|kil'),
('fällkniv','1|fickkniv'),
('fällköl','1|köl'),
('fällning','1|fälla'),
('fällning','2|fälla'),
('fällning','3|fälla'),
('fällning','4|klump'),
('fällstol','1|stol'),
('fält','1|mark'),
('fält','2|område'),
('fält','3|yta'),
('fält','4|deltagare'),
('fält','5|kraftfält'),
('fältarbete','1|studera'),
('fältarmé','1|armé'),
('fältartilleri','1|artilleri'),
('fältassistent','1|socialassistent'),
('fältbegravning','1|begravning'),
('fältbiolog','1|fältbiologi'),
('fältbiologi','1|biologi'),
('fältflaska','1|flaska'),
('fältflygare','1|underofficer'),
('fältförsök','1|försök'),
('fältgrå','1|grå'),
('fälthare','1|hare'),
('fältherre','1|anföra'),
('fältherreblick','1|blick'),
('fälthöns','1|rapphöns'),
('fältjägare','1|jägare'),
('fältjägarkår','1|fältjägare'),
('fältkikare','1|kikare'),
('fältkirurg','1|kirurg'),
('fältkök','1|spis'),
('fältmarsch','1|marsch'),
('fältmarskalk','1|officer'),
('fältmarskalkinna','1|fältmarskalk'),
('fältmässig','1|militär'),
('fältmässighet','1|fältmässig'),
('fältmätning','1|kartlägga'),
('fältpost','1|post'),
('fältpostcensur','1|censur'),
('fältpostkort','1|fältpost'),
('fältpräst','1|präst'),
('fältrop','1|motto'),
('fältsjukhus','1|sjukhus'),
('fältskytte','1|skytte'),
('fältskär','1|läkare'),
('fältslag','1|slag'),
('fältspat','1|mineral'),
('fältstudium','1|fältarbete'),
('fältstyrka','1|elektricitet'),
('fälttecken','1|tecken'),
('fälttjänst','1|fälttjänstgöring'),
('fälttjänstgöring','1|tjänstgöring'),
('fälttjänstövning','1|militärövning'),
('fälttåg','1|krig'),
('fälttågsplan','1|plan'),
('fälttävlan','1|idrottstävling'),
('fältuniform','1|uniform'),
('fänad','1|boskap'),
('fängelse','1|fånge'),
('fängelsecell','1|cell'),
('fängelsechef','1|chef'),
('fängelsedirektör','1|direktör'),
('fängelsedom','1|dom'),
('fängelsedömd','1|döma'),
('fängelseförhållande','1|förhållande'),
('fängelsegaller','1|galler'),
('fängelsegård','1|rastgård'),
('fängelsehåla','1|fängelse'),
('fängelsekund','1|fånge'),
('fängelseläger','1|fångläger'),
('fängelsestraff','1|straff'),
('fängelsetak','1|tak'),
('fängelsetatuering','1|tatuering'),
('fängelseteater','1|teater'),
('fänghål','1|ladda'),
('fängsel','1|boja'),
('fängsla','1|fånga'),
('fängsla','2|intressera'),
('fängslande','1|fängsla'),
('fängslande','2|fängsla'),
('fängslande','3|fängsla'),
('fängslig','1|fängelse'),
('fängsling','1|fängsla'),
('fänkål','1|krydda'),
('fänrik','1|officer'),
('färd','1|fara'),
('färdas','1|fara'),
('färdbevis','1|biljett'),
('färdbiljett','1|biljett'),
('färdig','1|slut'),
('färdig','2|slut'),
('färdigbehandlad','1|behandla'),
('färdigbildad','1|färdig'),
('färdigblandad','1|blanda'),
('färdigbygga','1|bygga'),
('färdigbyggande','1|färdigbygga'),
('färdighet','1|förmåga'),
('färdighetsträning','1|träning'),
('färdighetsämne','1|ämne'),
('färdigjäsa','1|jäsa'),
('färdigjäsande','1|färdigjäsa'),
('färdigjäsning','1|färdigjäsa'),
('färdigkokt','1|koka'),
('färdigkämpad','1|kämpa'),
('färdiglagad','1|mat'),
('färdigmat','1|mat'),
('färdigpackad','1|packa'),
('färdigskivad','1|skiva'),
('färdigskriven','1|skriva'),
('färdigskulpterad','1|skulptera'),
('färdigskämtad','1|skämta'),
('färdigställa','1|färdig'),
('färdigställande','1|färdigställa'),
('färdigutbildad','1|färdigbildad'),
('färdigutbildad','2|utbildning'),
('färdigutvecklad','1|utveckla'),
('färdknäpp','1|sup'),
('färdkost','1|kost'),
('färdled','1|väg'),
('färdledare','1|ledare'),
('färdmedel','1|transport'),
('färdriktning','1|riktning'),
('färdskrivare','1|kontroll'),
('färdsup','1|färdknäpp'),
('färdsätt','1|färdas'),
('färdtjänst','1|skjuts'),
('färdväg','1|väg'),
('färg','1|PRIM'),
('färg','2|färg'),
('färg','3|kort'),
('färg','4|poker'),
('färga','1|färg'),
('färga','2|färga_av_sig'),
('färgad','1|svart'),
('färgande','1|färga'),
('färgare','1|färga'),
('färgbad','1|bad'),
('färgband','1|skrivmaskin'),
('färgbehandling','1|måla'),
('färgbeständig','1|beständig'),
('färgbeständighet','1|färgbeständig'),
('färgbild','1|bild'),
('färgblandning','1|blandning'),
('färgblandning','2|blanda'),
('färgblind','1|oförmåga'),
('färgblindhet','1|färgblind'),
('färgborttagning','1|avlägsna'),
('färgbrytning','1|färgblandning'),
('färgbrytning','2|färgblandning'),
('färgdelad','1|dela'),
('Färgelanda','1|Göteborg'),
('färgeri','1|färga'),
('färgfilm','1|film'),
('färgfilter','1|fotografi'),
('färgflagnande','1|flagna'),
('färgfläck','1|fläck'),
('färgförändring','1|förändring'),
('färgglad','1|färg'),
('färgglans','1|glans'),
('färggrann','1|färg'),
('färggrannhet','1|färggrann'),
('färghandel','1|affär'),
('färgharmoni','1|harmoni'),
('färgig','1|färg'),
('färgillustration','1|illustration'),
('färgklick','1|detalj'),
('färgkonstans','1|upplevelse'),
('färgkontrast','1|kontrast'),
('färgkrita','1|måla'),
('färgkänslig','1|känslig'),
('färgkänslighet','1|färgkänslig'),
('färglagd','1|färglägga'),
('färglitografi','1|litografi'),
('färglåda','1|låda'),
('färglägga','1|måla'),
('färgläggande','1|färglägga'),
('färgläggning','1|färglägga'),
('färglära','1|lära'),
('färglös','1|färg'),
('färglöshet','1|färglös'),
('färgmässig','1|färg'),
('färgmättad','1|färg'),
('färgmönster','1|mönster'),
('färgning','1|färga'),
('färgnyans','1|färg'),
('färgpenna','1|penna'),
('färgpigment','1|pigment'),
('färgprakt','1|prakt'),
('färgreproduktion','1|reproduktion'),
('färgrik','1|färg'),
('färgrikedom','1|färgrik'),
('färgrikhet','1|färgrik'),
('färgrivning','1|bereda'),
('färgsammansättning','1|färg'),
('färgsammansättning','2|sammansättning'),
('färgseende','1|synförmåga'),
('färgsinne','1|konstnärlig'),
('färgskala','1|skala'),
('färgskalle','1|kontraströntgen'),
('färgskiftning','1|skiftning'),
('färgskrapa','1|skrapa'),
('färgspektrum','1|spektrum'),
('färgspel','1|färg'),
('färgsprakande','1|färggrann'),
('färgspridning','1|ljus'),
('färgspruta','1|spruta'),
('färgsprutning','1|sprutning'),
('färgsprutpistol','1|färgspruta'),
('färgstark','1|färg'),
('färgstarkhet','1|färgstark'),
('färgstege','1|stege'),
('färgstoff','1|färg'),
('färgsättning','1|färg'),
('färgsättning','2|färg'),
('färgtemperatur','1|temperatur'),
('färgteve','1|TV'),
('färgteve','1|TV'),
('färgton','1|egenskap'),
('färgtryck','1|tryck'),
('färgval','1|val'),
('färgväxling','1|växla'),
('färgäkta','1|beständig'),
('färgämne','1|ämne'),
('färing','1|Färöarna'),
('färing','1|Färöarna'),
('färja','1|båt'),
('färja','2|färja'),
('färjande','1|färja'),
('färjeankomst','1|ankomst'),
('färjeavgång','1|avgång'),
('färjeläge','1|plats'),
('färjelägenhet','1|tur'),
('färjeolycka','1|olycka'),
('färjepassagerare','1|passagerare'),
('färjeterminal','1|terminal'),
('färjetidtabell','1|tidtabell'),
('färjetrafik','1|trafik'),
('färjetransport','1|transport'),
('färjetur','1|tur'),
('färjetur','2|tur'),
('färjkarl','1|skeppare'),
('färla','1|redskap'),
('färna','1|mört'),
('färnbock','1|träslag'),
('färre','1|få'),
('färs','1|köttfärs'),
('färsera','1|färs'),
('färserande','1|färsera'),
('färserbar','1|färsera'),
('färserbarhet','1|färserbar'),
('färsering','1|färsera'),
('färsk','1|ny'),
('färska','1|stål'),
('färskande','1|färska'),
('färskhet','1|färsk'),
('färsking','1|färsk'),
('färskmalm','1|färska'),
('färskmat','1|mat'),
('färskning','1|färska'),
('färskost','1|ost'),
('färskpotatis','1|potatis'),
('färskpressad','1|pressa'),
('färsksmide','1|färska'),
('färskvara','1|mat'),
('färskvarudisk','1|disk'),
('färskvatten','1|sötvatten'),
('färsköl','1|öl'),
('Färöarna','1|ögrupp'),
('Färöarna','2|territorium'),
('färöisk','1|Färöarna'),
('färöisk','2|färöiska'),
('färöiska','1|språk'),
('färöiska','2|färing'),
('Fässberg','1|Göteborg'),
('fäst','1|fästa_sig'),
('fästa','1|fast'),
('fästad','1|fästa'),
('fästande','1|fästa'),
('fästanordning','1|fästa'),
('fäste','1|fast'),
('fäste','2|fästning'),
('fäste','3|handtag'),
('fäste','4|stödja'),
('fästefolk','1|förlovad'),
('fästfolk','1|förlovad'),
('fästing','1|insekt'),
('fästingburen','1|sprida'),
('fästingfeber','1|infektionssjukdom'),
('fästingvirus','1|virus'),
('fästjärn','1|fästa'),
('fästkrok','1|krok'),
('fästman','1|förlovad'),
('fästmanssoffa','1|soffa'),
('fästmö','1|förlovad'),
('fästning','1|skydda'),
('fästning','2|fängelse'),
('fästningsfånge','1|fånge'),
('fästningsgrav','1|vallgrav'),
('fästningskommendant','1|kommendant'),
('fästningsliknande','1|fästning'),
('fästningsmur','1|mur'),
('fästningsstraff','1|straff'),
('fästningsvall','1|vall'),
('fästplatta','1|platta'),
('fästpunkt','1|punkt'),
('fästskruv','1|skruv'),
('fäsör','1|författare'),
('föda','1|skapa'),
('föda','2|mat'),
('föda','3|förse'),
('födande','1|föda'),
('födande','2|föda'),
('födas','1|föda'),
('född','1|födas'),
('födelse','1|födas'),
('födelseattest','1|attest'),
('födelsebygd','1|bygd'),
('födelsedag','1|dag'),
('födelsedagsbarn','1|födelsedag'),
('födelsedagsfest','1|fest'),
('födelsedagsgåva','1|gåva'),
('födelsedagskalas','1|kalas'),
('födelsedagsmiddag','1|middag'),
('födelsedagspresent','1|present'),
('födelsedagsstress','1|stress'),
('födelsedagstårta','1|tårta'),
('födelsedatum','1|datum'),
('födelsehem','1|hem'),
('födelsekalas','1|födelsedagskalas'),
('födelsekontroll','1|barnbegränsning'),
('födelsemärke','1|märke'),
('födelsenummer','1|personnummer'),
('födelseort','1|ort'),
('födelsestad','1|stad'),
('födelsetal','1|antal'),
('födelsetal','1|antal'),
('födelsetal','1|antal'),
('födelsetimme','1|timme'),
('födelseår','1|år'),
('födgeni','1|överleva'),
('födkrok','1|arbete'),
('födoorganism','1|organism'),
('födopartikel','1|partikel'),
('födoråd','1|rättighet'),
('födoämne','1|föda'),
('födsel','1|föda'),
('födsel','1|föda'),
('födslorätt','1|rättighet'),
('födsloskri','1|skri'),
('födslostund','1|födelse'),
('födslovånda','1|vånda'),
('födslovärk','1|värk'),
('föga','1|liten'),
('föga','2|liten'),
('fögderi','1|skatt'),
('fögderiförvaltning','1|förvaltning'),
('föhn','1|vind'),
('föhn','1|vind'),
('föl','1|häst'),
('föla','1|föda'),
('fölande','1|föla'),
('följa','1|efter'),
('följaktig','1|därmed'),
('följaktligen','1|alltså'),
('följande','1|följa'),
('följande','2|följa'),
('följd','1|följa'),
('följdenlig','1|konsekvent'),
('följdenlighet','1|följdenlig'),
('följdfråga','1|fråga'),
('följdproblem','1|problem'),
('följdriktig','1|självfallen'),
('följdriktighet','1|följdriktig'),
('följdsats','1|slutsats'),
('följdsjukdom','1|sjukdom'),
('följdverkning','1|inverkan'),
('följe','1|följa'),
('följebil','1|bil'),
('följebrev','1|brev'),
('följesedel','1|dokument'),
('följeslagare','1|följa'),
('följeslagarinna','1|följeslagare'),
('följetong','1|roman'),
('följetongsmässig','1|följetong'),
('följsam','1|anpassa'),
('följsamhet','1|följsam'),
('fölning','1|föla'),
('fölsto','1|sto'),
('fölunge','1|föl'),
('fön','1|föna'),
('föna','1|torka'),
('fönande','1|föna'),
('fönster','1|öppning'),
('fönster','2|fönsterruta'),
('fönsterbeslag','1|beslag'),
('fönsterbleck','1|plåtlist'),
('fönsterbord','1|bord'),
('fönsterbräda','1|hylla'),
('fönsterbräda','1|hylla'),
('fönsterbåge','1|ram'),
('fönsterbänk','1|fönsterbräda'),
('fönsterdraperi','1|draperi'),
('fönsterfärg','1|färg'),
('fönstergaller','1|galler'),
('fönsterglas','1|glas'),
('fönsterglugg','1|glugg'),
('fönsterhake','1|hake'),
('fönsterhasp','1|hasp'),
('fönsterkarm','1|karm'),
('fönsterkitt','1|kitt'),
('fönsterkuvert','1|kuvert'),
('fönsterlav','1|lav'),
('fönsterlucka','1|lucka'),
('fönsterluft','1|fönster'),
('fönsterlös','1|fönster'),
('fönsternisch','1|nisch'),
('fönsterplats','1|sittplats'),
('fönsterpost','1|fönsterkarm'),
('fönsterputs','1|putsa'),
('fönsterputs','2|medel'),
('fönsterputsare','1|putsa'),
('fönsterputsduk','1|putsduk'),
('fönsterputsning','1|putsa'),
('fönsterputsvätska','1|medel'),
('fönsterrektangel','1|rektangel'),
('fönsterruta','1|fönsterglas'),
('fönstershoppa','1|shoppa'),
('fönstershoppande','1|fönstershoppa'),
('fönstershoppning','1|fönstershoppa'),
('fönstershoppning','1|fönstershoppa'),
('fönstersmyg','1|fönsternisch'),
('fönsterspringa','1|springa'),
('fönsterstolpe','1|fönster'),
('fönstertittare','1|smygtitta'),
('fönsteröppning','1|öppning'),
('fönsteröppning','2|öppna'),
('för','1|åt'),
('för','1|åt'),
('för','2|PRIM'),
('för','3|alltför'),
('för','4|framdel'),
('för','5|på_grund_av'),
('för','6|rekommendera'),
('för','7|hindra'),
('för','8|för'),
('för','9|byta'),
('föra','1|röra'),
('förakt','1|förakta'),
('förakta','1|dålig'),
('föraktande','1|förakta'),
('föraktfull','1|förakt'),
('föraktfullhet','1|föraktfull'),
('föraktlig','1|förakt'),
('föraktlighet','1|föraktlig'),
('förallmänliga','1|generalisera'),
('förallmänligande','1|förallmänliga'),
('förande','1|föra'),
('förandliga','1|andlig'),
('förandligad','1|besjäla'),
('förandligande','1|förandliga'),
('föraning','1|ana'),
('förankra','1|ankare'),
('förankra','2|underbygga'),
('förankrande','1|förankra'),
('förankrande','2|förankra'),
('förankring','1|förankra'),
('förankring','2|förankra'),
('föranleda','1|förorsaka'),
('föranledande','1|föranleda'),
('föranledning','1|föranleda'),
('föranlåta','1|förorsaka'),
('föranlåten','1|tvinga'),
('föranmäla','1|anmäla'),
('föranmälan','1|föranmäla'),
('föranmälande','1|föranmäla'),
('föranmälning','1|föranmäla'),
('förannonsera','1|annonsera'),
('förannonserande','1|förannonsera'),
('förannonserbar','1|förannonsera'),
('förannonserbarhet','1|förannonserbar'),
('förannonsering','1|förannonsera'),
('föranstalta','1|åtgärd'),
('föranstaltan','1|föranstalta'),
('föranstaltande','1|föranstalta'),
('föranstaltning','1|föranstalta'),
('förarbeta','1|förbereda'),
('förarbetande','1|förarbeta'),
('förarbete','1|förbereda'),
('förarbetning','1|förarbeta'),
('förare','1|köra'),
('förarga','1|arg'),
('förargad','1|förarga'),
('förargande','1|förarga'),
('förargas','1|förarga'),
('förargelse','1|förarga'),
('förargelseklippa','1|orsak'),
('förargelseväckande','1|vålla'),
('förarglig','1|förarga'),
('förarglighet','1|förarglig'),
('förarhytt','1|hytt'),
('förarkabin','1|kabin'),
('förarlös','1|förare'),
('förarplats','1|plats'),
('förarruta','1|bilruta'),
('förarsits','1|sits'),
('förband','1|förbinda'),
('förband','2|militär'),
('förband','3|mura'),
('förband','4|hålla_samman'),
('förband','5|band'),
('förbandsartikel','1|förband'),
('förbandslåda','1|låda'),
('förbandsplats','1|plats'),
('förbandsteknik','1|teknik'),
('förbanna','1|önska'),
('förbannad','1|arg'),
('förbannad','2|jävla'),
('förbannande','1|förbanna'),
('förbannelse','1|förbanna'),
('förbarmande','1|förbarma_sig'),
('förbaskad','1|arg'),
('förbaskad','2|förbannad'),
('förbaskat','1|förbaskad'),
('förbehandling','1|behandling'),
('förbehåll','1|förbehålla'),
('förbehålla','1|garantera'),
('förbehållande','1|förbehålla'),
('förbehållsam','1|reserverad'),
('förbehållsamhet','1|förbehållsam'),
('förbehållslös','1|förbehåll'),
('förbehållslöshet','1|förbehållslös'),
('förbemälde','1|nämna'),
('förbenad','1|förstockad'),
('förbenad','2|förbaskad'),
('förbenad','3|förbaskad'),
('förbereda','1|beredd'),
('förberedande','1|förbereda'),
('förberedande','2|förbereda'),
('förberedd','1|förbereda'),
('förberedelse','1|förbereda'),
('förberedelsearbete','1|förberedelse'),
('förberedelsetid','1|tid'),
('förberg','1|utlöpare'),
('förbeställa','1|beställa'),
('förbeställande','1|förbeställa'),
('förbeställning','1|förbeställa'),
('förbi','1|vid'),
('förbi','2|uttröttad'),
('förbi','3|slut'),
('förbida','1|invänta'),
('förbidan','1|förbida'),
('förbidande','1|förbida'),
('förbifart','1|fara'),
('förbifartsled','1|trafikled'),
('förbigå','1|bortse'),
('förbigående','1|avseende'),
('förbigången','1|förbigå'),
('förbiilande','1|ila'),
('förbilliga','1|billig'),
('förbilligande','1|förbilliga'),
('förbinda','1|förena'),
('förbinda','2|sår'),
('förbindande','1|förbinda'),
('förbindande','2|förbinda'),
('förbindelse','1|förbinda'),
('förbindelse','2|skyldighet'),
('förbindelsearbete','1|förbindelse'),
('förbindelsegrav','1|löpgrav'),
('förbindelsegång','1|gång'),
('förbindelseled','1|led'),
('förbindelselinje','1|förbindelse'),
('förbindelselänk','1|förbindelse'),
('förbindelsemedel','1|förbindelse'),
('förbindelseofficer','1|sambandsofficer'),
('förbindlig','1|artig'),
('förbindlighet','1|förbindlig'),
('förbindning','1|förbinda'),
('förbipasserande','1|passera'),
('förbise','1|bortse'),
('förbisedd','1|förbise'),
('förbiseende','1|förbise'),
('förbiskyndande','1|skynda'),
('förbistrad','1|förbistring'),
('förbistring','1|förstå'),
('förbisvepande','1|svepa'),
('förbisvischande','1|svischa'),
('förbittra','1|bitter'),
('förbittrad','1|förbittra'),
('förbittrande','1|förbittra'),
('förbittring','1|förbittra'),
('förbjuda','1|tillåta'),
('förbjudande','1|förbjuda'),
('förbjuden','1|förbjuda'),
('förbjudenhet','1|förbjuden'),
('förblanda','1|förväxla'),
('förblandande','1|förblanda'),
('förblandning','1|förblanda'),
('förblekna','1|blek'),
('förbleknande','1|förblekna'),
('förbli','1|lik'),
('förblinda','1|blind'),
('förblindande','1|förblinda'),
('förblivande','1|bestående'),
('förblivande','2|förbli'),
('förblommerad','1|försköna'),
('förbluffa','1|förbluffad'),
('förbluffad','1|förvånad'),
('förbluffande','1|förbluffa'),
('förbluffande','2|förbluffa'),
('förblöda','1|blöda'),
('förblödande','1|förblöda'),
('förblödning','1|förblöda'),
('förbommad','1|stänga'),
('förborga','1|gömma'),
('förborgande','1|förborga'),
('förborgerliga','1|borgerlig'),
('förborgerligande','1|förborgerliga'),
('förbrinna','1|brinna'),
('förbrinnande','1|förbrinna'),
('förbroskas','1|brosk'),
('förbruka','1|använda'),
('förbrukande','1|förbruka'),
('förbrukare','1|förbruka'),
('förbrukning','1|förbruka'),
('förbrukningsartikel','1|artikel'),
('förbrukningsmaterial','1|material'),
('förbrylla','1|förvåna'),
('förbryllande','1|förbrylla'),
('förbrytarband','1|förbrytare'),
('förbrytare','1|brottsling'),
('förbrytelse','1|brott'),
('förbränna','1|bränna'),
('förbrännande','1|förbränna'),
('förbränning','1|förbränna'),
('förbränningsmotor','1|motor'),
('förbränningsprodukt','1|produkt'),
('förbrödra','1|förbrödring'),
('förbrödrande','1|förbrödra'),
('förbrödring','1|vänskap'),
('förbrödringsfest','1|fest'),
('förbud','1|förbjuda'),
('förbudslag','1|lag'),
('förbudslagstiftning','1|lagstiftning'),
('förbudslinje','1|princip'),
('förbund','1|förening'),
('förbunden','1|tacksam'),
('förbundenhet','1|förbunden'),
('förbundsarken','1|budord'),
('förbundsbrev','1|brev'),
('förbundsdag','1|parlament'),
('förbundskansler','1|ledare'),
('förbundskapten','1|ledare'),
('förbundspresident','1|statschef'),
('förbundsregering','1|regering'),
('förbundsrepublik','1|förbundsstat'),
('Förbundsrepubliken','1|Västtyskland'),
('förbundsstat','1|stat'),
('förbundsstyrelse','1|styrelse'),
('förbundsvis','1|förbund'),
('förbundsvis','2|förbundsvis'),
('förbuska','1|buske'),
('förbuskande','1|förbuska'),
('förbygga','1|säkra'),
('förbyggande','1|förbygga'),
('förbyggnad','1|förbygga'),
('förbyta','1|förvandla'),
('förbytande','1|förbyta'),
('förbytning','1|förbyta'),
('förbålt','1|förbaskat'),
('förbätterlig','1|förbättra'),
('förbätterlighet','1|förbätterlig'),
('förbättra','1|bra'),
('förbättrande','1|förbättra'),
('förbättring','1|förbättra'),
('förbättringsarbete','1|förbättring'),
('förbättringslån','1|lån'),
('förbättringslån','1|lån'),
('förbättringspotential','1|potential'),
('förbön','1|bön'),
('förcolumbisk','1|Columbus'),
('förcolumbisk','1|Columbus'),
('fördel','1|bra'),
('fördela','1|sprida'),
('fördelaktig','1|fördel'),
('fördelaktighet','1|fördelaktig'),
('fördelande','1|fördela'),
('fördelare','1|fördela'),
('fördelning','1|fördela'),
('fördelning','2|division'),
('fördelning','3|statistik'),
('fördelningsmässig','1|fördelning'),
('fördelningspolitik','1|politik'),
('fördelningspolitisk','1|fördelningspolitik'),
('fördenskull','1|därför'),
('fördetta','1|före_detta'),
('fördetting','1|före_detta'),
('fördevind','1|vind'),
('fördevind','2|fördevind'),
('fördjupa','1|djup'),
('fördjupande','1|fördjupa'),
('fördjupning','1|håla'),
('fördjupning','2|fördjupa'),
('fördjupningskurs','1|kurs'),
('fördjupningsreportage','1|reportage'),
('fördold','1|hemlig'),
('fördoldhet','1|fördold'),
('fördom','1|åsikt'),
('fördomsalstrande','1|fördom'),
('fördomsfri','1|fördom'),
('fördomsfrihet','1|fördomsfri'),
('fördomsfull','1|fördom'),
('fördomsfullhet','1|fördomsfull'),
('fördra','1|tåla'),
('fördrag','1|avtal'),
('fördragande','1|fördra'),
('fördragen','1|täcka'),
('fördragenhet','1|fördragen'),
('fördragsam','1|tålamod'),
('fördragsamhet','1|fördragsam'),
('fördragsbrott','1|fördrag'),
('fördragsenlig','1|fördrag'),
('fördragsmässig','1|fördrag'),
('fördragsslutande','1|fördrag'),
('fördragsvidrig','1|fördrag'),
('fördriva','1|bort'),
('fördrivande','1|fördriva'),
('fördrivning','1|fördriva'),
('fördröja','1|sen'),
('fördröjande','1|fördröja'),
('fördröjning','1|fördröja'),
('fördröjningsaktion','1|aktion'),
('fördröjningstaktik','1|taktik'),
('fördrömd','1|fantisera'),
('fördubbla','1|dubbel'),
('fördubblande','1|fördubbla'),
('fördubbling','1|fördubbla'),
('fördumma','1|dum'),
('fördummande','1|fördumma'),
('fördunkla','1|dunkel'),
('fördunklande','1|fördunkla'),
('fördunkling','1|fördunkla'),
('fördunsta','1|avdunsta'),
('fördunstande','1|fördunsta'),
('fördunstning','1|fördunsta'),
('fördyra','1|dyr'),
('fördyrande','1|fördyra'),
('fördyring','1|fördyra'),
('fördystra','1|dyster'),
('fördystrande','1|fördystra'),
('fördäck','1|däck'),
('fördämma','1|fördämning'),
('fördämmande','1|fördämma'),
('fördämning','1|hejda'),
('fördärv','1|fördärva'),
('fördärva','1|förstöra'),
('fördärvande','1|fördärva'),
('fördärvare','1|fördärva'),
('fördärvbringande','1|fördärva'),
('fördärvlig','1|fördärva'),
('fördärvlighet','1|fördärvlig'),
('fördölja','1|dölja'),
('fördöljande','1|fördölja'),
('fördöma','1|döma'),
('fördömande','1|fördöma'),
('fördömd','1|förbannad'),
('fördömdhet','1|fördömd'),
('fördömelse','1|straff'),
('fördömlig','1|fördöma'),
('fördömlighet','1|fördömlig'),
('före','1|PRIM'),
('före','1|PRIM'),
('före','2|väglag'),
('förebild','1|bild'),
('förebildlig','1|förebild'),
('förebildlighet','1|förebildlig'),
('förebrå','1|anklaga'),
('förebråelse','1|förebrå'),
('förebrående','1|förebrå'),
('förebud','1|tecken'),
('förebygga','1|hindra'),
('förebyggande','1|förebygga'),
('förebåda','1|förutsäga'),
('förebådande','1|förebåda'),
('förebådare','1|förebåda'),
('förebära','1|anföra'),
('förebärande','1|förebära'),
('föredra','1|bra'),
('föredra','2|säga'),
('föredrag','1|föreläsa'),
('föredragande','1|föredra'),
('föredragande','2|föredra'),
('föredragande','3|föredra'),
('föredragning','1|föredra'),
('föredragningslista','1|lista'),
('föredragshållare','1|föredrag'),
('föredöme','1|mönster'),
('föredömlig','1|föredöme'),
('föredömlighet','1|föredömlig'),
('förefalla','1|verka'),
('förefallande','1|förefalla'),
('förefinnas','1|finnas'),
('förefintlig','1|förefinnas'),
('förefintlighet','1|förefintlig'),
('förege','1|anföra'),
('föregivande','1|förege'),
('föregiven','1|förege'),
('föregripa','1|före'),
('föregripande','1|föregripa'),
('föregå','1|före'),
('föregå','2|försiggå'),
('föregående','1|föregå'),
('föregående','2|föregå'),
('föregående','3|föregå'),
('föregångare','1|föregå'),
('föregångsexempel','1|exempel'),
('föregångsman','1|leda'),
('föreha','1|ha_för_sig'),
('förehavande','1|föreha'),
('förehålla','1|framhålla'),
('förehållande','1|förehålla'),
('förekomma','1|vara'),
('förekomma','2|hinna'),
('förekommande','1|artig'),
('förekommande','2|förekomma'),
('förekommande','3|förekomma'),
('förekommen','1|förekomma'),
('förekommen','2|förekomma'),
('förekomst','1|förekomma'),
('föreligga','1|finnas'),
('föreliggande','1|föreligga'),
('förelägga','1|ålägga'),
('förelägga','2|överlämna'),
('föreläggande','1|förelägga'),
('föreläggande','2|förelägga'),
('föreläsa','1|lära'),
('föreläsande','1|föreläsa'),
('föreläsare','1|föreläsa'),
('föreläsning','1|föreläsa'),
('föreläsningssal','1|sal'),
('förelöpare','1|förebud'),
('föremål','1|sak'),
('föremål','2|uppmärksamma'),
('förena','1|samman'),
('förenande','1|förena'),
('förening','1|förena'),
('förening','2|ämne'),
('föreningsband','1|förena'),
('föreningsbank','1|bank'),
('föreningsfrihet','1|frihet'),
('föreningsliv','1|förening'),
('föreningslokal','1|lokal'),
('föreningslänk','1|förena'),
('föreningsmängd','1|matematik'),
('föreningsmässig','1|förening'),
('föreningspunkt','1|förena'),
('föreningsrätt','1|föreningsfrihet'),
('föreningsrörelse','1|rörelse'),
('föreningsväsen','1|förening'),
('förenkla','1|enkel'),
('förenklande','1|förenkla'),
('förenkling','1|förenkla'),
('förenlig','1|förena'),
('förenlighet','1|förenlig'),
('föresats','1|avsikt'),
('föreskrift','1|bestämmelse'),
('föreskriftsenlig','1|föreskrift'),
('föreskriftsmässig','1|föreskrift'),
('föreskriva','1|föreskrift'),
('föreskrivande','1|föreskriva'),
('föreslå','1|erbjuda'),
('föreslående','1|föreslå'),
('förespegla','1|hopp'),
('förespeglande','1|förespegla'),
('förespegling','1|förespegla'),
('förespråka','1|rekommendera'),
('förespråkande','1|förespråka'),
('förespråkare','1|förespråka'),
('förestava','1|eftersäga'),
('förestava','2|bestämma'),
('förestavande','1|förestava'),
('förestavande','2|förestava'),
('förestavning','1|förestava'),
('förestavning','2|förestava'),
('förestå','1|leda'),
('förestå','2|bli'),
('förestående','1|förestå'),
('förestående','2|förestå'),
('förestående','3|förestå'),
('föreståndare','1|förestå'),
('föreståndarinna','1|föreståndare'),
('föreställa','1|visa'),
('föreställa','2|presentera'),
('föreställande','1|föreställa'),
('föreställande','2|föreställa'),
('föreställande','3|föreställa'),
('föreställare','1|kanon'),
('föreställning','1|föreställa_sig'),
('föreställning','2|uppträdande'),
('föreställningsförmåga','1|förmåga'),
('föreställningskategori','1|föreställning'),
('föreställningsrepertoar','1|repertoar'),
('föreställningssätt','1|föreställa_sig'),
('föreställningsvärld','1|föreställning'),
('föresväva','1|föreställa_sig'),
('föresvävande','1|föresväva'),
('företa','1|göra'),
('företag','1|arbeta'),
('företag','2|företa'),
('företagande','1|företa'),
('företagaranda','1|anda'),
('företagare','1|företag'),
('företagsam','1|företa'),
('företagsamhet','1|företagsam'),
('företagsbot','1|bot'),
('företagschef','1|chef'),
('företagsdemokrati','1|demokrati'),
('företagsekonom','1|företagsekonomi'),
('företagsekonomi','1|vetenskap'),
('företagsekonomisk','1|ekonomi'),
('företagsfiasko','1|fiasko'),
('företagsfilial','1|filial'),
('företagsgrupp','1|företag'),
('företagshälsovård','1|hälsovård'),
('företagsledare','1|ledare'),
('företagsledning','1|ledning'),
('företagsmässig','1|företag'),
('företagsnämnd','1|nämnd'),
('företagsstyrelse','1|bolagsstyrelse'),
('företagstät','1|tät'),
('företagstäthet','1|företagstät'),
('företagsvinst','1|vinst'),
('företagsvärlden','1|värld'),
('företal','1|förord'),
('förete','1|visa'),
('företeelse','1|sak'),
('företeende','1|förete'),
('företräda','1|ersätta'),
('företrädande','1|företräda'),
('företrädare','1|företräda'),
('företräde','1|rätt'),
('företräde','2|fördel'),
('företrädesrätt','1|företräde'),
('företrädesvis','1|främst'),
('förevara','1|inträffa'),
('förevarande','1|nuvarande'),
('förevarande','2|förevara'),
('föreviga','1|evig'),
('förevigande','1|föreviga'),
('förevisa','1|visa'),
('förevisande','1|förevisa'),
('förevisare','1|förevisa'),
('förevisning','1|förevisa'),
('förevita','1|anklaga'),
('förevitande','1|förevita'),
('förevändning','1|skäl'),
('förfader','1|släkting'),
('förfall','1|förfalla'),
('förfalla','1|sönder'),
('förfalla','2|förfallotid'),
('förfallande','1|förfalla'),
('förfallande','2|förfalla'),
('förfallen','1|förfalla'),
('förfallen','2|förfalla'),
('förfallenhet','1|förfallen'),
('förfallodag','1|dag'),
('förfallotid','1|tid'),
('förfallsperiod','1|period'),
('förfalska','1|falsk'),
('förfalskande','1|förfalska'),
('förfalskare','1|förfalska'),
('förfalskning','1|förfalska'),
('förfalskningsbrott','1|brott'),
('förfara','1|förfarande'),
('förfarande','1|sätt'),
('förfaras','1|förstöras'),
('förfaren','1|skicklig'),
('förfarenhet','1|förfaren'),
('förfaringssätt','1|sätt'),
('författa','1|skriva'),
('författande','1|författa'),
('författardröm','1|dröm'),
('författare','1|författa'),
('författargärning','1|författare'),
('författarinna','1|författare'),
('författarjag','1|jag'),
('författarporträtt','1|porträtt'),
('författarsignatur','1|signatur'),
('författarskap','1|författa'),
('författarskildring','1|skildring'),
('författarvän','1|vän'),
('författaryrket','1|författare'),
('författning','1|lag'),
('författningsdomstol','1|domstol'),
('författningsenlig','1|författning'),
('författningsenlighet','1|författningsenlig'),
('författningsmässig','1|författning'),
('författningsmässighet','1|författningsmässig'),
('författningsstridig','1|författning'),
('författningsstridighet','1|författningsstridig'),
('författningsvidrig','1|författning'),
('förfela','1|misslyckas'),
('förfelande','1|förfela'),
('förfest','1|fest'),
('förfesta','1|förfest'),
('förfestande','1|förfesta'),
('förfina','1|förbättra'),
('förfinad','1|förfina'),
('förfinande','1|förfina'),
('förfining','1|förfinad'),
('förflacka','1|ytlig'),
('förflackande','1|förflacka'),
('förflackning','1|förflacka'),
('förflugen','1|eftertanke'),
('förflugenhet','1|förflugen'),
('förfluten','1|förflyta'),
('förflyktigas','1|avdunsta'),
('förflyta','1|förbi'),
('förflytande','1|förflyta'),
('förflytta','1|flytta'),
('förflyttande','1|förflytta'),
('förflyttning','1|förflytta'),
('förfoga','1|äga'),
('förfogande','1|förfoga'),
('förfogandelag','1|lag'),
('förfoganderätt','1|rätt'),
('förfranska','1|franska'),
('förfranskande','1|förfranska'),
('förfriskning','1|förfriska_sig'),
('förfrusen','1|förfrysa'),
('förfrysa','1|frysa'),
('förfrysande','1|förfrysa'),
('förfrysning','1|förfrysa'),
('förfrågan','1|förfråga_sig'),
('förfrågning','1|förfrågan'),
('förfrämliga','1|göra'),
('förfrämligande','1|förfrämliga'),
('förfula','1|ful'),
('förfulande','1|förfula'),
('förfulning','1|förfula'),
('förfuska','1|förstöra'),
('förfuskande','1|förfuska'),
('förfuskning','1|förfuska'),
('förfånga','1|avlösa'),
('förfångande','1|förfånga'),
('förfäa','1|fördumma'),
('förfäande','1|förfäa'),
('förfäkta','1|åsikt'),
('förfäktande','1|förfäkta'),
('förfäktare','1|förfäkta'),
('förfära','1|skrämma'),
('förfäran','1|förfära'),
('förfärande','1|förfära'),
('förfäras','1|förfära'),
('förfärdiga','1|tillverka'),
('förfärdigande','1|förfärdiga'),
('förfärdigare','1|förfärdiga'),
('förfärlig','1|hemsk'),
('förfärlighet','1|förfärlig'),
('förfärligt','1|mycket'),
('förfölja','1|följa'),
('förföljande','1|förfölja'),
('förföljare','1|förfölja'),
('förföljelse','1|förfölja'),
('förföljelsemani','1|mani'),
('förföra','1|lura'),
('förförande','1|förföra'),
('förförare','1|förföra'),
('förfördela','1|orättvis'),
('förfördelande','1|förfördela'),
('förförelse','1|förföra'),
('förförelsekonst','1|konst'),
('förförerska','1|förföra'),
('förförisk','1|förföra'),
('förföriskhet','1|förförisk'),
('förförståelse','1|förståelse'),
('förgasa','1|gas'),
('förgasande','1|förgasa'),
('förgasare','1|motor'),
('förgasning','1|förgasa'),
('förgifta','1|skada'),
('förgiftande','1|förgifta'),
('förgiftning','1|förgifta'),
('förgjord','1|omöjlig'),
('förglasa','1|glas'),
('förglasande','1|förglasa'),
('förglasning','1|förglasa'),
('förglömd','1|förglömma'),
('förglömma','1|glömma'),
('förglömmande','1|förglömma'),
('förgrenad','1|förgrena_sig'),
('förgrening','1|förgrena_sig'),
('förgripelse','1|förgripa_sig'),
('förgriplig','1|kränka'),
('förgriplighet','1|förgriplig'),
('förgroning','1|gro'),
('förgrova','1|grov'),
('förgrovande','1|förgrova'),
('förgrund','1|framme'),
('förgrundsfigur','1|figur'),
('förgrundsgestalt','1|förgrundsfigur'),
('förgrymma','1|förgrymmad'),
('förgrymmad','1|vred'),
('förgrymmande','1|förgrymma'),
('förgråten','1|gråta'),
('förgråtenhet','1|förgråten'),
('förgrädda','1|grädda'),
('förgräddande','1|förgrädda'),
('förgräddning','1|förgrädda'),
('förgrämd','1|gräma'),
('förgrämdhet','1|förgrämd'),
('förgrämelse','1|förgrämdhet'),
('förgubbas','1|gubbe'),
('förgubbning','1|förgubbas'),
('förgudning','1|dyrka'),
('förgylla','1|guld'),
('förgyllande','1|förgylla'),
('förgyllare','1|förgylla'),
('förgyllning','1|förgylla'),
('förgå','1|försvinna'),
('förgående','1|förgå'),
('förgången','1|förgå'),
('förgård','1|byggnad'),
('förgås','1|gå_under'),
('förgängelse','1|förgänglig'),
('förgänglig','1|förgå'),
('förgänglighet','1|förgänglig'),
('förgäta','1|glömma'),
('förgätande','1|förgäta'),
('förgäten','1|förgäta'),
('förgätmigej','1|blomma'),
('förgäves','1|lyckas'),
('förgöra','1|förstöra'),
('förgörande','1|förgöra'),
('förgörning','1|förgöra'),
('förhala','1|fördröja'),
('förhala','2|hala'),
('förhalande','1|förhala'),
('förhalande','2|förhala'),
('förhall','1|ingång'),
('förhalning','1|förhala'),
('förhalningsförsök','1|försök'),
('förhalningstaktik','1|taktik'),
('förhand','1|hand'),
('förhanden','1|förhandenvarande'),
('förhanden','1|förhandenvarande'),
('förhandenvarande','1|nuvarande'),
('förhandenvaro','1|förhandenvarande'),
('förhandla','1|överens'),
('förhandlande','1|förhandla'),
('förhandlare','1|förhandla'),
('förhandling','1|förhandla'),
('förhandlingsbar','1|förhandla'),
('förhandlingsbarhet','1|förhandlingsbar'),
('förhandlingsbord','1|bord'),
('förhandlingsbricka','1|spelbricka'),
('förhandlingsdelegation','1|delegation'),
('förhandlingsfråga','1|fråga'),
('förhandlingsläge','1|läge'),
('förhandlingsmetod','1|metod'),
('förhandlingsmodell','1|modell'),
('förhandlingsmässig','1|förhandling'),
('förhandlingsrunda','1|förhandling'),
('förhandlingsrätt','1|rätt'),
('förhandlingstrick','1|trick'),
('förhandsbeställning','1|beställning'),
('förhandsboka','1|boka'),
('förhandsbokande','1|förhandsboka'),
('förhandsbokning','1|förhandsboka'),
('förhandsbukt','1|ankarkätting'),
('förhandscensur','1|censur'),
('förhandsinformation','1|information'),
('förhandskopia','1|kopia'),
('förhandsskriven','1|skriva'),
('förhastad','1|hastig'),
('förhatlig','1|hata'),
('förhatlighet','1|förhatlig'),
('förhinder','1|närvaro'),
('förhindra','1|hindra'),
('förhindrande','1|förhindra'),
('förhistoria','1|historia'),
('förhistorisk','1|urtida'),
('förhoppning','1|hoppas'),
('förhoppningsfull','1|förhoppning'),
('förhoppningsfullhet','1|förhoppningsfull'),
('förhoppningsvis','1|hoppas'),
('förhud','1|hudveck'),
('förhudsförträngning','1|förhud'),
('förhuggning','1|hinder'),
('förhyda','1|förstärka'),
('förhydande','1|förhyda'),
('förhydning','1|förhyda'),
('förhydningspapp','1|papp'),
('förhyra','1|hyra'),
('förhyrande','1|förhyra'),
('förhyrning','1|förhyra'),
('förhåll','1|jakt'),
('förhålla','1|tygla'),
('förhållande','1|mellan'),
('förhållande','2|situation'),
('förhållande','3|förhålla'),
('förhållande','4|kärleksförhållande'),
('förhållandevis','1|relativ'),
('förhållas','1|förfara'),
('förhållning','1|dissonans'),
('förhållningsorder','1|order'),
('förhållningsregel','1|regel'),
('förhållningssätt','1|inställning'),
('förhåna','1|håna'),
('förhånande','1|förhåna'),
('förhåning','1|förhåna'),
('förhårdnad','1|hård'),
('förhårdning','1|hård'),
('förhänge','1|draperi'),
('förhärda','1|hård'),
('förhärdande','1|förhärda'),
('förhärdning','1|förhärda'),
('förhärja','1|ödelägga'),
('förhärjande','1|förhärja'),
('förhärjning','1|förhärja'),
('förhärliga','1|försköna'),
('förhärligande','1|förhärliga'),
('förhärska','1|förhärskande'),
('förhärskande','1|dominera'),
('förhärskande','2|förhärska'),
('förhävelse','1|förhäva_sig'),
('förhäxa','1|förtrolla'),
('förhäxande','1|förhäxa'),
('förhäxare','1|förhäxa'),
('förhäxning','1|förhäxa'),
('förhöja','1|höja'),
('förhöjande','1|förhöja'),
('förhöjd','1|förhöja'),
('förhöjning','1|förhöja'),
('förhör','1|förhöra'),
('förhöra','1|fråga'),
('förhörande','1|förhöra'),
('förhörsledare','1|ledare'),
('förhörsprotokoll','1|protokoll'),
('förhörsrum','1|rum'),
('förhörsrumssceneri','1|sceneri'),
('förhörsutskrift','1|utskrift'),
('förhörsvittne','1|vittne'),
('förhöst','1|höst'),
('förindustriell','1|industriell'),
('förinspelad','1|spela_in'),
('förinta','1|förstöra'),
('förintande','1|förinta'),
('förintande','2|förinta'),
('förintelse','1|förinta'),
('förintelseförnekare','1|förneka'),
('förintelsekrig','1|krig'),
('förintelsemuseum','1|museum'),
('Förintelsen','1|förintelse'),
('förintelseverktyg','1|verktyg'),
('förirrelse','1|förirra_sig'),
('förirring','1|förirra_sig'),
('förivring','1|förivra_sig'),
('förjaga','1|driva'),
('förjagande','1|förjaga'),
('förkalkas','1|förkalkning'),
('förkalkning','1|åderförkalkning'),
('förkalkning','2|fälla_ut'),
('förkasta','1|bort'),
('förkastande','1|förkasta'),
('förkastelse','1|fördömelse'),
('förkastelsedom','1|dom'),
('förkastlig','1|fördöma'),
('förkastlighet','1|förkastlig'),
('förkastning','1|spricka'),
('förklara','1|klar'),
('förklara','2|meddela'),
('förklarad','1|avgjord'),
('förklarad','2|överjordisk'),
('förklarande','1|förklara'),
('förklarande','2|förklara'),
('förklaring','1|förklara'),
('förklaring','2|förklara'),
('förklaringsberget','1|berg'),
('förklaringsgrund','1|förklaring'),
('förklaringskraft','1|förmåga'),
('förklaringsmodell','1|modell'),
('förklaringssätt','1|förklara'),
('förklarlig','1|förklara'),
('förklarlighet','1|förklarlig'),
('förklenande','1|nedsättande'),
('förklinga','1|tystna'),
('förklingande','1|förklinga'),
('förklistra','1|klistra'),
('förklistrande','1|förklistra'),
('förklistring','1|förklistra'),
('förklistring','2|stärkelseklister'),
('förklyftning','1|sprickbildning'),
('förklädd','1|förklä_sig'),
('förkläddhet','1|förklädd'),
('förkläde','1|skydd'),
('förkläde','1|skydd'),
('förkläde','2|sällskap'),
('förkläde','2|sällskap'),
('förklädeskjol','1|kjol'),
('förklädnad','1|förklä_sig'),
('förknippa','1|förbinda'),
('förknippande','1|förknippa'),
('förknippning','1|förknippa'),
('förkoksas','1|koks'),
('förkoksas','1|koks'),
('förkolna','1|kol'),
('förkolnande','1|förkolna'),
('förkolning','1|förkolna'),
('förkomma','1|försvinna'),
('förkommande','1|förkomma'),
('förkommen','1|förkomma'),
('förkommenhet','1|förkommen'),
('förkonstlad','1|tillgjord'),
('förkonstling','1|förkonstlad'),
('förkoppra','1|koppar'),
('förkopprande','1|förkoppra'),
('förkoppring','1|förkoppra'),
('förkorta','1|kort'),
('förkorta','2|förenkla'),
('förkortande','1|förkorta'),
('förkortande','2|förkorta'),
('förkortning','1|förkorta'),
('förkortning','2|förkorta'),
('förkovra','1|förkovra_sig'),
('förkovran','1|förkovra_sig'),
('förkovrande','1|förkovra'),
('förkrigstid','1|krig'),
('förkrigstid','1|krig'),
('förkristen','1|kristen'),
('förkroma','1|krom'),
('förkroma','1|krom'),
('förkromande','1|förkroma'),
('förkromande','1|förkroma'),
('förkromning','1|förkroma'),
('förkroppning','1|utsprång'),
('förkroppsliga','1|kropp'),
('förkroppsligande','1|förkroppsliga'),
('förkrossa','1|förkrossad'),
('förkrossad','1|nedslagen'),
('förkrossande','1|förkrossad'),
('förkrossande','2|enorm'),
('förkrossande','3|förkrossa'),
('förkrosselse','1|förkrossad'),
('förkrossning','1|förkrossa'),
('förkrympa','1|krympa'),
('förkrympande','1|förkrympa'),
('förkrympas','1|förkrympt'),
('förkrympning','1|förkrympa'),
('förkrympt','1|växa'),
('förkrympthet','1|förkrympt'),
('förkunna','1|meddela'),
('förkunnande','1|förkunna'),
('förkunnare','1|förkunna'),
('förkunnelse','1|förkunna'),
('förkunskaper','1|kunskap'),
('förkväva','1|hindra'),
('förkvävande','1|förkväva'),
('förkvävning','1|förkväva'),
('förkyld','1|förkyla_sig'),
('förkyldhet','1|förkyld'),
('förkylning','1|sjukdom'),
('förkämpe','1|kämpa'),
('förkänning','1|förkänsla'),
('förkänsla','1|föraning'),
('förkärlek','1|föredra'),
('förkättrad','1|klandra'),
('förköp','1|köp'),
('förköpsrätt','1|rätt'),
('förkörsrätt','1|företräde'),
('förladdning','1|ladda'),
('förlag','1|bokförlag'),
('förlag','2|destillationsapparat'),
('förlag','3|förlagslån'),
('förlaga','1|mönster'),
('förlagd','1|förlägga'),
('förlagd','2|förlägga'),
('förlagd','3|förlägga'),
('förlagsbevis','1|bevis'),
('förlagslån','1|lån'),
('förlagsman','1|förläggare'),
('förlagsmässig','1|förlag'),
('förlagsverksamhet','1|förlag'),
('förlama','1|lam'),
('förlamande','1|förlama'),
('förlamning','1|förlama'),
('förled','1|sammansättningsled'),
('förleda','1|lura'),
('förledande','1|förleda'),
('förledande','2|förleda'),
('förledare','1|förleda'),
('förlegad','1|gammal'),
('förlida','1|förliden'),
('förlidande','1|förlida'),
('förliden','1|passera'),
('förlig','1|för'),
('förlig','2|gynnsam'),
('förlika','1|överens'),
('förlikande','1|förlika'),
('förlikas','1|förlika'),
('förlikning','1|förlika'),
('förlikningsanbud','1|anbud'),
('förlikningskommission','1|kommission'),
('förlikningsman','1|förlika'),
('förlisa','1|gå_under'),
('förlisande','1|förlisa'),
('förlisning','1|förlisa'),
('förlist','1|förlisa'),
('förlitan','1|förlita_sig'),
('förlitande','1|förlitan'),
('förljudande','1|förljudas'),
('förljudas','1|rykte'),
('förljugen','1|falsk'),
('förljugenhet','1|förljugen'),
('förljuva','1|behaglig'),
('förljuvande','1|förljuva'),
('förlopp','1|utveckling'),
('förlora','1|utan'),
('förlora','2|vinna'),
('förlora','3|förtjäna'),
('förlorad','1|hopp'),
('förlorad','2|ägg'),
('förlorande','1|förlora'),
('förlorande','2|förlora'),
('förlorande','3|förlora'),
('förlorare','1|förlora'),
('förlorare','2|förlora'),
('förlorargäng','1|gäng'),
('förlossa','1|förlösa'),
('förlossa','2|frälsa'),
('förlossande','1|förlossa'),
('förlossande','2|förlossa'),
('förlossare','1|förlossa'),
('förlossare','2|förlossa'),
('förlossning','1|föda'),
('förlossning','2|förlossa'),
('förlossningsanstalt','1|anstalt'),
('förlossningsarbete','1|arbete'),
('förlossningsdepression','1|depression'),
('förlossningsklinik','1|klinik'),
('förlossningsskada','1|skada'),
('förlossningstång','1|tång'),
('förlovad','1|förlova_sig'),
('förlovning','1|förlova_sig'),
('förlovningskort','1|kort'),
('förlovningsring','1|fingerring'),
('förlupen','1|rymma'),
('förlupen','2|missa'),
('förlust','1|förlora'),
('förlust','2|förlora'),
('förlust','3|förlora'),
('förlusta','1|förlusta_sig'),
('förlustande','1|förlusta'),
('förlustbringande','1|förlust'),
('förlustelse','1|förlusta_sig'),
('förlustfri','1|förlust'),
('förlustig','1|förlust'),
('förlustighet','1|förlustig'),
('förlustrik','1|förlust'),
('förlustrikedom','1|förlustrik'),
('förlusttyngd','1|tynga'),
('förlustår','1|år'),
('förlåt','1|förhänge'),
('förlåta','1|god'),
('förlåtande','1|förlåta'),
('förlåtelse','1|förlåta'),
('förlåtlig','1|förlåta'),
('förlåtlighet','1|förlåtlig'),
('förlägen','1|genera'),
('förlägenhet','1|förlägen'),
('förlägga','1|publicera'),
('förlägga','2|lägga'),
('förlägga','3|vistas'),
('förlägga','4|förlag'),
('förläggande','1|förlägga'),
('förläggande','2|förlägga'),
('förläggande','3|förlägga'),
('förläggande','4|förlägga'),
('förläggare','1|bokförläggare'),
('förläggare','2|förlag'),
('förläggning','1|förlägga'),
('förläggningsort','1|ort'),
('förläna','1|skänka'),
('förlänande','1|förläna'),
('förlänare','1|förläna'),
('förlänga','1|lång'),
('förlängande','1|förlänga'),
('förlängning','1|förlänga'),
('förlängningsrör','1|rör'),
('förlängningsskaft','1|skaft'),
('förlängningssladd','1|sladd'),
('förläning','1|egendom'),
('förläst','1|förläsa_sig'),
('förlästhet','1|förläst'),
('förlöjliga','1|löjlig'),
('förlöjligande','1|förlöjliga'),
('förlöpa','1|rymma'),
('förlöpa','2|hända'),
('förlöpande','1|förlöpa'),
('förlöpande','2|förlöpa'),
('förlöpare','1|häst'),
('förlöpare','2|biljardboll'),
('förlöpning','1|överila_sig'),
('förlösa','1|förlossning'),
('förlösa','2|frigöra'),
('förlösande','1|förlösa'),
('förlösande','2|förlösa'),
('förlösare','1|förlösa'),
('förlösare','2|förlösa'),
('förlösning','1|förlösa'),
('förmak','1|salong'),
('förmak','2|hjärta'),
('förmaksflimmer','1|flimmer'),
('förman','1|bas'),
('förmana','1|uppmana'),
('förmanande','1|förmana'),
('förmaning','1|förmana'),
('förmaningsord','1|förmaning'),
('förmaningstal','1|tal'),
('förmanskap','1|förman'),
('förmatch','1|match'),
('förmedla','1|genom'),
('förmedlan','1|förmedla'),
('förmedlande','1|förmedla'),
('förmedlande','2|förmedla'),
('förmedlare','1|förmedla'),
('förmedling','1|förmedla'),
('förmedlingslänk','1|förmedla'),
('förmedveten','1|omedveten'),
('förmedvetenhet','1|förmedveten'),
('förmena','1|vägra'),
('förmena','2|anse'),
('förmenande','1|förmena'),
('förmenande','2|förmena'),
('förment','1|förmena'),
('förmer','1|bra'),
('förmer','1|bra'),
('förmera','1|mer'),
('förmerande','1|förmera'),
('förmering','1|förmera'),
('förmiddag','1|dag'),
('förmiddagskaffe','1|kaffe'),
('förmiddagspromenad','1|promenad'),
('förmildra','1|mildra'),
('förmildrande','1|förmildra'),
('förmildrande','2|förmildra'),
('förminska','1|liten'),
('förminskande','1|förminska'),
('förminskning','1|förminska'),
('förmoda','1|tro'),
('förmodan','1|förmoda'),
('förmodande','1|förmoda'),
('förmodern','1|modern'),
('förmodligen','1|kanske'),
('förmultna','1|mull'),
('förmultnande','1|förmultna'),
('förmultning','1|förmultna'),
('förmyndaraktig','1|förmyndare'),
('förmyndaraktighet','1|förmyndaraktig'),
('förmyndare','1|bestämma'),
('förmyndarregering','1|regering'),
('förmyndarstyre','1|styre'),
('förmynderi','1|beteende'),
('förmynderskap','1|förmyndare'),
('förmynderskap','1|förmyndare'),
('förmå','1|tvinga'),
('förmå','2|kunna'),
('förmående','1|förmå'),
('förmående','2|förmå'),
('förmåga','1|förmå'),
('förmån','1|fördel'),
('förmånlig','1|förmån'),
('förmånlighet','1|förmånlig'),
('förmånserbjudande','1|erbjudande'),
('förmånsrätt','1|företrädesrätt'),
('förmånstagare','1|erhålla'),
('förmäla','1|gifta_bort'),
('förmäla','2|omnämna'),
('förmälande','1|förmäla'),
('förmälande','2|förmäla'),
('förmäld','1|förmäla'),
('förmälning','1|förmäla'),
('förmälning','2|förmäla'),
('förmänniska','1|människa'),
('förmänskliga','1|mänsklig'),
('förmänskligande','1|förmänskliga'),
('förmärka','1|märka'),
('förmärkande','1|förmärka'),
('förmäten','1|anspråksfull'),
('förmätenhet','1|förmäten'),
('förmögen','1|rik'),
('förmögen','2|förmå'),
('förmögenhet','1|förmögen'),
('förmögenhetsbrott','1|brott'),
('förmögenhetsrätt','1|rätt'),
('förmögenhetsskatt','1|skatt'),
('förmörka','1|mörk'),
('förmörkande','1|förmörka'),
('förmörkelse','1|förmörka'),
('förmörkelsevariabel','1|variabel'),
('förmörkning','1|förmörka'),
('förna','1|jord'),
('förnagla','1|oskadliggöra'),
('förnaglande','1|förnagla'),
('förnagling','1|förnagla'),
('förnamn','1|namn'),
('förnatt','1|natt'),
('förnedra','1|behandla'),
('förnedrande','1|förnedra'),
('förnedring','1|förnedra'),
('förnedringstillstånd','1|förnedring'),
('förneka','1|inte'),
('förnekande','1|förneka'),
('förnekare','1|gudsförnekare'),
('förnekelse','1|förnekare'),
('förnekelsefas','1|fas'),
('förnickla','1|nickel'),
('förnicklande','1|förnickla'),
('förnickling','1|förnickla'),
('förnimbar','1|förnimma'),
('förnimbarhet','1|förnimbar'),
('förnimma','1|känna'),
('förnimmande','1|förnimma'),
('förnimmelse','1|förnimma'),
('förnimmelseförmåga','1|förnimma'),
('förning','1|proviant'),
('förnuft','1|förstå'),
('förnuftig','1|klok'),
('förnuftighet','1|förnuftig'),
('förnuftsenlig','1|förnuft'),
('förnuftsenlighet','1|förnuftsenlig'),
('förnuftslös','1|förnuft'),
('förnuftslöshet','1|förnuftslös'),
('förnuftsmässig','1|förnuft'),
('förnuftsskäl','1|skäl'),
('förnuftsstridig','1|mot'),
('förnuftsstridighet','1|förnuftsstridig'),
('förnuftstro','1|tro'),
('förnuftsvidrig','1|förnuftsstridig'),
('förnuftsvidrighet','1|förnuftsvidrig'),
('förnumstig','1|snusförnuftig'),
('förnumstighet','1|förnumstig'),
('förnya','1|ny'),
('förnyande','1|förnya'),
('förnyare','1|förnya'),
('förnybar','1|förnya'),
('förnybar','1|förnya'),
('förnybarhet','1|förnybar'),
('förnybarhet','1|förnybar'),
('förnyelse','1|förnya'),
('förnyelsebar','1|förnybar'),
('förnäm','1|fin'),
('förnämhet','1|förnäm'),
('förnämitet','1|förnäm'),
('förnämlig','1|bra'),
('förnämligast','1|i_synnerhet'),
('förnämligen','1|förnämligast'),
('förnämlighet','1|förnämlig'),
('förnär','1|skada'),
('förnär','1|skada'),
('förnärma','1|såra'),
('förnärmad','1|förnärma'),
('förnärmande','1|förnärma'),
('förnärmelse','1|förnärma'),
('förnödenhet','1|behöva'),
('förnöja','1|roa'),
('förnöjande','1|förnöja'),
('förnöjd','1|nöjd'),
('förnöjdhet','1|förnöjd'),
('förnöjelse','1|glädje'),
('förnöjsam','1|förnöjd'),
('förnöjsamhet','1|förnöjsam'),
('förnöta','1|slösa'),
('förnötande','1|förnöta'),
('förolyckad','1|förolyckas'),
('förolyckas','1|dö'),
('förolämpa','1|behandla'),
('förolämpad','1|förolämpa'),
('förolämpande','1|förolämpa'),
('förolämpning','1|förolämpa'),
('förord','1|inleda'),
('förord','2|förorda'),
('förorda','1|rekommendera'),
('förordad','1|förorda'),
('förordande','1|förorda'),
('förordna','1|anställa'),
('förordnande','1|förordna'),
('förordning','1|lag'),
('förorena','1|smutsig'),
('förorenande','1|förorena'),
('förorening','1|förorena'),
('föroreningsgrad','1|grad'),
('förorsaka','1|orsaka'),
('förorsakande','1|förorsaka'),
('förort','1|ort'),
('förortsbo','1|förort'),
('förortslärarinna','1|lärarinna'),
('förortsskola','1|skola'),
('förortsträdgård','1|trädgård'),
('förorätta','1|såra'),
('förorättad','1|förorätta'),
('förorättande','1|förorätta'),
('förpacka','1|omslag'),
('förpackande','1|förpacka'),
('förpackning','1|förpacka'),
('förpackningsindustri','1|industri'),
('förpakta','1|arrendera'),
('förpaktande','1|förpakta'),
('förpaktare','1|förpakta'),
('förpaktning','1|förpakta'),
('förpanta','1|pantsätta'),
('förpantande','1|förpanta'),
('förpantning','1|förpanta'),
('förpassa','1|avvisa'),
('förpassande','1|förpassa'),
('förpassning','1|förpassa'),
('förpatrull','1|patrull'),
('förpesta','1|olidlig'),
('förpestande','1|förpesta'),
('förpestning','1|förpesta'),
('förpik','1|för'),
('förplikta','1|förpliktad'),
('förplikta','1|förpliktad'),
('förpliktad','1|plikt'),
('förpliktad','1|plikt'),
('förpliktande','1|förplikta'),
('förpliktande','2|förplikta'),
('förpliktande','2|förplikta'),
('förpliktelse','1|förpliktad'),
('förpläga','1|bjuda'),
('förplägande','1|förpläga'),
('förplägnad','1|förpläga'),
('förplägning','1|förpläga'),
('förpost','1|post'),
('förpostfäktning','1|strid'),
('förpricka','1|märka'),
('förprickande','1|förpricka'),
('förprickning','1|förpricka'),
('förpubertet','1|pubertet'),
('förpuppas','1|puppa'),
('förpuppning','1|förpuppas'),
('förr','1|före'),
('förra','1|före'),
('förregling','1|järnväg'),
('förresten','1|övrig'),
('förrförra','1|förra'),
('förringa','1|undervärdera'),
('förringande','1|förringa'),
('förrinna','1|passera'),
('förrinnande','1|förrinna'),
('förromantik','1|romantik'),
('förromantisk','1|förromantik'),
('förromersk','1|romersk'),
('förrum','1|rum'),
('förruttna','1|ruttna'),
('förruttnande','1|förruttna'),
('förruttnelse','1|ruttna'),
('förruttnelsegas','1|gas'),
('förruttnelseprocess','1|förruttnelse'),
('förrycka','1|missvisande'),
('förryckande','1|förrycka'),
('förryckning','1|förrycka'),
('förryckt','1|tokig'),
('förryckthet','1|förryckt'),
('förrymd','1|rymma'),
('förryska','1|ryska'),
('förryskande','1|förryska'),
('förråa','1|rå'),
('förråande','1|förråa'),
('förråd','1|förvara'),
('förråd','2|tillgångar'),
('förråda','1|bedra'),
('förrådande','1|förråda'),
('förrådshus','1|hus'),
('förrådsrum','1|förråd'),
('förrådsutrymme','1|utrymme'),
('förrädare','1|förråda'),
('förräderi','1|förråda'),
('förrädisk','1|förråda'),
('förrädisk','2|farlig'),
('förrädiskhet','1|förrädisk'),
('förrädiskhet','2|förrädisk'),
('förrän','1|före'),
('förrän','1|före'),
('förränta','1|ränta'),
('förräntande','1|förränta'),
('förräntning','1|förränta'),
('förrätt','1|rätt'),
('förrätta','1|göra'),
('förrättande','1|förrätta'),
('förrättare','1|förrätta'),
('förrättning','1|göromål'),
('försagd','1|blyg'),
('försagdhet','1|försagd'),
('försaka','1|undvara'),
('försakande','1|försaka'),
('försakelse','1|försaka'),
('försakelsefull','1|försakelse'),
('församla','1|samla'),
('församlande','1|församla'),
('församlas','1|församla'),
('församling','1|grupp'),
('församling','2|grupp'),
('församlingsassistent','1|assistent'),
('församlingsbo','1|församling'),
('församlingsbok','1|bok'),
('församlingsfrihet','1|rätt'),
('församlingshem','1|lokal'),
('församlingshus','1|hus'),
('församlingskyrka','1|kyrka'),
('församlingsliv','1|liv'),
('församlingsmedlem','1|medlem'),
('församlingspräst','1|präst'),
('församlingsråd','1|råd'),
('försanthållen','1|sann'),
('försats','1|bisats'),
('förse','1|ge'),
('försedd','1|förse'),
('förseelse','1|brott'),
('förseende','1|förse'),
('försegel','1|segel'),
('försegla','1|tillsluta'),
('förseglande','1|försegla'),
('försegling','1|försegla'),
('försena','1|sen'),
('försenad','1|försena'),
('försenande','1|försena'),
('försening','1|försena'),
('förseningskampanj','1|kampanj'),
('förseningstimme','1|timme'),
('försent','1|sen'),
('försent','1|sen'),
('försiggå','1|hända'),
('försiggående','1|försiggå'),
('försigkommen','1|utvecklad'),
('försigkommenhet','1|försigkommen'),
('försiktig','1|lugn'),
('försiktighet','1|försiktig'),
('försiktighetsmått','1|försiktighetsåtgärd'),
('försiktighetsprincip','1|princip'),
('försiktighetsåtgärd','1|åtgärd'),
('försiktigtvis','1|försiktig'),
('försiktigtvis','1|försiktig'),
('försilvra','1|silver'),
('försilvrande','1|försilvra'),
('försinka','1|försena'),
('försinkande','1|försinka'),
('försinkning','1|försinka'),
('försitta','1|missa'),
('försittande','1|försitta'),
('försjunka','1|försjunken'),
('försjunkande','1|försjunka'),
('försjunken','1|tankfull'),
('försjunkenhet','1|försjunken'),
('försjunkning','1|försjunka'),
('förskaffa','1|ge'),
('förskaffande','1|förskaffa'),
('förskansa','1|förskansning'),
('förskansande','1|förskansa'),
('förskansning','1|befästning'),
('förskepp','1|för'),
('förskiffring','1|skiffer'),
('förskingra','1|stjäla'),
('förskingrande','1|förskingra'),
('förskingrare','1|förskingra'),
('förskingring','1|förskingra'),
('förskinn','1|förkläde'),
('förskjuta','1|stöta'),
('förskjuta','2|rubba'),
('förskjutande','1|förskjuta'),
('förskjutande','2|förskjuta'),
('förskjutning','1|förskjuta'),
('förskola','1|skola'),
('förskolebarn','1|barn'),
('förskolechef','1|chef'),
('förskoleplats','1|plats'),
('förskoleålder','1|ålder'),
('förskollärare','1|lärare'),
('förskollärare','1|lärare'),
('förskona','1|skona'),
('förskonande','1|förskona'),
('förskoning','1|förskona'),
('förskott','1|betala'),
('förskottera','1|förskott'),
('förskotterande','1|förskottera'),
('förskotterbar','1|förskottera'),
('förskotterbarhet','1|förskotterbar'),
('förskottering','1|förskottera'),
('förskriva','1|överlåta'),
('förskriva','2|skriva_ut'),
('förskrivande','1|förskriva'),
('förskrivande','2|förskriva'),
('förskrivning','1|skuldförbindelse'),
('förskrivning','2|förskriva'),
('förskräcka','1|skrämma'),
('förskräckande','1|förskräcka'),
('förskräckas','1|förskräcka'),
('förskräckelse','1|förskräcka'),
('förskräcklig','1|hemsk'),
('förskräcklighet','1|förskräcklig'),
('förskräckt','1|förskräcka'),
('förskräckthet','1|förskräckt'),
('förskrämd','1|skrämma'),
('förskrämdhet','1|förskrämd'),
('förskylla','1|skyldig'),
('förskylla','2|förtjäna'),
('förskyllan','1|förskylla'),
('förskyllande','1|förskylla'),
('förskyllande','2|förskylla'),
('förskämd','1|rutten'),
('förskämdhet','1|förskämd'),
('förskämning','1|förskämd'),
('förskära','1|blanda'),
('förskärande','1|förskära'),
('förskärare','1|kniv'),
('förskärargaffel','1|gaffel'),
('förskärarkniv','1|förskärare'),
('försköna','1|skön'),
('förskönande','1|försköna'),
('försköning','1|försköna'),
('förslag','1|föreslå'),
('förslag','2|huvudton'),
('förslagen','1|listig'),
('förslagenhet','1|förslagen'),
('förslagsrum','1|ordning'),
('förslagsställare','1|förslag'),
('förslagsvis','1|förslag'),
('förslappa','1|slapp'),
('förslappande','1|förslappa'),
('förslappning','1|förslappa'),
('förslava','1|slav'),
('förslavande','1|förslava'),
('förslavning','1|förslava'),
('förslita','1|slita'),
('förslitande','1|förslita'),
('försliten','1|förslita'),
('förslitning','1|slita'),
('förslitningsskada','1|förslitning'),
('förslummas','1|slum'),
('försluta','1|stänga'),
('förslutande','1|försluta'),
('förslutning','1|lock'),
('förslå','1|räcka'),
('förslående','1|förslå'),
('förslöa','1|slö'),
('förslöande','1|förslöa'),
('förslösa','1|slösa'),
('förslösande','1|förslösa'),
('förslösning','1|förslösa'),
('försmak','1|förkänsla'),
('försmå','1|avstå'),
('försmådd','1|försmå'),
('försmående','1|försmå'),
('försmädlig','1|hånfull'),
('försmädlighet','1|försmädlig'),
('försmäkta','1|gå_under'),
('försmäktande','1|försmäkta'),
('försnilla','1|förskingra'),
('försnillande','1|försnilla'),
('försnillning','1|försnilla'),
('försockring','1|socker'),
('försoffa','1|förslöa'),
('försoffande','1|försoffa'),
('försoffning','1|försoffa'),
('försommar','1|sommar'),
('försommarkväll','1|kväll'),
('försona','1|förlåta'),
('försonande','1|försona'),
('försonande','2|försona'),
('försonare','1|försona'),
('försonas','1|försona'),
('försoning','1|försona'),
('försoningsdag','1|dag'),
('försoningsfest','1|fest'),
('försoningsgest','1|gest'),
('försoningsgåva','1|gåva'),
('försoningsgärd','1|försoning'),
('försoningsknull','1|knull'),
('försoningslära','1|lära'),
('försoningsoffer','1|offer'),
('försonlig','1|försona'),
('försonlighet','1|försonlig'),
('försorg','1|åtgärd'),
('försorg','2|omsorg'),
('förspel','1|inledning'),
('förspilla','1|förlora'),
('förspillande','1|förspilla'),
('försprång','1|avstånd'),
('förspänd','1|spänna_för'),
('förspänd','2|spänna'),
('förspännande','1|spänna_för'),
('förspänning','1|spänning'),
('förspänning','2|spänna_för'),
('förspörja','1|erfara'),
('förspörjande','1|förspörja'),
('först','1|före'),
('första','1|först'),
('första','2|en'),
('förstad','1|stad'),
('förstadagsbrev','1|filateli'),
('förstadium','1|stadium'),
('förstadsvilla','1|villa'),
('förstag','1|stag'),
('förstagradsekvation','1|ekvation'),
('förstagångsbesökande','1|besöka'),
('förstagångsköpare','1|köpare'),
('förstagångsväljare','1|väljare'),
('förstahandsalternativ','1|alternativ'),
('förstahandserfarenhet','1|erfarenhet'),
('förstahandskälla','1|källa'),
('förstahandssökande','1|söka'),
('förstahandsuppgift','1|uppgift'),
('förstainstans','1|instans'),
('förstaklassbiljett','1|biljett'),
('förstaklasshotell','1|hotell'),
('förstaklasshytt','1|hytt'),
('förstamajblomma','1|välgörenhet'),
('förstamajtal','1|tal'),
('förstamajtalare','1|förstamajtal'),
('förstamajtåg','1|tåg'),
('förstanamn','1|kandidatlista'),
('förstaplatsen','1|plats'),
('förstaresa','1|resa'),
('förstaserve','1|serve'),
('förstasida','1|sida'),
('förstaslag','1|attack'),
('förstaslag','2|slag'),
('förstaslagsförmåga','1|förmåga'),
('förstatliga','1|äga'),
('förstatligande','1|förstatliga'),
('förstaupplaga','1|upplaga'),
('förstavelse','1|prefix'),
('förstaårsstudent','1|student'),
('förstbemälde','1|förstnämnd'),
('försteg','1|försprång'),
('förstelna','1|stelna'),
('förstelnande','1|förstelna'),
('förstelning','1|förstelna'),
('försten','1|först'),
('förstena','1|sten'),
('förstenande','1|förstena'),
('förstening','1|förstena'),
('förstfödd','1|född'),
('förstföderska','1|föda'),
('förstfödslorätt','1|rätt'),
('förstklassig','1|första_klass'),
('förstklassighet','1|förstklassig'),
('förstling','1|först'),
('förstlingsarbete','1|arbete'),
('förstnämnd','1|nämna'),
('förstocka','1|förstockad'),
('förstockad','1|oförbätterlig'),
('förstockande','1|förstocka'),
('förstockelse','1|förstockad'),
('förstoppa','1|avföring'),
('förstoppande','1|förstoppa'),
('förstoppning','1|förstoppa'),
('förstoppningsbesvär','1|besvär'),
('förstora','1|stor'),
('förstorande','1|förstora'),
('förstoring','1|förstora'),
('förstoringsapparat','1|förstora'),
('förstoringsglas','1|lins'),
('försträcka','1|låna'),
('försträckande','1|försträcka'),
('försträckning','1|försträcka'),
('försträva','1|sträva'),
('försträvande','1|försträva'),
('förströ','1|roa'),
('förströdd','1|tankspridd'),
('förströddhet','1|förströdd'),
('förströelse','1|förströ'),
('förströelselektyr','1|lektyr'),
('förströelselitteratur','1|litteratur'),
('förströende','1|förströ'),
('förstubro','1|trappa'),
('förstubro','1|trappa'),
('förstucken','1|dold'),
('förstuckenhet','1|förstucken'),
('förstudie','1|undersökning'),
('förstuga','1|farstu'),
('förstukvist','1|förstuga'),
('förstukvist','1|förstuga'),
('förstukvist','1|förstuga'),
('förstulen','1|hemlig'),
('förstulenhet','1|förstulen'),
('förstumma','1|stum'),
('förstummande','1|förstumma'),
('förstå','1|veta'),
('förstådd','1|förstå'),
('förståelig','1|förstå'),
('förståelighet','1|förståelig'),
('förståelse','1|förstå'),
('förståelseram','1|förståelse'),
('förstående','1|medkänsla'),
('förstående','2|förstå'),
('förstånd','1|förstå'),
('förstånd','2|samförstånd'),
('förståndig','1|förstånd'),
('förståndighet','1|förståndig'),
('förståndsgåvor','1|förstånd'),
('förståndshandikapp','1|förståndshandikappad'),
('förståndshandikappad','1|handikappad'),
('förståndsmässig','1|förstånd'),
('förståndsutveckling','1|utveckling'),
('förstång','1|mast'),
('förstås','1|naturligtvis'),
('förståsigpåare','1|förstå_sig_på'),
('förställa','1|förändra'),
('förställande','1|förställa'),
('förställd','1|förställa'),
('förställning','1|förställa'),
('förstämd','1|nedstämd'),
('förstämdhet','1|förstämd'),
('förstämma','1|dämpa'),
('förstämmande','1|förstämma'),
('förstämning','1|förstämd'),
('förständiga','1|ålägga'),
('förständigande','1|förständiga'),
('förstärka','1|stark'),
('förstärkande','1|förstärka'),
('förstärkare','1|förstärka'),
('förstärkning','1|förstärka'),
('förstärkningsord','1|ord'),
('förstäv','1|för'),
('förstöra','1|sönder'),
('förstörande','1|förstöra'),
('förstörare','1|förstöra'),
('förstöras','1|förstöra'),
('förstörd','1|nedslagen'),
('förstördhet','1|förstörd'),
('förstörelse','1|förstöra'),
('förstörelselusta','1|lust'),
('förstörelsevapen','1|vapen'),
('förstörelseverk','1|förstöra'),
('förstöring','1|förstöra'),
('försumbar','1|obetydlig'),
('försumbarhet','1|försumbar'),
('försumlig','1|försumma'),
('försumlighet','1|försumlig'),
('försumma','1|slarvig'),
('försummande','1|försumma'),
('försummelse','1|försumma'),
('försumpas','1|sumpmark'),
('försumpning','1|försumpas'),
('försupen','1|alkoholist'),
('försupenhet','1|försupen'),
('försura','1|sur'),
('försurande','1|försura'),
('försuras','1|försura'),
('försurning','1|försura'),
('försutten','1|försitta'),
('försvaga','1|svag'),
('försvagande','1|försvaga'),
('försvagning','1|försvaga'),
('försvar','1|försvara'),
('försvar','2|försvara'),
('försvara','1|skydda'),
('försvara','2|försvara'),
('försvarande','1|försvara'),
('försvarande','2|försvara'),
('försvarare','1|försvara'),
('försvarbar','1|försvara'),
('försvarbarhet','1|försvarbar'),
('försvarlig','1|avsevärd'),
('försvarlighet','1|försvarlig'),
('försvarsadvokat','1|advokat'),
('försvarsallians','1|allians'),
('försvarsanläggning','1|anläggning'),
('försvarsattaché','1|diplomat'),
('försvarsberedskap','1|beredskap'),
('försvarsbeslut','1|beslut'),
('försvarsdator','1|dator'),
('försvarsdepartement','1|departement'),
('försvarsduglig','1|försvara'),
('försvarsfunktion','1|funktion'),
('försvarsgren','1|gren'),
('försvarsgrenschef','1|chef'),
('försvarshemlighet','1|hemlighet'),
('försvarshögskola','1|högskola'),
('försvarsinlaga','1|inlaga'),
('försvarskostnad','1|kostnad'),
('försvarskraft','1|försvar'),
('försvarskrig','1|krig'),
('försvarslinje','1|försvar'),
('försvarslös','1|hjälplös'),
('försvarslöshet','1|försvarslös'),
('försvarsmakt','1|krigsmakt'),
('försvarsmekanism','1|mekanism'),
('försvarsminister','1|minister'),
('försvarsmässig','1|försvar'),
('försvarsnedläggning','1|nedläggning'),
('försvarsnedskärning','1|nedskärning'),
('försvarsområde','1|militärområde'),
('försvarsplanering','1|planering'),
('försvarspolitik','1|politik'),
('försvarspolitisk','1|försvarspolitik'),
('försvarsraster','1|raster'),
('försvarsskrift','1|skrift'),
('försvarsspel','1|spel'),
('försvarsspelare','1|försvarsspel'),
('försvarsstab','1|stab'),
('försvarsstrategi','1|strategi'),
('försvarsställning','1|ställning'),
('försvarstal','1|tal'),
('försvarstänkande','1|tänkande'),
('försvarsutskott','1|utskott'),
('försvarsvapen','1|vapen'),
('försvarsverk','1|befästning'),
('försvarsväsen','1|försvar'),
('försvarsåtagande','1|åtagande'),
('försvenska','1|svensk'),
('försvenskande','1|försvenska'),
('försvinna','1|bort'),
('försvinnande','1|försvinna'),
('försvunnen','1|försvinna'),
('försvurenhet','1|försvärja_sig'),
('försvåra','1|svår'),
('försvårande','1|försvåra'),
('försvårande','2|försvåra'),
('försvärja','1|svära'),
('försvärjande','1|försvärja'),
('försyn','1|omsorg'),
('försyndelse','1|försynda_sig'),
('försynt','1|ödmjuk'),
('försynthet','1|försynt'),
('försåpning','1|förtvålning'),
('försåt','1|försåtlig'),
('försåtlig','1|listig'),
('försåtlighet','1|försåtlig'),
('försåvida','1|försåvitt'),
('försåvitt','1|såvida'),
('försägning','1|försäga_sig'),
('försäkra','1|ja'),
('försäkra','2|skydda'),
('försäkran','1|försäkra'),
('försäkrande','1|försäkra'),
('försäkrande','2|försäkra'),
('försäkring','1|försäkra'),
('försäkringsagent','1|agent'),
('försäkringsbedrägeri','1|bedrägeri'),
('försäkringsbelopp','1|belopp'),
('försäkringsbesked','1|dokument'),
('försäkringsbolag','1|bolag'),
('försäkringsbolagskontor','1|kontor'),
('försäkringsbolagskontorist','1|försäkringsbolagskontor'),
('försäkringsbranschen','1|bransch'),
('försäkringsbrev','1|dokument'),
('försäkringsfråga','1|fråga'),
('försäkringsgivare','1|försäkringsbolag'),
('försäkringsinslag','1|inslag'),
('försäkringskassa','1|sjukförsäkring'),
('försäkringsmarknad','1|marknad'),
('försäkringsmässig','1|försäkring'),
('försäkringspengar','1|pengar'),
('försäkringspolis','1|försäkringsbrev'),
('försäkringspremie','1|avgift'),
('försäkringsskada','1|skada'),
('försäkringsskydd','1|skydd'),
('försäkringssystem','1|system'),
('försäkringstagare','1|försäkring'),
('försäkringsvillkor','1|villkor'),
('försäkringsvärde','1|försäkringsbelopp'),
('försälja','1|sälja'),
('försäljande','1|försälja'),
('försäljare','1|sälja'),
('försäljerska','1|försäljare'),
('försäljning','1|sälja'),
('försäljningsbransch','1|bransch'),
('försäljningschef','1|chef'),
('försäljningsdag','1|dag'),
('försäljningsdisk','1|disk'),
('försäljningsled','1|led'),
('försäljningsmässig','1|försäljning'),
('försäljningsort','1|ort'),
('försäljningspris','1|pris'),
('försäljningsstopp','1|stopp'),
('försäljningsstånd','1|stånd'),
('försäljningssuccé','1|succé'),
('försäljningsvana','1|vana'),
('försäljningsvinst','1|vinst'),
('försäljningsvolym','1|volym'),
('försämra','1|dålig'),
('försämrande','1|försämra'),
('försämring','1|försämra'),
('försända','1|sända'),
('försändande','1|försända'),
('försändelse','1|sända'),
('försändning','1|försända'),
('försänka','1|vidga'),
('försänka','2|spärra'),
('försänka','3|försjunka'),
('försänkande','1|försänka'),
('försänkande','2|försänka'),
('försänkande','3|försänka'),
('försänkare','1|försänka'),
('försänkning','1|vänskapsförbindelse'),
('försänkning','2|fördjupning'),
('försätta','1|bringa'),
('försätta','2|förspilla'),
('försätta','3|uppblanda'),
('försättande','1|försätta'),
('försättande','2|försätta'),
('försättande','3|försätta'),
('försättning','1|försätta'),
('försättning','2|försätta'),
('försättning','3|försätta'),
('försättsblad','1|blad'),
('försättslins','1|lins'),
('försök','1|försöka'),
('försök','2|undersöka'),
('försöka','1|kanske'),
('försökande','1|försöka'),
('försöksballong','1|försök'),
('försöksdamm','1|damm'),
('försöksdjur','1|djur'),
('försöksgymnasium','1|experimentgymnasium'),
('försöksheat','1|heat'),
('försökskanin','1|försöksobjekt'),
('försöksledare','1|leda'),
('försöksmetod','1|försök'),
('försöksobjekt','1|objekt'),
('försöksperson','1|person'),
('försöksverksamhet','1|verksamhet'),
('försöksvis','1|försök'),
('försörja','1|förse'),
('försörjande','1|försörja'),
('försörjare','1|försörja'),
('försörjning','1|försörja'),
('försörjningsanstalt','1|fattigvård'),
('försörjningsbalans','1|balans'),
('försörjningsbörda','1|börda'),
('försörjningsinrättning','1|inrättning'),
('försörjningsläge','1|läge'),
('försörjningsmässig','1|försörjning'),
('försörjningspolitik','1|politik'),
('försörjningspolitisk','1|försörjningspolitik'),
('försörjningsprojekt','1|forskningsprojekt'),
('försörjningsskyldighet','1|skyldighet'),
('försörjningsstöd','1|socialbidrag'),
('förta','1|ta_bort'),
('förtagande','1|förta'),
('förtal','1|förtala'),
('förtala','1|tala'),
('förtalande','1|förtala'),
('förtalare','1|förtala'),
('förtalskampanj','1|kampanj'),
('förtalsmål','1|mål'),
('förtappad','1|fördömelse'),
('förtappelse','1|förtappad'),
('förtecken','1|not'),
('förtecken','2|särdrag'),
('förteckna','1|registrera'),
('förtecknande','1|förteckna'),
('förteckning','1|lista'),
('förtegen','1|tiga'),
('förtegenhet','1|förtegen'),
('förteknisk','1|teknik'),
('förtenna','1|tenn'),
('förtennande','1|förtenna'),
('förtenning','1|förtenna'),
('förtent','1|förtenna'),
('förtida','1|i_förtid'),
('förtida','1|i_förtid'),
('förtida','1|i_förtid'),
('förtidsbörd','1|förlossning'),
('förtidspension','1|pension'),
('förtidspensionera','1|förtidspension'),
('förtidspensionerande','1|förtidspensionera'),
('förtidspensionerbar','1|förtidspensionera'),
('förtidspensionerbarhet','1|förtidspensionerbar'),
('förtidspensionering','1|förtidspensionera'),
('förtidsrösta','1|rösta'),
('förtidsröstande','1|förtidsrösta'),
('förtidsröstning','1|förtidsrösta'),
('förtiga','1|tiga'),
('förtigande','1|förtiga'),
('förtimring','1|bordläggning'),
('förtingligande','1|ting'),
('förtjocka','1|tjock'),
('förtjockande','1|förtjocka'),
('förtjocknad','1|svälla'),
('förtjockning','1|förtjocka'),
('förtjusa','1|fängsla'),
('förtjusande','1|vacker'),
('förtjusande','2|förtjusa'),
('förtjusare','1|förtjusa'),
('förtjusning','1|förtjust'),
('förtjust','1|glad'),
('förtjäna','1|värd'),
('förtjäna','2|pengar'),
('förtjänande','1|förtjäna'),
('förtjänande','2|förtjäna'),
('förtjänst','1|lön'),
('förtjänst','2|orsak'),
('förtjänst','3|förtjänstfull'),
('förtjänstfull','1|bra'),
('förtjänstfullhet','1|förtjänstfull'),
('förtjänsttecken','1|tecken'),
('förtjänt','1|förtjäna'),
('förtjänt','2|välmeriterad'),
('förtona','1|tystna'),
('förtonande','1|förtona'),
('förtoning','1|nyans'),
('förtoning','2|kontur'),
('förtorka','1|torka'),
('förtorkande','1|förtorka'),
('förtorkning','1|förtorka'),
('förtrampa','1|förtrycka'),
('förtrampande','1|förtrampa'),
('förtrampning','1|förtrampa'),
('förtret','1|obehag'),
('förtreta','1|förtret'),
('förtretande','1|förtreta'),
('förtretlig','1|förtret'),
('förtretlighet','1|förtretlig'),
('förtro','1|anförtro'),
('förtroende','1|tro'),
('förtroende','2|förtro'),
('förtroendearbetstid','1|arbetstidsreglering'),
('förtroendefråga','1|fråga'),
('förtroendefull','1|förtroende'),
('förtroendefullhet','1|förtroendefull'),
('förtroendeglapp','1|glapp'),
('förtroendeingivande','1|inge'),
('förtroendeklyfta','1|brist'),
('förtroendekris','1|kris'),
('förtroendeman','1|fack'),
('förtroendemässig','1|förtroende'),
('förtroendemätning','1|mätning'),
('förtroendeomröstning','1|förtroendevotum'),
('förtroendepost','1|förtroendeuppdrag'),
('förtroenderåd','1|råd'),
('förtroendeskapande','1|förtroende'),
('förtroendeuppdrag','1|uppdrag'),
('förtroendevald','1|förtroendeuppdrag'),
('förtroendevotum','1|votum'),
('förtroendeväckande','1|förtroendeskapande'),
('förtrogen','1|veta'),
('förtrogen','2|lita'),
('förtrogenhet','1|förtrogen'),
('förtrolig','1|tro'),
('förtrolighet','1|förtrolig'),
('förtrolla','1|fängsla'),
('förtrolla','2|förvandla'),
('förtrollande','1|förtrolla'),
('förtrollande','2|förtrolla'),
('förtrollande','3|förtrolla'),
('förtrollare','1|förtrolla'),
('förtrollare','2|förtrolla'),
('förtrollerska','1|förtrolla'),
('förtrollning','1|förtrolla'),
('förtrollning','2|förtrolla'),
('förtrupp','1|trupp'),
('förtrusta','1|trust'),
('förtrustande','1|förtrusta'),
('förtryck','1|förtrycka'),
('förtrycka','1|tvinga'),
('förtryckande','1|förtrycka'),
('förtryckare','1|förtrycka'),
('förtryckning','1|förtrycka'),
('förtryckt','1|förtrycka'),
('förtryta','1|förtrytelse'),
('förtrytande','1|förtryta'),
('förtrytelse','1|vrede'),
('förtrytsam','1|förtrytelse'),
('förtrytsamhet','1|förtrytsam'),
('förträfflig','1|bra'),
('förträfflighet','1|förträfflig'),
('förtränga','1|tränga'),
('förträngande','1|förtränga'),
('förträngd','1|förtränga'),
('förträngning','1|förtränga'),
('förträngning','2|trång'),
('förträngningsmekanism','1|mekanism'),
('förtrösta','1|lita'),
('förtröstan','1|förtrösta'),
('förtröstande','1|förtrösta'),
('förtröstansfull','1|förtröstan'),
('förtröttas','1|tröttna'),
('förtulla','1|tull'),
('förtullande','1|förtulla'),
('förtullning','1|förtulla'),
('förtunna','1|tunn'),
('förtunnande','1|förtunna'),
('förtunning','1|förtunna'),
('förtur','1|före'),
('förtvina','1|försvinna'),
('förtvinande','1|förtvina'),
('förtvining','1|förtvina'),
('förtvivla','1|förtvivlad'),
('förtvivlad','1|hopp'),
('förtvivlan','1|förtvivlad'),
('förtvivlande','1|förtvivla'),
('förtvåla','1|förtvålning'),
('förtvålande','1|förtvåla'),
('förtvålning','1|spjälka'),
('förtvätt','1|tvätt'),
('förty','1|därför'),
('förtycka','1|misstycka'),
('förtyckande','1|förtycka'),
('förtydliga','1|tydlig'),
('förtydligande','1|förtydliga'),
('förtyska','1|tyska'),
('förtyskande','1|förtyska'),
('förtäckt','1|antyda'),
('förtälja','1|berätta'),
('förtäljande','1|förtälja'),
('förtändning','1|självtändning'),
('förtänka','1|klandra'),
('förtänkande','1|förtänka'),
('förtänksam','1|förutseende'),
('förtänksamhet','1|förtänksam'),
('förtära','1|äta'),
('förtärande','1|förtära'),
('förtäring','1|mat'),
('förtäta','1|intensiv'),
('förtätande','1|förtäta'),
('förtätning','1|tät'),
('förtöja','1|fästa'),
('förtöjande','1|förtöja'),
('förtöjning','1|förtöja'),
('förtöjningslina','1|lina'),
('förtöjningsring','1|ring'),
('förtörnad','1|förtörnas'),
('förtörnas','1|arg'),
('förtörnelse','1|förtörnas'),
('förunderlig','1|underlig'),
('förunderlighet','1|förunderlig'),
('förundersöka','1|förundersökning'),
('förundersökande','1|förundersöka'),
('förundersökning','1|undersökning'),
('förundersökningsledare','1|ledare'),
('förundersökningsprotokoll','1|protokoll'),
('förundersökningssekretess','1|sekretess'),
('förundra','1|förvåna'),
('förundran','1|förundra'),
('förundrande','1|förundra'),
('förundransvärd','1|förundran'),
('förundransvärdhet','1|förundransvärd'),
('förunna','1|unna'),
('förunnande','1|förunna'),
('förunt','1|förunna'),
('förut','1|före'),
('förut','2|för'),
('förutan','1|utan'),
('förutbestämd','1|öde'),
('förutbestämdhet','1|förutbestämd'),
('förutbestämma','1|bestämma'),
('förutbestämmande','1|förutbestämma'),
('förutbestämmelse','1|förutbestämma'),
('förutfattad','1|fördom'),
('förutnämnd','1|nämna'),
('förutom','1|utom'),
('förutsagd','1|förutsäga'),
('förutsatt','1|villkor'),
('förutse','1|ana'),
('förutsebar','1|förutse'),
('förutseende','1|förutse'),
('förutseende','2|förutse'),
('förutskicka','1|meddela'),
('förutskickande','1|förutskicka'),
('förutspå','1|spå'),
('förutspå','1|spå'),
('förutspående','1|förutspå'),
('förutspående','1|förutspå'),
('förutsäga','1|säga'),
('förutsägande','1|förutsäga'),
('förutsägbar','1|förutsäga'),
('förutsägbarhet','1|förutsägbar'),
('förutsägelse','1|förutsäga'),
('förutsägelsekraft','1|förmåga'),
('förutsätta','1|anta'),
('förutsättande','1|förutsätta'),
('förutsättning','1|villkor'),
('förutsättningslös','1|förutsättning'),
('förutsättningslöshet','1|förutsättningslös'),
('förutvarande','1|före'),
('förvalta','1|sköta'),
('förvaltande','1|förvalta'),
('förvaltare','1|förvalta'),
('förvaltarskap','1|förvalta'),
('förvaltarskapsområde','1|område'),
('förvaltning','1|förvalta'),
('förvaltningsberättelse','1|redogörelse'),
('förvaltningsbeslut','1|beslut'),
('förvaltningsbolag','1|bolag'),
('förvaltningsbyggnad','1|byggnad'),
('förvaltningsmyndighet','1|myndighet'),
('förvaltningsmässig','1|förvaltning'),
('förvaltningsrätt','1|rätt'),
('förvaltningsutskott','1|landsting'),
('förvandla','1|förändra'),
('förvandlande','1|förvandla'),
('förvandling','1|förvandla'),
('förvandlingskonstnär','1|artist'),
('förvandlingsnummer','1|nummer'),
('förvandlingsprocess','1|förvandling'),
('förvandlingsstraff','1|fängelsestraff'),
('förvanska','1|förändra'),
('förvanskande','1|förvanska'),
('förvanskning','1|förvanska'),
('förvar','1|förvara'),
('förvara','1|ha'),
('förvarande','1|förvara'),
('förvaring','1|förvara'),
('förvaringsask','1|ask'),
('förvaringsback','1|back'),
('förvaringsbox','1|box'),
('förvaringshall','1|hall'),
('förvaringskorg','1|korg'),
('förvaringskärl','1|kärl'),
('förvaringsmöjlighet','1|möjlighet'),
('förvaringsplats','1|plats'),
('förvaringsrum','1|förvaring'),
('förvaringsskåp','1|skåp'),
('förvaringsskärl','1|förvara'),
('förvaringsställe','1|ställe'),
('förvaringsutrymme','1|utrymme'),
('förvaringsvalv','1|förvara'),
('förvarna','1|varna'),
('förvarnande','1|förvarna'),
('förvarning','1|förvarna'),
('förveckling','1|komplicera'),
('förveda','1|ved'),
('förvedande','1|förveda'),
('förvedning','1|förveda'),
('förvekliga','1|vek'),
('förvekligande','1|förvekliga'),
('förverka','1|mista'),
('förverkande','1|förverka'),
('förverkliga','1|verklig'),
('förverkligande','1|förverkliga'),
('förveten','1|nyfiken'),
('förvetenhet','1|förveten'),
('förvikingatida','1|vikingatida'),
('förvildad','1|förvildas'),
('förvildas','1|vild'),
('förvildning','1|förvildas'),
('förvilla','1|vilseleda'),
('förvillande','1|förvilla'),
('förvillare','1|förvilla'),
('förvillelse','1|misstag'),
('förvinter','1|vinter'),
('förvirra','1|oreda'),
('förvirrad','1|förvirra'),
('förvirrande','1|förvirra'),
('förvirrande','2|förvirra'),
('förvirring','1|förvirra'),
('förvisa','1|avvisa'),
('förvisa','2|hänskjuta'),
('förvisande','1|förvisa'),
('förvisande','2|förvisa'),
('förvisning','1|förvisa'),
('förvisning','2|förvisa'),
('förvisningsort','1|ort'),
('förvissa','1|övertyga'),
('förvissande','1|förvissa'),
('förvissna','1|vissna'),
('förvissnande','1|förvissna'),
('förvissning','1|förvissna'),
('förvissning','2|visshet'),
('förvisso','1|visst'),
('förvittra','1|vittra'),
('förvittrande','1|förvittra'),
('förvittring','1|förvittra'),
('förvrida','1|förändra'),
('förvridande','1|förvrida'),
('förvriden','1|förvrida'),
('förvridning','1|förvrida'),
('förvränga','1|förändra'),
('förvrängande','1|förvränga'),
('förvrängning','1|förvränga'),
('förvunnen','1|skyldig'),
('förvuxen','1|växa'),
('förvuxenhet','1|förvuxen'),
('förvålla','1|vålla'),
('förvållan','1|förvålla'),
('förvållande','1|förvålla'),
('förvåna','1|underlig'),
('förvånad','1|förvåna'),
('förvånande','1|förvåna'),
('förvånansvärd','1|förvåna'),
('förvåning','1|förvåna'),
('förvägen','1|djärv'),
('förvägenhet','1|förvägen'),
('förvägra','1|vägra'),
('förvägrande','1|förvägra'),
('förväljare','1|anordning'),
('förvälla','1|koka'),
('förvällande','1|förvälla'),
('förvällning','1|förvälla'),
('förvänd','1|felaktig'),
('förvända','1|förställa'),
('förvändande','1|förvända'),
('förvändhet','1|förvänd'),
('förvändning','1|förvända'),
('förvänta','1|trolig'),
('förvänta','1|trolig'),
('förväntad','1|förvänta'),
('förväntan','1|förvänta'),
('förväntande','1|förvänta'),
('förväntansfull','1|hoppfull'),
('förväntansfullhet','1|förväntansfull'),
('förväntning','1|förvänta'),
('förväntningsfull','1|förväntansfull'),
('förvärkar','1|förlossning'),
('förvärldsliga','1|världslig'),
('förvärldsligande','1|förvärldsliga'),
('förvärmare','1|ångpanna'),
('förvärra','1|illa'),
('förvärrande','1|förvärra'),
('förvärring','1|förvärra'),
('förvärv','1|förvärva'),
('förvärva','1|skaffa'),
('förvärvande','1|förvärva'),
('förvärvsarbeta','1|arbeta'),
('förvärvsarbetande','1|förvärvsarbeta'),
('förvärvsarbete','1|förvärvsarbeta'),
('förvärvsavdrag','1|skatteavdrag'),
('förvärvskälla','1|inkomstkälla'),
('förvärvsliv','1|arbetsliv'),
('förvärvslysten','1|förvärva'),
('förvärvslystenhet','1|förvärvslysten'),
('förvärvslystnad','1|förvärvslysten'),
('förvärvsmässig','1|förvärv'),
('förvärvsverksamhet','1|verksamhet'),
('förväxla','1|fel'),
('förväxlande','1|förväxla'),
('förväxling','1|förväxla'),
('förväxlingskomedi','1|komedi'),
('förväxlingslek','1|lek'),
('förväxt','1|förvuxen'),
('föryngra','1|ung'),
('föryngrande','1|föryngra'),
('föryngring','1|ung'),
('föryngringsbeskära','1|beskära'),
('föryngringsbeskärande','1|föryngringsbeskära'),
('föryngringsbeskäring','1|föryngringsbeskära'),
('föryngringsyta','1|skog'),
('förzinka','1|zink'),
('förzinkande','1|förzinka'),
('förzinkning','1|förzinka'),
('föråldrad','1|omodern'),
('föråldras','1|föråldrad'),
('föråldring','1|föråldras'),
('förånga','1|ånga'),
('förångande','1|förånga'),
('förångning','1|förånga'),
('förädla','1|förbättra'),
('förädlande','1|förädla'),
('förädling','1|förädla'),
('förädlingsarbete','1|arbete'),
('föräktenskaplig','1|äktenskap'),
('föräktenskaplighet','1|föräktenskaplig'),
('förälder','1|vuxen'),
('förälder','1|vuxen'),
('förälderlig','1|förälder'),
('föräldraansvar','1|ansvar'),
('föräldrabalk','1|lagbalk'),
('föräldrabesök','1|besök'),
('föräldradag','1|skoldag'),
('föräldrafri','1|förälder'),
('föräldraförmån','1|föräldrapenning'),
('föräldraförsäkring','1|föräldrapenning'),
('föräldrahem','1|födelsehem'),
('föräldrakollektiv','1|kollektiv'),
('föräldrakreativitet','1|kreativitet'),
('föräldrakärlek','1|kärlek'),
('föräldraledig','1|ledig'),
('föräldraledighet','1|föräldraledig'),
('föräldralös','1|förälder'),
('föräldralöshet','1|föräldralös'),
('föräldramakt','1|makt'),
('föräldramöte','1|möte'),
('föräldrapenning','1|ersättning'),
('föräldraskap','1|förälder'),
('föräldraträd','1|träd'),
('förälskad','1|förälska_sig'),
('förälskelse','1|förälska_sig'),
('föränderlig','1|förändra'),
('föränderlighet','1|föränderlig'),
('förändra','1|ändra'),
('förändrande','1|förändra'),
('förändring','1|förändra'),
('förändringsarbete','1|förändring'),
('förändringsprocess','1|förändring'),
('förändringstakt','1|takt'),
('förändringstryck','1|tryck'),
('förära','1|skänka'),
('förärande','1|förära'),
('förätning','1|föräta_sig'),
('föröda','1|förstöra'),
('förödande','1|föröda'),
('förödande','2|föröda'),
('förödelse','1|föröda'),
('förödmjuka','1|förnedra'),
('förödmjukande','1|förödmjuka'),
('förödmjukelse','1|förödmjuka'),
('föröka','1|mången'),
('förökande','1|föröka'),
('förökning','1|föröka'),
('föröva','1|begå'),
('förövande','1|föröva'),
('förövare','1|föröva'),
('föröver','1|för'),
('förövning','1|övning'),
('fösa','1|driva'),
('fösande','1|fösa'),
('fösning','1|fösa'),
('g','1|bokstav'),
('g','2|ton'),
('g','3|acceleration'),
('GABA','1|signalsubstans'),
('gabardin','1|tyg'),
('gabbro','1|bergart'),
('Gabon','1|land'),
('gabon','1|träslag'),
('gabon','2|gabonhuggorm'),
('gabondörr','1|dörr'),
('gabones','1|Gabon'),
('gabonesisk','1|Gabon'),
('gabonesiska','1|gabones'),
('gabonhuggorm','1|huggorm'),
('Gabrielsson','1|bilfabrikör'),
('Gadaffitrogen','1|trogen'),
('gadd','1|sticka'),
('gadd','2|tand'),
('gadd','3|ormtunga'),
('gadda','1|tatuera'),
('gaddande','1|gadda'),
('gaddlös','1|kraftlös'),
('gaddlöshet','1|gaddlös'),
('gaddning','1|gadda'),
('gaddstekel','1|insekt'),
('gadolinium','1|grundämne'),
('gadolinium','1|grundämne'),
('gael','1|folk'),
('gael','1|folk'),
('gaelisk','1|gael'),
('gaelisk','1|gael'),
('gaeliska','1|språk'),
('gaeliska','1|språk'),
('gaeliska','2|gael'),
('gaeliska','2|gael'),
('gaff','1|huggkrok'),
('gaffel','1|redskap'),
('gaffel','2|mast'),
('gaffel','3|gaffeltruck'),
('gaffelankare','1|ankare'),
('gaffelantilop','1|antilop'),
('gaffelapa','1|gaffelsegel'),
('gaffelbit','1|sillbit'),
('gaffelbock','1|gaffelantilop'),
('gaffelbock','2|råbock'),
('gaffelfibbla','1|fibbla'),
('gaffelformig','1|gaffel'),
('gaffelhjort','1|hjort'),
('gaffelhjort','2|kronhjort'),
('gaffelklo','1|gaffel'),
('gaffellyft','1|lyfta'),
('gaffellängd','1|längd'),
('gaffelrigg','1|rigg'),
('gaffelsegel','1|segel'),
('gaffeltruck','1|truck'),
('gaffla','1|prata'),
('gaffla','2|rikta'),
('gafflande','1|gaffla'),
('gafflande','2|gaffla'),
('gag','1|skämt'),
('gagat','1|kol'),
('gagatsvart','1|svartglänsande'),
('gage','1|arvode'),
('gagg','1|struntprat'),
('gagga','1|gagg'),
('gaggande','1|gagga'),
('gaggig','1|förvirrad'),
('gaggighet','1|gaggig'),
('gagn','1|nytta'),
('gagna','1|gagn'),
('gagnande','1|gagna'),
('gagnelig','1|gagn'),
('gagnelighet','1|gagnelig'),
('gagnerik','1|gagnelig'),
('gagnerik','1|gagnelig'),
('gagnerikhet','1|gagnerik'),
('gagnerikhet','1|gagnerik'),
('gagnlös','1|gagn'),
('gagnlöshet','1|gagnlös'),
('gagnvirke','1|virke'),
('gagnväxt','1|nyttoväxt'),
('gaillarde','1|dans'),
('Gais','1|fotbollslag'),
('Gais','1|fotbollslag'),
('gaj','1|tåg'),
('gala','1|läte'),
('gala','2|festlighet'),
('gala','3|kläder'),
('galadräkt','1|festkläder'),
('galaföreställning','1|föreställning'),
('galaklädd','1|uppklädd'),
('galakläder','1|festkläder'),
('galaktisk','1|galax'),
('galaktos','1|mjölksocker'),
('galalit','1|plast'),
('galamiddag','1|middag'),
('galande','1|gala'),
('galant','1|artig'),
('galant','2|utmärkt'),
('galanteri','1|galant'),
('galanterier','1|vara'),
('Galapagosöarna','1|ögrupp'),
('galapremiär','1|premiär'),
('galat','1|Galatien'),
('Galatien','1|Mindre_Asien'),
('galauniform','1|uniform'),
('galavagn','1|vagn'),
('galax','1|hop'),
('galaxbildning','1|galax'),
('galaxcentrum','1|centrum'),
('galaxhop','1|galax'),
('galaxspektrum','1|spektrum'),
('galaxvärld','1|värld'),
('galder','1|trollsång'),
('galeas','1|segelfartyg'),
('galej','1|fest'),
('galeja','1|galär'),
('galen','1|klok'),
('galen','2|fel'),
('galenhet','1|galen'),
('Galenos','1|läkare'),
('galenpanna','1|galen'),
('galenskap','1|galen'),
('galgbacke','1|plats'),
('galge','1|avrätta'),
('galge','2|klädhängare'),
('galgenfrist','1|uppskov'),
('galgenfrist','1|uppskov'),
('galgfågel','1|skojare'),
('galghumor','1|humor'),
('galghumoristisk','1|galghumor'),
('galgrep','1|rep'),
('Galicien','1|provins'),
('galicisk','1|Galicien'),
('galilé','1|Galiléen'),
('Galiléen','1|Palestina'),
('galjon','1|utbyggnad'),
('galjon','1|utbyggnad'),
('galjonsbild','1|galjonsfigur'),
('galjonsfigur','1|prydnad'),
('galjonsfigur','2|person'),
('gall','1|ofruktsam'),
('gall','2|gallbildning'),
('galla','1|vätska'),
('galla','2|sjukdom'),
('galla','3|folk'),
('galla','3|folk'),
('galla','4|språk'),
('galla','4|språk'),
('gallbildning','1|missbildning'),
('gallblomma','1|blomma'),
('gallblåsa','1|blåsa'),
('galldrivande','1|galla'),
('galler','1|stängsel'),
('galler','2|folk'),
('galler','2|folk'),
('gallerdurk','1|durk'),
('gallerdörr','1|dörr'),
('gallerformig','1|galler'),
('gallerfönster','1|fönster'),
('gallerförsedd','1|galler'),
('gallergrind','1|grind'),
('galleri','1|visa'),
('galleri','2|pelargång'),
('galleria','1|shoppingcentrum'),
('galleriskog','1|snårskog'),
('gallerist','1|galleri'),
('gallerport','1|port'),
('gallerstaket','1|staket'),
('gallerverk','1|galler'),
('gallfeber','1|rasande'),
('gallgång','1|gång'),
('gallicism','1|franska'),
('gallimatias','1|struntprat'),
('gallimatias','1|struntprat'),
('gallisera','1|förfranska'),
('gallisera','2|vin'),
('galliserande','1|gallisera'),
('galliserande','2|gallisera'),
('galliserbar','1|gallisera'),
('galliserbar','2|gallisera'),
('galliserbarhet','1|galliserbar'),
('galliserbarhet','2|galliserbar'),
('gallisering','1|gallisera'),
('gallisering','2|gallisera'),
('gallisk','1|fransk'),
('gallium','1|metall'),
('gallium','2|grundämne'),
('gallium','2|grundämne'),
('gallko','1|ko'),
('gallkvalster','1|kvalster'),
('gallmygga','1|mygga'),
('gallon','1|rymdmått'),
('gallra','1|sortera'),
('gallrande','1|gallra'),
('gallring','1|gallra'),
('gallsjuk','1|galla'),
('gallsjuka','1|gallsjuk'),
('gallsjukhet','1|gallsjuk'),
('gallskrik','1|gallskrika'),
('gallskrika','1|skrika'),
('gallskrikande','1|gallskrika'),
('gallsprängd','1|galla'),
('gallsprängd','2|ilsken'),
('gallsprängdhet','1|gallsprängd'),
('gallstekel','1|stekel'),
('gallsten','1|sjukdom'),
('gallsyra','1|syra'),
('galltjut','1|galltjuta'),
('galltjuta','1|gallskrika'),
('galltjutande','1|galltjuta'),
('gallup','1|gallupmätning'),
('gallupmätning','1|opinionsundersökning'),
('gallussyra','1|garvsyra'),
('galläpple','1|gallbildning'),
('galmeja','1|zinkmalm'),
('galnas','1|galen'),
('galning','1|galen'),
('galon','1|tyg'),
('galon','2|dekoration'),
('galonbyxor','1|byxor'),
('galonerad','1|galon'),
('galopp','1|springa'),
('galopp','2|polka'),
('galoppad','1|galopp'),
('galoppera','1|galopp'),
('galopperande','1|galoppera'),
('galoppering','1|galoppera'),
('galoppsport','1|sport'),
('galopptävling','1|tävling'),
('galosch','1|sko'),
('galosch','2|person'),
('galoschbett','1|underbett'),
('galoschera','1|laga'),
('galoscherande','1|galoschera'),
('galoscherbar','1|galoschera'),
('galoscherbarhet','1|galoscherbar'),
('galoschering','1|galoschera'),
('galoschhaka','1|galoschbett'),
('galoschhylla','1|hylla'),
('galt','1|gris'),
('galt','2|ugn'),
('galtlukt','1|lukt'),
('galva','1|galvanisera'),
('galvande','1|galva'),
('galvanisera','1|förzinka'),
('galvaniserande','1|galvanisera'),
('galvaniserbar','1|galvanisera'),
('galvaniserbarhet','1|galvaniserbar'),
('galvanisering','1|galvanisera'),
('galvanisk','1|elektrolys'),
('galvanism','1|elektricitet'),
('galvanometer','1|elektrolys'),
('galvanoplastik','1|tryck'),
('galvanoskop','1|elektrolys'),
('galvanostegi','1|galvanisera'),
('galvanoteknik','1|elektrolys'),
('galvanotyp','1|kliché'),
('galvanotypi','1|galvanoplastik'),
('galär','1|fartyg'),
('galärslav','1|roddarslav'),
('gam','1|fågel'),
('gam','2|gama'),
('gama','1|roffa'),
('gamande','1|gama'),
('gamasch','1|benskydd'),
('Gambia','1|land'),
('gambier','1|Gambia'),
('gambisk','1|Gambia'),
('gambiska','1|gambier'),
('gambit','1|spelöppning'),
('game','1|tennis'),
('gamet','1|könscell'),
('gamling','1|gammal'),
('gamma','1|bokstav'),
('gamma','2|gammastrålning'),
('gammafly','1|fjäril'),
('gammaglobulin','1|vaccin'),
('gammakamera','1|kamera'),
('gammal','1|ålder'),
('gammal','1|ålder'),
('gammaldags','1|omodern'),
('gammaldans','1|dans'),
('gammaldans','1|dans'),
('gammalhöger','1|höger'),
('gammalkommunist','1|kommunist'),
('gammalkommunist','1|kommunist'),
('gammalkristen','1|kristen'),
('gammalkristenhet','1|gammalkristen'),
('gammalkyrklig','1|kyrklig'),
('gammalkyrklighet','1|gammalkyrklig'),
('gammalmodig','1|omodern'),
('gammalmodighet','1|gammalmodig'),
('gammalrosa','1|rosa'),
('gammalstavning','1|stavning'),
('gammaltestamentlig','1|Gamla_Testamentet'),
('gammaltestamentlighet','1|gammaltestamentlig'),
('gamman','1|glädje'),
('gammastråle','1|gamma'),
('gammastrålning','1|strålning'),
('gammelfeminist','1|feminist'),
('gammelmedium','1|medium'),
('gammelmedium','1|medium'),
('gammelmoderat','1|moderat'),
('gammeltantsgarderob','1|garderob'),
('gammelvals','1|vals'),
('gammelvals','1|vals'),
('gamäng','1|slyngel'),
('gan','1|gäl'),
('gan','2|svalg'),
('gana','1|gan'),
('gana','2|glo'),
('ganande','1|gana'),
('ganande','2|gana'),
('ganasch','1|tuggmuskel'),
('gandhiskynke','1|regnkappa'),
('ganglie','1|nervknut'),
('ganglie','1|nervknut'),
('ganglie','2|svulst'),
('ganglie','2|svulst'),
('gangliecell','1|cell'),
('gangrenös','1|gangrän'),
('gangrän','1|kallbrand'),
('gangster','1|brottsling'),
('gangsterism','1|gangster'),
('gangsterpolare','1|polare'),
('gangsterromantik','1|romantik'),
('gans','1|snodd'),
('ganska','1|nära'),
('ganymed','1|kypare'),
('Ganymedes','1|måne'),
('gap','1|gapa'),
('gap','2|skillnad'),
('gapa','1|öppen'),
('gapa','2|skrika'),
('gapa','3|stirra'),
('gapa','4|tom'),
('gapande','1|gapa'),
('gapande','2|gapa'),
('gapande','3|gapa'),
('gapflabb','1|gapflabba'),
('gapflabba','1|gapskratta'),
('gapflabbande','1|gapflabba'),
('gaphals','1|gapa'),
('gapig','1|gapa'),
('gapighet','1|gapig'),
('gapning','1|gapa'),
('gapning','2|gapa'),
('gapning','3|gapa'),
('gapsax','1|plåtsax'),
('gapskratt','1|gapskratta'),
('gapskratta','1|skratta'),
('gapskrattande','1|gapskratta'),
('gapstock','1|skamstock'),
('gara','1|bränna'),
('gara','2|raffinera'),
('gara','3|garva'),
('garage','1|förvara'),
('garagedomkraft','1|domkraft'),
('garagera','1|garage'),
('garagerande','1|garagera'),
('garagerbar','1|garagera'),
('garagerbarhet','1|garagerbar'),
('garagering','1|garagera'),
('garageuppfart','1|uppfart'),
('garagevakt','1|vakt'),
('garande','1|gara'),
('garande','2|gara'),
('garande','3|gara'),
('garant','1|garantera'),
('garantera','1|säkra'),
('garanterande','1|garantera'),
('garanterbar','1|garantera'),
('garanterbarhet','1|garanterbar'),
('garantering','1|garantera'),
('garanti','1|garantera'),
('garantibelopp','1|belopp'),
('garantibevis','1|bevis'),
('garantifond','1|kapital'),
('garantifördrag','1|traktat'),
('garantiförsäkring','1|försäkring'),
('garantilån','1|lån'),
('garantilån','1|lån'),
('garantisumma','1|garantibelopp'),
('garçon','1|kypare'),
('garçon','1|kypare'),
('garçon','2|yngling'),
('garçon','2|yngling'),
('gard','1|boxning'),
('garde','1|förband'),
('gardenia','1|blomma'),
('gardera','1|säkra'),
('garderande','1|gardera'),
('garderbar','1|gardera'),
('garderbarhet','1|garderbar'),
('gardering','1|gardera'),
('garderob','1|förvara'),
('garderob','2|kläder'),
('garderobiär','1|rockvaktmästare'),
('garderobiär','1|rockvaktmästare'),
('garderobsbög','1|bög'),
('garderobsdörr','1|dörr'),
('garderobsmässig','1|garderob'),
('garderobsmässig','2|garderob'),
('garderobssorg','1|brist'),
('garderobsstång','1|stång'),
('gardessoldat','1|gardist'),
('gardian','1|franciskanerkloster'),
('gardin','1|fönster'),
('gardinband','1|band'),
('gardinkappa','1|gardin'),
('gardinkrok','1|upphängningskrok'),
('gardinluft','1|gardin'),
('gardinring','1|gardinstång'),
('gardinspringa','1|springa'),
('gardinstång','1|stång'),
('gardist','1|garde'),
('gardjärn','1|lokomotiv'),
('gardställning','1|gard'),
('garfågel','1|alkfågel'),
('garn','1|tråd'),
('garnbom','1|vävstol'),
('garndocka','1|garn'),
('garnera','1|dekorera'),
('garnera','2|bordlägga'),
('garnerande','1|garnera'),
('garnerande','2|garnera'),
('garnerbar','1|garnera'),
('garnerbar','2|garnera'),
('garnerbarhet','1|garnerbar'),
('garnerbarhet','2|garnerbar'),
('garnering','1|garnera'),
('garnering','2|garnera'),
('garnhank','1|garnhärva'),
('garnhärva','1|garn'),
('garnison','1|trupp'),
('garnisonera','1|garnison'),
('garnisonerande','1|garnisonera'),
('garnisonerbar','1|garnisonera'),
('garnisonerbarhet','1|garnisonerbar'),
('garnisonering','1|garnisonera'),
('garnisonspräst','1|präst'),
('garnityr','1|garnering'),
('garnityr','2|uppsättning'),
('garnnystan','1|garn'),
('garnspole','1|spole'),
('garrottera','1|avrätta'),
('garrotterande','1|garrottera'),
('garrotterbar','1|garrottera'),
('garrotterbarhet','1|garrotterbar'),
('garrottering','1|garrottera'),
('gartner','1|trädgårdsmästare'),
('garv','1|garva'),
('garva','1|bereda'),
('garva','2|skratta'),
('garvad','1|erfaren'),
('garvande','1|garva'),
('garvande','2|garva'),
('garvare','1|garva'),
('garveri','1|garva'),
('garvmedel','1|garvämne'),
('garvning','1|garva'),
('garvsyra','1|syra'),
('garvämne','1|garva'),
('gas','1|ämne'),
('gas','2|tyg'),
('gasa','1|öka'),
('gasa','2|döda'),
('gasackumulator','1|komprimera'),
('gasande','1|gasa'),
('gasande','2|gasa'),
('gasartad','1|gas'),
('gasbetong','1|lättbetong'),
('gasbil','1|bil'),
('gasbilsförsäljning','1|försäljning'),
('gasbinda','1|förband'),
('gasblandning','1|blandning'),
('gasbrand','1|infektion'),
('gasbrist','1|brist'),
('gasbrännare','1|belysning'),
('gasbubbla','1|bubbla'),
('gascognare','1|Gascogne'),
('Gascogne','1|Frankrike'),
('gasdriven','1|driva'),
('gasdynamik','1|rörelse'),
('gasell','1|antilop'),
('gaseruption','1|eruption'),
('gasett','1|tidning'),
('gasexplosion','1|explosion'),
('gasform','1|gas'),
('gasformig','1|gas'),
('gasförgiftning','1|förgiftning'),
('gasgenerator','1|generator'),
('gashydrat','1|klatrat'),
('gask','1|fest'),
('gask','2|vira'),
('gaskammare','1|avrätta'),
('gaskatastrof','1|katastrof'),
('gasklocka','1|behållare'),
('gasklot','1|klot'),
('gaskran','1|kran'),
('gaskromatograf','1|gaskromatografi'),
('gaskromatografi','1|analys'),
('gaskropp','1|kropp'),
('gaskök','1|gasolkök'),
('gaslampa','1|lampa'),
('gasledning','1|ledning'),
('gaslykta','1|lykta'),
('gaslåga','1|låga'),
('gasläcka','1|läcka'),
('gasläckage','1|läckage'),
('gaslära','1|lära'),
('gasmask','1|skydd'),
('gasmaskfodral','1|fodral'),
('gasmassa','1|massa'),
('gasmoln','1|moln'),
('gasmotor','1|motor'),
('gasol','1|gas'),
('gasolgrill','1|grill'),
('gasolin','1|bensin'),
('gasolkök','1|spis'),
('gasoltub','1|tub'),
('gasometer','1|gasklocka'),
('gaspedal','1|pedal'),
('gaspollett','1|pollett'),
('gasreglage','1|reglage'),
('gasrik','1|naturgas'),
('gasrikedom','1|gasrik'),
('gasräkning','1|räkning'),
('gass','1|solgass'),
('gassa','1|gass'),
('gassande','1|gassa'),
('gassig','1|gass'),
('gassighet','1|gassig'),
('gasskiva','1|skiva'),
('gasskydd','1|skydd'),
('gasspis','1|spis'),
('gasström','1|ström'),
('gassvetsning','1|svetsning'),
('gast','1|sjöman'),
('gast','2|vålnad'),
('gasta','1|skrika'),
('gastande','1|gasta'),
('gastera','1|gästspela'),
('gasterande','1|gastera'),
('gastering','1|gastera'),
('gastkrama','1|skräck'),
('gastkramande','1|gastkrama'),
('gastkramning','1|gastkrama'),
('gastrisk','1|mage'),
('gastrit','1|magkatarr'),
('gastrointestinal','1|inälvor'),
('gastronom','1|gastronomi'),
('gastronomi','1|matlagning'),
('gastronomisk','1|gastronomi'),
('gastroskop','1|instrument'),
('gastroskopera','1|gastroskopi'),
('gastroskoperande','1|gastroskopera'),
('gastroskoperbar','1|gastroskopera'),
('gastroskoperbarhet','1|gastroskoperbar'),
('gastroskopering','1|gastroskopera'),
('gastroskopi','1|endoskopi'),
('gastrulering','1|embryo'),
('gastryck','1|tryck'),
('gastub','1|behållare'),
('gasturbin','1|turbin'),
('gasurladdning','1|urladdning'),
('gasutsläpp','1|utsläpp'),
('gasutveckling','1|utvecklas'),
('gasventil','1|ventil'),
('gasverk','1|fabrik'),
('gasväv','1|väv'),
('gata','1|väg'),
('gate','1|utgång'),
('gatflicka','1|prostituerad'),
('gathus','1|hus'),
('gathörn','1|hörn'),
('gatlopp','1|straff'),
('gatlykta','1|lampa'),
('gatläggning','1|gatubeläggning'),
('gatpojke','1|busfrö'),
('gatslinka','1|gatflicka'),
('gatsmuts','1|smuts'),
('gatsmuts','1|smuts'),
('gatsopare','1|sopa'),
('gatsten','1|sten'),
('gatt','1|sund'),
('gatt','2|öppning'),
('gatt','3|förvara'),
('gatubarn','1|fattigbarn'),
('gatubelysning','1|belysning'),
('gatubeläggning','1|beläggning'),
('gatubuller','1|trafikbuller'),
('gatudemonstration','1|demonstration'),
('gatufred','1|gatufrid'),
('gatufrid','1|frid'),
('gatuförsäljare','1|försäljare'),
('gatuhus','1|hus'),
('gatukonst','1|konst'),
('gatukontor','1|kontor'),
('gatukors','1|gatukorsning'),
('gatukorsning','1|korsning'),
('gatukorsning','2|blandrashund'),
('gatukravaller','1|kravaller'),
('gatukök','1|kiosk'),
('gatuliv','1|vistas'),
('gatumanifestation','1|manifestation'),
('gatumusik','1|musik'),
('gatumusikant','1|musikant'),
('gatunamn','1|namn'),
('gatunge','1|gatpojke'),
('gatuparti','1|parti'),
('gatuplan','1|plan'),
('gatupoesi','1|poesi'),
('gatupris','1|pris'),
('gatuprostituerad','1|gatflicka'),
('gatuprotest','1|demonstration'),
('gatuscen','1|scen'),
('gatuspråk','1|slang'),
('gatustånd','1|stånd'),
('gatuteater','1|teater'),
('gatuvimmel','1|folkvimmel'),
('gatuvåld','1|våld'),
('gatuvåldsbekämpning','1|bekämpning'),
('gatuvåldsgrupp','1|polisstyrka'),
('gaucho','1|cowboy'),
('gauge','1|mått'),
('gaullism','1|de_Gaulle'),
('gaullist','1|de_Gaulle'),
('gaullistisk','1|de_Gaulle'),
('gaur','1|oxdjur'),
('gauss','1|mått'),
('gausskurva','1|kurva'),
('gavel','1|ände'),
('gavelfält','1|överdel'),
('gavelhus','1|ingång'),
('gavelröste','1|gavelfält'),
('gavelröste','1|gavelfält'),
('gavelspets','1|topp'),
('gavial','1|krokodil'),
('gavott','1|dans'),
('gay','1|homosexuell'),
('gayal','1|oxdjur'),
('gayscout','1|scout'),
('g-dräkt','1|skydd'),
('ge','1|åt'),
('gebit','1|fack'),
('gecko','1|geckoödla'),
('geckoödla','1|ödla'),
('gedigen','1|total'),
('gedigenhet','1|gedigen'),
('geger','1|folk'),
('gegga','1|geggamoja'),
('gegga','1|geggamoja'),
('gegga','2|kleta'),
('geggamoja','1|smet'),
('geggande','1|gegga'),
('geggig','1|kletig'),
('geggighet','1|geggig'),
('geheimeråd','1|ämbetsman'),
('gehenna','1|helvete'),
('gehäng','1|axelrem'),
('gehör','1|musik'),
('gehör','2|bifall'),
('geiger-müllerrör','1|geigermätare'),
('geigermätare','1|mäta'),
('geisha','1|kvinna'),
('geist','1|entusiasm'),
('gejd','1|skena'),
('gejser','1|vattenkälla'),
('gel','1|lösning'),
('gelada','1|hundapa'),
('gelatin','1|gelé'),
('gelatinera','1|gel'),
('gelatinera','2|gelatin'),
('gelatinerande','1|gelatinera'),
('gelatinerande','2|gelatinera'),
('gelatinerbar','1|gelatinera'),
('gelatinerbar','2|gelatinera'),
('gelatinerbarhet','1|gelatinerbar'),
('gelatinerbarhet','2|gelatinerbar'),
('gelatinering','1|gelatinera'),
('gelatinering','2|gelatinera'),
('gelatinkapsel','1|medicin'),
('gelatinös','1|geleig'),
('gelbgjutare','1|gelbgjuteri'),
('gelbgjutare','1|gelbgjuteri'),
('gelbgjuteri','1|gjuta'),
('gelbgjuteri','1|gjuta'),
('gelcoat','1|plast'),
('gelé','1|stel'),
('gelea','1|gelé'),
('geléaktig','1|gelé'),
('geleande','1|gelea'),
('geléartad','1|gelé'),
('geléhallon','1|godis'),
('geleig','1|gelé'),
('geléklump','1|klump'),
('geléråtta','1|godsak'),
('gelésvamp','1|svamp'),
('gelform','1|gel'),
('gelike','1|kamrat'),
('gelänk','1|sko'),
('gem','1|pappersklämma'),
('gem','2|ädelsten'),
('gemak','1|rum'),
('gematri','1|bokstavsmystik'),
('gemen','1|vanlig'),
('gemen','2|elak'),
('gemen','3|bokstav'),
('gemenhet','1|gemen'),
('gemenligen','1|gemen'),
('gemensam','1|ha'),
('gemensamhet','1|gemensam'),
('gemensamhetsgrav','1|grav'),
('gemensamhetskänsla','1|gemensamhet'),
('gemenskap','1|tillsammans'),
('gemenskap','2|sammanslutning'),
('gemenskapsform','1|gemenskap'),
('gemination','1|geminera'),
('geminera','1|förlänga'),
('geminerande','1|geminera'),
('geminerbar','1|geminera'),
('geminerbarhet','1|geminerbar'),
('geminering','1|geminera'),
('Gemini','1|rymdraket'),
('gemmologi','1|vetenskap'),
('gems','1|stenget'),
('gems','1|stenget'),
('gemyt','1|gemytlig'),
('gemytlig','1|trevlig'),
('gemytlighet','1|gemytlig'),
('gemål','1|make'),
('gen','1|genväg'),
('gen','1|genväg'),
('gen','2|arvsmassa'),
('gena','1|gen'),
('gena','1|gen'),
('genande','1|gena'),
('genande','1|gena'),
('genans','1|genant'),
('genant','1|genera'),
('genast','1|fort'),
('genbank','1|bevara'),
('genbankning','1|genbank'),
('gendarm','1|polis'),
('gendarmeri','1|gendarm'),
('gendriva','1|vederlägga'),
('gendrivande','1|gendriva'),
('gendrivning','1|gendriva'),
('genealog','1|genealogi'),
('genealogi','1|släktforskning'),
('genealogisk','1|genealogi'),
('genera','1|besvära'),
('genera','2|generera'),
('generad','1|genera'),
('general','1|officer'),
('generalagent','1|agent'),
('generalangrepp','1|angrepp'),
('generalbas','1|bas'),
('generalbefälhavare','1|befälhavare'),
('generaldirektör','1|chef'),
('generalfel','1|fel'),
('generalförsamling','1|möte'),
('generalguvernör','1|guvernör'),
('generalisation','1|generalisering'),
('generalisera','1|generell'),
('generaliserande','1|generalisera'),
('generaliserbar','1|generalisera'),
('generaliserbarhet','1|generaliserbar'),
('generalisering','1|generalisera'),
('generaliseringsprocess','1|generalisering'),
('generalissimus','1|befälhavare'),
('generalist','1|kunskap'),
('generalitet','1|allmängiltighet'),
('generalitet','2|general'),
('generalkarta','1|karta'),
('generalkonsul','1|konsul'),
('generalkonsulat','1|konsulat'),
('generallöjtnant','1|officer'),
('generalmajor','1|officer'),
('generalmönstring','1|mönstring'),
('generalorder','1|order'),
('generalpaus','1|paus'),
('generalplan','1|plan'),
('generalplanemässig','1|generalplan'),
('generalpostdirektör','1|chef'),
('generalprevention','1|allmänprevention'),
('generalrep','1|generalrepetition'),
('generalrepetition','1|repetition'),
('generalsekreterare','1|chef'),
('generalska','1|fru'),
('generalsperson','1|general'),
('generalstab','1|stab'),
('generalstabskarta','1|karta'),
('generalstabsnivå','1|nivå'),
('generalstrejk','1|strejk'),
('generalöverste','1|officer'),
('generande','1|genera'),
('generande','2|genera'),
('generande','3|genera'),
('generation','1|släkt'),
('generationskamrat','1|samtida'),
('generationsklyfta','1|klyfta'),
('generationskonflikt','1|konflikt'),
('generationsmässig','1|generation'),
('generationsskifte','1|generationsväxling'),
('generationstid','1|tid'),
('generationsväxling','1|växling'),
('generationsöverskridande','1|överskrida'),
('generativ','1|generera'),
('generator','1|alstra'),
('generatorgas','1|gengas'),
('generatris','1|matematik'),
('generbar','1|genera'),
('generbar','2|genera'),
('generbarhet','1|generbar'),
('generbarhet','2|generbar'),
('generell','1|allmän'),
('generell','1|allmän'),
('generera','1|skapa'),
('genererande','1|generera'),
('genererbar','1|generera'),
('genererbarhet','1|genererbar'),
('generering','1|generera'),
('genering','1|genera'),
('genering','2|genera'),
('generisk','1|släkte'),
('generositet','1|generös'),
('generös','1|ge'),
('genes','1|utveckling'),
('genetik','1|arv'),
('genetiker','1|genetik'),
('genetisk','1|genetik'),
('genett','1|skunkdjur'),
('Genève','1|stad'),
('Genève','1|stad'),
('genever','1|brännvin'),
('genflöde','1|flöde'),
('genfordran','1|kvitta'),
('genfordring','1|genfordran'),
('genförändrad','1|genmodifierad'),
('genförändring','1|förändring'),
('gengas','1|gas'),
('gengångare','1|vålnad'),
('gengångarlik','1|gengångare'),
('gengångarlikhet','1|gengångarlik'),
('gengåva','1|gåva'),
('gengälda','1|i_gengäld'),
('gengäldande','1|gengälda'),
('geni','1|klok'),
('genial','1|geni'),
('genialisk','1|genial'),
('genialitet','1|genial'),
('genidrag','1|drag'),
('genie','1|ande'),
('genital','1|kön'),
('genitalier','1|könsorgan'),
('genitalorgan','1|genitalier'),
('genitiv','1|kasus'),
('genitivattribut','1|attribut'),
('genitivmetafor','1|metafor'),
('genitivändelse','1|ändelse'),
('genius','1|genie'),
('genklang','1|återklang'),
('genkärande','1|kärande'),
('genljud','1|genklang'),
('genljuda','1|genljud'),
('genljudande','1|genljuda'),
('genmanipulation','1|genteknik'),
('genmanipulationsteknik','1|genmanipulation'),
('genmanipulera','1|genmanipulation'),
('genmanipulerande','1|genmanipulera'),
('genmanipulerbar','1|genmanipulera'),
('genmanipulerbarhet','1|genmanipulerbar'),
('genmanipulering','1|genmanipulera'),
('genmodifiera','1|genmodifierad'),
('genmodifierad','1|genteknik'),
('genmodifiering','1|genmodifierad'),
('genmäla','1|svara'),
('genmälande','1|genmäla'),
('genmäle','1|genmäla'),
('genocid','1|folkmord'),
('genom','1|i'),
('genom','1|i'),
('genom','2|gen'),
('genom','3|använda'),
('genom','3|använda'),
('genomarbeta','1|arbeta'),
('genomarbetande','1|genomarbeta'),
('genomarbetning','1|genomarbeta'),
('genombiten','1|bita'),
('genomblicka','1|blicka'),
('genomblickbar','1|genomblicka'),
('genombläddring','1|bläddra'),
('genomblödning','1|blöda'),
('genomblöt','1|blöt'),
('genomborra','1|borra'),
('genomborrande','1|genomborra'),
('genomborrning','1|genomborra'),
('genombrott','1|genombryta'),
('genombrottsbok','1|bok'),
('genombruten','1|hålmönster'),
('genombryta','1|bryta'),
('genombryta','1|bryta'),
('genombrytande','1|genombryta'),
('genombrytning','1|genombryta'),
('genomdragning','1|dra'),
('genomdriva','1|tvinga'),
('genomdriva','1|tvinga'),
('genomdrivande','1|genomdriva'),
('genomdriven','1|genomdriva'),
('genomdränka','1|dränka'),
('genomdränkande','1|genomdränka'),
('genomdränkning','1|genomdränka'),
('genomdum','1|dum'),
('genomdumhet','1|genomdum'),
('genomelak','1|elak'),
('genomfara','1|genomfart'),
('genomfarande','1|genomfara'),
('genomfart','1|fara'),
('genomfartsgata','1|gata'),
('genomfartsled','1|väg'),
('genomfartsväg','1|väg'),
('genomforskning','1|forskning'),
('genomfärd','1|genomfart'),
('genomföra','1|göra'),
('genomförande','1|genomföra'),
('genomförbar','1|genomföra'),
('genomförbarhet','1|genomförbar'),
('genomföring','1|fuga'),
('genomföring','2|isolator'),
('genomförkyld','1|förkyld'),
('genomförning','1|genomföra'),
('genomgod','1|god'),
('genomgripande','1|grundlig'),
('genomgrädda','1|grädda'),
('genomgräddning','1|grädda'),
('genomgå','1|uppleva'),
('genomgå','1|uppleva'),
('genomgående','1|hel'),
('genomgående','2|genomgående'),
('genomgående','3|gå_igenom'),
('genomgående','4|genomgå'),
('genomgång','1|gå_igenom'),
('genomgång','2|undersökning'),
('genomgång','3|presentation'),
('genomhederlig','1|hederlig'),
('genomik','1|genom'),
('genomklappning','1|sammanbrott'),
('genomkoka','1|koka'),
('genomkokande','1|genomkoka'),
('genomkokning','1|genomkoka'),
('genomkomponerad','1|genomarbeta'),
('genomkorsa','1|korsa'),
('genomkorsande','1|genomkorsa'),
('genomkorsning','1|genomkorsa'),
('genomkylning','1|kyla'),
('genomkörare','1|behandling'),
('genomletning','1|leta_igenom'),
('genomleva','1|uppleva'),
('genomlevande','1|genomleva'),
('genomlida','1|genomgå'),
('genomlidande','1|genomlida'),
('genomlysa','1|lysa'),
('genomlysande','1|genomlysa'),
('genomlysande','2|genomlysa'),
('genomlysning','1|genomlysa'),
('genomläsning','1|läsa'),
('genomlöpa','1|förlöpa'),
('genomlöpande','1|genomlöpa'),
('genommarsch','1|marschera'),
('genommönstring','1|mönstra'),
('genomorganiserad','1|organisera'),
('genomresa','1|resa'),
('genomrostad','1|rosta'),
('genomräkning','1|räkna'),
('genomseende','1|se_igenom'),
('genomseende','2|se_igenom'),
('genomseende','3|se_igenom'),
('genomsippra','1|sippra'),
('genomsipprande','1|genomsippra'),
('genomsippring','1|genomsippra'),
('genomskinlig','1|synlig'),
('genomskinlighet','1|genomskinlig'),
('genomskåda','1|avslöja'),
('genomskådande','1|genomskåda'),
('genomskärning','1|genom'),
('genomskärningsyta','1|yta'),
('genomskölja','1|skölja'),
('genomsköljande','1|genomskölja'),
('genomslag','1|verkan'),
('genomslag','2|kopiering'),
('genomslag','3|gnista'),
('genomslagsförmåga','1|förmåga'),
('genomslagskopia','1|kopia'),
('genomslagskraft','1|förmåga'),
('genomslagspapper','1|karbonpapper'),
('genomsläpplig','1|släppa'),
('genomsläpplighet','1|genomsläpplig'),
('genomsläppning','1|släppa'),
('genomsnitt','1|medeltal'),
('genomsnittlig','1|genomsnitt'),
('genomsnittlighet','1|genomsnittlig'),
('genomsnittsinkomst','1|inkomst'),
('genomsnittsmänniska','1|människa'),
('genomsnittsskatt','1|skatt'),
('genomsnittssvensk','1|svensk'),
('genomsnittsvärde','1|värde'),
('genomsnokning','1|snoka_igenom'),
('genomsnäll','1|snäll'),
('genomsteka','1|steka'),
('genomströmma','1|strömma'),
('genomströmmande','1|genomströmma'),
('genomströmning','1|utbildning'),
('genomströmning','2|strömma_genom'),
('genomstucken','1|sticka'),
('genomsur','1|sur'),
('genomsvettig','1|svettig'),
('genomsvettighet','1|genomsvettig'),
('genomsyra','1|uppfylla'),
('genomsyrande','1|genomsyra'),
('genomsyrning','1|genomsyra'),
('genomsöka','1|söka'),
('genomsökande','1|genomsöka'),
('genomsökning','1|genomsöka'),
('genomtrampning','1|trampa'),
('genomtryckt','1|tyg'),
('genomtränga','1|tränga'),
('genomträngande','1|genomtränga'),
('genomträngande','2|genomtränga'),
('genomträngd','1|genomtränga'),
('genomtränglig','1|genom'),
('genomtränglighet','1|genomtränglig'),
('genomträngning','1|genomtränga'),
('genomträngningsförmåga','1|förmåga'),
('genomtrött','1|trött'),
('genomtåg','1|tåga'),
('genomtänka','1|tänka'),
('genomtänkande','1|genomtänka'),
('genomtänkt','1|tänka'),
('genomtänkthet','1|genomtänkt'),
('genomusel','1|usel'),
('genomvarm','1|varm'),
('genomvåt','1|våt'),
('genomvärma','1|värma'),
('genomvärmning','1|genomvärma'),
('genomvävd','1|tyg'),
('genomärlig','1|ärlig'),
('genotyp','1|typ'),
('genpool','1|gen'),
('genre','1|stil'),
('genremålare','1|målare'),
('genremålning','1|måla'),
('genremålning','2|målning'),
('genremässig','1|genre'),
('genrep','1|generalrepetition'),
('genrestycke','1|föreställning'),
('genretavla','1|tavla'),
('genretänjande','1|tänja'),
('gensaga','1|protest'),
('gensare','1|tröja'),
('genskjuta','1|hinna'),
('genskjutande','1|genskjuta'),
('genskjutning','1|genskjuta'),
('genstridig','1|motsträvig'),
('genstridighet','1|genstridig'),
('gensträvig','1|motsträvig'),
('gensträvighet','1|gensträvig'),
('genstämning','1|stämning'),
('genstörtig','1|motsträvig'),
('genstörtighet','1|genstörtig'),
('gensvar','1|bifall'),
('gensägelse','1|invändning'),
('genta','1|upprepa'),
('gentagande','1|genta'),
('genteknik','1|teknik'),
('gentemot','1|mot'),
('genterapi','1|terapi'),
('genterapibehandling','1|genterapi'),
('gentiana','1|växt'),
('gentil','1|elegant'),
('gentil','1|elegant'),
('gentil','1|elegant'),
('gentiljess','1|gentil'),
('gentjänst','1|tjänst'),
('gentleman','1|man'),
('gentlemannabeslut','1|beslut'),
('gentlemannablod','1|blod'),
('gentlemannalik','1|gentleman'),
('gentlemannamässig','1|gentleman'),
('genua','1|genuafock'),
('genuafock','1|segel'),
('genuin','1|äkta'),
('genus','1|kön'),
('genus','2|kön'),
('genusforskning','1|forskning'),
('genusmässig','1|genus'),
('genusmässig','2|genus'),
('genusperspektiv','1|perspektiv'),
('genusvetenskap','1|vetenskap'),
('genväg','1|väg'),
('geocentrisk','1|centrum'),
('geodata','1|information'),
('geodesi','1|vetenskap'),
('geodet','1|geodesi'),
('geodetisk','1|kartografi'),
('geodimeter','1|mäta'),
('geodynamik','1|vetenskap'),
('geofon','1|lyssnarapparat'),
('geofysik','1|geodynamik'),
('geofysisk','1|geografisk'),
('geograf','1|geografi'),
('geografi','1|jorden'),
('geografibok','1|lärobok'),
('geografisk','1|jorden'),
('geoid','1|havsyta'),
('geokemi','1|vetenskap'),
('geokemisk','1|kemi'),
('geokronologi','1|vetenskap'),
('geokronologisk','1|tideräkning'),
('geolog','1|geologi'),
('geologi','1|vetenskap'),
('geologiprofessor','1|professor'),
('geologisk','1|bergart'),
('geometri','1|matematik'),
('geometriker','1|geometri'),
('geometrisera','1|geometrisk'),
('geometriserande','1|geometrisera'),
('geometriserbar','1|geometrisera'),
('geometriserbarhet','1|geometriserbar'),
('geometrisering','1|geometrisera'),
('geometrisk','1|geometri'),
('geomorfologi','1|vetenskap'),
('geomorfologisk','1|morfologi'),
('geopolitik','1|politik'),
('geopolitiker','1|politiker'),
('geopolitisk','1|geopolitik'),
('georgette','1|tyg'),
('Georgia','1|delstat'),
('georgiansk','1|Georgia'),
('georgianskhet','1|georgiansk'),
('Georgien','1|land'),
('georgier','1|Georgien'),
('georgisk','1|Georgien'),
('georgiska','1|språk'),
('georgiska','2|georgier'),
('georgskors','1|kors'),
('geostationär','1|satellit'),
('geostrategisk','1|strategisk'),
('geosynklinal','1|synklinal'),
('geotagga','1|tagga'),
('geotaggande','1|geotagga'),
('geoteknik','1|teknik'),
('geoteknisk','1|geoteknik'),
('geotermi','1|vetenskap'),
('geotermisk','1|geovärme'),
('geotropism','1|tyngdkraft'),
('geovetare','1|geovetenskap'),
('geovetenskap','1|vetenskap'),
('geovetenskaplig','1|geovetenskap'),
('geovärme','1|jordvärme'),
('gepard','1|kattdjur'),
('gepardunge','1|gepard'),
('gepäck','1|bagage'),
('geranium','1|midsommarblomster'),
('Gerard','1|De_Geer'),
('geriatri','1|geriatrik'),
('geriatrik','1|vetenskap'),
('geriatrisk','1|åldrande'),
('geridon','1|pelarbord'),
('geridon','1|pelarbord'),
('gerilla','1|krig'),
('gerilladåd','1|illdåd'),
('gerillakrig','1|gerilla'),
('gerillakrigare','1|gerilla'),
('gerillaledare','1|ledare'),
('gerillarörelse','1|rörelse'),
('gerillaveteran','1|veteran'),
('gering','1|fog'),
('geringslåda','1|geringssåg'),
('geringssåg','1|såg'),
('german','1|folk'),
('germanfolk','1|folk'),
('germanisera','1|förtyska'),
('germaniserande','1|germanisera'),
('germaniserbar','1|germanisera'),
('germaniserbarhet','1|germaniserbar'),
('germanisering','1|germanisera'),
('germanism','1|tyska'),
('germanist','1|språkvetare'),
('germanistik','1|germanist'),
('germanistisk','1|germanist'),
('germanium','1|grundämne'),
('germanium','1|grundämne'),
('germankrigare','1|krigare'),
('germansk','1|tysk'),
('germanstam','1|stam'),
('gerontofil','1|älska'),
('gerontologi','1|vetenskap'),
('gerontologisk','1|åldrande'),
('gerundium','1|verbform'),
('gerundivum','1|verbform'),
('gesant','1|sändebud'),
('geschwint','1|snabb'),
('geschwint','1|snabb'),
('geschwint','1|snabb'),
('geschäft','1|affär'),
('gesims','1|list'),
('gesimsbåge','1|gesims'),
('gesimslist','1|gesims'),
('gest','1|rörelse'),
('gestalt','1|varelse'),
('gestalta','1|gestalt'),
('gestaltande','1|gestalta'),
('gestaltlös','1|gestalt'),
('gestaltning','1|gestalt'),
('gestaltningsform','1|gestaltning'),
('gestaltningsmässig','1|gestaltning'),
('gestaltpsykologi','1|psykologi'),
('Gestapo','1|polis'),
('gestik','1|gestikulera'),
('gestikulation','1|gestikulera'),
('gestikulera','1|gest'),
('gestikulerande','1|gestikulera'),
('gestikulering','1|gestikulera'),
('gesäll','1|lärling'),
('gesällbrev','1|bevis'),
('gesällprov','1|arbetsprov'),
('gesällvandring','1|vandring'),
('get','1|husdjur'),
('getabock','1|bock'),
('getapel','1|vägtorn'),
('getbjällra','1|bjällra'),
('getfot','1|stämjärn'),
('getfot','2|kran'),
('geting','1|insekt'),
('getingbilla','1|getingbo'),
('getingbo','1|bo'),
('getingmidja','1|midja'),
('getingstick','1|stick'),
('getingsvärm','1|svärm'),
('getmjölk','1|mjölk'),
('getmjölksost','1|getost'),
('getost','1|ost'),
('getpors','1|skvattram'),
('getrams','1|lilja'),
('Getsemane','1|örtagård'),
('getskinn','1|skinn'),
('getskägg','1|skägg'),
('gettofiering','1|ghetto'),
('gettofiering','1|ghetto'),
('getväppling','1|ärtväxt'),
('gevaldiger','1|polisman'),
('Gevalia','1|kaffe'),
('gevär','1|vapen'),
('gevärseld','1|eld'),
('gevärsfaktori','1|fabrik'),
('gevärsgranat','1|granat'),
('gevärskolv','1|kolv'),
('gevärskompani','1|infanterikompani'),
('gevärskula','1|kula'),
('gevärsmynning','1|mynning'),
('gevärsolja','1|olja'),
('gevärspatron','1|patron'),
('gevärspipa','1|pipa'),
('gevärspost','1|post'),
('gevärssalva','1|salva'),
('gevärssikte','1|sikte'),
('gevärsskott','1|skott'),
('gevärssmed','1|vapensmed'),
('gevärssmide','1|gevärssmed'),
('gevärsstock','1|gevär'),
('gevärsväska','1|väska'),
('Ghana','1|land'),
('ghanan','1|Ghana'),
('ghanansk','1|Ghana'),
('ghananska','1|ghanan'),
('ghanes','1|ghanan'),
('ghanesisk','1|ghanansk'),
('ghasel','1|versmått'),
('ghetto','1|stadsdel'),
('ghetto','1|stadsdel'),
('ghost-writer','1|spökskrivare'),
('gibbon','1|apa'),
('Gibraltar','1|koloni'),
('giffel','1|bulle'),
('gift','1|gifta_sig'),
('gift','2|ämne'),
('giftapparat','1|organ'),
('giftaslysten','1|gifta_sig'),
('giftastankar','1|gifta_sig'),
('giftasvuxen','1|vuxen'),
('giftasvuxenhet','1|giftasvuxen'),
('giftavdunstning','1|avdunstning'),
('giftbetning','1|beta'),
('giftblandare','1|giftmord'),
('giftblandning','1|giftblandare'),
('giftblandning','2|blandning'),
('giftblåsa','1|blåsa'),
('giftbok','1|register'),
('giftbägare','1|självmord'),
('giftdryck','1|dryck'),
('gifte','1|gifta_sig'),
('giftermål','1|gifta_sig'),
('giftermålsanbud','1|anbud'),
('giftermålsbalk','1|lagbalk'),
('giftfri','1|gift'),
('giftgas','1|gift'),
('giftgrön','1|grön'),
('gifthalt','1|halt'),
('giftig','1|gift'),
('giftig','2|elak'),
('giftighet','1|giftig'),
('giftighet','2|giftig'),
('giftinformation','1|information'),
('giftinformationscentral','1|central'),
('giftinjektion','1|injektion'),
('giftkapsel','1|kapsel'),
('giftkörtel','1|körtel'),
('giftlära','1|lära'),
('giftmoln','1|moln'),
('giftmord','1|mord'),
('giftmängd','1|mängd'),
('giftoman','1|målsman'),
('giftorm','1|orm'),
('giftorätt','1|rätt'),
('giftpiller','1|piller'),
('giftregn','1|regn'),
('giftslam','1|avloppsslam'),
('giftspindel','1|spindel'),
('giftspruta','1|spruta'),
('giftspruta','2|spruta'),
('giftstadga','1|stadga'),
('gifttagg','1|tagg'),
('gifttand','1|tand'),
('gifttransport','1|transport'),
('giftutsläpp','1|utsläpp'),
('giftverkan','1|verkan'),
('gig','1|popkonsert'),
('giga','1|violin'),
('giga','2|råsegel'),
('gigabyte','1|byte'),
('gigabyte','1|byte'),
('gigande','1|giga'),
('gigant','1|jätte'),
('gigantisk','1|stor'),
('gigaton','1|ton'),
('gigawatt','1|watt'),
('gigg','1|vagn'),
('gigg','2|skeppsbåt'),
('gigga','1|spotta'),
('giggande','1|gigga'),
('gigolo','1|dansör'),
('gikt','1|sjukdom'),
('giktbruten','1|gikt'),
('giktbrutenhet','1|giktbruten'),
('giktring','1|skydd'),
('gilja','1|fria'),
('giljande','1|gilja'),
('giljare','1|gilja'),
('giljarfärd','1|färd'),
('giljarstråt','1|giljarfärd'),
('giljotin','1|halshugga'),
('giljotinera','1|giljotin'),
('giljotinerande','1|giljotinera'),
('giljotinerbar','1|giljotinera'),
('giljotinerbarhet','1|giljotinerbar'),
('giljotinering','1|giljotin'),
('gill','1|giltig'),
('gilla','1|tycka_om'),
('gilla','2|godkänna'),
('gillande','1|gilla'),
('gillande','2|gilla'),
('gillas','1|giltig'),
('gille','1|kalas'),
('gille','2|förening'),
('giller','1|fälla'),
('gillesbroder','1|medlem'),
('gillessocialism','1|makt'),
('gillestuga','1|sällskapsrum'),
('gillestuga','1|sällskapsrum'),
('gillhet','1|gill'),
('gillra','1|giller'),
('gillrande','1|gillra'),
('giltig','1|gälla'),
('giltighet','1|giltig'),
('giltighetstid','1|tid'),
('gimmick','1|trick'),
('gin','1|dryck'),
('gina','1|talja'),
('ginbalk','1|balk'),
('gindrink','1|drink'),
('gingham','1|tyg'),
('ginnungagap','1|avgrund'),
('ginseng','1|naturmedicin'),
('ginseng','2|växt'),
('ginst','1|buske'),
('ginstkatt','1|genett'),
('ginväg','1|genväg'),
('gip','1|mark'),
('gipa','1|mungipa'),
('gipp','1|vända'),
('gipp','1|vända'),
('gippa','1|gipp'),
('gippa','1|gipp'),
('gippande','1|gippa'),
('gippande','1|gippa'),
('gips','1|kalk'),
('gipsa','1|gipsförband'),
('gipsande','1|gipsa'),
('gipsavgjutning','1|avgjutning'),
('gipsbruk','1|gips'),
('gipsbyst','1|byst'),
('gipsfigur','1|figur'),
('gipsform','1|form'),
('gipsförband','1|förband'),
('gipsklump','1|klump'),
('gipsmurbruk','1|gipsbruk'),
('gipsornament','1|ornament'),
('gipsplatta','1|platta'),
('gipsputs','1|gipsbruk'),
('gipsskiva','1|gipsplatta'),
('gipstak','1|innertak'),
('gipsvägg','1|vägg'),
('gipyr','1|spets'),
('gir','1|gira'),
('gira','1|svänga'),
('giraff','1|djur'),
('giraffliknande','1|giraff'),
('girande','1|gira'),
('girandole','1|ljusstake'),
('girera','1|giro'),
('girerande','1|girera'),
('girerbar','1|girera'),
('girerbarhet','1|girerbar'),
('girering','1|girera'),
('girig','1|snål'),
('girigbuk','1|girig'),
('girighet','1|girig'),
('girih-mönster','1|utsmyckning'),
('girland','1|band'),
('girland','1|band'),
('girning','1|gira'),
('giro','1|överföring'),
('girobesked','1|bevis'),
('girvuxen','1|träd'),
('girväxt','1|girvuxen'),
('gissa','1|ana'),
('gissande','1|gissa'),
('gissel','1|piska'),
('gissel','2|flimmerhår'),
('gissel','3|plåga'),
('gisseldjur','1|flagellat'),
('gisselslag','1|slag'),
('gissla','1|gissel'),
('gissla','2|gissel'),
('gisslan','1|fånge'),
('gisslande','1|gissla'),
('gisslande','2|gissla'),
('gisslandrama','1|drama'),
('gisslansituation','1|situation'),
('gisslantagande','1|gisslan'),
('gisslantagare','1|gisslan'),
('gisslare','1|flagellant'),
('gisslartåg','1|tåg'),
('gissling','1|gissla'),
('gissling','2|gissla'),
('gissning','1|gissa'),
('gissningslek','1|lek'),
('gissningstävling','1|tävling'),
('gissningsvis','1|antagligen'),
('gist','1|gistgård'),
('gista','1|gist'),
('gistande','1|gista'),
('gisten','1|otät'),
('gistenhet','1|gisten'),
('gistgård','1|torka'),
('gistna','1|gisten'),
('gistnande','1|gistna'),
('gitarr','1|instrument'),
('gitarrackompanjemang','1|ackompanjemang'),
('gitarrist','1|gitarr'),
('gitarrmusik','1|musik'),
('gitarrsolo','1|solo'),
('gitarrspel','1|spel'),
('gitarrspelare','1|gitarrist'),
('gitarrsträng','1|sträng'),
('gitta','1|orka'),
('gittande','1|gitta'),
('gitter','1|rutnät'),
('gitter','2|galler'),
('giv','1|initiativ'),
('giv','2|kort'),
('givakt','1|stå'),
('givakt','2|givakt'),
('givakt','2|givakt'),
('givande','1|nyttig'),
('givande','2|ge'),
('givande','2|ge'),
('givare','1|ge'),
('givare','2|mätare'),
('givas','1|finnas'),
('given','1|självklar'),
('given','2|överens'),
('given','3|faktisk'),
('givenhet','1|given'),
('givenhet','2|given'),
('givet','1|förutsatt'),
('givetvis','1|naturligtvis'),
('givkort','1|giv'),
('givmild','1|generös'),
('givmildhet','1|givmild'),
('givning','1|ge'),
('gjord','1|sadelgjord'),
('gjord','2|göra'),
('gjord','3|göra'),
('gjord','4|göra'),
('gjorda','1|gjord'),
('gjordande','1|gjorda'),
('gjuse','1|fiskgjuse'),
('gjuta','1|forma'),
('gjuta','2|hälla'),
('gjutande','1|gjuta'),
('gjutande','2|gjuta'),
('gjutare','1|gjuta'),
('gjutbar','1|gjuta'),
('gjutbarhet','1|gjutbar'),
('gjutbetong','1|betong'),
('gjuteri','1|gjuta'),
('gjutflaska','1|form'),
('gjutform','1|form'),
('gjutgods','1|gjuta'),
('gjutjärn','1|järn'),
('gjutjärnsbro','1|bro'),
('gjutjärnsgryta','1|gryta'),
('gjutjärnsspis','1|spis'),
('gjutmassa','1|massa'),
('gjutmodell','1|modell'),
('gjutning','1|gjuta'),
('gjutrand','1|kant'),
('gjutsand','1|formsand'),
('gjutstål','1|stål'),
('g-klav','1|diskantklav'),
('G-krafter','1|tyngdkraft'),
('G-krafter','1|tyngdkraft'),
('glacéhandske','1|handske'),
('glaci','1|yta'),
('glacial','1|istid'),
('glacialperiod','1|istid'),
('glacialräffla','1|räffla'),
('glacifluvial','1|smältvatten'),
('glaciolog','1|glaciologi'),
('glaciologi','1|vetenskap'),
('glaciologisk','1|glaciär'),
('glaciär','1|is'),
('glaciärbrunn','1|schakt'),
('glaciäris','1|glaciär'),
('glaciärnisch','1|nisch'),
('glaciärport','1|hål'),
('glaciärräffla','1|glacialräffla'),
('glaciärsmältning','1|issmältning'),
('glaciärälv','1|älv'),
('glad','1|bra'),
('glad','2|glänta'),
('glada','1|rovfågel'),
('gladelig','1|glad'),
('gladelig','1|glad'),
('gladeligen','1|utan_tvekan'),
('gladeligen','1|utan_tvekan'),
('Glader','1|dvärg'),
('gladhet','1|glad'),
('gladiator','1|fäktare'),
('gladiatorgrav','1|grav'),
('gladiatorskola','1|skola'),
('gladiatorspel','1|spel'),
('gladiolus','1|lilja'),
('gladlynt','1|glad'),
('gladlynthet','1|gladlynt'),
('gladporr','1|porr'),
('glagolitisk','1|alfabet'),
('glam','1|skratt'),
('glamma','1|glam'),
('glammande','1|glamma'),
('glammig','1|glamorös'),
('glammighet','1|glammig'),
('glamorisera','1|positiv'),
('glamorisera','1|positiv'),
('glamoriserande','1|glamorisera'),
('glamoriserande','1|glamorisera'),
('glamoriserbar','1|glamorisera'),
('glamoriserbar','1|glamorisera'),
('glamoriserbarhet','1|glamoriserbar'),
('glamoriserbarhet','1|glamoriserbar'),
('glamorisering','1|glamorisera'),
('glamorisering','1|glamorisera'),
('glamorös','1|glamour'),
('glamorös','1|glamour'),
('glamour','1|flott'),
('glana','1|stirra'),
('glanande','1|glana'),
('glandel','1|körtel'),
('glandulös','1|glandel'),
('glans','1|glänsa'),
('glansa','1|glans'),
('glansande','1|glansa'),
('glansbagge','1|skalbagge'),
('glansdagar','1|period'),
('glansfull','1|högtidlig'),
('glansfullhet','1|glansfull'),
('glansig','1|glans'),
('glansighet','1|glansig'),
('glansis','1|is'),
('glansk','1|glansig'),
('glanska','1|glansk'),
('glanskande','1|glanska'),
('glanskhet','1|glansk'),
('glanskis','1|glansis'),
('glanskning','1|glanska'),
('glanslös','1|glans'),
('glanslöshet','1|glanslös'),
('glansning','1|glansa'),
('glansnummer','1|nummer'),
('glanspapper','1|papper'),
('glansperiod','1|glansdagar'),
('glansroll','1|glansnummer'),
('glanssot','1|sot'),
('glanstid','1|glansdagar'),
('glansull','1|kapock'),
('glapp','1|otät'),
('glapp','2|springa'),
('glappa','1|glapp'),
('glappande','1|glappa'),
('glapphet','1|glapp'),
('glappkontakt','1|kontakt'),
('glappning','1|glappa'),
('glapprum','1|glapp'),
('glarre','1|glass'),
('glas','1|material'),
('glas','2|dricka'),
('glas','3|halvtimme'),
('glasa','1|glas'),
('glasaktig','1|glasartad'),
('glasaktig','2|glasartad'),
('glasande','1|glasa'),
('glasartad','1|glas'),
('glasartad','2|stirra'),
('glasberget','1|ungmö'),
('glasbit','1|glas'),
('glasbjörk','1|björk'),
('glasblåsare','1|glasblåsning'),
('glasblåsarpipa','1|pipa'),
('glasblåseri','1|verkstad'),
('glasblåsning','1|forma'),
('glasbruk','1|bruk'),
('glasbult','1|fisk'),
('glasburk','1|burk'),
('glasdörr','1|dörr'),
('glasera','1|glasyr'),
('glaserande','1|glasera'),
('glaserbar','1|glasera'),
('glaserbarhet','1|glaserbar'),
('glasering','1|glasera'),
('glasfiber','1|fiber'),
('glasfiberarmera','1|armera'),
('glasfiberarmerande','1|glasfiberarmera'),
('glasfiberarmering','1|glasfiberarmera'),
('glasfiberförstärkt','1|förstärka'),
('glasfiberull','1|glasfiber'),
('glasfiberväv','1|väv'),
('glasflaska','1|flaska'),
('glasfluss','1|flussmedel'),
('glasframställning','1|framställning'),
('glasföremål','1|föremål'),
('glashal','1|hal'),
('glashandduk','1|kökshandduk'),
('glasharmonika','1|instrument'),
('glashus','1|mästra'),
('glashuv','1|huv'),
('glashylla','1|hylla'),
('glashytta','1|glasbruk'),
('glasig','1|glasartad'),
('glasighet','1|genomskinlig'),
('glasiglo','1|returglas'),
('glasiologisk','1|glaciär'),
('glaskanna','1|kanna'),
('glaskaraff','1|karaff'),
('glasklar','1|genomskinlig'),
('glasklar','2|uppenbar'),
('glasklocka','1|skydd'),
('glasklot','1|klot'),
('glaskolv','1|kolv'),
('glaskropp','1|öga'),
('glaskub','1|kub'),
('glaskula','1|julgranskula'),
('glasmassa','1|glas'),
('glasmonter','1|monter'),
('glasmålare','1|glasmåleri'),
('glasmåleri','1|måla'),
('glasmålning','1|målning'),
('glasmästardiamant','1|skära'),
('glasmästare','1|tillverka'),
('glasmästarsill','1|sill'),
('glasmästeri','1|glasmästare'),
('glasnost','1|öppenhet'),
('glasplåt','1|fotografiplåt'),
('glaspokal','1|pokal'),
('glasprisma','1|prisma'),
('glaspärla','1|pärla'),
('glasrengöring','1|rengöring'),
('glasruta','1|fönsterruta'),
('glasrör','1|rör'),
('glass','1|äta'),
('glass','1|äta'),
('glassa','1|glassig'),
('glassande','1|glassa'),
('glassbil','1|bil'),
('glassbomb','1|glassdessert'),
('glassbägare','1|bägare'),
('glassdessert','1|dessert'),
('glassfabrik','1|fabrik'),
('glassförsäljning','1|försäljning'),
('glassig','1|glänsa'),
('glassighet','1|glassig'),
('glasskiva','1|skiva'),
('glasskål','1|skål'),
('glasskåp','1|skåp'),
('glasskåp','2|skåp'),
('glasskärardiamant','1|glasmästardiamant'),
('glasskärare','1|glasmästardiamant'),
('glasskärva','1|skärva'),
('glasslipare','1|slipa'),
('glasslipning','1|slipa'),
('glasslycka','1|lycklig'),
('glassmaskin','1|tillverka'),
('glasspamp','1|direktör'),
('glasspinne','1|glass'),
('glassplitter','1|splitter'),
('glassportion','1|glass'),
('glassrecept','1|recept'),
('glasstrut','1|glass'),
('glasstårta','1|tårta'),
('glassälskare','1|älska'),
('glastak','1|tak'),
('glasull','1|glasfiberull'),
('glasvakt','1|vakt'),
('glasvar','1|flundra'),
('glasveranda','1|veranda'),
('glasvete','1|durumvete'),
('glasvingefjäril','1|fjäril'),
('glasvägg','1|vägg'),
('glasvätska','1|glaskropp'),
('glasyr','1|skikt'),
('glasål','1|ål'),
('glasäpple','1|äpple'),
('glasöga','1|emaljöga'),
('glasögon','1|avhjälpa'),
('glasögonbjörn','1|björn'),
('glasögonbåge','1|glasögon'),
('glasögonfodral','1|fodral'),
('glasögonorm','1|orm'),
('glasögonorm','2|pojke'),
('glasört','1|växt'),
('glatt','1|slät'),
('glatthet','1|glatt'),
('glattis','1|is'),
('glattmask','1|mask'),
('glattpolera','1|polera'),
('glattpolerande','1|glattpolera'),
('glattpolering','1|glattpolera'),
('glattslipa','1|slipa'),
('glattslipande','1|glattslipa'),
('glattslipning','1|glattslipa'),
('glaubersalt','1|natriumsulfat'),
('glaukom','1|grönstarr'),
('glav','1|vapen'),
('glencheck','1|rutig'),
('gles','1|tät'),
('glesa','1|glespanela'),
('glesande','1|glesa'),
('glesbefolkad','1|befolka'),
('glesbladig','1|blad'),
('glesbygd','1|bygd'),
('glesbygdsbo','1|glesbygd'),
('gleshet','1|gles'),
('gleshårig','1|hår'),
('glesläkt','1|glespanel'),
('glesna','1|gles'),
('glesnande','1|glesna'),
('glespanel','1|regel'),
('glespanela','1|glespanel'),
('glespanelande','1|glespanela'),
('glesregel','1|glespanel'),
('glesvävd','1|väva'),
('glete','1|blyglete'),
('gletscher','1|glaciär'),
('gli','1|fiskyngel'),
('gli','2|barn'),
('glia','1|vävnad'),
('glid','1|glida'),
('glida','1|slät'),
('glidande','1|glida'),
('glidarkille','1|skolpojke'),
('glidflygning','1|glidflykt'),
('glidflykt','1|flyga'),
('glidfriktion','1|friktion'),
('glidkontakt','1|kontakt'),
('glidkräm','1|salva'),
('glidlager','1|axellager'),
('glidljud','1|språkljud'),
('glidmedel','1|glidkräm'),
('glidning','1|glida'),
('glidsalva','1|salva'),
('glidslem','1|glidmedel'),
('glidtackling','1|tackling'),
('glim','1|växt'),
('glima','1|brottning'),
('glimlampa','1|lampa'),
('glimljus','1|ljus'),
('glimma','1|lysa'),
('glimmande','1|glimma'),
('glimmer','1|mineral'),
('glimmer','2|glans'),
('Glimmingehus','1|borg'),
('glimra','1|lysa'),
('glimrande','1|glimra'),
('glimt','1|glimta'),
('glimta','1|synas'),
('glimtande','1|glimta'),
('glimtvis','1|glimta'),
('glimtändare','1|lysrör'),
('glinder','1|fiskedrag'),
('glindra','1|glimra'),
('glindrande','1|glindra'),
('gliom','1|tumör'),
('glipa','1|springa'),
('glipa','2|glipa'),
('glipande','1|glipa'),
('gliring','1|spydighet'),
('glis','1|vildpersilja'),
('glis','2|sjusovare'),
('glisa','1|lysa'),
('glisande','1|glisa'),
('glissando','1|glida'),
('glisört','1|glis'),
('glitter','1|glittra'),
('glitterfin','1|fin'),
('glittergirlang','1|girland'),
('glitterglad','1|glad'),
('glitterprydd','1|pryda'),
('glittertryck','1|tryck'),
('glittra','1|lysa'),
('glittrande','1|glittra'),
('glittrig','1|glittra'),
('glittrighet','1|glittrig'),
('glo','1|stirra'),
('glob','1|klot'),
('global','1|världsomfattande'),
('globaliserad','1|globalisering'),
('globalisering','1|utveckling'),
('Globen','1|arena'),
('globetrotter','1|vittberest'),
('globulin','1|äggviteämne'),
('gloende','1|glo'),
('glop','1|slyngel'),
('glopp','1|snöglopp'),
('gloria','1|ljus'),
('gloria','2|tyg'),
('glorifiera','1|förhärliga'),
('glorifierande','1|glorifiera'),
('glorifierbar','1|glorifiera'),
('glorifierbarhet','1|glorifierbar'),
('glorifiering','1|glorifiera'),
('gloriös','1|ära'),
('glosa','1|ord'),
('glosbok','1|bok'),
('glosig','1|glosögd'),
('glossa','1|förklaring'),
('glossar','1|glossarium'),
('glossarium','1|ordbok'),
('glossematik','1|språkteori'),
('glossig','1|glassig'),
('glossolali','1|tungomålstalande'),
('glosögd','1|öga'),
('glosögdhet','1|glosögd'),
('glosögon','1|glosögd'),
('glottis','1|ljudspringa'),
('glottisstöt','1|språkljud'),
('glottokronologi','1|kronologi'),
('gloxinia','1|krukväxt'),
('glugg','1|öppning'),
('glukos','1|druvsocker'),
('glukos','1|druvsocker'),
('glunka','1|antyda'),
('glunkande','1|glunka'),
('glunkas','1|rykte'),
('glunt','1|studentsång'),
('gluon','1|kärnpartikel'),
('glupande','1|glupsk'),
('glupsk','1|äta'),
('glupskhet','1|glupsk'),
('glutamat','1|smakämne'),
('glutaminsyra','1|aminosyra'),
('gluten','1|äggviteämne'),
('gluten','2|glutenintolerant'),
('gluten','3|glutenintolerans'),
('glutenfri','1|gluten'),
('glutenintolerans','1|glutenintolerant'),
('glutenintolerant','1|överkänslig'),
('glutinös','1|klibbig'),
('glutta','1|titta'),
('gluttande','1|glutta'),
('gluttare','1|glutta'),
('gluttsnäppa','1|snäppa'),
('glycerid','1|glycerin'),
('glycerin','1|glycerol'),
('glycerintvål','1|tvål'),
('glycerol','1|ämne'),
('glycerylnitrat','1|nitroglycerin'),
('glycin','1|blåregn'),
('glykogen','1|kolhydrat'),
('glykol','1|kylarvätska'),
('glykolys','1|ämnesomsättning'),
('glykopeptid','1|ämne'),
('glykosid','1|ämne'),
('glyptik','1|gravera'),
('glyptotek','1|museum'),
('glytt','1|barnunge'),
('glyttig','1|barnslig'),
('glyttighet','1|glyttig'),
('glåmig','1|blek'),
('glåmighet','1|glåmig'),
('glåpord','1|förolämpa'),
('glädja','1|glad'),
('glädjande','1|glädje'),
('glädjande','2|glädja'),
('glädje','1|glad'),
('glädjebesked','1|besked'),
('glädjebetyg','1|överbetyg'),
('glädjebetygelse','1|visa'),
('glädjebetygssättning','1|betygsättning'),
('glädjebringande','1|glädje'),
('glädjebud','1|bud'),
('glädjebudskap','1|budskap'),
('glädjedag','1|dag'),
('glädjedans','1|dans'),
('glädjedödare','1|förstöra'),
('glädjefattig','1|glädje'),
('glädjefest','1|fest'),
('glädjeflicka','1|prostituerad'),
('glädjefnatt','1|glädje'),
('glädjefull','1|glädjefylld'),
('glädjefylld','1|full'),
('glädjefylldhet','1|glädjefylld'),
('glädjehopp','1|hopp'),
('glädjehus','1|bordell'),
('glädjehögtid','1|högtid'),
('glädjekalkyl','1|kalkyl'),
('glädjekvarter','1|kvarter'),
('glädjelös','1|glädje'),
('glädjemäta','1|mäta'),
('glädjemätande','1|glädjemäta'),
('glädjemätning','1|glädjemäta'),
('glädjerik','1|glädje'),
('glädjerop','1|rop'),
('glädjerus','1|rusig'),
('glädjerusig','1|glädjerus'),
('glädjerusighet','1|glädjerusig'),
('glädjeskri','1|skri'),
('glädjespridare','1|sprida'),
('glädjesprång','1|språng'),
('glädjestrålande','1|glädje'),
('glädjetom','1|glädje'),
('glädjetår','1|tår'),
('glädjeyra','1|yra'),
('glädjeyttring','1|glädje'),
('glädjeämne','1|glädje'),
('gläfs','1|gläfsa'),
('gläfsa','1|läte'),
('gläfsande','1|gläfsa'),
('gläfsning','1|gläfsa'),
('glänsa','1|lysa'),
('glänsande','1|framstående'),
('glänsande','2|glänsa'),
('glänta','1|öppning'),
('glänta','2|på_glänt'),
('gläntande','1|glänta'),
('glätta','1|glatt'),
('glätta','1|glatt'),
('glättad','1|positiv'),
('glättande','1|glätta'),
('glättande','1|glätta'),
('glättig','1|glad'),
('glättighet','1|glättig'),
('glättning','1|glätta'),
('glättning','1|glätta'),
('glättsten','1|gnidsten'),
('glöd','1|glöda'),
('glöd','2|ivrig'),
('glöd','3|eld'),
('glöda','1|eld'),
('glödande','1|glöda'),
('glödande','2|het'),
('glödbaka','1|baka'),
('glödbakande','1|glödbaka'),
('glödbädd','1|glöd'),
('glödeld','1|glöd'),
('glödfat','1|behållare'),
('glödga','1|värmebehandla'),
('glödgande','1|glödga'),
('glödgning','1|glödga'),
('glödhet','1|het'),
('glödhetta','1|glöd'),
('glödhoppa','1|bröd'),
('glödhög','1|hög'),
('glödkatod','1|katod'),
('glödkropp','1|glödning'),
('glödlampa','1|lampa'),
('glödlampsfabrik','1|fabrik'),
('glödljus','1|ljus'),
('glödmjuk','1|mjuk'),
('glödning','1|glöda'),
('glödrita','1|rita'),
('glödritande','1|glödrita'),
('glödritning','1|glödrita'),
('glödröd','1|röd'),
('glödsteka','1|steka'),
('glödstekande','1|glödsteka'),
('glödstrumpa','1|glödkropp'),
('glödström','1|ström'),
('glödtråd','1|tråd'),
('glödtända','1|tändning'),
('glödtändande','1|glödtända'),
('glödvarm','1|varm'),
('glögg','1|dryck'),
('glögga','1|glögg'),
('glöggande','1|glögga'),
('glöggpanna','1|panna'),
('glöggryta','1|glöggpanna'),
('glöggsörpling','1|sörpla'),
('glöggtest','1|test'),
('glömd','1|glömma'),
('glömd','2|glömma'),
('glömma','1|minnas'),
('glömma','2|lämna_kvar'),
('glömmande','1|glömma'),
('glömmande','2|glömma'),
('glömsk','1|glömma'),
('glömska','1|glömma'),
('glömskekurva','1|diagram'),
('glömskhet','1|glömsk'),
('glöta','1|snoka'),
('glötande','1|glöta'),
('gnabb','1|smågräl'),
('gnabbas','1|gnabb'),
('gnag','1|gnaga'),
('gnaga','1|bita'),
('gnagande','1|gnaga'),
('gnagare','1|djur'),
('gnagarliknande','1|gnagare'),
('gnagning','1|gnaga'),
('gnagtand','1|framtand'),
('gnat','1|gnata'),
('gnata','1|kritisera'),
('gnatande','1|gnata'),
('gnatig','1|gnata'),
('gnatighet','1|gnatig'),
('gnava','1|gnaga'),
('gnavande','1|gnava'),
('gnejs','1|bergart'),
('gnet','1|ägg'),
('gnet','2|gnetig'),
('gneta','1|snåla'),
('gnetande','1|gneta'),
('gnetig','1|gneta'),
('gnetighet','1|gnetig'),
('gnida','1|röra'),
('gnidande','1|gnida'),
('gnidare','1|gnidig'),
('gniden','1|gnidig'),
('gnidenhet','1|gniden'),
('gnideri','1|gnidig'),
('gnidig','1|snål'),
('gnidning','1|gnida'),
('gnidningselektricitet','1|elektricitet'),
('gnidsten','1|glätta'),
('gnissel','1|gnissla'),
('gnisselljud','1|gnissel'),
('gnissla','1|låta'),
('gnisslande','1|gnissla'),
('gnissling','1|gnissla'),
('gnist','1|telegraf'),
('gnista','1|eld'),
('gnista','2|meddela'),
('gnista','3|entusiasm'),
('gnistande','1|gnista'),
('gnistbildning','1|bilda'),
('gnistfångare','1|gnistskydd'),
('gnistgaller','1|gnistskydd'),
('gnistgap','1|elektrod'),
('gnistinduktor','1|induktionsapparat'),
('gnistkammare','1|fotografera'),
('gnistra','1|lysa'),
('gnistrande','1|gnistra'),
('gnistregn','1|regn'),
('gnistrig','1|gnistra'),
('gnistrighet','1|gnistrig'),
('gnistskydd','1|skydd'),
('gnistsläckare','1|släcka'),
('gniststation','1|telegrafstation'),
('gniststräcka','1|gnistgap'),
('gnistsändare','1|radiosändare'),
('gnisttändning','1|tändstift'),
('gno','1|gnida'),
('gno','2|slita'),
('gno','3|flänga'),
('gnoding','1|knorrhane'),
('gnoende','1|gno'),
('gnoende','2|gno'),
('gnoende','3|gno'),
('gnola','1|sjunga'),
('gnolande','1|gnola'),
('gnom','1|tomte'),
('gnom','2|levnadsregel'),
('gnomiker','1|gnom'),
('gnomon','1|visare'),
('gnosis','1|kunskap'),
('Gnosjöanda','1|framåtanda'),
('gnosticism','1|religion'),
('gnostiker','1|gnosticism'),
('gnostisk','1|gnosticism'),
('gnu','1|antilop'),
('gnugga','1|gnida'),
('gnuggande','1|gnugga'),
('gnuggbild','1|bild'),
('gnuggning','1|gnugga'),
('gnuggsten','1|bergart'),
('gnuss','1|foxtrot'),
('gnussa','1|gnuss'),
('gnussande','1|gnussa'),
('gnussare','1|gnuss'),
('gnutta','1|en_gnutta'),
('gny','1|jämra_sig'),
('gny','2|gny'),
('gnyende','1|gny'),
('gnägg','1|gnägga'),
('gnägga','1|läte'),
('gnäggande','1|gnägga'),
('gnäggning','1|gnägga'),
('gnäll','1|gnälla'),
('gnälla','1|klaga'),
('gnällande','1|gnälla'),
('gnällig','1|gnälla'),
('gnällighet','1|gnällig'),
('gnällmåns','1|gnälla'),
('gnällspik','1|gnälla'),
('gnöl','1|gnöla'),
('gnöla','1|klaga'),
('gnölande','1|gnöla'),
('go','1|initiativkraft'),
('go','2|härlig'),
('go','3|spel'),
('gobeläng','1|vävnad'),
('gobelängbroderi','1|broderi'),
('gobelängklädd','1|klä'),
('gobelängtyg','1|tyg'),
('go-cart','1|biltävling'),
('god','1|bra'),
('god','2|smaka'),
('god','3|ordentlig'),
('godartad','1|ofarlig'),
('godbit','1|bit'),
('goddagar','1|period'),
('goddagspilt','1|man'),
('gode','1|blot'),
('godemanskap','1|förmyndare'),
('godemanskap','1|förmyndare'),
('godhet','1|god'),
('godhetsfull','1|vänlig'),
('godhetsfullhet','1|godhetsfull'),
('godhjärtad','1|god'),
('godhjärtenhet','1|godhjärtad'),
('godhällig','1|god'),
('godhällighet','1|godhällig'),
('goding','1|kvinna'),
('godis','1|godsak'),
('godis','2|godis'),
('godishjärta','1|godis'),
('godisjakt','1|söka'),
('godislycka','1|lycklig'),
('godislycka','2|lyckas'),
('godispanik','1|sockersug'),
('godissugen','1|sugen'),
('godissugenhet','1|godissugen'),
('godkänd','1|godkänna'),
('godkänna','1|ja'),
('godkännande','1|godkänna'),
('godkännare','1|godkänna'),
('godlynt','1|godhjärtad'),
('godlynthet','1|godlynt'),
('godmodig','1|god'),
('godmodighet','1|godmodig'),
('godnattsaga','1|saga'),
('gods','1|frakta'),
('gods','2|gård'),
('gods','3|material'),
('godsak','1|god'),
('godsexpedition','1|gods'),
('godsfinka','1|godsvagn'),
('godsherre','1|äga'),
('godsindragning','1|indragning'),
('godsint','1|godmodig'),
('godsinthet','1|godsint'),
('godsmagasin','1|magasin'),
('godsmottagning','1|mottagning'),
('godsstation','1|station'),
('godsterminal','1|terminal'),
('godstrafik','1|trafik'),
('godstransport','1|transport'),
('godståg','1|tåg'),
('godsvagn','1|järnvägsvagn'),
('godsägare','1|gods'),
('godsägarinna','1|godsägare'),
('godsägarstil','1|stil'),
('godta','1|acceptera'),
('godtagande','1|godta'),
('godtagbar','1|godta'),
('godtagbarhet','1|godtagbar'),
('godtemplare','1|godtemplarorden'),
('godtemplarorden','1|orden'),
('godtrogen','1|tro'),
('godtrogenhet','1|godtrogen'),
('godtrosförvärv','1|förvärva'),
('godtycke','1|godtycklig'),
('godtycklig','1|osaklig'),
('godtycklig','2|slump'),
('godtycklighet','1|godtycklig'),
('godtycklighet','2|godtycklig'),
('godvikt','1|ersättning'),
('godvillig','1|frivillig'),
('godvillighet','1|godvillig'),
('goffrera','1|våffelmönstrad'),
('goffrera','1|våffelmönstrad'),
('goffrerande','1|goffrera'),
('goffrerande','1|goffrera'),
('goffrerbar','1|goffrera'),
('goffrerbar','1|goffrera'),
('goffrerbarhet','1|goffrerbar'),
('goffrerbarhet','1|goffrerbar'),
('goffrering','1|goffrera'),
('goffrering','1|goffrera'),
('goggles','1|glasögon'),
('go-go-flicka','1|dansa'),
('goja','1|struntprat'),
('goja','2|geggamoja'),
('goja','3|papegoja'),
('gola','1|tjalla'),
('gold-digger','1|kvinna'),
('golf','1|sport'),
('golf','2|bukt'),
('golfa','1|golf'),
('golfande','1|golfa'),
('golfare','1|golf'),
('golfbana','1|bana'),
('golfboll','1|boll'),
('golfbyxor','1|knäbyxor'),
('golfklubb','1|klubb'),
('golfklubba','1|klubba'),
('golfmässig','1|golf'),
('golfresa','1|semesterresa'),
('golfrunda','1|runda'),
('golfskjorta','1|skjorta'),
('golfspel','1|golf'),
('golfspelare','1|golf'),
('golfstjärna','1|stjärna'),
('golfturnering','1|turnering'),
('Golgata','1|korsfästelse'),
('golgatavandring','1|lidande'),
('Golgatavandring','1|vandring'),
('golgiapparaten','1|cellplasma'),
('goltupp','1|gola'),
('golv','1|rum'),
('golva','1|slå'),
('golvande','1|golva'),
('golvbeläggning','1|beläggning'),
('golvbjälke','1|bjälke'),
('golvbrunn','1|avlopp'),
('golvbrunnssil','1|sil'),
('golvbräda','1|bräda'),
('golvdrag','1|drag'),
('golvfast','1|fast'),
('golvfärg','1|färg'),
('golvkall','1|golvdrag'),
('golvklocka','1|golvur'),
('golvkonstruktion','1|konstruktion'),
('golvlack','1|lack'),
('golvlampa','1|lampa'),
('golvlist','1|list'),
('golvläggare','1|golvbeläggning'),
('golvläggning','1|golvläggare'),
('golvmatta','1|matta'),
('golvmopp','1|mopp'),
('golvramp','1|belysning'),
('golvregel','1|regel'),
('golvsil','1|golvbrunnssil'),
('golvskyddspapper','1|skyddspapper'),
('golvspackel','1|spackel'),
('golvspringa','1|springa'),
('golvtilja','1|tilja'),
('golvtrasa','1|skurtrasa'),
('golvur','1|ur'),
('golvvax','1|vax'),
('golvvårdare','1|lokalvårdare'),
('golvvärme','1|uppvärmning'),
('golvväxel','1|växel'),
('golvyta','1|yta'),
('gom','1|mun'),
('gomben','1|ben'),
('gombåge','1|veck'),
('gomklyvning','1|gomspalt'),
('gomljud','1|språkljud'),
('gomsegel','1|gom'),
('gomspalt','1|gom'),
('gomspene','1|tungspene'),
('gon','1|geodesi'),
('gonad','1|könskörtel'),
('gondol','1|båt'),
('gondol','2|korg'),
('gondol','3|försäljningsdisk'),
('gondol','4|skidlift'),
('gondolfärd','1|färd'),
('gondolförare','1|förare'),
('gondoljär','1|gondol'),
('gonfaloniär','1|ämbetsman'),
('gonggong','1|signal'),
('gonggongslag','1|slag'),
('goniometer','1|vinkelmätare'),
('gonokock','1|bakterie'),
('gonorré','1|könssjukdom'),
('goodwill','1|rykte'),
('googla','1|söka'),
('googlande','1|googla'),
('Google','1|sökmotor'),
('Google','1|sökmotor'),
('googlebar','1|googla'),
('googling','1|googla'),
('googlingsbar','1|googla'),
('googlingsbarhet','1|googlingsbar'),
('gordonsetter','1|setter'),
('gorgon','1|odjur'),
('gorgonzola','1|ädelost'),
('gorilla','1|apa'),
('gorillaunge','1|gorilla'),
('gorma','1|gräla'),
('gormande','1|gorma'),
('gorr','1|sörja'),
('gorå','1|rån'),
('gorå','1|rån'),
('gosa','1|njuta'),
('gosa','1|njuta'),
('gosande','1|gosa'),
('gosedjur','1|leksaksdjur'),
('gosig','1|behaglig'),
('gosing','1|gosig'),
('gospel','1|jazz'),
('gossamer','1|gummi'),
('gosse','1|pojke'),
('gossebarn','1|gosse'),
('gossekonung','1|kung'),
('gosskör','1|kör'),
('goter','1|folk'),
('gotik','1|stil'),
('gotiserande','1|gotik'),
('gotiserande','1|gotik'),
('gotisk','1|gotik'),
('gotisk','2|goter'),
('gotiska','1|språk'),
('Gotland','1|landskap'),
('Gotlandserfarenheter','1|erfarenhet'),
('Gotlandsfärja','1|färja'),
('gotlandsmarmor','1|marmor'),
('gotlandsruss','1|russ'),
('gotländsk','1|Gotland'),
('gotländsk','1|Gotland'),
('gotländsk','2|gotländska'),
('gotländsk','2|gotländska'),
('gotländska','1|dialekt'),
('gotländska','1|dialekt'),
('gotländska','2|gotlänning'),
('gotländskhet','1|gotländsk'),
('gotländskhet','1|gotländsk'),
('gotlänning','1|Gotland'),
('gott','1|mycket'),
('gottegris','1|tycka_om'),
('gotter','1|godsak'),
('gotterier','1|gotter'),
('gottfinnande','1|godtycke'),
('Gottfried','1|Leibniz'),
('gottgöra','1|ersätta'),
('gottgörande','1|gottgöra'),
('gottgörelse','1|gottgöra'),
('gottis','1|godis'),
('gottköpsförklaring','1|förklaring'),
('gottköpsvara','1|vara'),
('gottskriva','1|kreditera'),
('gottskrivande','1|gottskriva'),
('gouache','1|målning'),
('gouachemålning','1|måla'),
('gouachemålning','2|gouache'),
('gourmand','1|matvrak'),
('gourmand','2|gourmet'),
('gourmet','1|finsmakare'),
('gourmet','1|finsmakare'),
('gourmetsalt','1|salt'),
('goutera','1|uppskatta'),
('goutera','1|uppskatta'),
('gouterande','1|goutera'),
('gouterande','1|goutera'),
('gouterbar','1|goutera'),
('gouterbar','1|goutera'),
('gouterbarhet','1|gouterbar'),
('gouterbarhet','1|gouterbar'),
('goutering','1|goutera'),
('goutering','1|goutera'),
('GPS','1|lägesbestämning'),
('GPS','1|lägesbestämning'),
('gpsa','1|GPS'),
('gpsa','1|GPS'),
('gpsa','1|GPS'),
('gpsa','1|GPS'),
('gpsa','1|GPS'),
('gpsa','1|GPS'),
('g-punkt','1|erogen_zon'),
('g-punkt','1|erogen_zon'),
('grabb','1|pojke'),
('grabb','2|pojke'),
('grabba','1|gripa'),
('grabbande','1|grabba'),
('grabbatag','1|grepp'),
('grabbatag','1|grepp'),
('grabbig','1|grabb'),
('grabbnäve','1|handfull'),
('Gracchus','1|romare'),
('grace','1|elegans'),
('gracer','1|välvilja'),
('gracil','1|fin'),
('graciös','1|fin'),
('grad','1|mått'),
('grad','2|mycken'),
('grad','3|rang'),
('grad','4|linje'),
('grad','5|vinkelrät'),
('grad','6|gradmejsel'),
('grad','7|vinkelmått'),
('grad','8|boktrycksstil'),
('grad','9|potens'),
('grada','1|grad'),
('gradande','1|grada'),
('gradation','1|gradera'),
('gradbeteckning','1|tecken'),
('gradböjning','1|komparation'),
('gradera','1|grad'),
('graderande','1|gradera'),
('graderbar','1|gradera'),
('graderbarhet','1|graderbar'),
('gradering','1|gradera'),
('graderverk','1|kyla_av'),
('gradhet','1|grad'),
('gradient','1|mått'),
('gradlist','1|list'),
('gradmejsel','1|mejsel'),
('gradmätare','1|gradmätning'),
('gradmätning','1|mäta'),
('gradnät','1|rutnät'),
('gradskala','1|skala'),
('gradskala','2|skala'),
('gradskala','3|skala'),
('gradskala','4|skala'),
('gradskala','5|skala'),
('gradskillnad','1|skillnad'),
('gradskiva','1|mäta'),
('gradstreck','1|streck'),
('gradsåg','1|såg'),
('gradtal','1|grad'),
('gradtapp','1|fog'),
('gradtecken','1|gradbeteckning'),
('gradualavhandling','1|doktorsavhandling'),
('gradualpsalm','1|psalm'),
('graduell','1|gradvis'),
('graduell','1|gradvis'),
('graduera','1|examen'),
('graduerande','1|graduera'),
('graduerbar','1|graduera'),
('graduerbarhet','1|graduerbar'),
('graduering','1|graduera'),
('gradvis','1|grad'),
('gradvis','2|gradvis'),
('gradäng','1|avsats'),
('graf','1|diagram'),
('graf','2|skrivtecken'),
('grafem','1|skrivtecken'),
('grafematisk','1|grafem'),
('grafen','1|kol'),
('graffiti','1|klotter'),
('grafik','1|konst'),
('grafik','2|bild'),
('grafik','3|diagram'),
('grafiker','1|grafik'),
('grafisk','1|grafik'),
('grafisk','2|graf'),
('grafisk','3|graf'),
('grafit','1|kol'),
('grafitdegel','1|smältdegel'),
('grafitera','1|grafit'),
('grafiterande','1|grafitera'),
('grafiterbar','1|grafitera'),
('grafiterbarhet','1|grafiterbar'),
('grafitering','1|grafitera'),
('grafitgrå','1|grå'),
('grafolog','1|grafologi'),
('grafologi','1|handstil'),
('grafonomi','1|vetenskap'),
('grafonomisk','1|skrivtecken'),
('grafteori','1|teori'),
('grahamsbröd','1|bröd'),
('grahamsmjöl','1|vetemjöl'),
('grain','1|ytstruktur'),
('grain','1|ytstruktur'),
('gral','1|kalk'),
('gral','1|kalk'),
('gralsökare','1|söka'),
('gram','1|mått'),
('gramaner','1|band'),
('gramkalori','1|kalori'),
('grammatik','1|språk'),
('grammatik','2|grammatikbok'),
('grammatik','2|grammatikbok'),
('grammatikalisk','1|riktig'),
('grammatikbok','1|lärobok'),
('grammatiker','1|grammatik'),
('grammatikregel','1|regel'),
('grammatisk','1|grammatik'),
('grammatisk','2|grammatikalisk'),
('grammofon','1|spela'),
('grammofonarkiv','1|arkiv'),
('grammofonskiva','1|grammofon'),
('grammofonstift','1|stift'),
('grammolekyl','1|molekylvikt'),
('gramse','1|arg'),
('gran','1|barrträd'),
('gran','2|vikt'),
('gran','2|vikt'),
('granat','1|spränga'),
('granat','2|ädelsten'),
('granat','3|fruktträd'),
('granatattack','1|attack'),
('granatbeskjuta','1|beskjuta'),
('granatbeskjutande','1|granatbeskjuta'),
('granatbeskjutning','1|granatbeskjuta'),
('granatchock','1|chock'),
('granateld','1|eld'),
('granatgevär','1|gevär'),
('granatkartesch','1|kartesch'),
('granatkastare','1|vapen'),
('granatskärva','1|skärva'),
('granatsplitter','1|splitter'),
('granatspruta','1|vapen'),
('granatträff','1|träff'),
('granatäppelkärna','1|kärna'),
('granatäpple','1|frukt'),
('granatäpplejuice','1|juice'),
('granbark','1|bark'),
('granbarr','1|barr'),
('granbarrlus','1|bladlus'),
('grand','1|adelsman'),
('Grand','1|hotell'),
('grandezza','1|värdighet'),
('grand-guignol','1|teater'),
('grandios','1|storslagen'),
('grandioshet','1|grandios'),
('grandseigneur','1|adelsman'),
('grandunge','1|dunge'),
('grangirlang','1|girland'),
('grangren','1|gren'),
('granhäck','1|häck'),
('granimitation','1|imitation'),
('granit','1|bergart'),
('granitkeramik','1|klinker'),
('granitkeramikskärare','1|verktyg'),
('grann','1|fin'),
('grann','2|fin'),
('grann','3|liten'),
('grann','3|liten'),
('grannbygd','1|bygd'),
('granne','1|nära'),
('grannelag','1|grannskap'),
('granneligen','1|noga'),
('grannfastighet','1|fastighet'),
('grannfejd','1|fejd'),
('grannhet','1|grann'),
('grannhet','2|grann'),
('grannhus','1|hus'),
('grannkung','1|kung'),
('grannlaga','1|delikat'),
('grannlagenhet','1|grannlaga'),
('grannland','1|land'),
('grannlåt','1|prålig'),
('grannosämja','1|osämja'),
('grannpojke','1|pojke'),
('grannrike','1|grannland'),
('grannräcke','1|räcke'),
('grannskap','1|omgivning'),
('grannsocken','1|socken'),
('grannstat','1|stat'),
('grannstjärna','1|stjärna'),
('grannstuga','1|stuga'),
('grannsynt','1|noggrann'),
('grannsynthet','1|grannsynt'),
('grannsämja','1|sämja'),
('granntvist','1|tvist'),
('granntyckt','1|kräsen'),
('granntyckthet','1|granntyckt'),
('granplanta','1|planta'),
('granpollen','1|pollen'),
('granris','1|ris'),
('granska','1|undersöka'),
('granskande','1|granska'),
('granskare','1|granska'),
('granskning','1|granska'),
('granskningsexemplar','1|exemplar'),
('granskningskommission','1|kommission'),
('granskningsman','1|revisor'),
('granskningsnämnd','1|nämnd'),
('granskog','1|skog'),
('gransort','1|sort'),
('granspira','1|gran'),
('granspira','2|lejongap'),
('granstam','1|trädstam'),
('gransångare','1|lövsångare'),
('granulat','1|korn'),
('granulation','1|granulom'),
('granulationsvävnad','1|granulom'),
('granulera','1|granulering'),
('granulera','2|granulom'),
('granulerande','1|granulera'),
('granulerande','2|granulera'),
('granulerbar','1|granulera'),
('granulerbar','2|granulera'),
('granulerbarhet','1|granulerbar'),
('granulerbarhet','2|granulerbar'),
('granulering','1|hantverk'),
('granulom','1|vävnad'),
('granulum','1|korn'),
('granved','1|ved'),
('grapefrukt','1|citrusfrukt'),
('grapefruktjuice','1|juice'),
('grassera','1|förekomma'),
('grasserande','1|grassera'),
('grassering','1|grassera'),
('gratial','1|pension'),
('gratialist','1|gratial'),
('gratie','1|gudinna'),
('gratier','1|gratie'),
('gratifikation','1|belöning'),
('gratinera','1|gratäng'),
('gratinerande','1|gratinera'),
('gratinerbar','1|gratinera'),
('gratinerbarhet','1|gratinerbar'),
('gratinering','1|gratinera'),
('gratis','1|kosta'),
('gratis','2|gratis'),
('gratisaktie','1|aktie'),
('gratisnöje','1|nöje'),
('gratispassagerare','1|passagerare'),
('gratisplats','1|delta'),
('gratisprogram','1|program'),
('gratisskjut','1|skjut'),
('gratisskjuts','1|skjuts'),
('gratisspel','1|spel'),
('gratistidning','1|tidning'),
('gratta','1|gratulera'),
('grattande','1|gratta'),
('grattis','1|gratulera'),
('gratulant','1|gratulera'),
('gratulation','1|gratulera'),
('gratulationsbrev','1|brev'),
('gratulationskort','1|kort'),
('gratulera','1|lyckönska'),
('gratulerande','1|gratulera'),
('gratulerbar','1|gratulera'),
('gratulerbarhet','1|gratulerbar'),
('gratulering','1|gratulera'),
('gratäng','1|maträtt'),
('gratäng','1|maträtt'),
('grauballemannen','1|mosslik'),
('grav','1|död'),
('grav','2|allvarlig'),
('grav','3|accent'),
('grava','1|tillaga'),
('gravallvar','1|gravallvarlig'),
('gravallvarlig','1|allvarlig'),
('gravallvarlighet','1|gravallvarlig'),
('gravamen','1|omständighet'),
('gravand','1|and'),
('gravande','1|grava'),
('gravation','1|inteckning'),
('gravationsbevis','1|gravation'),
('gravbrev','1|dokument'),
('gravbyggnad','1|byggnad'),
('gravdikt','1|begravningspoesi'),
('grave','1|allvarlig'),
('gravenstein','1|äpple'),
('gravenstein','1|äpple'),
('gravera','1|konst'),
('gravera','2|inteckna'),
('graverande','1|besvärande'),
('graverande','2|gravera'),
('graverande','3|gravera'),
('graverbar','1|gravera'),
('graverbar','2|gravera'),
('graverbarhet','1|graverbar'),
('graverbarhet','2|graverbar'),
('gravering','1|gravera'),
('graverstål','1|gravera'),
('gravfynd','1|fynd'),
('gravfält','1|fält'),
('gravgods','1|föremål'),
('gravgås','1|gravand'),
('gravgåva','1|gåva'),
('gravhet','1|grav'),
('gravhet','2|grav'),
('gravhäll','1|häll'),
('gravhög','1|hög'),
('gravid','1|föda'),
('graviditet','1|gravid'),
('graviditetsdagbok','1|dagbok'),
('graviditetskilon','1|viktökning'),
('graviditetstest','1|test'),
('graviditetsvecka','1|vecka'),
('gravidmage','1|mage'),
('gravimeter','1|mäta'),
('gravis','1|grav'),
('gravitation','1|tyngdkraft'),
('gravitationell','1|gravitation'),
('gravitationskollaps','1|kollaps'),
('gravitationskonstant','1|konstant'),
('gravitationskraft','1|tyngdkraft'),
('gravitationslag','1|lag'),
('gravitationslagen','1|tyngdlagen'),
('gravitationsstrålning','1|strålning'),
('gravitationsvåg','1|våg'),
('gravitera','1|gravitation'),
('graviterande','1|gravitera'),
('gravitering','1|gravitera'),
('gravitet','1|gravitetisk'),
('gravitetisk','1|värdig'),
('graviton','1|partikel'),
('gravkammare','1|kammare'),
('gravkapell','1|kapell'),
('gravkista','1|kista'),
('gravkor','1|kor'),
('gravkummel','1|gravröse'),
('gravkyrka','1|kyrka'),
('gravlax','1|lax'),
('gravlik','1|grav'),
('gravlikhet','1|gravlik'),
('gravlägga','1|begrava'),
('gravläggande','1|gravlägga'),
('gravmaterial','1|material'),
('gravmonument','1|monument'),
('gravor','1|sorgslöja'),
('gravplats','1|plats'),
('gravplundrare','1|plundra'),
('gravplundring','1|plundring'),
('gravrelief','1|relief'),
('gravrost','1|rost'),
('gravröse','1|röse'),
('gravröse','1|röse'),
('gravsed','1|sed'),
('gravskick','1|skick'),
('gravskändning','1|skändning'),
('gravsten','1|minnessten'),
('gravstickel','1|verktyg'),
('gravsvepning','1|liksvepning'),
('gravsänka','1|dalgång'),
('gravsätta','1|begrava'),
('gravsättande','1|gravsätta'),
('gravsättning','1|gravsätta'),
('gravtal','1|tal'),
('gravtest','1|graviditetstest'),
('gravurna','1|urna'),
('gravvalv','1|gravplats'),
('gravvård','1|gravsten'),
('gravyr','1|gravera'),
('gravyrkonst','1|gravera'),
('gravyrmaskin','1|maskin'),
('gravöl','1|fest'),
('gravöppning','1|öppning'),
('gravör','1|gravera'),
('gray','1|mått'),
('gray','1|mått'),
('Grebbestad','1|ort'),
('grecism','1|grekiska'),
('gredelin','1|violett'),
('green','1|gräsmatta'),
('Greenwichmeridianen','1|längdgrad'),
('gregoriansk','1|tideräkning'),
('Gregorius','1|påve'),
('grej','1|sak'),
('grej','1|sak'),
('greja','1|ordna'),
('greja','2|syssla'),
('grejande','1|greja'),
('grejande','2|greja'),
('grejs','1|grej'),
('grejsimojs','1|grejs'),
('grek','1|Grekland'),
('grekcypriot','1|cypriot'),
('grekcypriotisk','1|cypriotisk'),
('grekinna','1|grekiska'),
('grekisk','1|Grekland'),
('grekiska','1|språk'),
('grekiska','2|grek'),
('grekisk-katolsk','1|religion'),
('grekisk-ortodox','1|religion'),
('grekisk-romersk','1|brottning'),
('grekisktalande','1|tala'),
('Grekland','1|land'),
('gren','1|träd'),
('gren','2|avdelning'),
('gren','3|skrev'),
('grenad','1|förgrenad'),
('Grenada','1|ö'),
('grenadier','1|Grenada'),
('grenadin','1|saft'),
('grenadin','2|sidentyg'),
('grenadisk','1|Grenada'),
('grenadiska','1|grenadier'),
('grenadjär','1|elitsoldat'),
('grenadjärregemente','1|regemente'),
('grenbildning','1|gren'),
('grenhopp','1|gymnastikhopp'),
('grenig','1|gren'),
('grenighet','1|grenig'),
('grenklyka','1|gren'),
('grenledning','1|ledning'),
('grenljus','1|ljus'),
('grenrik','1|gren'),
('grenskott','1|skott'),
('grensla','1|grensle'),
('grensla','1|grensle'),
('grenslande','1|grensla'),
('grenslande','1|grensla'),
('grensle','1|ben'),
('grensle','1|ben'),
('grenspets','1|spets'),
('grenstående','1|stå'),
('grenuttag','1|eluttag'),
('grenveck','1|gren'),
('grenverk','1|gren'),
('grenvinkel','1|grenveck'),
('grep','1|jordbruksredskap'),
('grepe','1|handtag'),
('grepp','1|gripa'),
('grepp','2|sätt'),
('greppa','1|grepp'),
('greppa','2|förstå'),
('greppande','1|greppa'),
('greppande','2|greppa'),
('greppbar','1|greppa'),
('greppbar','2|greppa'),
('greppbarhet','1|greppbar'),
('greppbarhet','2|greppbar'),
('greppbräde','1|stränginstrument'),
('Greppet','1|film'),
('greppmatta','1|matta'),
('greppriktig','1|passa'),
('greppriktighet','1|greppriktig'),
('greppvänlig','1|lämplig'),
('greppvänlighet','1|greppvänlig'),
('greppyta','1|yta'),
('grevar','1|ister'),
('greve','1|adelsman'),
('grevekrona','1|krona'),
('grevetitel','1|titel'),
('grevinna','1|greve'),
('grevlig','1|greve'),
('grevlighet','1|grevlig'),
('grevskap','1|län'),
('grevyzebra','1|zebra'),
('grevyzebra','1|zebra'),
('greyhound','1|vinthund'),
('Gribojedovkanalen','1|kanal'),
('griffel','1|griffeltavla'),
('griffeltavla','1|tavla'),
('grift','1|grav'),
('griftefrid','1|frid'),
('griftetal','1|tal'),
('griljera','1|steka'),
('griljerande','1|griljera'),
('griljerbar','1|griljera'),
('griljerbarhet','1|griljerbar'),
('griljering','1|griljera'),
('grill','1|grilla'),
('grilla','1|steka'),
('grilla','2|förhöra'),
('grillande','1|grilla'),
('grillande','2|grilla'),
('grillbar','1|bar'),
('griller','1|idé'),
('griller','2|skridsko'),
('grillfängeri','1|griller'),
('grilljanne','1|snobb'),
('grillkol','1|kol'),
('grillning','1|grilla'),
('grillning','2|grilla'),
('grillor','1|griller'),
('grillspett','1|stekspett'),
('grillspett','2|maträtt'),
('grimas','1|min'),
('grimasera','1|grimas'),
('grimaserande','1|grimasera'),
('grimasering','1|grimasera'),
('grimera','1|sminka'),
('grimerande','1|grimera'),
('grimerbar','1|grimera'),
('grimerbarhet','1|grimerbar'),
('grimering','1|grimera'),
('grimma','1|hålla'),
('grimskaft','1|grimma'),
('grin','1|grina'),
('grina','1|grimas'),
('grina','2|gråta'),
('grinande','1|grina'),
('grinande','2|grina'),
('grinare','1|grina'),
('grinare','2|grina'),
('grind','1|dörr'),
('grind','2|tecken'),
('grind','3|dörr'),
('grindbeslag','1|beslag'),
('grindslant','1|betala'),
('grindstuga','1|grindöppning'),
('grindval','1|val'),
('grindöppning','1|öppna'),
('grindöppning','2|öppning'),
('gringo','1|utlänning'),
('grinig','1|grina'),
('grinighet','1|grinig'),
('grinolle','1|grina'),
('grip','1|fantasidjur'),
('gripa','1|ta'),
('gripa','2|fängsla'),
('gripande','1|gripen'),
('gripande','2|gripa'),
('gripande','3|gripa'),
('gripbar','1|gripa'),
('gripbarhet','1|gripbar'),
('gripen','1|rörd'),
('gripenhet','1|gripen'),
('Gripenplan','1|JAS_Gripen'),
('gripfot','1|fot'),
('gripreflex','1|reflex'),
('gris','1|husdjur'),
('gris','2|grisig'),
('grisa','1|föda'),
('grisaille','1|målning'),
('grisande','1|grisa'),
('grisbonde','1|bonde'),
('griseri','1|grisa_ned'),
('grisett','1|prostituerad'),
('grisfest','1|fest'),
('grisfösare','1|fösa'),
('grishandlare','1|handla'),
('grisig','1|grisa_ned'),
('grisinsulin','1|insulin'),
('griskastrering','1|kastrering'),
('griskulting','1|spädgris'),
('griskött','1|kött'),
('grismat','1|mat'),
('grisning','1|grisa'),
('grisningsbo','1|bo'),
('grisplågeri','1|djurplågeri'),
('grissel','1|brödspade'),
('grisskandal','1|skandal'),
('grisskär','1|skär'),
('grissla','1|fågel'),
('grissvans','1|svans'),
('grisunge','1|spädgris'),
('grisuppfödning','1|uppfödning'),
('grisöga','1|öga'),
('grizzlybjörn','1|björn'),
('gro','1|växa'),
('grobar','1|grobarhet'),
('grobarhet','1|förmåga'),
('grobian','1|otrevlig'),
('grobianfasoner','1|grobian'),
('groblad','1|växt'),
('groda','1|djur'),
('groda','2|dumhet'),
('grodd','1|frö'),
('grodda','1|grodd'),
('groddande','1|grodda'),
('groddblad','1|embryo'),
('groddjur','1|groda'),
('groddknopp','1|skott'),
('groddplanta','1|planta'),
('grodfisk','1|fisk'),
('grodlår','1|maträtt'),
('grodman','1|dykare'),
('grodnate','1|nate'),
('grodperspektiv','1|perspektiv'),
('grodsim','1|simma'),
('grodspott','1|ormspott'),
('grodyngel','1|yngel'),
('grodägg','1|ägg'),
('groende','1|gro'),
('grogg','1|dryck'),
('grogga','1|grogg'),
('groggande','1|grogga'),
('groggvirke','1|grogg'),
('groggy','1|yr'),
('grogrund','1|plats'),
('groll','1|ovänskap'),
('gromning','1|grooming'),
('groning','1|gro'),
('groningstid','1|tid'),
('grooming','1|pedofili'),
('grooming','2|skönhetsvård'),
('grop','1|håla'),
('gropemalj','1|emaljinläggning'),
('gropig','1|grop'),
('gropig','2|hav'),
('gropighet','1|gropig'),
('gropighet','2|gropig'),
('groplöja','1|löja'),
('groschen','1|myntenhet'),
('gross','1|dussin'),
('grossess','1|graviditet'),
('grosshandel','1|handel'),
('grosshandelsfirma','1|firma'),
('grosshandlare','1|grosshandel'),
('grossist','1|grosshandel'),
('grossistpris','1|pris'),
('grossör','1|grosshandlare'),
('grotesk','1|ful'),
('grotesk','2|teaterpjäs'),
('grotesk','3|ornament'),
('grotesk','4|tryck'),
('groteskeri','1|grotesk'),
('grotta','1|håla'),
('grottbjörn','1|björn'),
('grottekvarn','1|trälarbete'),
('grottforskare','1|forskare'),
('grottforskning','1|utforskning'),
('grottgång','1|gång'),
('grottingång','1|ingång'),
('grottinvånare','1|grotta'),
('grottinvånare','1|grotta'),
('grottmynning','1|grottingång'),
('grottmålning','1|målning'),
('grottmänniska','1|människa'),
('grottskreva','1|skreva'),
('Groucho','1|Marx'),
('groupie','1|beundrarinna'),
('grov','1|fin'),
('grov','2|tjock'),
('grov','3|allvarlig'),
('grov','4|oanständig'),
('grovarbetare','1|grovarbete'),
('grovarbete','1|arbete'),
('grovbruk','1|bruk'),
('grovfoder','1|foder'),
('grovgöra','1|grovarbete'),
('grovhacka','1|hacka'),
('grovhackande','1|grovhacka'),
('grovhackning','1|grovhacka'),
('grovhet','1|grov'),
('grovhugga','1|hugga'),
('grovhuggande','1|grovhugga'),
('grovhuggen','1|grov'),
('grovhuggenhet','1|grovhuggen'),
('grovhuggning','1|grovhugga'),
('grovhyad','1|hy'),
('grovhyvla','1|hyvla'),
('grovhyvlad','1|grovhyvla'),
('grovhyvlande','1|grovhyvla'),
('grovhyvling','1|grovhyvla'),
('grovhångla','1|hångla'),
('grovhånglande','1|grovhångla'),
('grovhångling','1|grovhångla'),
('grovkalibrig','1|kaliber'),
('grovkalibrighet','1|grovkalibrig'),
('grovkornig','1|grov'),
('grovkornig','2|oanständig'),
('grovkornighet','1|grovkornig'),
('grovkornighet','2|grovkornig'),
('grovkök','1|tvättstuga'),
('grovlagd','1|grov'),
('grovlek','1|mått'),
('grovlemmad','1|lem'),
('grovmala','1|mala'),
('grovmalande','1|grovmala'),
('grovmalning','1|grovmala'),
('grovna','1|grov'),
('grovnande','1|grovna'),
('grovplanera','1|planera'),
('grovplanerande','1|grovplanera'),
('grovplanerbar','1|grovplanera'),
('grovplanerbarhet','1|grovplanerbar'),
('grovplanering','1|grovplanera'),
('grovriven','1|riva'),
('grovsalt','1|salt'),
('grovsikt','1|sikt'),
('grovsikta','1|sikta'),
('grovsiktande','1|grovsikta'),
('grovsiktning','1|grovsikta'),
('grovsmed','1|smed'),
('grovsmide','1|smide'),
('grovsortera','1|sortera'),
('grovsorterande','1|grovsortera'),
('grovsorterbar','1|grovsortera'),
('grovsorterbarhet','1|grovsorterbar'),
('grovsortering','1|grovsortera'),
('grovspackel','1|spackel'),
('grovsyssla','1|grovarbete'),
('grovtarm','1|tjocktarm'),
('grovtrådig','1|tråd'),
('grovyxad','1|yxa_till'),
('grubba','1|grop'),
('grubbel','1|grubbla'),
('grubbla','1|tänka'),
('grubblande','1|grubbla'),
('grubblare','1|grubbla'),
('grubbleri','1|grubbla'),
('gruff','1|bråk'),
('gruffa','1|gruff'),
('gruffande','1|gruffa'),
('grumla','1|grumlig'),
('grumlande','1|grumla'),
('grumlig','1|oklar'),
('grumlighet','1|grumlig'),
('grumling','1|grumla'),
('grummel','1|grums'),
('grums','1|fällning'),
('grumsa','1|gnälla'),
('grumsande','1|grumsa'),
('grumsig','1|grums'),
('grumsighet','1|grumsig'),
('grund','1|under'),
('grund','2|djup'),
('grund','3|grund'),
('grunda','1|skapa'),
('grunda','2|basera'),
('grunda','3|grundmåla'),
('grunda','4|drink'),
('grundackord','1|ackord'),
('grundad','1|viss'),
('grundande','1|grunda'),
('grundande','2|grunda'),
('grundande','3|grunda'),
('grundande','4|grunda'),
('grundantagande','1|antagande'),
('grundarduo','1|duo'),
('grundare','1|grunda'),
('grundavdrag','1|avdrag'),
('grundavgift','1|avgift'),
('grundbegrepp','1|begrepp'),
('grundbehandla','1|behandla'),
('grundbehandlande','1|grundbehandla'),
('grundbelopp','1|belopp'),
('grundbeståndsdel','1|beståndsdel'),
('grundbetydelse','1|betydelse'),
('grundbok','1|bok'),
('grundbrott','1|brott'),
('grundbult','1|grundval'),
('grunddrag','1|huvuddrag'),
('grundegenskap','1|egenskap'),
('grundelement','1|grundämne'),
('grundelement','2|element'),
('grundelement','3|element'),
('grundenhet','1|enhet'),
('grundera','1|grunda'),
('grunderande','1|grundera'),
('grunderbar','1|grundera'),
('grunderbarhet','1|grunderbar'),
('grundering','1|grundera'),
('grundfalsk','1|falsk'),
('grundfel','1|fel'),
('grundflås','1|flås'),
('grundfond','1|grundkapital'),
('grundform','1|ordform'),
('grundforskning','1|forskning'),
('grundfärg','1|färg'),
('grundfärg','2|färg'),
('grundförbättring','1|jordförbättring'),
('grundförsörjning','1|försörjning'),
('grundgrävning','1|gräva'),
('grundgående','1|grund'),
('grundhav','1|hav'),
('grundhet','1|grund'),
('grundhyra','1|hyra'),
('grundidé','1|idé'),
('grundkapital','1|kapital'),
('grundkaraktär','1|karaktär'),
('grundkraft','1|elementärkraft'),
('grundkunskap','1|kunskap'),
('grundkurs','1|kurs'),
('grundkänning','1|grundstötning'),
('grundlag','1|lag'),
('grundlag','2|grundval'),
('grundlagsbestämmelse','1|bestämmelse'),
('grundlagsbrott','1|brott'),
('grundlagsenlig','1|grundlag'),
('grundlagsenlighet','1|grundlagsenlig'),
('grundlagsfäst','1|grundlag'),
('grundlagsmässig','1|grundlag'),
('grundlagsrevision','1|revision'),
('grundlagsskyddad','1|skydda'),
('grundlagsstridig','1|grundlag'),
('grundlagsstridighet','1|grundlagsstridig'),
('grundlagstolkning','1|tolkning'),
('grundlagsvidrig','1|grundlag'),
('grundlagsvidrighet','1|grundlagsvidrig'),
('grundlagsändring','1|ändra'),
('grundlig','1|noggrann'),
('grundligen','1|grundlig'),
('grundlighet','1|grundlig'),
('grundlinje','1|grunddrag'),
('grundlura','1|lura'),
('grundlurande','1|grundlura'),
('grundlägga','1|grund'),
('grundläggande','1|grund'),
('grundläggande','2|grundlägga'),
('grundläggare','1|grundare'),
('grundläggning','1|grundlägga'),
('grundlärd','1|lärd'),
('grundlön','1|lön'),
('grundlös','1|grund'),
('grundlöshet','1|grundlös'),
('grundmur','1|mur'),
('grundmurad','1|fast'),
('grundmurning','1|mura'),
('grundmåla','1|måla'),
('grundmålande','1|grundmåla'),
('grundmålning','1|grundmåla'),
('grundmått','1|mått'),
('grundning','1|grunda'),
('grundord','1|ord'),
('grundorsak','1|orsak'),
('grundpelare','1|grund'),
('grundperiod','1|period'),
('grundplan','1|plan'),
('grundplåt','1|pengar'),
('grundregel','1|regel'),
('grundritning','1|ritning'),
('grundsanning','1|sanning'),
('grundsats','1|princip'),
('grundskatt','1|skatt'),
('grundskola','1|skola'),
('grundskolebarn','1|barn'),
('grundskolelärare','1|lärare'),
('grundskott','1|skott'),
('grundspråk','1|originalspråk'),
('grundstam','1|ympning'),
('grundsten','1|grundval'),
('grundstomme','1|stomme'),
('grundstreck','1|typografi'),
('grundstryka','1|grundmåla'),
('grundstrykande','1|grundstryka'),
('grundstrykning','1|grundstryka'),
('grundställning','1|ställning'),
('grundstämma','1|stämma'),
('grundstämning','1|stämning'),
('grundstöta','1|stöta'),
('grundstötande','1|grundstöta'),
('grundstötning','1|grundstöta'),
('grundstött','1|grundstöta'),
('grundsyn','1|åsikt'),
('grundsärskola','1|särskola'),
('grundtal','1|räkneord'),
('grundtanke','1|tanke'),
('grundteori','1|teori'),
('grundtes','1|tes'),
('grundtext','1|text'),
('grundtillstånd','1|tillstånd'),
('grundton','1|ton'),
('grundtvigianism','1|Grundtvig'),
('grundutbildning','1|utbildning'),
('grundval','1|grund'),
('grundvatten','1|vatten'),
('grundvillkor','1|villkor'),
('grundvillkor','2|villkor'),
('grundyta','1|yta'),
('grundyta','2|yta'),
('grundåskådning','1|åskådning'),
('grundämne','1|ämne'),
('grunge','1|musik'),
('grunka','1|pryl'),
('grunna','1|fundera'),
('grunna','1|fundera'),
('grunnande','1|grunna'),
('grunnande','1|grunna'),
('grupp','1|samman'),
('Grupp-8','1|kvinnorörelse'),
('grupparbete','1|arbete'),
('gruppbild','1|fotografi'),
('gruppboende','1|bostad'),
('gruppchef','1|chef'),
('gruppdynamik','1|samspel'),
('gruppdynamisk','1|gruppdynamik'),
('gruppera','1|grupp'),
('grupperande','1|gruppera'),
('grupperbar','1|gruppera'),
('grupperbarhet','1|grupperbar'),
('gruppering','1|gruppera'),
('gruppering','2|grupp'),
('gruppförsäkring','1|försäkring'),
('gruppgenitiv','1|genitiv'),
('grupphus','1|hus'),
('gruppidentitet','1|identitet'),
('gruppkorsband','1|korsband'),
('gruppledare','1|ledare'),
('gruppresa','1|resa'),
('gruppsamtal','1|samtal'),
('gruppsamtal','2|telefonsamtal'),
('gruppsex','1|sex'),
('gruppsmörjning','1|smörjning'),
('gruppsykologi','1|gruppdynamik'),
('gruppså','1|så'),
('gruppsående','1|gruppså'),
('grupptalan','1|stämma'),
('gruppterapi','1|psykoterapi'),
('grupptest','1|test'),
('grupptillhörighet','1|tillhörighet'),
('grupptryck','1|påverkan'),
('gruppvis','1|grupp'),
('gruppvis','2|gruppvis'),
('grus','1|sten'),
('grusa','1|grus'),
('grusa','2|omintetgöra'),
('grusande','1|grusa'),
('grusande','2|grusa'),
('grusgrop','1|grustag'),
('grusgång','1|gång'),
('grusig','1|grus'),
('grusplan','1|plan'),
('grustag','1|ta'),
('grustäkt','1|grustag'),
('grusväg','1|väg'),
('grusås','1|ås'),
('gruva','1|bryta'),
('gruvarbetardotter','1|dotter'),
('gruvarbetare','1|arbetare'),
('gruvarbetarstövel','1|stövel'),
('gruvbolag','1|bolag'),
('gruvbrytning','1|bryta'),
('gruvdrama','1|drama'),
('gruvdrift','1|gruva'),
('gruvexplosion','1|explosion'),
('gruvfogde','1|bas'),
('gruvfält','1|område'),
('gruvgas','1|metan'),
('gruvgång','1|gång'),
('gruvhund','1|vagn'),
('gruvhål','1|hål'),
('gruvkompass','1|kompass'),
('gruvlave','1|byggnad'),
('gruvlig','1|fasansfull'),
('gruvligen','1|gruvlig'),
('gruvlighet','1|gruvlig'),
('gruvoffer','1|offer'),
('gruvolycka','1|olycka'),
('gruvras','1|ras'),
('gruvrå','1|väsen'),
('gruvsam','1|oroande'),
('gruvsamhet','1|gruvsam'),
('gruvschakt','1|gruvgång'),
('gruvstigare','1|gruvfogde'),
('gruvstrejk','1|strejk'),
('gruvstötta','1|stötta'),
('gruvöppning','1|öppning'),
('gruyere','1|ost'),
('gry','1|ljusna'),
('gry','2|anlag'),
('gry','3|bergart'),
('gryende','1|gry'),
('grym','1|hård'),
('grym','2|bra'),
('grymhet','1|grym'),
('grymhet','2|grym'),
('grymt','1|grymta'),
('grymt','2|mycket'),
('grymta','1|läte'),
('grymtande','1|grymta'),
('grymthastighet','1|hastighet'),
('grymtning','1|grymta'),
('grymtoxe','1|jak'),
('gryn','1|korn'),
('gryna','1|gryn'),
('grynande','1|gryna'),
('gryne','1|gräs'),
('grynig','1|gryn'),
('grynighet','1|grynig'),
('gryning','1|ljusna'),
('gryningsgroggy','1|groggy'),
('gryningsljus','1|gryning'),
('gryningsstrimma','1|ljusstrimma'),
('gryningstid','1|gryning'),
('gryningstimme','1|timme'),
('grynkorv','1|korv'),
('grynna','1|grund'),
('grynpipig','1|ost'),
('grynvälling','1|välling'),
('gryt','1|bo'),
('gryt','2|mark'),
('gryta','1|kärl'),
('gryta','2|maträtt'),
('grytbitar','1|kött'),
('grytfot','1|ställning'),
('grytfot','2|fot'),
('grythund','1|jakthund'),
('grytlapp','1|skydd'),
('grytlock','1|lock'),
('grytskåp','1|skåp'),
('grytstek','1|stek'),
('grytvante','1|grytlapp'),
('grå','1|färg'),
('grå','2|tråkig'),
('gråaktig','1|grå'),
('gråaktighet','1|gråaktig'),
('gråal','1|al'),
('gråben','1|varg'),
('gråberg','1|gråsten'),
('gråblek','1|blek'),
('gråblekhet','1|gråblek'),
('gråblå','1|blå'),
('gråbo','1|växt'),
('gråbroder','1|gråmunk'),
('gråbrun','1|brun'),
('gråbrödrakonvent','1|konvent'),
('grådask','1|grådaskig'),
('grådask','2|portvin'),
('grådaskig','1|smutsgrå'),
('grådaskighet','1|grådaskig'),
('gråfläckig','1|fläckig'),
('grågosse','1|pensionär'),
('grågrön','1|grön'),
('grågul','1|gul'),
('grågyllen','1|äpple'),
('grågås','1|gås'),
('gråhund','1|spets'),
('gråhårig','1|hår'),
('gråhårighet','1|gråhårig'),
('gråhårsman','1|åldring'),
('gråhäger','1|häger'),
('gråkall','1|kall'),
('gråkallhet','1|gråkall'),
('gråkil','1|fotografi'),
('grålax','1|lax'),
('grålla','1|grålle'),
('grålla','2|gråpäron'),
('grålle','1|husdjur'),
('Grålle','1|häst'),
('gråmes','1|talltita'),
('gråmunk','1|franciskanermunk'),
('gråmurrig','1|grå'),
('gråmurrighet','1|gråmurrig'),
('gråmålad','1|måla'),
('gråna','1|grå'),
('grånad','1|gråna'),
('grånande','1|gråna'),
('gråpapper','1|papper'),
('gråpäron','1|päron'),
('gråregnig','1|regngrå'),
('gråregnighet','1|gråregnig'),
('gråsalva','1|salva'),
('gråsej','1|fisk'),
('gråsida','1|gråsej'),
('gråsiska','1|småfågel'),
('gråskala','1|skala'),
('gråskimlig','1|gråsprängd'),
('gråskimlighet','1|gråskimlig'),
('gråskimmel','1|häst'),
('gråskäckig','1|häst'),
('gråskägg','1|gråskäggig'),
('gråskäggig','1|skägg'),
('gråsosse','1|sosse'),
('gråsossefalang','1|falang'),
('gråsparv','1|sparv'),
('gråspett','1|hackspett'),
('gråsprängd','1|hår'),
('gråsprängdhet','1|gråsprängd'),
('gråstarr','1|starr'),
('gråstarr','1|starr'),
('gråstarr','2|starr'),
('gråsten','1|bergart'),
('gråstrimmig','1|strimmig'),
('gråsugga','1|kräftdjur'),
('gråsvart','1|svart'),
('gråsäl','1|säl'),
('gråt','1|gråta'),
('gråta','1|ledsen'),
('gråtande','1|gråta'),
('gråtattack','1|attack'),
('gråterska','1|gråta'),
('gråtfärdig','1|på_vippen'),
('gråtfärdighet','1|gråtfärdig'),
('gråthickande','1|hulkande'),
('gråtlabil','1|gråta'),
('gråtmild','1|sentimental'),
('gråtmildhet','1|gråtmild'),
('gråton','1|nyans'),
('gråtonsskala','1|skala'),
('gråtparoxysm','1|paroxysm'),
('gråtrut','1|trut'),
('gråtögd','1|tårögd'),
('gråvacka','1|bergart'),
('gråval','1|val'),
('gråverk','1|vinterskinn'),
('gråvide','1|vide'),
('gråvit','1|vit'),
('gråväder','1|väder'),
('gråvädersmoln','1|moln'),
('gråzon','1|zon'),
('gråärt','1|åkerärt'),
('gråögd','1|öga'),
('gräbba','1|flicka'),
('grädda','1|baka'),
('grädda','2|bäst'),
('gräddad','1|grädda'),
('gräddande','1|grädda'),
('gräddbakelse','1|bakelse'),
('grädde','1|mjölk'),
('gräddfil','1|fil'),
('gräddfil','2|fil'),
('gräddfil','3|privilegierad'),
('gräddfärgad','1|gulvit'),
('gräddgul','1|gul'),
('gräddhalt','1|halt'),
('gräddhylla','1|bostadsområde'),
('gräddig','1|grädde'),
('gräddighet','1|gräddig'),
('gräddmätare','1|mäta'),
('gräddning','1|grädda'),
('gräddskum','1|vispgrädde'),
('gräddsnipa','1|kanna'),
('gräddsättning','1|grädde'),
('gräddtårta','1|tårta'),
('gräddvisp','1|visp'),
('gräddvisp','2|vispgrädde'),
('gräddvit','1|vit'),
('gräfta','1|jordhacka'),
('gräfta','2|gräfta'),
('gräftande','1|gräfta'),
('gräl','1|gräla'),
('gräla','1|oenig'),
('grälaktig','1|grälsjuk'),
('grälaktighet','1|grälaktig'),
('grälande','1|gräla'),
('grälig','1|grälsjuk'),
('grälighet','1|grälig'),
('gräll','1|bjärt'),
('grällhet','1|gräll'),
('grälmakare','1|gräla'),
('grälmåns','1|grälmakare'),
('grälsjuk','1|gräla'),
('grälsjuka','1|grälsjuk'),
('grälsjukhet','1|grälsjuk'),
('gräma','1|besviken'),
('grämande','1|gräma'),
('grämelse','1|gräma_sig'),
('gränd','1|gata'),
('grändhus','1|hus'),
('Gränna','1|stad'),
('gräns','1|kant'),
('gränsa','1|gräns'),
('gränsbastion','1|bastion'),
('gränsbefolkning','1|gränsbo'),
('gränsbevakning','1|bevakning'),
('gränsbo','1|gräns'),
('gränsbråk','1|bråk'),
('gränsdistrikt','1|distrikt'),
('gränsdragning','1|gräns'),
('gränsdragningsfråga','1|fråga'),
('gränsfall','1|fall'),
('gränsintäkt','1|marginalintäkt'),
('gränsjägare','1|gränspolis'),
('gränskontroll','1|kontroll'),
('gränskostnad','1|marginalkostnad'),
('gränslinje','1|linje'),
('gränslös','1|gräns'),
('gränslöshet','1|gränslös'),
('gränsmarkering','1|markering'),
('gränsmur','1|mur'),
('gränsmärke','1|märke'),
('gränsnytta','1|nytta'),
('gränsområde','1|område'),
('gränspolis','1|polis'),
('gränspolis','2|polis'),
('gränspostering','1|postering'),
('gränspåle','1|påle'),
('gränsskikt','1|skikt'),
('gränssnitt','1|datorkommunikation'),
('gränssnittsdokumentation','1|dokumentation'),
('gränsstad','1|stad'),
('gränssten','1|sten'),
('gränssättning','1|gräns'),
('gränstrakt','1|trakt'),
('gränstänjande','1|tänja'),
('gränsvakt','1|vakt'),
('gränsvåg','1|frekvensområde'),
('gränsvärde','1|värde'),
('gränsvärde','2|värde'),
('gränsöverskridande','1|överskrida'),
('gränsöverskridande','2|överskrida'),
('gräs','1|växa'),
('gräs','2|marijuana'),
('gräsa','1|träffa'),
('gräsad','1|gräsbetäckt'),
('gräsand','1|and'),
('gräsande','1|gräsa'),
('gräsbetäckt','1|gräs'),
('gräsbevuxen','1|bevuxen'),
('gräsbrand','1|brand'),
('gräsbrandseffekt','1|effekt'),
('gräsfjäril','1|fjäril'),
('gräsfly','1|fjäril'),
('gräsfläck','1|fläck'),
('gräsfläcksfobi','1|fobi'),
('gräsgrön','1|grön'),
('gräshalm','1|hö'),
('gräshoppa','1|insekt'),
('gräshoppeliknande','1|gräshoppa'),
('gräshoppssvärm','1|svärm'),
('gräsklippare','1|klippa'),
('gräsklippning','1|klippa'),
('gräsklippningsmaskin','1|gräsklippare'),
('gräslig','1|hemsk'),
('gräslighet','1|gräslig'),
('gräslik','1|gräs'),
('gräsliknande','1|gräs'),
('gräslök','1|lök'),
('gräsmask','1|larv'),
('gräsmatta','1|gräs'),
('gräsmånad','1|april'),
('gräsnejlika','1|trift'),
('gräsplan','1|gräsmatta'),
('gräsplätt','1|plätt'),
('gräsrot','1|människa'),
('gräsrot','2|rot'),
('gräsrotskampanj','1|kampanj'),
('gräsrotsnivå','1|gräsrot'),
('gräsrotsrörelse','1|rörelse'),
('grässtrå','1|strå'),
('grässträng','1|sträng'),
('grässvål','1|grästorv'),
('grästorv','1|jord'),
('grästorva','1|jord'),
('grästrimmer','1|klippa'),
('grästuva','1|knippe'),
('gräsvall','1|vall'),
('gräsväxt','1|gräs'),
('gräsväxt','2|växa'),
('gräsänka','1|änka'),
('gräsänkling','1|änkling'),
('gräsätande','1|gräsätare'),
('gräsätare','1|äta'),
('grätten','1|kräsen'),
('grättenhet','1|grätten'),
('gräva','1|jord'),
('gräva','2|undersöka'),
('grävande','1|gräva'),
('grävande','2|gräva'),
('grävare','1|gräva'),
('grävare','2|gräva'),
('grävargeneration','1|generation'),
('grävarjournalist','1|grävarjournalistik'),
('grävarjournalistik','1|journalistik'),
('grävblogg','1|blogg'),
('grävgrupp','1|grupp'),
('grävjournalistik','1|gräva'),
('grävling','1|djur'),
('grävlingsgryt','1|gryt'),
('grävlingshund','1|grythund'),
('grävlingshår','1|hår'),
('grävlingsjakt','1|jakt'),
('grävmaskin','1|maskin'),
('grävning','1|gräva'),
('grävschakt','1|schakt'),
('grävskopa','1|maskin'),
('grävsvin','1|grävling'),
('gröda','1|odla'),
('gröe','1|gräs'),
('grön','1|färg'),
('grön','2|oerfaren'),
('grön','3|miljövänlig'),
('grönaktig','1|grön'),
('grönaktighet','1|grönaktig'),
('grönalg','1|alg'),
('Grönan','1|Gröna_Lund'),
('grönavågare','1|gröna_vågen'),
('grönavågare','1|gröna_vågen'),
('grönbena','1|vadarfågel'),
('grönbete','1|bete'),
('grönblek','1|blek'),
('grönblekhet','1|grönblek'),
('grönblind','1|färgblind'),
('grönblindhet','1|grönblind'),
('grönfink','1|fink'),
('grönfoder','1|foder'),
('gröngräset','1|gräs'),
('gröngul','1|gul'),
('gröngödsla','1|gödsla'),
('gröngödslande','1|gröngödsla'),
('gröngödsling','1|gröngödsla'),
('gröngöling','1|fågel'),
('gröngöling','2|oerfaren'),
('grönhet','1|grön'),
('gröning','1|grönfink'),
('grönklädd','1|klädd'),
('grönkulla','1|orkidé'),
('grönkål','1|kål'),
('grönköping','1|småstad'),
('grönköpingsmässig','1|grönköping'),
('grönköpingsmässighet','1|grönköpingsmässig'),
('Grönland','1|ö'),
('Grönland','2|territorium'),
('grönlandsval','1|bardval'),
('grönling','1|karpfisk'),
('grönländare','1|Grönland'),
('grönländsk','1|Grönland'),
('grönländsk','2|grönländska'),
('grönländska','1|språk'),
('grönländska','2|grönländare'),
('grönmalt','1|malt'),
('grönmogen','1|grönmognad'),
('grönmognad','1|mognad'),
('grönmålad','1|måla'),
('grönmögel','1|mögel'),
('grönmögelost','1|ost'),
('grönmörk','1|mörk'),
('grönområde','1|område'),
('grönpeppar','1|peppar'),
('grönrätt','1|grönsakstallrik'),
('grönsak','1|växt'),
('grönsaker','1|grönsak'),
('grönsaksblandning','1|blandning'),
('grönsaksfrö','1|frö'),
('grönsaksodling','1|odling'),
('grönsaksröra','1|röra'),
('grönsakssoppa','1|soppa'),
('grönsaksstånd','1|stånd'),
('grönsakstallrik','1|maträtt'),
('grönsallad','1|sallad'),
('grönsiska','1|småfågel'),
('grönska','1|växa'),
('grönska','2|grönska'),
('grönskande','1|grönska'),
('grönskimrande','1|skimra'),
('grönsoppa','1|grönsakssoppa'),
('grönspett','1|hackspett'),
('grönstarr','1|starr'),
('grönstarr','1|starr'),
('grönstarr','2|starr'),
('grönsvart','1|svart'),
('grönvit','1|vit'),
('grönyta','1|grönområde'),
('grönådrig','1|åder'),
('grönådrighet','1|grönådrig'),
('gröpa','1|mala'),
('gröpande','1|gröpa'),
('gröpe','1|foder'),
('gröpning','1|gröpa'),
('gröt','1|mat'),
('gröta','1|grötig'),
('grötande','1|gröta'),
('grötfrukost','1|frukost'),
('grötig','1|oreda'),
('grötighet','1|grötig'),
('grötlunk','1|promenad'),
('grötmyndig','1|dryg'),
('grötmyndighet','1|grötmyndig'),
('grötomslag','1|omslag'),
('grötrim','1|rim'),
('grötrock','1|skyddskläder'),
('GSK','1|sportklubb'),
('GU','1|Göteborgs_universitet'),
('guadalup','1|perm'),
('Guangdong','1|provins'),
('guanin','1|nukleinsyra'),
('guano','1|gödsel'),
('guarani','1|folk'),
('guarani','2|språk'),
('Guatemala','1|land'),
('guatemalan','1|Guatemala'),
('guatemalansk','1|Guatemala'),
('guatemalanska','1|guatemalan'),
('guatemaltek','1|guatemalan'),
('guatemaltekisk','1|guatemalansk'),
('Guayana','1|land'),
('guayanan','1|Guayana'),
('guayansk','1|Guayana'),
('gubbe','1|man'),
('gubbhus','1|ålderdomshem'),
('gubbig','1|gubbe'),
('gubbighet','1|gubbig'),
('gubbjävel','1|gubbe'),
('gubbkalsonger','1|kalsonger'),
('gubbknarrighet','1|knarrighet'),
('gubbs','1|man'),
('gubbsjuk','1|upptänd'),
('gubbsjuka','1|gubbsjuk'),
('gubbsjukhet','1|gubbsjuk'),
('gubbskägg','1|skägg'),
('gubbslem','1|gubbe'),
('gubbstackare','1|gubbe'),
('gubbstrutt','1|gubbe'),
('gubbträsk','1|träsk'),
('gubbvälde','1|makt'),
('gubevars','1|minsann'),
('gubevars','1|minsann'),
('guckusko','1|orkidé'),
('Gud','1|gud'),
('gud','1|väsen'),
('gud','2|herregud'),
('gud','2|herregud'),
('gudabeläte','1|beläte'),
('gudabenådad','1|begåvad'),
('gudabild','1|bild'),
('gudadryck','1|dryck'),
('gudagiven','1|ge'),
('gudagåva','1|gåva'),
('gudaktig','1|gudfruktig'),
('gudaktighet','1|gudaktig'),
('gudalik','1|gud'),
('gudaliknande','1|gud'),
('gudalära','1|gudasaga'),
('gudamakt','1|makt'),
('gudasaga','1|berättelse'),
('gudaskymning','1|ragnarök'),
('gudasänd','1|gåva'),
('gudbarn','1|fadderbarn'),
('guddotter','1|fadderbarn'),
('gudfader','1|fadder'),
('gudfruktig','1|tro'),
('gudfruktighet','1|gudfruktig'),
('gudilov','1|gudskelov'),
('guding','1|ejder'),
('gudinna','1|gud'),
('gudinog','1|nog'),
('gudlig','1|Gud'),
('gudlig','1|Gud'),
('gudlighet','1|gudlig'),
('gudlighet','1|gudlig'),
('gudlös','1|tro'),
('gudlöshet','1|gudlös'),
('gudmoder','1|fadder'),
('gudom','1|Gud'),
('gudomlig','1|underbar'),
('gudomliggöra','1|göra'),
('gudomliggörande','1|gudomliggöra'),
('gudomliggörelse','1|gudomliggöra'),
('gudomliggöring','1|gudomliggöra'),
('gudomlighet','1|gudomlig'),
('gudsbevis','1|bevis'),
('gudsbild','1|bild'),
('gudsdom','1|dom'),
('gudsdyrkan','1|gud'),
('gudsfred','1|fred'),
('gudsfruktan','1|gudfruktig'),
('gudsförgäten','1|bortglömd'),
('gudsförgätenhet','1|gudsförgäten'),
('gudsförnekare','1|gudsförnekelse'),
('gudsförnekelse','1|förneka'),
('gudskelov','1|lyckligtvis'),
('gudslån','1|mat'),
('gudsman','1|präst'),
('gudsnådelig','1|skenhelig'),
('gudsnådelig','1|skenhelig'),
('gudsnådelighet','1|gudsnådelig'),
('gudsnådelighet','1|gudsnådelig'),
('gudson','1|fadderbarn'),
('gudsord','1|bibelcitat'),
('gudstjänst','1|religion'),
('gudstjänstbesökare','1|besökare'),
('gudstjänstdag','1|dag'),
('gudstjänstform','1|form'),
('gudstjänstfrekvens','1|frekvens'),
('gudstjänstlig','1|gudstjänst'),
('gudstjänstlokal','1|lokal'),
('gudstjänstordning','1|gudstjänst'),
('gudstjänstritual','1|ritual'),
('gudstjänsttid','1|tid'),
('gudstro','1|tro'),
('gudstroende','1|gudstro'),
('gudsupplevelse','1|upplevelse'),
('gudunge','1|guding'),
('guida','1|visa'),
('guidande','1|guida'),
('guide','1|guida'),
('guinea','1|guldmynt'),
('Guinea','1|land'),
('guinean','1|Guinea'),
('guineansk','1|Guinea'),
('guineanska','1|guinean'),
('Guinness','1|stout'),
('gujarati','1|språk'),
('gul','1|färg'),
('gula','1|äggula'),
('Gulag','1|fångläger'),
('gulaktig','1|gul'),
('gulaktighet','1|gulaktig'),
('gulasch','1|maträtt'),
('gulasch','2|gulaschbaron'),
('gulaschbaron','1|nyrik'),
('gulblek','1|blek'),
('gulblekhet','1|gulblek'),
('gulblommig','1|blomma'),
('gulblåsa','1|gulsäck'),
('gulbrun','1|brun'),
('guld','1|metall'),
('guld','1|metall'),
('guld','2|grundämne'),
('guld','2|grundämne'),
('guld','3|guldmedalj'),
('guldbagge','1|skalbagge'),
('guldbagge','2|pris'),
('guldbaggegala','1|gala'),
('guldbarr','1|guldtacka'),
('guldberlock','1|berlock'),
('guldbesatt','1|besätta'),
('guldbrokad','1|brokad'),
('guldbrun','1|brun'),
('guldbröllop','1|jubileum'),
('guldbågad','1|glasögonbåge'),
('guldbär','1|physalis'),
('gulddekor','1|dekor'),
('gulddoublé','1|guldliknande'),
('gulddoublé','1|guldliknande'),
('gulddrageri','1|guldtråd'),
('gulddukat','1|dukat'),
('gulden','1|guldmynt'),
('guldfasan','1|fasan'),
('guldfeber','1|feber'),
('guldfestong','1|festong'),
('guldfisk','1|akvariefisk'),
('guldfux','1|fux'),
('guldfynd','1|fynd'),
('guldfärgad','1|färg'),
('guldförande','1|guld'),
('guldföremål','1|föremål'),
('guldgalon','1|galon'),
('guldglans','1|glans'),
('guldglänsande','1|glänsa'),
('guldgruva','1|gruva'),
('guldgruva','2|skattkammare'),
('guldgrävare','1|söka'),
('guldgul','1|gul'),
('guldhalt','1|halt'),
('guldhaltig','1|guldhalt'),
('guldhårig','1|blond'),
('guldhöna','1|kvinna'),
('guldkalv','1|pengar'),
('guldkant','1|kant'),
('guldkant','2|lyxa'),
('guldkantad','1|guldkant'),
('guldkantad','2|lönsam'),
('guldkedja','1|kedja'),
('guldklimp','1|klimp'),
('guldklocka','1|klocka'),
('guldkorn','1|korn'),
('guldkorn','2|värdefull'),
('guldkran','1|vattenkran'),
('guldkrog','1|restaurang'),
('guldkrona','1|tandkrona'),
('guldlegering','1|legering'),
('guldliknande','1|guld'),
('guldlockig','1|blond'),
('guldmakare','1|alkemist'),
('guldmakeri','1|guldmakare'),
('guldmakrill','1|makrill'),
('guldmedalj','1|medalj'),
('guldmedaljör','1|guldmedalj'),
('guldmynt','1|mynt'),
('guldmyntfot','1|valuta'),
('guldpeng','1|peng'),
('guldpeng','1|peng'),
('guldpenna','1|penna'),
('guldplants','1|guldtacka'),
('guldpressning','1|ornament'),
('guldpris','1|pris'),
('guldpris','2|pris'),
('guldprov','1|prov'),
('guldpunkt','1|betala'),
('guldpärla','1|pärla'),
('guldregn','1|utdelning'),
('guldreserv','1|förråd'),
('guldrush','1|guldfeber'),
('guldrush','1|guldfeber'),
('guldsand','1|sand'),
('guldskimrande','1|skimrande'),
('guldslagare','1|guldslageri'),
('guldslageri','1|bladguld'),
('guldsmed','1|smed'),
('guldsmidd','1|guldsmide'),
('guldsmide','1|guldsmed'),
('guldsnitt','1|förgyllning'),
('guldspade','1|pris'),
('guldspadejury','1|jury'),
('guldstandard','1|guldmyntfot'),
('guldstekel','1|gaddstekel'),
('guldstickad','1|sticka'),
('guldstrid','1|strid'),
('guldstämpel','1|intyg'),
('guldtacka','1|stycke'),
('guldtand','1|tandprotes'),
('guldtråd','1|tråd'),
('guldtäckning','1|guldreserv'),
('guldtändare','1|cigarettändare'),
('guldtörst','1|guldfeber'),
('guldvaskning','1|guldgrävare'),
('guldvittring','1|vittring'),
('guldvåg','1|våg'),
('guldålder','1|period'),
('guldäpple','1|äpple'),
('guldörhänge','1|örhänge'),
('gulfilter','1|filter'),
('gulfärga','1|gulfärgad'),
('gulfärgad','1|gul'),
('gulfärgande','1|gulfärga'),
('gulfärgning','1|gulfärga'),
('gulgrå','1|grå'),
('gulgrön','1|grön'),
('guling','1|kines'),
('guling','2|strejkbrytare'),
('gulkropp','1|äggblåsa'),
('gulla','1|gullig'),
('gullande','1|gulla'),
('gullebrand','1|ringfinger'),
('gullegris','1|skämma_bort'),
('gullegris','1|skämma_bort'),
('gulleplutt','1|gullig'),
('gullgosse','1|skämma_bort'),
('gullhöna','1|nyckelpiga'),
('gullhöna','1|nyckelpiga'),
('gullig','1|söt'),
('gullighet','1|gullig'),
('gullpudra','1|växt'),
('gullregn','1|buske'),
('gullregn','1|buske'),
('gullris','1|växt'),
('gulltrav','1|nattljus'),
('gullviva','1|blomma'),
('gulmetall','1|mässing'),
('gulmålad','1|måla'),
('gulmåra','1|måra'),
('gulna','1|gul'),
('gulnad','1|vitna'),
('gulnande','1|gulna'),
('gulning','1|gulna'),
('gulockra','1|ockra'),
('gulorange','1|orange'),
('gulrutig','1|rutig'),
('gulröd','1|röd'),
('gulsiktig','1|gulblek'),
('gulsiktighet','1|gulsiktig'),
('gulsippa','1|sippa'),
('gulskiva','1|gulfilter'),
('gulsot','1|sjukdom'),
('gulsparv','1|sparv'),
('gulsporre','1|växt'),
('gulsvart','1|svart'),
('gulsäck','1|foster'),
('gulsäck','1|foster'),
('gultörne','1|växt'),
('gulvial','1|vial'),
('gulvit','1|vit'),
('gulärla','1|ärla'),
('gumma','1|kvinna'),
('gummera','1|klistra'),
('gummerande','1|gummera'),
('gummerbar','1|gummera'),
('gummerbarhet','1|gummerbar'),
('gummering','1|gummera'),
('gummi','1|ämne'),
('gummi','2|radergummi'),
('gummi','3|kondom'),
('gummiasfalt','1|tartan'),
('gummiband','1|band'),
('gummibeklädd','1|beklä'),
('gummiboll','1|boll'),
('gummibåt','1|båt'),
('gummidäck','1|däck'),
('gummigutta','1|gummiharts'),
('gummihandske','1|handske'),
('gummiharts','1|harts'),
('gummihjul','1|hjul'),
('gummikabel','1|kabel'),
('gummilag','1|lag'),
('gummilist','1|list'),
('gummimaterial','1|gummi'),
('gummiparagraf','1|bestämmelse'),
('gummipigg','1|pigg'),
('gummiplantage','1|plantage'),
('gummiplatta','1|platta'),
('gummipropp','1|propp'),
('gummiräfflad','1|räffla'),
('gummiskydd','1|skydd'),
('gummislang','1|slang'),
('gummislägga','1|slägga'),
('gummisnodd','1|snodd'),
('gummistövel','1|stövel'),
('gummiträd','1|kautschukträd'),
('gummös','1|svulst'),
('gump','1|bak'),
('gumpa','1|skumpa'),
('gumpande','1|gumpa'),
('gumphöna','1|höna'),
('gumpkörtel','1|fettkörtel'),
('gumse','1|bagge'),
('Gunder','1|Hägg'),
('gung','1|gunga'),
('gunga','1|röra'),
('gunga','2|gunga'),
('gunga','3|gunga'),
('gungande','1|gunga'),
('gungande','2|gunga'),
('gungbräda','1|gunga'),
('gungbräda','1|gunga'),
('gungfly','1|myr'),
('gungfly','2|osäker'),
('gunghäst','1|leksak'),
('gungig','1|gunga'),
('gungighet','1|gungig'),
('Gungner','1|spjut'),
('gungning','1|gunga'),
('gungstol','1|stol'),
('gungställning','1|ställning'),
('Gunnebo','1|Göteborg'),
('Gunnilse','1|Göteborg'),
('gunrum','1|officersmäss'),
('gunst','1|uppskattning'),
('gunstbenägen','1|välvillig'),
('gunstbenägenhet','1|gunstbenägen'),
('gunstbevis','1|ynnest'),
('gunstig','1|gunst'),
('gunstighet','1|gunstig'),
('gunstling','1|favorit'),
('gunstlingssystem','1|gunstling'),
('gunås','1|minsann'),
('gupp','1|grop'),
('guppa','1|gupp'),
('guppande','1|guppa'),
('guppig','1|gupp'),
('guppighet','1|guppig'),
('guppning','1|guppa'),
('guppy','1|akvariefisk'),
('gura','1|gitarr'),
('gurami','1|akvariefisk'),
('gurgel','1|gurgla'),
('gurgel','2|smågräl'),
('gurgelvatten','1|vatten'),
('gurgla','1|skölja'),
('gurgla','2|gurgel'),
('gurglande','1|gurgla'),
('gurglande','2|gurgla'),
('gurgling','1|gurgla'),
('gurka','1|grönsak'),
('gurkha','1|folkgrupp'),
('gurklist','1|odling'),
('gurkmeja','1|krydda'),
('gurkmejpapper','1|filtrerpapper'),
('gurkskiva','1|skiva'),
('gurkstav','1|bit'),
('gurkväxt','1|gurka'),
('guru','1|lärare'),
('guska','1|papperstillverkning'),
('guskande','1|guska'),
('guss','1|tjej'),
('guss','1|tjej'),
('gustavadolfsbakelse','1|bakelse'),
('gustavadolfsbakelse','1|bakelse'),
('gustavadolfsbakelse','1|bakelse'),
('gustavian','1|Gustav_III'),
('gustaviansk','1|gustavian'),
('Gustavsberg','1|Stockholm'),
('gut','1|tafs'),
('gut','1|tafs'),
('gute','1|gotlänning'),
('guttaperka','1|gummi'),
('guttural','1|språkljud'),
('guttural','2|guttural'),
('gutår','1|skål'),
('guvernant','1|lärarinna'),
('guvernement','1|län'),
('guvernör','1|landshövding'),
('guvernörsval','1|val'),
('guyanan','1|Guayana'),
('guyanansk','1|Guayana'),
('guyananska','1|guyanan'),
('gyckel','1|gyckla'),
('gyckelbild','1|synvilla'),
('gyckelspel','1|gyckla'),
('gyckla','1|driva'),
('gycklande','1|gyckla'),
('gycklare','1|gyckla'),
('gyckleri','1|gyckla'),
('gydja','1|blot'),
('gylf','1|öppning'),
('gylf','1|öppning'),
('gylfputande','1|puta'),
('gyllen','1|äpple'),
('gyllen','2|blomma'),
('gyllen','3|guldmynt'),
('gyllenbrun','1|brun'),
('gyllenduk','1|tyg'),
('gyllene','1|guld'),
('gyllene','1|guld'),
('gyllenglänsande','1|glänsa'),
('gyllengul','1|gul'),
('gyllenkläde','1|kläde'),
('gyllenlack','1|lackviol'),
('gyllenläder','1|läder'),
('gyllental','1|måncykel'),
('gylling','1|sommargylling'),
('gylta','1|ungsugga'),
('gylta','2|fisk'),
('gym','1|lokal'),
('gym','1|lokal'),
('gymkort','1|rabattkort'),
('gymnasial','1|gymnasium'),
('gymnasieekonom','1|ekonom'),
('gymnasieingenjör','1|ingenjör'),
('gymnasieinspektör','1|inspektör'),
('gymnasielinje','1|linje'),
('gymnasielärare','1|lärare'),
('gymnasieskola','1|gymnasium'),
('gymnasieutbildning','1|utbildning'),
('gymnasieval','1|val'),
('gymnasist','1|gymnasium'),
('gymnasium','1|skola'),
('gymnast','1|gymnastik'),
('gymnastik','1|rörelse'),
('gymnastikdirektör','1|lärare'),
('gymnastikdräkt','1|dräkt'),
('gymnastikhopp','1|hopp'),
('gymnastikhus','1|hus'),
('gymnastiklektion','1|lektion'),
('gymnastikredskap','1|redskap'),
('gymnastiksal','1|sal'),
('gymnastiksko','1|sko'),
('gymnastiktimme','1|gymnastiklektion'),
('gymnastisera','1|gymnastik'),
('gymnastiserad','1|vältränad'),
('gymnastiserande','1|gymnastisera'),
('gymnastiserbar','1|gymnastisera'),
('gymnastiserbarhet','1|gymnastiserbar'),
('gymnastisering','1|gymnastisera'),
('gymnastisk','1|gymnastik'),
('gymnastisk','2|spänstig'),
('gymnisk','1|gymnastisk'),
('gymnosperm','1|nakenfröig'),
('gympa','1|gymnastik'),
('gympa','1|gymnastik'),
('gympa','2|gympa'),
('gympa','2|gympa'),
('gympakläder','1|kläder'),
('gympande','1|gympa'),
('gympande','1|gympa'),
('gympapåse','1|påse'),
('gympasko','1|gymnastiksko'),
('gymping','1|gympa'),
('gymping','1|gympa'),
('gynekolog','1|läkare'),
('gynekologi','1|gynekologisk'),
('gynekologisk','1|medicin'),
('gynna','1|hjälpa'),
('gynnande','1|gynna'),
('gynnare','1|gynna'),
('gynnare','2|rackare'),
('gynnsam','1|fördel'),
('gynnsamhet','1|gynnsam'),
('gyro','1|gyroskop'),
('gyrohorisont','1|gyroprincipen'),
('gyrokompass','1|kompass'),
('gyroprincipen','1|snurra'),
('gyroskop','1|apparat'),
('gyroskopkompass','1|gyrokompass'),
('gyrostabilisator','1|gyroskop'),
('gytter','1|mången'),
('gyttja','1|lera'),
('gyttjebad','1|bad'),
('gyttjig','1|gyttja'),
('gyttjighet','1|gyttjig'),
('gyttra','1|gytter'),
('gyttrande','1|gyttra'),
('gyttrig','1|gytter'),
('gyttrighet','1|gyttrig'),
('gyttring','1|gytter'),
('gå','10|kosta'),
('gå','11|ledtråd'),
('gå','1|röra_sig'),
('gå','2|nå'),
('gå','3|förlopp'),
('gå','4|fungera'),
('gå','5|möjlig'),
('gå','6|uppföra'),
('gå','7|orgasm'),
('gå','8|bort'),
('gå','9|godkänna'),
('gåbock','1|stödja'),
('gåbock','1|stödja'),
('gåbortskostym','1|kostym'),
('gående','1|gå'),
('gågata','1|gata'),
('gågata','1|gata'),
('gågosse','1|springpojke'),
('gång','1|när'),
('gång','2|gå'),
('gång','3|gå'),
('gång','4|fungera'),
('gånga','1|gå'),
('gångande','1|gånga'),
('gångare','1|gå'),
('gångart','1|sätt'),
('gångavstånd','1|avstånd'),
('gångbana','1|bana'),
('gångbar','1|giltig'),
('gångbarhet','1|gångbar'),
('gångbergart','1|bergart'),
('gångbord','1|däck'),
('gångbro','1|bro'),
('gångfot','1|fot'),
('gånggrift','1|grav'),
('gånghjälpmedel','1|hjälpmedel'),
('gånghjälpmedel','1|hjälpmedel'),
('gångjärn','1|fästa'),
('gångjärnsförsedd','1|gångjärn'),
('gångjärnshake','1|hake'),
('gångjärnsled','1|led'),
('gångkläder','1|kläder'),
('gångled','1|gångjärn'),
('gånglåt','1|låt'),
('gångra','1|multiplicera'),
('gångrande','1|gångra'),
('gångspel','1|vindspel'),
('gångsport','1|sport'),
('gångstig','1|stig'),
('gångstol','1|gåstol'),
('gångtrafikant','1|fotgängare'),
('gångtunnel','1|vägtunnel'),
('gångtävling','1|gångsport'),
('gångväg','1|väg'),
('gåpåare','1|enträgen'),
('gåpåig','1|gåpåare'),
('gåpåighet','1|gåpåig'),
('gård','1|hus'),
('gård','2|område'),
('gårdag','1|i_går'),
('gårdagskväll','1|kväll'),
('gårdfarihandel','1|sälja'),
('gårdfarihandlande','1|gårdfarihandel'),
('gårdfarihandlare','1|gårdfarihandel'),
('gårding','1|tåg'),
('gårdsfolk','1|gård'),
('gårdsförsäljning','1|försäljning'),
('gårdshus','1|hus'),
('gårdskarl','1|sköta'),
('gårdskulle','1|kulle'),
('gårdslykta','1|lykta'),
('gårdsmusikant','1|musikant'),
('gårdsområde','1|område'),
('gårdsplan','1|plan'),
('gårdsplats','1|gård'),
('gårdsrum','1|gård'),
('gårdsstädning','1|städning'),
('gårdstomt','1|tomt'),
('gårdsträd','1|träd'),
('gårdvar','1|vakthund'),
('gås','1|fågel'),
('gåsbröst','1|maträtt'),
('gåse','1|gåskarl'),
('gåsfjäder','1|fjäder'),
('gåsfot','1|harv'),
('gåshud','1|rysa'),
('gåskarl','1|gås'),
('gåslever','1|maträtt'),
('gåsmarsch','1|marschera'),
('gåspenna','1|penna'),
('gåstav','1|stav'),
('gåstol','1|stödja'),
('gåsunge','1|gässling'),
('gåsägg','1|ägg'),
('gåsögon','1|vävnad'),
('gåsögon','2|citationstecken'),
('gåsört','1|ört'),
('gåt','1|dörrkarm'),
('gåta','1|gissa'),
('gåtfull','1|gåta'),
('gåtfullhet','1|gåtfull'),
('gåva','1|ge'),
('gåva','2|begåvad'),
('gåvoavtal','1|avtal'),
('gåvobrev','1|handling'),
('gåvodiplomati','1|diplomati'),
('gåvohandling','1|gåvobrev'),
('gåvoskatt','1|skatt'),
('gäcka','1|undgå'),
('gäckande','1|gäcka'),
('gäckas','1|retas'),
('gäckeri','1|gäckas'),
('gäckmast','1|mesanmast'),
('gäcksam','1|gäckas'),
('gäcksamhet','1|gäcksam'),
('gädda','1|fisk'),
('gäddhäng','1|missprydande'),
('gäddnate','1|nate'),
('gäddsax','1|fälla'),
('gäl','1|fisk'),
('gäla','1|rensa'),
('gälande','1|gäla'),
('gälblad','1|gäl'),
('gälbåge','1|gäl'),
('gäld','1|skuld'),
('gälda','1|gengälda'),
('gäldande','1|gälda'),
('gäldbunden','1|skuldsatt'),
('gäldenär','1|skyldig'),
('gäldfri','1|gäld'),
('gäldstuga','1|fängelse'),
('gäll','1|ljud'),
('gälla','1|angå'),
('gälla','2|aktuell'),
('gälla','3|kastrera'),
('gälla','4|värd'),
('gällande','1|gälla'),
('gällande','2|gälla'),
('gällande','3|gälla'),
('gällande','4|gälla'),
('gällande','5|gälla'),
('gällen','1|halvsur'),
('gällen','1|halvsur'),
('gällenhet','1|gällen'),
('gällenhet','1|gällen'),
('gällhet','1|gäll'),
('Gällivare','1|ort'),
('Gällivare','1|ort'),
('gällivarehäng','1|byxbak'),
('gälspringa','1|springa'),
('gäng','1|grupp'),
('gänga','1|skruv'),
('gänga','2|gänga'),
('gänga','3|samlag'),
('gängad','1|gänga'),
('gängande','1|gänga'),
('gängande','2|gänga'),
('gängback','1|gänga'),
('gänge','1|gille'),
('gänginsats','1|insats'),
('gängkloppa','1|gänga'),
('gängkrig','1|krig'),
('gängledare','1|ledare'),
('gänglig','1|smal'),
('gänglighet','1|gänglig'),
('gängmedlem','1|medlem'),
('gängning','1|gänga'),
('gängse','1|allmän'),
('gängstål','1|verktyg'),
('gängtapp','1|tapp'),
('gängtappshållare','1|hållare'),
('gängtatuering','1|tatuering'),
('gängtolk','1|måttverktyg'),
('gängverktyg','1|verktyg'),
('gängverktygssats','1|sats'),
('gärd','1|handling'),
('gärd','2|skatt'),
('gärda','1|inhägna'),
('gärdande','1|gärda'),
('gärde','1|åker'),
('gärde','2|stängsel'),
('gärdning','1|gärdsgård'),
('gärdsel','1|material'),
('gärdsel','1|material'),
('gärdsgård','1|stängsel'),
('gärdsgård','1|stängsel'),
('gärdsgårdsstör','1|stör'),
('gärdsla','1|gärda'),
('gärdslande','1|gärdsla'),
('gärdsmyg','1|småfågel'),
('gärna','1|vilja'),
('gärning','1|göra'),
('gärningslära','1|lära'),
('gärningsman','1|gärning'),
('gärningsmannaprofil','1|profil'),
('gärningsmannaprofilgrupp','1|expertgrupp'),
('gärningsort','1|brottsplats'),
('gärningsperson','1|gärningsman'),
('gärs','1|snorgärs'),
('gärs','1|snorgärs'),
('gäsp','1|gäspning'),
('gäspa','1|gapa'),
('gäspande','1|gäspa'),
('gäspig','1|gäspa'),
('gäspighet','1|gäspig'),
('gäspning','1|gäspa'),
('gässling','1|gås'),
('gäst','1|besöka'),
('gästa','1|gäst'),
('gästabud','1|fest'),
('gästande','1|gästa'),
('gästarbetare','1|arbetare'),
('gästatom','1|klatrat'),
('gästblogga','1|blogga'),
('gästbloggande','1|gästblogga'),
('gästbloggare','1|bloggare'),
('gästbloggning','1|gästblogga'),
('gästbok','1|bok'),
('gästflagga','1|flagga'),
('gästforskare','1|forskare'),
('gästfri','1|generös'),
('gästfrihet','1|gästfri'),
('gästfrihetsstrategi','1|strategi'),
('gästgivare','1|gästgiveri'),
('gästgivargård','1|gästgiveri'),
('gästgiveri','1|värdshus'),
('gästhandduk','1|handduk'),
('gästkrönika','1|krönika'),
('gästlista','1|lista'),
('gästmolekyl','1|klatrat'),
('gästnatt','1|övernattning'),
('gästning','1|skyldighet'),
('gästrike','1|Gästrikland'),
('gästriking','1|gästrike'),
('Gästrikland','1|landskap'),
('gästrikländsk','1|Gästrikland'),
('gästrikländska','1|gästrike'),
('gästriklänning','1|gästrike'),
('gästrikska','1|dialekt'),
('gästring','1|gästrike'),
('gästrisk','1|Gästrikland'),
('gästroll','1|gästspel'),
('gästrum','1|rum'),
('gästrumsdörr','1|dörr'),
('gästspel','1|besöka'),
('gästspela','1|gästspel'),
('gästspelande','1|gästspela'),
('gästvänlig','1|gästfri'),
('gästvänlighet','1|gästvänlig'),
('gästvänskap','1|gästfrihet'),
('Gävle','1|stad'),
('Gävle','1|stad'),
('gävlebo','1|Gävle'),
('gävlebo','1|Gävle'),
('Gävlebocken','1|julbock'),
('Gävleborg','1|län'),
('göda','1|bördig'),
('gödande','1|göda'),
('gödboskap','1|boskap'),
('gödd','1|göda'),
('göddjur','1|slaktdjur'),
('gödkyckling','1|kyckling'),
('gödning','1|gödsel'),
('gödningsmedel','1|medel'),
('gödsel','1|göda'),
('gödselmedel','1|gödsel'),
('gödselränna','1|ränna'),
('gödselspridare','1|sprida'),
('gödselstack','1|hög'),
('gödselstad','1|hög'),
('gödselvatten','1|vätska'),
('gödsla','1|gödsel'),
('gödslande','1|gödsla'),
('gödsling','1|gödsla'),
('göjemånad','1|februari'),
('gök','1|fågel'),
('gök','2|kaffegök'),
('gök','3|typ'),
('göka','1|pippa'),
('gökande','1|göka'),
('gökblomma','1|gökblomster'),
('gökblomster','1|blomma'),
('gökklocka','1|gökur'),
('gökmat','1|gökärt'),
('gökmat','2|harsyra'),
('göknycklar','1|orkidé'),
('gökotta','1|picknick'),
('göktyta','1|fågel'),
('gökunge','1|fosterbarn'),
('gökur','1|väggklocka'),
('gökärt','1|växt'),
('göl','1|vattensamling'),
('göling','1|tåg'),
('gömfröig','1|växt'),
('gömma','1|bort'),
('gömma','2|gömma'),
('gömma','2|gömma'),
('gömmande','1|gömma'),
('gömme','1|frögömme'),
('gömme','2|kurragömma'),
('gömsle','1|gömställe'),
('gömställe','1|gömma'),
('göpen','1|handfull'),
('göra','1|PRIM'),
('göra','2|åstadkomma'),
('göra','3|tillverka'),
('göra','4|göra'),
('görande','1|göra'),
('görande','2|göra'),
('görande','3|göra'),
('görare','1|göra'),
('görbar','1|görlig'),
('görbarhet','1|görbar'),
('gördel','1|bälte'),
('gördelbåge','1|båge'),
('gördeldäck','1|däck'),
('gördelfästning','1|fästning'),
('gördelmakare','1|gördel'),
('gördla','1|gördel'),
('gördlande','1|gördla'),
('görlig','1|göra'),
('görlighet','1|görlig'),
('göromål','1|göra'),
('gös','1|fisk'),
('gös','2|tackjärn'),
('gös','3|flagga'),
('gösstake','1|flaggstång'),
('göt','1|folk'),
('göt','2|gjuta'),
('göt','2|gjuta'),
('göt','3|göticism'),
('Götaland','1|Sverige'),
('götamål','1|dialekt'),
('Götaplatsen','1|torg'),
('Götaverken','1|skeppsvarv'),
('Göteborg','1|stad'),
('Göteborg','1|stad'),
('göteborgare','1|Göteborg'),
('göteborgsbaserad','1|basera'),
('göteborgsk','1|Göteborg'),
('göteborgska','1|dialekt'),
('göteborgska','2|göteborgare'),
('Göteborgsmålare','1|målare'),
('göteborgsområdet','1|område'),
('göteborgsregionen','1|region'),
('göteborgsvits','1|ordvits'),
('Götene','1|ort'),
('göticism','1|romantik'),
('göticistisk','1|götisk'),
('götisk','1|göt'),
('götisk','2|göticism'),
('götmetall','1|järn'),
('gött','1|bra'),
('gött','1|bra'),
('gött','2|rumpa'),
('götter','1|gotter'),
('götterdämmerung','1|gudaskymning'),
('götvalsverk','1|valsverk'),
('h','1|bokstav'),
('h','2|ton'),
('H2O','1|vatten'),
('ha','1|PRIM'),
('ha','2|skratt'),
('ha','3|brås'),
('Haag','1|stad'),
('habegär','1|begär'),
('habil','1|skicklig'),
('habilitering','1|anpassning'),
('habilitet','1|habil'),
('habit','1|klädsel'),
('habitué','1|besökare'),
('habituell','1|vanemässig'),
('habituell','1|vanemässig'),
('habitus','1|utseende'),
('habsburgsk','1|Habsburg'),
('hack','1|skåra'),
('hack','2|hacka'),
('hack','3|hacka'),
('hack','4|hacka'),
('hacka','1|sönderdela'),
('hacka','2|hacka'),
('hacka','3|tala'),
('hacka','4|kritisera'),
('hacka','5|hacker'),
('hacka','6|pengar'),
('hacka','6|pengar'),
('hackande','1|hacka'),
('hackande','2|hacka'),
('hackande','3|hacka'),
('hackande','4|hacka'),
('hackare','1|hacker'),
('hackbräde','1|stränginstrument'),
('hackbräde','2|bräde'),
('hackbräde','3|rorkult'),
('hackelse','1|foder'),
('hacker','1|datorintrång'),
('hackhosta','1|hosta'),
('hackig','1|hack'),
('hackig','2|hacka'),
('hackighet','1|hackig'),
('hackkniv','1|kniv'),
('hackkorv','1|korv'),
('hackkyckling','1|hacka'),
('hackmat','1|oreda'),
('hackning','1|hacka'),
('hackning'